/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.license.client.cis.util.LicensingMethodFault;
import com.vmware.vim.binding.cis.license.fault.NotFoundFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.HashMap;
import java.util.Map;

public final class LicensingAssetPropertyProvider {
    private final QueryService _queryService;
    public static final String PROPERTY = "asset";
    public static final String TARGET_TYPE = "Asset";
    public static final String RELATION = "assets";
    public static final String RESPONSE_PROPERTY_ASSET = "asset";
    public static final String RESPONSE_PROPERTY_ERROR = "notFound";
    public static final String RESPONSE_PROPERTY_OBJECT_TYPE = "managedObjectRef";

    public LicensingAssetPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="HostSystem/asset")
    public Map<String, Object> getHostSystemAssetProperty(ManagedObjectReference assetRef) {
        return this.getAsset(assetRef);
    }

    @PropertyProvider(value="ClusterComputeResource/asset")
    public Map<String, Object> getClusterComputeResourceAssetProperty(ManagedObjectReference assetRef) {
        return this.getAsset(assetRef);
    }

    @PropertyProvider(value="Folder/asset")
    public Map<String, Object> getFolderAssetProperty(ManagedObjectReference assetRef) {
        return this.getAsset(assetRef);
    }

    private Map<String, Object> getAsset(ManagedObjectReference assetRef) {
        if (assetRef == null) {
            return null;
        }
        ResultSet resultSet = null;
        try {
            resultSet = this._queryService.select(new String[]{"asset"}).from(new String[]{TARGET_TYPE}).where(RELATION, PropertyPredicate.ComparisonOperator.EQUAL, (Object)assetRef).fetch();
        }
        catch (Exception e) {
            Throwable innerCause;
            Throwable cause = e.getCause();
            if (cause instanceof LicensingMethodFault && (innerCause = ((LicensingMethodFault)cause).getMostInnerCause()) instanceof NotFoundFault) {
                return this.transformResultSet(null, assetRef);
            }
            throw e;
        }
        return this.transformResultSet(resultSet, assetRef);
    }

    private Map<String, Object> transformResultSet(ResultSet resultSet, ManagedObjectReference assetRef) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (resultSet == null) {
            resultMap.put("asset", null);
            resultMap.put(RESPONSE_PROPERTY_ERROR, true);
            resultMap.put(RESPONSE_PROPERTY_OBJECT_TYPE, assetRef);
            return resultMap;
        }
        if (resultSet.getItems().size() > 0) {
            ResourceItem resourceItem = (ResourceItem)resultSet.getItems().get(0);
            resultMap.put("asset", resourceItem.get("asset"));
            resultMap.put(RESPONSE_PROPERTY_ERROR, false);
            resultMap.put(RESPONSE_PROPERTY_OBJECT_TYPE, assetRef);
        }
        return resultMap;
    }
}

