/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.notifications;

import com.vmware.license.client.cis.management.ds.License;

class LicensingNotificationUtil {
    static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final long MAX_WARNING_DAYS_REMAINING = 90L;

    LicensingNotificationUtil() {
    }

    static boolean isLicenseExpiring(License license) {
        if (license != null && license.getExpirationTime() != null) {
            return LicensingNotificationUtil.calculateLicensingRemainingDays(license.getExpirationTime()) <= 90L;
        }
        return false;
    }

    static long calculateLicensingRemainingDays(long expirationTime) {
        if (expirationTime <= 0L) {
            return -1L;
        }
        long remainingDays = Math.round((double)expirationTime / 8.64E7);
        return remainingDays == 0L ? 1L : remainingDays;
    }
}

