/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile;

import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.PriorityQueue;

public class BoundedPriorityQueue<T> {
    private static final String ERROR_NULL_QUEUE_COMPARATOR = "error.nullQueueComparator";
    private static final String ERROR_NEGATIVE_QUEUE_BOUND = "error.negativeQueueBound";
    private int _bound;
    private PriorityQueue<T> _queue;

    public BoundedPriorityQueue(int bound, Comparator<T> comparator) {
        if (bound < 0) {
            String error = HostProfileUtils.getLocalizedString(ERROR_NEGATIVE_QUEUE_BOUND);
            throw new IllegalArgumentException(error);
        }
        if (comparator == null) {
            String error = HostProfileUtils.getLocalizedString(ERROR_NULL_QUEUE_COMPARATOR);
            throw new IllegalArgumentException(error);
        }
        this._bound = bound;
        this._queue = new PriorityQueue<T>(bound, comparator);
    }

    public T offer(T element) {
        if (this._queue.offer(element) && this._queue.size() > this._bound) {
            return (T)this._queue.remove();
        }
        return null;
    }

    public T[] pollAll(T[] result) {
        if (result == null) {
            this._queue.clear();
            return null;
        }
        if (result.length < this._queue.size()) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), this._queue.size());
        }
        for (int idx = this._queue.size() - 1; idx >= 0; --idx) {
            result[idx] = this._queue.remove();
        }
        return result;
    }
}

