/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.ProfileCategoryMetadata;
import com.vmware.vim.binding.vim.profile.ProfileComponentMetadata;
import com.vmware.vim.binding.vim.profile.ProfileMetadata;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.impl.ProcessUtil;
import com.vmware.vsphere.client.hostprofile.impl.ProfileProcessor;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilePathUtil {
    private static final Log _logger = LogFactory.getLog(ProfilePathUtil.class);
    private static final String HUMAN_READABLE_PATH_DELIMETER = " > ";
    private static final String INTERNAL_PATH_DELIMETER = ".";

    public static ProfileWrapper buildProfileWrapper(ManagedObjectReference profileRef, ProfileMetadata[] profileMeta, PolicyMetadata[] policyMeta, ProfileCategoryMetadata[] categoryMeta, ProfileComponentMetadata[] componentMeta) throws Exception {
        HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profileRef);
        return ProfilePathUtil.buildProfileWrapper(profile, profileMeta, policyMeta, categoryMeta, componentMeta);
    }

    public static ProfileWrapper buildProfileWrapper(HostProfile profile, ProfileMetadata[] profileMeta, PolicyMetadata[] policyMeta, ProfileCategoryMetadata[] categoryMeta, ProfileComponentMetadata[] componentMeta) throws Exception {
        HostProfile.ConfigInfo configInfo = (HostProfile.ConfigInfo)profile.getConfig();
        HostApplyProfile hostApplyProfile = configInfo.applyProfile;
        return ProfilePathUtil.buildProfileWrapper(hostApplyProfile, profileMeta, policyMeta, categoryMeta, componentMeta);
    }

    public static ProfileWrapper buildProfileWrapper(HostApplyProfile hostApplyProfile, ProfileMetadata[] profileMeta, PolicyMetadata[] policyMeta, ProfileCategoryMetadata[] categoryMeta, ProfileComponentMetadata[] componentMeta) throws Exception {
        ProfileProcessor processor = ProfileProcessor.newInstance(profileMeta, policyMeta);
        ProfileWrapper profileWrapper = processor.process((ApplyProfile)hostApplyProfile);
        profileWrapper = ProcessUtil.addCategoriesAndComponents(profileWrapper, categoryMeta, componentMeta);
        return profileWrapper;
    }

    public static void extractProfileParamsPaths(ProfileWrapper root, Map<String, String> paramPath) {
        if (root != null && paramPath != null) {
            ProfilePathUtil.extractDeferredParamsPathsRecursively(root, paramPath, "", "");
        }
    }

    private static void extractDeferredParamsPathsRecursively(ProfileWrapper wrapper, Map<String, String> map, String internalPath, String humanReadablePath) {
        assert (wrapper != null);
        assert (map != null);
        if (!ProfileWrapper.isCategory(wrapper) && !ProfileWrapper.isComponent(wrapper)) {
            internalPath = internalPath + wrapper.profilePath;
        }
        humanReadablePath = ProfilePathUtil.appendToHumanReadablePath(wrapper, humanReadablePath);
        ProfilePathUtil.addTrimmedPathsToMap(wrapper, map, internalPath, humanReadablePath);
        if (wrapper.children == null) {
            return;
        }
        for (ProfileWrapper profileWrapper : wrapper.children) {
            ProfilePathUtil.extractDeferredParamsPathsRecursively(profileWrapper, map, internalPath, humanReadablePath);
        }
    }

    private static String appendToHumanReadablePath(ProfileWrapper wrapper, String path) {
        assert (wrapper != null);
        if (wrapper.obj instanceof HostApplyProfile) {
            return path;
        }
        path = path + HUMAN_READABLE_PATH_DELIMETER + wrapper.label;
        return path;
    }

    private static void addTrimmedPathsToMap(ProfileWrapper wrapper, Map<String, String> map, String internalPath, String humanReadablePath) {
        assert (wrapper != null);
        assert (map != null);
        if (StringUtil.isNullOrEmpty((String)internalPath) || StringUtil.isNullOrEmpty((String)humanReadablePath)) {
            return;
        }
        if (!(wrapper.obj instanceof ApplyProfile)) {
            return;
        }
        internalPath = ProfilePathUtil.trimPathStartDelimeter(internalPath, INTERNAL_PATH_DELIMETER);
        humanReadablePath = ProfilePathUtil.trimPathStartDelimeter(humanReadablePath, HUMAN_READABLE_PATH_DELIMETER);
        _logger.debug((Object)String.format("Adding path %s (%s)", humanReadablePath, internalPath));
        map.put(internalPath, humanReadablePath);
    }

    private static String trimPathStartDelimeter(String path, String delimeter) {
        assert (!StringUtil.isNullOrEmpty((String)path));
        if (StringUtil.isNullOrEmpty((String)delimeter)) {
            return path;
        }
        String result = path;
        if (result.startsWith(delimeter)) {
            result = result.substring(delimeter.length(), path.length());
        }
        return result;
    }
}

