/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.h5.impl;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.fault.HostConfigFailed;
import com.vmware.vim.binding.vim.fault.InvalidProfileReferenceHost;
import com.vmware.vim.binding.vim.profile.ComplianceManager;
import com.vmware.vim.binding.vim.profile.Profile;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.hostprofile.HostProfileCompressUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.cluster.h5.ClusterHostProfileComplianceCheckSpec;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import com.vmware.vsphere.client.hostprofile.data.ExecuteResultWrapper;
import com.vmware.vsphere.client.hostprofile.data.HostApplyConfigSpecData;
import com.vmware.vsphere.client.hostprofile.data.HostRequirements;
import com.vmware.vsphere.client.hostprofile.data.ImportProfileSpec;
import com.vmware.vsphere.client.hostprofile.data.RemediationSpec;
import com.vmware.vsphere.client.hostprofile.data.RemediationTaskListData;
import com.vmware.vsphere.client.hostprofile.data.h5.ClearValidationResultSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.DuplicateHostProfileSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.HostProfileCheckComplianceSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.ValidateHostCustomizationsSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.model.HostProfileCheckComplianceData;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.H5PrecheckRemediation60Spec;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.H5Remediation60Spec;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.H5RemediationSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.HostPrecheck60AvailabilityData;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.HostPrecheckResultData;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.HostRemediateResult;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.PreRemediationSpec;
import com.vmware.vsphere.client.hostprofile.data.h5.remediate.Remediation60TaskResultItem;
import com.vmware.vsphere.client.hostprofile.impl.GenerateRemediationTasksAdapter;
import com.vmware.vsphere.client.hostprofile.impl.HostProfileMutationProvider;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostApplyConfigService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class H5HostProfileMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(HostProfileMutationProvider.class);
    private static final String REMEDIATION_TASKS_PROPERTY = "hostProfileRemediationTasks";
    private final HostApplyConfigService _hostApplyConfigService;
    private final QueryBindingService _queryBindingService;
    private final MutationService _mutationService;
    private final GenerateRemediationTasksAdapter _generateRemediationTasksAdapter;
    private final TaskMonitor _taskMonitor;

    public H5HostProfileMutationProvider(HostApplyConfigService hostApplyConfigService, QueryBindingService queryBindingService, MutationService mutationService, GenerateRemediationTasksAdapter generateRemediationTasksAdapter, TaskMonitor taskMonitor) {
        this._hostApplyConfigService = hostApplyConfigService;
        this._queryBindingService = queryBindingService;
        this._mutationService = mutationService;
        this._generateRemediationTasksAdapter = generateRemediationTasksAdapter;
        this._taskMonitor = taskMonitor;
    }

    public OperationResult apply(ManagedObjectReference hostProfileRef, HostProfileCheckComplianceSpec spec) {
        assert (hostProfileRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = hostProfileRef;
        try {
            if (hostProfileRef == null || spec == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("profile.error.invalidArguments"));
            }
            HostProfile hostProfile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostProfileRef);
            ComplianceManager manager = HostProfileUtils.getComplianceManager(hostProfileRef.getServerGuid());
            ManagedObjectReference[] associatedEntities = hostProfile.getEntity();
            List<ManagedObjectReference> associatedClusters = this.getAssociatedClusters(associatedEntities);
            List<ManagedObjectReference> associatedStandaloneHosts = this.getAssociatedStandaloneHosts(associatedEntities);
            ArrayList<ManagedObjectReference> allEntities = new ArrayList<ManagedObjectReference>();
            allEntities.addAll(associatedClusters);
            allEntities.addAll(associatedStandaloneHosts);
            result.task = manager.checkCompliance(new ManagedObjectReference[]{hostProfileRef}, allEntities.toArray(new ManagedObjectReference[0]));
        }
        catch (Exception e) {
            _logger.error((Object)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference clusterRef, ClusterHostProfileComplianceCheckSpec spec) {
        assert (clusterRef != null);
        assert (spec != null);
        OperationResult result = new OperationResult();
        result.entity = clusterRef;
        try {
            if (clusterRef == null || spec == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("profile.error.invalidArguments"));
            }
            ServiceInstanceContent serviceContent = Util.getServiceInstanceContent(clusterRef);
            ManagedObjectReference hostProfileRef = spec.hostProfile;
            if (hostProfileRef == null) {
                hostProfileRef = Util.findAssociatedHostProfile(serviceContent, clusterRef);
            }
            if (hostProfileRef == null) {
                return result;
            }
            ComplianceManager manager = HostProfileUtils.getComplianceManager(clusterRef.getServerGuid());
            result.task = manager.checkCompliance(new ManagedObjectReference[]{hostProfileRef}, new ManagedObjectReference[]{clusterRef});
        }
        catch (Exception e) {
            _logger.error((Object)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference vcRef, ImportProfileSpec zippedSpec) {
        OperationResult result = new OperationResult();
        HostProfile.SerializedHostProfileSpec spec = new HostProfile.SerializedHostProfileSpec();
        try {
            String hostProfileConfig = HostProfileCompressUtil.unzip(zippedSpec.compressedProfileConfig);
            spec.setProfileConfigString(hostProfileConfig);
            spec.setName(zippedSpec.name);
            spec.setAnnotation(zippedSpec.annotation);
            spec.setEnabled(Boolean.valueOf(zippedSpec.enabled));
            ProfileManager profileManager = HostProfileUtils.getProfileManager(vcRef.getServerGuid());
            spec.validating = true;
            ManagedObjectReference newProfile = null;
            try {
                newProfile = profileManager.createProfile((Profile.CreateSpec)spec);
            }
            catch (InvalidProfileReferenceHost noRefHostError) {
                spec.validating = false;
                newProfile = profileManager.createProfile((Profile.CreateSpec)spec);
            }
            result.result = newProfile;
        }
        catch (Exception e) {
            _logger.error((Object)"Import profile failed", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference hpRef, ClearValidationResultSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hpRef;
        try {
            if (hpRef == null || spec == null) {
                throw new IllegalArgumentException(Util.getLocalizedString("profile.error.invalidArguments"));
            }
            HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hpRef);
            profile.ResetValidationState();
        }
        catch (Exception e) {
            _logger.warn((Object)"The HostProfile clear validation result failed ", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference entityRef, H5RemediationSpec h5RemediationSpec) {
        ManagedObjectReference[] hosts = h5RemediationSpec.hostRefs;
        OperationResult operationResult = new OperationResult();
        HostApplyConfigSpecData hostApplyConfigSpecData = this._hostApplyConfigService.readHostApplyConfigData(hosts, null);
        if (hostApplyConfigSpecData != null) {
            ProfileManager.ApplyHostConfigSpec[] applyHostConfigSpecs = this.getAllHostsApplyConfigSpecs(hostApplyConfigSpecData, h5RemediationSpec.rebootHosts);
            if (applyHostConfigSpecs.length > 0) {
                try {
                    ProfileManager profileManager = HostProfileUtils.getProfileManager(entityRef.getServerGuid());
                    operationResult.task = profileManager.applyEntitiesConfiguration(applyHostConfigSpecs);
                }
                catch (Exception e) {
                    _logger.error((Object)"Remediation operation failed.", (Throwable)e);
                    operationResult.error = MixedUtil.getMethodFault((Throwable)e);
                }
            } else {
                String errorMessage = HostProfileUtils.getLocalizedString("error.invokeRemediationFailed");
                RuntimeException noHostsAreAvailableException = new RuntimeException(errorMessage);
                _logger.error((Object)"Remediation operation failed", (Throwable)noHostsAreAvailableException);
                operationResult.error = noHostsAreAvailableException;
            }
        } else {
            for (Exception currentError : hostApplyConfigSpecData.faults) {
                _logger.error((Object)"Precheck operation failed.", (Throwable)currentError);
                operationResult.error = MixedUtil.getMethodFault((Throwable)currentError);
            }
        }
        return operationResult;
    }

    public ValidationResult validate(ManagedObjectReference entity, PreRemediationSpec spec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = entity;
        Collection precheckData = this._queryBindingService.prepare(HostPrecheckResultData.class).fetch(Arrays.asList(spec.hosts));
        HostApplyConfigSpecData applyConfigSpecs = this._hostApplyConfigService.readHostApplyConfigData(spec.hosts, null);
        Map<ManagedObjectReference, ProfileManager.ApplyHostConfigSpec> hostApplyConfigMap = applyConfigSpecs.hostApplyConfigMap;
        for (HostPrecheckResultData precheckResult : precheckData) {
            ProfileManager.ApplyHostConfigSpec hostApplyConfigSpec;
            precheckResult.precheckRemediationResult = hostApplyConfigSpec = hostApplyConfigMap.get(precheckResult.provider);
        }
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = entity;
        if (applyConfigSpecs.faults.size() > 0) {
            validationResult.error = new CompositeException(applyConfigSpecs.faults);
        }
        validationResult.result = precheckData;
        return validationResult;
    }

    private ProfileManager.ApplyHostConfigSpec[] getAllHostsApplyConfigSpecs(HostApplyConfigSpecData hostApplyConfigSpecData, boolean rebootHosts) {
        ArrayList<ProfileManager.ApplyHostConfigSpec> configSpecs = new ArrayList<ProfileManager.ApplyHostConfigSpec>();
        Map<ManagedObjectReference, ProfileManager.ApplyHostConfigSpec> hostApplyConfigMap = hostApplyConfigSpecData.hostApplyConfigMap;
        if (hostApplyConfigMap != null) {
            for (ManagedObjectReference currentHost : hostApplyConfigMap.keySet()) {
                ProfileManager.ApplyHostConfigSpec currentApplyHostConfigSpec = hostApplyConfigMap.get(currentHost);
                if (currentApplyHostConfigSpec.faultData != null) continue;
                currentApplyHostConfigSpec.rebootHost = rebootHosts;
                configSpecs.add(currentApplyHostConfigSpec);
            }
        }
        return configSpecs.toArray(new ProfileManager.ApplyHostConfigSpec[0]);
    }

    public OperationResult add(DuplicateHostProfileSpec cloneSpec) {
        if (cloneSpec.profileRef == null) {
            _logger.warn((Object)"The reference profile is undefined");
            throw new RuntimeException(HostProfileUtils.getLocalizedString("error.noReferenceProfile"));
        }
        OperationResult result = new OperationResult();
        try {
            HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cloneSpec.profileRef);
            HostProfile.ConfigInfo oldConfigInfo = cloneSpec.configInfo;
            if (oldConfigInfo == null) {
                oldConfigInfo = (HostProfile.ConfigInfo)profile.getConfig();
            }
            HostProfile.CompleteConfigSpec duplicateSpec = new HostProfile.CompleteConfigSpec();
            duplicateSpec.applyProfile = oldConfigInfo.applyProfile;
            duplicateSpec.customComplyProfile = oldConfigInfo.customComplyProfile;
            duplicateSpec.disabledExpressionList = oldConfigInfo.disabledExpressionList;
            duplicateSpec.name = cloneSpec.profileName;
            duplicateSpec.annotation = cloneSpec.profileDescription;
            duplicateSpec.validatorHost = cloneSpec.referenceHost == null ? profile.getReferenceHost() : cloneSpec.referenceHost;
            duplicateSpec.validating = true;
            duplicateSpec.enabled = true;
            ProfileManager profileManager = HostProfileUtils.getProfileManager(cloneSpec.profileRef.getServerGuid());
            ManagedObjectReference newProfileRef = null;
            try {
                newProfileRef = profileManager.createProfile((Profile.CreateSpec)duplicateSpec);
            }
            catch (InvalidProfileReferenceHost noRefHostError) {
                duplicateSpec.validating = false;
                newProfileRef = profileManager.createProfile((Profile.CreateSpec)duplicateSpec);
            }
            HostProfile newProfile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)newProfileRef);
            newProfile.updateReferenceHost(cloneSpec.referenceHost);
            result.entity = newProfileRef;
            result.result = newProfileRef;
        }
        catch (Exception e) {
            _logger.warn((Object)"The HostProfile could not be duplicated. ", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference entityRef, H5Remediation60Spec remediationSpec) {
        Collection precheckData = this._queryBindingService.prepare(HostPrecheck60AvailabilityData.class).fetch(Arrays.asList(remediationSpec.hostRefs));
        ValidationResult validationResult = this.validate60HostCustomizations(remediationSpec.hostProfileRef, remediationSpec.hostRefs);
        OperationResult operationResult = new OperationResult();
        Map<ManagedObjectReference, RemediationTaskListData> generateTaskListResult = this.generateTaskList(validationResult, remediationSpec.hostRefs);
        for (HostPrecheck60AvailabilityData precheckResultData : precheckData) {
            ManagedObjectReference hostRef = precheckResultData.getHostMor();
            if (!generateTaskListResult.containsKey(hostRef)) continue;
            RemediationTaskListData remediationTaskListData = generateTaskListResult.get(hostRef);
            precheckResultData.setRemediationTaskList(remediationTaskListData);
        }
        List<ManagedObjectReference> availableHosts = this.extractAvailableHosts(precheckData);
        if (availableHosts.size() > 0) {
            operationResult = this.invoke60Remediation(remediationSpec.hostProfileRef, (Map)validationResult.parameter, availableHosts, remediationSpec.rebootHosts, generateTaskListResult);
        } else {
            String errorMessage = HostProfileUtils.getLocalizedString("error.invokeRemediationFailed");
            RuntimeException noHostsAreAvailableException = new RuntimeException(errorMessage);
            _logger.error((Object)"Remediation operation failed", (Throwable)noHostsAreAvailableException);
            operationResult.error = noHostsAreAvailableException;
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference entityRef, H5PrecheckRemediation60Spec precheckSpec) {
        Collection precheckData = this._queryBindingService.prepare(HostPrecheck60AvailabilityData.class).fetch(Arrays.asList(precheckSpec.hostRefs));
        ValidationResult validationResult = this.validate60HostCustomizations(precheckSpec.hostProfileRef, precheckSpec.hostRefs);
        OperationResult operationResult = new OperationResult();
        Map<ManagedObjectReference, RemediationTaskListData> generateTaskListResult = this.generateTaskList(validationResult, precheckSpec.hostRefs);
        for (HostPrecheck60AvailabilityData precheckResultData : precheckData) {
            ManagedObjectReference hostRef = precheckResultData.getHostMor();
            if (!generateTaskListResult.containsKey(hostRef)) continue;
            RemediationTaskListData remediationTaskListData = generateTaskListResult.get(hostRef);
            precheckResultData.setRemediationTaskList(remediationTaskListData);
        }
        operationResult.result = precheckData;
        return operationResult;
    }

    private Map<ManagedObjectReference, RemediationTaskListData> generateTaskList(ValidationResult validationResult, ManagedObjectReference[] hostRefs) {
        PropertyRequestSpec propertyRequestSpec = new PropertyRequestSpec();
        PropertySpec propertySpec = new PropertySpec();
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.parameter = validationResult.parameter;
        parameterSpec.propertyName = REMEDIATION_TASKS_PROPERTY;
        propertySpec.propertyNames = new String[]{REMEDIATION_TASKS_PROPERTY};
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        propertyRequestSpec.objects = hostRefs;
        propertyRequestSpec.properties = new PropertySpec[]{propertySpec};
        ResultSet result = this._generateRemediationTasksAdapter.getProperties(propertyRequestSpec);
        Map<ManagedObjectReference, RemediationTaskListData> hostsConfigTaskMap = this.extractGenerateTaskListResult(result);
        return hostsConfigTaskMap;
    }

    private Map<ManagedObjectReference, RemediationTaskListData> extractGenerateTaskListResult(ResultSet result) {
        ResultItem[] resultItems;
        HashMap<ManagedObjectReference, RemediationTaskListData> hostsConfigTaskMap = new HashMap<ManagedObjectReference, RemediationTaskListData>();
        if (result != null && (resultItems = result.items) != null) {
            for (ResultItem resultItem : resultItems) {
                ManagedObjectReference resourceObject = this.extractGenerateTaskListResourceObjectForResultItem(resultItem);
                PropertyValue[] properties = this.extractGenerateTaskListPropertiesForResultItem(resultItem);
                if (properties == null) continue;
                for (PropertyValue propertyValue : properties) {
                    if (propertyValue == null || propertyValue.value == null || !(propertyValue.value instanceof RemediationTaskListData)) continue;
                    hostsConfigTaskMap.put(resourceObject, (RemediationTaskListData)((Object)propertyValue.value));
                }
            }
        }
        return hostsConfigTaskMap;
    }

    private ManagedObjectReference extractGenerateTaskListResourceObjectForResultItem(ResultItem resultItem) {
        ManagedObjectReference resourceObject = null;
        if (resultItem != null && resultItem.resourceObject instanceof ManagedObjectReference) {
            resourceObject = (ManagedObjectReference)resultItem.resourceObject;
        }
        return resourceObject;
    }

    private PropertyValue[] extractGenerateTaskListPropertiesForResultItem(ResultItem resultItem) {
        PropertyValue[] properties = null;
        if (resultItem != null && resultItem.resourceObject instanceof ManagedObjectReference) {
            properties = resultItem.properties;
        }
        return properties;
    }

    private ValidationResult validate60HostCustomizations(ManagedObjectReference hostProfileRef, ManagedObjectReference[] hostRefs) {
        ValidateHostCustomizationsSpec validateHostCustomizationsSpec = new ValidateHostCustomizationsSpec(null);
        validateHostCustomizationsSpec.forceValidationOnHosts = hostRefs;
        validateHostCustomizationsSpec.executeProfile = true;
        ValidationResult validationResult = this._mutationService.validate((Object)hostProfileRef, (Object)validateHostCustomizationsSpec);
        return validationResult;
    }

    private List<ManagedObjectReference> getAssociatedStandaloneHosts(ManagedObjectReference[] associatedEntitites) {
        ArrayList<ManagedObjectReference> associatedStandaloneHosts = new ArrayList<ManagedObjectReference>();
        List<ManagedObjectReference> associatedClusters = this.getAssociatedClusters(associatedEntitites);
        Collection hostsAssociatedWithClusters = this._queryBindingService.prepare(HostProfileCheckComplianceData.class).fetch(associatedClusters);
        LinkedHashMap<ManagedObjectReference, Set<ManagedObjectReference>> clustersWithAssociatedHosts = new LinkedHashMap<ManagedObjectReference, Set<ManagedObjectReference>>();
        for (HostProfileCheckComplianceData cluster : hostsAssociatedWithClusters) {
            clustersWithAssociatedHosts.put(cluster.getClusterMor(), cluster.getAssociatedHostsSet());
        }
        for (ManagedObjectReference entity : associatedEntitites) {
            boolean isEntityTypeHost = HostSystem.class.getSimpleName().equals(entity.getType());
            if (!isEntityTypeHost || !this.isHostStandalone(clustersWithAssociatedHosts, entity)) continue;
            associatedStandaloneHosts.add(entity);
        }
        return associatedStandaloneHosts;
    }

    private boolean isHostStandalone(Map<ManagedObjectReference, Set<ManagedObjectReference>> clustersWithAssociatedHosts, ManagedObjectReference host) {
        boolean isStandalone = true;
        for (ManagedObjectReference cluster : clustersWithAssociatedHosts.keySet()) {
            if (!clustersWithAssociatedHosts.get(cluster).contains(host)) continue;
            isStandalone = false;
            break;
        }
        return isStandalone;
    }

    private List<ManagedObjectReference> getAssociatedClusters(ManagedObjectReference[] associatedEntities) {
        ArrayList<ManagedObjectReference> associatedClusters = new ArrayList<ManagedObjectReference>();
        for (ManagedObjectReference entity : associatedEntities) {
            if (!ClusterComputeResource.class.getSimpleName().equals(entity.getType())) continue;
            associatedClusters.add(entity);
        }
        return associatedClusters;
    }

    private List<ManagedObjectReference> extractAvailableHosts(Collection<HostPrecheck60AvailabilityData> precheckData) {
        ArrayList<ManagedObjectReference> availableHosts = new ArrayList<ManagedObjectReference>();
        for (HostPrecheck60AvailabilityData data2 : precheckData) {
            HostRemediateResult precheckResult = data2.getPrecheckResult();
            if (precheckResult == null || !precheckResult.isHostAvailableForRemediation()) continue;
            availableHosts.add(data2.getHostMor());
        }
        return availableHosts;
    }

    private HostRequirements[] extractHostsRequirements(List<ManagedObjectReference> availableHosts, Map<ManagedObjectReference, RemediationTaskListData> generateTaskListResult) {
        ArrayList<HostRequirements> hostRequirements = new ArrayList<HostRequirements>();
        for (ManagedObjectReference availableHost : availableHosts) {
            if (!generateTaskListResult.containsKey(availableHost)) continue;
            RemediationTaskListData taskListData = generateTaskListResult.get(availableHost);
            HostRequirements requirements = new HostRequirements();
            requirements.hostRef = availableHost;
            requirements.remediationRequirements = taskListData.remediationRequirements;
            hostRequirements.add(requirements);
        }
        return hostRequirements.toArray(new HostRequirements[0]);
    }

    private OperationResult invoke60Remediation(ManagedObjectReference hostProfileRef, Map<String, ExecuteResultWrapper> hostExecutionResults, List<ManagedObjectReference> availableHosts, boolean rebootHosts, Map<ManagedObjectReference, RemediationTaskListData> generateTaskListResult) {
        RemediationSpec spec = new RemediationSpec();
        spec.profileReference = hostProfileRef;
        spec.rebootHosts = rebootHosts;
        spec.hostsExecutionResults = hostExecutionResults;
        spec.hostRequirements = this.extractHostsRequirements(availableHosts, generateTaskListResult);
        OperationResult[] remediationOperationResults = this._mutationService.applyOnMultiEntity((Object[])availableHosts.toArray(new ManagedObjectReference[0]), (Object)spec);
        OperationResult operationResult = this.invoke60ComplianceCheck(hostProfileRef, remediationOperationResults);
        return operationResult;
    }

    private OperationResult invoke60ComplianceCheck(ManagedObjectReference hostProfileRef, OperationResult[] remediationOperationResults) {
        OperationResult operationResult = new OperationResult();
        ArrayList<ManagedObjectReference> remediationTasks = new ArrayList<ManagedObjectReference>();
        if (remediationOperationResults != null) {
            for (OperationResult remediateOperationResult : remediationOperationResults) {
                ManagedObjectReference remediateTask = (ManagedObjectReference)remediateOperationResult.task;
                remediationTasks.add(remediateTask);
            }
            try {
                List remediationTasksInfos = this._taskMonitor.monitorTasks(remediationTasks);
                HostProfileCheckComplianceSpec checkComplianceSpec = new HostProfileCheckComplianceSpec();
                operationResult = this._mutationService.apply((Object)hostProfileRef, (Object)checkComplianceSpec);
                if (remediationTasksInfos != null) {
                    List<Remediation60TaskResultItem> remediation60TaskResultItems = this.getRemediation60TaskResultItems(remediationTasksInfos);
                    HashMap<String, List<Remediation60TaskResultItem>> operationResultParams = new HashMap<String, List<Remediation60TaskResultItem>>();
                    operationResultParams.put("remediation60TaskResultItems", remediation60TaskResultItems);
                    operationResult.parameter = operationResultParams;
                }
            }
            catch (Exception e) {
                _logger.error((Object)("Remediation task finished with error " + e));
                operationResult.error = e;
            }
        }
        return operationResult;
    }

    private List<Remediation60TaskResultItem> getRemediation60TaskResultItems(List<TaskInfo> remediationTasksInfos) {
        ArrayList<Remediation60TaskResultItem> remediation60TaskResultItems = new ArrayList<Remediation60TaskResultItem>();
        for (TaskInfo remediationTaskInfo : remediationTasksInfos) {
            String status = remediationTaskInfo.state != null ? remediationTaskInfo.state.name() : "";
            ManagedObjectReference host = remediationTaskInfo.entity != null ? remediationTaskInfo.entity : null;
            HostConfigFailed error = remediationTaskInfo.error != null ? (HostConfigFailed)remediationTaskInfo.error : null;
            Exception[] remediationErrors = error != null && error.getFailure() != null ? error.getFailure() : null;
            Remediation60TaskResultItem taskResultItem = new Remediation60TaskResultItem(status, host, remediationErrors);
            remediation60TaskResultItems.add(taskResultItem);
        }
        return remediation60TaskResultItems;
    }
}

