/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ProfileCategoryMetadata;
import com.vmware.vim.binding.vim.profile.ProfileComponentMetadata;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.hostprofile.impl.KeyUtil;
import java.util.HashMap;

public class CategoryMetadataAdapter {
    public static final String EMPTY_LABEL = "";
    private ProfileCategoryMetadata[] _categoryMeta;
    private ProfileComponentMetadata[] _componentMeta;
    private final HashMap<String, ProfileCategoryMetadata> _categoryMap = new HashMap();
    private final HashMap<String, ProfileComponentMetadata> _componentMap = new HashMap();

    public CategoryMetadataAdapter(ProfileCategoryMetadata[] categoryMeta, ProfileComponentMetadata[] componentMeta) {
        if (categoryMeta == null) {
            throw new NullPointerException("ProfileCategoryMetadata[] is null");
        }
        if (componentMeta == null) {
            throw new NullPointerException("ProfileComponentMetadata[] is null");
        }
        this._categoryMeta = categoryMeta;
        this._componentMeta = componentMeta;
        this.localizeCategoryMetadata();
        this.localizeComponentMetadata();
    }

    private void localizeComponentMetadata() {
        for (ProfileComponentMetadata meta : this._componentMeta) {
            String label = LocalizationUtil.getLocalizedMessage((String)(meta.id.messageCatalogKeyPrefix + ".label"), (KeyAnyValue[])meta.id.messageArg);
            String summary = LocalizationUtil.getLocalizedMessage((String)(meta.id.messageCatalogKeyPrefix + ".summary"), (KeyAnyValue[])meta.id.messageArg);
            meta.id.label = label;
            meta.id.summary = summary;
            String key = KeyUtil.getComponentMetaDataKey(meta);
            this._componentMap.put(key, meta);
        }
    }

    private void localizeCategoryMetadata() {
        for (ProfileCategoryMetadata meta : this._categoryMeta) {
            String localizeLabel = LocalizationUtil.getLocalizedMessage((String)(meta.id.messageCatalogKeyPrefix + ".label"), (KeyAnyValue[])meta.id.messageArg);
            String localizedSummary = LocalizationUtil.getLocalizedMessage((String)(meta.id.messageCatalogKeyPrefix + ".summary"), (KeyAnyValue[])meta.id.messageArg);
            meta.id.label = localizeLabel;
            meta.id.summary = localizedSummary;
            String key = KeyUtil.getCategoryMetaDataKey(meta);
            this._categoryMap.put(key, meta);
        }
    }

    public String getCategoryLabel(String key) {
        ProfileCategoryMetadata meta = this.getCategoryMeta(key);
        if (meta == null || meta.id == null || meta.id.label == null) {
            return EMPTY_LABEL;
        }
        return meta.id.label;
    }

    public String getCategorySummary(String key) {
        ProfileCategoryMetadata meta = this.getCategoryMeta(key);
        if (meta == null || meta.id == null || meta.id.summary == null) {
            return EMPTY_LABEL;
        }
        return meta.id.summary;
    }

    private ProfileCategoryMetadata getCategoryMeta(String key) {
        if (StringUtil.isNullOrEmpty((String)key)) {
            return null;
        }
        return this._categoryMap.get(key.toLowerCase());
    }

    private ProfileComponentMetadata getComponentMeta(String key) {
        if (StringUtil.isNullOrEmpty((String)key)) {
            return null;
        }
        return this._componentMap.get(key.toLowerCase());
    }

    public String getComponentLabel(String key) {
        ProfileComponentMetadata meta = this.getComponentMeta(key);
        if (meta == null || meta.id == null || meta.id.label == null) {
            return EMPTY_LABEL;
        }
        return meta.id.label;
    }

    public String getComponentSummary(String key) {
        ProfileComponentMetadata meta = this.getComponentMeta(key);
        if (meta == null || meta.id == null || meta.id.summary == null) {
            return EMPTY_LABEL;
        }
        return meta.id.summary;
    }
}

