/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.profile.host.ExecuteResult;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.ExecuteResultWrapper;
import com.vmware.vsphere.client.hostprofile.data.RemediationTaskListData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GenerateRemediationTasksAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(GenerateRemediationTasksAdapter.class);
    private static final String REMEDIATION_TASKS_PROPERTY = "hostProfileRemediationTasks";
    private DataService _dataService;
    private TaskMonitor _taskMonitor;
    private ThreadPoolExecutor _threadPool;

    public GenerateRemediationTasksAdapter(DataServiceExtensionRegistry registry, DataService dataService, ThreadPoolExecutor threadPool, TaskMonitor taskMonitor) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
        this._threadPool = threadPool;
        this._taskMonitor = taskMonitor;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo hostTypeInfo = new TypeInfo();
        hostTypeInfo.type = HostSystem.class.getSimpleName();
        hostTypeInfo.properties = new String[]{REMEDIATION_TASKS_PROPERTY};
        return new TypeInfo[]{hostTypeInfo};
    }

    private static PropertyValue buildPropertyValue(Object provider, String propertyName, Object propertyValue) {
        PropertyValue property = new PropertyValue();
        property.resourceObject = provider;
        property.propertyName = propertyName;
        property.value = propertyValue;
        return property;
    }

    private static ResultItem buildResultItem(ManagedObjectReference host, PropertyValue[] properties) {
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = host;
        resultItem.properties = properties;
        return resultItem;
    }

    private static Map<String, ExecuteResultWrapper> getPropertyParameter(PropertySpec[] specs) {
        for (PropertySpec propertySpec : specs) {
            for (ParameterSpec parameterSpec : propertySpec.parameters) {
                Object parameter;
                String propertyName = parameterSpec.propertyName;
                if (!REMEDIATION_TASKS_PROPERTY.equals(propertyName) || !((parameter = parameterSpec.parameter) instanceof Map)) continue;
                return (Map)parameter;
            }
        }
        _logger.warn((Object)"Could not find host execution results parameter");
        return new HashMap<String, ExecuteResultWrapper>();
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        List list;
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] hosts = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        Map<String, ExecuteResultWrapper> executionResults = GenerateRemediationTasksAdapter.getPropertyParameter(properties);
        ArrayList<Callable<ProfileManager.ConfigTaskList>> taskRequests = new ArrayList<Callable<ProfileManager.ConfigTaskList>>(hosts.length);
        ProfileManager profileManager = null;
        for (Object host : hosts) {
            if (!this.isValidHostReference(host)) continue;
            try {
                String guid = ((ManagedObjectReference)host).getServerGuid();
                profileManager = HostProfileUtils.getProfileManager(guid);
                break;
            }
            catch (Exception guid) {
                // empty catch block
            }
        }
        if (profileManager == null) {
            String string = HostProfileUtils.getLocalizedString("profile.error.invalidArguments");
            throw new RuntimeException(string);
        }
        for (Object object : hosts) {
            if (!this.isValidHostReference(object)) {
                _logger.info((Object)("The object[" + object + "] is not a HostSystem object"));
                continue;
            }
            Object[] hostRef = (Object[])object;
            String hostRefString = ManagedObjectUtil.morefToString((ManagedObjectReference)hostRef);
            ExecuteResultWrapper executeResultWrapper = executionResults.get(hostRefString);
            ExecuteResult hostExecuteResult = executeResultWrapper == null ? null : executeResultWrapper.getExecuteResult();
            Callable<ProfileManager.ConfigTaskList> deferredTasks = this.getRemediationTasks(profileManager, (ManagedObjectReference)hostRef, hostExecuteResult);
            taskRequests.add(deferredTasks);
        }
        Object var7_10 = null;
        ArrayList<MethodFault> faults = new ArrayList<MethodFault>();
        try {
            list = ExecutorUtil.executeTasks(taskRequests, (Executor)this._threadPool, (long)1L, (TimeUnit)TimeUnit.HOURS, (boolean)false);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
        ArrayList<ResultItem> remediationTaskResults = new ArrayList<ResultItem>(hosts.length);
        int taskIdx = 0;
        for (Object object : hosts) {
            if (!this.isValidHostReference(object)) continue;
            ManagedObjectReference hostRef = (ManagedObjectReference)object;
            ExecutorUtil.TaskResult taskResult = (ExecutorUtil.TaskResult)list.get(taskIdx++);
            RemediationTaskListData remediationTask = new RemediationTaskListData();
            try {
                ProfileManager.ConfigTaskList taskList = (ProfileManager.ConfigTaskList)taskResult.getResult();
                LocalizableMessage[] messages = taskList == null || taskList.taskDescription == null ? new LocalizableMessage[]{} : taskList.taskDescription;
                String[] tasks = new String[messages.length];
                for (int i = 0; i < tasks.length; ++i) {
                    LocalizableMessage message = messages[i];
                    tasks[i] = LocalizationUtil.getLocalizedMessage((String)message.getKey(), (KeyAnyValue[])message.getArg());
                }
                remediationTask.remediationTasks = tasks;
                remediationTask.remediationRequirements = taskList == null || taskList.taskListRequirement == null ? new String[]{} : taskList.taskListRequirement;
            }
            catch (Exception e) {
                _logger.warn((Object)("Could not extract remediation tasks for host: " + hostRef), (Throwable)e);
                Throwable t = e;
                if (e instanceof ExecutionException) {
                    t = ((ExecutionException)e).getCause();
                }
                MethodFault methodFault = MixedUtil.getMethodFault((Throwable)t);
                remediationTask.error = methodFault;
                faults.add(methodFault);
            }
            PropertyValue propertyValue = GenerateRemediationTasksAdapter.buildPropertyValue(hostRef, REMEDIATION_TASKS_PROPERTY, (Object)remediationTask);
            ResultItem hostResult = GenerateRemediationTasksAdapter.buildResultItem(hostRef, new PropertyValue[]{propertyValue});
            remediationTaskResults.add(hostResult);
        }
        ResultSet result = new ResultSet();
        if (faults.size() > 0) {
            result.error = new CompositeException(faults);
        }
        result.items = remediationTaskResults.toArray(new ResultItem[0]);
        return result;
    }

    private boolean isValidHostReference(Object host) {
        return host instanceof ManagedObjectReference && HostSystem.class.getSimpleName().equals(((ManagedObjectReference)host).getType());
    }

    private Callable<ProfileManager.ConfigTaskList> getRemediationTasks(final ProfileManager profileManager, final ManagedObjectReference hostRef, final ExecuteResult executeResult) {
        return new Callable<ProfileManager.ConfigTaskList>(){

            @Override
            public ProfileManager.ConfigTaskList call() throws Exception {
                ProfileManager.ConfigTaskList remediationTasks;
                if (executeResult == null) {
                    return null;
                }
                if (VcServiceUtil.isOPVcOrLater((String)hostRef.getServerGuid())) {
                    TaskInfo taskInfo;
                    try {
                        taskInfo = GenerateRemediationTasksAdapter.this._taskMonitor.monitorTask(profileManager.generateTaskList(executeResult.configSpec, hostRef));
                    }
                    catch (Exception e) {
                        return null;
                    }
                    remediationTasks = (ProfileManager.ConfigTaskList)taskInfo.result;
                } else {
                    remediationTasks = profileManager.generateConfigTaskList(executeResult.configSpec, hostRef);
                }
                return remediationTasks;
            }
        };
    }
}

