/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.profile.ComplianceResult;
import com.vmware.vim.binding.vim.profile.Profile;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.hostprofile.BoundedPriorityQueue;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.ProfilePathUtil;
import com.vmware.vsphere.client.hostprofile.cluster.impl.Util;
import com.vmware.vsphere.client.hostprofile.data.CopyHostProfileSettingsDiffData;
import com.vmware.vsphere.client.hostprofile.data.CopyHostProfileSettingsDiffElementData;
import com.vmware.vsphere.client.hostprofile.data.CopyHostProfileSettingsDiffSpec;
import com.vmware.vsphere.client.hostprofile.data.HostProfileComplianceSummaryData;
import com.vmware.vsphere.client.hostprofile.data.ProfileSummaryData;
import com.vmware.vsphere.client.hostprofile.impl.ProfileWrapperUtil;
import com.vmware.vsphere.client.hostprofile.impl.Unwrapper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostProfilePropertyProvider
implements PropertyProviderBean {
    private static final String PROFILE_EDIT_PRIVILIGE = "Profile.Edit";
    private static final String VALIDATE_COMPOSITION_DIFF_STATUS_SUCCESS = "success";
    private static final Log _logger = LogFactory.getLog(HostProfilePropertyProvider.class);
    private final LegacyAuthorizationService _authorizationService;
    private TaskMonitor _taskMonitor;
    private final QueryExecutor _queryExecutor;
    private final QueryService _queryService;

    public HostProfilePropertyProvider(QueryExecutor queryExecutor, TaskMonitor taskMonitor, LegacyAuthorizationService authorizationService, QueryService queryService) {
        this._queryExecutor = queryExecutor;
        this._authorizationService = authorizationService;
        this._taskMonitor = taskMonitor;
        this._queryService = queryService;
    }

    @type(value="HostProfile,ClusterProfile")
    public Profile.Description getOverallSummary(ManagedObjectReference profileRef) throws Exception {
        Profile hostProfile = (Profile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profileRef);
        Profile.Description description = null;
        if (HostProfileUtils.isVc65OrLater(profileRef) && this.hasProfilePrivilege(PROFILE_EDIT_PRIVILIGE, profileRef).booleanValue()) {
            HostProfile.ConfigInfo configInfo = (HostProfile.ConfigInfo)hostProfile.getConfig();
            description = configInfo.description;
        } else {
            description = hostProfile.retrieveDescription();
        }
        if (description == null || description.section == null) {
            return null;
        }
        String messageCatalogKeySuffix = ".label";
        for (Profile.Description.Section section : description.section) {
            String localizedDescription;
            section.description.label = localizedDescription = LocalizationUtil.getLocalizedMessage((String)(section.description.messageCatalogKeyPrefix + messageCatalogKeySuffix), (KeyAnyValue[])section.description.messageArg);
        }
        return description;
    }

    @type(value="HostProfile")
    public String[] getGrantedPrivileges(ManagedObjectReference mor) throws Exception {
        VcService service = VimSessionUtil.getService((String)mor.getServerGuid());
        ManagedObjectReference rootFolderRef = service.getServiceInstanceContent().rootFolder;
        PropertyValue[] privilegeData = this._authorizationService.getPrivileges(new ManagedObjectReference[]{rootFolderRef});
        return privilegeData != null && privilegeData.length > 0 ? (String[])privilegeData[0].value : null;
    }

    @type(value="HostProfile")
    public HostProfileComplianceSummaryData getHostComplianceSummary(ManagedObjectReference profileRef) throws Exception {
        PropertyValue[] complianceValues;
        HostProfileComplianceSummaryData result = new HostProfileComplianceSummaryData();
        Object[] entitiesRef = (ManagedObjectReference[])this._queryExecutor.getProperty((Object)profileRef, "entity");
        if (entitiesRef == null || entitiesRef.length == 0) {
            return result;
        }
        for (PropertyValue complianceProperty : complianceValues = this._queryExecutor.getProperty(entitiesRef, "hostProfileCompliance")) {
            ManagedObjectReference entityRef = (ManagedObjectReference)complianceProperty.resourceObject;
            if (!HostSystem.class.getSimpleName().equals(entityRef.getType())) continue;
            ComplianceResult complianceResult = (ComplianceResult)complianceProperty.value;
            ComplianceResult.Status complianceStatus = null;
            if (complianceResult.complianceStatus != null) {
                complianceStatus = ComplianceResult.Status.valueOf((String)complianceResult.complianceStatus);
            }
            ++result.attachedHostCount;
            if (ComplianceResult.Status.compliant.equals((Object)complianceStatus)) {
                ++result.compliantHostCount;
                continue;
            }
            if (ComplianceResult.Status.nonCompliant.equals((Object)complianceStatus)) {
                ++result.nonCompliantHostCount;
                continue;
            }
            ++result.unknownCompliantHostCount;
        }
        return result;
    }

    @type(value="HostProfile")
    public ComplianceResult[] getNonCompliantHostsResult(ManagedObjectReference profileRef, int lastModified) throws Exception {
        Object[] entitiesRef = (ManagedObjectReference[])this._queryExecutor.getProperty((Object)profileRef, "entity");
        if (entitiesRef == null || entitiesRef.length == 0) {
            return new ComplianceResult[0];
        }
        PropertyValue[] complianceValues = this._queryExecutor.getProperty(entitiesRef, "hostProfileCompliance");
        BoundedPriorityQueue<ComplianceResult> queue = new BoundedPriorityQueue<ComplianceResult>(lastModified, new Comparator<ComplianceResult>(){

            @Override
            public int compare(ComplianceResult arg1, ComplianceResult arg2) {
                return arg1.checkTime.compareTo(arg2.checkTime);
            }
        });
        for (PropertyValue complianceProperty : complianceValues) {
            ManagedObjectReference entityRef = (ManagedObjectReference)complianceProperty.resourceObject;
            if (!HostSystem.class.getSimpleName().equals(entityRef.getType())) continue;
            ComplianceResult complianceResult = (ComplianceResult)complianceProperty.value;
            ComplianceResult.Status complianceStatus = null;
            if (complianceResult.complianceStatus != null) {
                complianceStatus = ComplianceResult.Status.valueOf((String)complianceResult.complianceStatus);
            }
            if (!ComplianceResult.Status.nonCompliant.equals(complianceStatus)) continue;
            queue.offer(complianceResult);
        }
        ComplianceResult[] result = queue.pollAll((ComplianceResult[])new ComplianceResult[0]);
        return result;
    }

    private boolean isParentAttached(ManagedObjectReference[] entities, ManagedObjectReference hostEntity) throws Exception {
        ManagedObjectReference parent = (ManagedObjectReference)this._queryExecutor.getProperty((Object)hostEntity, "cluster");
        boolean parentAttached = false;
        if (parent != null) {
            for (ManagedObjectReference mor : entities) {
                if (!parent.equals((Object)mor)) continue;
                parentAttached = true;
                break;
            }
        }
        return parentAttached;
    }

    @type(value="HostProfile")
    public ManagedObjectReference[] getDetachableEntity(ManagedObjectReference profileRef) throws Exception {
        ManagedObjectReference[] entities = (ManagedObjectReference[])this._queryExecutor.getProperty((Object)profileRef, "entity");
        ArrayList<ManagedObjectReference> detachableEntities = new ArrayList<ManagedObjectReference>();
        if (entities != null) {
            for (ManagedObjectReference entity : entities) {
                if (entity.getType().equals(HostSystem.class.getSimpleName()) && this.isParentAttached(entities, entity)) continue;
                detachableEntities.add(entity);
            }
        }
        return detachableEntities.toArray(new ManagedObjectReference[detachableEntities.size()]);
    }

    @type(value="HostProfile")
    public ProfileSummaryData[] getComponentSummary(ManagedObjectReference profileRef) throws Exception {
        ArrayList<ProfileSummaryData> aList = new ArrayList<ProfileSummaryData>();
        if (profileRef == null) {
            return new ProfileSummaryData[0];
        }
        Profile.Description description = this.getOverallSummary(profileRef);
        String messageCatalogKeySuffix = ".label";
        for (Profile.Description.Section section : description.section) {
            for (LocalizableMessage message : section.message) {
                String strSection = LocalizationUtil.getLocalizedMessage((String)(section.description.messageCatalogKeyPrefix + messageCatalogKeySuffix), (KeyAnyValue[])section.description.messageArg);
                String strMessage = LocalizationUtil.getLocalizedMessage((String)message.getKey(), (KeyAnyValue[])message.getArg());
                aList.add(new ProfileSummaryData(strSection, strMessage));
            }
        }
        ProfileSummaryData[] result = new ProfileSummaryData[aList.size()];
        return aList.toArray(result);
    }

    @type(value="HostProfile")
    public OperationResult getHostApplyProfileData(ManagedObjectReference profileRef) {
        OperationResult result = new OperationResult();
        try {
            ProfileManager.HostProfileMetadata hostProfileMeta = HostProfileUtils.getHostProfileMetadata(profileRef, ProfileManager.MetadataTypes.profile, ProfileManager.MetadataTypes.policy, ProfileManager.MetadataTypes.category, ProfileManager.MetadataTypes.component);
            result.result = ProfilePathUtil.buildProfileWrapper(profileRef, hostProfileMeta.profileMetadata, hostProfileMeta.policyMetadata, hostProfileMeta.profileCategoryMetadata, hostProfileMeta.profileComponentMetadata);
        }
        catch (Exception e) {
            result.error = MixedUtil.getMethodFault((Throwable)e);
            _logger.error((Object)"Error while retrieving HostApplyProfileData", (Throwable)e);
        }
        return result;
    }

    @type(value="HostProfile,HostSystem,ClusterComputeResource")
    public String getHostCustomizationsExportData(ManagedObjectReference entity) throws Exception {
        ManagedObjectReference[] entities = null;
        entities = ManagedObjectUtil.isOfType((ManagedObjectReference)entity, HostProfile.class) ? this.getAttachedHosts(entity) : new ManagedObjectReference[]{entity};
        if (entities == null || entities.length == 0) {
            _logger.error((Object)"There are no entities from which to export host customizations.");
            return null;
        }
        ProfileManager profileManager = HostProfileUtils.getProfileManager(entity.getServerGuid());
        ManagedObjectReference taskRef = profileManager.exportCustomizations(entities, "csv");
        TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
        if (taskInfo.error != null) {
            throw taskInfo.error;
        }
        ProfileManager.CustomizationData taskResult = (ProfileManager.CustomizationData)taskInfo.result;
        ProfileManager.FormattedCustomizations customizations = null;
        if (taskResult != null && taskResult.entityCustomizations != null && taskResult.entityCustomizations.length > 0) {
            customizations = (ProfileManager.FormattedCustomizations)taskResult.entityCustomizations[0];
        }
        return customizations != null ? customizations.formattedCustomizations : null;
    }

    private ManagedObjectReference[] getAttachedHosts(ManagedObjectReference profileRef) throws Exception {
        ManagedObjectReference[] entitiesRef = (ManagedObjectReference[])this._queryExecutor.getProperty((Object)profileRef, "entity");
        if (entitiesRef == null || entitiesRef.length == 0) {
            return null;
        }
        ArrayList<ManagedObjectReference> hostMors = null;
        if (entitiesRef != null || entitiesRef.length > 0) {
            hostMors = new ArrayList<ManagedObjectReference>();
            for (ManagedObjectReference entity : entitiesRef) {
                if (!ManagedObjectUtil.isOfType((ManagedObjectReference)entity, HostSystem.class)) continue;
                hostMors.add(entity);
            }
        }
        if (hostMors == null || hostMors.isEmpty()) {
            return null;
        }
        return hostMors.toArray(new ManagedObjectReference[hostMors.size()]);
    }

    @type(value="HostProfile,HostSystem,ClusterComputeResource")
    public boolean getExportHostCustomizationsAvailable(ManagedObjectReference entity) throws Exception {
        boolean isBulkAnswerFileEnabled = (Boolean)this._queryExecutor.getProperty((Object)entity, "isBulkAnswerFileEnabled");
        if (!isBulkAnswerFileEnabled) {
            return false;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)entity, HostProfile.class)) {
            ManagedObjectReference[] entities = this.getAttachedHosts(entity);
            return entities != null && entities.length != 0;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)entity, ClusterComputeResource.class)) {
            PropertyValue[] pv = this._queryExecutor.getPropertiesForRelatedObjects((Object)entity, "host", "HostSystem", new String[]{"name"});
            return pv != null && pv.length != 0;
        }
        return true;
    }

    @type(value="HostProfile")
    public String getHostProfileExportData(ManagedObjectReference profileRef) throws Exception {
        HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)profileRef);
        String serializedProfile = profile.exportProfile();
        return serializedProfile;
    }

    @type(value="HostProfile,HostSystem,ClusterComputeResource")
    public boolean getCanEditHostCustomizations(ManagedObjectReference entity) throws Exception {
        boolean isBulkAnswerFileEnabled = (Boolean)this._queryExecutor.getProperty((Object)entity, "isBulkAnswerFileEnabled");
        if (!isBulkAnswerFileEnabled) {
            return false;
        }
        return this.getCanRemediate(entity);
    }

    @type(value="HostProfile,HostSystem,ClusterComputeResource")
    public boolean getCanRemediate(ManagedObjectReference entity) throws Exception {
        ProfileManager profileManager = HostProfileUtils.getProfileManager(entity.getServerGuid());
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)entity, HostProfile.class)) {
            ManagedObjectReference[] entities = this.getAttachedHosts(entity);
            return entities != null && entities.length != 0;
        }
        ManagedObjectReference assosseatedProfile = this.getAssociatedHostProfile(profileManager, entity);
        if (assosseatedProfile == null || !this.hasProfilePrivilege(PROFILE_EDIT_PRIVILIGE, assosseatedProfile).booleanValue()) {
            return false;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)entity, ClusterComputeResource.class)) {
            PropertyValue[] pv = this._queryExecutor.getPropertiesForRelatedObjects((Object)entity, "host", "HostSystem", new String[]{"name"});
            return pv != null && pv.length != 0;
        }
        return true;
    }

    private ManagedObjectReference getAssociatedHostProfile(ProfileManager profileManager, ManagedObjectReference entity) throws Exception {
        ManagedObjectReference[] profiles = profileManager.findAssociatedProfile(entity);
        if (profiles != null) {
            for (ManagedObjectReference profile : profiles) {
                if (!profile.getType().equals(HostProfile.class.getSimpleName())) continue;
                return profile;
            }
        }
        return null;
    }

    private Boolean hasProfilePrivilege(String priviliage, ManagedObjectReference hostProfile) throws Exception {
        String[] grantedPrivileges;
        for (String grantedPrivilege : grantedPrivileges = this.getGrantedPrivileges(hostProfile)) {
            if (!grantedPrivilege.equals(priviliage)) continue;
            return true;
        }
        return false;
    }

    @type(value="HostProfile")
    public CopyHostProfileSettingsDiffData getCopyHostProfileSettingsDiff(ManagedObjectReference sourceHostProfileRef, CopyHostProfileSettingsDiffSpec spec) throws Exception {
        if (sourceHostProfileRef == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("copyHostProfileSettingsDiff.emptySourceHostProfile"));
        }
        if (spec == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("copyHostProfileSettingsDiff.emptySpec"));
        }
        if (spec.targetHostProfilesRefs == null || spec.targetHostProfilesRefs.size() == 0) {
            throw new IllegalArgumentException(Util.getLocalizedString("copyHostProfileSettingsDiff.emptyTargetHostProfiles"));
        }
        if (spec.sourceProfileWrapper == null) {
            throw new IllegalArgumentException(Util.getLocalizedString("copyHostProfileSettingsDiff.emptyCopySettingsObject"));
        }
        ProfileWrapperUtil.patchHostApplyProfileWrapperToBeMerged(spec.sourceProfileWrapper, false);
        ProfileManager profileManager = HostProfileUtils.getProfileManager(sourceHostProfileRef.getServerGuid());
        HostApplyProfile applyProfile = Unwrapper.unwrap(spec.sourceProfileWrapper);
        ManagedObjectReference validationTask = profileManager.validateComposition(sourceHostProfileRef, spec.targetHostProfilesRefs.toArray(new ManagedObjectReference[0]), applyProfile, null, null, null, Boolean.valueOf(spec.returnOnlyErrors));
        TaskInfo validationTaskInfo = this._taskMonitor.monitorTask(validationTask);
        ProfileManager.CompositionValidationResult validationResult = (ProfileManager.CompositionValidationResult)validationTaskInfo.result;
        CopyHostProfileSettingsDiffData resultDiff = new CopyHostProfileSettingsDiffData();
        resultDiff.errorMessages = new ArrayList<String>();
        resultDiff.elements = new ArrayList<CopyHostProfileSettingsDiffElementData>();
        if (validationResult.errors != null) {
            for (LocalizableMessage error : validationResult.errors) {
                String errorMessage = HostProfileUtils.getLocalizedMessage(error);
                resultDiff.errorMessages.add(errorMessage);
            }
        }
        Map<Object, Object> hostProfilesMeta = new HashMap();
        if (!spec.returnOnlyErrors) {
            ArrayList<ManagedObjectReference> hostProfilesRefs = new ArrayList<ManagedObjectReference>();
            hostProfilesRefs.add(sourceHostProfileRef);
            hostProfilesRefs.addAll(spec.targetHostProfilesRefs);
            hostProfilesMeta = HostProfileUtils.getHostProfilesMetadata(hostProfilesRefs.toArray(new ManagedObjectReference[0]), ProfileManager.MetadataTypes.profile, ProfileManager.MetadataTypes.policy, ProfileManager.MetadataTypes.category, ProfileManager.MetadataTypes.component);
        }
        ProfileManager.HostProfileMetadata sourceHostProfileMeta = (ProfileManager.HostProfileMetadata)hostProfilesMeta.get(sourceHostProfileRef);
        if (validationResult.results != null) {
            for (ProfileManager.CompositionValidationResult.ResultElement validationResultElement : validationResult.results) {
                CopyHostProfileSettingsDiffElementData resultDiffElement = new CopyHostProfileSettingsDiffElementData();
                resultDiffElement.errorMessages = new ArrayList<String>();
                resultDiffElement.isSuccessful = false;
                resultDiffElement.targetProfileRef = validationResultElement.target;
                if (validationResultElement.errors != null) {
                    for (LocalizableMessage error : validationResultElement.errors) {
                        String errorMessage = HostProfileUtils.getLocalizedMessage(error);
                        resultDiffElement.errorMessages.add(errorMessage);
                    }
                }
                if (VALIDATE_COMPOSITION_DIFF_STATUS_SUCCESS.equals(validationResultElement.status)) {
                    resultDiffElement.isSuccessful = true;
                }
                ProfileManager.HostProfileMetadata targetHostProfileMeta = (ProfileManager.HostProfileMetadata)hostProfilesMeta.get(validationResultElement.target);
                if (!spec.returnOnlyErrors) {
                    if (validationResultElement.sourceDiffForToBeMerged != null) {
                        resultDiffElement.sourceDiff = ProfilePathUtil.buildProfileWrapper(validationResultElement.sourceDiffForToBeMerged, sourceHostProfileMeta.profileMetadata, sourceHostProfileMeta.policyMetadata, sourceHostProfileMeta.profileCategoryMetadata, sourceHostProfileMeta.profileComponentMetadata);
                        ProfileWrapperUtil.patchHostApplyProfileWrapperToBeMerged(resultDiffElement.sourceDiff, true);
                    }
                    if (validationResultElement.targetDiffForToBeMerged != null) {
                        resultDiffElement.targetDiff = ProfilePathUtil.buildProfileWrapper(validationResultElement.targetDiffForToBeMerged, targetHostProfileMeta.profileMetadata, targetHostProfileMeta.policyMetadata, targetHostProfileMeta.profileCategoryMetadata, targetHostProfileMeta.profileComponentMetadata);
                        ProfileWrapperUtil.patchHostApplyProfileWrapperToBeMerged(resultDiffElement.targetDiff, true);
                    }
                    if (validationResultElement.toBeAdded != null) {
                        resultDiffElement.toBeAdded = ProfilePathUtil.buildProfileWrapper(validationResultElement.toBeAdded, sourceHostProfileMeta.profileMetadata, sourceHostProfileMeta.policyMetadata, sourceHostProfileMeta.profileCategoryMetadata, sourceHostProfileMeta.profileComponentMetadata);
                        ProfileWrapperUtil.patchHostApplyProfileWrapperToBeMerged(resultDiffElement.toBeAdded, true);
                    }
                }
                resultDiff.elements.add(resultDiffElement);
            }
        }
        return resultDiff;
    }
}

