/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.PasswordField;
import com.vmware.vim.binding.vim.fault.ProfileUpdateFailed;
import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ApplyProfileProperty;
import com.vmware.vim.binding.vim.profile.NumericComparator;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.PolicyOptionMetadata;
import com.vmware.vim.binding.vim.profile.ProfileCategoryMetadata;
import com.vmware.vim.binding.vim.profile.ProfileComponentMetadata;
import com.vmware.vim.binding.vim.profile.ProfilePropertyPath;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.impl.CategoryMetadataAdapter;
import com.vmware.vsphere.client.hostprofile.impl.ProfileGrouper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProcessUtil {
    private static final Log _logger = LogFactory.getLog(ProcessUtil.class);
    private static final String TYPE_BOOLEAN = "boolean";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_INT = "int";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_ARRAY_OF_STRING = "ArrayOfString";
    private static final String ADVANCED_OPTION_PROFILE_KEY_PREFIX = "config.applyProfile.option[\"key-vim-profile-host-OptionProfile-";
    private static final String ADVANCED_OPTION_PROFILE_KEY_FORMAT = "config.applyProfile.option[\"key-vim-profile-host-OptionProfile-%s\"]";

    private ProcessUtil() {
    }

    public static boolean hasValidOptionParam(Policy policy) {
        return policy != null && policy.policyOption != null && policy.policyOption.parameter != null && policy.policyOption.parameter.length > 0;
    }

    public static boolean hasValidParam(PolicyOptionMetadata poMeta) {
        return poMeta != null && poMeta.parameter != null && poMeta.parameter.length > 0;
    }

    public static boolean hasValidOptionId(Policy policy) {
        return policy != null && policy.policyOption != null && !StringUtil.isNullOrEmpty((String)policy.policyOption.id);
    }

    public static boolean hasValidPossibleOption(PolicyMetadata meta) {
        return meta != null && meta.possibleOption != null;
    }

    public static boolean hasValidIdKey(PolicyOptionMetadata meta) {
        return meta != null && meta.id != null && !StringUtil.isNullOrEmpty((String)meta.id.key);
    }

    public static boolean isValidParam(ParameterMetadata parMeta) {
        return parMeta != null && parMeta.type != null;
    }

    public static boolean isValidKeyParam(ParameterMetadata parMeta) {
        return parMeta != null && parMeta.id != null && parMeta.id.key != null;
    }

    public static boolean isValidKeyAnyValue(KeyAnyValue kav) {
        return kav != null && !StringUtil.isNullOrEmpty((String)kav.getKey());
    }

    public static Boolean isTraversableField(Field field) {
        if (field == null) {
            return false;
        }
        Class<?> fieldType = field.getType();
        return ApplyProfile.class.isAssignableFrom(fieldType) || ApplyProfile[].class.isAssignableFrom(fieldType) || Policy[].class.isAssignableFrom(fieldType) || ApplyProfileProperty[].class.isAssignableFrom(fieldType);
    }

    public static String convertToSimpleTypeName(Class<?> clazz) {
        if (clazz.equals(Boolean.class)) {
            return TYPE_BOOLEAN;
        }
        if (clazz.equals(Boolean.TYPE)) {
            return TYPE_BOOLEAN;
        }
        if (clazz.equals(Integer.class)) {
            return TYPE_INT;
        }
        if (clazz.equals(Integer.TYPE)) {
            return TYPE_INT;
        }
        if (clazz.equals(Long.class)) {
            return TYPE_LONG;
        }
        if (clazz.equals(Long.TYPE)) {
            return TYPE_LONG;
        }
        if (clazz.equals(String.class)) {
            return TYPE_STRING;
        }
        if (clazz.equals(String[].class)) {
            return TYPE_ARRAY_OF_STRING;
        }
        return TYPE_STRING;
    }

    private static Class<?> convertToPrimitiveOrStringClass(String className) {
        if (TYPE_STRING.equals(className)) {
            return String.class;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        if (TYPE_INT.equals(className)) {
            return Integer.TYPE;
        }
        if (TYPE_LONG.equals(className)) {
            return Long.TYPE;
        }
        if ("float".equals(className)) {
            return Float.TYPE;
        }
        if ("double".equals(className)) {
            return Double.TYPE;
        }
        if (TYPE_BOOLEAN.equals(className)) {
            return Boolean.TYPE;
        }
        if ("char".equals(className)) {
            return Character.TYPE;
        }
        return null;
    }

    public static boolean isComplexTypeKeyValue(KeyAnyValue kav) {
        if (kav == null || kav.getValue() == null) {
            return false;
        }
        Class<?> kavClass = ProcessUtil.getKeyValueClass(kav);
        if (kavClass == null) {
            return false;
        }
        return ProcessUtil.isComplexType(kavClass);
    }

    public static boolean isComplexTypeParamMeta(ParameterMetadata parMeta) {
        if (parMeta == null || parMeta.type == null) {
            return false;
        }
        Class<?> pmClass = ProcessUtil.getParamMetaClass(parMeta);
        if (pmClass == null) {
            return false;
        }
        return ProcessUtil.isComplexType(pmClass);
    }

    public static boolean isComplexType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String className = clazz.getName();
        if (clazz.isArray()) {
            className = clazz.getComponentType().getName();
        }
        boolean result = className.startsWith("com.vmware.vim.binding.vim");
        result &= !clazz.equals(PasswordField.class);
        return result &= !clazz.equals(NumericComparator.class);
    }

    public static Class<?> getKeyValueClass(KeyAnyValue kav) {
        if (kav == null || kav.getValue() == null) {
            return null;
        }
        return kav.getValue().getClass();
    }

    public static Class<?> getParamMetaClass(ParameterMetadata parMeta) {
        try {
            Class<?> primitiveClass;
            String className = parMeta.type.getName();
            if (StringUtil.isNullOrEmpty((String)className)) {
                className = ((TypeNameImpl)parMeta.type).getWsdlName();
            }
            if ((primitiveClass = ProcessUtil.convertToPrimitiveOrStringClass(className)) != null) {
                return primitiveClass;
            }
            return Class.forName(className);
        }
        catch (Exception e) {
            _logger.error((Object)"getParamMetaClass failed", (Throwable)e);
            return null;
        }
    }

    public static PolicyOptionMetadata getActivePolicyOptionMeta(Policy policy, PolicyMetadata meta) {
        if (!ProcessUtil.hasValidOptionId(policy)) {
            return null;
        }
        if (!ProcessUtil.hasValidPossibleOption(meta)) {
            return null;
        }
        String policyOptionId = policy.policyOption.id;
        for (PolicyOptionMetadata pom : meta.possibleOption) {
            if (!ProcessUtil.hasValidIdKey(pom) || !policyOptionId.equalsIgnoreCase(pom.id.key)) continue;
            return pom;
        }
        return null;
    }

    public static ProfileWrapper addCategoriesAndComponents(ProfileWrapper wrapper, ProfileCategoryMetadata[] categoryMeta, ProfileComponentMetadata[] componentMeta) {
        try {
            CategoryMetadataAdapter categoryMetaAdapter = new CategoryMetadataAdapter(categoryMeta, componentMeta);
            ProfileGrouper grouper = ProfileGrouper.createCategoryGrouper(categoryMetaAdapter);
            return grouper.group(wrapper);
        }
        catch (Exception e) {
            String errorMsg = "addCategoriesAndComponents(...) failed";
            if (wrapper != null) {
                errorMsg = "addCategoriesAndComponents(...) failed for ProfileWrapper " + wrapper.toString();
            }
            _logger.error((Object)errorMsg, (Throwable)e);
            return wrapper;
        }
    }

    public static String getAdjustedProfileName(Field f, String name) {
        if (f == null) {
            return name;
        }
        String result = name;
        if (f.getName().toLowerCase().contains("ConsoleIpRouteConfig".toLowerCase())) {
            result = String.format("%s %s", HostProfileUtils.getLocalizedString("editProfile.adjustedNames.ConsoleIpRouteConfig"), name);
        } else if (f.getName().toLowerCase().contains("MutualCHAPProfile".toLowerCase())) {
            result = String.format("%s %s", HostProfileUtils.getLocalizedString("editProfile.adjustedNames.MutualCHAPProfile"), name);
        }
        return result;
    }

    public static Object extractParam(ApplyProfile profile, String policyId, String paramId) {
        if (profile == null || profile.policy == null || policyId == null || paramId == null) {
            return null;
        }
        for (Policy policy : profile.policy) {
            if (!ProcessUtil.hasValidOptionParam(policy) || !policyId.equalsIgnoreCase(policy.id)) continue;
            for (KeyAnyValue param : policy.policyOption.parameter) {
                if (!ProcessUtil.isValidKeyAnyValue(param) || !paramId.equalsIgnoreCase(param.getKey())) continue;
                return param.getValue();
            }
        }
        return null;
    }

    public static String getParamByKey(Policy policy, String key) {
        if (StringUtil.isNullOrEmpty((String)key) || !ProcessUtil.hasValidOptionParam(policy)) {
            return "";
        }
        for (KeyAnyValue param : policy.policyOption.parameter) {
            if (!ProcessUtil.isValidKeyAnyValue(param) || !key.equalsIgnoreCase(param.getKey())) continue;
            return param.getValue().toString();
        }
        return "";
    }

    public static List<ProfileUpdateFailed.UpdateFailure> extractProfileUpdateFailures(String profilePath, ProfileUpdateFailed updateFailure, List<ProfileWrapper> policies) {
        if (updateFailure == null) {
            return new ArrayList<ProfileUpdateFailed.UpdateFailure>();
        }
        List<ProfileUpdateFailed.UpdateFailure> allFailures = ProcessUtil.getUpdateFailureMatchingPath(updateFailure, profilePath);
        if (policies != null && !StringUtil.isNullOrEmpty((String)profilePath) && allFailures.size() == 0 && profilePath.startsWith(ADVANCED_OPTION_PROFILE_KEY_PREFIX)) {
            for (ProfileWrapper elem : policies) {
                Policy policy = (Policy)elem.obj;
                List<ProfileUpdateFailed.UpdateFailure> failures = ProcessUtil.getAdvancedOptionUpdateFailure(profilePath, policy, updateFailure);
                allFailures.addAll(failures);
            }
        }
        return allFailures;
    }

    public static String getUpdateFailureKey(ProfileUpdateFailed.UpdateFailure failure) {
        if (failure == null || failure.profilePath == null) {
            return "";
        }
        StringBuilder updateFailureKey = new StringBuilder();
        return updateFailureKey.append(failure.profilePath.getProfilePath()).append(failure.profilePath.getPolicyId()).append(failure.profilePath.getParameterId()).toString();
    }

    private static String getPolicyParameterKeyValue(Policy policy) {
        if (policy == null || policy.getPolicyOption() == null) {
            return null;
        }
        KeyAnyValue[] parameters = policy.getPolicyOption().getParameter();
        if (parameters == null) {
            return null;
        }
        for (KeyAnyValue parameter : parameters) {
            if (!"key".equalsIgnoreCase(parameter.getKey())) continue;
            return parameter.getValue().toString();
        }
        return null;
    }

    private static List<ProfileUpdateFailed.UpdateFailure> getAdvancedOptionUpdateFailure(String profilePath, Policy policy, ProfileUpdateFailed updateFailure) {
        String parameterKeyValue = ProcessUtil.getPolicyParameterKeyValue(policy);
        if (parameterKeyValue == null) {
            return new ArrayList<ProfileUpdateFailed.UpdateFailure>();
        }
        String keyValue = parameterKeyValue.replace(".", "_").replace(" ", "");
        String newProfilePath = String.format(ADVANCED_OPTION_PROFILE_KEY_FORMAT, keyValue);
        if (newProfilePath.equals(profilePath)) {
            return new ArrayList<ProfileUpdateFailed.UpdateFailure>();
        }
        return ProcessUtil.getUpdateFailureMatchingPath(updateFailure, newProfilePath);
    }

    private static List<ProfileUpdateFailed.UpdateFailure> getUpdateFailureMatchingPath(ProfileUpdateFailed updateFailure, String path) {
        ProfileUpdateFailed.UpdateFailure[] failures;
        ArrayList<ProfileUpdateFailed.UpdateFailure> aList = new ArrayList<ProfileUpdateFailed.UpdateFailure>();
        if (ProcessUtil.isEmptyFailure(updateFailure)) {
            return aList;
        }
        if (StringUtil.isNullOrEmpty((String)path)) {
            return aList;
        }
        for (ProfileUpdateFailed.UpdateFailure fail : failures = updateFailure.getFailure()) {
            ProfilePropertyPath profiPath = fail.profilePath;
            if (ProcessUtil.isEmptyPath(profiPath) || !ProcessUtil.doesPathMatchProfilePath(path, profiPath)) continue;
            aList.add(fail);
        }
        return aList;
    }

    private static boolean doesPathMatchProfilePath(String path, ProfilePropertyPath profiPath) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            return false;
        }
        return path.endsWith(profiPath.profilePath);
    }

    private static boolean isEmptyFailure(ProfileUpdateFailed updateFailure) {
        return updateFailure == null || updateFailure.getFailure() == null || updateFailure.getFailure().length == 0;
    }

    private static boolean isEmptyPath(ProfilePropertyPath path) {
        return path == null || StringUtil.isNullOrEmpty((String)path.profilePath);
    }
}

