/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ProfileMetadata;
import com.vmware.vsphere.client.hostprofile.impl.ProcessUtil;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfileComparator
implements Comparator<ApplyProfile> {
    private static final Log _logger = LogFactory.getLog(ProfileComparator.class);
    private ProfileMetadata _meta;

    public static ProfileComparator getInstance(ProfileMetadata meta) {
        if (!ProfileComparator.canCreateComparatorFromMeta(meta)) {
            return null;
        }
        return new ProfileComparator(meta);
    }

    private ProfileComparator(ProfileMetadata meta) {
        this._meta = meta;
    }

    @Override
    public int compare(ApplyProfile profile1, ApplyProfile profile2) {
        assert (ProfileComparator.canCreateComparatorFromMeta(this._meta));
        int result = 0;
        int index = 0;
        while (result == 0 && index < this._meta.sortSpec.length) {
            ProfileMetadata.ProfileSortSpec spec = this._meta.sortSpec[index++];
            Object param1 = ProcessUtil.extractParam(profile1, spec.policyId, spec.parameter);
            Object param2 = ProcessUtil.extractParam(profile2, spec.policyId, spec.parameter);
            if (param1 == null && param2 == null) {
                result = 0;
                continue;
            }
            if (!(param1 instanceof Comparable) || !(param2 instanceof Comparable)) {
                result = 0;
                continue;
            }
            try {
                result = ((Comparable)param1).compareTo(param2);
            }
            catch (ClassCastException exc) {
                _logger.error((Object)"Incomparable policy parameters", (Throwable)exc);
                result = 0;
            }
        }
        return result;
    }

    private static boolean canCreateComparatorFromMeta(ProfileMetadata meta) {
        return meta != null && meta.sortSpec != null && meta.sortSpec.length > 0;
    }
}

