/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.PolicyOptionMetadata;
import com.vmware.vim.binding.vim.profile.ProfilePropertyPath;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.hostprofile.data.ProfilePropertyPathRelation;
import java.util.ArrayList;
import java.util.List;

public final class RelationsUtil {
    private RelationsUtil() {
    }

    public static List<ProfilePropertyPathRelation> retrieveRelations(PolicyMetadata[] policyMeta) {
        ArrayList<ProfilePropertyPathRelation> allRelations = new ArrayList<ProfilePropertyPathRelation>();
        if (!ArrayUtil.isNullOrEmpty((Object[])policyMeta)) {
            for (PolicyMetadata policyMetaData : policyMeta) {
                Object[] policyOptionMeta = policyMetaData.possibleOption;
                if (ArrayUtil.isNullOrEmpty((Object[])policyOptionMeta)) continue;
                for (Object policyOptionMetadata : policyOptionMeta) {
                    Object[] parameterMeta = ((PolicyOptionMetadata)policyOptionMetadata).parameter;
                    if (ArrayUtil.isNullOrEmpty((Object[])parameterMeta)) continue;
                    List<ProfilePropertyPathRelation> paramRelation = RelationsUtil.getParameterRelations((ParameterMetadata[])parameterMeta, ParameterMetadata.RelationType.dynamic_relation, policyMetaData.id.key, ((PolicyOptionMetadata)policyOptionMetadata).id.key);
                    allRelations.addAll(paramRelation);
                }
            }
        }
        return allRelations;
    }

    private static List<ProfilePropertyPathRelation> getParameterRelations(ParameterMetadata[] parameterMeta, ParameterMetadata.RelationType relationType, String policyId, String policyOptionId) {
        ArrayList<ProfilePropertyPathRelation> relations = new ArrayList<ProfilePropertyPathRelation>();
        if (!ArrayUtil.isNullOrEmpty((Object[])parameterMeta)) {
            for (ParameterMetadata parameterMetadata : parameterMeta) {
                if (ArrayUtil.isNullOrEmpty((Object[])parameterMetadata.parameterRelations)) continue;
                for (ParameterMetadata.ParameterRelationMetadata relationMeta : parameterMetadata.parameterRelations) {
                    if (!RelationsUtil.relationHasType(relationMeta.relationTypes, relationType)) continue;
                    ProfilePropertyPath profilePropertyPath = new ProfilePropertyPath();
                    profilePropertyPath.policyId = policyId;
                    profilePropertyPath.policyOptionId = policyOptionId;
                    profilePropertyPath.parameterId = parameterMetadata.id.key;
                    ProfilePropertyPathRelation profilePropertyPathRelation = new ProfilePropertyPathRelation();
                    profilePropertyPathRelation.profilePropertyPath = profilePropertyPath;
                    profilePropertyPathRelation.parameterRelationMetadata = relationMeta;
                    relations.add(profilePropertyPathRelation);
                }
            }
        }
        return relations;
    }

    private static boolean relationHasType(String[] relationTypes, ParameterMetadata.RelationType expectedRelationType) {
        boolean exists = false;
        for (String relationType : relationTypes) {
            if (!expectedRelationType.name().equals(relationType)) continue;
            exists = true;
            break;
        }
        return exists;
    }
}

