/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ApplyProfileProperty;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.impl.MissingTypeUtil;
import com.vmware.vsphere.client.hostprofile.impl.ProfileGrouper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class Unwrapper {
    private Unwrapper() {
    }

    public static HostApplyProfile unwrap(ProfileWrapper wrap) throws Exception {
        if (wrap == null) {
            return null;
        }
        ProfileGrouper.ungroup(wrap);
        return (HostApplyProfile)Unwrapper.unwrapInternal(HostApplyProfile.class, wrap);
    }

    private static <T extends ApplyProfile> Object unwrapInternal(Class<?> targetType, ProfileWrapper wrap) throws Exception {
        Field[] fields;
        Object result = Unwrapper.getWrapperObject(targetType, wrap);
        for (Field field : fields = targetType.getFields()) {
            if (Unwrapper.isSingleProfileField(field)) {
                ApplyProfile ap = Unwrapper.unwrapApplyProfile(field.getType(), wrap, field.getName());
                field.set(result, ap);
                continue;
            }
            if (Unwrapper.isProfileArrayField(field)) {
                ApplyProfile[] apArray = Unwrapper.unwrapApplyProfileArray(field.getType().getComponentType(), (ProfileWrapper)wrap);
                field.set(result, apArray);
                continue;
            }
            if (!Unwrapper.isPropertyArrayField(field)) continue;
            ApplyProfileProperty[] propArray = Unwrapper.unwrapPropertyArray(wrap);
            field.set(result, propArray);
        }
        MissingTypeUtil.restoreMissingTypes(result, wrap.missingTypeData);
        return result;
    }

    private static ApplyProfileProperty[] unwrapPropertyArray(ProfileWrapper wrap) throws Exception {
        ArrayList<ApplyProfileProperty> result = new ArrayList<ApplyProfileProperty>();
        for (ProfileWrapper child : wrap.children) {
            if (ProfileWrapper.isSingleProperty(child)) {
                ApplyProfile ap = (ApplyProfile)Unwrapper.unwrapInternal(ApplyProfile.class, child);
                ApplyProfileProperty singleProperty = new ApplyProfileProperty();
                singleProperty.array = false;
                singleProperty.profile = new ApplyProfile[]{ap};
                singleProperty.propertyName = child.propertyName;
                result.add(singleProperty);
                continue;
            }
            if (!ProfileWrapper.isArrayProperty(child)) continue;
            ApplyProfileProperty arrayProperty = new ApplyProfileProperty();
            arrayProperty.array = true;
            arrayProperty.profile = Unwrapper.getProperties(child);
            arrayProperty.propertyName = child.propertyName;
            result.add(arrayProperty);
        }
        return (ApplyProfileProperty[])Unwrapper.convertToArray(result, ApplyProfileProperty.class);
    }

    private static <T extends ApplyProfile> T[] unwrapApplyProfileArray(Class<?> targetType, ProfileWrapper wrap) throws Exception {
        ArrayList<ApplyProfile> result = new ArrayList<ApplyProfile>();
        for (ProfileWrapper child : wrap.children) {
            ProfileWrapper firstGrandChild;
            if (!ProfileWrapper.isProfileArray(child) || (firstGrandChild = Unwrapper.getFirstChild(child)) == null || firstGrandChild.obj == null || !targetType.equals(firstGrandChild.obj.getClass())) continue;
            for (ProfileWrapper grandChild : child.children) {
                ApplyProfile ap = (ApplyProfile)Unwrapper.unwrapInternal(targetType, grandChild);
                result.add(ap);
            }
        }
        return (ApplyProfile[])Unwrapper.convertToArray(result, targetType);
    }

    private static ApplyProfile unwrapApplyProfile(Class<?> targetType, ProfileWrapper wrap, String fieldName) throws Exception {
        if (wrap == null || targetType == null) {
            return null;
        }
        for (ProfileWrapper child : wrap.children) {
            if (child.obj == null || !child.obj.getClass().equals(targetType) || !fieldName.equalsIgnoreCase(child.arrayFieldName)) continue;
            return (ApplyProfile)Unwrapper.unwrapInternal(targetType, child);
        }
        return null;
    }

    private static ApplyProfile[] getProperties(ProfileWrapper wrap) throws Exception {
        ArrayList<ApplyProfile> result = new ArrayList<ApplyProfile>();
        for (ProfileWrapper child : wrap.children) {
            ApplyProfile apChild = (ApplyProfile)Unwrapper.unwrapInternal(ApplyProfile.class, child);
            result.add(apChild);
        }
        return (ApplyProfile[])Unwrapper.convertToArray(result, ApplyProfile.class);
    }

    private static Object getWrapperObject(Class<?> targetType, ProfileWrapper wrap) throws Exception {
        if (wrap.obj != null && targetType.isAssignableFrom(wrap.obj.getClass())) {
            return wrap.obj;
        }
        return targetType.newInstance();
    }

    private static <T> T[] convertToArray(List<T> list, Class<?> clazz) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(result);
    }

    private static ProfileWrapper getFirstChild(ProfileWrapper parent) {
        if (parent == null) {
            return null;
        }
        if (parent.children == null || parent.children.size() == 0) {
            return null;
        }
        return parent.children.get(0);
    }

    private static boolean isProfileArrayField(Field field) {
        if (field == null) {
            return false;
        }
        if (!field.getType().isArray()) {
            return false;
        }
        return ApplyProfile.class.isAssignableFrom(field.getType().getComponentType());
    }

    private static boolean isSingleProfileField(Field field) {
        if (field == null) {
            return false;
        }
        return ApplyProfile.class.isAssignableFrom(field.getType());
    }

    private static boolean isPropertyArrayField(Field field) {
        if (field == null) {
            return false;
        }
        if (!field.getType().isArray()) {
            return false;
        }
        return ApplyProfileProperty.class.isAssignableFrom(field.getType().getComponentType());
    }
}

