/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl.hostcustomizations;

import com.vmware.vim.binding.vim.PasswordField;
import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.DeferredHostSettingTag;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeferredHostSettingsService {
    private static final Log logger = LogFactory.getLog(DeferredHostSettingsService.class);
    private static final String OBJECT = "object";
    private static final String REQUIRED = "required";
    private static final String PROPERTY_NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String VALUE = "value";
    private static final String STAR_PREFIX = "* ";

    DeferredPolicyOptionParameter[] createDeferredPolicyOptionParameter(Object[] rowsData, String hostName) {
        DeferredPolicyOptionParameter[] results = null;
        block0: for (Object rowObject : rowsData) {
            if (!(rowObject instanceof DynamicObject)) {
                logger.warn((Object)("Unknown row object: " + rowObject));
                continue;
            }
            DynamicObject row = (DynamicObject)rowObject;
            NameValuePair[] nameValuePairArray = row.properties;
            int n = nameValuePairArray.length;
            for (int i = 0; i < n; ++i) {
                NameValuePair valuePair = nameValuePairArray[i];
                if (!OBJECT.equals(valuePair.name) || !hostName.equals(valuePair.value) || !(row.tag instanceof DeferredHostSettingTag)) continue;
                results = ((DeferredHostSettingTag)((Object)row.tag)).deferredSettings;
                break block0;
            }
        }
        if (results == null) {
            return null;
        }
        for (DeferredPolicyOptionParameter deferredParameter : results) {
            for (KeyAnyValue valuePair : deferredParameter.parameter) {
                Object userValue = this.findPropertyValue(rowsData, hostName, valuePair.getKey(), deferredParameter.getInputPath().policyId, deferredParameter.getInputPath().profilePath);
                this.fromFlexObject(valuePair, userValue);
            }
        }
        return results;
    }

    private Object findPropertyValue(Object[] rows, String object, String propertyName, String policyId, String propertyPath) {
        String uniqueRowIdentifier = HostCustomizationsUtil.buildRowPrimaryKey(object, propertyName, policyId, propertyPath);
        for (Object rowObject : rows) {
            if (!(rowObject instanceof DynamicObject)) {
                logger.warn((Object)("Unknown row object: " + rowObject));
                continue;
            }
            DynamicObject row = (DynamicObject)rowObject;
            if (!uniqueRowIdentifier.equals(row.key)) continue;
            for (NameValuePair valuePair : row.properties) {
                if (!VALUE.equals(valuePair.name)) continue;
                return valuePair.value;
            }
        }
        logger.warn((Object)String.format("Cannot find host setting value for a %s.%s", object, propertyName));
        return null;
    }

    private void fromFlexObject(KeyAnyValue keyValue, Object userValue) {
        if (userValue != null) {
            if (keyValue.getValue() instanceof PasswordField) {
                userValue = new PasswordField(userValue.toString());
            }
            keyValue.setValue(userValue);
        }
    }

    Collection<DynamicObject> extractDeferredHostSettings(String hostName, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, DeferredPolicyOptionParameter[] newDeferredSettings, DeferredPolicyOptionParameter[] oldDeferredSettings) {
        Map<String, Map<String, Object>> oldDeferredHostSettingsValuesMap = this.extractDeferredHostSettingValues(oldDeferredSettings);
        LinkedList<DynamicObject> resultList = new LinkedList<DynamicObject>();
        if (newDeferredSettings.length == 0) {
            DynamicObject deferredParam = new DynamicObject();
            deferredParam.properties = new NameValuePair[]{new NameValuePair(REQUIRED, (Object)""), new NameValuePair(OBJECT, (Object)hostName), new NameValuePair(PROPERTY_NAME, (Object)""), new NameValuePair(DESCRIPTION, (Object)""), new NameValuePair(VALUE, (Object)"")};
            DeferredHostSettingTag tag = new DeferredHostSettingTag();
            tag.deferredSettings = newDeferredSettings;
            deferredParam.key = HostCustomizationsUtil.buildRowPrimaryKey(hostName, "", "", "");
            deferredParam.tag = tag;
            resultList.add(deferredParam);
        }
        boolean executeResultPassed = false;
        for (DeferredPolicyOptionParameter param : newDeferredSettings) {
            String relevantProfilePath;
            PolicyMetadata metadata = HostCustomizationsUtil.getPolicyMetadata(policiesMetadata, param);
            if (metadata == null || (relevantProfilePath = HostCustomizationsUtil.extractRelevantPath(relevantProfilePaths, param.getInputPath().profilePath)) == null) continue;
            PolicyMetadata localizedPolicyMetadata = HostProfileUtils.getLocalizedPolicyMetadata(metadata);
            relevantProfilePath = String.format("%s > %s", relevantProfilePath, localizedPolicyMetadata.id.label);
            Map<String, Object> oldValuesMap = oldDeferredHostSettingsValuesMap.get(param.getInputPath().profilePath);
            for (KeyAnyValue keyValue : param.parameter) {
                ParameterMetadata userInputParameter = HostCustomizationsUtil.getParameterMetadata(metadata.possibleOption, keyValue.getKey());
                if (userInputParameter == null) continue;
                ParameterMetadata localizedParameterMetadata = HostProfileUtils.getLocalizedParameterMetadata(userInputParameter);
                DynamicObject deferredParam = new DynamicObject();
                String requiredColumnValue = userInputParameter.isOptional() ? HostProfileUtils.getLocalizedString("deferredSettings.column.valueNotRequired") : HostProfileUtils.getLocalizedString("deferredSettings.column.valueRequired");
                boolean isValueUpdated = false;
                Object propertyValue = this.toFlexObject(keyValue);
                if (oldDeferredSettings != null) {
                    isValueUpdated = oldValuesMap == null ? true : this.isDeferredSettingValueUpdated(oldValuesMap.get(keyValue.getKey()), propertyValue);
                }
                String propertyName = isValueUpdated ? STAR_PREFIX + localizedParameterMetadata.id.label : localizedParameterMetadata.id.label;
                deferredParam.properties = new NameValuePair[]{new NameValuePair(REQUIRED, (Object)requiredColumnValue), new NameValuePair(OBJECT, (Object)hostName), new NameValuePair(PROPERTY_NAME, (Object)propertyName), new NameValuePair(DESCRIPTION, (Object)relevantProfilePath), new NameValuePair(VALUE, propertyValue)};
                deferredParam.key = HostCustomizationsUtil.buildRowPrimaryKey(hostName, keyValue.getKey(), param.getInputPath().policyId, param.getInputPath().profilePath);
                if (!executeResultPassed) {
                    DeferredHostSettingTag tag = new DeferredHostSettingTag();
                    tag.deferredSettings = newDeferredSettings;
                    deferredParam.tag = tag;
                    executeResultPassed = true;
                }
                resultList.add(deferredParam);
            }
        }
        return resultList;
    }

    private Object toFlexObject(KeyAnyValue keyValue) {
        Object returnValue = keyValue.getValue();
        if (returnValue instanceof PasswordField) {
            returnValue = ((PasswordField)returnValue).getValue();
        }
        return returnValue;
    }

    private boolean isDeferredSettingValueUpdated(Object oldPropertyValue, Object newPropertyValue) {
        if (oldPropertyValue == null) {
            return newPropertyValue != null;
        }
        return !oldPropertyValue.equals(newPropertyValue);
    }

    private Map<String, Map<String, Object>> extractDeferredHostSettingValues(DeferredPolicyOptionParameter[] deferredSettings) {
        HashMap<String, Map<String, Object>> deferredParameters = new HashMap<String, Map<String, Object>>();
        if (deferredSettings == null || deferredSettings.length == 0) {
            return deferredParameters;
        }
        for (DeferredPolicyOptionParameter param : deferredSettings) {
            String profilePath = param.getInputPath().profilePath;
            HashMap<String, Object> parameterValuesByKey = (HashMap<String, Object>)deferredParameters.get(profilePath);
            if (parameterValuesByKey == null) {
                parameterValuesByKey = new HashMap<String, Object>();
                deferredParameters.put(profilePath, parameterValuesByKey);
            }
            for (KeyAnyValue keyValue : param.parameter) {
                parameterValuesByKey.put(keyValue.getKey(), this.toFlexObject(keyValue));
            }
        }
        return deferredParameters;
    }

    void extractDeferredSettingsMetadata(ArrayList<PropertyNodeDescriptor> resultList, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, DeferredPolicyOptionParameter[] params) {
        for (DeferredPolicyOptionParameter param : params) {
            PolicyMetadata policyMetadata = HostCustomizationsUtil.getPolicyMetadata(policiesMetadata, param);
            if (policyMetadata == null) {
                logger.warn((Object)("Skip irelevant profile path with vCenter Server version: " + param.getInputPath().policyId));
                continue;
            }
            String relevantProfilePath = HostCustomizationsUtil.extractRelevantPath(relevantProfilePaths, param.getInputPath().profilePath);
            if (relevantProfilePath == null) {
                logger.warn((Object)("Skip irelevant profile path with current profile instance: " + param.getInputPath().policyId));
                continue;
            }
            for (KeyAnyValue keyValue : param.parameter) {
                ParameterMetadata parameterMetadata = HostCustomizationsUtil.getParameterMetadata(policyMetadata.possibleOption, keyValue.getKey());
                if (parameterMetadata == null) {
                    logger.warn((Object)("Cannot find a deferred parameter metadata for key: " + keyValue.getKey()));
                    continue;
                }
                ParameterMetadata localizedParameterMetadata = HostProfileUtils.getLocalizedParameterMetadata(parameterMetadata);
                String propertyDescription = localizedParameterMetadata.id.summary;
                String propertyType = HostProfileUtils.getResourceFWType(localizedParameterMetadata.getType().getName(), keyValue.getValue());
                TypeNodeDescriptor typeDescriptor = new TypeNodeDescriptor();
                typeDescriptor.properties = new PropertyNodeDescriptor[]{this.getPropertyRequiredMetadata(), this.getObjectMetadata(null), this.getPropertyNameMetadata(propertyDescription), this.getDescriptionMetadata(null), this.getValueMetadata(propertyDescription, propertyType, parameterMetadata.isOptional())};
                PropertyNodeDescriptor rowDescriptor = new PropertyNodeDescriptor();
                rowDescriptor.name = Integer.toString(resultList.size());
                rowDescriptor.valueType = typeDescriptor;
                resultList.add(rowDescriptor);
            }
        }
    }

    private PropertyNodeDescriptor getObjectMetadata(String description) {
        PropertyNodeDescriptor pdObject = new PropertyNodeDescriptor();
        pdObject.name = OBJECT;
        pdObject.title = HostProfileUtils.getLocalizedString("deferredSettings.column.object");
        pdObject.description = description;
        pdObject.valueTypeName = "string";
        pdObject.immutable = true;
        return pdObject;
    }

    private PropertyNodeDescriptor getPropertyNameMetadata(String description) {
        PropertyNodeDescriptor pdName = new PropertyNodeDescriptor();
        pdName.name = PROPERTY_NAME;
        pdName.title = HostProfileUtils.getLocalizedString("deferredSettings.column.propertyName");
        pdName.description = description;
        pdName.valueTypeName = "string";
        pdName.immutable = true;
        return pdName;
    }

    private PropertyNodeDescriptor getPropertyRequiredMetadata() {
        PropertyNodeDescriptor pdName = new PropertyNodeDescriptor();
        pdName.name = REQUIRED;
        pdName.title = HostProfileUtils.getLocalizedString("deferredSettings.column.propertyRequired");
        pdName.valueTypeName = "string";
        pdName.immutable = true;
        return pdName;
    }

    private PropertyNodeDescriptor getDescriptionMetadata(String description) {
        PropertyNodeDescriptor pdDesc = new PropertyNodeDescriptor();
        pdDesc.name = DESCRIPTION;
        pdDesc.title = HostProfileUtils.getLocalizedString("deferredSettings.column.propertyDescription");
        pdDesc.description = description;
        pdDesc.valueTypeName = "string";
        pdDesc.immutable = true;
        return pdDesc;
    }

    private PropertyNodeDescriptor getValueMetadata(String description, String propertyType, boolean isOptional) {
        PropertyNodeDescriptor pdValue = new PropertyNodeDescriptor();
        pdValue.name = VALUE;
        pdValue.title = HostProfileUtils.getLocalizedString("deferredSettings.column.propertyValue");
        pdValue.description = description;
        pdValue.valueTypeName = propertyType;
        pdValue.isOptional = isOptional;
        if ("password".equals(propertyType)) {
            pdValue.tags = new HashMap();
            pdValue.tags.put("createPassword", "true");
        }
        return pdValue;
    }
}

