/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl.hostcustomizations;

import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.profile.DeferredPolicyOptionParameter;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.host.AnswerFile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.data.common.DynamicObject;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.DeferredHostSettingsSpec;
import com.vmware.vsphere.client.hostprofile.data.HostCustomizationImportException;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.HostCustomizationsService;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.DeferredPolicyOptionData;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.DeferredPolicyOptionDataImpl;
import com.vmware.vsphere.client.hostprofile.impl.hostcustomizations.data.HostCustomizationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostCustomizationsImportService {
    private static final String CSV_CUSTOMIZATION_FORMAT = "csv";
    private static final Log logger = LogFactory.getLog(HostCustomizationsImportService.class);
    private final HostCustomizationsService service;
    private final TaskMonitor taskMonitor;

    public HostCustomizationsImportService(HostCustomizationsService service, TaskMonitor taskMonitor) {
        this.service = service;
        this.taskMonitor = taskMonitor;
    }

    public HostCustomizationData importHostCustomizations(ManagedObjectReference profileRef, DeferredHostSettingsSpec spec, Map<String, String> relevantProfilePaths, PolicyMetadata[] policiesMetadata) throws Exception {
        ProfileManager profileManager = HostProfileUtils.getProfileManager(profileRef.getServerGuid());
        ProfileManager.CustomizationData customizationData = this.createCustomizationData(spec.formattedCustomizations);
        DeferredPolicyOptionData importedData = this.invokeImportHostCustomizations(profileRef, spec.forceValidationOnHosts, profileManager, customizationData);
        DynamicObject[] deferredSettings = this.getDeferredHostSettingsFromImportResults(importedData.getUserInputMap(), policiesMetadata, relevantProfilePaths, spec.forceValidationOnHosts, spec.currentHostCustomizations);
        return new ImportHostCustomizationsResult(importedData, deferredSettings);
    }

    public DeferredPolicyOptionData importH5HostCustomizations(ManagedObjectReference profileRef, ManagedObjectReference[] hosts, String hostCustomizationsCsvString) throws Exception {
        ProfileManager profileManager = HostProfileUtils.getProfileManager(profileRef.getServerGuid());
        ProfileManager.CustomizationData customizationData = this.createCustomizationData(hostCustomizationsCsvString);
        return this.invokeImportHostCustomizations(profileRef, hosts, profileManager, customizationData);
    }

    private DeferredPolicyOptionData invokeImportHostCustomizations(ManagedObjectReference hpRef, ManagedObjectReference[] entities, ProfileManager profileManager, ProfileManager.CustomizationData customizationData) throws Exception {
        ManagedObjectReference taskRef;
        HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]> cachedResults = new HashMap<ManagedObjectReference, DeferredPolicyOptionParameter[]>();
        ArrayList<Exception> faults = new ArrayList<Exception>();
        try {
            taskRef = profileManager.importCustomizations(customizationData, Boolean.valueOf(false), Boolean.valueOf(false), hpRef, entities);
        }
        catch (Exception e) {
            logger.error((Object)"Import of the host customizations failed.", (Throwable)e);
            Exception exception = new Exception(HostProfileUtils.getLocalizedString("error.importCustomizations.method"));
            faults.add(exception);
            DeferredPolicyOptionDataImpl importedData = new DeferredPolicyOptionDataImpl(cachedResults, faults);
            return importedData;
        }
        TaskInfo taskInfo = this.taskMonitor.monitorTask(taskRef);
        if (taskInfo.error != null) {
            Exception exception = new Exception(HostProfileUtils.getLocalizedString("error.importCustomizations.operation"));
            faults.add(exception);
            MethodFault fault = MixedUtil.getMethodFault((Throwable)taskInfo.error);
            logger.error((Object)"Import host customizations task failed.", fault.getCause());
            faults.add((Exception)fault);
            DeferredPolicyOptionDataImpl importedData = new DeferredPolicyOptionDataImpl(cachedResults, faults);
            return importedData;
        }
        ProfileManager.ImportCustomizationsResult importResult = (ProfileManager.ImportCustomizationsResult)taskInfo.result;
        if (importResult != null && !ArrayUtil.isNullOrEmpty((Object[])importResult.entityResults)) {
            for (ProfileManager.ImportCustomizationsResult.EntityCustomizationsResult entity : importResult.entityResults) {
                AnswerFile answerFile = entity.customizations;
                if (answerFile == null) continue;
                cachedResults.put(entity.entity, answerFile.userInput);
            }
        }
        if (importResult != null && importResult.importIssues != null) {
            this.addImportIssues(importResult, faults);
        }
        DeferredPolicyOptionDataImpl importedData = new DeferredPolicyOptionDataImpl(cachedResults, faults);
        return importedData;
    }

    private void addImportIssues(ProfileManager.ImportCustomizationsResult importResult, List<Exception> importFaults) {
        HostCustomizationImportException importException = null;
        if (!ArrayUtil.isNullOrEmpty((Object[])importResult.importIssues.errors)) {
            importException = new HostCustomizationImportException();
            importException.errorMessages = importResult.importIssues.errors;
            importFaults.add(importException);
        }
        if (!ArrayUtil.isNullOrEmpty((Object[])importResult.importIssues.warnings)) {
            if (importException == null) {
                importException = new HostCustomizationImportException();
                importException.warningMessages = importResult.importIssues.warnings;
                importFaults.add(importException);
            } else {
                importException.warningMessages = importResult.importIssues.warnings;
            }
        }
    }

    private ProfileManager.CustomizationData createCustomizationData(String formattedCustomizations) {
        ProfileManager.CustomizationData customizationData = new ProfileManager.CustomizationData();
        customizationData.setCustomizationsFormat(CSV_CUSTOMIZATION_FORMAT);
        ProfileManager.FormattedCustomizations customizations = new ProfileManager.FormattedCustomizations();
        customizations.format = CSV_CUSTOMIZATION_FORMAT;
        customizations.formattedCustomizations = formattedCustomizations;
        customizationData.setEntityCustomizations(new ProfileManager.EntityCustomizations[]{customizations});
        return customizationData;
    }

    private DynamicObject[] getDeferredHostSettingsFromImportResults(Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> importResults, PolicyMetadata[] policiesMetadata, Map<String, String> relevantProfilePaths, ManagedObjectReference[] hosts, Object[] hostCustomizationsBeforeImport) throws Exception {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        Map<ManagedObjectReference, String> hostEntityNameMap = this.service.createHostEntityNameMap(hosts);
        Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> beforeImportCustomizationsMap = null;
        for (ManagedObjectReference host : hosts) {
            Collection<DynamicObject> result;
            String hostName = hostEntityNameMap.get(host);
            DeferredPolicyOptionParameter[] deferredParameters = importResults.get(host);
            if (beforeImportCustomizationsMap == null) {
                beforeImportCustomizationsMap = this.service.createDeferredPolicyOptionParameterMap(hostCustomizationsBeforeImport, hostEntityNameMap);
            }
            DeferredPolicyOptionParameter[] currentDeferredParameters = (DeferredPolicyOptionParameter[])beforeImportCustomizationsMap.get(host);
            if (deferredParameters != null) {
                result = this.service.extractDeferredHostSettings(hostName, policiesMetadata, relevantProfilePaths, deferredParameters, currentDeferredParameters);
                resultList.addAll(result);
                continue;
            }
            logger.warn((Object)("Can not extract imported deferred host settings on " + hostName));
            if (currentDeferredParameters == null) continue;
            result = this.service.extractDeferredHostSettings(hostName, policiesMetadata, relevantProfilePaths, currentDeferredParameters, null);
            importResults.put(host, currentDeferredParameters);
            resultList.addAll(result);
        }
        return resultList.toArray(new DynamicObject[resultList.size()]);
    }

    private class ImportHostCustomizationsResult
    implements HostCustomizationData {
        private final DynamicObject[] deferredHostSettings;
        private final Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> userInputMap;
        private final List<Exception> faults;

        @Override
        public DynamicObject[] getDeferredHostSettings() {
            return this.deferredHostSettings;
        }

        @Override
        public Map<ManagedObjectReference, DeferredPolicyOptionParameter[]> getUserInputMap() {
            return this.userInputMap;
        }

        @Override
        public List<Exception> getFaults() {
            return this.faults;
        }

        ImportHostCustomizationsResult(DeferredPolicyOptionData importedHostCustomizations, DynamicObject[] deferredHostSettings) {
            this.deferredHostSettings = deferredHostSettings;
            this.userInputMap = importedHostCustomizations.getUserInputMap() == null ? Collections.emptyMap() : importedHostCustomizations.getUserInputMap();
            this.faults = importedHostCustomizations.getFaults() == null ? Collections.emptyList() : importedHostCustomizations.getFaults();
        }
    }
}

