/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.logbundle;

import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreUtil;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.logbundle.LogBundleDownloadSpec;
import com.vmware.vsphere.client.logbundle.UrlZipEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.util.HashMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpZipEntry
extends UrlZipEntry {
    private static Log _logger = LogFactory.getLog(HttpZipEntry.class);
    private static final String MANIFEST_CHECK = "manifests";
    private static final String AUTH_COOKIE_PREFIX = "vmware_cgi_ticket=";
    private static final String VM_PARAM_NAME = "vm";
    private static final String ENCRYPT_PASSWORD_PARAM = "password";
    private final String _serviceUuid;
    private final KeyStore _keyStore;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final String _thumbprint;
    private String _vmPath = null;
    private String _encryptPassword = null;

    public HttpZipEntry(URI url, LogBundleDownloadSpec spec, KeyStore keyStore, SSLConfigurationProvider sslConfigProvider) {
        super(url);
        Validate.notNull((Object)sslConfigProvider);
        this._serviceUuid = spec.serviceUuid;
        this._keyStore = keyStore;
        this._sslConfigurationProvider = sslConfigProvider;
        if (spec.vcReference != null && StringUtil.isNullOrEmpty((String)spec.thumbprint)) {
            ManagedObjectReference vcRef = spec.vcReference;
            if (VcServiceUtil.is60VcOrLater((String)vcRef.getServerGuid())) {
                this._thumbprint = null;
                return;
            }
            VcService service = VimSessionUtil.getService((String)vcRef.getServerGuid());
            this._thumbprint = service.getThumbprint();
        } else {
            this._thumbprint = spec.thumbprint;
        }
    }

    public void setVmPath(String vmPath) {
        this._vmPath = vmPath;
    }

    public void setEncryptPassword(String encryptPassword) {
        this._encryptPassword = encryptPassword;
    }

    @Override
    protected InputStream connect(String clientId) throws IOException, Exception {
        String remoteUrl = this.url.toString();
        HashMap<String, String> params = null;
        HashMap<String, String> headers = null;
        if (remoteUrl.contains(MANIFEST_CHECK)) {
            _logger.debug((Object)"Building up authorization headers for HTTP connection");
            SessionManager.GenericServiceTicket ticket = VcServiceUtil.acquireGenericServiceTicketByClientId((String)clientId, (String)remoteUrl, (String)this._serviceUuid);
            headers = new HashMap<String, String>();
            headers.put("Cookie", AUTH_COOKIE_PREFIX + ticket.getId());
            params = new HashMap<String, String>();
            if (this._vmPath != null) {
                params.put(VM_PARAM_NAME, this._vmPath);
            }
            if (this._encryptPassword != null) {
                params.put(ENCRYPT_PASSWORD_PARAM, this._encryptPassword);
            }
            params.put("http.protocol.cookie-policy", "rfc2109");
        }
        HttpClient httpClient = null;
        if (StringUtil.isNullOrEmpty((String)this._thumbprint)) {
            KeyStore ks = this._keyStore;
            if (ks == null) {
                ks = KeystoreUtil.getKeyStore();
            }
            httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).addTrustStore(ks).socketReadTimeout(0).buildHttpClientIgnoreErrors();
        } else {
            httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).thumbprint(this._thumbprint).socketReadTimeout(0).buildHttpClientIgnoreErrors();
        }
        InputStream zipStream = httpClient.executeMethodResponseAsStream(remoteUrl, params, headers);
        this.contentLength = httpClient.getContentLength();
        return zipStream;
    }
}

