/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.filter;

import com.google.common.collect.Sets;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.h5.perspective.model.UiRestriction;
import com.vmware.vsphere.client.h5.perspective.services.PerspectiveService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PerspectiveFilter
implements ExtensionObjectFilter {
    private static final Log logger = LogFactory.getLog(PerspectiveFilter.class);
    private static final String DISABLED_EXTENSION_IDS_SESSION_KEY = "perspective";
    private final PerspectiveService perspectiveService;
    private final FeatureStateService featureStateService;

    public PerspectiveFilter(PerspectiveService perspectiveService, FeatureStateService featureStateService) {
        this.perspectiveService = perspectiveService;
        this.featureStateService = featureStateService;
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return new PropertyInfo[0];
    }

    public PropertyInfo[] getFilterProperties() {
        return new PropertyInfo[0];
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        try {
            if (!this.featureStateService.isEnabled(Feature.h5uiPerspectiveUi)) {
                return extensionInfos;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return extensionInfos;
        }
        Set<String> disabledExtensionIds = PerspectiveFilter.getDisabledExtensionIdsFromSession();
        if (disabledExtensionIds != null) {
            if (!disabledExtensionIds.isEmpty()) {
                return PerspectiveFilter.filterExtensions(extensionInfos, disabledExtensionIds);
            }
            return extensionInfos;
        }
        String activeUserUsername = PerspectiveFilter.getActiveUserUsernameFromSession();
        if (activeUserUsername == null || activeUserUsername.isEmpty()) {
            logger.warn((Object)"It seems there is no active session so the Perspective UI ExtensionObjectFilter will not be applied.");
            return extensionInfos;
        }
        try {
            UiRestriction uiRestriction = this.perspectiveService.loadUiRestrictionForAssignee(activeUserUsername);
            if (uiRestriction == null) {
                PerspectiveFilter.setEmptyDisabledExtensionIdsToSession();
                return extensionInfos;
            }
            disabledExtensionIds = uiRestriction.getDisabledExtensionIds();
            if (disabledExtensionIds == null || disabledExtensionIds.isEmpty()) {
                PerspectiveFilter.setEmptyDisabledExtensionIdsToSession();
                return extensionInfos;
            }
            PerspectiveFilter.setDisabledExtensionIdsToSession(disabledExtensionIds);
            return PerspectiveFilter.filterExtensions(extensionInfos, disabledExtensionIds);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Failed to load the perspective for assignee '%s'.", activeUserUsername), (Throwable)e);
            PerspectiveFilter.setEmptyDisabledExtensionIdsToSession();
            return extensionInfos;
        }
    }

    private static String getActiveUserUsernameFromSession() {
        return (String)SessionUtil.getData((String)"USER_NAME");
    }

    private static Set<String> getDisabledExtensionIdsFromSession() {
        return (Set)SessionUtil.getData((String)DISABLED_EXTENSION_IDS_SESSION_KEY);
    }

    private static void setDisabledExtensionIdsToSession(Set<String> disabledExtensionIds) {
        SessionUtil.setData((String)DISABLED_EXTENSION_IDS_SESSION_KEY, disabledExtensionIds);
    }

    private static void setEmptyDisabledExtensionIdsToSession() {
        SessionUtil.setData((String)DISABLED_EXTENSION_IDS_SESSION_KEY, (Object)Sets.newHashSet());
    }

    private static List<ExtensionInfo> filterExtensions(List<ExtensionInfo> extensionInfos, Set<String> disabledExtensionIds) {
        ArrayList<ExtensionInfo> filteredExtensions = new ArrayList<ExtensionInfo>();
        for (ExtensionInfo extensionInfo : extensionInfos) {
            if (disabledExtensionIds.contains(extensionInfo.getId())) continue;
            filteredExtensions.add(extensionInfo);
        }
        return filteredExtensions;
    }
}

