/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.mutation;

import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.h5.perspective.dataservice.DataServiceUtil;
import com.vmware.vsphere.client.h5.perspective.model.Assignment;
import com.vmware.vsphere.client.h5.perspective.model.AssignmentBase;
import com.vmware.vsphere.client.h5.perspective.services.PerspectiveService;
import com.vmware.vsphere.client.h5.perspective.spec.RemoveAssignmentSpec;
import com.vmware.vsphere.client.h5.perspective.util.DomainEntityId;
import com.vmware.vsphere.client.h5.perspective.util.PerspectiveUtil;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssignmentMutationProvider
implements MutationProvider {
    private static final Log logger = LogFactory.getLog(AssignmentMutationProvider.class);
    private final PerspectiveService perspectiveService;

    public AssignmentMutationProvider(PerspectiveService perspectiveService) {
        this.perspectiveService = perspectiveService;
    }

    public OperationResult add(AssignmentBase assignmentBase) {
        OperationResult operationResult = new OperationResult();
        try {
            Assignment userFacingAssignment = this.perspectiveService.saveAssignment(assignmentBase);
            operationResult.entity = DataServiceUtil.createUri(userFacingAssignment);
            operationResult.result = userFacingAssignment;
        }
        catch (Exception e) {
            operationResult.error = PerspectiveUtil.getMethodFault(e);
            logger.error((Object)e);
        }
        return operationResult;
    }

    @type(value="Assignment")
    public OperationResult remove(URI assignmentUri, RemoveAssignmentSpec removeAssignmentSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = assignmentUri;
        try {
            DomainEntityId domainEntityId = DataServiceUtil.getDomainEntityId(assignmentUri);
            if (domainEntityId == null) {
                logger.error((Object)String.format("Invalid URI '%s'.", assignmentUri));
                operationResult.error = PerspectiveUtil.getMethodFault(new IllegalArgumentException());
                return operationResult;
            }
            this.perspectiveService.deleteAssignment(domainEntityId.getEntityId());
            operationResult.result = true;
        }
        catch (Exception e) {
            operationResult.error = PerspectiveUtil.getMethodFault(e);
            logger.error((Object)e);
        }
        return operationResult;
    }
}

