/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vmware.vsphere.client.h5.perspective.services.JsonObjectMapper;
import java.io.IOException;
import java.lang.reflect.Array;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonObjectMapperImpl
implements JsonObjectMapper {
    private static final Log logger = LogFactory.getLog(JsonObjectMapperImpl.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public <T> T readValue(String content, Class<T> valueType) throws IOException {
        return (T)this.objectMapper.readValue(content, valueType);
    }

    @Override
    public String writeValueAsString(Object value) throws Exception {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new Exception(e);
        }
    }

    @Override
    public <E> E[] fromJsonString(String[] objectsAsJson, Class<E> type2) {
        Object[] entities = (Object[])Array.newInstance(type2, objectsAsJson.length);
        for (int i = 0; i < objectsAsJson.length; ++i) {
            try {
                entities[i] = this.objectMapper.readValue(objectsAsJson[i], type2);
                continue;
            }
            catch (IOException e) {
                logger.warn((Object)String.format("The following perspective JSON string could not be deserialized: '%s'.", objectsAsJson[i]), (Throwable)e);
            }
        }
        return entities;
    }
}

