/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.services;

import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.sso.PrincipalId;
import com.vmware.vim.binding.sso.admin.Group;
import com.vmware.vim.binding.sso.admin.PrincipalDiscoveryService;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.h5.perspective.services.PrincipalManagementService;
import com.vmware.vsphere.client.h5.perspective.util.PerspectiveUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrincipalManagementServiceImpl
implements PrincipalManagementService {
    private static final Log logger = LogFactory.getLog(PrincipalManagementServiceImpl.class);
    private final SsoServiceManager ssoServiceManager;

    PrincipalManagementServiceImpl(SsoServiceManager ssoServiceManager) {
        this.ssoServiceManager = ssoServiceManager;
    }

    @Override
    public String[] findNestedParentGroups(String assignee) {
        SsoAdminService ssoAdminService;
        String normalizedAssignee;
        PrincipalId principalId;
        block8: {
            principalId = PerspectiveUtil.toPrincipalId(assignee);
            if (principalId == null) {
                throw new IllegalArgumentException(String.format("Invalid principal: '%s'", assignee));
            }
            normalizedAssignee = PerspectiveUtil.normalizeAssignee(assignee);
            ssoAdminService = this.ssoServiceManager.getSolutionAdminService(null, SsoDomain.getLocal());
            if (ssoAdminService != null) break block8;
            logger.error((Object)"Cannot obtain the SsoAdminService.");
            return new String[]{normalizedAssignee};
        }
        try {
            PrincipalDiscoveryService principalDiscoveryService = ssoAdminService.getPrincipalDiscoveryService();
            if (principalDiscoveryService == null) {
                throw new IllegalStateException("Cannot obtain PrincipalDiscoveryService.");
            }
            Group[] parentGroups = principalDiscoveryService.findNestedParentGroups(principalId);
            String[] assignees = new String[parentGroups.length + 1];
            assignees[0] = normalizedAssignee;
            for (int i = 1; i < assignees.length; ++i) {
                assignees[i] = PerspectiveUtil.normalizeAssignee(PerspectiveUtil.toString(parentGroups[i - 1].getId()));
            }
            return assignees;
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
                return new String[]{normalizedAssignee};
            }
            catch (Exception e2) {
                logger.error((Object)"Cannot obtain the SsoAdminService.", (Throwable)e2);
                return new String[]{normalizedAssignee};
            }
        }
    }
}

