/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.tree;

import com.google.common.collect.Sets;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vsphere.client.h5.perspective.tree.ExtensionTreeBuilder;
import com.vmware.vsphere.client.h5.perspective.tree.PerspectiveTreeNode;
import com.vmware.vsphere.client.h5.perspective.tree.PerspectiveTreeNodeBuilderService;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerObjectViewExtensionTreeBuilder
implements ExtensionTreeBuilder {
    private static final Log logger = LogFactory.getLog(ServerObjectViewExtensionTreeBuilder.class);
    private static final String PERSPECTIVE_AVAILABILITY_TAG_NAME = "perspectivesAvailable";
    private static final String PERSPECTIVE_REQUIRES_HOSTED_EXTENSIONS_TAG_NAME = "requiresHostedExtensions";
    private static final Set<String> BLACKLISTED_EXTENSION_IDS = Sets.newHashSet((Object[])new String[]{"vsphere.core.dvs.nrp.view", "vsphere.core.folder.HostFolder.summaryView", "vsphere.core.folder.DatacenterFolder.summaryView", "vsphere.core.folder.VirtualMachineFolder.summaryView", "vsphere.core.folder.DatastoreFolder.summaryView", "vsphere.core.folder.NetworkFolder.summaryView", "vsphere.core.folder.datacenter.relatedDatacentersTab", "vsphere.core.folder.host.relatedHostsTab", "vsphere.core.folder.vm.relatedVMsTab", "vsphere.core.folder.network.relatedNetworksTab", "vsphere.core.folder.storage.datastoresTab"});
    private final ExtensionService extensionService;
    private final PerspectiveTreeNodeBuilderService perspectiveTreeNodeBuilderService;

    public ServerObjectViewExtensionTreeBuilder(ExtensionService extensionService, PerspectiveTreeNodeBuilderService perspectiveTreeNodeBuilderService) {
        this.extensionService = extensionService;
        this.perspectiveTreeNodeBuilderService = perspectiveTreeNodeBuilderService;
    }

    @Override
    public List<PerspectiveTreeNode> build(ExtensionInfo extensionInfo) {
        if (extensionInfo == null) {
            throw new IllegalArgumentException("ExtensionInfo is mandatory.");
        }
        ArrayDeque<TreeNodeInfo> queue = new ArrayDeque<TreeNodeInfo>();
        ArrayList<PerspectiveTreeNode> rootTreeNodes = new ArrayList<PerspectiveTreeNode>();
        logger.info((Object)String.format("Extension tree build process for '%s' started.", extensionInfo.getId()));
        queue.add(new TreeNodeInfo(extensionInfo, false, null));
        while (!queue.isEmpty()) {
            String[] hostedExtensionPointIds;
            TreeNodeInfo currentTreeNodeInfo = (TreeNodeInfo)queue.poll();
            if (currentTreeNodeInfo == null) continue;
            ExtensionInfo currentExtensionInfo = currentTreeNodeInfo.extensionInfo;
            PerspectiveTreeNode currentParentNode = currentTreeNodeInfo.parent;
            boolean isTransitivelyWhitelisted = false;
            PerspectiveTreeNode futureParentNode = currentParentNode;
            PerspectiveTreeNode currentNode = new PerspectiveTreeNode();
            boolean shouldPopulatePayload = false;
            if (this.isExtensionBlacklisted(currentExtensionInfo).booleanValue()) continue;
            if (this.isExtensionWhitelisted(currentExtensionInfo).booleanValue()) {
                if (currentParentNode == null) {
                    rootTreeNodes.add(currentNode);
                } else {
                    currentParentNode.addChild(currentNode);
                }
                isTransitivelyWhitelisted = true;
                futureParentNode = currentNode;
                shouldPopulatePayload = true;
            } else if (currentTreeNodeInfo.isTransitivelyWhitelisted) {
                currentParentNode.addChild(currentNode);
                futureParentNode = currentNode;
                shouldPopulatePayload = true;
            }
            if (shouldPopulatePayload) {
                currentNode.payload = new PerspectiveTreeNode.PerspectiveTreeNodePayload();
                this.perspectiveTreeNodeBuilderService.populateNode(currentNode.payload, currentExtensionInfo);
                currentNode.requiresChildren = this.areChildExtensionsRequired(currentExtensionInfo);
            }
            if ((hostedExtensionPointIds = currentExtensionInfo.getHostedPointsIds()) == null || hostedExtensionPointIds.length == 0) continue;
            for (String hostedExtensionPointId : hostedExtensionPointIds) {
                try {
                    ExtensionInfo[] extensionPointChildren;
                    for (ExtensionInfo childExtensionPoint : extensionPointChildren = this.extensionService.getExtensionInfos(hostedExtensionPointId)) {
                        queue.add(new TreeNodeInfo(childExtensionPoint, isTransitivelyWhitelisted, futureParentNode));
                    }
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Error while retrieving extension with id '%s'.", hostedExtensionPointId), (Throwable)e);
                }
            }
        }
        logger.info((Object)String.format("Extension tree build process for '%s' ended.", extensionInfo.getId()));
        return rootTreeNodes;
    }

    @Override
    public List<PerspectiveTreeNode> build(String extensionId) {
        try {
            ExtensionInfo extensionInfo = this.extensionService.getExtensionInfo(extensionId);
            return this.build(extensionInfo);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error while retrieving extension with id '%s'.", extensionId), (Throwable)e);
            return null;
        }
    }

    @Override
    public void prune(PerspectiveTreeNode root) {
        PerspectiveTreeNode node;
        ArrayDeque<PerspectiveTreeNode> result = new ArrayDeque<PerspectiveTreeNode>();
        ArrayDeque<PerspectiveTreeNode> queue = new ArrayDeque<PerspectiveTreeNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            node = (PerspectiveTreeNode)queue.pop();
            queue.addAll(node.children);
            result.add(node);
        }
        while (!result.isEmpty()) {
            node = (PerspectiveTreeNode)result.removeLast();
            ServerObjectViewExtensionTreeBuilder.tryToRemoveNode(node);
        }
    }

    private Boolean isExtensionBlacklisted(ExtensionInfo extensionInfo) {
        if (extensionInfo == null || extensionInfo.getId() == null) {
            return false;
        }
        return BLACKLISTED_EXTENSION_IDS.contains(extensionInfo.getId());
    }

    private Boolean isExtensionWhitelisted(ExtensionInfo extensionInfo) {
        Object metadataTagValue = extensionInfo.getMetadata().get(PERSPECTIVE_AVAILABILITY_TAG_NAME);
        return ServerObjectViewExtensionTreeBuilder.isMetadataTagValueTrue(metadataTagValue);
    }

    private Boolean areChildExtensionsRequired(ExtensionInfo extensionInfo) {
        Object metadataTagValue = extensionInfo.getMetadata().get(PERSPECTIVE_REQUIRES_HOSTED_EXTENSIONS_TAG_NAME);
        return ServerObjectViewExtensionTreeBuilder.isMetadataTagValueTrue(metadataTagValue);
    }

    private static Boolean isMetadataTagValueTrue(Object metadataTagValue) {
        if (metadataTagValue instanceof String) {
            return Boolean.valueOf((String)metadataTagValue);
        }
        if (metadataTagValue instanceof Boolean) {
            return (Boolean)metadataTagValue;
        }
        return false;
    }

    private static void tryToRemoveNode(PerspectiveTreeNode node) {
        if (node.children != null && !node.children.isEmpty()) {
            return;
        }
        if (node.requiresChildren && node.parent != null) {
            node.parent.removeChild(node);
            node.parent = null;
        }
    }

    private static class TreeNodeInfo {
        private ExtensionInfo extensionInfo;
        private boolean isTransitivelyWhitelisted;
        private PerspectiveTreeNode parent;

        private TreeNodeInfo(ExtensionInfo extensionInfo, boolean isTransitivelyWhiteListed, PerspectiveTreeNode parent) {
            this.extensionInfo = extensionInfo;
            this.isTransitivelyWhitelisted = isTransitivelyWhiteListed;
            this.parent = parent;
        }
    }
}

