/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.perspective.util;

import org.apache.commons.lang.StringUtils;

public class DomainEntityId {
    private static final String SEGMENT_DELIMITER = "/";
    private final String scopeId;
    private final String entityId;

    public DomainEntityId(String scopeId, String entityId) {
        this.scopeId = scopeId;
        this.entityId = entityId;
    }

    public static DomainEntityId fromString(String perspectiveIdAsString) {
        if (perspectiveIdAsString == null) {
            return null;
        }
        String[] segments = perspectiveIdAsString.split(SEGMENT_DELIMITER);
        if (segments.length != 2) {
            return null;
        }
        return new DomainEntityId(segments[0], segments[1]);
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public String toString() {
        if (this.scopeId == null || this.entityId == null) {
            return "";
        }
        return StringUtils.join((Object[])new String[]{this.scopeId, this.entityId}, (String)SEGMENT_DELIMITER);
    }
}

