/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.firewall;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.fault.HostConfigFault;
import com.vmware.vim.binding.vim.fault.NotFound;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.FirewallSystem;
import com.vmware.vim.binding.vim.host.Ruleset;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.host.firewall.spec.FirewallConfigurationSpec;
import com.vmware.vsphere.client.h5.host.firewall.spec.IpNetwork;
import com.vmware.vsphere.client.h5.host.firewall.spec.IpNetworkConfigurationSpec;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostFirewallMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(HostFirewallMutationProvider.class);

    public OperationResult apply(ManagedObjectReference hostRef, FirewallConfigurationSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            ConfigManager cm = host.getConfigManager();
            FirewallSystem fs = (FirewallSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cm.firewallSystem);
            if (spec.ipNetworkConfigurationSpec != null) {
                HostFirewallMutationProvider.updateFirewallIpSpec(fs, spec.ipNetworkConfigurationSpec);
            }
            if (spec.rulesetToEnabledState != null) {
                for (Map.Entry<String, Boolean> entry : spec.rulesetToEnabledState.entrySet()) {
                    String rulesetKey = entry.getKey();
                    boolean rulesetEnabled = entry.getValue();
                    if (rulesetEnabled) {
                        fs.enableRuleset(rulesetKey);
                        continue;
                    }
                    fs.disableRuleset(rulesetKey);
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Error while updating firewall config", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private static void updateFirewallIpSpec(FirewallSystem firewallSystem, Map<String, IpNetworkConfigurationSpec> ipNetworkSpec) throws NotFound, HostConfigFault {
        for (Map.Entry<String, IpNetworkConfigurationSpec> e : ipNetworkSpec.entrySet()) {
            IpNetworkConfigurationSpec currentNetworkSpec = e.getValue();
            Ruleset.RulesetSpec rulesetSpec = HostFirewallMutationProvider.createFirewallIpSpec(currentNetworkSpec);
            firewallSystem.updateRuleset(e.getKey(), rulesetSpec);
        }
    }

    private static Ruleset.RulesetSpec createFirewallIpSpec(IpNetworkConfigurationSpec networkSpec) {
        Ruleset.IpList ipList = new Ruleset.IpList();
        ipList.allIp = networkSpec.allIp;
        ipList.ipAddress = networkSpec.ipAddresses.toArray(new String[0]);
        ipList.ipNetwork = HostFirewallMutationProvider.createIpNetworkListFromSpec(networkSpec);
        return new Ruleset.RulesetSpec(ipList);
    }

    private static Ruleset.IpNetwork[] createIpNetworkListFromSpec(IpNetworkConfigurationSpec networkSpec) {
        List<IpNetwork> ipNetworks = networkSpec.ipNetworks;
        Ruleset.IpNetwork[] ipNetworkArray = new Ruleset.IpNetwork[ipNetworks.size()];
        for (int i = 0; i < ipNetworks.size(); ++i) {
            String currentNetwork = ipNetworks.get((int)i).network;
            int currentPrefixLength = ipNetworks.get((int)i).prefixLength;
            ipNetworkArray[i] = new Ruleset.IpNetwork(currentNetwork, currentPrefixLength);
        }
        return ipNetworkArray;
    }
}

