/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.DateTimeConfig;
import com.vmware.vim.binding.vim.host.DateTimeInfo;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.Ruleset;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vsphere.client.h5.host.util.HostStringUtil;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;

@QueryBinding(value="HostSystem")
public class TimeConfigData
extends IdentifiableQueryBinding {
    private static final String SERVER_LIST_SEPARATOR = ", ";
    private static final String NTP_SERVICE_KEY = "ntpd";
    private static final String NTP_CLIENT_KEY = "ntpClient";
    private static final String NTP_STATUS_ENABLED = "timeConfig.ntpStatusEnabled";
    private static final String NTP_STATUS_DISABLED = "timeConfig.ntpStatusDisabled";
    private static final String NTP_SERVICE_STATUS_NOT_FOUND = "timeConfig.ntpServiceStatusNotFound";
    private static final String NTP_SERVICE_STATUS_STOPPED = "timeConfig.ntpServiceStatusStopped";
    private static final String NTP_SERVICE_STATUS_RUNNING = "timeConfig.ntpServiceStatusRunning";
    @Property(value="HostSystem/config/dateTimeInfo")
    public transient DateTimeInfo config;
    @Property(value="HostSystem/config/service")
    public transient ServiceInfo services;
    @Property(value="HostSystem/config/firewall")
    public transient FirewallInfo firewallInfo;
    @Property(value="HostSystem/currentTimeOnHost")
    public transient GregorianCalendar currentTime;

    private Service getNtpService() {
        if (this.services != null && this.services.service != null) {
            for (Service s : this.services.service) {
                if (!NTP_SERVICE_KEY.equals(s.key)) continue;
                return s;
            }
        }
        return null;
    }

    private Ruleset getNtpRuleset() {
        if (this.firewallInfo == null || this.firewallInfo.ruleset == null) {
            return null;
        }
        for (Ruleset rs : this.firewallInfo.ruleset) {
            if (rs.key == null || !rs.key.contains(NTP_CLIENT_KEY)) continue;
            return rs;
        }
        return null;
    }

    public String getNtpServiceStatus() {
        Service ntpService = this.getNtpService();
        if (ntpService == null) {
            return HostStringUtil.getString(NTP_SERVICE_STATUS_NOT_FOUND, new String[0]);
        }
        if (ntpService.running) {
            return HostStringUtil.getString(NTP_SERVICE_STATUS_RUNNING, new String[0]);
        }
        return HostStringUtil.getString(NTP_SERVICE_STATUS_STOPPED, new String[0]);
    }

    public String getNtpClientStatus() {
        if (this.getNtpClientEnabled()) {
            return HostStringUtil.getString(NTP_STATUS_ENABLED, new String[0]);
        }
        return HostStringUtil.getString(NTP_STATUS_DISABLED, new String[0]);
    }

    public boolean getNtpClientEnabled() {
        Ruleset rs = this.getNtpRuleset();
        return rs != null && rs.enabled;
    }

    public String getNtpServers() {
        if (this.config == null || this.config.ntpConfig == null || this.config.ntpConfig.server == null) {
            return "";
        }
        return StringUtils.join((Object[])this.config.ntpConfig.server, (String)SERVER_LIST_SEPARATOR);
    }

    public Long getCurrentTimeInMillis() {
        if (this.currentTime == null) {
            return null;
        }
        return this.currentTime.getTimeInMillis();
    }

    public String getNtpServicePolicy() {
        Service ntpService = this.getNtpService();
        return ntpService == null ? "" : ntpService.getPolicy();
    }

    public String getNtpServiceId() {
        Service service = this.getNtpService();
        return service == null ? "" : service.getKey();
    }

    public boolean getNtpServiceState() {
        Service service = this.getNtpService();
        return service == null ? false : service.isRunning();
    }

    public DateTimeConfig getDateTimeConfig() {
        if (this.config == null) {
            return null;
        }
        DateTimeConfig config = new DateTimeConfig();
        String timeZone = this.config.getTimeZone() == null ? "" : this.config.getTimeZone().getKey();
        config.setTimeZone(timeZone);
        config.setNtpConfig(this.config.getNtpConfig());
        return config;
    }
}

