/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.moveHost.services;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.host.moveHost.MoveHostSpec;
import com.vmware.vsphere.client.h5.host.moveHost.model.HostMoveToCommonData;
import com.vmware.vsphere.client.h5.host.moveHost.services.MoveHostMutationHelperProvider;
import com.vmware.vsphere.client.h5.host.moveHost.services.MoveHostToClusterService;
import com.vmware.vsphere.client.mixed.ManagedEntityMoveSpec;
import java.util.Arrays;
import java.util.HashMap;

public class MoveHostService {
    private static final String DRS_ENABLED_PROPERTY = "configurationEx.drsConfig.enabled";
    private final String clusterType = ClusterComputeResource.class.getSimpleName();
    private MoveHostToClusterService _moveHostIntoClusterService;
    private MutationService _mutationService;
    private MoveHostMutationHelperProvider _moveHostMutationHelperProvider;
    private QueryBindingService _queryBindingService;

    public MoveHostService(MoveHostToClusterService moveHostIntoClusterService, MutationService mutationService, MoveHostMutationHelperProvider moveHostMutationHelperProvider, QueryBindingService queryBindingService) {
        this._moveHostIntoClusterService = moveHostIntoClusterService;
        this._mutationService = mutationService;
        this._moveHostMutationHelperProvider = moveHostMutationHelperProvider;
        this._queryBindingService = queryBindingService;
    }

    public OperationResult moveHostsToDatacenterOrFolder(ManagedObjectReference target, MoveHostSpec spec) {
        ManagedObjectReference[] hostsToMoveRefs = spec.entities;
        HostMoveToCommonData[] hostsToMoveDetails = this._queryBindingService.prepare(HostMoveToCommonData.class).fetch(Arrays.asList(hostsToMoveRefs)).toArray(new HostMoveToCommonData[0]);
        OperationResult[] opResultsForAllHosts = new OperationResult[hostsToMoveRefs.length];
        for (int i = 0; i < hostsToMoveDetails.length; ++i) {
            HostMoveToCommonData currentHostCommonData = hostsToMoveDetails[i];
            ManagedObjectReference currentHostReference = hostsToMoveRefs[i];
            opResultsForAllHosts[i] = this.moveSingleHostToDatacenterOrFolder(target, currentHostCommonData, currentHostReference);
        }
        OperationResult operationResult = new OperationResult();
        operationResult.result = opResultsForAllHosts;
        return operationResult;
    }

    public OperationResult moveHostsToCluster(ManagedObjectReference targetEntity, MoveHostSpec spec) {
        ManagedObjectReference[] hostsToMoveRefs = spec.entities;
        HostMoveToCommonData[] hostsToMoveDetails = this._queryBindingService.prepare(HostMoveToCommonData.class).fetch(Arrays.asList(hostsToMoveRefs)).toArray(new HostMoveToCommonData[0]);
        OperationResult opResult = new OperationResult();
        OperationResult[] operationResultForAllHosts = new OperationResult[hostsToMoveRefs.length];
        for (int i = 0; i < hostsToMoveDetails.length; ++i) {
            HostMoveToCommonData currentCommonData = hostsToMoveDetails[i];
            ManagedObjectReference currentHostRef = hostsToMoveRefs[i];
            operationResultForAllHosts[i] = this.moveSingleHostToCluster(targetEntity, currentCommonData, currentHostRef, spec);
        }
        opResult.result = operationResultForAllHosts;
        return opResult;
    }

    private OperationResult moveSingleHostToDatacenterOrFolder(ManagedObjectReference target, HostMoveToCommonData singleHostCommonData, ManagedObjectReference singleHostRef) {
        ManagedObjectReference parent = singleHostCommonData.parent;
        String hostParentType = parent.getType();
        ManagedEntityMoveSpec specToSend = new ManagedEntityMoveSpec();
        HashMap<MoveHostMutationHelperProvider.HelperConstants, Boolean> parameters = new HashMap<MoveHostMutationHelperProvider.HelperConstants, Boolean>();
        specToSend.entities = new ManagedObjectReference[1];
        OperationResult opResult = new OperationResult();
        try {
            if (hostParentType.equals(this.clusterType)) {
                if (!singleHostCommonData.isMoveAllowed()) {
                    parameters.put(MoveHostMutationHelperProvider.HelperConstants.displayMaintenanceModeError, true);
                    opResult.parameter = parameters;
                }
                specToSend.entities[0] = singleHostRef;
            } else {
                specToSend.entities[0] = parent;
            }
            if (opResult.parameter == null) {
                opResult = this._mutationService.apply((Object)target, (Object)specToSend);
            }
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private OperationResult moveSingleHostToCluster(ManagedObjectReference targetEntity, HostMoveToCommonData hostMoveToCommonData, ManagedObjectReference hostRef, MoveHostSpec spec) {
        boolean isDrsEnabled = this._moveHostMutationHelperProvider.isClusterServiceEnabled(DRS_ENABLED_PROPERTY, targetEntity);
        OperationResult opResult = new OperationResult();
        try {
            HashMap<MoveHostMutationHelperProvider.HelperConstants, Boolean> parameters = new HashMap<MoveHostMutationHelperProvider.HelperConstants, Boolean>();
            ManagedObjectReference hostParent = hostMoveToCommonData.parent;
            if (hostParent.getType().equals(this.clusterType) && !hostMoveToCommonData.isMoveAllowed()) {
                parameters.put(MoveHostMutationHelperProvider.HelperConstants.displayMaintenanceModeError, true);
                opResult.parameter = parameters;
            } else {
                opResult = isDrsEnabled ? this._moveHostIntoClusterService.moveHostToDrsEnabled(targetEntity, hostRef, spec) : this._moveHostIntoClusterService.moveHostToDrsDisabled(targetEntity, hostRef, spec);
            }
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }
}

