/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.system;

import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.host.SystemResourceInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.h5.host.system.SystemResourceReservation;

public class SystemResourcePropertyProvider
implements PropertyProviderBean {
    private QueryExecutor queryExecutor;

    public SystemResourcePropertyProvider(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @type(value="HostSystem")
    public SystemResourceReservation getSystemResourceReservations(ManagedObjectReference hostRef) throws Exception {
        SystemResourceInfo[] resourceInfo = (SystemResourceInfo[])this.queryExecutor.getProperty((Object)hostRef, "systemResources.child");
        ResourceConfigSpec targetConfig = this.getConfigForKey("host/system", resourceInfo);
        String cpuAllocation = null;
        String memoryAllocation = null;
        if (targetConfig.cpuAllocation != null && targetConfig.cpuAllocation.reservation != null) {
            cpuAllocation = FormatUtil.getFrequencyFormatted((Number)targetConfig.cpuAllocation.reservation, (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
        }
        if (targetConfig.memoryAllocation != null && targetConfig.memoryAllocation.reservation != null) {
            memoryAllocation = FormatUtil.getDataSizeFormatted((Number)targetConfig.memoryAllocation.reservation, (int)2, (long)0x100000L, (long)-1L, (boolean)true);
        }
        return new SystemResourceReservation(cpuAllocation, memoryAllocation);
    }

    private ResourceConfigSpec getConfigForKey(String key, SystemResourceInfo[] resourceInfo) {
        for (SystemResourceInfo info : resourceInfo) {
            if (info.key == null || !info.key.equals(key)) continue;
            return info.config;
        }
        return new ResourceConfigSpec();
    }
}

