/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vmtx.libraryItem.impl;

import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vcenter.vm_template.LibraryItems;
import com.vmware.vcenter.vm_template.LibraryItemsTypes;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.cis.CisIdConverter;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vsphere.client.error.transform.ErrorTransformUtil;
import com.vmware.vsphere.client.h5.vmtx.libraryItem.specs.CreateVmtxLibraryItemSpec;
import com.vmware.vsphere.client.h5.vmtx.libraryItem.specs.DeployVmtxLibraryItemSpec;
import com.vmware.vsphere.client.util.uri.UriSchemeUtil;
import com.vmware.vsphere.client.vapi.tasks.VapiAsyncCallback;
import com.vmware.vsphere.client.vapi.tasks.VapiTaskMonitor;
import java.net.URI;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmtxLibraryItemMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(VmtxLibraryItemMutationProvider.class);
    private final LibraryItems _vmtxLibraryItemService;
    private VapiTaskMonitor _vapiTaskMonitor;

    public VmtxLibraryItemMutationProvider(LibraryItems vmtxLibraryItemService) {
        Validate.notNull((Object)vmtxLibraryItemService, (String)"vmtxLibraryItemService");
        this._vmtxLibraryItemService = vmtxLibraryItemService;
    }

    @type(value="VirtualMachine")
    public OperationResult apply(ManagedObjectReference objRef, CreateVmtxLibraryItemSpec spec) {
        OperationResult result = new OperationResult();
        assert (objRef != null);
        assert (spec != null);
        assert (spec.contentLibrary != null);
        result.entity = spec.contentLibrary;
        LibraryItemsTypes.CreateSpec createSpec = this.getVmtxLibraryCreateSpec(objRef, spec);
        try {
            VapiAsyncCallback asyncCallback = new VapiAsyncCallback(null, this._vapiTaskMonitor);
            this._vmtxLibraryItemService.create(createSpec, (AsyncCallback)asyncCallback);
            _logger.info((Object)("Create clone VM task: " + ObjectUtil.prettyPrint((Object)result.task)));
        }
        catch (Exception exception) {
            _logger.error((Object)("Could not clone VMTX template. spec =  " + ObjectUtil.prettyPrint((Object)((Object)spec))), (Throwable)exception);
            result.error = ErrorTransformUtil.convertError((Exception)exception);
        }
        return result;
    }

    public OperationResult add(DeployVmtxLibraryItemSpec deploymentSpecInput) {
        OperationResult result = new OperationResult();
        VapiAsyncCallback asyncCallback = new VapiAsyncCallback(this._vapiTaskMonitor);
        LibraryItemsTypes.DeploySpec deploymentSpec = new LibraryItemsTypes.DeploySpec();
        try {
            deploymentSpec.setName(deploymentSpecInput.name);
            deploymentSpec.setDescription(deploymentSpecInput.description);
            deploymentSpec.setPlacement(deploymentSpecInput.placementSpec);
            deploymentSpec.setDiskStorage(deploymentSpecInput.diskStorage);
            deploymentSpec.setVmHomeStorage(deploymentSpecInput.vmHomeStorage);
            deploymentSpec.setDiskStorageOverrides(deploymentSpecInput.diskStorageOverrides);
            deploymentSpec.setPoweredOn(Boolean.valueOf(deploymentSpecInput.powerOn));
            deploymentSpec.setGuestCustomization(deploymentSpecInput.guestCustomizationSpec);
            deploymentSpec.setHardwareCustomization(deploymentSpecInput.hardwareCustomization);
            _logger.debug((Object)("Deploy VMTX library item spec: " + deploymentSpec));
            this._vmtxLibraryItemService.deploy(UriSchemeUtil.getId((URI)deploymentSpecInput.libraryItemUri), deploymentSpec, (AsyncCallback)asyncCallback);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error deploying content library item.\nSpec: \n" + ObjectUtil.prettyPrint((Object)deploymentSpec)), (Throwable)ex);
            result.error = ErrorTransformUtil.convertError((Exception)ex);
        }
        return result;
    }

    public void setVapiTaskMonitor(VapiTaskMonitor vapiTaskMonitor) {
        this._vapiTaskMonitor = vapiTaskMonitor;
    }

    private LibraryItemsTypes.CreateSpec getVmtxLibraryCreateSpec(ManagedObjectReference objRef, CreateVmtxLibraryItemSpec spec) {
        LibraryItemsTypes.CreateSpec createSpec = new LibraryItemsTypes.CreateSpec();
        String sourceVm = CisIdConverter.toGlobalCisId((ManagedObjectReference)objRef, (String)objRef.getServerGuid());
        createSpec.setSourceVm(sourceVm);
        createSpec.setName(spec.name);
        createSpec.setDescription(spec.description);
        createSpec.setVmHomeStorage(spec.vmHomeStorage);
        createSpec.setDiskStorage(spec.diskStorage);
        createSpec.setDiskStorageOverrides(spec.diskStorageOverrides);
        LibraryItemsTypes.CreatePlacementSpec placement = new LibraryItemsTypes.CreatePlacementSpec();
        placement.setFolder(spec.folder);
        if (spec.host != null) {
            placement.setHost(spec.host);
        } else if (spec.cluster != null) {
            placement.setCluster(spec.cluster);
        } else if (spec.resourcePool != null) {
            placement.setResourcePool(spec.resourcePool);
        }
        createSpec.setPlacement(placement);
        String library = UriSchemeUtil.getId((URI)spec.contentLibrary);
        createSpec.setLibrary(library);
        return createSpec;
    }
}

