/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vmtx.libraryItem.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import java.net.URI;
import org.apache.commons.lang.Validate;

public class VmtxLibraryItemPropertyProvider
implements PropertyProviderBean {
    private final DataService _dataService;
    private QueryService _queryService;

    public VmtxLibraryItemPropertyProvider(DataService dataService, QueryServiceFactory queryServiceFactory) {
        Validate.notNull((Object)dataService, (String)"dataService is null");
        this._dataService = dataService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @type(value="com.vmware.content.library.Item")
    public ManagedObjectReference getMorIdOfVmtx(URI objRef) {
        ResourceItem item;
        ResultSet libraryItemsResult = this._queryService.select(new String[]{"com.vmware.vcenter.vm_template.LibraryItems.Info/vmTemplate"}).from(new String[]{"com.vmware.content.library.ItemModel", "com.vmware.vcenter.vm_template.LibraryItems.Info"}).where(new PropertyPredicate[]{new PropertyPredicate("id", PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef.toString())}).fetch();
        if (libraryItemsResult != null && !libraryItemsResult.getItems().isEmpty() && !(item = (ResourceItem)libraryItemsResult.getItems().get(0)).getPropertyValues().isEmpty() && item.getPropertyValues().get(0) instanceof ManagedObjectReference) {
            return (ManagedObjectReference)item.getPropertyValues().get(0);
        }
        return null;
    }

    @type(value="com.vmware.content.library.Item")
    public String getGuestOSForLibraryItem(URI libraryItemUri) {
        ResultSet ovfLibraryItemsResult = this._queryService.select(new String[]{"vmTemplate/osDescription"}).from(new String[]{"com.vmware.content.library.ItemModel", "com.vmware.content.type.ovf.OvfTemplate"}).where(new PropertyPredicate[]{new PropertyPredicate("id", PropertyPredicate.ComparisonOperator.EQUAL, (Object)libraryItemUri.toString())}).fetch();
        for (ResourceItem libraryItem : ovfLibraryItemsResult.getItems()) {
            if (libraryItem.get("vmTemplate/osDescription") == null) continue;
            return (String)libraryItem.get("vmTemplate/osDescription");
        }
        ResultSet vmtxLibraryItemsResult = this._queryService.select(new String[]{"com.vmware.vcenter.vm_template.LibraryItems.Info/guestOsDescription"}).from(new String[]{"com.vmware.content.library.ItemModel", "com.vmware.vcenter.vm_template.LibraryItems.Info"}).where(new PropertyPredicate[]{new PropertyPredicate("id", PropertyPredicate.ComparisonOperator.EQUAL, (Object)libraryItemUri.toString())}).fetch();
        for (ResourceItem libraryItem : vmtxLibraryItemsResult.getItems()) {
            String guestOS = (String)libraryItem.get("com.vmware.vcenter.vm_template.LibraryItems.Info/guestOsDescription");
            if (guestOS == null) continue;
            return guestOS;
        }
        return null;
    }
}

