/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SortableCongestionThresholdPropertyProvider
implements PropertyProviderAdapter {
    public static final String SORTABLE_CONGESTION_THRESHOLD = "sortableCongestionThreshold";
    public static final String SORTABLE_CONGESTION_THRESHOLD_MODE = "sortableCongestionThresholdMode";
    static final int CONGESTION_THRESHOLD_NOT_AVAILABLE_VALUE = 1000;
    static final int CONGESTION_THRESHOLD_NOT_ENABLED_VALUE = 900;
    static final int CONGESTION_THRESHOLD_MODE_NOT_AVAILABLE_VALUE = 1000;
    static final int CONGESTION_THRESHOLD_MODE_MANUAL_VALUE = 900;
    static final String PROPERTY_SIOC_SUPPORTED = "capability.storageIORMSupported";
    static final String PROPERTY_CT_MODE = "iormConfiguration.congestionThresholdMode";
    static final String PROPERTY_CT = "iormConfiguration.congestionThreshold";
    static final String PROPERTY_PERCENT_OF_PEAK_THROUGHPUT = "iormConfiguration.percentOfPeakThroughput";
    static final String PROPERTY_IORM_ENABLED = "iormConfiguration.enabled";
    private static final Log _logger = LogFactory.getLog(SortableCongestionThresholdPropertyProvider.class);
    private final DataService _dataService;

    public SortableCongestionThresholdPropertyProvider(DataServiceExtensionRegistry registry, DataService dataService) {
        this._dataService = dataService;
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = Datastore.class.getSimpleName();
        ti.properties = new String[]{SORTABLE_CONGESTION_THRESHOLD, SORTABLE_CONGESTION_THRESHOLD_MODE};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        if (propertyRequest == null || propertyRequest.objects == null || propertyRequest.properties == null) {
            String error = "objects or properties argument passed null.";
            _logger.error((Object)error);
            return null;
        }
        HashSet<String> requestedProperties = new HashSet<String>();
        for (PropertySpec propertySpec : propertyRequest.properties) {
            for (String propertyName : propertySpec.propertyNames) {
                if (SORTABLE_CONGESTION_THRESHOLD.equals(propertyName)) {
                    requestedProperties.add(SORTABLE_CONGESTION_THRESHOLD);
                    continue;
                }
                if (!SORTABLE_CONGESTION_THRESHOLD_MODE.equals(propertyName)) continue;
                requestedProperties.add(SORTABLE_CONGESTION_THRESHOLD_MODE);
            }
        }
        if (requestedProperties.isEmpty()) {
            return null;
        }
        ArrayList<ManagedObjectReference> datastores = new ArrayList<ManagedObjectReference>();
        for (Object object : propertyRequest.objects) {
            if (!(object instanceof ManagedObjectReference)) {
                _logger.warn((Object)("Request for non-managed object received: " + object));
                continue;
            }
            ManagedObjectReference moRef = (ManagedObjectReference)object;
            if (!Datastore.class.equals((Object)ManagedObjectUtil.getType((ManagedObjectReference)moRef))) {
                _logger.warn((Object)("Request for an object != Datastore received: " + moRef));
                continue;
            }
            datastores.add(moRef);
        }
        if (datastores.isEmpty()) {
            _logger.warn((Object)"No objects left after filtering.");
            return null;
        }
        ResultSet[] dataFromDataService = this.retrieveData(datastores);
        ResultSet result = this.processData(dataFromDataService, requestedProperties);
        return result;
    }

    private ResultSet[] retrieveData(List<ManagedObjectReference> datastores) {
        QuerySpec[] allQuerySpecs = new QuerySpec[datastores.size()];
        for (int i = 0; i < datastores.size(); ++i) {
            QuerySpec querySpec;
            ManagedObjectReference datastoreRef = datastores.get(i);
            allQuerySpecs[i] = querySpec = QueryUtil.buildQuerySpec((Object)datastoreRef, (String[])new String[]{PROPERTY_SIOC_SUPPORTED, PROPERTY_CT_MODE, PROPERTY_CT, PROPERTY_PERCENT_OF_PEAK_THROUGHPUT, PROPERTY_IORM_ENABLED});
        }
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = allQuerySpecs;
        return this._dataService.getData((RequestSpec)requestSpec).resultSet;
    }

    private ResultSet processData(ResultSet[] resultsFromDataService, Set<String> requestedProperties) {
        ResultSet result = new ResultSet();
        ResultItem[] resultItems = new ResultItem[resultsFromDataService.length];
        for (int i = 0; i < resultsFromDataService.length; ++i) {
            PropertyValue propertyValue;
            ResultSet datastoreResultSet = resultsFromDataService[i];
            ManagedObjectReference datastoreRef = null;
            boolean siocSupported = false;
            String congestionThresholdMode = StorageResourceManager.CongestionThresholdMode.automatic.name();
            int congestionThreshold = -1;
            int percentOfPeakThroughput = -1;
            boolean iormEnabled = false;
            for (ResultItem resultItem : datastoreResultSet.items) {
                for (PropertyValue propertyValue2 : resultItem.properties) {
                    if (PROPERTY_SIOC_SUPPORTED.equals(propertyValue2.propertyName)) {
                        siocSupported = (Boolean)propertyValue2.value;
                        continue;
                    }
                    if (PROPERTY_CT_MODE.equals(propertyValue2.propertyName)) {
                        congestionThresholdMode = (String)propertyValue2.value;
                        continue;
                    }
                    if (PROPERTY_CT.equals(propertyValue2.propertyName)) {
                        congestionThreshold = (Integer)propertyValue2.value;
                        continue;
                    }
                    if (PROPERTY_PERCENT_OF_PEAK_THROUGHPUT.equals(propertyValue2.propertyName)) {
                        percentOfPeakThroughput = (Integer)propertyValue2.value;
                        continue;
                    }
                    if (!PROPERTY_IORM_ENABLED.equals(propertyValue2.propertyName)) continue;
                    iormEnabled = (Boolean)propertyValue2.value;
                }
                datastoreRef = (ManagedObjectReference)resultItem.resourceObject;
            }
            ResultItem datastoreResultItem = new ResultItem();
            datastoreResultItem.resourceObject = datastoreRef;
            ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
            if (requestedProperties.contains(SORTABLE_CONGESTION_THRESHOLD)) {
                int sortableCongestionThreshold = this.getSortableCongestionThresholdForDatastore(siocSupported, iormEnabled, congestionThreshold);
                propertyValue = this.createPropertyValue(SORTABLE_CONGESTION_THRESHOLD, datastoreRef, sortableCongestionThreshold);
                values.add(propertyValue);
            }
            if (requestedProperties.contains(SORTABLE_CONGESTION_THRESHOLD_MODE)) {
                int sortableCongestionThresholdMode = this.getSortableCongestionThresholdModeForDatastore(siocSupported, iormEnabled, congestionThresholdMode, percentOfPeakThroughput);
                propertyValue = this.createPropertyValue(SORTABLE_CONGESTION_THRESHOLD_MODE, datastoreRef, sortableCongestionThresholdMode);
                values.add(propertyValue);
            }
            datastoreResultItem.properties = values.toArray(new PropertyValue[0]);
            resultItems[i] = datastoreResultItem;
        }
        result.items = resultItems;
        return result;
    }

    private int getSortableCongestionThresholdModeForDatastore(boolean siocSupported, boolean iormEnabled, String congestionThresholdMode, int percentOfPeakThroughput) {
        int value = percentOfPeakThroughput;
        if (!siocSupported || !iormEnabled) {
            value = 1000;
        } else if (StorageResourceManager.CongestionThresholdMode.manual.name().equals(congestionThresholdMode)) {
            value = 900;
        }
        return value;
    }

    private int getSortableCongestionThresholdForDatastore(boolean siocSupported, boolean iormEnabled, int actualCongestionThreshold) {
        int value = actualCongestionThreshold;
        if (!siocSupported) {
            value = 1000;
        } else if (!iormEnabled) {
            value = 900;
        }
        return value;
    }

    private PropertyValue createPropertyValue(String propertyName, ManagedObjectReference datastoreRef, int value) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = propertyName;
        propertyValue.resourceObject = datastoreRef;
        propertyValue.value = value;
        return propertyValue;
    }
}

