/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.util;

import com.vmware.vim.binding.vim.host.DatastoreBrowser;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.storage.FileSpec;
import com.vmware.vsphere.client.storage.DatastoreCreateFolderSpec;
import com.vmware.vsphere.client.storage.DatastoreDeleteFileSpec;
import com.vmware.vsphere.client.storage.DatastoreFileCopySpec;
import com.vmware.vsphere.client.storage.DatastoreFileMoveSpec;
import com.vmware.vsphere.client.storage.DatastoreFileRenameSpec;
import com.vmware.vsphere.client.storage.InflateDiskSpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastorePathUtil {
    private static final Log _logger = LogFactory.getLog(DatastorePathUtil.class);
    private static Pattern DATASTORE_PATH_PATTERN = Pattern.compile("\\[(.*?)\\] ?((?:.*?/)*)(.*)");
    private static String UNABLE_TO_MATCH_PATH_ERROR_MESSAGE_TEMPLATE = "Unable to match {path} to datastore path format.";

    public static void escapeDatastoreNameInFileSpec(FileSpec spec) {
        spec.datastorePath = DatastorePathUtil.escapeDatastoreNameInPath(spec.datastorePath);
    }

    public static void escapeDatastoreNameInDatastoreCreateFolderSpec(DatastoreCreateFolderSpec spec) {
        spec.folderName = DatastorePathUtil.escapeDatastoreNameInPath(spec.folderName);
    }

    public static void escapeDatastoreNameInDatastoreDeleteFileSpec(DatastoreDeleteFileSpec spec) {
        for (int i = 0; i < spec.targetFiles.length; ++i) {
            spec.targetFiles[i] = DatastorePathUtil.escapeDatastoreNameInPath(spec.targetFiles[i]);
        }
    }

    public static void escapeDatastoreNameInInflateDiskSpec(InflateDiskSpec spec) {
        spec.targetFile = DatastorePathUtil.escapeDatastoreNameInPath(spec.targetFile);
    }

    public static void escapeDatastoreNameInDatastoreFileCopySpec(DatastoreFileCopySpec spec) {
        for (int i = 0; i < spec.sourcePaths.length; ++i) {
            spec.sourcePaths[i] = DatastorePathUtil.escapeDatastoreNameInPath(spec.sourcePaths[i]);
        }
        spec.destinationPath = DatastorePathUtil.escapeDatastoreNameInPath(spec.destinationPath);
    }

    public static void escapeDatastoreNameInDatastoreFileMoveSpec(DatastoreFileMoveSpec spec) {
        for (int i = 0; i < spec.sourcePaths.length; ++i) {
            spec.sourcePaths[i] = DatastorePathUtil.escapeDatastoreNameInPath(spec.sourcePaths[i]);
        }
        spec.destinationPath = DatastorePathUtil.escapeDatastoreNameInPath(spec.destinationPath);
    }

    public static void escapeDatastoreNameInDatastoreFileRenameSpec(DatastoreFileRenameSpec spec) {
        spec.sourcePath = DatastorePathUtil.escapeDatastoreNameInPath(spec.sourcePath);
    }

    public static void unescapeDatastoreNameInSearchResults(Object results) {
        DatastoreBrowser.SearchResults[] typedResults = null;
        typedResults = results instanceof DatastoreBrowser.SearchResults[] ? (DatastoreBrowser.SearchResults[])results : (results instanceof DatastoreBrowser.SearchResults ? new DatastoreBrowser.SearchResults[]{(DatastoreBrowser.SearchResults)results} : new DatastoreBrowser.SearchResults[]{});
        for (DatastoreBrowser.SearchResults result : typedResults) {
            result.folderPath = DatastorePathUtil.unescapeDatastoreNameInPath(result.folderPath);
        }
    }

    public static String escapeDatastoreNameInPath(String datastorePath) {
        return DatastorePathUtil.escapeOrUnescapeDatastoreNameInPath(datastorePath, true);
    }

    public static String unescapeDatastoreNameInPath(String datastorePath) {
        return DatastorePathUtil.escapeOrUnescapeDatastoreNameInPath(datastorePath, false);
    }

    public static String getDestinationPath(String sourcePath, String destinationPath, boolean preserveSourceDirectoryStructure) throws IllegalArgumentException {
        Matcher sourcePathMatcher = DATASTORE_PATH_PATTERN.matcher(sourcePath);
        if (!sourcePathMatcher.matches()) {
            String errorMessage = DatastorePathUtil.getUnableToMatchPathErrorMessage(sourcePath);
            _logger.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        Matcher destinationPathMatcher = DATASTORE_PATH_PATTERN.matcher(destinationPath);
        if (!destinationPathMatcher.matches()) {
            String errorMessage = DatastorePathUtil.getUnableToMatchPathErrorMessage(destinationPath);
            _logger.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        String sourcePrefix = sourcePathMatcher.group(2);
        String sourceTrail = sourcePathMatcher.group(3);
        String destinationPrefix = destinationPathMatcher.group(2);
        String destinationTrail = destinationPathMatcher.group(3);
        StringBuilder destination = new StringBuilder(destinationPath);
        if (destinationPrefix.equals("") && destinationTrail.equals("") && destinationPath.endsWith("]")) {
            destination.append(' ');
        }
        if (preserveSourceDirectoryStructure) {
            destination.append('/').append(sourcePrefix).append(sourceTrail);
        } else {
            destination.append('/').append(sourceTrail);
        }
        return destination.toString();
    }

    public static String replacePathTrail(String sourcePath, String trail) throws IllegalArgumentException {
        Matcher sourcePathMatcher = DATASTORE_PATH_PATTERN.matcher(sourcePath);
        if (!sourcePathMatcher.matches()) {
            String errorMessage = DatastorePathUtil.getUnableToMatchPathErrorMessage(sourcePath);
            _logger.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        int trailGroupStartIndex = sourcePathMatcher.start(3);
        int trailGroupEndIndex = sourcePathMatcher.end(3);
        String trailPrefix = sourcePath.substring(0, trailGroupStartIndex);
        String trailSuffix = sourcePath.substring(trailGroupEndIndex);
        return trailPrefix + trail + trailSuffix;
    }

    private static String escapeOrUnescapeDatastoreNameInPath(String datastorePath, boolean escape) {
        Matcher datastorePathMatcher = DATASTORE_PATH_PATTERN.matcher(datastorePath);
        if (datastorePathMatcher.matches()) {
            int datastoreNameGroupStartIndex = datastorePathMatcher.start(1);
            int datastoreNameGroupEndIndex = datastorePathMatcher.end(1);
            String datastoreName = datastorePath.substring(datastoreNameGroupStartIndex, datastoreNameGroupEndIndex);
            datastoreName = escape ? MixedUtil.escapeVimEntityNameSpecialChars((String)datastoreName) : MixedUtil.unescapeVimEntityNameSpecialChars((String)datastoreName);
            String datastoreNamePrefix = datastorePath.substring(0, datastoreNameGroupStartIndex);
            String datastoreNameSuffix = datastorePath.substring(datastoreNameGroupEndIndex);
            datastorePath = datastoreNamePrefix + datastoreName + datastoreNameSuffix;
        }
        return datastorePath;
    }

    private static String getUnableToMatchPathErrorMessage(String path) {
        return UNABLE_TO_MATCH_PATH_ERROR_MESSAGE_TEMPLATE.replaceAll("\\{path\\}", path);
    }
}

