/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.cimmonitor.http.impl;

import com.vmware.cis.common.sso.SsoOverRestHelper;
import com.vmware.cis.common.sso.SsoOverRestRequest;
import com.vmware.vim.cimmonitor.http.CimMonitorHttpService;
import com.vmware.vim.cimmonitor.http.HttpCimException;
import com.vmware.vim.cimmonitor.http.impl.DefaultCimHttpGetBuilder;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SslUtil;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.security.sso.SsoUtil;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpGet;

public class CimVc61HttpService
implements CimMonitorHttpService {
    private static final Log _logger = LogFactory.getLog(CimVc61HttpService.class);
    private URL _serviceUrl;
    private KeystoreService _keystoreService;

    public CimVc61HttpService(URL serviceUrl, KeystoreService keystoreService) {
        this._serviceUrl = serviceUrl;
        this._keystoreService = keystoreService;
    }

    @Override
    public String getHostData(String hostId, String vcSessionId) throws HttpCimException {
        String result = this.executeHttpAction(hostId, "getHostData");
        return result;
    }

    @Override
    public void refreshHost(String hostId, String vcSessionId) throws HttpCimException {
        this.executeHttpAction(hostId, "refreshHost");
    }

    @Override
    public void resetHostSensors(String hostId, String vcSessionId) throws HttpCimException {
        this.executeHttpAction(hostId, "resetHostSensors");
    }

    @Override
    public void resetEventLog(String hostId, String vcSessionId) throws HttpCimException {
        this.executeHttpAction(hostId, "resetEventLog");
    }

    private String executeHttpAction(String hostId, String action) {
        String result = null;
        try {
            HttpGet httpGet = this.getHttpGet(hostId, action);
            SsoOverRestRequest ssoRequest = new SsoOverRestRequest(httpGet);
            PrivateKey privateKey = SsoUtil.getSolutionUser().getPrivateKey();
            SamlToken ssoToken = AuthSessionUtil.getSsoToken();
            Map authenticationHeaders = SsoOverRestHelper.calcAuthHeader((SsoOverRestRequest)ssoRequest, (PrivateKey)privateKey, (SamlToken)ssoToken, (int)1024);
            String url = httpGet.getURI().toString();
            HttpClient httpClient = SslUtil.getHttpClient((KeyStore)this._keystoreService.getKeyStore());
            result = httpClient.executeMethod(url, null, authenticationHeaders);
            if ("getHostData".equals(action) && StringUtil.isNullOrEmpty((String)result)) {
                _logger.warn((Object)("No host data. Http status code: " + httpClient.getStatusCode()));
            }
        }
        catch (IOException e) {
            _logger.error((Object)"Failed to create SSO request.", (Throwable)e);
        }
        catch (SsoOverRestHelper.SsoOverRestHelperException e) {
            _logger.error((Object)"Failed to create authentication headers.", (Throwable)e);
        }
        return result;
    }

    private HttpGet getHttpGet(String hostId, String operation) {
        DefaultCimHttpGetBuilder builder = new DefaultCimHttpGetBuilder();
        builder.setServiceUrl(this._serviceUrl);
        builder.setHostId(hostId);
        builder.setOperation(operation);
        return builder.getHttpGet();
    }
}

