/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cimmonitor.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.cimmonitor.http.CimMonitorHttpService;
import com.vmware.vim.cimmonitor.http.impl.CimVc60HttpService;
import com.vmware.vim.cimmonitor.http.impl.CimVc61HttpService;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.cimmonitor.cimdataadapter.CimData;
import com.vmware.vsphere.client.cimmonitor.impl.CMSServiceLocator;
import com.vmware.vsphere.client.cimmonitor.impl.CimServiceAddressLookupException;
import com.vmware.vsphere.client.cimmonitor.impl.Utilities;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CimMonitorFacade {
    private static final String HW_HEALTH_HOST_RELATION = "host.id";
    private static final String HW_HEALTH_HOST_PROP = "host";
    private static final String HW_HEALTH_RES_TYPE = "com.vmware.vcenter.HardwareHealth";
    private static final Log _logger = LogFactory.getLog(CimMonitorFacade.class);
    private CMSServiceLocator _cmsServiceLocator;
    private DataService _dataService;
    private KeystoreService _keystoreService;
    private SsoService _ssoService;
    private CimData _cimData;

    public void setCimData(CimData cimData) {
        this._cimData = cimData;
    }

    public void setDataService(DataService dataService) {
        this._dataService = dataService;
    }

    public void setCmsServiceLocator(CMSServiceLocator cmsServiceLocator) {
        this._cmsServiceLocator = cmsServiceLocator;
    }

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void setSsoService(SsoService ssoService) {
        this._ssoService = ssoService;
    }

    public CimMonitorHttpService getServiceInstance(String serverGuid) throws CimServiceAddressLookupException {
        if (this._cmsServiceLocator == null) {
            throw this.newCimServiceAddressLookupException(serverGuid);
        }
        CimMonitorHttpService service = null;
        URL serviceUrl = this._cmsServiceLocator.getCMSUrl(serverGuid);
        if (VcServiceUtil.isVc61OrLater((String)serverGuid)) {
            if (serviceUrl == null) {
                return null;
            }
            service = new CimVc61HttpService(serviceUrl, this._keystoreService);
        } else {
            if (serviceUrl == null) {
                throw this.newCimServiceAddressLookupException(serverGuid);
            }
            service = new CimVc60HttpService(serverGuid, serviceUrl, this._keystoreService, this._ssoService);
        }
        return service;
    }

    public String getHardwareHealthData(ManagedObjectReference host) throws Exception {
        String serverGuid = host.getServerGuid();
        if (this.getServiceInstance(serverGuid) == null) {
            String cimData = this._cimData.getData(host);
            if (StringUtil.isNullOrEmpty((String)cimData)) {
                _logger.error((Object)"Unable to retrive runtime health information from host");
            }
            return cimData;
        }
        if (VcServiceUtil.isVc61OrLater((String)serverGuid)) {
            return this.getHardwareHealthFromCIM(host);
        }
        if (CimMonitorFacade.isVc60OrLater(serverGuid)) {
            return this.getHardwareHealthFromIS(host);
        }
        return this.getHardwareHealthFromCIM(host);
    }

    private String getHardwareHealthFromIS(ManagedObjectReference host) throws Exception {
        String result = null;
        ObjectIdentityConstraint hostConstraint = QueryUtil.createObjectIdentityConstraint((Object)host);
        RelationalConstraint hwhConstraint = QueryUtil.createRelationalConstraint((String)HW_HEALTH_HOST_RELATION, (Constraint)hostConstraint, (Boolean)false, (String)HW_HEALTH_RES_TYPE);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)hwhConstraint, (String[])new String[]{HW_HEALTH_HOST_PROP});
        try {
            _logger.debug((Object)("Query IS for hardware health data about host: " + host));
            ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
            result = (String)QueryUtil.findPropertyValueIn((String)HW_HEALTH_HOST_PROP, Arrays.asList(resultSet.items));
            if (StringUtil.isNullOrEmpty((String)result)) {
                _logger.error((Object)("Missing hardware health data for host " + host));
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error while getting hardware health data for host " + host), (Throwable)e);
            throw e;
        }
        return result;
    }

    private String getHardwareHealthFromCIM(ManagedObjectReference host) throws Exception {
        String hostId = host.getValue();
        String serverGuid = host.getServerGuid();
        String vcSessionId = Utilities.getVcSessionId(serverGuid);
        CimMonitorHttpService service = this.getServiceInstance(serverGuid);
        _logger.debug((Object)("Query CIM for hardware health data about host: " + host));
        String result = null;
        if (service != null) {
            result = service.getHostData(hostId, vcSessionId);
        }
        return result;
    }

    private static boolean isVc60OrLater(String serverGuid) {
        return VcServiceUtil.is2014VcOrLater((String)serverGuid);
    }

    private CimServiceAddressLookupException newCimServiceAddressLookupException(String serverGuid) {
        return new CimServiceAddressLookupException(String.format("CIM HTTP service address lookup failed for server: %s", serverGuid));
    }
}

