/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vapp.impl;

import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.vApp.OvfSectionInfo;
import com.vmware.vim.binding.vim.vApp.VAppConfigInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.common.util.OvfUtil;
import com.vmware.vsphere.client.ippool.vapp.VAppIpPoolData;
import com.vmware.vsphere.client.vapp.impl.VAppConfig;

public class VAppPropertyProvider
implements PropertyProviderBean {
    private DataService _dataService;

    public VAppPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="VirtualApp")
    public VAppIpPoolData getIpPoolData(ManagedObjectReference vAppRef) throws Exception {
        return VAppConfig.getIpPoolData(vAppRef, this._dataService);
    }

    @type(value="VirtualApp")
    public String[] getUnrecognizedOvfSections(ManagedObjectReference vAppRef) throws Exception {
        VirtualApp vApp = (VirtualApp)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vAppRef);
        VAppConfigInfo vAppConfig = vApp.getVAppConfig();
        if (vAppConfig == null) {
            return null;
        }
        OvfSectionInfo[] sections = vAppConfig.getOvfSection();
        if (sections == null) {
            return null;
        }
        String[] styledSections = new String[sections.length];
        for (int i = 0; i < sections.length; ++i) {
            String section = sections[i].getContents();
            styledSections[i] = OvfUtil.styleOvfSection((String)section);
        }
        return styledSections;
    }
}

