/* Copyright (c) 2018 VMware, Inc. All rights reserved. */

package com.vmware.samples.htmlsample.controllers;

import com.vmware.samples.htmlsample.model.Host;
import com.vmware.samples.htmlsample.services.VcInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;
import java.util.Map;

/**
 * A controller which returns information about vSphere objects.
 */
@Controller
public class VcInfoController extends BaseRestController {
   private final VcInfoService _vcInfoService;

   @Autowired
   public VcInfoController(VcInfoService vcInfoService) {
      _vcInfoService = vcInfoService;
   }

   /**
    * Retrieves all connected hosts
    * @return list of connected host objects.
    */
   @RequestMapping(value = "/hosts", method = RequestMethod.GET)
   @ResponseBody
   public List<Host> getRelatedHostsList() throws Exception {
      return _vcInfoService.getRelatedHosts();
   }

   /**
    * Retrieves all vCenter server infos.
    * @return a map vCenter server names and guids.
    */
   @RequestMapping(value = "/serverInfos", method = RequestMethod.GET)
   @ResponseBody
   public Map<String, String> getServerInfos() throws Exception {
      return _vcInfoService.getServerInfos();
   }
}

