/* Copyright (c) 2018 VMware, Inc. All rights reserved. */
package com.vmware.samples.htmlsample.services;

import com.vmware.samples.htmlsample.model.Host;

import java.util.List;
import java.util.Map;

/**
 * Interface used to retrieve information about vSphere objects.
 */
public interface VcInfoService {

   /**
    * Retrieves the connected hosts
    */
   List<Host> getRelatedHosts();

   /**
    * Retrieves vCenters server information
    * @return a map containing vCenter names and guids
    */
   Map<String, String> getServerInfos();
}
