/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * This file must come first.
 */
window.h5 = window.h5 || {};
window.h5.uiLib = window.h5.uiLib || {};
window.h5.actions = window.h5.actions || {};
window.h5.dragAndDropValidationMethods = window.h5.dragAndDropValidationMethods || {};
window.h5.listViewSelectedItemIdProperty = "lvSelectedItemId";

/**
 * @ngdoc overview
 * @name com.vmware.platform.ui
 * @module com.vmware.platform.ui
 *
 * @description
 *    # com.vmware.platform.ui
 *    This module contains various utility services for fetching and mutating objects
 *    and data, navigating, localization and other common tasks.
 *
 *    <mark style="background: #FA8072">Many of the APIs in this module are still
 *    candidate only and subject to change. Send feedback to h5-reviews@vmware.com.</mark>
 */
window.h5.uiLib.angularModule = angular
      .module('com.vmware.platform.ui', [
            'ngAria',
            'ngCookies',
            'vui.angular',
            'kendo.directives',
            'angulartics',
            'angulartics.piwik',
            'clarity-bridge', // Angular2 based Clarity
            'ui.sortable'
         ]
      )
      .config([
         'vuiModalServiceProvider', 'vuiDialogServiceProvider', 'vuiWizardServiceProvider',
         function(vuiModalServiceProvider, vuiDialogServiceProvider, vuiWizardServiceProvider) {
            vuiModalServiceProvider.setDefaultConfig({
               destroyOnHide: true,
               destroyOuterScope: true
            });

            vuiDialogServiceProvider.setDefaultConfig({
               destroyOnHide: true,
               destroyOuterScope: true
            });
            vuiDialogServiceProvider.setDefaultDialogOptions({
               maximizable: false,
               resizable: false,
               draggable: true,
               resizeMinWidth: 320,
               resizeMinHeight: 320
            });

            vuiWizardServiceProvider.setDefaultConfig({
               destroyOnHide: true,
               destroyOuterScope: true
            });
            vuiWizardServiceProvider.setDefaultWizardOptions({
               maximizable: true,
               resizable: true,
               draggable: true,
               resizeMinWidth: 700,
               resizeMinHeight: 420,
               closeOnEsc: true
            });
         }])
      .config([
         '$compileProvider', '$httpProvider', function ($compileProvider, $httpProvider) {
            $compileProvider.aHrefSanitizationWhitelist(
                  /^\s*((https?|ftp|mailto|tel|file|vmrc):|(javascript:((void\(0\))?;?|(\/{2})))$)/);
            $compileProvider.debugInfoEnabled(h5.debug);

            $httpProvider.defaults.xsrfCookieName = h5.xsrfCookieName;
            $httpProvider.defaults.xsrfHeaderName = h5.xsrfHeaderName;

            // Disables the compilation of directives on comments.
            // Results in a compilation performance gain.
            $compileProvider.commentDirectivesEnabled(false);
            // Disables the compilation of directives on element classes.
            // Results in a compilation performance gain.
            $compileProvider.cssClassDirectivesEnabled(false);

         }])
      .config(['$qProvider', function($qProvider) {
         // Possibly unhandled rejected promises will be logged to the
         // $exceptionHandler. Normally, that means that an error will be
         // logged to the console, but in tests $exceptionHandler will
         // (by default) re-throw any exceptions.
         // Tests that are affected by this change.
         // Adding this config option to keep 1.5 - 1.6 compatibility.
         // https://docs.angularjs.org/guide/migration#migrate1.5to1.6-ng-services-$q
         $qProvider.errorOnUnhandledRejections(false);
      }])
      .config(['$locationProvider', function ($locationProvider) {
         // Angular 1.6 introduces '!' as default hash prefix.
         // Adding this config option to keep 1.5 - 1.6 compatibility.
         // https://docs.angularjs.org/guide/migration#commit-aa077e8
         $locationProvider.hashPrefix('');
      }])
      .directive('input', function() {
         // Added for backward compatibility between Angular 1.5 & 1.6
         // https://docs.angularjs.org/guide/migration#migrate1.5to1.6-ng-directives-input%5Bnumber%5D
         return {
            restrict: 'E',
            require: '?ngModel',
            link: function (scope, elem, attrs, ngModelCtrl) {
               // ...that are of type "number" and have `ngModel`...
               if ((attrs.type === 'number') && ngModelCtrl) {
                  // ...remove the `step` validator.
                  delete ngModelCtrl.$validators.step;
               }
            }
         };
      })
      .run(['$rootScope', 'i18nService', '$cookies', 'h5SdkActionService',
         function ($rootScope, i18nService, $cookies, h5SdkActionService) {
         // Adding Language Resources to h5 global variable and $rootScope.
         h5.i18n.getString = i18nService.getString;
         angular.extend($rootScope, {
            i18n: i18nService.getString
         });

         jQuery.ajaxPrefilter(function (options, originalOptions, jqXHR) {
            var xsrfCookie = $cookies.get(h5.xsrfCookieName);
            if (xsrfCookie) {
               jqXHR.setRequestHeader(h5.xsrfHeaderName, xsrfCookie);
            }
         });

         h5SdkActionService.bindActionHandlers();
         }]);

window.h5.h5main = window.h5.h5main || {};
window.h5.h5main.angularModule = angular.module('h5main',
      ['ngAnimate', 'com.vmware.platform.ui', 'angulartics', 'angulartics.piwik']);

var pendingJqueryRequests = [];
var pendingXhrs = {};

// context / right click disabled
if (!h5.debug) {
   if (h5.configuration && h5.configuration.configParams
         && h5.configuration.configParams["browser.context.menu"] === "false") {
      $(window).on('contextmenu', function() {
         return false;
      });
   } else {
      $(document).ready(function() {
         $('#applicationMenuContainer').on('contextmenu', function() {
            return false;
         });
      });
   }

   // Instrumentation to capture pending jQuery requests in addition to
   // pending Angular requests. h5.__getPendingHTTPRequests() is invoked by
   // the SystemTest automation.
   // See https://reviewboard.eng.vmware.com/r/1243537
   (function () {
      $(document).ready(function () {
         (function (open) {
            XMLHttpRequest.prototype.open = function (method, url, async, user, pass) {
               this.addEventListener("loadstart", function () {
                  pendingXhrs[url] = {'method': method};
               }, false);
               this.addEventListener("loadend", function () {
                  delete pendingXhrs[url];
               }, false);
               open.apply(this, arguments);
            };
         })(XMLHttpRequest.prototype.open);

         $(document).ajaxSend(function (evt, xhr, opts) {
            xhr.vmwopts = opts.url + " - " + opts.data;
            pendingJqueryRequests.push(xhr.vmwopts);
            xhr.always(function () {
               var idx = pendingJqueryRequests.indexOf(xhr.vmwopts);
               if (idx === -1) {
                  pendingJqueryRequests = [];
               }
               pendingJqueryRequests.splice(idx, 1);
            });
         });
      });
   })();
}

// plugin clarity specially patched components. Required because they don't port perfectly into Angular 1.x
angular.module("clarity-bridge", []);



/// <reference path="../../../types/clarity/index.d.ts" />
/**
 * Angular 2 downgraded components require special care because content projection with children sub-components breaks
 * These utilities are crafted to let special directives for Clarity tabs, wizard to workaround known Angular defect
 * Goal is to offer tooling for injector detection and expose underlying component
 */
var platform;
(function (platform) {
    var ClarityExtenderService = (function () {
        function ClarityExtenderService($q, $parse) {
            this.$q = $q;
            this.$parse = $parse;
            this.scopePseudoNotationSubstrate();
        }
        // reassemble :scope support for deadhead MS browsers
        ClarityExtenderService.prototype.scopePseudoNotationSubstrate = function () {
            (function (doc, elemProto) {
                try {
                    doc.querySelector(":scope BODY");
                }
                catch (err) {
                    var _loop_1 = function(method) {
                        var nativ = elemProto[method];
                        elemProto[method] = function (selectors) {
                            if (/(^|,)\s*:scope/.test(selectors)) {
                                var id = this.id; // remember
                                this.id = 'scopedPseudo_' + Date.now(); // new unique id
                                selectors = selectors.replace(/((^|,)\s*):scope/g, '$1#' + this.id); // replace :scope with #ID
                                var result = doc[method](selectors); // trigger
                                this.id = id; // restore previous id
                                return result;
                            }
                            else {
                                return nativ.call(this, selectors); // norml routine
                            }
                        };
                    };
                    for (var _i = 0, _a = ['querySelector', 'querySelectorAll']; _i < _a.length; _i++) {
                        var method = _a[_i];
                        _loop_1(method);
                    }
                }
            })(window.document, Element.prototype);
        };
        // utility : host bindings @Input emulated
        ClarityExtenderService.prototype.observeHostToController = function (hostMap, componentInstance, componentScope, componentAttributes) {
            var rules = [], list = Object.keys(hostMap);
            var _loop_2 = function(internalProperty) {
                var externalProperty = hostMap[internalProperty];
                // track rules for assigner
                rules.push([
                    externalProperty,
                    // binder back to live component onchange
                    function (val) {
                        componentInstance[internalProperty] = val;
                    }]);
            };
            for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
                var internalProperty = list_1[_i];
                _loop_2(internalProperty);
            }
            // next, observe
            this.observeHostInputsList(rules, componentScope, componentAttributes);
        };
        // routine :: internally host bindings @Input emulated
        ClarityExtenderService.prototype.observeHostInputsList = function (rules, componentScope, componentAttributes) {
            var _this = this;
            var _loop_3 = function(bindingProperty, valueAssigner) {
                var observedProperty = bindingProperty;
                // unless it doesn't have brackets ( then rewrite )
                if (observedProperty.indexOf("[") !== 0 && observedProperty.substr(observedProperty.length - 1) !== "]") {
                    observedProperty = "[" + componentAttributes.$normalize(observedProperty) + "]"; // prefer ng4 wrapping nomenclature
                }
                componentAttributes.$observe(observedProperty, function (val) {
                    valueAssigner(_this.$parse(val)(componentScope)); // deref expression and call assignment
                });
            };
            for (var _i = 0, rules_1 = rules; _i < rules_1.length; _i++) {
                var _a = rules_1[_i], bindingProperty = _a[0], valueAssigner = _a[1];
                _loop_3(bindingProperty, valueAssigner);
            }
        };
        /**
         * Notes: https://github.com/angular/angular/commit/1367cd9 - believe wiring process to be different
         *
         * In order to enable more control over the wiring of downgraded components and
         * their content (which eventually allows better control over features like
         * injector setup and content projection), it was necessary to change the
         * implementation of the directives generated for downgraded components.
         * The directives are now terminal and manually take care of projecting and
         * compiling their contents in the post-linking function. This is similar to how
         * the dynamic version of `upgrade` does it.
         * This is not expected to affect apps, since the relative order of individual
         * operations is preserved. Still, it is difficult to predict how every possible
         * usecase may be affected.
         * @param elem
         * @returns {any}
         */
        // two ways of preparation : encapsulated
        ClarityExtenderService.prototype.preparingHostComponent = function (elem) {
            var _this = this;
            // note: this reference may not have been fully resolved, due to deep component composition
            //const injectableRef = elem.inheritedData()[this.getInjectorControllerName()],
            var $q = this.$q.defer();
            this.fetchingComponentInjectorReference(elem).then(function (injectableRef) {
                var m = (_a = {}, _a[_this.injectorName] = injectableRef, _a);
                $q.resolve(injectableRef.then
                    ? _this.fetchingHostComponent(m) // injectable unavailable ( still ... processing )
                    : _this.getHostComponent(injectableRef) // grab it by the pointer!
                );
                var _a;
            });
            return $q.promise;
        };
        // ng4 wires downgraded components using a different technique
        // may yield injector OR a promise that resolves to an injector
        ClarityExtenderService.prototype.fetchingComponentInjectorReference = function (elem) {
            var $q = this.$q.defer(), icn = this.getInjectorControllerName(), injectableRef = _getReference();
            if (injectableRef) {
                $q.resolve(injectableRef);
            }
            else {
                // awaits ng4 component fabrication and linking process. must complete no exception
                var _ticker_1 = setInterval(function () {
                    var r = _getReference();
                    if (r) {
                        clearInterval(_ticker_1);
                        $q.resolve(_getReference());
                    }
                }, 0);
            }
            return $q.promise;
            function _getReference() {
                return elem.data(icn);
            }
        };
        // resolves NG4 component from an element: critical piece in normalizing interpretation of nested ng2 components
        ClarityExtenderService.prototype.fetchingHostComponent = function (controllerMap) {
            var _this = this;
            var $q = this.$q.defer();
            var injectorPromise = controllerMap[this.injectorName];
            if (injectorPromise && injectorPromise.then) {
                injectorPromise.then(function (elemInjector) { return $q.resolve(_this.getHostComponent(elemInjector)); });
            }
            else {
                $q.reject(); // malformed
            }
            return $q.promise;
        };
        // for external access in a template to an NG1 directive, resolve its class controller instance ( bound to elem )
        // normalized selector in the form of "clrTabs"
        ClarityExtenderService.prototype.getElementControllerByIdSelector = function (markerId, normalizedSelector, containerNodeElement) {
            if (normalizedSelector.indexOf("-") > 0) {
                return;
            }
            var expandedControllerNotation = "$" + normalizedSelector + "Controller"; //ng1 factory notation
            var $targetElement = angular.element(this.determineContainerDOM(containerNodeElement).querySelector("[" + '\\' + "#" + markerId + "]")); // using marker
            var potentials = $targetElement.data();
            // extract
            var probableClassMatch = Object.keys(potentials)
                .filter(function (k) { return [expandedControllerNotation, normalizedSelector].indexOf(k) >= 0; })
                .map(function (k) { return potentials[k]; });
            if (probableClassMatch.length) {
                return probableClassMatch[0];
            }
        };
        // standard identity technique
        // for external access in a template to an NG4 component decorated with hash notation
        ClarityExtenderService.prototype.getComponentById = function (markerId, containerNodeElement) {
            var $targetElement = angular.element(this.determineContainerDOM(containerNodeElement).querySelector("[" + '\\' + "#" + markerId + "]")); // using marker
            if ($targetElement) {
                var injectableRef = $targetElement.data(this.getInjectorControllerName());
                // injectable has resolved and isn't awaiting
                if (injectableRef && !(typeof injectableRef.then === "function")) {
                    return this.getHostComponent(injectableRef);
                }
            }
        };
        ClarityExtenderService.prototype.determineContainerDOM = function (containerNodeElement) {
            // decide which particle?
            var originalChildNode = containerNodeElement[0];
            // IE misinterprets
            var containerDOM = (originalChildNode && (originalChildNode instanceof HTMLElement || containerNodeElement[0] instanceof HTMLUnknownElement))
                ? containerNodeElement[0]
                : containerNodeElement;
            return containerDOM;
        };
        //internal only for safety:: having an injector, extract the component
        ClarityExtenderService.prototype.getHostComponent = function (ng4Injector) {
            return ng4Injector.view.nodes[0].componentView.component;
            /*
             20170227 - special notes for previous build before view engine refactor from Angular
             let nodeIndex        = 0, // assumption is the component is first in the template where it is defined
             primarySpecCmpId = `compView_${nodeIndex}`; // proven via view_compiler as such - keep a watchful eye
             return ng4Injector._view.ref.internalView[primarySpecCmpId].context; // targeted via component factory
             */
        };
        // find a list of angular DOM fragments in the sub-hierarchy
        ClarityExtenderService.prototype.getChildrenNodesList = function (selector, elem) {
            var scopeDescendants = ":scope "; // baseElement bracing
            //const children: Array<any> = Array.prototype.slice.call(elem.find(selector))
            return Array.prototype.slice.call(elem[0].querySelectorAll(scopeDescendants + selector));
        };
        // find a list of angular components in the sub-hierarchy
        ClarityExtenderService.prototype.getChildrenComponentsList = function (selector, elem) {
            var _this = this;
            return this.getChildrenNodesList(selector, elem)
                .map(function (elem) {
                return _this.getHostComponent(angular.element(elem).data(_this.getInjectorControllerName()));
            });
        };
        // supply ng4 injected promise by its specific compilation phase
        ClarityExtenderService.prototype.augmentRequire = function (requireMap, searchAncestors) {
            if (searchAncestors === void 0) { searchAncestors = true; }
            // generally scan ancestors, unless overrriden
            requireMap[this.injectorName] = searchAncestors ? "^^" : ""; // ng4 downgraded enclosing
            return requireMap;
        };
        Object.defineProperty(ClarityExtenderService.prototype, "injectorName", {
            // canonical definition from the scriptures
            get: function () {
                //return "ng2.Injector"; // ng2
                return "$$angularInjector"; // ng 4 2017
            },
            enumerable: true,
            configurable: true
        });
        // buried in inherited data
        ClarityExtenderService.prototype.getInjectorControllerName = function () {
            return "$" + this.injectorName + "Controller";
        };
        ClarityExtenderService.Metastructure = {
            name: "ClarityExtenderService",
            factory: ["$q", "$parse", function ($q, $parse) { return new ClarityExtenderService($q, $parse); }]
        };
        return ClarityExtenderService;
    }());
    platform.ClarityExtenderService = ClarityExtenderService;
    angular.module("clarity-bridge").service(ClarityExtenderService.Metastructure.name, ClarityExtenderService.Metastructure.factory);
})(platform || (platform = {}));



/// <reference path="../../../types/clarity/index.d.ts" />
var platform;
(function (platform) {
    // missing clarity pieces regenerated
    var DropdownToggleDirective = (function () {
        function DropdownToggleDirective(clarityExtender) {
            var _this = this;
            this.clarityExtender = clarityExtender;
            this.restrict = "A";
            this.link = function (scope, element, attrs, requiredCtrlMap) {
                var clarityDropdown;
                element.addClass("dropdown-toggle"); // styled
                _this.clarityExtender.fetchingHostComponent(requiredCtrlMap).then(function (cmp) { return clarityDropdown = cmp; });
                // behavioral
                element.on("click", function (evt) {
                    clarityDropdown.toggleDropdown();
                });
            };
            // shared state only
            this.require = clarityExtender.augmentRequire({}, true);
        }
        DropdownToggleDirective.Metastructure = {
            name: "clrDropdownToggle",
            factory: ["ClarityExtenderService", function (ClarityExtenderService) { return new DropdownToggleDirective(ClarityExtenderService); }]
        };
        return DropdownToggleDirective;
    }());
    platform.DropdownToggleDirective = DropdownToggleDirective;
    var DropdownItemDirective = (function () {
        function DropdownItemDirective(clarityExtender) {
            this.clarityExtender = clarityExtender;
            this.restrict = "A";
            this.bindToController = {
                "(click)": "&" // item action per click
            };
            this.controller = (function () {
                function class_1($element, clarityExtender) {
                    this.$element = $element;
                    this.clarityExtender = clarityExtender;
                    $element.addClass("dropdown-item"); // styled
                }
                class_1.prototype.$onInit = function () {
                    var _this = this;
                    this.clarityExtender.fetchingHostComponent(this).then(function (cmp) { return _this.clarityDropdown = cmp; });
                    // behavioral : menu item mouse click
                    this.$element.on("click", function (evt) {
                        var outputEvent = _this["(click)"];
                        if (outputEvent) {
                            outputEvent({ "$evt": evt }); // decorate with MouseEvent
                            _this.onDropdownItemClick();
                        }
                    });
                };
                // behavior via clarity
                class_1.prototype.onDropdownItemClick = function () {
                    if (this.clarityDropdown.isMenuClosable && !this.$element.hasClass("disabled")) {
                        this.clarityDropdown.toggleDropdown();
                    }
                };
                class_1.$inject = ["$element", platform.ClarityExtenderService.Metastructure.name];
                return class_1;
            }());
            // shared state only
            this.require = clarityExtender.augmentRequire({}, true);
        }
        // link: angular.IDirectiveLinkFn = (scope: DropdownItemDirectiveScope, element: angular.IAugmentedJQuery, attrs: angular.IAttributes, requiredCtrlMap: any) => { };
        DropdownItemDirective.Metastructure = {
            name: "clrDropdownItem",
            factory: ["ClarityExtenderService", function (ClarityExtenderService) { return new DropdownItemDirective(ClarityExtenderService); }]
        };
        return DropdownItemDirective;
    }());
    platform.DropdownItemDirective = DropdownItemDirective;
    // module definition0
    angular.module("clarity-bridge").directive(DropdownToggleDirective.Metastructure.name, DropdownToggleDirective.Metastructure.factory);
    angular.module("clarity-bridge").directive(DropdownItemDirective.Metastructure.name, DropdownItemDirective.Metastructure.factory);
})(platform || (platform = {}));



/// <reference path="../../../types/clarity/index.d.ts" />
var platform;
(function (platform) {
    // --------------- shim for tabs ----------------------
    var TabsDirective = (function () {
        function TabsDirective(clarityExtender) {
            this.clarityExtender = clarityExtender;
            this.restrict = "E"; //realized like a component
            this.bindToController = {};
            this.hostToController = {};
            this.terminal = false; // no guarantee
            this.controllerAs = "tabsCtrl"; // ng 1.5 needs identifier to bind to controller, remove in later versions?
            this.controller = (function () {
                function TabsDirectiveController($scope, $element, $attrs, $timeout, clarityExtender) {
                    this.$scope = $scope;
                    this.$element = $element;
                    this.$attrs = $attrs;
                    this.$timeout = $timeout;
                    this.clarityExtender = clarityExtender;
                    this.active = false;
                    // host bindings @Input
                }
                TabsDirectiveController.prototype.$onInit = function () {
                };
                TabsDirectiveController.prototype.$postLink = function () {
                    var _this = this;
                    this.clarityExtender.preparingHostComponent(this.$element).then(function (cmp) {
                        _this.clarityTabs = cmp; // bindable component as it's prepared
                        // tick...
                        // Add second argument, temporary solution in order the tests to work
                        _this.timer = _this.$timeout(function () {
                            _this.afterViewInit();
                        }, 0);
                    });
                };
                TabsDirectiveController.prototype.$onDestroy = function () {
                    if (this.timer) {
                        this.$timeout.cancel(this.timer);
                    }
                };
                // Respond after Angular initializes the component's views and child views.
                // @ContentChildren initialized at this sequence
                TabsDirectiveController.prototype.afterViewInit = function () {
                    this.applyComponentPatch();
                    // higher dimension alignment of children TabLink components
                    this.clarityTabs.tabLinkChildren.reset(this.queryTabLinkContentChildren());
                    // higher dimension alignment of children TabContent components
                    this.clarityTabs.tabContentChildren.reset(this.queryTabContentContentChildren());
                    // sync
                    this.clarityTabs.setUpLinksAndContents();
                    // assign safely class references
                    if (Array.isArray(this.tabContentComponentsList)) {
                        this.TabContentClass = this.tabContentComponentsList[0].constructor;
                    }
                    if (Array.isArray(this.tabLinkComponentsList)) {
                        this.TabLinkClass = this.tabLinkComponentsList[0].constructor;
                    }
                };
                // scan within component QueryList
                TabsDirectiveController.prototype.queryTabLinkContentChildren = function () {
                    return this.tabLinkComponentsList = this.clarityExtender.getChildrenComponentsList("> UL > clr-tab-link", this.$element);
                };
                TabsDirectiveController.prototype.queryTabContentContentChildren = function () {
                    return this.tabContentComponentsList = this.clarityExtender.getChildrenComponentsList("> clr-tab-content", this.$element);
                };
                // accommodate shortcoming in AoT builds
                // WRONG  mapped content projection
                TabsDirectiveController.prototype.applyComponentPatch = function () {
                    var _this = this;
                    // organization of "lost" TabContent blocks. bug in downgraded AoT?
                    this.clarityExtender.getChildrenNodesList("> UL > clr-tab-content", this.$element)
                        .forEach(function (sheep) { return _this.$element[0].appendChild(sheep); });
                };
                ;
                TabsDirectiveController.$inject = ["$scope", "$element", "$attrs", "$timeout", 'ClarityExtenderService'];
                return TabsDirectiveController;
            }());
            this.link = function (scope, element, attrs, requiredCtrlMap) {
            };
            // shared state only
            this.controller["HostToController"] = this.hostToController; // static inject
        }
        TabsDirective.Metastructure = {
            name: "clrTabs",
            factory: ["ClarityExtenderService", function (ClarityExtenderService) { return new TabsDirective(ClarityExtenderService); }]
        };
        return TabsDirective;
    }());
    platform.TabsDirective = TabsDirective;
    angular.module("clarity-bridge").directive(TabsDirective.Metastructure.name, TabsDirective.Metastructure.factory);
})(platform || (platform = {}));



var common_ui;
(function (common_ui) {
    var ActionBarController = (function () {
        function ActionBarController(vuiConstants, $log) {
            this.vuiConstants = vuiConstants;
            this.$log = $log;
            this.isDisabled = function (action) {
                if (!action) {
                    return false;
                }
                if (action.enabled === undefined) {
                    return false;
                }
                if (!action.enabled) {
                    return true;
                }
                return false;
            };
        }
        ActionBarController.prototype.isSeparator = function (action) {
            return action === this.vuiConstants.actions.SEPARATOR ? true : false;
        };
        ActionBarController.prototype.isVisible = function (action) {
            if (!action) {
                return true;
            }
            if (action.visible === undefined) {
                return true;
            }
            return action.visible;
        };
        ActionBarController.prototype.hasLabel = function (action) {
            return action.label && action.label.trim().length > 0;
        };
        ActionBarController.prototype.clickAction = function (event, action) {
            // handle event propogation when action is disabled
            if (!action.enabled) {
                event.stopPropagation();
                event.preventDefault();
            }
            else if (angular.isDefined(action.onClick) &&
                angular.isFunction(action.onClick)) {
                action.onClick.call(undefined, event, action);
            }
            else {
                this.$log.warn("No onClick action defined for action id: " +
                    action.id + " label: " + action.label);
            }
        };
        ActionBarController.prototype.hasClarityIcon = function (action) {
            if (!action || !action.iconClass) {
                return false;
            }
            if (action.shape) {
                return true;
            }
            var index = action.iconClass.indexOf("clr:");
            if (index === 0) {
                action.shape = action.iconClass.slice(4);
                return true;
            }
            return false;
        };
        ActionBarController.$inject = ["vuiConstants", "$log"];
        return ActionBarController;
    }());
    var ActionBarComponent = (function () {
        function ActionBarComponent() {
            this.templateUrl = "resources/ui/components/action-bar/action-bar.component.html";
            this.controller = ActionBarController;
            this.bindings = {
                options: "<",
                clrTemplate: "<?"
            };
        }
        return ActionBarComponent;
    }());
    common_ui.ActionBarComponent = ActionBarComponent;
    angular.module("com.vmware.platform.ui")
        .component("actionBar", new ActionBarComponent());
})(common_ui || (common_ui = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Directive for showing a Clarity spinner
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
      .directive('vxActivityIndicator', vxActivityIndicator);

   function vxActivityIndicator () {

      return {
         templateUrl: 'resources/ui/components/activityIndicator/vxActivityIndicator.html',
         transclude: true,
         scope: {
            isInteractive: "=?",
            isVisible: "=",
            title: "@",
            size: "@?",
            loadingAriaLabel: "@?"
         },
         controller: ['$scope', function($scope) {
            this.$onInit = function() {
               $scope.isInteractive = angular.isDefined($scope.isInteractive) ? $scope.isInteractive : true;
            };
         }],
         restrict: "E",
         priority: -500
      };
   }
})();

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
*@ngdoc directive
*@name com.vmware.platform.ui:vxAlert
*@description
*  Directive to create a confirmation or alert dialog
*@example

   <html>
      <div vx-alert='alertOptions'></div>
   </html>

   <script>
   $scope.alertOptions = {
      title: 'new title',
      text: 'Some scary text',
      icon: 'icon-applib-cool-class' // 32x32 px
      visible:true
      confirmOptions: {
         label: 'Yay'
         visible: true,
         disabled: false,
         onClick: function(){
            console.log('yes clicked');
         }
      },
      rejectOptions: {
         label: 'Nay'
         visible: true,
         focused: true,
         disabled: false,
         onClick: function(){
            alert('Reject button clicked or escape pressed');
         }
      }
   };
   </script>
*/
(function() {
var vxAlertTemplateUrl = 'resources/ui/components/alert/vxAlertTemplate.html';

angular
   .module('com.vmware.platform.ui')
   .directive('vxAlert', vxAlert);

vxAlert.$inject = [
   '$templateCache',
   '$document',
   '$timeout'
];

function vxAlert($templateCache, $document, $timeout) {
   return {
      restrict: 'A',
      template: $templateCache.get(vxAlertTemplateUrl),
      scope: {
         vxAlert: '='
      },
      link: function (scope, element, attrs) {
         var ESC_KEYCODE = 27;

         if (!_.isObject(scope.vxAlert)) {
            throw new TypeError('Alert configuration is not an object');
         }

         function onReject() {
            if (_.isObject(scope.vxAlert.rejectOptions) &&
                _.isFunction(scope.vxAlert.rejectOptions.onClick)) {
               scope.vxAlert.rejectOptions.onClick.call(undefined);
            }

            // hide alert
            scope.vxAlert.visible = false;
         }

         var dismissAlertHandler = function (event) {
            // Avoid propagation of any keydown event since some other dialog might be
            // listening for it and trigger undesired functionality as closing the other
            // dialog when the current one on is on focus.
            event.stopImmediatePropagation();

            if (event.which === ESC_KEYCODE || event.keyCode === ESC_KEYCODE) {
               // hide alert
               //  need $apply beacuse digest does not trigger ?
               scope.$apply(function () {
                  onReject();
               });
            }
         };

         scope.vxAlert.htmlSafe = scope.vxAlert.text;

         $document.on('keydown', dismissAlertHandler);

         // clean up bindings
         scope.$on('$destroy', function(){
            $document.off('keydown', dismissAlertHandler);
         });

         // watch the text and replace with safeHtml
         scope.$watch('vxAlert.text', function(oldVal,newVal){
            if(scope.vxAlert.htmlSafe && angular.equals(oldVal, newVal)){
               return;
            }
            scope.vxAlert.htmlSafe = scope.vxAlert.text;
         });

         scope.isConfirmVisible = function (){
            // if not defined default to visible/true
            if ( _.isUndefined(scope.vxAlert.confirmOptions.visible)) {
               scope.vxAlert.confirmOptions.visible = true;
            }
            return scope.vxAlert.confirmOptions.visible ;
         };

         scope.isRejectVisible = function (){
            // if not defined default to visible/true
            if ( _.isUndefined(scope.vxAlert.rejectOptions.visible)) {
               scope.vxAlert.rejectOptions.visible = true ;
            }
            return scope.vxAlert.rejectOptions.visible;
         };

         scope.isConfirmDisabled = function (){
            // if not defined default to not-disabled/false
            if ( _.isUndefined(scope.vxAlert.confirmOptions.disabled)) {
               scope.vxAlert.confirmOptions.disabled = false ;
            }
            return scope.vxAlert.confirmOptions.disabled ;
         };

         scope.isRejectDisabled = function (){
            // if not defined default to not-disabled/false
            if ( _.isUndefined(scope.vxAlert.rejectOptions.disabled)) {
               scope.vxAlert.rejectOptions.disabled = false;
            }
            return scope.vxAlert.rejectOptions.disabled;
         };

         scope.onConfirmClick = function (event){
            if (angular.isDefined(scope.vxAlert.confirmOptions.onClick) &&
                  angular.isFunction(scope.vxAlert.confirmOptions.onClick)) {
               scope.vxAlert.confirmOptions.onClick.call(undefined,event);
            }
            // hide alert right now the alert closes immediately after hitting yes or no
            // TODO: jaked move this to a service and give control to user to close the alert.
            scope.vxAlert.visible = false;
         };

         scope.onRejectClick = onReject;

         scope.getConfirmText = function (){
            return scope.vxAlert.confirmOptions.label  ;
         };

         scope.getRejectText = function (){
            return scope.vxAlert.rejectOptions.label;
         };

         if (scope.vxAlert.rejectOptions.focused) {
            $timeout(function() {
               element.find('.reject-button').focus();
            }, 0);
         }
      }
   };
}
}());

/**
 * the HTML5 autofocus property can be finicky when it comes to dynamically loaded
 * templates and such with AngularJS. Use this simple directive to
 * tame this beast once and for all.
 *
 * Usage:
 * <input type="text" autofocus>
 *
 * License: MIT
 */
(function() {
   angular.module('com.vmware.platform.ui')

      .directive('autofocus', ['$timeout', function($timeout) {
         return {
            restrict: 'A',
            link : function($scope, $element) {
               $timeout(function() {
                  $element[0].focus();
               }, 500);
            }
         };
      }]);
})();


(function() {
   angular.module('com.vmware.platform.ui')

      .directive('autoscrollintoview', ['$timeout', function($timeout) {
         return {
            restrict: 'A',
            link : function($scope, $element, attributes) {
               $timeout(function() {
                  var preferredElement = attributes['autoscrollintoview']
                        ? $element.find(attributes['autoscrollintoview'])[0]
                        : undefined;
                  var elementToScrollTo = preferredElement || $element[0];

                  if (elementToScrollTo) {
                     if (elementToScrollTo.scrollIntoViewIfNeeded) {
                        elementToScrollTo.scrollIntoViewIfNeeded();
                     } else {
                        elementToScrollTo.scrollIntoView(false);
                     }
                  }
               }, 1);
            }
         };
      }]);
})();

/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */

angular.module('com.vmware.platform.ui').directive('vxBindHtmlAndCompile', ['$compile',
   function($compile) {
      return {
         restrict: 'A',
         link: function (scope, element, attrs) {
            scope.$watch( function () {
               return scope.$eval(attrs.vxBindHtmlAndCompile);
            }, function (value) {
               element.html(value && value.toString());
               $compile(element.contents())(scope);
            });
         }
      };
   }]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Click directive, supports different types of click. Eg: long click
 */
angular.module('com.vmware.platform.ui').directive('vxClick', ['$timeout', '$parse',
function($timeout, $parse) {
   return {
      restrict: 'A',
      link: function($scope, iElement, iAttrs, controller){

         var mouseDownTimeout;
         var type;

         function call(locals){
            // execute the expression
            $parse(iAttrs.vxClick)($scope, locals);
            type = locals.$type;
         }

         function mouseDown(evt){
            // TODO mousedown triggerd form Jquery  doesnt have the
            // evet.which populated. This affects testing or programatic triggers
            if (evt.which !== 1) {
               // Only interested in left button clicks.
               return;
            }
            type = null;
            $scope.$apply(function(){
               call({
                  $type: 'mousedown',
                  $event: evt
               });
            });

            mouseDownTimeout = $timeout(function() {
               call({
                  $type: 'slowClick'
               });
            },500);
         }

         function mouseUp(evt){
            if (evt.which !== 1) {
            // Only interested in left button clicks.
               return;
            }
            $timeout.cancel(mouseDownTimeout);
            if (type === 'slowClick') {
               call({
                  $type: 'mouseup'
               });
            } else {
               call({
                  $type: 'click',
                  $event: evt
               });
            }
         }

         function rightClick(evt){
            $scope.$apply(function(){
               call({
                  $type: 'rightclick',
                  $event: evt
               });
            });
         }

         function keyUp(evt){
            if (evt.keyCode === 32) { // space
               call({
                  $type: 'click',
                  $event: evt
               });
            }
         }

         $(iElement).on("mousedown", mouseDown);
         $(iElement).on("mouseup", mouseUp);
         $(iElement).on("contextmenu", rightClick);
         $(iElement).on("keyup", keyUp);
         $(iElement).on("click", function(evt) {
            evt.which = 1;
            mouseDown(evt);
         });


         $scope.$on("$destroy", function(){
            $(iElement).off("mousedown", mouseDown);
            $(iElement).off("mouseup", mouseUp);
            $(iElement).off("contextmenu", rightClick);
            $(iElement).off("keyup", keyUp);
         });
      },
      controller:['$scope', '$element', '$attrs', function($scope, $element, $attrs) {

      }]
   };
}]);
/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Directive for right-click on a data row of a kendo-grid. Given a function callback for the vxDatagridRowRightClick attribute, it calls that function.
 * The function is called passing the (event) parameter. event.data contains the selected data rows in the grid.
 * Usage: Place this on the same element as the vui-datagrid directive.
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxDatagridRowRightClick', vxDatagridRowRightClick);

   vxDatagridRowRightClick.$inject = ['$parse', 'vuiConstants'];

   function vxDatagridRowRightClick($parse, vuiConstants) {
      var directive = {
            link: link
      };
      return directive;

      function link(scope, element, attrs) {
         var fn = null;
         if (attrs.vxDatagridRowRightClick !== '') {
            fn = $parse(attrs.vxDatagridRowRightClick);
         }

         // Find the kendoGrid by using the selector.
         var kendoGrid = element.children('div[kendo-grid]');
         kendoGrid.on('contextmenu', "tr[role='row'][data-uid]", function(event) {

            function rightClickPreselection(currentTarget){
               grid.clearSelection();
               // Select the row that has been right-clicked.
               grid.select(currentTarget); // currentTarget is the row (because of the selector used during event binding).
            }


            if (fn === null) {
               event.preventDefault();
               return;
            }
            event.preventDefault();

            var grid = kendoGrid.data('kendoGrid');

            if (grid.options.selectionMode === vuiConstants.grid.selectionMode.SINGLE) {
               event.data = [grid.dataItem(event.currentTarget)];
               if(attrs.hasOwnProperty('vxDatagridRowRightClickPreselection')) {
                  rightClickPreselection(event.currentTarget);
               }
            } else if (grid.options.selectionMode === vuiConstants.grid.selectionMode.MULTI) {
               var selectedRows = grid.select();
               var dataRows = [];
               for (var i = 0; i < selectedRows.length; i++) {
                  var data = grid.dataItem(selectedRows[i]);
                  dataRows.push(data);
               }
               if (isTargetSelected(dataRows, grid.dataItem(event.currentTarget))) {
                  event.data = dataRows;
               } else {
                  rightClickPreselection(event.currentTarget);
                  event.data = [grid.dataItem(event.currentTarget)];
               }
            }
            var eventCopy = jQuery.extend(true, {}, event);
            var callback = function() {
               fn(scope, {$event:eventCopy});
            };
            scope.$apply(callback);
         });
       }

      /**
       * Is the currently selected target part of the already selected rows?
       * @param dataRows Selected rows in the grid.
       * @param target New row to be selected.
       * @returns {boolean} True if the target is already selected, false otherwise.
       */
      function isTargetSelected(dataRows, target) {
         if (!dataRows || !target) {
            return false;
         }
         for (var i = 0; i < dataRows.length; i++) {
            if (dataRows[i].id === target.id) {
               return true;
            }
         }
         return false;
      }
   }

})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Document click directive. Triggers when the user clicks on the document excluding
 * this directive's dom element and it's children.
 *
 * Most useful for implementing popups/menus.
 *
 * however it is dangerous to continuously be observing
 */
angular.module('com.vmware.platform.ui').directive('vxDocumentClick', ['$timeout', '$parse',
function($timeout, $parse) {
   return {
      restrict: 'A',
      link: function($scope, iElement, iAttrs, controller){

         function call(locals){
            // execute the expression
            $scope.$apply($parse(iAttrs.vxDocumentClick)($scope, locals));
         }

         function onClick(evt){
            if (!$(evt.target).closest(iElement).length){
               call({$event:evt});
            }
         }

         $(document).on("mousedown", onClick);

         $scope.$on("$destroy", function(){
            $(document).off("mousedown", onClick);
         });
      }
   };
}]);

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Directive for right-click. Given a function callback for the vxRightClick attribute, it calls that function.
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxRightClick', vxRightClick);

   vxRightClick.$inject = ['$parse'];

   function vxRightClick($parse) {
      var directive = {
            link: link
      };
      return directive;

      function link(scope, element, attrs) {
         var fn = null;
         if (attrs.vxRightClick !== '') {
            fn = $parse(attrs.vxRightClick);
         }
         element.bind('contextmenu', function(event) {
            if (fn === null) {
               event.preventDefault();
               return;
            }

            scope.$apply(function() {
               event.preventDefault();
               fn(scope, {$event:event});
            });
         });
       }
   }

})();
/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Directive for right-click on a node of a kendo-tree view. Given a function callback for the vxTreeRightClick attribute, it calls that function.
 * The function is called passing the (event) parameter. event.data contains the object reference corresponding to the selected node.
 * Usage: Place this on the element which contains a kendo tree
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui')
         .directive('vxTreeRightClick', vxTreeRightClick);

   vxTreeRightClick.$inject = ['$parse'];

   function vxTreeRightClick($parse) {

      var directive = {
         restrict: 'A',
         link: link
      };
      return directive;


      function link(scope, element, attrs) {
         var fn = null;
         if (attrs.vxTreeRightClick !== '') {
            fn = $parse(attrs.vxTreeRightClick);
         }

         //For contextMenu, kendo uses <filter: ".k-in">
         // http://docs.telerik.com/kendo-ui/web/treeview/how-to/show-context-menu
         element.on('contextmenu', ".k-in", function(event) {
            event.preventDefault();
            if (fn === null) {
               return;
            }

            //prepare the data
            var elClicked = $(event.target);
            var kendoTreeView = element.data('kendoTreeView');
            if (!kendoTreeView) {
               return;
            }
            event.data = kendoTreeView.dataItem(elClicked);

            //envoke the callback
            var callback = function() {
               fn(scope, {$event:event});
            };
            scope.$apply(callback);
         });
      }
   }

})();

// The collapsible directive indicates a block of html that will expand and collapse
// Github link to src: https://github.com/angular-ui/bootstrap/tree/master/src/collapse
// TODO jaked rename to vxCollapse
// TODO jaked remove dependency on transitionService replace with ngAnimate
angular.module('com.vmware.platform.ui').directive('collapse', ['transitionService', function(transitionService) {
   return {
      link: function (scope, element, attrs) {

         var initialAnimSkip = true;
         var currentTransition;

         function doTransition(change) {
            var newTransition = transitionService(element, change);
            if (currentTransition) {
               currentTransition.cancel();
            }
            currentTransition = newTransition;
            newTransition.then(newTransitionDone, newTransitionDone);
            return newTransition;

            function newTransitionDone() {
               // Make sure it's this transition, otherwise, leave it alone.
               if (currentTransition === newTransition) {
                  currentTransition = undefined;
               }
            }
         }

         function expand() {
            if (initialAnimSkip) {
               initialAnimSkip = false;
               expandDone();
            } else {
               element.removeClass('collapse').addClass('collapsing');
               doTransition({ height: element[0].scrollHeight + 'px' }).then(expandDone);
            }
         }

         function expandDone() {
            element.removeClass('collapsing');
            element.addClass('collapse in');
            element.css({height: 'auto'});
         }

         function collapse() {
            if (initialAnimSkip) {
               initialAnimSkip = false;
               collapseDone();
               element.css({height: 0});
            } else {
               // CSS transitions don't work with height: auto,
               // so we have to manually change the height to a specific value
               element.css({ height: element[0].scrollHeight + 'px' });
               //trigger reflow so a browser realizes that height was updated from auto
               // to a specific value
               var x = element[0].offsetWidth;

               element.removeClass('collapse in').addClass('collapsing');

               doTransition({ height: 0 }).then(collapseDone);
            }
         }

         function collapseDone() {
            element.removeClass('collapsing');
            element.addClass('collapse');
         }

         scope.$watch(attrs.collapse, function (shouldCollapse) {
            if (shouldCollapse) {
               collapse();
            } else {
               expand();
            }
         });
      }
   };
}]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Click directive, supports different types of click. Eg: long click
 */
angular.module('com.vmware.platform.ui').directive('vxCollapseIcon', ['$timeout', '$parse',
function($timeout, $parse) {
   return {
      restrict: 'A',
      scope: {
         vxCollapseIcon: '=?'
      },
      template: '<i ng-class="getIcon()" style="margin: 0px;"></i>',
      link: function($scope, iElement, iAttrs, controller){

      },
      controller:['$scope', '$element', '$attrs', function($scope, $element, $attrs) {


         $scope.getIcon = function() {
            return $scope.vxCollapseIcon ? 'vui-icon-caret-gray-right' : 'vui-icon-caret-gray-down';
         };
         $element.on('click', function () {
            $scope.vxCollapseIcon = !$scope.vxCollapseIcon;
         });
      }]
   };
}]);
angular.module('com.vmware.platform.ui')
.run(['columnRenderersRegistry',
      'resourceUtil',
      'taskConstants',
      'i18nService',
      'taskFormatter',
      'entityStatusService',
      '$interpolate',
      'vimEntityEscapingService',
      'iconService',
      function(columnRenderersRegistry, resourceUtil, taskConstants, i18nService,
               taskFormatter, entityStatusService, $interpolate, vimEntityEscapingService, iconService) {
         'use strict';

   columnRenderersRegistry.registerColumnRenderers({
      /**
       * Renderer to render icon and label which is link-enabled in a cell. [e.g. <icon> name(label1)(label2)]
       * @param  {array} props Array of property names, where 1st property is an object reference,
       *  2nd icon property,
       *  3nd is a label property,
       *  4th is tagging labels
       *  5th is tooltip title
       * @param  {object} data  Map of values for icon and label properties.
       * @param {object} config A dictionary (key/value) to control the renderer behavior.
       *  'navigatable' - controls whether a link navigating to the object should be rendered.
       */
      'object-name': function(props, data, config) {
         var objectId = data[props[0]];
         var iconClass = data[props[1]] || '';
         var label = data[props[2]];
         if (!label) {
            return '';
         }
         var labelIds = data[props[3]];
         var title = data[props[4]];
         var taggingLabel = resourceUtil.getTaggingLabelString(labelIds);

         var navigatable = config ? config.navigatable: undefined;

         var options = null;
         if (config && config.extensionName) {
            options = {
               extensionName: config.extensionName
            };
         }
         // TODO - vaivanov - This needs to be reworked to use options object
         return linkRenderer(
               objectId, label + taggingLabel, iconClass, false, options, title, navigatable);
      },

      /**
       * Renderer to render status icon and status label in a cell.
       * @param  {array} props Array of property names, where there is only 1 "status" property
       * @param  {object} data  Map of values for a "status" property.
       */
      'status': function(props, data) {
         var stat = data[props[0]];

         var properties = entityStatusService.statusProperties(stat);

         var label = _.escape(properties.label);

         return '<div ng-non-bindable class="object"><span title="' + label +
               '"><i class="' +  properties.iconClass +'"></i>' + label + '</span></div>';
      },

      'task-status': taskStatus,

      'task-status-first-line': taskStatusFirstLine,

      /**
       * Renderer to render object icon and name as navigable link in a cell if
       * object id is provided, otherwise the object name is displayed as a plain text.
       * @param  {array} props Array of property names, where
       *    1st property is the object reference
       *    2nd property is the object name
       *    3rd property is the object icon
       *    4th property is a custom label to be displayed if the object name is not
       *       available, e.g. if datastore does not belong to a datastore cluster,
       *       the parentPod property of the datastore will be null, so for those
       *       datastores we could want to display a custom label, e.g. --, na, etc.
       *    5th property is a boolean defining if the object exists. If set to
       *    false, the link will be non-navigatable.
       *    6th property is tooltip title
       * @param  {object} data  Map of values for icon and label properties.
       * @param {object} config A dictionary (key/value) to control the renderer behavior.
       *  'navigatable' - controls whether a link navigating to the object should be rendered.
       */
      'object-link': function(props, data, config) {
         var objectId = data[props[0]],
               objectName = data[props[1]],
               objectIcon = props[2],
               customLabel = data[props[3]],
               targetExists = props[4],
               title = data[props[5]],
               displayText; // objectName or customLabel (if objectName not provided)

         displayText = !objectName ? customLabel : objectName;

         var isDisabled = targetExists === false;

         var navigatable = config ? config.navigatable: undefined;
         var focusable = config && config.focusable === true;

         return linkRenderer(objectId, displayText, objectIcon, isDisabled, config, title, navigatable, focusable);
      },

      /**
       * Renderer to render a custom attribute value in a cell.
       * @param {array} props Array of property names, where there is "customValue" and
       *    "@instanceUuid" properties
       * @param {object} data  Map of values for a "customValue" and "@instanceUuid"
       *    properties.
       * @param {object} config Object with custom attribute's 'key' and 'serverGuid' to
       *       identify the correct custom attribute value that matches current cell.
       *       @link config value
       */
      'custom-attr': function(props, data, config) {
         var customAttr = _.find(data.customValue, function(attr) {
            return config.key === attr.key && config.serverGuid === data['@instanceUuid'];
         });
         var value = customAttr ? customAttr.value : "";
         return textWithTooltipRenderer(value, value);
      },

      /**
       * Plain-text renderer. Used when no renderer is specified.
       * @param  {array} props Array of property names.
       * 1st property is displayed both as value and a tooltip.
       * Other properties are ignored.
       *
       * @param  {object} data  Map of values.
       *
       * @param  {boolean} unescapeCharacters (Optional) specifies whether the renderer
       * should unescape special characters such as % / and \.
       */
      'text': function(props, data, unescapeCharacters) {
         return textWithTooltipRenderer(data[props[0]], undefined, unescapeCharacters);
      },

      /**
       * Plain-text renderer. Used when no renderer is specified.
       * @param  {array} props Array of property names.
       * 1st property is displayed.
       * 2nd property is the tootlip of the displayed property.
       * Other properties are ignored.
       *
       * @param  {object} data  Map of values.
       *
       * @param  {boolean} unescapeCharacters (Optional) specifies whether the renderer
       * should unescape special characters such as % / and \.
       */
      'text-with-custom-tooltip': function(props, data, unescapeCharacters) {
         return textWithTooltipRenderer(data[props[0]], data[props[1]], unescapeCharacters);
      },

      /**
       * Multi-line text renderer.
       * @param  {array} props Array of property names. 1st property is displayed.
       * Other properties are ignored
       * @param  {object} data  Map of values.
       */
      'wrapped-text': function(props, data) {
         var value = data[props[0]] !== undefined ? data[props[0]] : '';
         return $('<div/>')
               .attr('ng-non-bindable', '')
               .addClass('line-wrap')
               .text(value)[0].outerHTML;
      },

      /**
       * Renders disabled (grayed out and in italics) text.
       * @param props Array of property names, where:
       *    1st property is the property to display,
       *    2nd property controls whether the text should be rendered as disabled.
       *        The first property will be rendered disabled only when
       *        data[ <2nd property> ] equals 'true'.
       *
       * Other properties are ignored
       * @param  {object} data  Map of values.
       */
      'disabled-text': function(props, data) {
         var textValue = data[props[0]] !== undefined ? data[props[0]] : '';
         var className = 'vertical-aligned-text';
         if (data[props[1]] !== undefined && data[props[1]] === true) {
            className += ' disabled-text';
         }
         return $('<span/>')
               .attr('ng-non-bindable', '')
               .addClass(className)
               .text(textValue)[0].outerHTML;
      },

      /**
       * Renders disabled (grayed out and in italics) text with an icon and a tooltip.
       * @param props Array of property names, where:
       *    1st property is the icon to display,
       *    2st property is the text to display,
       *    3nd property controls whether the text should be rendered as disabled.
       *        The first property will be rendered disabled only when
       *        data[ <2nd property> ] equals 'true'.
       *    4nd property is the tooltip of the displayed property.
       *
       * Other properties are ignored
       * @param  {object} data  Map of values.
       */
      'disabled-text-icon-with-tooltip': function(props, data) {
         var icon = data[props[0]];
         var text = data[props[1]];

         if (typeof text === 'undefined' || text === null) {
            text = '';
         }

         var className = 'vertical-aligned-text';
         if (data[props[2]] !== undefined && data[props[2]] === true) {
            className += ' disabled-text';
         }

         var title = data[props[3]];
         if (typeof title === 'undefined' || title === null) {
            title = text;
         }

         return "<span ng-non-bindable class='" + className + "'>" +
            "<span title='" + _.escape(title) + "' class='object'>" +
                  "<i class='" + _.escape(icon) + "'></i>" + _.escape(text) +
            "</span></span>";
      },

      /**
       * Renders number values (right-aligned).
       * @param props Array of property names, where:
       *    1st property is the property to display
       *
       * Other properties are ignored
       * @param  {object} data  Map of values.
       */
      'number': function(props, data) {
         var textValue = data[props[0]] !== undefined ? data[props[0]] : '';
         return $('<span/>')
               .attr('ng-non-bindable', '')
               .addClass('numeric-text')
               .text(textValue)[0].outerHTML;
      },

      /**
       * Renders an array as a comma-separated list.
       * @param  {array} props Array of property names, where 1st property is
       * the name of the array property. Other properties are ignored
       * @param  {object} data  Map of values, contains the array.
       */
      'array': function(props, data) {
         var items = data[props[0]];
         var displayText = items ? items.join(', ') : '';
         return '<div ng-non-bindable class="line-wrap">' + displayText + '</div>';
      },

      /**
       * Renders a percentage meter
       * @param  {array} props Array of property names. 1st property is displayed.
       * Other properties are ignored
       * @param  {object} data  Map of values, contains the percentage to render.
       */
      'meter': function(props, data) {
         var value = data[props[0]];
         if (!value) {
            value = 0;
         }
         var labelElement = '<span ng-non-bindable>' + value + '%</span>';
         var meterElement = '<vx-resource-meter percentage="' + value + '" orientation="horizontal"/>';
         return '<div class="column-meter">' + labelElement + meterElement + '</div>';
      },

      'progress-bar-cancel-link': progressBar,

      /**
       * Rendering function for Status column, which shows the progress bar
       * while the task is running, otherwise shows the status.
       */
      'task-state': function(clientTaskInfo) {
         var pluginTaskState = getPluginTaskState(clientTaskInfo);
         if (pluginTaskState) {
            return pluginTaskState;
         }
         if (clientTaskInfo.state === taskConstants.status.RUNNING) {
            return progressBar(clientTaskInfo.progress, clientTaskInfo.cancelable,
               clientTaskInfo.pendingCancel,
               'dataItem.onCancelTaskClicked()');
         } else {
            return taskStatus(clientTaskInfo);
         }
      },

      'recent-task-state': function(clientTaskInfo) {
         var pluginTaskState = getPluginTaskState(clientTaskInfo);
         if (pluginTaskState) {
            return pluginTaskState;
         }
         if (clientTaskInfo.state === taskConstants.status.RUNNING) {
            var cancelClass =  clientTaskInfo.cancelable ? 'vui-icon-datagrid-cancel' : 'vui-icon-datagrid-cancel-disabled';
            var onclick = "angular.element('recent-tasks-view').injector().get('recentTasksStoreService').cancelTask('" +
                  clientTaskInfo.key + "', '" + clientTaskInfo.serverGuid + "')";
            return '<div class="horizontal-flex-container">' +
                  '<div class="progress-static flex-column flex-grow-auto">' +
                  '<div class="progress-meter" data-value="' + clientTaskInfo.progress + '"></div>' +
                  '</div>' +
                  '<div role="percentage">' + clientTaskInfo.progress + '%</div>' +
                  '<div role="cancelButton" onclick="' + onclick + '" class="' + cancelClass + '" title="'
                        + i18nService.getString('Common', 'cancel') + '"></div>' +
                  '</div>';
         } else {
            return taskStatus(clientTaskInfo);
         }
      },


      /**
       * Renders an icon and text
       * @param  {array} props Array of property names. 1st property is icon,
       * second is text
       * @param  {object} data  Map of values
       * @param  {boolean} unescapeCharacters (Optional) specifies whether the renderer
       * should unescape special characters such as % / and \.
       */
      'icon-text': function(props, data, unescapeCharacters) {
			return iconTextExRenderer(props, data, null, unescapeCharacters);
      },


      /**
       *
       *
       * @param  {array} props Array of property names. If no renderConfig is
       * specified it is expected the 1st property is the icon, second is the text.
       *
       * @param  {object} data Map of the property values.
       *
       * @param {object} rendererConfig A dictionary (key/value) to contrl the behavior.
       *    'icon' - if the key is specified it should contain the icon class that
       *       provides the icon.
       *    'iconProperty' - usually you won't specify this if you specify an 'icon'
       *       value. Use this key to specify the name of the property in the
       *       'data' map that holds the icon class.
       *    'dataProperty' - use this key to specify the name of the property in the
       *       'data' map that hold the text to show next to the icon.
       *
       *     e.g {
       *       icon: "vx-icon-vcenter"
       *     }
       *     or {
       *       icon: ["vx-warning", "vx-icon-vcenter"]
       *     }
       *
       * @param  {boolean} unescapeCharacters (Optional) specifies whether the renderer
       * should unescape special characters such as % / and \.
       */
      'icon-text-ex': function(props, data, rendererConfig, unescapeCharacters) {
         return iconTextExRenderer(props, data, rendererConfig, unescapeCharacters);
      },

      /**
       * @see linkRenderer
       */
      'link': linkRenderer,

      /**
       * @see linkAndTextRenderer
       */
      'link-and-text': linkAndTextRenderer,

      /**
       * @see issueStatusRenderer
       */
      'issue-status': issueStatusRenderer
   });

   /**
    * Progress bar renderer, which shows a clickable link in order to request
    * cancellation of the current process.
    *
    * @param progress the current progress value
    * @param cancelable boolean if the process is cancelable
    * @param isCancelPending indicates if a request to cancel the task has been
    * dispatched. If so, show the cancelIcon disabled.
    * @param cancelCallback the callback to be called on click of the cancel link
    */
   function progressBar(progress, cancelable, isCancelPending, cancelCallback) {
      return $interpolate(
         '<vx-static-progress-indicator ' +
         'progress="{{ progress }}" ' +
         'enable-cancel-button="{{ cancelable }}" ' +
         'is-cancel-pending="{{ isCancelPending }}" ' +
         'cancel-callback="{{ cancelCallback }}"/>'
      )({
         progress: progress,
         cancelable: cancelable,
         isCancelPending: isCancelPending,
         cancelCallback: cancelCallback
      });
   }

   /**
    * Renderer to render recent tasks status icon and status label.
    * @param clientTaskInfo the task we are rendering
    */
   function taskStatus(clientTaskInfo) {
      var label = _.escape(taskFormatter.getClientErrorOrSimpleStatus(clientTaskInfo));
      if (label && isPluginTask(clientTaskInfo)) {
         label = label.substr(label.indexOf('\n') + 1);
      }
      var iconClass = taskFormatter.getTaskIconByState(clientTaskInfo.state);
      var iconClassAriaLabel = taskFormatter.hasClientError(clientTaskInfo)
            ? _.escape(i18nService.getString("Common", "error")) : "";
      return '<div class="object"><span ng-non-bindable><span ng-non-bindable title="'
            + _.escape(clientTaskInfo.statusSummary) + '"><span class="vui-icon ' + iconClass + '" '
            + (iconClassAriaLabel && 'aria-label="' + iconClassAriaLabel+ '" ')
            + '></span>' + label + '</span></span></div>';
   }

   /**
    * This renderer does what {@link taskStatus} renderer does with the difference that it only shows
    * the first line of a multi-line status string.
    * @param clientTaskInfo the task we are rendering
    * @returns {string}
    */
   function taskStatusFirstLine(clientTaskInfo) {
      var label = _.escape(taskFormatter.getClientErrorOrSimpleStatus(clientTaskInfo));
      if (label) {
         var newLines = label.split(/[\r\n]/g);
         if (newLines.length && newLines.length > 1) {
            label = newLines[0];
            if (isPluginTask(clientTaskInfo)) {
               label = newLines[1];
            }
         }
      }
      var iconClass = taskFormatter.getTaskIconByState(clientTaskInfo.state);
      var iconClassAriaLabel = taskFormatter.hasClientError(clientTaskInfo)
            ? _.escape(i18nService.getString("Common", "error")) : "";
      return '<div class="object"><span ng-non-bindable><span title="'
            + _.escape(clientTaskInfo.statusSummary) + '"><span class="vui-icon ' + iconClass + '" '
            + (iconClassAriaLabel && 'aria-label="' + iconClassAriaLabel + '" ')
            + '></span>' + label + '</span></span></div>';
   }

   /**
    * Null-checks a string and if present, wraps it in a span with a title
    * attribute(to show a tooltip).
    * @param text the text to show
    * @param title the tooltip title to show, if not set text param will be used
    * @param unescapeCharacters (Optional) specifies whether the renderer
    * should unescape special characters such as % / and \.
    */
   function textWithTooltipRenderer(text, title, unescapeCharacters) {
      // just the falsy check incorrectly disregards 0
      if (!text && text !== 0) {
         return '';
      }

      if (typeof title === 'undefined') {
         title = text;
      }

      if (unescapeCharacters) {
         title = vimEntityEscapingService.unescapeSpecialCharacters(title);
         text = vimEntityEscapingService.unescapeSpecialCharacters(text);
      }

      return ['<span ng-non-bindable class="vertical-aligned-text"><span title="',
         _.escape(title), '">', _.escape(text), '</span></span>'].join('');
   }

   /**
    * Renders text/link with an icon.
    * @param objectId the object reference, if not set, will render plain text
    * @param text the text to show
    * @param icon the object icon
    * @param disabled if set to true, the link will be non-navigatable
    * @param options hash of additional options including "extensionName" to specify a custom extension
    * @param title the tooltip title to show, if not set text param will be used
    * @param navigatable indicates whether the link should navigate to the object or not.
    * @param focusable - if set to true the link receives a href attribute
    */
   function linkRenderer(objectId, text, icon, disabled, options, title, navigatable, focusable) {
      var anchorCssClass = '';
      var iconSpan = '';

      if (typeof title === 'undefined') {
         title = text;
      }

      var textElement;
      if (!text) {
         return '';
      }
      if (!!icon) {
         var iconAriaLabel = resourceUtil.getLocalizedEntityType(objectId);
         var iconAriaLabelAttr = "";
         if (iconAriaLabel) {
            iconAriaLabelAttr = ' aria-label="' + _.escape(iconAriaLabel) + '"';
         }
         var iconParts = iconService.parseIcon(icon);
         if (!iconParts[0]) {
            iconSpan = '<span class="' + icon + '"' + iconAriaLabelAttr + ' ></span>';
         } else if (iconParts[0] === 'clr') {
            iconSpan = '<span><clr-icon shape="' + iconParts[1] + '"' + iconAriaLabelAttr+ '></clr-icon></span>';
         }
      }
      if (disabled) {
         anchorCssClass = 'disabled-link';
      }
      // Disable navigation only when `navigatable` is explicitly specified to `false`
      if (navigatable === false) {
         anchorCssClass += ' non-navigatable-link';
      }
      if (!objectId) {
         textElement = textWithTooltipRenderer(text, title);
      } else {
         var extensionName = (options && options.extensionName) || 'vsphere.core.inventory.serverObjectViewsExtension';
         var navParams = [
            '"' + extensionName + '"',
            '"' + objectId + '"'
         ];

         if (options && options.isKendoGrid) {
            var $jqElement = $('<a/>')
               .addClass(anchorCssClass)
               .attr('onClick', "angular.element('recent-tasks-view').injector().get('navigation').navigateToViewAndObject(" + navParams.join(', ') + ")")
               .html([
                  '<span ng-non-bindable>',
                  $('<span/>').attr('title', title).text(text)[0].outerHTML,
                  '</span>'
               ].join(''));
            if (focusable === true && !$jqElement.attr('href')) {
               // just putting a href attribute to the link to make it focusable
               // in order to enable interaction when Enter or Space is pressed on it
               $jqElement.attr('href', '');
            }
            textElement = $jqElement[0].outerHTML;
         } else {
            text = _.escape(text);

            var onclick = navigatable === false ? '' : "ng-click='$root._navigateToViewAndObject(" + navParams.join(', ').replace(/"/g, '&quot;') + ")'";
            var classStr = anchorCssClass ? 'class="' + anchorCssClass + '"' : '';
            // just putting a href attribute to the link to make it focusable
            // in order to enable interaction when Enter or Space is pressed on it
            var href = focusable === true ? ' href ' : '';
            textElement = [
               '<a ' + classStr + ' ' + onclick + href + '>',
               '<span ng-non-bindable="">',
               '<span title="' + _.escape(title) + '">' + text + '</span>',
               '</span>',
               '</a>'].join('');
         }
      }
      return [
         '<div class="object object-link">',
         iconSpan,
         textElement,
         '</div>'].join('');
   }

   /**
    * Renders text with an optional link to an element in front of it.
    * I.e. link: text.
    * @param objectId the object reference, if not set, will not render link
    * @param linkText the text to show on the link, if not set, will not render link
    * @param labelIds the labelIds associated with the given objectId
    * @param plainText the text to show after the link
    * @param textFirst if true renders the text before the link
    * @param styleClass css class to be applied to the link
    */
   function linkAndTextRenderer(objectId, linkText, labelIds, plainText, textFirst, styleClass) {
      var objectLink = '';
      if (objectId && linkText) {
         var labelIdsString = resourceUtil.getTaggingLabelString(labelIds);

         var objectLinkText = textFirst
               ? linkText + labelIdsString
               : linkText + labelIdsString + ':';

         objectLink = $('<a/>')
            .attr('ng-click', '$root._navigateToObject("' + objectId + '")')
            .html([
               '<span ng-non-bindable>',
               $('<span/>')
                  .attr('title', objectLinkText)
                  .text(objectLinkText)[0].outerHTML,
               '</span>'].join(''))[0].outerHTML;
      }

      var wrappedPlainText = $('<span/>')
          .attr('title', plainText)
          .text(plainText)
          [0].outerHTML;

      var elementsArray = textFirst
            ? ['<div class ="' + styleClass + '">', wrappedPlainText, ' ', objectLink, '</div>']
            : ['<div class ="' + styleClass + '">', objectLink, ' ', wrappedPlainText, '</div>'];

      return elementsArray.join('');
   }

   /**
    * Renders an icon with status text for an issue, based on a provided status string.
    * @param status the issue status string as returned by the backend
    */
   function issueStatusRenderer(status) {

      var issueStatusToIconAndLabelMap = {
         'WARNING': {'iconClass': 'vsphere-icon-status-warning',
            'label': i18nService.getString('Common', 'issueStatus.warning')},
         'ERROR': {'iconClass': 'vsphere-icon-status-error',
            'label': i18nService.getString('Common', 'issueStatus.error')},
         'INFO': {'iconClass': 'vui-icon-info',
            'label': i18nService.getString('Common', 'issueStatus.info')},
         'QUESTION': {'iconClass': 'vsphere-icon-status-unkown',
            'label': i18nService.getString('Common', 'issueStatus.questions')}
      };

      if (!status || !issueStatusToIconAndLabelMap[status]) {
         return '';
      }

      return '<span class="' + issueStatusToIconAndLabelMap[status].iconClass + '"></span>' +
           issueStatusToIconAndLabelMap[status].label;
   }


	function iconTextExRenderer(props, data, rendererConfig, unescapeCharacters) {
		var iconClass = "undefined";
		var text = "";

		if (!rendererConfig) {
			iconClass = data[props[0]];
			text = data[props[1]];
			if (unescapeCharacters) {
				text = vimEntityEscapingService
						.unescapeSpecialCharacters(text);
			}
		} else {
			if (rendererConfig.icon) {
				iconClass = rendererConfig.icon;
			} else if (rendererConfig.iconProperty) {
				iconClass = data[rendererConfig.iconProperty];
			} else {
				iconClass = "unspecified";
			}

			if (rendererConfig.dataProperty) {
				text = data[rendererConfig.dataProperty];
				if (unescapeCharacters) {
					text = vimEntityEscapingService
							.unescapeSpecialCharacters(text);
				}
			} else {
				text = data[props[0]];
				if (unescapeCharacters) {
					text = vimEntityEscapingService
							.unescapeSpecialCharacters(text);
				}
			}
		}

		var title = _.escape(text);

		var iconHtml = '';
		if (Array.isArray(iconClass)) {
			_.each(iconClass, function(item) {
				iconHtml += '<i class="' + _.escape(item) + '"></i>';
			});
		} else {
			iconHtml = '<i class="' + _.escape(iconClass) + '"></i>';
		}

		return '<span ng-non-bindable class="object" title="' + title + '">' + iconHtml + _.escape(text) + '</span>';
	}

    function getPluginTaskState(clientTaskInfo) {
        if (isPluginTask(clientTaskInfo) && clientTaskInfo.state === taskConstants.status.RUNNING) {
            return pluginTaskLabelAndSpinner(clientTaskInfo);
        }
        return null;
    }

   function isPluginTask(clientTaskInfo) {
      return clientTaskInfo.taskTypeId === "com.vmware.vsphere.client.PluginDeploymentTask" ||
            clientTaskInfo.taskTypeId === "com.vmware.vsphere.client.PluginDownloadTask" ||
            clientTaskInfo.taskTypeId === "com.vmware.vsphere.client.PluginUndeploymentTask";
   }

   function pluginTaskLabelAndSpinner(clientTaskInfo) {
      var label = _.escape(taskFormatter.getClientErrorOrSimpleStatus(clientTaskInfo));
      return '<span class="spinner spinner-inline"></span><span>&ensp;' + label + '</span>';
   }
}]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Provides columns renderers.
 */
angular.module('com.vmware.platform.ui')
.service('columnRenderersRegistry', function() {
   'use strict';
   var columnRenderers = {};
   return {
      /**
       * Registers a column renderer with the provider.
       * @param  {string} id     Id to reference a rendere
       * @param  {function} columnRenderer The column renderer function
       */
      registerColumnRenderers: function(columnRendererConfig) {
         angular.extend(columnRenderers, columnRendererConfig);
      },
      /**
       * Retrieves a column renderer based on its id.
       * @param  {string} id Id of a column renderer
       * @return {function}    A column renderer
       */
      getColumnRenderer: function(id) {
         return columnRenderers[id];
      }
   };
});
/* Copyright 2013-2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Util methods to help managing resource logic.
 */
(function () {
   'use strict';
   angular.module('com.vmware.platform.ui').factory('resourceUtil', resourceUtil);

   resourceUtil.$inject = ['i18nService', 'defaultUriSchemeUtil'];

   function resourceUtil(i18nService, defaultUriSchemeUtil) {
      return {
         /**
          * Utility function to process and internationalize the labelIds property of an object.
          * @param labelIdsStr: labelIds property of an object - semicolon separated string
          *
          * @return Empty string if there are no label ids provided, otherwise - comma
          *    separated list of internationalized labelIds surrounded in brackets " ( )"
          *    with a leading whitespace.
          */
         getTaggingLabelString: function (labelIdsStr) {
            if (!angular.isString(labelIdsStr)) {
               return '';
            }
            var labelIds = labelIdsStr.split(';');
            var labels = [];

            labelIds.forEach(function (labelId) {
               labelId = labelId.trim();
               if (!labelId) {
                  return;
               }
               var tokens = labelId.split(':');
               var label = '';
               if (tokens.length === 2) {
                  label = i18nService.getString(tokens[0], tokens[1]);
               } else if (tokens.length === 1) {
                  label = i18nService.getString('Common', tokens[0]);
               }

               if (!label) {
                  label = labelId;
               }

               labels.push(label);
            });
            return labels.length === 0 ? '' : (' (' + labels.join(', ') + ')');
         },

         /**
          * Utility function to figure out if that element needs to be italic
          *
          * @param labelIds: labelIds property of an object - semicolon separated string
          * @param primaryIconId: primaryIconId property of an object - semicolon separated string
          *
          * @return string
          * "italic" - the elements has to be italic
          * "" - empty string when no need to be italic
          */
         getItalicClassName: function (labelIds, primaryIconId) {
            var DISCONNECTED = "disconnected";
            var NOT_RESPONDING = "notResponding";
            var INACCESSIBLE = "inaccessible";

            var isDisconnectedOrNotResponding = labelIds && ( labelIds.indexOf(DISCONNECTED) !== -1 || labelIds.indexOf(NOT_RESPONDING) !== -1 );
            var isInaccessible = primaryIconId && primaryIconId.indexOf(INACCESSIBLE) !== -1;
            return ( isDisconnectedOrNotResponding || isInaccessible ) ? "italic" : "";
         },

         /**
          * Returns the localized type for a given object or empty string in case of unknown type.
          */
         getLocalizedEntityType: function (objectId) {
            if (objectId && typeof objectId === "string") {
               var entityType = defaultUriSchemeUtil.getEntityType(objectId);
               switch (entityType) {
                  case "HostSystem":
                     return i18nService.getString("Common", "typeResource.host");
                  case "Datacenter":
                     return i18nService.getString("Common", "typeResource.datacenter");
                  case "Datastore":
                     return i18nService.getString("Common", "typeResource.datastore");
                  case "Folder":
                     if (defaultUriSchemeUtil.isRootFolder(objectId)) {
                        return i18nService.getString("Common", "typeResource.vCenter");
                     }
                     return i18nService.getString("Common", "typeResource.folder");
                  case "VirtualMachine":
                     return i18nService.getString("Common", "typeResource.vm");
                  case "ClusterComputeResource":
                     return i18nService.getString("Common", "typeResource.cluster");
                  case "VirtualApp":
                     return i18nService.getString("Common", "typeResource.vapp");
                  case "ResourcePool":
                     return i18nService.getString("Common", "typeResource.rp");
                  case "Network":
                     return i18nService.getString("Common", "typeResource.network");
                  case "VmwareDistributedVirtualSwitch":
                     return i18nService.getString("Common", "typeResource.dvs");
                  case "DistributedVirtualPortgroup":
                     return i18nService.getString("Common", "typeResource.dvpg");
                  case "StoragePod":
                     return i18nService.getString("Common", "typeResource.storagePod");
               }
            }
            return "";
         }
      };
   }
})();
angular.module('com.vmware.platform.ui').directive('vxDatagridPreselectItem', [
   '$timeout', 'vuiConstants', '$log',
   function ($timeout, vuiConstants, $log) {
      return {
         link: function ($scope, element, attributes) {
            $scope.$on('kendoWidgetCreated', function (e, widget) {
               var isDestroyed = false;
               if (attributes.vxDatagridPreselectItem === 'false') {
                  return;
               }

               var grid = element.find('[kendo-grid]').data("kendoGrid");

               if(widget !== grid) {
                  return;
               }

               var ensurePreselectionVisibility = attributes.ensurePreselectionVisibility
                     && attributes.ensurePreselectionVisibility !== "false";

               if(ensurePreselectionVisibility) {
                  var animateToPreselected = true;
                  var currentPage = grid.dataSource.page();
               }

               function onGridPageChange () {
                  var newPage = grid.dataSource.page();
                  animateToPreselected = newPage === currentPage;
                  currentPage = newPage;
               }

               function selectRow() {
                  if(attributes.vxDatagridPreselectItem) {
                     selectSpecificRow();
                  } else {
                     selectFirstRow();
                  }
               }

               function selectFirstRow() {
                  grid.select(element.find(".k-selectable tr:first"));
               }

               function selectSpecificRow() {
                  if (attributes.preselectComparator) {
                     var cmp = null;
                     if (attributes.preselectComparator
                        && attributes.preselectComparator.indexOf('.') !== -1) {
                        //for nested scope values ($ctrl.anotherLevel.myPreSelectComparator)
                        // we need to perform lookups one after another
                        var nestedKeys = attributes.preselectComparator.split('.');
                        var current = $scope;
                        while (nestedKeys.length) {
                           var key = nestedKeys.shift();
                           current = current[key];
                        }
                        cmp = current;
                     } else {
                        cmp = $scope[attributes.preselectComparator];
                     }
                     if (!cmp) {
                        $log.warn('Pre-select comparator "' + attributes.preselectComparator + '" is not undefined!');
                        return;
                     }
                     grid.items().each(function() {
                        var data = grid.dataItem(this);
                        if (cmp(data)) {
                           if (grid.options.selectionMode === vuiConstants.grid.selectionMode.MULTI) {
                              var row = this;
                              // When grid is in multiple selection mode,
                              // trigger selection inside a timeout to avoid
                              // a digest loop.
                              $timeout(function() {
                                 grid.select(row);
                              }, 0);
                           } else {
                              grid.select(this);
                           }
                           var gridContent = $(this).closest('.k-grid-content');
                           gridContent[0].scrollTop = gridContent[0].scrollTop + $(this).position().top;
                        }
                     });
                  } else {
                     var selector = ".k-selectable tr:contains('" + attributes.vxDatagridPreselectItem + "')";
                     grid.select(element.find(selector));
                  }

                  if(ensurePreselectionVisibility && animateToPreselected) {
                     scrollToPreselection();
                  }
               }

               function scrollToPreselection() {
                  $timeout(function() {
                     if (!element) {
                        return;
                     }
                     var grid = element.find('div[kendo-grid]').data("kendoGrid");

                     if (!grid || !grid.select().length) {
                        return;
                     }

                     var vs = grid.wrapper.find('.k-grid-content').data('kendoVirtualScrollable');
                     if (!vs) {
                        return;
                     }

                     // The height from the beginig of the list to the begining of the selected item
                     var selectedItemRelativePosition = grid.select().position().top;
                     // The height from the begionign to the first visible item
                     var vsScrollTop = vs.verticalScrollbar.scrollTop();
                     // The height of the visible part of the grid
                     var gridInnerHeight = vs.verticalScrollbar.innerHeight();

                     var topVisiblePosition = vsScrollTop;
                     var bottomVisiblePosition = vsScrollTop + gridInnerHeight;
                     var positionToScrollTo = 0;

                     // The following logic should apply:
                     // If the current position of the selected element is withing the
                     // visible area of the grid - no need to scroll.
                     // If the element is not in visible position
                     // scroll it on the top of the list.
                     if(selectedItemRelativePosition <= topVisiblePosition) {
                        positionToScrollTo = selectedItemRelativePosition;
                     }
                     if(selectedItemRelativePosition > topVisiblePosition
                           && selectedItemRelativePosition < bottomVisiblePosition) {
                        positionToScrollTo = vsScrollTop;
                     }
                     if(bottomVisiblePosition <= selectedItemRelativePosition) {
                        positionToScrollTo = selectedItemRelativePosition;
                     }

                     vs.verticalScrollbar.animate({ scrollTop:  positionToScrollTo}, 400);
                  }, 0);
               }

               if (attributes.hasOwnProperty('reselectOnChange')) {
                  attributes.$observe('vxDatagridPreselectItem', function () {
                     selectSpecificRow();
                  });

                  $scope.$watch(attributes.vuiDatagrid + '.data', function (newData) {
                     if (newData) {
                        $timeout(function () {
                           if(!isDestroyed) {
                              selectSpecificRow();
                           }
                        }, 0);
                     }
                  });
                  $scope.$on('$destroy', function() {
                     isDestroyed = true;
                  });
               }

               if(grid.items().length > 0){
                  // we have the data, select it now
                  selectRow();
               } else {
                  // wait for data, then select the first row
                  grid.bind("dataBound", function() {
                     if(ensurePreselectionVisibility) {
                        onGridPageChange();
                     }
                     selectRow();
                  });
               }
            });
         }
      };
   }
]);

angular.module('com.vmware.platform.ui').directive('vxMultiDatagridContainer', [
   function () {
      return {
         link: function ($scope, element) {
            $scope.$on('vx-multi-datagrid.selection-changed', function (event, triggeringEl) {
               clearOtherDatagrids(element, triggeringEl);
            });
         }
      };

      function clearOtherDatagrids(element, triggeringEl) {
         var datagrids = element.find('[vx-multi-datagrid-member]');
         datagrids.each(function (i, childDatagrid) {
            if (childDatagrid !== triggeringEl[0]) {
               $(childDatagrid).find('[kendo-grid]').data('kendoGrid').clearSelection();
            }
         });
      }
   }]);

angular.module('com.vmware.platform.ui').directive('vxMultiDatagridMember', [
   function () {
      return {
         link: function ($scope, element, attributes) {
            onSelection($scope, attributes, function(){
               $scope.$emit('vx-multi-datagrid.selection-changed', element);
            });
         }
      };

      function onSelection($scope, attributes, fn) {
         $scope.$watch(attributes.vuiDatagrid + '.selectedItems', function(selectedItems){
            if(selectedItems.length > 0) {
               fn();
            }
         });
      }
   }]);
/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Resizes the contained kendo grid to fill it's parent (i.e. have 100% height)
 */
angular.module('com.vmware.platform.ui').directive('vxStretchGrid', [
function() {
   'use strict';
   return {
      restrict: 'A',
      link: function(scope, element) {
         scope.$on('resize', resizeGrid);

         function resizeGrid() {
            kendo.resize(element, true);
         }

         scope.$on('kendoWidgetCreated', function(event, widget) {
            if (!widget || widget.constructor !== kendo.ui.Grid) {
               return;
            }

            widget.resize = _.wrap(widget.resize, function(originalResize) {
               var args = Array.prototype.slice.call(arguments, 1);
               // force resize
               if (args.length === 0) {
                  args.push(true);
               } else {
                  args[0] = true;
               }

               return originalResize.apply(widget, args);
            });

            widget._setContentHeight = function() {
               var that = this,
                  options = that.options,
                  height = that.wrapper.innerHeight(),
                  header = that.wrapper.children(".k-grid-header"),
                  scrollbar = kendo.support.scrollbar();

               if (options.scrollable && that.wrapper.is(":visible")) {

                  height -= header.outerHeight();

                  if (that.pager) {
                     height -= that.pager.element.outerHeight();
                  }

                  if(options.groupable) {
                     height -= that.wrapper.children(".k-grouping-header").outerHeight();
                  }

                  if(options.toolbar) {
                     height -= that.wrapper.children(".k-grid-toolbar").outerHeight();
                  }

                  if (that.footerTemplate) {
                     height -= that.wrapper.children(".k-grid-footer").outerHeight();
                  }

                  var isGridHeightSet = function(el) {
                     var initialHeight, newHeight;
                     if (el[0].style.height) {
                        return true;
                     } else {
                        initialHeight = el.height();
                     }

                     el.height("auto");
                     newHeight = el.height();

                     if (initialHeight !== newHeight) {
                        el.height("");
                        return true;
                     }
                     el.height("");
                     return false;
                  };

                  if (isGridHeightSet(that.wrapper)) { // set content height only if needed
                     if (height > scrollbar * 2) { // do not set height if proper scrollbar cannot be displayed
                        if (that.lockedContent) {
                           scrollbar = that.table[0].offsetWidth > that.table.parent()[0].clientWidth ? scrollbar : 0;
                           that.lockedContent.outerHeight(height - scrollbar);
                        }

                        that.content.outerHeight(height);
                     } else {
                        that.content.outerHeight(scrollbar * 2 + 1);
                     }
                  }
               }
            };

            resizeGrid();
         });
      }
   };
}]);

/* Copyright 2017 Vmware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var DatastoreFileBrowserController = (function () {
        function DatastoreFileBrowserController(datastoreBrowserConstants, defaultUriSchemeUtil, i18nService, vuiConstants) {
            this.datastoreBrowserConstants = datastoreBrowserConstants;
            this.defaultUriSchemeUtil = defaultUriSchemeUtil;
            this.vuiConstants = vuiConstants;
            this.FOLDER_TYPE = "folder";
            this.DATASTORE_TYPE = "datastore";
            this.FILE_TYPE = "file";
            this.areContentItemsLoading = false;
            this.dsBrowserTreeAccessor = {};
            this.splitterOptions = {
                orientation: this.vuiConstants.splitter.orientation.HORIZONTAL,
                panes: [
                    {
                        min: "250px",
                        size: "35%"
                    }, {
                        min: "250px",
                        size: "35%"
                    }, {
                        min: "200px",
                        size: "30%"
                    }
                ]
            };
            this.i18n = i18nService.getString;
        }
        DatastoreFileBrowserController.prototype.$onInit = function () {
            this.fileQueryType = this.initialFileQueryType;
            this.selectedFileQueryType = this.filterFileQueryTypes && this.filterFileQueryTypes.length > 0 ?
                this.filterFileQueryTypes[0] : undefined;
        };
        DatastoreFileBrowserController.prototype.clearContentItems = function () {
            this.contentItems = [];
            this.selectedFile = null;
            this.notifySelectedFileChanged();
        };
        DatastoreFileBrowserController.prototype.selectedTreeItemChanged = function (selectedTreeItem) {
            this.clearContentItems();
            this.selectedTreeItem = selectedTreeItem;
            this.areContentItemsLoading = true;
        };
        DatastoreFileBrowserController.prototype.selectedTreeItemFilesLoaded = function (selectedTreeItemContentFiles) {
            this.areContentItemsLoading = false;
            this.contentItems = selectedTreeItemContentFiles;
            if (this.contentItems && this.contentItems.length === 1) {
                var item = this.contentItems[0];
                if (item.type === this.FILE_TYPE && !this.disablePreselect) {
                    // if only one file is available in the contents panel
                    // preselect it
                    this.selectedContentItemChanged(item);
                }
            }
        };
        DatastoreFileBrowserController.prototype.selectedContentItemChanged = function (selectedItem) {
            var newItem = null;
            if (selectedItem.type === this.FOLDER_TYPE) {
                this.dsBrowserTreeAccessor.selectChildItem(selectedItem.path);
            }
            else {
                newItem = selectedItem;
            }
            this.selectedFile = newItem;
            this.notifySelectedFileChanged();
        };
        DatastoreFileBrowserController.prototype.notifySelectedFileChanged = function () {
            if (this.selectedFileChanged) {
                this.selectedFileChanged({ selectedFile: this.selectedFile });
            }
        };
        DatastoreFileBrowserController.prototype.fileQueryTypeChange = function (selectedFileType) {
            this.clearContentItems();
            this.fileQueryType = selectedFileType.value;
            if (this.dsBrowserTreeAccessor.reloadContentFiles) {
                this.areContentItemsLoading = true;
                this.dsBrowserTreeAccessor.reloadContentFiles(this.fileQueryType);
            }
        };
        ;
        DatastoreFileBrowserController.prototype.isDatastoreItemSelected = function () {
            if (!this.selectedTreeItem) {
                return false;
            }
            return this.selectedTreeItem.type === this.DATASTORE_TYPE;
        };
        DatastoreFileBrowserController.prototype.isFolderItemSelected = function () {
            if (!this.selectedTreeItem) {
                return false;
            }
            return this.selectedTreeItem.type === this.FOLDER_TYPE;
        };
        DatastoreFileBrowserController.prototype.isFileItemSelected = function () {
            if (!this.selectedFile) {
                return false;
            }
            return this.selectedFile.type === this.FILE_TYPE;
        };
        ;
        DatastoreFileBrowserController.$inject = ["datastoreBrowserConstants", "defaultUriSchemeUtil",
            "i18nService", "vuiConstants"];
        return DatastoreFileBrowserController;
    }());
    platform.DatastoreFileBrowserController = DatastoreFileBrowserController;
    var DatastoreFileBrowserComponent = (function () {
        function DatastoreFileBrowserComponent() {
            this.bindings = {
                objectId: "<",
                datastoreIds: "<",
                initialFileQueryType: "<",
                filterFileQueryTypes: "<?",
                showVmImagesFolder: "<",
                selectedFile: "=?",
                selectedFileChanged: "&",
                selectedTreeItem: "=?",
                disablePreselect: "<?"
            };
            this.controller = DatastoreFileBrowserController;
            this.templateUrl = "resources/ui/components/datastore-file-browser/datastore-file-browser.html";
        }
        return DatastoreFileBrowserComponent;
    }());
    platform.DatastoreFileBrowserComponent = DatastoreFileBrowserComponent;
    angular.module("com.vmware.platform.ui")
        .component("datastoreFileBrowser", new DatastoreFileBrowserComponent());
})(platform || (platform = {}));



/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Datastore browser directive that creates a kendo tree view by dynamically loading the
 * tree nodes from the server based on object ref and/or provided datastore uids.
 *
 * Example:
 * 1) datastore browser tree declaration
 * <div
 *    datastore-browser-tree
 *    object-ref="objRef"
 *    datastores="datastoreUids"
 *    file-query-type="fileQueryType"
 *    show-vm-images-folder="showVmImagesFolder"
 *    on-selected-item-changed="selectedTreeItemChanged(item)"
 *    on-selected-item-files-loaded="selectedTreeItemFilesLoaded(contentFiles)"
 *    accessor="dsBrowserTreeAccessor"></div>
 *
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').directive('datastoreBrowserTree', datastoreBrowserTree);

   datastoreBrowserTree.$inject = ['datastoreBrowserTreeService', 'datastoreBrowserConstants', '$q', '$timeout', 'logService'];

   function datastoreBrowserTree(datastoreBrowserTreeService, datastoreBrowserConstants, $q, $timeout, logService) {

      var directive = {
         scope: {
            objectRef: '=', // The object which the datastore browser will be invoked for.
            datastores: '=?',  //Array of ServerObjectRef pointing to datastore to show
                                 // at root level of browsing tree
            fileQueryType: '=?', // The query type of the files that need to be shown.
                                 // It can be a combination of all possible bit flags
                                 // defined in datastoreBrowserConstants.fileQueryType
            selectAndExpandFirstRootItem: '=?', // Optional flag, if set to true, the first
                                                // root item will be automatically selected
                                                // and expanded.
            showVmImagesFolder: '=?',
            initializationCompleted: '&onInitializationCompleted',
            selectedItemChanged: '&onSelectedItemChanged',
            selectedItemFilesLoaded: '&onSelectedItemFilesLoaded',
            accessor: '=' // accessor pattern to make it easy to call the directive
                          // functions from hosting components. Used to call the
                          // directive's 'reloadContentFiles' function when file type
                          // for filtering files is changed
         },
         link: link
      };

      var _logger = logService('datastoreBrowserTree');

      return directive;

      function link(scope, element, attrs) {
         var dsBrowserKendoTree, // kendo tree object
            dataSource,
            dataSourceOptions, // data source and options for the kendo tree
            dataSourceItemIdPropName = 'path';

         var _lastContentFilesPromise;
         var _contentFilesRequestCanceller;
         var _pendingLoadTreeRequestsCancellers = [];

         var bindOnInitializationCompleted = !!attrs.onInitializationCompleted;
         var bindOnSelectedItemChanged = !!attrs.onSelectedItemChanged;
         var bindOnSelectedItemFilesLoaded = !!attrs.onSelectedItemFilesLoaded;
         var selectAndExpandFirstRootItem = attrs.selectAndExpandFirstRootItem !== undefined;
         var initialLoadingCompleted = false;

         scope.$on('$destroy', function() {
            cancelContentFilesRequest();

            _.forEach(_pendingLoadTreeRequestsCancellers, function(canceller) {
               canceller.resolve();
            });
            _pendingLoadTreeRequestsCancellers = [];
         });

         // build kendo tree data source
         dataSource = getKendoDataSource();

         dataSourceOptions = {
            dataSource: dataSource,
            dataTextField: ['name']
         };

         dataSourceOptions.select = function (event) {
            var selectedDataItem = dsBrowserKendoTree.dataItem(event.node);
            notifySelectionChangeListener(selectedDataItem);
            // No need to retrieve the content for the currently selected
            // item in case the onSelectedItemFilesLoaded callback is missing.
            if (bindOnSelectedItemFilesLoaded) {
               reloadContentFilesInternal(selectedDataItem.path);
            }
         };

         // create kendo tree view
         dsBrowserKendoTree = element.kendoTreeView(dataSourceOptions).data('kendoTreeView');
         element.attr('vui-tree-view', '');

         function loadTreeItems(options) {
            var expandingItemId, expandingItemData, loadingRoot, promise;

            expandingItemId = options.data && options.data[dataSourceItemIdPropName];
            loadingRoot = !expandingItemId;
            if (loadingRoot) {
               promise = datastoreBrowserTreeService.getRoot(
                     scope.objectRef,
                     scope.datastores,
                     scope.showVmImagesFolder);
            } else {
               expandingItemData = dsBrowserKendoTree.dataSource.get(expandingItemId);
               var getChildrenCanceller = $q.defer();
               _pendingLoadTreeRequestsCancellers.push(getChildrenCanceller);
               promise = datastoreBrowserTreeService.getChildren(
                     scope.objectRef,
                     expandingItemData.path,
                     datastoreBrowserConstants.fileQueryType.FOLDERS,
                     getChildrenCanceller.promise).finally(function() {
                        var index = _pendingLoadTreeRequestsCancellers.indexOf(getChildrenCanceller);
                        if (index >= 0) {
                           _pendingLoadTreeRequestsCancellers.splice(index, 1);
                        }
                     });
            }

            promise.then(function (data) {
               _.forEach(data, function(item) {
                  if (item.friendlyName) {
                     item.name = item.friendlyName;
                  }
               });
               options.success(data);
               if (loadingRoot) {
                  notifyInitializationCompleteListener(data);

                  // Select and expand root item only during the initial loading.
                  if (!initialLoadingCompleted) {
                     selectExpandFirstRootItem();
                     initialLoadingCompleted = true;
                  }
               }
            });
         }

         function reloadContentFilesInternal(selectedTreeItemFilePath) {

            cancelContentFilesRequest();
            _contentFilesRequestCanceller = $q.defer();

            var contentFilesPromise = datastoreBrowserTreeService.getChildren(
                  scope.objectRef,
                  selectedTreeItemFilePath,
                  scope.fileQueryType,
                  _contentFilesRequestCanceller.promise);

            // Save the current promise
            _lastContentFilesPromise = contentFilesPromise;

            contentFilesPromise.then(function(data) {
               // Ignore all responses which are not related to the
               // last saved promise
               if (contentFilesPromise === _lastContentFilesPromise) {
                  _contentFilesRequestCanceller = null;
                  notifySelectedItemFilesLoadedListener(data);
               }
            });
         }

         function cancelContentFilesRequest() {
            if (_contentFilesRequestCanceller) {
               _contentFilesRequestCanceller.resolve();
            }
         }

         // accessor pattern used to make it easy to call the directive function
         // for reloading the content files when file type is changed easier
         if (scope.accessor) {

            scope.accessor.reloadData = function() {
               initialLoadingCompleted = false;
               dsBrowserKendoTree.setDataSource(getKendoDataSource());
            };

            scope.accessor.reloadContentFiles = function (newFileQueryType) {
               var selectedNode, selectedDataItem;

               if (newFileQueryType) {
                  scope.fileQueryType = newFileQueryType;
               }
               selectedNode = dsBrowserKendoTree.select();
               selectedDataItem = dsBrowserKendoTree.dataItem(selectedNode);
               if (!selectedDataItem) {
                  return;
               }
               reloadContentFilesInternal(selectedDataItem.path);
            };

            scope.accessor.refreshTreeNode = function (folderPath) {
               var dataItem = dsBrowserKendoTree.dataSource.get(folderPath);
               if (dataItem) {
                  try {
                     // mark the node as not loaded
                     dataItem.loaded(false);

                     if (dataItem.expanded) {
                        // Re-load the node only if expanded.
                        // Non-expanded nodes will be loaded when the user
                        // expands them.
                        dataItem.load();
                     }

                     // get the currently selected node
                     var selectedNode = dsBrowserKendoTree.select();
                     var selectedDataItem = dsBrowserKendoTree.dataItem(selectedNode);

                     if (selectedNode && !selectedDataItem) {
                        // currently selected node is no longer available
                        // trigger full refresh
                        scope.accessor.refreshTree();
                        return;
                     }

                     if (selectedDataItem[dataSourceItemIdPropName] === folderPath) {
                        // if we are refreshing the currently selected node we should also
                        // reload its content files.
                        scope.accessor.reloadContentFiles();
                     }

                  } catch (error) {
                     _logger.error("Failed reloading element: " + error.message);
                  }
               }
            };

            // Refreshes the tree, expands and pre-selects the currently selected node
            scope.accessor.refreshTree = function () {
               if (scope.isRefreshing) {
                  // Ignore the refresh action, if we are currently refreshing the tree
                  return;
               }

               // Guard against never ending refresh
               // It might happen that the kendo expansion stuck in the middle and this
               // will result in never ending refresh. That's why we need this guard
               var timeoutPromise = $timeout(function () {
                  scope.isRefreshing = false;
               }, 10000);

               scope.isRefreshing = true;
               var selectedNode = dsBrowserKendoTree.select();
               var selectedDataItem = dsBrowserKendoTree.dataItem(selectedNode);
               if (!selectedDataItem) {
                  // If there is no selection, just refresh the tree
                  refreshTreeInternal().then(function () {
                     scope.isRefreshing = false;
                     $timeout.cancel(timeoutPromise);
                  });
                  return;
               }

               notifySelectionChangeListener();

               var parentNode = dsBrowserKendoTree.parent(selectedNode);
               var parentDataItem = dsBrowserKendoTree.dataItem(parentNode);

               var expandedPath = selectedDataItem.expanded ? [selectedDataItem[dataSourceItemIdPropName]] : [];
               while (parentDataItem) {
                  expandedPath.splice(0, 0, parentDataItem[dataSourceItemIdPropName]);

                  parentNode = dsBrowserKendoTree.parent(parentNode);
                  parentDataItem = dsBrowserKendoTree.dataItem(parentNode);
               }

               var refreshTreePromise = refreshTreeInternal();
               refreshTreePromise.then(function () {
                  expandPath(expandedPath).then(function () {
                     if(!selectItem(selectedDataItem[dataSourceItemIdPropName])) {
                        // If the old selection cannot be restored
                        // Select and expand the root if configured
                        selectExpandFirstRootItem();
                     }
                     scope.isRefreshing = false;
                     $timeout.cancel(timeoutPromise);
                  });
               });
            };

            /**
             * Selects a child item of the currently selected item.
             */
            scope.accessor.selectChildItem = function(childItemId) {
               var selectedNode = dsBrowserKendoTree.select(); // parent of item
               var selectedDataItem = dsBrowserKendoTree.dataItem(selectedNode);
               if (!selectedDataItem) {
                  return;
               }

               var parentNode = dsBrowserKendoTree.parent(selectedNode);
               var parentDataItem = dsBrowserKendoTree.dataItem(parentNode);

               var expandedPath = [selectedDataItem[dataSourceItemIdPropName]];
               while (parentDataItem) {
                  expandedPath.splice(0, 0, parentDataItem[dataSourceItemIdPropName]);

                  parentNode = dsBrowserKendoTree.parent(parentNode);
                  parentDataItem = dsBrowserKendoTree.dataItem(parentNode);
               }

               expandPath(expandedPath).then(function() {
                  selectItem(childItemId);
               });

            };
         }

         function expandPath(expandedPath) {
            var deferred = $q.defer();
            dsBrowserKendoTree.expandPath(expandedPath, function() {
               deferred.resolve();
            });

            return deferred.promise;
         }

         function selectItem(itemId) {
            // Selecting the previously selected node
            var dataItem = dsBrowserKendoTree.dataSource.get(itemId);
            var node;
            if (dataItem) {
               try {
                  node = dsBrowserKendoTree.findByUid(dataItem.uid);
                  dsBrowserKendoTree.select(node);

                  // trigger the select event because programatically selecting node does not trigger it
                  dsBrowserKendoTree.trigger('select', {node: node});
               } catch (error) {
                  _logger.error("Failed selecting element: " + error.message);
               }
            }

            return !!node;
         }

         function selectExpandFirstRootItem() {
            var data = dsBrowserKendoTree.dataSource.data();
            if (selectAndExpandFirstRootItem && data && data.length > 0) {
               var firstRootId = data[0][dataSourceItemIdPropName];
               selectItem(firstRootId);
               expandPath([firstRootId]);
            }
         }

         function notifyInitializationCompleteListener(rootItems) {
            if (bindOnInitializationCompleted) {
               scope.initializationCompleted({rootItems: rootItems});
            }
         }

         function notifySelectionChangeListener(selectedDataItem) {
            if (bindOnSelectedItemChanged) {
               scope.selectedItemChanged({selectedTreeItem: selectedDataItem});
            }
         }

         function notifySelectedItemFilesLoadedListener(data) {
            if (bindOnSelectedItemFilesLoaded) {
               scope.selectedItemFilesLoaded({selectedTreeItemContentFiles: data});
            }
         }

         function refreshTreeInternal() {
            return dsBrowserKendoTree.dataSource.read();
         }

         function getKendoDataSource(){
            return new kendo.data.HierarchicalDataSource({
               schema: {
                  model: {
                     // unique id needed to retrieve the children of a node
                     id: dataSourceItemIdPropName
                  }
               },
               transport: {
                  read: loadTreeItems
               }
            });
         }
      }
   }
})();

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service for retrieving datastore browser tree items from the backend.
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('datastoreBrowserTreeService', datastoreBrowserTreeService);

   datastoreBrowserTreeService.$inject = ['$http'];

   function datastoreBrowserTreeService($http) {

      // Public API
      var service = {
         getRoot: getRoot,
         getChildren: getChildren,
         searchResults: searchResults,
         isFileExists: isFileExists
      };
      return service;

      /**
       * Performs a get request to the backend and retrieves the root nodes of the
       * datastore browser tree.
       *
       * @param objectId {String} String representation of the object reference to list
       *    the datastores for. Should be of type HostDatastoreBrowser, HostSystem,
       *    Datastore, VirtualMachine, ComputeResource or ClusterComputeResource.
       * @param datastores {String} /Optional/ An array of datastore uids representing
       *    the datastore objects to be listed in the tree. Should be provided only when
       *    the objectRef is of type HostDatastoreBrowser. In other cases - the
       *    datastores will be gathered by the provided object reference.
       * @param showVmImagesFolder {Boolean} /Optional/ Flag to indicate whether to
       *    return the vm images folder.
       * @returns {Promise} Promise with a single parameter which is the response data.
       */
      function getRoot(objectId, datastores, showVmImagesFolder) {
         var httpConfig = {
            method: 'GET',
            url: 'datastoreBrowserTree/root/' + objectId,
            params: {}
         };

         if (datastores) {
            httpConfig.params.datastores = datastores;
         }
         if (showVmImagesFolder) {
            httpConfig.params.showVmImagesFolder = showVmImagesFolder;
         }

         return getData(httpConfig, []);
      }

      /**
       * Performs a get request to the backend and retrieves the children nodes of the
       * selected datastore browser tree.
       *
       * @param objectId {String} String representation of the object reference to list
       *    the datastores for. Should be of type HostDatastoreBrowser, HostSystem,
       *    Datastore, VirtualMachine, ComputeResource or ClusterComputeResource.
       * @param datastorePath {String} The folder path of the selected datastore browser
       *    item which defined the folder in which to search files.
       * @param fileQueryType {Integer} /Optional/ A bit mask that specifies what is
       *    the file types to include in the search criteria. If not specified - all files
       *    types are included in the result.
       * @cancelPromise {Promise} Optional promise which if resolved cancels the request.
       * @returns {Promise} Promise with a single parameter which is the response data.
       */
      function getChildren(objectId, datastorePath, fileQueryType, cancelPromise) {
         var httpConfig = {
               method: 'GET',
               url: 'datastoreBrowserTree/children/' + objectId,
               params: {
                  datastorePath: datastorePath
               },
               timeout: cancelPromise
         };

         if (fileQueryType) {
            httpConfig.params.fileQueryType = fileQueryType;
         }
         return getData(httpConfig, []);
      }

      /**
       * Performs a get request to the backend to search for datastore files using given pattern.
       *
       * @param datastoreId {String} String representation of the datastore reference
       * @param datastoreRootPath {String} The root folder path e.g. '[Datastore]'
       * @param pattern {String} The search pattern to be used.
       * @cancelPromise {Promise} Optional promise which if resolved cancels the request.
       * @returns {Promise} Promise with a single parameter which is the response data.
       */
      function searchResults(datastoreId, datastoreRootPath, pattern, cancelPromise) {
         var httpConfig = {
            method: 'GET',
            url: 'datastoreBrowserTree/children/' + datastoreId,
            params: {
               datastorePath: datastoreRootPath,
               pattern: '*' + pattern + '*',
               fileQueryType: 16 /*all files*/,
               searchInSubFolders: true
            },
            timeout: cancelPromise
         };

         return getData(httpConfig, []);
      }

      function isFileExists(objectId, filePath, fileType) {
         var httpConfig = {
            method: 'GET',
            url: 'datastoreBrowserTree/isFileExists/' + objectId,
            params: {
               filePath: filePath,
               fileQueryType: fileType
            }
         };

         return getData(httpConfig, false);
      }

      function getData(httpConfig, emptyReturnValue) {
         return $http(httpConfig).then(function (resp) {
            return resp.data;
         }, function (error) {
            return emptyReturnValue;
         });
      }
   }
})();
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * @ngdoc object
 * @name com.vmware.platform.ui:MultiPageDialogPage
 * @module com.vmware.platform.ui
 *
 * @property {string} title
 *    `{string}` Title of the page.
 * @property {string} contentUrl
 *    `{string}` Template URL of the page.
 * @property {string} state
 *    `{string}` State that indicates if page is completed, incomplete or disabled.
 * @property {Function} [onCommit]
 *    `{Function}` A function that is to be called when the Ok button is clicked or
 *    another page is to be opened. This function is where page validation is supposed
 *    to happen.
 *
 *    It is expected to return true/false or an array with
 *    validaiton message objects like:
 *       {
 *          type: vuiConstants.validationBanner.type.ERROR,
 *          text: 'The name is required.'
 *       }
 *    The callback result can be returned via promise as well.
 *
 *    If the result is true or an empty array the dialog is to open the
 *    new page that is clicked or is to be submitted if OK is clicked.
 *
 *    If the result is false or a non-empty array it will stay on the same page.
 *    In case of non-empty array the errors, passed via result, will be shown
 *    in an overlay message.
 */

/**
 * @ngdoc object
 * @name com.vmware.platform.ui:MultiPageDialogOptions
 * @module com.vmware.platform.ui
 *
 * @description
 *    **Extends** {@link vui.angular.modal:ModalOptions ModalOptions}.
 *
 *    Configuration object for
 *    {@link com.vmware.platform.ui:vxMultiPageDialog vxMultiPageDialog} directive.
 *
 *    Example:
 *    ```js
 *    var dialogOptions = {
 *                            title: 'Edit HA settings',
 *                            iconClass: 'vSphere-icon-cluster',
 *                            pages: [{
 *                               title: 'Failures and Responses',
 *                               contentUrl: 'page1.html',
 *                            }, {
 *                               title: 'Heartbeat Datastores',
 *                               contentUrl: 'page2.html',
 *                               onCommit: heartbeatDatastoresOnCommit
 *                            }],
 *                            show: true,
 *                            loading: true,
 *                            loadingMessage: 'Loading...',
 *                            loadingAriaLabel: 'Loading HA data...',
 *                            width : '600px',
 *                            height: '400px',
 *                            confirmOptions: { ... },
 *                            rejectOptions: { ... }
 *                        };
 *    ```
 *
 * @property {string} title
 *    Type: `string`
 *
 *    Specifies the title of the dialog.
 * @property {string} [iconClass]
 *    Type: `string` **|** Optional
 *
 *    The CSS class name representing the icon displayed in the dialog title bar. *
 * @property {Array} pages
 *    Type: `Array`
 *
 *    An array of {@link com.vmware.platform.ui:MultiPageDialogPage MultiPageDialogPage}
 *    that defines pages of the dialog defined by the page title, URL of the content
 *    that will be loaded, and commit function used to validate the page when OK
 *    button is clicked or it is an attempt to move to another page.
 * @property {string} [width]
 *    Type: `string` **|** Optional **|** Default: `'auto'`
 *
 *    The custom width for the dialog. Min-width is 220px and
 *    max-width is 960px.
 * @property {string} [height]
 *    Type: `string` **|** Optional **|** Default: `'auto'`
 *
 *    The custom height for the dialog. Min-height is 200px and
 *    max-height is 80%.
 *
 *    **Note:** In Internet Explorer the default height of dialog is set to
 *    `'400px'`. This is a workaround to handle an existing browser bug where
 *    the flex container does not honor the containers `min-height`.
 * @property {Object} confirmOptions
 *    Type: `Object` **|** Optional
 *
 *    {@link vui.angular.dialog:ConfirmOptions ConfirmOptions} contains
 *    properties to define the confirm (OK) button.
 * @property {Object} rejectOptions
 *    Type: `Object` **|** Optional
 *
 *    {@link vui.angular.dialog:RejectOptions RejectOptions} contains
 *    properties to define the reject (Cancel) button.
 * @deprecated {Object} validationBanner
 *    Type: `Object` **|** Optional
 *
 *    {@link vui.angular.validationBanner:ValidationBannerOptions ValidationBannerOptions}
 *    contains properties to define the validation banner. In the dialog,
 *    validation banner is used to show an error or warning message.
 *
 *    Instead of using vlidationBanner to show overlay messages you can pass them as a
 *    result of each page's onCommit callback.
 *
 * @property {boolean} [loading]
 *
 *    Whether to show the indeterminate loading indicator.
 *
 * @property {String} [loadingMessage]
 *
 *    Property that determines whether a loading message should be shown, and what
 *    the localized content of the loading message is.
 *
 * @property {String} [loadingAriaLabel]
 *    Property that determines the loading message which should be read by the
 *    screen readers when the loading is in progress.
 */

/*
 * @ngdoc directive
 * @name com.vmware.platform.ui:vxMultiPageDialog
 * @module com.vmware.platform.ui
 * @restrict A
 *
 * @description
 *    Directive to create a multi page dialog.
 *
 *    The dialog's content scope prototypically inherits from the scope on
 *    which {@link com.vmware.platform.ui:vxMultiPageDialog vx-multi-page-dialog}
 *    directive is declared.
 *
 * @param {MultiPageDialogOptions} vxMultiPageDialog
 *    Configuration object for the multi page dialog.
 *    It is of type {@link com.vmware.platform.ui:MultiPageDialogOptions MultiPageDialogOptions}.
 */
angular.module('com.vmware.platform.ui')
.directive('vxMultiPageDialog', ['vxMultiPageDialogService',
   function(vxMultiPageDialogService) {
      'use strict';
      return {
         restrict: 'A',
         scope: false,
         link: function (scope, element, attr) {
            // Directive options
            var options = {
               scope: scope,
               configObjectName : attr.vxMultiPageDialog
            };

            // Initialize modal
            var dialog = vxMultiPageDialogService(options);

            // set a watch on show to show and hide
            scope.$watch(attr.vxMultiPageDialog + '.show',
               function (newValue, oldValue) {
                  if (newValue ===  false  && oldValue === true) {
                     dialog.hide();
                  } else if (newValue ===  true  && oldValue === false) {
                     dialog.show();
                  }
               });

            // Garbage collection
            scope.$on('$destroy', function () {
               dialog.destroy();
               options = null;
               dialog = null;
            });
         }
      };
   }]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * @ngdoc service
 * @name com.vmware.platform.ui:vxMultiPageDialogService
 * @module com.vmware.platform.ui
 *
 * @description
 *    Service to create instance of a multi page dialog. The service allows
 *    you to create, show, hide and destroy the dialog.
 *
 * # General usage
 *    The `vxMultiPageDialogService` is a function which takes a single argument - a
 *    configuration object - that is used to create a multi page dialog.
 *
 * @param {Object} config
 *    Object containing the scope and the configObjectName.
 *
 *    - **scope** – `{$scope}` – Angular scope object of the dialog container.
 *       It can be the scope of the controller or rootScope or a custom scope. The scope
 *       of each page in the dialog prototypically inherits from the scope that is
 *       mentioned here.
 *    - **configObjectName** – `{string}` – The name of the scope variable
 *       declared on the above mentioned scope. The variable is of type
 *       {@link com.vmware.platform.ui:MultiPageDialogOptions MultiPageDialogOptions}.
 *
 *    Example:
 *    ```js
 *    var config = {
 *                     scope: $scope,
 *                     configObjectName: 'dialogOptions'
 *                 };
 *    ```
 *
 * @returns {Object}
 *    Returns a response object which has these methods:
 *
 *    - **show()** – `{Function}` To display the dialog.
 *    - **hide()** – `{Function}` To hide the dialog.
 *    - **destroy()** – `{Function}` To destroy the dialog.
 */
angular.module('com.vmware.platform.ui').provider('vxMultiPageDialogService', [
   function() {
      this.$get = ['$rootScope', '$document', '$q', '$timeout', 'vuiModalService', 'jsUtils', 'vuiConstants', 'vuiLocale', 'vxModalKeyService', function ($rootScope, $document, $q, $timeout, vuiModalService,
            jsUtils, vuiConstants, vuiLocale, vxModalKeyService) {

         function MultiPageDialogFactory(config) {
            var dialogManager;
            var outerScope = config.scope;
            var scope = outerScope.$new();
            scope.multiPageDialog = config.scope[config.configObjectName];
            scope.isInitialized = false;

            var defaultConfirmOptions = {
               label: vuiLocale.ok,
               disabled: false,
               confirmOnEnter: true
            };

            var defaultRejectOptions = {
               label: vuiLocale.cancel,
               visible: true,
               rejectOnEsc: true
            };

            angular.extend(scope.multiPageDialog,
                  angular.extend({
                           maximizable: true,
                           resizable: true,
                           draggable: true,
                           resizeMinWidth: 700,
                           resizeMinHeight: 420
                        },
                        scope.multiPageDialog
                  )
            );

            var temp = {};
            angular.extend(temp, defaultConfirmOptions, scope.multiPageDialog.confirmOptions);
            scope.multiPageDialog.confirmOptions = temp;
            var confirmOptions = scope.multiPageDialog.confirmOptions;
            temp = {};
            angular.extend(temp, defaultRejectOptions, scope.multiPageDialog.rejectOptions);
            scope.multiPageDialog.rejectOptions = temp;
            var rejectOptions = scope.multiPageDialog.rejectOptions;

            var dialogTemplate =
               '<div class="vui-wizard default-text" vui-focus-trap ng-style="multiPageDialog.getStyle()"' +
                     'role="dialog" tabindex="0" vui-focus-on="vuiModalOpened">' +
                  '<div class="wizard-modal-titlebar">' +
                     '<span class="titlebar-left-icons">' +
                        '<span ng-if="multiPageDialog.iconClass" class="vui-icon" ' +
                              'ng-class="multiPageDialog.iconClass">' +
                        '</span>' +
                     '</span>' +
                     '<span class="titlebar-text" title="{{multiPageDialog.title}}">' +
                        '{{multiPageDialog.title}}</span>' +
                 '</div>' +
                  '<div class="wizard-modal-body" ng-if="multiPageDialog.show">' +
                     '<vx-multi-page-dialog-toc></vx-multi-page-dialog-toc>' +
                     '<div class="wizard-content-container" role="main" tabindex="0">' +
                        '<div vui-validation-banner="multiPageDialog.validationBanner"></div>' +
                        '<div class="wizard-content"' +
                           'ng-include="dialogPages[dialogManager.currentIdx].contentUrl"></div>' +
                     '</div>' +
                     '<div class="progress-bordered progress-centered" ng-if="multiPageDialog.loading">' +
                        '<vx-progress message="{{multiPageDialog.loadingMessage}}" ' +
                              'loading-aria-label="{{multiPageDialog.loadingAriaLabel}}">' +
                        '</vx-progress>' +
                     '</div>' +
                  '</div>' +
                  '<div class="wizard-modal-footer">' +
               '<button class="btn" ng-if="multiPageDialog.rejectOptions.visible"' +
                           ' ng-click="multiPageDialog.onCancelClick()">' +
                           '{{multiPageDialog.rejectOptions.label}}</button>' +
                     '<button class="btn btn-primary" ng-click="multiPageDialog.onOkClick()"' +
                           ' ng-disabled="multiPageDialog.confirmOptions.disabled || !isInitialized">' +
                           '{{multiPageDialog.confirmOptions.label}}</button>' +
                     '<span class="wizard-resize-icon-span"></span>' +
                  '</div>' +
               '</div>';

            var setValidationBannerMessages = function (messages) {
               scope.multiPageDialog.validationBanner.messages = messages;
            };

            var clearValidationBanner = function () {
               setValidationBannerMessages([]);
            };

            var isCombobox = function (element) {
               return element && element.getAttribute('role') === 'combobox';
            };

            var isDropdown = function (element) {
               return element && element.getAttribute('role') === 'listbox';
            };

            var escKeyHandler = function ($event) {
               var element = $event.currentTarget.activeElement;
               // Ignore if disabled
               if (rejectOptions.rejectOnEsc !== true) {
                  return;
               }
               // Ignore on vui.angular.combobox and vui.angular.dropdown
               if (isCombobox(element) || isDropdown(element)) {
                  return;
               }

               // Ensure cancel is available
               if (rejectOptions.visible === true) {
                  scope.multiPageDialog.onCancelClick();
               }
            };


            var onKeydownHandler = function ($event) {
               //Run keydown handler in angular zone
               vxModalKeyService.onKeydownHandler($event, escKeyHandler.bind(this, $event));
            };


            // Turn the keypress handler on/off
            var setKeypressHandler = function (state) {
               $document[state]('keydown', onKeydownHandler);
            };

            /**
             * Handles jumping between pages when user clicks on a page in TOC.
             * This function actually validates the page (if page onCommit function is
             * defined) and decides whether to move to the new page that is clicked or
             * to stay on the current page.
             *
             * @param pageIndex The index of the page clicked.
             * @returns Promise Promise with a boolean data indicating whether the move
             *       to the new page is successful or not.
             *
             */
            var tryMoveToPage = function (pageIndex) {
               // Do nothing when user clicks on the same page or a disabled page.
               if (dialogManager.currentIdx === pageIndex ||
                     scope.dialogPages[pageIndex].state === vuiConstants.wizard.pageState.DISABLED) {
                  return $q.resolve(false);
               }

               // Call onCommit of the currentPage when jumping to another page
               return $q.when(onPageCommit()).then(function (result) {
                  var isMoved = false;
                  if (!!result) {
                     updateDialogPageVars(pageIndex);
                     isMoved = true;
                  }
                  return isMoved;
               });
            };

            var updateDialogPageVars = function (pageIndex) {
               dialogManager.currentIdx = pageIndex;
               scope.multiPageDialog.currentPage = scope.dialogPages[pageIndex];
               clearValidationBanner();
            };

            // Holds the onCommit function of the current page
            var onPageCommit = function () {
               var pageCommitFunction = scope.multiPageDialog.currentPage.onCommit;
               if (pageCommitFunction && typeof pageCommitFunction === 'function') {

                  return $q.when(pageCommitFunction()).then(function(result) {
                     if (typeof result === 'boolean') {
                        return result;
                     }

                     if (_.isArray(result) && result.length > 0) {
                        clearValidationBanner();
                        setValidationBannerMessages(result);
                        return false;
                     }

                     // onCommit result is neither boolean nor ValidationBannerMessage[]
                     return true;
                  });

               } else {
                  // onCommit is not set
                  return true;
               }
            };

            var oldFocus;
            /* Attaching to angular event getStyle to put focus on dialog properly,
             * does not work on ngInit or onload because it needs to fire every
             * time the dialog is shown or hidden (i.e. when the style is changed)
             * it is also necessary to wait until the spinnner/progress dialog has
             * fully closed first.
             */
            scope.$watch('multiPageDialog.show', function (val) {
               if (val) {
                  oldFocus = document.activeElement;

                  var waitTillProgressIsGone = function () {
                     $timeout(function () {
                        if (!scope.progress) {
                           scope.progress = $('.modal-spinner');
                        }
                        if (scope.progress.hasClass('ng-hide') || !scope.progress.length) {
                           scope.$broadcast('vuiModalOpened');
                        } else {
                           waitTillProgressIsGone();
                        }
                     }, 100);
                  };
                  waitTillProgressIsGone();
               }
            });

            var restoreFocus = function () {
               if (oldFocus) {
                  oldFocus.focus();
               }
            };

            scope.multiPageDialog.onOkClick = function () {
               $q.when(onPageCommit()).then(function (result) {
                  if (!result) {
                     return;
                  }
                  onOk();
                  restoreFocus();
               });
            };

            /**
             * Calls onClick function of the dialog's confirm options if available.
             */
            var onOk = function () {
               if (confirmOptions && confirmOptions.onClick &&
                     typeof(confirmOptions.onClick) === 'function') {
                  $q.when(confirmOptions.onClick()).then(function (result) {
                     if (!result) {
                        return;
                     }
                     clearValidationBanner();
                     scope.multiPageDialog.show = false;
                  });
               } else {
                  clearValidationBanner();
                  scope.multiPageDialog.show = false;
               }
            };

            scope.multiPageDialog.onCancelClick = function () {
               if (rejectOptions && rejectOptions.onClick &&
                     typeof(rejectOptions.onClick) === 'function') {
                  $q.when(rejectOptions.onClick()).then(function (result) {
                     if (result) {
                        clearValidationBanner();
                        scope.multiPageDialog.show = false;
                     }
                  });
               } else {
                  clearValidationBanner();
                  scope.multiPageDialog.show = false;
               }
               restoreFocus();
            };

            // style for dialog container
            scope.multiPageDialog.getStyle = function () {
               var styles = {};
               if (jsUtils.hasProperty(scope.multiPageDialog, 'width')) {
                  styles.width = scope.multiPageDialog.width;
               }
               if (jsUtils.hasProperty(scope.multiPageDialog, 'height')) {
                  styles.height = scope.multiPageDialog.height;
               }
               return styles;
            };

            // scope.dialogManager contains those properties of the dialog that are
            // required by some of its child components that need to call the dialog
            // functions, such a component is the multi-page-dialog-toc
            scope.dialogManager = {
               currentIdx: 0,
               tryMoveToPage : tryMoveToPage
            };

            var initializeDialog = function() {
               scope.isInitialized = true;

               dialogManager = scope.dialogManager;

               scope.dialogPages = scope.multiPageDialog.pages;
               scope.multiPageDialog.validationBanner = {
                  showAllMessages : false,
                  messages : []
               };
               scope.multiPageDialog.currentPage = {};

               var pageIndex = 0;
               // To handle the case where first page is a skipped page
               while (scope.dialogPages[pageIndex].state === vuiConstants.wizard.pageState.SKIPPED &&
                     pageIndex < scope.dialogPages.length) {
                  pageIndex++;
               }
               updateDialogPageVars(pageIndex);
            };

            config._vuiModalTemplate = dialogTemplate;
            config._outerScopeActual = outerScope;
            config.scope = scope;
            config.showBackdrop = true;
            config.headerElementSelector = '> .wizard-modal-titlebar';
            config.configObjectName = 'multiPageDialog';
            config.zIndex = vuiConstants.internal.zIndex.DEFAULT;

            // set a watch on show to add/remove keystroke listener
            scope.$watch(config.configObjectName + '.show',
               function (newValue, oldValue) {
                  if (newValue ===  false  && oldValue === true) {
                     setKeypressHandler('off');
                  } else if (newValue ===  true) {
                     setKeypressHandler('on');
                  }
               });

            scope.$watch(config.configObjectName + '.loading', function(val) {
               if (!val) {
                  // since the loading might be related to the initial loading of
                  // dialog data, that is why we have to check if the dialog is already
                  // initialized, and if not - initialize it
                  if (scope.isInitialized) {
                     return;
                  }
                  initializeDialog();
               }
            });

            scope.$on('$destroy', function () {
               setKeypressHandler('off');
            });

            return vuiModalService(config);
         }

         return MultiPageDialogFactory;
      }];
   }]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * @ngdoc directive
 * @name com.vmware.platform.ui:vxMultiPageDialogToc
 * @module com.vmware.platform.ui
 * @restrict E
 *
 * @description
 *    Directive to create TOC for multi page dialog.
 */
angular.module('com.vmware.platform.ui').directive('vxMultiPageDialogToc',
      ['vuiConstants', 'vuiTreeAccessibilityServiceFactory', function(vuiConstants, accessibilityServiceFactory) {
         'use strict';
         return {
            template:
               '<div class="wizard-panel-TOC" role="tree" tabindex="0">' +
                  '<ul class="wizard-steps-list" role="group">' +
                     '<li ' +
                        'ng-repeat="page in dialogPages" ' +
                        'ng-class="getStepClass(page.state, $index)" ' +
                        'ng-if="criteriaMatch(page.state)" ng-click="moveTo($index)" ' +
                        'role="treeitem" ' +
                        'aria-label="{{page.title}}" ' +
                        'aria-selected="{{getAriaActive($index) ? \'true\' : \'false\'}}"' +
                        'tabindex="-1">' +
                        '<a class="no-content">{{page.title}}</a>' +
                     '</li>' +
                  '</ul>' +
               '</div>',
            scope: false,
            restrict: 'E',
            controller: ['$scope', '$element', '$timeout', function($scope, $element, $timeout) {
               var pageStateConst = vuiConstants.wizard.pageState;
               var dialogManager = $scope.dialogManager;

               setTimeout(function () {
                  accessibilityServiceFactory.create($element, $scope);
               }, 0);

               $scope.criteriaMatch = function(pageState) {
                  return pageState !== pageStateConst.SKIPPED;
               };

               $scope.getStepClass = function(pageState, pageIndex) {
                  var stepClass = (pageIndex === dialogManager.currentIdx) ?
                        'wizard-steps-current ' : '';
                  if(pageState === pageStateConst.DISABLED) {
                     stepClass += 'wizard-steps-not-available';
                  } else if(pageState === pageStateConst.COMPLETED && pageIndex !== 0) {
                     stepClass += 'wizard-steps-completed';
                  } else if(pageState === pageStateConst.INCOMPLETE) {
                     stepClass += 'wizard-steps-incomplete';
                  }
                  return stepClass;
               };

               $scope.getAriaActive = function (pageIndex) {
                  return pageIndex === dialogManager.currentIdx;
               };

               $scope.moveTo = function(pageIndex) {
                  dialogManager.tryMoveToPage(pageIndex).then(function(isMoved) {
                     // If because the current page in the dialog is not valid
                     // the navigation to the new page is prevented. But since the new
                     // page's TOC item that is clicked gets a new style applied
                     // (defined by :focus selector) we have to invoke onblur event on
                     // that TOC item in order to make the :focus style removed
                     if (!isMoved) {
                        $element.find('.wizard-steps-list li a:eq(' + pageIndex + ')').blur();
                     }
                  });
               };
            }]
         };
      }]
);

(function() {
   'use strict';

   angular.module('com.vmware.platform.ui').directive('diskFormatSelector', ['diskFormatService',
      function(diskFormatService) {
         return {
            scope: {
               diskFormats: '=',
               selectedFormat: '=?',
               readOnly: '=?',
               ctrlAriaLabeledBy: '=?'
            },
            templateUrl: 'resources/ui/components/diskFormatSelector/diskFormatSelector.html',
            link: function(scope) {

               // If no selection is provided, select the first item by default.
               if (!scope.selectedFormat) {
                  selectFirstItem();
               }

               scope.$watch(function () {
                  return scope.diskFormats;
               }, function(newValue, oldValue) {
                  if (newValue !== oldValue) {
                     if (!scope.selectedFormat) {
                        selectFirstItem();
                     }
                     updateIsDisabled();
                  }
               });

               updateIsDisabled();

               function updateIsDisabled() {
                  scope.isDisabled = !scope.diskFormats || !scope.diskFormats.length ||
                     (scope.diskFormats.length === 1 &&
                        scope.diskFormats[0].type === diskFormatService.diskFormats.asDefinedInProfile.type);
               }

               function selectFirstItem() {
                  if (scope.diskFormats && scope.diskFormats.length > 0) {
                     scope.selectedFormat = scope.diskFormats[0];
                  }
               }
            }
         };
      }]);
})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service for retrieving available disk formats for virtual disks.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('diskFormatService', diskFormatService);

   diskFormatService.$inject = ['datastoreTypeConstants', 'i18nService'];

   function diskFormatService (datastoreTypeConstants, i18nService) {

      var diskFormats = {
         sameAsSource: {
            type: 'sameAsSource',
            name: i18nService.getString('Common', 'VirtualDiskFormat.sameAsSource')
         },
         asDefinedInProfile: {
            type: 'asDefinedInProfile',
            name: i18nService.getString('Common', 'VirtualDiskFormat.asDefinedInProfile')
         },
         flat: { type: 'flat', name: i18nService.getString('Common', 'VirtualDiskFormat.flat') },
         thick: { type: 'thick', name: i18nService.getString('Common', 'VirtualDiskFormat.thick') },
         nativeThick: { type: 'nativeThick', name: i18nService.getString('Common', 'VirtualDiskFormat.nativeThick') },
         thin: { type: 'thin', name: i18nService.getString('Common', 'VirtualDiskFormat.thin') }
      };

      return {
         diskFormats: diskFormats,
         getDrsDiskFormats: getDrsDiskFormats,
         getAvailableDiskFormats: getAvailableDiskFormats
      };
      function getDrsDiskFormats (profile) {
         // formats user to choose for Ovf deploy via DRS placement
         return [diskFormats.flat, diskFormats.thin, diskFormats.thick];
      }

      function getAvailableDiskFormats (
         datastoreType, isVStorageSupported, isSameAsSourceSupported, isThickSupported
      ) {
         if (!datastoreType) {
            return [];
         }

         if (datastoreType === datastoreTypeConstants.VVOL) {
            return [diskFormats.thin, diskFormats.nativeThick];
         }

         if (datastoreType === datastoreTypeConstants.VSAN) {
            return [diskFormats.asDefinedInProfile];
         }

         if ((datastoreType === datastoreTypeConstants.NFS
            || datastoreType === datastoreTypeConstants.NFS41) && isVStorageSupported !== true) {
            return [diskFormats.thin];
         }

         var result = [];
         if (isSameAsSourceSupported === true) {
            result.push(diskFormats.sameAsSource);
         }

         result.push(diskFormats.flat);
         if (isThickSupported === true) {
            result.push(diskFormats.thick);
         }
         result.push(diskFormats.thin);
         return result;
      }
   }

})();


/**
 * Copyright 2013 VMware, Inc. All rights reserved.
 *
 * The dropdown directives to create a dropdown button
 *
 * - Define button with a label
 * - Define Dropdown menu items
 * - Define separator
 */
angular.module('com.vmware.platform.ui').directive('vxDropdown', function () {
   return {
      restrict: 'E',
      transclude: true,
      scope: {
         label: '@'
      },

     controller:['$scope', function(scope) {
      scope.isOpen = false;
     }],

     template: '<div class="dropdown" ng-class="{open : isOpen}" >' +
            '<a class="btn dropdown-toggle"  ng-click="isOpen=!isOpen">' +
               '{{label}} ' +
               '<span class="caret"></span>' +
            '</a>' +
            '<ul class="dropdown-menu" ng-click="isOpen=!isOpen" ng-transclude></ul>' +
            '</div>',

     replace: true
   };
}).directive('vxDropdownItem', function () {
   return {
      restrict: 'E',
      scope: false,
      transclude: true,
      template: '<li ng-transclude></li>',
      replace: true
   };
}).directive('vxDropdownDivider', function () {
   return {
      restrict: 'E',
      transclude: false,
      template: '<li class="divider"/>',
      replace: true
   };
});

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Component, that shows a server error stack
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxErrorStack', vxErrorStack);

   function vxErrorStack() {
      return {
         restrict: 'A',
         scope: {
            vxErrorStack: '=',
            errorReportArgs: '='
         },
         template: [
            '<div class="property-value horizontal-flex-container">',
               '<span class="property">',
                  '{{::ctrl.i18n(\'errorStack.label\')}}',
               '</span>',
               // TODO semerdzhievp copy /errorReport/errorReport.jsp and
               // assets from flex container-app and enable link
               //
               // Submit error report link:
               //'<a style="margin-left:auto;" ',
               //      'ng-click="ctrl.onSubmitErrorReportClicked()" ',
               //      'title="{{::ctrl.i18n(\'SubmitErrorReport.toolTip.text\')}}">',
               //   '{{::ctrl.i18n(\'SubmitErrorReport.link.text\')}}',
               //'</a>',
            '</div>',
            '<span class="horizontal-flex-container property-value"' +
                  'ng-repeat="line in ctrl.stack track by $index"' +
                  'style="white-space: pre;">',
               '<span class="vui-icon-error-stack" ',
                  'style="flex-shrink:0;"></span>',
               '{{line}}',
            '</span>'
         ].join(''),
         controller: ErrorStackViewController,
         controllerAs: 'ctrl'
      };
   }

   var ERROR_REPORT_URL = '/h5ngc/errorReport/';

   ErrorStackViewController.$inject = ['$scope', 'i18nService', '$window'];

   function ErrorStackViewController($scope, i18nService, $window) {
      var self = this;

      self.i18n = function(key) {
         return i18nService.getString('Common', key);
      };

      self.onSubmitErrorReportClicked = function() {
         var url = ERROR_REPORT_URL + '?' +
               angular.element.param($scope.errorReportArgs);
         $window.open(url);
      };

      self.stack = $scope.vxErrorStack;
   }
})();
(function() {
   angular.module('com.vmware.platform.ui')
      .directive('filterFocusRetainer', ['$document', function($document) {
         return {
            restrict: 'A',
            link: function($element) {

               $document[0].body.addEventListener('focusin', stopFocusinPropagation);

               $element.$on('$destroy', function() {
                  $document[0].body.removeEventListener('focusin', stopFocusinPropagation);
               });

               function stopFocusinPropagation(e) {
                  if (e && e.target) {
                     var targetElementClassAttribute = e.target.getAttribute("class");
                     if (targetElementClassAttribute && targetElementClassAttribute.indexOf('k-textbox') > -1) {
                        e.stopPropagation();
                     }
                  }
               }
            }
         };
      }]);
})();
function VxValueInUnitsController($scope, $element, $attrs, $document, i18nService, vxValueInUnitsService) {
   var UNLIMITED_VALUE = i18nService.getString('Common', 'unlimited');
   var self = this;

   var modelValueChanged = function (convertedValue) {
      if (convertedValue === undefined) {
         convertedValue = self.ngModelController.$viewValue;
      }
      if (self.ngModelController.$viewValue === -1) {
         self.selection.quantity = UNLIMITED_VALUE;
      } else {
         self.selection.quantity = convertedValue;
      }
   };

   function setErrorMessage(errors) {
      var firstErrorForWhichWeHaveAMessage = _.find(_.keys(self.errorMessages), function (errorMessageKey) {
         return errors.hasOwnProperty(errorMessageKey);
      });

      if (!firstErrorForWhichWeHaveAMessage) {
         self.vxErrorConfig.message = i18nService.getString('Common',
               'resourcePool.create.form.invalid.chars');
      } else {
         var message = self.errorMessages[firstErrorForWhichWeHaveAMessage];
         if (angular.isFunction(message)) {
            message = message();
         }
         self.vxErrorConfig.message = message;
      }
   }

   function setDefaultUnit(unit) {
      var actualUnit = unit ? unit : $attrs.defaultUnit;

      if (!self.showUnits) {
         return null;
      } else if (actualUnit) {
         return _.find(self.unitOptions, function(option) {
            return option.label === actualUnit;
         });
      }

      return self.unitOptions[0];
   }

   function highlightValue() {
      var itemHighlighted = false;
      _.each(self.recommendedValues, function(recommendation) {
         if(recommendation.value === self.ngModelController.$viewValue && !itemHighlighted) {
            recommendation.isHighlighted = true;
            itemHighlighted = true;
         } else {
            recommendation.isHighlighted = false;
         }
      });
   }

   function setCustomValidators(ngModelController) {
      if (!self.customValidators) {
         return;
      }
      _.each(self.customValidators, function(validator) {
         ngModelController.$validators[validator.name] = function(modelValue, viewValue) {
            var valid = validator.validate(viewValue);
            self.valueInUnitsForm.quantity.$setValidity(validator.name, valid);
            return valid;
         };
         self.errorMessages[validator.name] = validator.message;
      });
   }

   function installDocumentClickEvent($document, $scope, $element) {
      var dismissDropdown = function (e) {
         // close recommended values dropdown when clicking outside the current element
         // or on the units dropdown
         if (($element !== e.target && !$element[0].contains(e.target)) ||
               (e.target && e.target.type === 'select-one')) {
            $scope.$apply(function () {
               self.properties.recommendedValuesExpanded = false;
            });
         }
      };
      $document.on('click', dismissDropdown);
      $scope.$on('$destroy', function () {
         $document.off('click', dismissDropdown);
      });
   }

   function AttributeValidator(inputForError, ngModelController, attributeName, $attrs, validationFn) {
      $attrs.$observe(attributeName, function () {
         ngModelController.$validate();
      });

      return function (computedValue) {
         var attributeValue = $attrs[attributeName];

         if (ngModelController.$isEmpty(attributeValue)) {
            inputForError.$setValidity(attributeName, true);
            return true;
         }

         var valid = validationFn(computedValue, Number(attributeValue));
         inputForError.$setValidity(attributeName, valid);
         return valid;
      };
   }

   // Lifecycle hooks
   self.$onInit = function() {
      self.properties = {};
      self.showUnits = angular.isUndefined(self.showUnits) ? true : self.showUnits;

      $scope.$watch('ctrl.recommendedValues', function() {
         highlightValue();
      });

      $scope.$watch('ctrl.errorMessages', function() {
         var errors = self.valueInUnitsForm.$error;
         if(!errors || _.isEmpty(errors)) {
            return;
         }

         setErrorMessage(errors);
      });

      $scope.$watchCollection("ctrl.valueInUnitsForm.$error", function (errors) {
         self.vxErrorConfig.isVisible = false;
         self.vxErrorConfig.message = "";

         if (!errors || _.isEmpty(errors)) {
            return;
         }

         setErrorMessage(errors);

         self.vxErrorConfig.isVisible = true;
      });

      self.ngModelController = self.ngModel;

      setCustomValidators(self.ngModelController);
      self.ngModelController.$render = modelValueChanged;

      if ($attrs.defaultUnit) {
         var setDefaultQuantity = $scope.$watch('ctrl.selection.quantity', function() {
            if (self.selection.quantity !== UNLIMITED_VALUE) {
               if (!self.selection.unit) {
                  throw new Error("No unit for '" + self.name + "'.");
               }
               self.selection.quantity = self.ngModelController.$viewValue / self.selection.unit.multiplier;
            }
            setDefaultQuantity(); // to stop watching
         });
      }
   };

   self.$postLink = function() {
      self.name = $attrs.name;
      self.type = $attrs.type || 'text';
      self.selection = {
         quantity: 1,
         unit: setDefaultUnit()
      };
      self.allowedCharacters = angular.isDefined(self.allowedCharacters) ?
         self.allowedCharacters : '0-9.';
      self.vxErrorConfig = {
         message: "",
         isVisible: false
      };

      installDocumentClickEvent($document, $scope, $element);

      self.ngModelController.$validators.max = AttributeValidator(self.valueInUnitsForm.quantity, self.ngModelController, 'max', $attrs, function (computedValue, attributeValue) {
         return computedValue <= attributeValue;
      });


      self.ngModelController.$validators.min = AttributeValidator(self.valueInUnitsForm.quantity, self.ngModelController, 'min', $attrs, function (computedValue, attributeValue) {
         return computedValue >= attributeValue;
      });

      self.ngModelController.$validators.mod = AttributeValidator(self.valueInUnitsForm.quantity, self.ngModelController, 'mod', $attrs, function (computedValue, attributeValue) {
         if(!$attrs.min) {
            $attrs.min = 0;
         }

         var valid;
         if($attrs.hotPlugActive) {
            var hotPlugValid = (computedValue - $attrs.min) >= attributeValue;
            var modValid = (computedValue % attributeValue === 0);

            valid = (modValid && hotPlugValid) || (Number($attrs.min) === computedValue);
         } else {
            valid = computedValue % attributeValue === 0 ;
         }
         return valid;
      });

      self.updateModelFromFields = function(quantity, unit) {
         var multiplier = unit ? unit.multiplier : 1;
         var value = 0;
         self.currentUnit = unit;

         if (quantity === UNLIMITED_VALUE) {
            value = -1;
         }
         else {
            if(quantity){
                value = quantity * multiplier;
            }
         }

         self.ngModelController.$setViewValue(value);

         if (self.unitChangedCallback && (typeof self.unitChangedCallback === 'function')) {
            self.unitChangedCallback(unit ? unit : null);
         }

         if (self.valueChangedCallback && (typeof self.valueChangedCallback === 'function')) {
            self.valueChangedCallback({value: value});
         }
      };

      self.clickDropdownButton = function() {
         self.properties.recommendedValuesExpanded = !self.properties.recommendedValuesExpanded;
         vxValueInUnitsService.onRecommendedValuesExpandedChange($element);
      };

      self.setModelValue = function (recommendation) {
         if (recommendation.unit) {
            self.selection = {
               quantity: 1,
               unit: setDefaultUnit(recommendation.unit)
            };
         }
         self.ngModelController.$setViewValue(recommendation.value);
         modelValueChanged(recommendation.value /
               (self.selection.unit ? self.selection.unit.multiplier : 1));
         highlightValue();
      };
   };
}

angular.module('com.vmware.platform.ui')
   .component('vxValueInUnits', {
      templateUrl: 'resources/ui/components/forms/vxValueInUnits.html',
      bindings: {
         unitOptions: "<",
         unitChangedCallback: "=",
         valueChangedCallback: "&",
         errorMessages: "<",
         isDisabled: "<",
         recommendedValues: "<",
         showUnits: "<?",
         customValidators: "<?",
         allowedCharacters: "@",
         currentUnit: "=?",
         unitAriaLabel: "<?",
         quantityCaretAriaLabel: "<?",
         quantityAriaLabel: "<?"

      },
      require: {
         ngModel: 'ngModel'
      },
      controller: VxValueInUnitsController,
      controllerAs: 'ctrl'
   });

VxValueInUnitsController.$inject = [
   '$scope',
   '$element',
   '$attrs',
   '$document',
   'i18nService',
   'vxValueInUnitsService'
];

/*
 *  Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential
 */
/**
 * Service which handles the positioning of the vxValueInUnits dropdown content. In cases
 * when the parent container partially covers the content, the dropdown should open
 * upwards.
 *
 * Note: When using the vxValueInUnits directive in tests, make sure to use
 * the renderTemplateAndAppendToDom method instead of the renderTemplate one.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('vxValueInUnitsService',
      vxValueInUnitsService);

   function vxValueInUnitsService() {
      return {
         onRecommendedValuesExpandedChange: onRecommendedValuesExpandedChange
      };
   }

   function onRecommendedValuesExpandedChange(domElement, recommendedValuesExpanded) {
      if (recommendedValuesExpanded) {
         var offsetParentElement = domElement.context.offsetParent;
         var parentRectangle = offsetParentElement.getBoundingClientRect();

         var dropdownContentElement = $(domElement.find('table.recommended-values'));
         var dropdownContentRectangle = dropdownContentElement[0].getBoundingClientRect();

         var shouldOpenUpwards = isContentCoveredByParent(parentRectangle,
            dropdownContentRectangle);

         if (shouldOpenUpwards) {
            dropdownContentElement.addClass('recommended-values-openUpwards');
         }
      }
   }

   function isContentCoveredByParent(parentRectangle, dropdownContentRectangle) {
      var offsetParentBottomPosition = parentRectangle.bottom + parentRectangle.top;
      var dropdownBottomPosition = dropdownContentRectangle.bottom + dropdownContentRectangle.top;
      var shouldOpenMenuUpwards = offsetParentBottomPosition - dropdownBottomPosition < 0;
      return shouldOpenMenuUpwards;
   }
}());

/**
 * Accepts text of the form  "something {vm.name} with {host.otherName} and {someUnknownEntity.name}"
 * As well as an object specifying the values to replace the {variable} expressions
 * and renders HTML ready text that has navigation links inside.
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('linkedText', linkedText);

   linkedText.$inject = ['defaultUriSchemeUtil', 'columnRenderersRegistry', '$compile'];

   function linkedText(defaultUriSchemeUtil, columnRenderersRegistry, $compile) {
      var getLinkHTMl = columnRenderersRegistry.getColumnRenderer('link');

      return {
         scope: {
            text: '=',
            targets: '=',
            fallbackText: '='
         },
         template: "",
         link: link
      };

      function link(scope, element) {
         scope.$watch('text', function() {
            var text = _.escape(scope.text);
            if (!scope.targets) {
               scope.targets = {};
            }

            _.every(parseEntities(text), function(entity) {
               if (getTargetEntity(entity)) {
                  var linkHTML = getLinkHTMl(getLinkTarget(entity), getLinkText(entity));
                  text = text.replace(entity, linkHTML);
                  return true;
               } else {
                  text = '<span ng-non-bindable>' + scope.fallbackText + '</span>';
                  return false;
               }
            });
            element.html(text);
            $compile(element.contents())(scope);
         }, true);


         function getTargetEntity(entity) {
            var key = entity.match(/{([^{}]+)}/)[1];
            return (scope.targets[key] || {}). entity;
         }

         function parseEntities(text) {
            return text.match(/{([^{}]+)}/g) || [];
         }

         function getLinkTarget(entity) {
            return defaultUriSchemeUtil.getVsphereObjectId(getTargetEntity(entity));
         }

         function getLinkText(entity) {
            var key = entity.match(/{([^{}]+)}/)[1];
            return (scope.targets[key] || {}).name;
         }
      }
   }
})();

(function () {
    /**
     * Directive for localizing aria-label attribute of a given html element.
     */
    'use strict';
    angular.module('com.vmware.platform.ui').directive('vxLocalizedAriaLabel', ["i18nService",
        function (i18nService) {
            return {
                restrict: 'A',
                scope: false,
                link: function ($scope, $element, $attrs) {
                    $scope.$watch($attrs.vxLocalizedAriaLabel, function (newValue) {
                        if (newValue) {
                            var stringProperties = newValue.split(":");
                            var localizedLabel = i18nService.getString.apply(i18nService, stringProperties);
                            if (localizedLabel) {
                                $attrs.$set("aria-label", localizedLabel);
                            }
                        }
                    });
                }
            };
        }]);
})();



/* Copyright 2016 Vmware, Inc. All rights reserved. -- VMware Confidential */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui')
      .component('macAddressControl', {
         templateUrl: 'resources/ui/components/macAddressControl/macAddressControl.html',
         controller: MacAddressController,
         controllerAs: 'ctrl',
         bindings: {
            addressType: '=?',
            assignedMacAddress: '=?',
            disabled: '=ngDisabled'
         }
      });

   MacAddressController.$inject = ['macAddressValidatorService', 'i18nService'];

   function MacAddressController(macAddressValidatorService, i18nService) {
      var self = this;

      function resetErrorConfig() {
         return {
            message: '',
            isVisible: false
         };
      }

      function isAutomaticAddressType(type) {
         return type === 'assigned' || type === 'generated';
      }

      self.$onInit = function () {
         self.MAC_ADDRESS_PREFIX = "00:50:56:";
         self.originalMacAddress = self.assignedMacAddress;
         self.originalAddressType = self.addressType;

         self.ARIA_LBL_MAC = i18nService.getString("Common", "macAddress");
         self.ARIA_LBL_MAC_TYPE = i18nService.getString("Common", "macAddressType");


         var automaticSelectionId = isAutomaticAddressType(self.addressType) ? self.addressType : 'generated';

         self.dropDownOptions = [
            { id: 'manual', label: i18nService.getString('Common', 'macAddressType.manual') },
            { id: automaticSelectionId, label: i18nService.getString('Common', 'macAddressType.automatic') }
         ];
         self.macAddressValidateErrorConfig = resetErrorConfig();

         if (self.addressType) {
            self.selectedOption =
                  (self.addressType === 'manual') ? self.dropDownOptions[0] : self.dropDownOptions[1];
         } else {
            self.selectedOption = self.dropDownOptions[1];
         }
      };

      // Lifecycle hooks
      self.$postLink = function () {

         // Todo: Change this to use angular $validators and $parsers so we do not need to do this manual logic
         //       of render, setting view value etc.
         self.validateMacAddress = function () {
            if (self.selectedOption.id === 'manual') {
               var validationResult = macAddressValidatorService.validate(self.assignedMacAddress);
               self.macAddressForm.macAddressInput.$setValidity("required", validationResult.result);
               self.macAddressValidateErrorConfig.isVisible = !validationResult.result;
               self.macAddressValidateErrorConfig.message = validationResult.error;
            } else {
               self.macAddressForm.macAddressInput.$setValidity("required", true);
               self.macAddressValidateErrorConfig = resetErrorConfig();
            }
         };

         self.onSelectionChange = function () {
            self.addressType = self.selectedOption.id;

            if (self.selectedOption.id === self.originalAddressType) {
               var defaultMacAddress = isAutomaticAddressType(self.addressType) ? '' : self.MAC_ADDRESS_PREFIX;
               self.assignedMacAddress = !_.isEmpty(self.originalMacAddress) ?
                     self.originalMacAddress : defaultMacAddress;
            } else {
               if (self.originalAddressType === 'manual') {
                  if (self.addressType === 'manual') {
                     self.assignedMacAddress = self.originalMacAddress ? self.originalMacAddress : self.MAC_ADDRESS_PREFIX;
                  } else {
                     self.assignedMacAddress = self.originalMacAddress ? self.originalMacAddress : '';
                  }
               } else {
                  if (self.addressType === 'manual') {
                     self.assignedMacAddress = self.MAC_ADDRESS_PREFIX;
                  } else {
                     self.assignedMacAddress = self.originalMacAddress ? self.originalMacAddress : '';
                  }
               }
            }

            self.isAutomatic = isAutomaticAddressType(self.addressType);
            self.validateMacAddress();
         };

         self.onSelectionChange();
      };
   }
})();

/* Copyright 2016 Vmware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var MasterDetailsComponent = (function () {
        function MasterDetailsComponent($scope, i18nService, logService, navigation, vuiConstants) {
            this.$scope = $scope;
            this.i18nService = i18nService;
            this.logService = logService;
            this.navigation = navigation;
            this.vuiConstants = vuiConstants;
            this.isResizable = false;
            this.log = this.logService("vxMasterDetailsViewController");
            this.noItemsSelectedWarning = this.i18nService.getString("Common", "ListPreviewSplitView.noItemsSelected");
            this.multipleItemsSelectedWarning = this.i18nService.getString("Common", "ListPreviewSplitView.multipleItemsSelected");
            this.splitterOptions = {
                orientation: this.vuiConstants.splitter.orientation.VERTICAL,
                panes: [
                    { min: "250px", size: "50%" },
                    { size: "50%" }
                ]
            };
        }
        MasterDetailsComponent.prototype.$onInit = function () {
            this.$scope.detailsViewData = this.detailsViewData || {};
            this.$scope.masterDetailsViewContext = this.masterDetailsViewContext || {};
            var defaults = {
                selectedItems: [],
                detailsView: null,
                selectedItem: null,
                contextObjectId: this.navigation.getRoute().objectId
            };
            _.defaults(this.$scope.masterDetailsViewContext, defaults);
            this.initWatch();
        };
        MasterDetailsComponent.prototype.initWatch = function () {
            var _this = this;
            this.$scope.$watch(function () {
                return _this.$scope.masterDetailsViewContext.selectedItems;
            }, function (newValue, oldValue) {
                if (newValue === oldValue || _.isEqual(newValue, oldValue)) {
                    return;
                }
                if (!newValue || newValue.length === 0 || newValue.length > 1) {
                    _this.$scope.masterDetailsViewContext.selectedItem = null;
                }
                else {
                    _this.$scope.masterDetailsViewContext.selectedItem = newValue[0];
                }
            });
        };
        MasterDetailsComponent.$inject = ["$scope", "i18nService", "logService", "navigation", "vuiConstants"];
        return MasterDetailsComponent;
    }());
    platform.MasterDetailsComponent = MasterDetailsComponent;
    angular.module("com.vmware.platform.ui")
        .component("vxMasterDetailsComponent", {
        controller: MasterDetailsComponent,
        templateUrl: "resources/ui/components/masterdetails/vxMasterDetailsComponent.html",
        bindings: {
            masterViewTemplateUrl: "@",
            detailsViewData: "<?",
            masterDetailsViewContext: "<?",
            detailsViewTemplateUrl: "@?",
            isResizable: "@?"
        }
    });
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Master-details view controller.
 * Master-details view displays two views: master list view and details view one under another.
 *
 * Two hosted points should be defined, the first hosted point will be the master view,
 * and the second hosted point will be the details view.
 *
 * The following warning messages are displayed in the details view:
 * - "No item selected", when no items are selected in the master view
 * - "Multiple items selected", when multiple items are selected in the master view
 *
 * The controller expects the master view to set its selected items
 * into the scope variable called: "masterDetailsViewContext.selectedItems".
 *
 * Example:
 * 1. Defines Extension point for the master view
 *    <extensionPoint id="vsphere.core.samples.masterView">
 *       <objectType class="com.vmware.vise.mvc.model.ViewSpec"/>
 *    </extensionPoint>
 *
 * 2. Defines Extension point for the details view
 *    <extensionPoint id="vsphere.core.samples.detailsView">
 *       <objectType class="com.vmware.vise.mvc.model.ViewSpec"/>
 *    </extensionPoint>
 *
 * 3. Defines extension for the master-details view
 *    <extension id="vsphere.core.sample.masterDetailsView">
 *       <extendedPoint>vsphere.core.samples.views</extendedPoint>
 *       <hostedPoint>vsphere.core.samples.masterView</hostedPoint>
 *       <hostedPoint>vsphere.core.samples.detailsView</hostedPoint>
 *       <object>
 *          <contentSpec>
 *             <url>resources/ui/components/masterdetails/vxMasterDetailsView.html</url>
 *          </contentSpec>
 *       </object>
 *    </extension>
 *
 * 4. Defines extensions for my custom master views
 *    <extension id="vsphere.core.samples.myMasterView">
 *       <extendedPoint>vsphere.core.samples.masterView</extendedPoint>
 *       <object>
 *          <contentSpec>
 *             <url>path-to-my-master-view-template/MyMasterView.html</url>
 *          </contentSpec>
 *       </object>
 *    </extension>
 *
 * 5. Defines extension for my custom details view
 *    <extension id="vsphere.core.samples.myDetailsView">
 *       <extendedPoint>vsphere.core.samples.detailsView</extendedPoint>
 *       <object>
 *          <contentSpec>
 *             <url>path-to-my-details-view-template/MyDetailsView.html</url>
 *          </contentSpec>
 *       </object>
 *    </extension>
 */
var platform;
(function (platform) {
    var VxMasterDetailsViewController = (function () {
        function VxMasterDetailsViewController($scope, i18nService, logService, navigation) {
            this.$scope = $scope;
            this.i18nService = i18nService;
            this.log = logService('vxMasterDetailsViewController');
            this.$scope.masterDetailsViewContext = $scope.masterDetailsViewContext || {
                selectedItems: [],
                detailsView: null,
                selectedItem: null,
                contextObjectId: navigation.getRoute().objectId
            };
            this.initMasterDetailsUrls();
        }
        VxMasterDetailsViewController.prototype.initMasterDetailsUrls = function () {
            if (!this.$scope._view.children || this.$scope._view.children.length !== 2) {
                this.log.error('Master-details view: Expected 2 hosted points.');
            }
            else {
                var masterViewResponse = this.$scope._view.children[0];
                var detailsViewResponse = this.$scope._view.children[1];
                this.masterViewTemplateUrl = masterViewResponse.contentSpec.url;
                this.detailsViewTemplateUrl = detailsViewResponse.contentSpec.url;
                this.$scope.masterDetailsViewContext.detailsView = detailsViewResponse;
            }
        };
        VxMasterDetailsViewController.$inject = ['$scope', 'i18nService', 'logService', 'navigation'];
        return VxMasterDetailsViewController;
    }());
    angular.module('com.vmware.platform.ui').controller('vxMasterDetailsViewController', VxMasterDetailsViewController);
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Component used to display "No item selected" message in master-details views.
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxNoItemsSelected', ['i18nService', vxNoItemsSelected]);

   function vxNoItemsSelected(i18nService) {
      return {
         restrict: 'E',
         replace: true,
         scope: {
            message: '=?'
         },
         template: [
            '<div class="no-items-selected-container">',
               '<span class="no-items-selected-text" ng-bind="message || defaultMessage" />',
            '</div>'
         ].join(''),
         link: function($scope) {
            if (!$scope.defaultMessage) {
               $scope.defaultMessage = i18nService.getString(
                     'Common', 'ListPreviewSplitView.noItemsSelected');
            }
         }
      };
   }
})();
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * VxSingleExtensionTab view controller.
 *
 * VxSingleExtensionTab should be used to add extensible tabs (tabs that hosts extension point) to the
 * vxMasterDetailsView.
 *
 * Example:
 * 1. Defines Extension point that will be hosted by the tab
 *    <extensionPoint id="vsphere.core.samples.extensibleDetailsTab">
 *       <objectType class="com.vmware.vise.mvc.model.ViewSpec"/>
 *    </extensionPoint>
 *
 *
 * 2. Defines extension for the tab
 *    <extension id="vsphere.core.sample.singleExtensionView">
 *       <extendedPoint>vsphere.core.samples.tabbedDetails.tabs</extendedPoint>
 *       <hostedPoint>vsphere.core.samples.extensibleDetailsTab</hostedPoint>
 *       <object>
 *          <contentSpec>
 *             <url>resources/ui/components/masterdetails/vxSingleExtensionTab.html</url>
 *          </contentSpec>
 *       </object>
 *    </extension>
 *
 * 3. Define extension for the tab content
 *    <extension id="vsphere.core.samples.extensibleDetailsTabContentView">
 *       <extendedPoint>vsphere.core.samples.extensibleDetailsTab</extendedPoint>
 *       <object>
 *          <contentSpec>
 *             <url>path-to-template/MyTab2.html</url>
 *          </contentSpec>
 *       </object>
 *    </extension>
 */
(function () {
   'use strict';
   angular.module('com.vmware.platform.ui').controller('vxSingleExtensionTabController', VxSingleExtensionTabController);

   VxSingleExtensionTabController.$inject = ['extensionService', '$scope', 'logService', 'navigation'];

   function VxSingleExtensionTabController (extensionService, $scope, logService, navigation) {
      var log = logService('vxSingleExtensionTabController');
      var self = this;

      var objectId = navigation.getRoute().objectId;
      var extensionId;
      if ($scope.tabExtension) {
         extensionId = $scope.tabExtension.uid || navigation.getRoute().extensionId;
      } else {
         extensionId = navigation.getRoute().extensionId;
      }


      if (!extensionId || !objectId) {
         log.error('VxSingleExtensionTabController: invalid configuration');
         return;
      }

      extensionService.getHostedExtensions(extensionId, objectId).then(function (response) {
         if (!response || response.length !== 1) {
            log.error('VxSingleExtensionTabController: Expected 1 hosted point.');
         } else {
            self.viewTemplateUrl = response[0].contentSpec.url;
         }
      });
   }
})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Tabbed view controller for details view which displays multiple tabs.
 *
 * How to use:
 *
 * 1. Defines extension point for tabbed details view
 * <extensionPoint id="vsphere.core.samples.tabbedDetails.tabs">
 *    <objectType class="com.vmware.vise.mvc.model.ViewSpec"/>
 * </extensionPoint>
 *
 * 2. Define extension with hosted point from above (to be used by the tabs)
 *    <extension id="vsphere.core.samples.myTabbedDetailsView">
 *       <extendedPoint>vsphere.core.samples.masterDetails.detailsView</extendedPoint>
 *       <hostedPoint>vsphere.core.samples.tabbedDetails.tabs</hostedPoint>
 *       <object>
 *          <contentSpec>
 *             <url>resources/ui/components/masterdetails/vxTabbedDetailsView.html</url>
 *          </contentSpec>
 *       </object>
 *    </extension>
 *
 * 3. Define extension for each tab you want to plug into the tabbed details view:
 *
 * <extension id="vsphere.core.samples.myTab1">
 *    <extendedPoint>vsphere.core.samples.tabbedDetails.tabs</extendedPoint>
 *    <object>
 *       <name>Tab name</name>
 *       <contentSpec>
 *          <url>path-to-template/MyTab1.html</url>
 *       </contentSpec>
 *    </object>
 * </extension>
 *
 * We support filtering on the tabs with only support boolean flags on the selected items using
 * entry key-value pair in contentSpec metadata.
 * <extension id="vsphere.core.samples.myTab2">
 *    <extendedPoint>vsphere.core.samples.tabbedDetails.tabs</extendedPoint>
 *    <object>
 *       <name>Tab name</name>
 *       <contentSpec>
 *          <url>path-to-template/MyTab2.html</url>
 *          <metadata>
 *             <entry>
 *                <key>relevantFor<key>
 *                <value>isConnected, isPoweredOn</value>
 *             </entry>
 *          </metadata>
 *       </contentSpec>
 *    </object>
 * </extension>
 *
 * Master view is responsible to set the "isConnected" and "isPoweredOn" in its selected items.
 *
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').controller('vxTabbedDetailsViewController', VxTabbedDetailsViewController);

   VxTabbedDetailsViewController.$inject = ['extensionService', '$scope', 'logService', 'localStorageService', '$q', 'navigation'];

   function VxTabbedDetailsViewController (extensionService, $scope, logService, localStorageService, $q, navigation) {
      var log = logService('VxTabbedDetailsViewController');

      var self = this;
      var allTabs = [];

      self.tabViewApi = {};

      $scope.$watch(function() {
         return $scope.masterDetailsViewContext.selectedItem;
      }, function(newValue, oldValue) {
         if (newValue !== oldValue) {
            showRelevantTabsForItem(newValue);
         }
      });

      $scope.$watch(
         function () {
            return self.selectedTab;
         },
         function (newValue, oldValue) {
            if (newValue !== oldValue) {
               persistTabSelection();
            }
         });

      function getTabSelectionUserDataKey() {
         return navigation.getRoute().extensionId + "_selectedTab";
      }

      function persistTabSelection() {
         if (self.selectedTab && self.selectedTab.uid) {
            localStorageService.setUserData(getTabSelectionUserDataKey(), self.selectedTab.uid);
         }
      }

      function retrieveTabSelection() {
         return localStorageService.getUserData(getTabSelectionUserDataKey());
      }

      extractTabs().then(function() {
         if ($scope.masterDetailsViewContext.selectedItem) {
            showRelevantTabsForItem($scope.masterDetailsViewContext.selectedItem);
         }
      });

      function showRelevantTabsForItem(item) {
         var tabs = [];

         _.forEach(allTabs, function(currentTab) {
            if (isTabRelevant(item, currentTab)) {
               tabs.push(currentTab);
            }
         });

         self.tabs = tabs;

         // If the preserved selected tab is no more relevant for the newly selected item,
         // select the first tab. Need to set the selected tab before trying to clear cached tabs.
         if (self.selectedTab && !isTabRelevant(item, self.selectedTab)) {
            self.selectedTab = self.tabs[0];
         }

         if (self.tabViewApi && self.tabViewApi.clearCache) {
            self.tabViewApi.clearCache(self.selectedTab);
         }
      }

      function extractTabs() {
         var tabsPromise = $scope.detailsViewData.tabsPromise;
         if (!tabsPromise) {
            //Extracting tab config from extension framework
            tabsPromise = extensionService.getHostedExtensions($scope.masterDetailsViewContext.detailsView.uid).then(function (extensionResponse) {
               return _.map(extensionResponse, function (tabExtension) {
                  return {
                     name: tabExtension.name,
                     templateUrl: tabExtension.contentSpec.url,
                     metadata: tabExtension.contentSpec.metadata,
                     uid: tabExtension.uid,
                     tabParams: { tabExtension: tabExtension }
                  };
               });
            });
         }
         return $q.all([tabsPromise, retrieveTabSelection()]).then(function (responses) {
            var tabs = responses[0];
            var selectedTabUidResponse = responses[1];
            allTabs = [];
            _.forEach(tabs, function (tab) {
               allTabs.push(tab);
               if (selectedTabUidResponse && tab.uid === selectedTabUidResponse) {
                  self.selectedTab = tab;
               }
            });
         });
      }

      function isTabRelevant(selectedItem, tab) {
         if (!selectedItem) {
            return false;
         }

         if (!tab.metadata || !tab.metadata.relevantFor) {
            return true;
         }

         // The tab is visible only if the selected item defines the boolean
         // flags in the entry-value and they all evaluates to true i.e.
         // support only AND operation.
         var filterFlags = tab.metadata.relevantFor.split(',');

         var matchingFields = true;
         _.forEach(filterFlags, function(flag) {
            var trimmedFlag = flag.trim();
            var expectedFlagValue = true;
            if (trimmedFlag.charAt(0) === "!") {
               // The flag starts with ! and this is not field name. Treat ! as not
               trimmedFlag = trimmedFlag.substring(1);
               expectedFlagValue = false;
            }

            if (!selectedItem.hasOwnProperty(trimmedFlag)) {
               log.debug('Tabbed details view: Missing flags ' + trimmedFlag + ' for the selected item.');
               matchingFields = false;
            }

            if (selectedItem[trimmedFlag] !== expectedFlagValue) {
               matchingFields = false;
            }
         });
         return matchingFields;
      }
   }
})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * A simple context menu style menu.
 *
 * <p>
 * This directive has isolated scope. To use, pass the vx-menu attribute an object containing
 * the following properties:
 * <ul>
 * <li>showMenu: Boolean controlling when to show or hide the menu.</li>
 * <li>menuItems: Array of objects representing the items in the list. Each object should
 * contain:
 *    <ul>
 *    <li>id: Unique string identifier for the item.</li>
 *    <li>label: Localized display text for the item.</li>
 *    <li>icon: CSS class name of an icon for the item.</li>
 *    <li>enabled: Boolean controlling whether the item is enabled (clickable) or not.</li>
 *    </ul>
 *    Use 'separator' string to insert separator between items in the list.
 * </li>
 * <li>itemClick: Function accepting a click event and called when an enabled menu item
 * is clicked. The event is raised on the menu itself, so the function is responsible for
 * finding the parent li that was clicked. The id of the li is set to the id of the item data.</li>
 * <li>left: The absolute coordinate for the left side of the menu.</li>
 * <li>top: The absolute coordinate for the top side of the menu.</li>
 * <li>header: An object containing the following properties:
 *    <ul>
 *       <li>show: Boolean controlling whether a header is shown for this menu.</li>
 *       <li>icon: CSS class name of an icon for the header.</li>
 *       <li>label: Localized display text for the header.</li>
 *    </ul>
 * </li>
 * </p>
 */
(function () {
    angular.module('com.vmware.platform.ui').directive('vxMenu', vxMenu);
    function vxMenu() {
        return {
            restrict: 'A',
            templateUrl: 'resources/ui/components/menu/vxMenuTemplate.html',
            scope: {
                vxMenu: '='
            },
            link: function (scope, element, attrs, controller) {
                if (!h5.debug) {
                    element.on('contextmenu', function () {
                        return false;
                    });
                }
                scope.clickHandler = function (event) {
                    // Get clicked on item.
                    var targetElement = $(event.target);
                    var liElement = targetElement.closest("li");
                    if (liElement.length === 0) {
                        // Clicked on some empty space that wasn't an item.
                        return false;
                    }
                    var clickedItem = $(liElement[0]);
                    if (clickedItem.hasClass("disabled")) {
                        // Do nothing if item is disabled.
                        return false;
                    }
                    // Hide menu then call the click handler the client supplied.
                    scope.vxMenu.showMenu = false;
                    // inform trigger point of closing action
                    scope.vxMenu.isShowing = false;
                    scope.vxMenu.itemClick(event, clickedItem[0]);
                };
                //Returns true if item is string divider
                scope.isDivider = function (item) {
                    return item === 'SEPARATOR';
                };
                // Styles is bound in the template using ng-style. We use it only to control
                // the coordinates, according to what the client is putting on the scope.
                scope.styles = { left: '0px', top: '0px' };
                scope.$watch("vxMenu.left", function (val) {
                    scope.styles.left = val + 'px';
                });
                scope.$watch("vxMenu.top", function (val) {
                    scope.styles.top = val + 'px';
                });
            }
        };
    }
}());



angular.module('com.vmware.platform.ui').directive('vxResourceMeter', function () {
   return {
      restrict: 'E',
      replace: true,
      scope: {
         percentage: '=',
         orientation: '@'
      },
      templateUrl: 'resources/ui/components/meter/vxResourceMeter.html'
   };
});
/**
 * Clarity Modal decorators
 * - formats the title into two pieces, action and optional ( but recommended ) object title
 */
angular.module('com.vmware.platform.ui').directive('modalTitle', function() {
   return {
      restrict: 'A',
      scope: {
         primaryTitle: "=",
         secondaryTitle: "="
      },
      templateUrl: 'resources/ui/components/modal/modalTitle.html'
   };
});

/* Copyright 2018 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var VxModalKeyService = (function () {
        function VxModalKeyService(vxZoneService, clarityConstants) {
            this.vxZoneService = vxZoneService;
            this.clarityConstants = clarityConstants;
        }
        VxModalKeyService.prototype.onKeydownHandler = function (event, onEsc, onEnter) {
            var _this = this;
            var code = event.which || event.keyCode;
            if (code !== this.clarityConstants.keys.ESC &&
                code !== this.clarityConstants.keys.ENTER) {
                return;
            }
            // Avoid propagation of any keydown event for ESC and ENTER since some other dialog might be
            // listening for it and trigger undesired functionality as closing the other
            // dialog when the current one on is on focus.
            event.stopImmediatePropagation();
            // Run handling inside angular otherwise
            // $digest already in progress error appears
            this.vxZoneService.runInsideAngular(function () {
                switch (code) {
                    case _this.clarityConstants.keys.ESC:
                        if (!!onEsc) {
                            onEsc();
                        }
                        break;
                    case _this.clarityConstants.keys.ENTER:
                        if (!!onEnter) {
                            onEnter();
                        }
                        break;
                }
            });
        };
        ;
        VxModalKeyService.$inject = ['vxZoneService', 'clarityConstants'];
        return VxModalKeyService;
    }());
    platform.VxModalKeyService = VxModalKeyService;
    angular.module("com.vmware.platform.ui")
        .service("vxModalKeyService", VxModalKeyService);
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * @ngdoc directive
 * @name com.vmware.platform.ui.directive:vxObjectLabel
 *
 * @description
 * Represents and object with an icon and and a label containing the object name<BR><BR>
 *
 * Component reuses the 'object-link' renderer.
 *
 * Sample usage:
 *
 * <vx-object-label
 *    object-id="{{controller.datacenterId}}"
 *    object-icon="{{controller.objectIcon}}"
 *    object-name="{{controller.objectName}}">
 * </vx-object-label>
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxObjectLabel', vxObjectLabel);

   vxObjectLabel.$inject = ['columnRenderersRegistry', '$timeout'];

   function vxObjectLabel(columnRenderersRegistry, $timeout) {
      var propertiesChanged = false;
      return {
         restrict: 'E',
         scope: {
            objectIcon: '@',
            objectName: '@',
            objectId: '@'
         },
         link: function(scope, element, attrs) {
            attrs.$observe('objectId', invalidateProperties);
            attrs.$observe('objectIcon', invalidateProperties);
            attrs.$observe('objectName', invalidateProperties);

            renderElement(scope);

            function invalidateProperties() {
               if (propertiesChanged) {
                  return;
               }
               propertiesChanged = true;
               $timeout(function() {
                  if (propertiesChanged) {
                     renderElement(scope);
                     propertiesChanged = false;
                  }
               }, 0);
            }

            function renderElement(scope) {
               var renderer =
                     columnRenderersRegistry.getColumnRenderer('object-link');
               var data = {
                  id: scope.objectId,
                  label: scope.objectName
               };
               element.html(renderer(['id', 'label', scope.objectIcon], data));
            }
         }
      };
   }
})();

/*
 *  Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential
 */

/**
 * Directive which represents the Object Selector. The object selector got the same
 * behaviour as the Flex ObjectSelector v3. The selector contains 3 different tabs
 * (filter, browse, selected objects).
 *
 * 1) Filter tab is always shown, which means that the listTabConfig is always required.
 * 2) Browse tab shows the inventory tree and is displayed when there's an available
 * treeTabConfig and multipleSelect == false. If in treeTabConfig object a caption property
 * is passed, it will appear above the tree as caption label.
 * 3) Selected objects tab is shown when multipleSelect == true.
 *
 * Usage:
 *
 * var config = {
 *    contextObject: "some-context-object-id",
 *    multipleSelect: false,
 *    listTabConfig: {
 *       selectedTabIndex: 0, // tab index to be preselected after load
 *       label: "Filter",
 *       listConfig: [ {
 *          label: "Label",
 *          listViewId: "vsphere.core.host.list",
 *          dataModels: ["HostSystem"],
 *          filterId: "some-filter-id",
 *          filterParams: [ "obj-id-1", "obj-id-2", ... ],
 *          propertyParams: [ {      // array of ParamSpec. See com.vmware.vise.mvc.model.data.ParamSpec.java
 *             propertyName: "propertyName",
 *             parameterType: "java.lang.String",
 *             parameter: "foo"
 *          ] }
 *       } ]
 *    },
 *    treeTabConfig: {
 *      caption: "CaptionLabel",
 *      treeConfig: {
 *         treeId: "vsphere.core.physicalInventorySpec",
 *         rootObjRef: rootObjRef
 *      }
 *    },
 *    onSelectionChanged: function (newSelectedItems, oldSelectedItems) {
 *        ...
 *    },
 *    selectedObjects: [
 *       "some-id-1",
 *       "some-id-2",
 *       ...
 *    ]
 * };
 *
 * filterParams: the list of object ids will be provided as a 2nd argument to the
 * Java filter implementation. It's up to the user what to do with the provided object ids.
 * It's possible to use them as a way to exclude some of the objects from the filter.
 *
 * newSelectedItems & oldSelectedItems will be arrays of objects, i.e:
 * [{
 *       "id": "urn:vmomi:Folder:group-d1:bbb78699-6264-4232-87ac-01d55fc20e42",
 *       "icon": "vsphere-icon-vcenter",
 *       "name": "sof2-rila-5-13.eng.vmware.com",
 *       "rawData": {
 *         "text": "sof2-rila-5-13.eng.vmware.com",
 *         "spriteCssClass": "vsphere-icon-vcenter",
 *         "objRef": "urn:vmomi:Folder:group-d1:bbb78699-6264-4232-87ac-01d55fc20e42",
 *         "nodeTypeId": "VcRoot",
 *         "items": [],
 *         "index": 0,
 *         "selected": true
 *       }
 * },
 * { ... },
 * { ... }
 * ]
 *
 * <div vx-object-selector config="config"></div>
 *
 * If `filterId` is not provided, the object selector will fetch the relation id for
 * the ListView based on the provided `listViewId` and `dataModels[0]`.
 *
 * Samples:
 *
 * 1) '''Filter tab only'''
 *  1.1 '''One object type'''
 *    var config = {
 *          contextObject: "some-context-object-id",
 *          multipleSelect: false,
 *          listTabConfig: {
 *             label: "Filter",
 *             listConfig: [ {
 *                label: "Label",
 *                listViewId: "vsphere.core.host.list",
 *                dataModels: ["HostSystem"],
 *                filterId: "some-filter-id"
 *             } ]
 *          }
 *    };
 *
 *  1.2 '''Many object types'''
 *    var config = {
 *          contextObject: "some-context-object-id",
 *          multipleSelect: false,
 *          listTabConfig: {
 *             label: "Filter",
 *             listConfig: [
 *                {
 *                   label: "Label_1",
 *                   listViewId: "vsphere.core.host.list",
 *                   dataModels: ["HostSystem"],
 *                   filterId: "some-host-filter-id"
 *                },
 *                {
 *                   label: "Label_2",
 *                   listViewId: "vsphere.core.datastore.list",
 *                   dataModels: ["Datastore"],
 *                   filterId: "some-datastore-filter-id"
 *                }
 *             ]
 *          }
 *    };
 *
 * 2) '''Browse tab only'''
 *    var config = {
 *          contextObject: "some-context-object-id",
 *          multipleSelect: false,
 *          treeTabConfig: {
 *             caption: "CaptionLabel",
 *             treeConfig: {
 *                treeId: "vsphere.core.physicalInventorySpec",
 *                rootObjRef: rootObjRef
 *             }
 *          }
 *    };
 *
 * 3) '''Filter + Browse tab'''
 *    var config = {
 *          contextObject: "some-context-object-id",
 *          multipleSelect: false,
 *          listTabConfig: {
 *             label: "Filter",
 *             listConfig: [ {
 *                label: "Host",
 *                listViewId: "vsphere.core.host.list",
 *                dataModels: ["HostSystem"],
 *                filterId: "some-filter-id"
 *             } ]
 *          },
 *          treeTabConfig: {
 *             caption: "CaptionLabel",
 *             treeConfig: {
 *                treeId: "vsphere.core.physicalInventorySpec",
 *                rootObjRef: rootObjRef
 *             }
 *          }
 *    };
 *
 * 4) '''Filter + "Selected Objects" tabs (multiple selection)'''
 *    var config = {
 *          contextObject: "some-context-object-id",
 *          multipleSelect: true,
 *          listTabConfig: {
 *             label: "Filter",
 *             listConfig: [ {
 *                label: "Label",
 *                listViewId: "vsphere.core.host.list",
 *                dataModels: ["HostSystem"],
 *                filterId: "some-filter-id"
 *             } ]
 *          }
 *    };
 */
angular.module('com.vmware.platform.ui').directive('vxObjectSelector', ['i18nService', 'logService',
   'vuiConstants', '$timeout', '$http', '$q', 'defaultUriSchemeUtil',
   function(i18nService, logService, vuiConstants, $timeout, $http, $q, defaultUriSchemeUtil) {
      var log = logService('vxObjectSelector');
      var _itemsBeforeRemove = null;
      var _removeItemsInProgress = false;

      return {
         templateUrl: 'resources/ui/components/objectselector/vxObjectSelector.html',
         restrict: 'A',
         scope: {
            config: '='
         },
         link: linkFn
      };

      function linkFn($scope, element) {
         // mapping from listViewId -> array of selected objects
         var selectedItems = {};
         var configCallback = $scope.config.onSelectionChanged;
         // used only when multipleSelect is false
         $scope.currentSelection = [];

         $scope.primaryTabOptions = {
            hideWhenSingleTab: !$scope.multipleSelect,
            tabs: createPrimaryTabs($scope, element),
            tabType: vuiConstants.tabs.type.PRIMARY
         };

         $scope.config.multipleSelect = angular.isDefined($scope.config.multipleSelect) ?
               !!$scope.config.multipleSelect : false;

         $scope.config.selectedObjects = extractSelectedObjects($scope.config);

         $scope.$watch(function() {
            if ($scope.filterTabOptions && $scope.filterTabOptions.selectedTabIndex) {
               return $scope.filterTabOptions.selectedTabIndex;
            }
         }, function(newItem, oldItem) {
            if (newItem === oldItem) {
               return;
            }
            $timeout(function() {
               var grid = getGrid(element, $scope.filterTabOptions.tabs
                     [$scope.filterTabOptions.selectedTabIndex].listViewId);
               if (!grid) {
                  return;
               }
               var kendoGrid = grid.data('kendoGrid');
               if (!kendoGrid) {
                  return;
               }
               kendoGrid.resize(true);
            }, 0);
         });

         if ($scope.config.treeTabConfig) {
            if ($scope.config.multipleSelect) {
               throw new Error('Configuration error: tree is not supported in multipleSelect mode');
            }

            $scope.treeConfig = $scope.config.treeTabConfig.treeConfig || {};

            angular.extend($scope.treeConfig, {
               preselectRoot: false
            });

            $scope.onTreeSelectionChanged = function(item) {
               var old = $scope.currentSelection;
               $scope.currentSelection = [formatItem(item)];

               if (old.length &&
                     _.isEqual(_.values(selectedItems)[0], old)) {

                  var deselectListViewId = _.keys(selectedItems)[0];
                  deselectAllFromList(element, deselectListViewId);
                  delete selectedItems[deselectListViewId];
               }

               triggerConfigCallback(configCallback, $scope.currentSelection, old);
            };

            if ($scope.config.selectedObjects.length) {
               $scope.treePreselectedNode = $scope.config.selectedObjects[0];
               var activeTabIndex = _.findIndex($scope.primaryTabOptions.tabs, {
                  label: i18nService.getString('CommonUi',
                        'objectSelector.navigationTabTitle')
               });
               $scope.primaryTabOptions.selectedTabIndex = activeTabIndex !== -1 ?
                     activeTabIndex : 0;
            }
         }

         if ($scope.config.listTabConfig) {
            var configTabIndex = $scope.config.listTabConfig.selectedTabIndex;
            var selectedTabIndex = angular.isDefined(configTabIndex) ? configTabIndex : 0;
            var listConfig = $scope.config.listTabConfig.listConfig;
            if (!isValidListConfig(listConfig)) {
               return;
            }

            if ($scope.config.selectedObjects.length && !$scope.config.treeTabConfig) {
               // Clone the array since the onSelectionChange callback is invoked
               // in-between the loading of the two tabs and overrides the original array.
               var selectedObjects = _.clone($scope.config.selectedObjects);

               var preselectComparator = function(item) {
                  if (!item) {
                     return false;
                  }
                  return selectedObjects.indexOf(item.id) > -1;
               };
               _.each(listConfig, function(conf) {
                  conf.preselectComparator = preselectComparator;
               });
            }

            createFilterTabs(listConfig, $scope).then(function(tabs) {
               var contextObject = $scope.config.contextObject;
               var selectionMode = $scope.config.multipleSelect ?
                     vuiConstants.grid.selectionMode.MULTI :
                     vuiConstants.grid.selectionMode.SINGLE;
               var numConfigs = listConfig.length;
               // Initialize watchers for reloadable tabs.
               var watchExpressionFunctions = _.flatten(_.map(listConfig, function(config) {
                  return [
                     function() {
                        return config.propertyParams;
                     }, function() {
                        return config.filterId;
                     }
                  ];
               }));
               $scope.$watchGroup(watchExpressionFunctions, function(newValues, oldValues) {
                  _.each(_.range(numConfigs), function(tabIndex) {
                     var tabPropertyParamsValueIndex = tabIndex * 2;
                     var tabFilterIdValueIndex = tabPropertyParamsValueIndex + 1;
                     if (newValues[tabPropertyParamsValueIndex] !== oldValues[tabPropertyParamsValueIndex] ||
                           newValues[tabFilterIdValueIndex] !== oldValues[tabFilterIdValueIndex]) {
                        reloadTab(tabIndex);
                     }
                  });
               });
               initializeFilterTabs(tabs);

               function reloadTab(idx) {
                  // Deselect and reload inside a timeout to avoid nested $digest.
                  $timeout(function reload() {
                     var deselectListViewId = listConfig[idx].listViewId;
                     delete selectedItems[deselectListViewId];

                     // Update the Selected Objects tab to ensure that no weird
                     // selection behaviour occurs after recreating the filter tab.
                     if ($scope.config.multipleSelect) {
                        var selectedObjTab = $scope.primaryTabOptions.tabs[1];
                        updateSelectedObjectsTab(element, selectedItems, selectedObjTab);
                     }

                     // Deselect the items in the tab before recreating it to
                     // remove them from the Selected Objects tab.
                     deselectAllFromList(element, deselectListViewId);

                     tabs[idx] = createTab(contextObject, selectionMode, listConfig[idx]);
                     initializeFilterTabs([tabs[idx]]);
                  }, 0);
               }

               function initializeFilterTabs(tabsToInit) {
                  initializeTabs(tabsToInit, selectedTabIndex, selectedItems, $scope, element);
                  $scope.filterTabOptions = {
                     selectedTabIndex: selectedTabIndex,
                     tabs: tabs,
                     tabType: vuiConstants.tabs.type.SECONDARY,
                     tabStyle: $scope.config.tabStyle ?
                           $scope.config.tabStyle :
                           vuiConstants.tabs.style.TABS,
                     hideWhenSingleTab: true
                  };
               }
            });
         }
      }

      function initializeTabs(tabs, selectedTabIndex, selectedItems, $scope, element) {
         // Attach onSelectionChange callbacks to each listView in the tabs.
         // We do it here, after creating the tabs, because we don't want
         // createFilterTabs() to track the selectedItems for each listview
         _.each(tabs, function(tab, idx) {
            var old, current;

            // For the currently selected tab - override deferred instantiation
            // flag - so that it is instantiated immediately.
            if (idx === selectedTabIndex) { tab.deferInstantiation = false; }

            tab.onSelectionChanged = function(newItems, oldItems) {
               if (isInitializing(newItems, oldItems)) {
                  return;
               }

               var items = _.map(newItems, formatItem);
               if ($scope.config.multipleSelect) {
                  old = _.chain(selectedItems).values().flatten().value();
                  selectedItems[tab.listViewId] = items;
                  current = _.chain(selectedItems).values().flatten().value();
                  var selectedObjTab = $scope.primaryTabOptions.tabs[1];
                  updateSelectedObjectsTab(element, selectedItems, selectedObjTab);
                  $scope.config.selectedObjects = _.pluck(current, 'id');
               } else {
                  if (!newItems || !newItems.length) {
                     return;
                  }
                  old = _.flatten(_.values(selectedItems));

                  // Get the id of the first (and only) list view that currently
                  // has a selection. If it is not the current list view, trigger
                  // a deselection, otherwise let Kendo handle it.
                  var deselectListviewId = _.keys(selectedItems)[0];
                  if (deselectListviewId !== tab.listViewId && old.length) {
                     deselectAllFromList(element, deselectListviewId);
                     delete selectedItems[deselectListviewId];
                  }

                  // If there is a currently selected item but listViewSelections
                  // is empty, this means that the selection is in the tree
                  // and we should deselect everything from in it.
                  if ($scope.currentSelection.length && !old.length) {
                     old = old.concat($scope.currentSelection);
                     deselectAllFromTree(element);
                  }

                  selectedItems[tab.listViewId] = items;
                  $scope.currentSelection = items;
                  current = items;
               }

               if (_removeItemsInProgress && !_itemsBeforeRemove) {
                  _itemsBeforeRemove = _.clone(old);
               }

               if (!_removeItemsInProgress) {
                  if (!_itemsBeforeRemove) {
                     triggerConfigCallback($scope.config.onSelectionChanged,
                           current, old);
                  } else {
                     triggerConfigCallback($scope.config.onSelectionChanged,
                           current, _itemsBeforeRemove);
                     _itemsBeforeRemove = null;
                  }
               }

               $scope.config.selectedObjects = _.pluck(current, 'id');
            };
            tab.onClick = function (event, tab) {
               // NOTE: Clicking on a tab clears deferred instantiation flag -
               // so that it is instantiated as soon as possible. If the flag was already
               // cleared - or was set to false initially (the default in most cases) -
               // then the bellow assignment has no effect whatsoever.
               tab.deferInstantiation = false;
            };
         });
      }

      function getGrid(element, listviewId) {
         var grid = element.find('[list-view-id="' + listviewId + '"] [kendo-grid]');

         return grid;
      }

      function deselectAllFromList(element, deselectListviewId) {
         var grid = getGrid(element, deselectListviewId);
         var kendoGrid = grid.data('kendoGrid');

         if (kendoGrid !== undefined) {
            grid.data('kendoGrid').clearSelection();
         }
      }

      function getTree(element) {
         var tree = element.find('[vx-tree-view]');

         return tree;
      }

      function deselectAllFromTree(element) {
         var tree = getTree(element);
         tree.data("kendoTreeView").select($());
      }

      function getDuplicateIds(listConfig, propertyName) {
         var ids = {};
         var dups = [];
         _.each(listConfig, function(cfg) {
            var val = cfg[propertyName];
            if (ids.hasOwnProperty(val)) {
               dups.push(val);
            }
            ids[val] = 1;
         });
         return dups;
      }

      /**
       * Creates the config for the primary tabs (Filter, Browse, Selected objects) in the
       * object selector.
       *
       * @param $scope The current angular scope
       * @returns {Array} An array containing the definitions required by <vui-tabs>
       */
      function createPrimaryTabs($scope, element) {
         var config = $scope.config;
         var tabs = [];

         if (config.listTabConfig) {
            var filterTabTitle = i18nService.getString('CommonUi',
                  'objectSelector.filterTabTitle');
            var filterLabel = config.listTabConfig.label || filterTabTitle;
            var filterTab = {
               label: filterLabel,
               contentUrl: 'resources/ui/components/objectselector/filterTab.html',
            };
            tabs.push(filterTab);
         }

         if (config.treeTabConfig && !config.multipleSelect) {
            var browseTab = {
               label: i18nService.getString('CommonUi',
                     'objectSelector.navigationTabTitle'),
               contentUrl: 'resources/ui/components/objectselector/browseTab.html'
            };
            tabs.push(browseTab);
         }

         if (config.multipleSelect) {
            var selectObjectsTab = {
               label: i18nService.getString('CommonUi',
                     'objectSelector.selectedObjectsTabTitle', 0),
               contentUrl: 'resources/ui/components/objectselector/selectObjectsTab.html',
               gridOpts: createSelectedItemsGridOpts($scope, element)
            };
            tabs.push(selectObjectsTab);
         }
         return tabs;
      }

      function createFilterTabs(listConfig, $scope) {
         var contextObject = $scope.config.contextObject;
         var selectionMode = $scope.config.multipleSelect ? vuiConstants.grid.selectionMode.MULTI :
               vuiConstants.grid.selectionMode.SINGLE;
         var relItemsTabs = _.filter(listConfig, function(conf) {
            return !angular.isDefined(conf.filterId);
         });
         var tabs;

         if (relItemsTabs.length === 0) {
            tabs = _.map(listConfig, function(conf) {
               return createTab(contextObject, selectionMode, conf);
            });
            return $q.when(tabs);
         }

         var promises = _.map(relItemsTabs, function(tab) {
            return fetchRelatedItem(contextObject, tab.listViewId, tab.dataModels[0]);
         });

         return $q.all(promises).then(function(relationSpecs) {
            tabs = _.map(listConfig, function(conf) {
               return createTab(contextObject, selectionMode, conf, relationSpecs);
            });
            return tabs;
         });
      }

      function createTab(contextObject, selectionMode, conf, relationSpecs) {
         var tab = {
            label: conf.label,
            contentUrl: 'resources/ui/components/objectselector/tabContent.html',
            listViewId: conf.listViewId,
            contextObject: contextObject,
            selectionMode: selectionMode,
            filterId: conf.filterId,
            dataModels: conf.dataModels,
            preselectComparator: conf.preselectComparator,
            filterParams: conf.filterParams,
            propertyParams: conf.propertyParams,
            showLoadingIndicatorWhileFetchingColumns: conf.showLoadingIndicatorWhileFetchingColumns,
            loadingIndicatorSize: conf.loadingIndicatorSize,
            deferInstantiation: conf.useLazyInstantiation ? true : false,
         };
         if (!conf.filterId) {
            tab.relationId = relationSpecs.shift().relationId;
         }
         return tab;
      }

      function fetchRelatedItem(contextObject, listViewId, targetType) {
         return $http({
            method: 'get',
            url: 'relateditems/relateditem/' + contextObject + '?listViewId=' +
            listViewId + '&targetType=' + targetType
         }).then(function(res) {
            return res.data;
         });
      }

      function createSelectedItemsGridOpts($scope, element) {
         var nameTemplate = '<span ng-non-bindable>' +
               '<span class="#:iconClass#"></span>#:name#</span>';

         var removeItemsButton = {
            actionId: 'removeItems',
            tooltipText: i18nService.getString('CommonUi', 'selector.removeItems'),
            label: i18nService.getString('CommonUi', 'selector.removeItems'),
            enabled: true,
            iconClass: 'vx-icon-removeIcon',
            onClick: removeItemsCallback
         };

         var opts = {
            columnDefs: [
               {
                  displayName: i18nService.getString('CommonUi',
                        'objectSelector.selectedObjectsTabName'),
                  template: kendo.template(nameTemplate),
                  field: 'name',
                  width: '50%'
               },
               {
                  displayName: i18nService.getString('CommonUi',
                        'objectSelector.selectedObjectTabType'),
                  field: 'type'
               }
            ],
            sortMode: vuiConstants.grid.sortMode.SINGLE,
            selectionMode: vuiConstants.grid.selectionMode.MULTI,
            data: [],
            selectedItems: [],
            resizable: true,
            searchable: false,
            actionBarOptions: {
               actions: [removeItemsButton]
            }
         };

         $scope.$watch(function() {
            return opts.selectedItems;
         }, function(newItems) {
            removeItemsButton.enabled = !!newItems.length;
         });

         /**
          * Function executed when the 'Remove Items' button in the
          * 'Selected items' tab is clicked.
          *
          * When called deselects selected items in other Object Selector tabs.
          */
         function removeItemsCallback() {
            var selectedItemsGrid = element.find('#selected-objects > div')
                  .data('kendoGrid');

            var selectedItemsData = selectedItemsGrid.dataSource.data();
            var itemsToDeselect = selectedItemsGrid.select();

            // Map the kendo ids to the vsphere ids,
            // so that we can find the item across list views.
            var vsIds = [];
            for (var i = 0, j = 0; i < selectedItemsData.length && j < itemsToDeselect.length; i++) {
               if (selectedItemsData[i].uid === itemsToDeselect[j].getAttribute('data-uid')) {
                  vsIds.push(selectedItemsData[i].id);
                  j++;
               }
            }

            // Deselect the item inside a timeout, so that we do not trigger a digest
            // cycle inside the currently running digest cycle.
            $timeout(function() {
               // Properly update the check-all checkbox.
               itemsToDeselect.find('input[type="checkbox"]').click();
            }, 0);

            // Collect all list view datasource items.
            var dataSources = _.map(
                  element.find('.vui-secondary-tabs [vui-datagrid] > div'),
                  function(item) {
                     var grid = $(item).data('kendoGrid');

                     return grid.dataSource.data();
                  });

            var uidsToDelete = [];
            _.each(dataSources, function(dataSource) {
               for (var i = 0; i < dataSource.length; i++) {
                  var index = vsIds.indexOf(dataSource[i].id);
                  if (index !== -1) {
                     uidsToDelete.push(dataSource[i].uid);
                     delete vsIds[index];
                  }
               }
            });

            // Deselect the item inside a timeout, so that we do not trigger a digest
            // cycle inside the currently running digest cycle.
            $timeout(function() {
               _removeItemsInProgress = true;
               _.each(uidsToDelete, function(uid) {
                  if (uid === uidsToDelete[uidsToDelete.length - 1]) {
                     // Turn off the flag before the last deselect digest cycle
                     // so the onSelectionChange callback can be properly called.
                     _removeItemsInProgress = false;
                  }
                  element.find('[data-uid="' + uid + '"] input[type="checkbox"]').click();
               });
            }, 0);
         }

         return opts;
      }

      /**
       * Updates the grid in the "Selected object (XX)" tab.
       * Clears the grid and adds the new items from the selectedItems param.
       *
       * NOTE: This will not update the vui-datagrid internal selection.
       *
       * @param element The DOM element of the grid
       * @param selectedItems Currently selected items from all listview grids
       * @param selectedObjTab The vui tab object, contained in the primaryTabOptions.
       */
      function updateSelectedObjectsTab(element, selectedItems, selectedObjTab) {
         if (!element) {
            return;
         }
         var grid = element.find('#selected-objects > div').data("kendoGrid");
         if (!grid) {
            return;
         }
         var gridData = _.chain(selectedItems)
               .map(function(values, listViewId) {
                  if (!values || values.length === 0) {
                     return [];
                  }
                  return _.map(values, function(val) {
                     return {
                        iconClass: val.icon,
                        name: val.name,
                        type: getObjectType(val.id),
                        id: val.id
                     };
                  });
               })
               .flatten()
               .value();

         grid.dataSource.data(gridData);
         selectedObjTab.label = i18nService.getString('CommonUi',
               'objectSelector.selectedObjectsTabTitle', gridData.length);
      }

      /**
       * Returns a localized object type for an objectId, i.e 'Host' for
       * 'HostSystem:host-1:server-guid'.
       * @param objectId Object references
       * @returns {String} Localized type or an empty string, if the ref is invalid.
       */
      function getObjectType(objectId) {
         if (!objectId) {
            return '';
         }
         var type = defaultUriSchemeUtil.getEntityType(objectId);
         if (!type) {
            return '';
         }
         return i18nService.getString('Common', 'fieldType.' + type);
      }

      /**
       * Invokes the provided user callback.
       *
       * @callback configCallback The function provided by the user.
       * @param current {String[]} Current selected items.
       * @param old {String[]} Old selected items.
       */
      function triggerConfigCallback(configCallback, current, old) {
         if (configCallback && current) {
            configCallback(current, old);
         }
      }

      /**
       * Transforms a tree or listview item into a common format for the end user.
       * The original object is also provided as the 'rawData' property.
       */
      function formatItem(item) {
         return {
            id: item.id || item.objRef,
            icon: item.primaryIconId || item.spriteCssClass,
            name: item.name || item.text,
            rawData: item
         };
      }

      /**
       * Checks if the properties, which hold the selected items are still being
       * initialized.
       */
      function isInitializing(newItems, oldItems) {
         return !newItems ||
               newItems && newItems.length === 0 && (!oldItems || oldItems.length === 0);
      }

      function extractSelectedObjects(config) {
         var preselected = config.selectedObjects ?
               config.selectedObjects : [];

         if (!config.multipleSelect && preselected.length > 1) {
            log.error('Configuration error: Cannot preselect more than' +
                  'one item when multiple selection is set to false');
            return [preselected[0]];
         }

         return preselected;
      }

      /**
       * @param {Array} listConfig
       * @return {boolean}
       */
      function isValidListConfig(listConfig) {
         var listViewDups = getDuplicateIds(listConfig, 'listViewId');
         if (listViewDups.length !== 0) {
            log.error('Duplicate list view ids: ' + listViewDups.join());
            return false;
         }

         for (var i = 0; i < listConfig.length; i++) {
            if (!listConfig[i].dataModels || !listConfig[i].dataModels.length) {
               log.error('Missing or empty data models for list view: ' +
                     listConfig[i].listViewId);
               return false;
            }
         }

         var dataModelsDups = getDuplicateIds(listConfig, 'dataModels');
         if (dataModelsDups.length !== 0) {
            log.error('Duplicate data models: ' + dataModelsDups.join());
            return false;
         }

         return true;
      }

   }]);

/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var common_ui;
(function (common_ui) {
    /**
     * Wrapper component designed specifically to upgrade vxObjectSelector directive and
     * allow object selector usage in angular.next components.
     * This component is not intended to be used by angular 1.5 components. For this
     * purpose the vxObjectSelector directive should continue to be used.
     */
    var UpgradableObjectSelector = (function () {
        function UpgradableObjectSelector() {
            this.bindings = {
                config: "<"
            };
            this.controller = UpgradableObjectSelectorController;
            this.template =
                "<div vx-object-selector\n                     config=\"$ctrl.config\"\n               </div>";
        }
        return UpgradableObjectSelector;
    }());
    common_ui.UpgradableObjectSelector = UpgradableObjectSelector;
    var UpgradableObjectSelectorController = (function () {
        function UpgradableObjectSelectorController() {
        }
        return UpgradableObjectSelectorController;
    }());
    angular.module("com.vmware.platform.ui")
        .component("vxUpgradableObjectSelector", new UpgradableObjectSelector());
})(common_ui || (common_ui = {}));



// Copyright (c) 2016 VMware, Inc.  All rights reserved. -- VMware Confidential

angular.module('com.vmware.platform.ui').directive('vxPortlets', [
   '$log', 'jsUtils', 'persistenceService', 'navigation', 'defaultUriSchemeUtil', '$rootScope', '$timeout',
   function ($log, jsUtils, persistenceService, navigation, defaultUriSchemeUtil, $rootScope, $timeout) {
      'use strict';
      var KEY_CODE_SPACE = 32;
      return {
         scope: true,
         restrict: 'A',
         replace: true,

         templateUrl: 'resources/ui/components/portlet/portlets.html',

         link: function (scope, element, attributes) {
            var portletOptionsPropName = attributes.vxPortlets;
            var PORTLETS_STATE_CATEGORY = 'portletsStateCategory';
            var PORTLETS_CLASSNAME = 'vx-portlets';
            var PORTLET_CLASSNAME = 'vx-portlet';

            var portletsPersistParams = {
               extensionId: navigation.getRouteFromUrl().extensionId,
               entityType: defaultUriSchemeUtil.getEntityType($rootScope._route.objectId)
            };

            // toggles
            // - collapsed/expanded state
            // - collapsed/expanded classname
            // persists the updated portlets state
            scope.toggleCollapsed = function (portlet, event) {
               if (event.keyCode && event.keyCode === KEY_CODE_SPACE) {
                  event.preventDefault();
               }
               portlet.collapsed = !portlet.collapsed;
               var portletNode = angular.element(event.currentTarget).closest('.' + PORTLET_CLASSNAME);
               portletNode.toggleClass('collapsed');
               persistPortletsState(scope.columns);
               if (portlet.collapsed) {
                  var portletContent = angular.element(
                        '[portlet-id="' + portlet._view.uid + '"] .vx-portlet-content');
                  if (portletContent) {
                     portletContent.remove();
                  }
               }
            };

            // Returns true if link has label
            scope.hasLabel = function (link) {
               return (link.label && link.label.trim().length > 0);
            };

            scope.clickAction = function (event, link) {
               if (angular.isDefined(link.onClick) &&
                  angular.isFunction(link.onClick)) {
                  link.onClick.call(undefined, event, link);
               } else {
                  $log.warn('No onClick action defined for link: ' + link.label);
               }
            };

            scope.getLimits = function (array) {
               return [
                  Math.floor(array.length / 2) + 1,
                  -Math.floor(array.length / 2)
               ];
            };

            scope.sortableOptions = {
               handle: '> .portlet-titlebar',
               cursor: 'move',
               placeholder: PORTLET_CLASSNAME + " placeholder",
               connectWith: ".col",
               start: function (e, ui) {
                  ui.item.css('transform', 'rotate(2deg)');
                  ui.item.css('transform', 'translateX(10px)');
                  ui.item.closest('.' + PORTLETS_CLASSNAME).addClass('ui-sorting');
               },
               stop: function (e, ui) {
                  ui.item.css('transform', 'rotate(0deg)');
                  ui.item.css('transform', 'translateX(0px)');

                  $timeout(function () {
                     ui.item.closest('.' + PORTLETS_CLASSNAME).removeClass('ui-sorting');
                     persistPortletsState(scope.columns);
                  }, 0);
               }
            };

            var getPortletsPersistanceKey = function () {
               return portletsPersistParams.entityType + '-' + portletsPersistParams.extensionId + '-portlets';
            };

            var persistPortletsState = function (cols) {
               var portletsToPersist = [];
               _.each(cols, function (column) {
                  var portletsInColumn = [];
                  portletsToPersist.push(portletsInColumn);
                  _.each(column, function (portlet) {
                     var id = portlet._view.uid;
                     var collapsed = portlet.collapsed;
                     portletsInColumn.push({
                        id: id,
                        collapsed: collapsed
                     });
                  });
               });

               persistenceService.setData(
                   getPortletsPersistanceKey(),
                   angular.toJson(portletsToPersist),
                   {},
                   PORTLETS_STATE_CATEGORY
               );
            };

            scope.$watchCollection(portletOptionsPropName + '.portlets', function () {

               scope.columns = [[], []];

               var portletOptions = scope.$eval(portletOptionsPropName);
               if (portletOptions && portletOptions.portlets &&
                     portletOptions.portlets.length > 0) {

                  var persistenceObj = {
                     "key": 'uid',
                     "op": '=',
                     "value": getPortletsPersistanceKey()
                  };

                  persistenceService.getData(persistenceObj).then(function (data) {
                     var portletUid;

                     var portletsById = {};
                     _.each(portletOptions.portlets, function (portlet, index) {
                        portletUid = portlet._view.uid;
                        if (portletsById[portletUid]) {
                           $log.debug("Duplicate portlet with ID " + portletUid + " found in the scope!");
                        }
                        // Populate default values for collapsed state and column.
                        portlet.collapsed = !portlet._view.activateViewByDefault;
                        portlet.columnIndex = index % 2;
                        portletsById[portletUid] = portlet;
                     });

                     var visiblePortletsById = {};
                     _.each(scope.columns, function (column) {
                        _.each(column, function (visiblePortlet) {
                           portletUid = visiblePortlet._view.uid;
                           if (visiblePortletsById[portletUid]) {
                              $log.warn("Duplicate portlet with ID " + portletUid + " found in the visible portlet columns!");
                           }
                           visiblePortletsById[portletUid] = true;
                        });
                     });

                     if (data[0] && data[0].value) {
                        var persistedLayoutData = angular.fromJson(data[0].value);
                        _.each(persistedLayoutData, function (persistedColumnData, columnIndex) {
                           _.each(persistedColumnData, function (persistedPortletData) {
                              var portlet = portletsById[persistedPortletData.id];
                              // If the persisted data is for a portlet not in
                              // the current scope, it can safely be skipped.
                              if (!portlet) {
                                 return;
                              }
                              // Populate persisted values for collapsed state and column.
                              if (persistedPortletData.collapsed !== undefined
                                    && persistedPortletData.collapsed !== null) {
                                 portlet.collapsed = persistedPortletData.collapsed;
                              }
                              portlet.columnIndex = columnIndex;
                           });
                        });
                     }

                     _.each(portletOptions.portlets, function (portlet) {
                        portletUid = portlet._view.uid;
                        if (!portletsById[portletUid] || visiblePortletsById[portletUid]) {
                           return;
                        }
                        portlet = portletsById[portletUid];
                        delete portletsById[portletUid];
                        scope.columns[portlet.columnIndex].push(portlet);
                        visiblePortletsById[portletUid] = true;

                        updatePortlet(portlet);
                     });
                  });
               }
            });

            /**
             * Updates the portlet properties and state.
             * A hook method that is invoked once for each portlet.
             *
             * @param portlet The portlet whose state will be updated.
             */
            function updatePortlet(portlet) {
               var portletSpanSizeRegExp = /^(\d+):(\d+)$/i;

               portlet.style = {height: "auto"};

               var size = ((portlet._view.contentSpec || {}).metadata || {}).size;
               if (typeof(size) !== 'string' ||
                     !portletSpanSizeRegExp.test(size)) {
                  return;
               }

               var portletSpanSizeGroups = size.match(portletSpanSizeRegExp);
               // Unused for now
               var spanWidth = parseInt(portletSpanSizeGroups[1], 10);
               var spanHeight = parseInt(portletSpanSizeGroups[2], 10);

               if (spanHeight < 1 || 2 < spanHeight) {
                  return;
               }

               // This default value is taken from the upcoming specification
               // for the Clarity card UI elements.
               var BASE_HEIGHT_IN_PIXELS = 156;

               var pixelHeight = BASE_HEIGHT_IN_PIXELS * spanHeight;
               portlet.style.height = pixelHeight + "px";
            }
         }
      };
   }
]);

/**
 * Copyright 2015 VMware, Inc. All rights reserved.
 *
 * The progress directive shows an indeterminate progress bar
 */
angular.module('com.vmware.platform.ui').directive('vxProgress', function () {
   return {
      restrict: 'E',
      templateUrl: 'resources/ui/components/progress/vxProgress.html',
      scope: {
         message: "@",
         loadingAriaLabel: "@?"
      },
      link: function (scope, element, attributes) {
         scope.message = attributes.message;
      }
   };
});
/* Copyright 2016 Vmware, Inc. All rights reserved. -- VMware Confidential */

/**
 * The static, non-transitioning progress directive shows a percentage-labeled progress bar
 * Shows an optional cancel button
 */
angular.module('com.vmware.platform.ui').directive('vxStaticProgressIndicator', function() {

   vxStaticProgressIndicatorController.$inject = ['i18nService'];

   function vxStaticProgressIndicatorController (i18nService) {
      var self = this;

      self.$onInit = function() {
         self.resources = {
            cancelTooltip: i18nService.getString('Common', 'cancel'),
            cancelEnableClass: "vui-icon-datagrid-cancel",
            cancelDisabledClass: "vui-icon-datagrid-cancel-disabled"
         };

         // derived CSS states
         self.resources.resolvedCancelClass = self.isCancelPending
            ? self.resources.cancelDisabledClass
            : self.resources.cancelEnableClass;

         if (!self.enableCancelButton) {
            self.resources.resolvedCancelClass = self.resources.cancelDisabledClass;
         }

         self.events = {
            onCancelClickEvent: function(event) {
               if (self.enableCancelButton) {
                  self.cancelCallback(event);
               }
            }
         };
      };
   }
   return {
      restrict: 'E',
      bindToController: true,
      controllerAs: "vx_spi_ctrl",
      templateUrl: 'resources/ui/components/progress/vxStaticProgressIndicator.html',
      scope: {
         progress: "=",
         enableCancelButton: "=",
         isCancelPending: "=",
         cancelCallback: "&"
      },
      controller: vxStaticProgressIndicatorController
   };

});


/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

angular.module('com.vmware.platform.ui')
      .directive('vxPropertyView', ['$rootScope', function ($rootScope) {
         'use strict';

         function getCategoryIndex(categories, id) {
            return _.findIndex(categories, function (category) {
               return category.id === id;
            });
         }

         function categoryExists(categories, id) {
            return getCategoryIndex(categories, id) >= 0;
         }

         return {
            templateUrl: "resources/ui/components/propertyview/propertyView.html",
            restrict: 'E',
            replace: true,
            scope: {
               data: '=',
               defaultCategoryId: '='
            },
            link: function ($scope) {

               $scope.selectedCategoryId = $scope.defaultCategoryId;
               $scope.selectCategory = function (categoryId) {
                  $scope.selectedCategoryId = categoryId;
               };
               $scope.getSelectedCategory = function () {
                  if (!$scope.data || !$scope.data.categories || !($scope.data.categories instanceof Array)) {
                     return null;
                  }

                  var selectedCategoryIndex = getCategoryIndex(
                        $scope.data.categories, $scope.selectedCategoryId
                  );

                  if (selectedCategoryIndex < 0) {
                     return null;
                  }

                  return $scope.data.categories[selectedCategoryIndex];
               };

               $scope.navigate = function(link) {
                  $rootScope._navigate(link.extensionId, link.objectId, link.navigator);
               };

               $scope.$watchCollection('data.categories', function (categories) {
                  if (!categories || !(categories instanceof Array) ||
                        categories.length === 0) {
                     return;
                  }

                  if (categoryExists(categories, $scope.selectedCategoryId)) {
                     return;
                  }

                  if (categoryExists(categories, $scope.defaultCategoryId)) {
                     $scope.selectedCategoryId = $scope.defaultCategoryId;
                     return;
                  }

                  $scope.selectedCategoryId = categories[0].id;
               });
            }
         };
      }]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var platform;
(function (platform) {
    (function (PropertyViewModelItemType) {
        PropertyViewModelItemType[PropertyViewModelItemType["Message"] = 'Message'] = "Message";
        PropertyViewModelItemType[PropertyViewModelItemType["PropertyValue"] = 'PropertyValue'] = "PropertyValue";
        PropertyViewModelItemType[PropertyViewModelItemType["PropertyKey"] = 'PropertyKey'] = "PropertyKey";
        PropertyViewModelItemType[PropertyViewModelItemType["Property"] = 'Property'] = "Property";
        PropertyViewModelItemType[PropertyViewModelItemType["Section"] = 'Section'] = "Section";
        PropertyViewModelItemType[PropertyViewModelItemType["Category"] = 'Category'] = "Category";
    })(platform.PropertyViewModelItemType || (platform.PropertyViewModelItemType = {}));
    var PropertyViewModelItemType = platform.PropertyViewModelItemType;
    var PropertyViewBaseBuilder = (function () {
        function PropertyViewBaseBuilder() {
            this.parent = null;
        }
        PropertyViewBaseBuilder.cloneBuilders = function (builders, parentBuilder) {
            return _.map(builders, function (builder) {
                var result = builder.clone();
                if (parentBuilder) {
                    parentBuilder.setAsParentTo(result);
                }
                return result;
            });
        };
        PropertyViewBaseBuilder.getBuildersResults = function (builders) {
            return _.map(builders, function (builder) {
                return builder.build();
            });
        };
        PropertyViewBaseBuilder.prototype.setAsParentTo = function (child) {
            child.parent = this;
            return this;
        };
        return PropertyViewBaseBuilder;
    }());
    platform.PropertyViewBaseBuilder = PropertyViewBaseBuilder;
    var PropertyViewMessageBuilder = (function (_super) {
        __extends(PropertyViewMessageBuilder, _super);
        function PropertyViewMessageBuilder() {
            _super.call(this);
            this._text = null;
            this._icon = null;
            this._renderAsHtml = false;
        }
        PropertyViewMessageBuilder.prototype.text = function (value) {
            this._text = value;
            return this;
        };
        PropertyViewMessageBuilder.prototype.icon = function (value) {
            this._icon = value;
            return this;
        };
        PropertyViewMessageBuilder.prototype.renderAsHtml = function (value) {
            this._renderAsHtml = value;
            return this;
        };
        ;
        PropertyViewMessageBuilder.prototype.build = function () {
            return {
                type: PropertyViewModelItemType.Message,
                text: this._text,
                icon: this._icon,
                renderAsHtml: this._renderAsHtml
            };
        };
        PropertyViewMessageBuilder.prototype.clone = function () {
            var result = new PropertyViewMessageBuilder();
            result._text = this._text;
            result._icon = this._icon;
            result._renderAsHtml = this._renderAsHtml;
            return result;
        };
        PropertyViewMessageBuilder.prototype.exit = function () {
            return this.parent;
        };
        return PropertyViewMessageBuilder;
    }(PropertyViewBaseBuilder));
    platform.PropertyViewMessageBuilder = PropertyViewMessageBuilder;
    var PropertyViewPropertyKeyBuilder = (function (_super) {
        __extends(PropertyViewPropertyKeyBuilder, _super);
        function PropertyViewPropertyKeyBuilder() {
            _super.call(this);
            this._text = null;
            this._icon = null;
        }
        PropertyViewPropertyKeyBuilder.prototype.text = function (value) {
            this._text = value;
            return this;
        };
        PropertyViewPropertyKeyBuilder.prototype.icon = function (value) {
            this._icon = value;
            return this;
        };
        PropertyViewPropertyKeyBuilder.prototype.build = function () {
            return {
                type: PropertyViewModelItemType.PropertyKey,
                text: this._text,
                icon: this._icon
            };
        };
        PropertyViewPropertyKeyBuilder.prototype.clone = function () {
            var result = new PropertyViewPropertyKeyBuilder();
            result._text = this._text;
            result._icon = this._icon;
            return result;
        };
        PropertyViewPropertyKeyBuilder.prototype.exit = function () {
            return this.parent;
        };
        return PropertyViewPropertyKeyBuilder;
    }(PropertyViewBaseBuilder));
    platform.PropertyViewPropertyKeyBuilder = PropertyViewPropertyKeyBuilder;
    var PropertyViewPropertyValueBuilder = (function (_super) {
        __extends(PropertyViewPropertyValueBuilder, _super);
        function PropertyViewPropertyValueBuilder() {
            _super.call(this);
            this._text = null;
            this._icon = null;
            this._link = null;
        }
        PropertyViewPropertyValueBuilder.prototype.text = function (value) {
            this._text = value;
            return this;
        };
        PropertyViewPropertyValueBuilder.prototype.icon = function (value) {
            this._icon = value;
            return this;
        };
        PropertyViewPropertyValueBuilder.prototype.link = function (value) {
            this._link = value;
            return this;
        };
        PropertyViewPropertyValueBuilder.prototype.build = function () {
            return {
                type: PropertyViewModelItemType.PropertyValue,
                text: this._text,
                icon: this._icon,
                link: this._link
            };
        };
        PropertyViewPropertyValueBuilder.prototype.clone = function () {
            var result = new PropertyViewPropertyValueBuilder();
            result._text = this._text;
            result._icon = this._icon;
            result._link = angular.copy(this._link);
            return result;
        };
        PropertyViewPropertyValueBuilder.prototype.exit = function () {
            return this.parent;
        };
        return PropertyViewPropertyValueBuilder;
    }(PropertyViewBaseBuilder));
    platform.PropertyViewPropertyValueBuilder = PropertyViewPropertyValueBuilder;
    var PropertyViewPropertyBuilder = (function (_super) {
        __extends(PropertyViewPropertyBuilder, _super);
        function PropertyViewPropertyBuilder() {
            _super.call(this);
            this._keyBuilder = new PropertyViewPropertyKeyBuilder();
            this.setAsParentTo(this._keyBuilder);
            this._valueBuilders = [];
        }
        PropertyViewPropertyBuilder.prototype.keyBuilder = function () {
            return this._keyBuilder;
        };
        PropertyViewPropertyBuilder.prototype.valueBuilder = function () {
            var result = new PropertyViewPropertyValueBuilder();
            this.setAsParentTo(result);
            this._valueBuilders.push(result);
            return result;
        };
        PropertyViewPropertyBuilder.prototype.build = function () {
            return {
                type: PropertyViewModelItemType.Property,
                key: this.keyBuilder().build(),
                content: PropertyViewBaseBuilder.getBuildersResults(this._valueBuilders)
            };
        };
        PropertyViewPropertyBuilder.prototype.clone = function () {
            var result = new PropertyViewPropertyBuilder();
            result._keyBuilder = this._keyBuilder.clone();
            result.setAsParentTo(result._keyBuilder);
            result._valueBuilders =
                PropertyViewBaseBuilder.cloneBuilders(this._valueBuilders, result);
            return result;
        };
        PropertyViewPropertyBuilder.prototype.exit = function () {
            return this.parent;
        };
        return PropertyViewPropertyBuilder;
    }(PropertyViewBaseBuilder));
    platform.PropertyViewPropertyBuilder = PropertyViewPropertyBuilder;
    var PropertyViewSectionBuilder = (function (_super) {
        __extends(PropertyViewSectionBuilder, _super);
        function PropertyViewSectionBuilder(id) {
            if (typeof id !== 'string') {
                throw new Error('id must be a string');
            }
            _super.call(this);
            this._id = id;
            this._title = null;
            this._titleIcon = null;
            this._contentBuilders = [];
            this._actions = [];
            this._renderAsHtml = false;
            this._compileAsHtml = false;
        }
        PropertyViewSectionBuilder.prototype.getId = function () {
            return this._id;
        };
        PropertyViewSectionBuilder.prototype.renderAsHtml = function (value) {
            this._renderAsHtml = value;
            return this;
        };
        ;
        PropertyViewSectionBuilder.prototype.compileAsHtml = function (value) {
            this._compileAsHtml = value;
            return this;
        };
        ;
        PropertyViewSectionBuilder.prototype.title = function (value) {
            this._title = value;
            return this;
        };
        PropertyViewSectionBuilder.prototype.titleIcon = function (value) {
            this._titleIcon = value;
            return this;
        };
        PropertyViewSectionBuilder.prototype.action = function (value) {
            if (value) {
                this._actions.push(value);
            }
            return this;
        };
        ;
        PropertyViewSectionBuilder.prototype.property = function (key, values) {
            var valuesAsArray;
            if (values instanceof Array) {
                valuesAsArray = values;
            }
            else if (values === null || values === undefined) {
                valuesAsArray = [];
            }
            else {
                valuesAsArray = [values];
            }
            var propertyBuilder = this.propertyBuilder();
            propertyBuilder.keyBuilder().text(key);
            _.each(valuesAsArray, function (value) {
                propertyBuilder.valueBuilder().text(value);
            });
            return this;
        };
        PropertyViewSectionBuilder.prototype.message = function (text, icon) {
            var messageBuilder = this.messageBuilder();
            messageBuilder.text(text);
            if (typeof icon === 'string') {
                messageBuilder.icon(icon);
            }
            return this;
        };
        PropertyViewSectionBuilder.prototype.info = function (text) {
            return this.message(text, PropertyViewSectionBuilder.INFO_ICON_CLASS);
        };
        PropertyViewSectionBuilder.prototype.warning = function (text) {
            return this.message(text, PropertyViewSectionBuilder.WARNING_ICON_CLASS);
        };
        PropertyViewSectionBuilder.prototype.error = function (text) {
            return this.message(text, PropertyViewSectionBuilder.ERROR_ICON_CLASS);
        };
        PropertyViewSectionBuilder.prototype.propertyBuilder = function () {
            var result = new PropertyViewPropertyBuilder();
            this.setAsParentTo(result);
            this._contentBuilders.push(result);
            return result;
        };
        PropertyViewSectionBuilder.prototype.messageBuilder = function () {
            var result = new PropertyViewMessageBuilder();
            this.setAsParentTo(result);
            this._contentBuilders.push(result);
            return result;
        };
        PropertyViewSectionBuilder.prototype.build = function () {
            return {
                type: PropertyViewModelItemType.Section,
                id: this._id,
                renderAsHtml: this._renderAsHtml,
                compileAsHtml: this._compileAsHtml,
                title: this._title,
                titleIcon: this._titleIcon,
                actions: this._actions,
                content: PropertyViewBaseBuilder.getBuildersResults(this._contentBuilders)
            };
        };
        PropertyViewSectionBuilder.prototype.clone = function () {
            var result = new PropertyViewSectionBuilder(this._id);
            result._renderAsHtml = this._renderAsHtml;
            result._compileAsHtml = this._compileAsHtml;
            result._title = this._title;
            result._titleIcon = this._titleIcon;
            result._actions = this._actions.concat();
            result._contentBuilders =
                PropertyViewBaseBuilder.cloneBuilders(this._contentBuilders, result);
            return result;
        };
        ;
        PropertyViewSectionBuilder.prototype.exit = function () {
            return this.parent;
        };
        PropertyViewSectionBuilder.INFO_ICON_CLASS = 'vx-icon-info_normal';
        PropertyViewSectionBuilder.WARNING_ICON_CLASS = 'vx-icon-warn';
        PropertyViewSectionBuilder.ERROR_ICON_CLASS = 'vx-icon-error';
        return PropertyViewSectionBuilder;
    }(PropertyViewBaseBuilder));
    platform.PropertyViewSectionBuilder = PropertyViewSectionBuilder;
    var PropertyViewCategoryBuilder = (function (_super) {
        __extends(PropertyViewCategoryBuilder, _super);
        function PropertyViewCategoryBuilder(id) {
            if (typeof id !== 'string') {
                throw new Error('id must be a string');
            }
            _super.call(this);
            this._id = id;
            this._title = null;
            this._contentBuilders = [];
        }
        PropertyViewCategoryBuilder.prototype.getId = function () {
            return this._id;
        };
        PropertyViewCategoryBuilder.prototype.title = function (value) {
            this._title = value;
            return this;
        };
        PropertyViewCategoryBuilder.prototype.section = function (id) {
            var sectionBuilder = this.getSection(id);
            if (sectionBuilder === null) {
                sectionBuilder = new PropertyViewSectionBuilder(id);
                this.setAsParentTo(sectionBuilder);
                this._contentBuilders.push(sectionBuilder);
            }
            return sectionBuilder;
        };
        ;
        PropertyViewCategoryBuilder.prototype.getSection = function (id) {
            var matchingBuilders = _.filter(this.getAllSections(), function (s) { return s.getId() === id; });
            if (matchingBuilders.length === 1) {
                return matchingBuilders[0];
            }
            return null;
        };
        ;
        PropertyViewCategoryBuilder.prototype.getAllSections = function () {
            return _.filter(this._contentBuilders, function (b) { return b instanceof PropertyViewSectionBuilder; });
        };
        PropertyViewCategoryBuilder.prototype.cloneAndAddBuilder = function (builder) {
            if (!builder) {
                return this;
            }
            if (!(builder instanceof PropertyViewSectionBuilder)) {
                throw new Error('expected a PropertyViewSectionBuilder instance');
            }
            if (this.getSection(builder.getId()) !== null) {
                throw new Error('a PropertyViewSectionBuilder with the same id already exists');
            }
            builder = builder.clone();
            this.setAsParentTo(builder);
            this._contentBuilders.push(builder);
            return this;
        };
        ;
        PropertyViewCategoryBuilder.prototype.cloneAndAddBuilders = function (builders) {
            var _this = this;
            _.each(builders, function (b) { return _this.cloneAndAddBuilder(b); });
            return this;
        };
        PropertyViewCategoryBuilder.prototype.build = function () {
            return {
                type: PropertyViewModelItemType.Category,
                id: this._id,
                title: this._title,
                content: PropertyViewBaseBuilder.getBuildersResults(this._contentBuilders)
            };
        };
        ;
        PropertyViewCategoryBuilder.prototype.clone = function () {
            var result = new PropertyViewCategoryBuilder(this._id);
            result._title = this._title;
            result._contentBuilders =
                PropertyViewBaseBuilder.cloneBuilders(this._contentBuilders, result);
            return result;
        };
        ;
        PropertyViewCategoryBuilder.prototype.exit = function () {
            return this.parent;
        };
        return PropertyViewCategoryBuilder;
    }(PropertyViewBaseBuilder));
    platform.PropertyViewCategoryBuilder = PropertyViewCategoryBuilder;
    var PropertyViewBuilder = (function (_super) {
        __extends(PropertyViewBuilder, _super);
        function PropertyViewBuilder(_i18nService) {
            _super.call(this);
            this._i18nService = _i18nService;
            if (typeof _i18nService !== 'object' ||
                typeof _i18nService.getString !== 'function') {
                throw new Error('expecting i18nService to be an object with a getString() method');
            }
            this._categoryBuilders = [];
        }
        PropertyViewBuilder.prototype.category = function (id, insertionIndex) {
            var categoryBuilder = this.getCategory(id);
            if (categoryBuilder === null) {
                categoryBuilder = new PropertyViewCategoryBuilder(id);
                this.setAsParentTo(categoryBuilder);
                this._categoryBuilders.push(categoryBuilder);
            }
            var removalIndex = _.findIndex(this._categoryBuilders, function (b) { return b.getId() === id; });
            this._categoryBuilders.splice(removalIndex, 1);
            if (insertionIndex === undefined) {
                insertionIndex = removalIndex;
            }
            else if (typeof insertionIndex !== 'number' ||
                isNaN(insertionIndex) || !isFinite(insertionIndex) ||
                insertionIndex !== parseInt(insertionIndex.toString(), 10) ||
                insertionIndex < 0 ||
                this._categoryBuilders.length < insertionIndex) {
                throw new Error('invalid insertionIndex');
            }
            this._categoryBuilders.splice(insertionIndex, 0, categoryBuilder);
            return categoryBuilder;
        };
        PropertyViewBuilder.prototype.getCategory = function (id) {
            var matchingBuilder = _.filter(this.getAllCategories(), function (s) { return s.getId() === id; });
            if (matchingBuilder.length === 1) {
                return matchingBuilder[0];
            }
            return null;
        };
        PropertyViewBuilder.prototype.getAllCategories = function () {
            return _.filter(this._categoryBuilders, function (b) { return b instanceof PropertyViewCategoryBuilder; });
        };
        PropertyViewBuilder.prototype.getSection = function (categoryId, sectionId) {
            var category = this.getCategory(categoryId);
            if (category === null) {
                return null;
            }
            return category.getSection(sectionId);
        };
        PropertyViewBuilder.prototype.generateAllCategory = function (categoryTitle) {
            if (this.getCategory('all')) {
                throw new Error('"All" category already added');
            }
            categoryTitle = categoryTitle ||
                this._i18nService.getString('Common', 'vxPropertyView.allCategory');
            return this.category('all', 0)
                .title(categoryTitle)
                .cloneAndAddBuilders(_.flatten(_.map(this.getAllCategories(), function (c) { return c.getAllSections(); })));
        };
        ;
        PropertyViewBuilder.prototype.build = function () {
            return {
                categories: PropertyViewBaseBuilder.getBuildersResults(this._categoryBuilders)
            };
        };
        ;
        PropertyViewBuilder.prototype.clone = function () {
            var result = new PropertyViewBuilder(this._i18nService);
            result._categoryBuilders =
                PropertyViewBaseBuilder.cloneBuilders(this._categoryBuilders, result);
            return result;
        };
        ;
        PropertyViewBuilder.prototype.exit = function () {
            return null;
        };
        return PropertyViewBuilder;
    }(PropertyViewBaseBuilder));
    platform.PropertyViewBuilder = PropertyViewBuilder;
    angular.module('com.vmware.platform.ui')
        .constant('vxPropertyViewConstants', {
        PropertyViewModelItemType: PropertyViewModelItemType
    });
    angular.module('com.vmware.platform.ui')
        .factory('vxPropertyViewBaseBuilder', function () { return PropertyViewBaseBuilder; });
    angular.module('com.vmware.platform.ui')
        .factory('vxPropertyViewMessageBuilder', function () { return PropertyViewMessageBuilder; });
    angular.module('com.vmware.platform.ui')
        .factory('vxPropertyViewPropertyKeyBuilder', function () { return PropertyViewPropertyKeyBuilder; });
    angular.module('com.vmware.platform.ui')
        .factory('vxPropertyViewPropertyValueBuilder', function () { return PropertyViewPropertyValueBuilder; });
    angular.module('com.vmware.platform.ui')
        .factory('vxPropertyViewPropertyBuilder', function () { return PropertyViewPropertyBuilder; });
    angular.module('com.vmware.platform.ui')
        .factory('vxPropertyViewSectionBuilder', function () { return PropertyViewSectionBuilder; });
    angular.module('com.vmware.platform.ui')
        .factory('vxPropertyViewCategoryBuilder', function () { return PropertyViewCategoryBuilder; });
    angular.module('com.vmware.platform.ui')
        .factory('vxPropertyViewBuilder', function () { return PropertyViewBuilder; });
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var PropertyViewService = (function () {
        function PropertyViewService(_i18nService) {
            this._i18nService = _i18nService;
        }
        PropertyViewService.prototype.createPropertyViewBuilder = function () {
            return new platform.PropertyViewBuilder(this._i18nService);
        };
        PropertyViewService.$inject = ['i18nService'];
        return PropertyViewService;
    }());
    platform.PropertyViewService = PropertyViewService;
    angular.module('com.vmware.platform.ui')
        .service('vxPropertyViewService', PropertyViewService);
})(platform || (platform = {}));



/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Directive that adds refresh functionality (both manual and auto-refresh) to the view.
 * This directive takes a isolated scope which should contain something like:
 *    {  Array of objectIds (watchObjects): ObjectIds of the objects whose properties change trigger the refresh of the view.
 *       refresh() - callback to get refresh the view.
 *       delayRefreshOnObjectUpdatesBy: Optional Time in MSecs to refresh data after a object change is detected. Use this only when you find inconsistencies
 *       where backend VC server does not change the object properties before returning.
 *    }
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxRefreshable', refreshableCtrl);

   function refreshableCtrl() {
      var directive = {
            restrict: 'A',
             scope: {
                objectIds: '@watchObjects', // Array of object Ids to watch for changes.
                refreshCallback: '&refresh',
                refreshEventTypes: '@refreshEventTypes',
                delayRefreshOnObjectUpdatesBy: '@delayRefreshOnObjectUpdatesBy',
                liveRefreshEnabled: '@',
                liveRefreshProperties: '=?',
                hasObjectStateProperty: '@'
             },
             controller: RefreshController
      };
      return directive;
   }

   RefreshController.$inject = ['$scope', '$element', '$timeout',
      'visibilityAwareDataUpdateNotificationService', 'defaultUriSchemeUtil', 'vcH5ConstantsService'];
   function RefreshController($scope, $element, $timeout,
         visibilityAwareDataUpdateNotificationService, defaultUriSchemeUtil, vcH5ConstantsService) {
      var OBJECT_DETAILS_CHANGED_EVENT = 'object-details';
      var liveRefreshEnabled = $scope.liveRefreshEnabled ?
            $scope.liveRefreshEnabled === 'true' : true;
      var relevantProperties = {};
      if (liveRefreshEnabled) {
         _.each($scope.liveRefreshProperties, function (prop) {
            relevantProperties[prop] = true;
         });
      }
      var debouncedRefreshCallback = _.debounce(function() {
         $scope.refreshCallback();
      }, vcH5ConstantsService.CHANGELOG_REFRESH_DELAY);
      var timeoutPromise = null;

      var dataUpdateEventsConfig = {};

      var refreshInvocationEventEnabled = !$scope.refreshEventTypes ||
            ($scope.refreshEventTypes.indexOf(vcH5ConstantsService.DATA_REFRESH_INVOCATION_EVENT) !== -1);
      var modelChangedEventEnabled = !$scope.refreshEventTypes ||
            ($scope.refreshEventTypes.indexOf(vcH5ConstantsService.MODEL_CHANGED_EVENT) !== -1);
      var objectDetailsChangedEventEnabled = !$scope.refreshEventTypes ||
            ($scope.refreshEventTypes.indexOf(OBJECT_DETAILS_CHANGED_EVENT) !== -1);

      if (refreshInvocationEventEnabled) {
         dataUpdateEventsConfig[vcH5ConstantsService.DATA_REFRESH_INVOCATION_EVENT] = {
            handler: $scope.refreshCallback
         };
      }

      if (modelChangedEventEnabled) {
         dataUpdateEventsConfig[vcH5ConstantsService.MODEL_CHANGED_EVENT] = {
            handler: onModelChanged,
            checker: isModelChangeRelevant
         };
      }

      if (objectDetailsChangedEventEnabled) {
         dataUpdateEventsConfig[OBJECT_DETAILS_CHANGED_EVENT] = {
            handler: onObjectDetailsChanged,
            checker: isObjectDetailsChangeRelevant
         };
      }

      var dataUpdateNotificationSubscriberId =
         visibilityAwareDataUpdateNotificationService.subscribeForDataUpdate(
            $element,
            $scope.refreshCallback,
            dataUpdateEventsConfig
         );

      function isObjectDetailsChangeRelevant(event, partialUpdate) {
         if (!$scope.objectIds || !liveRefreshEnabled) {
            return false;
         }

         if (!$scope.hasObjectStateProperty && _.isEmpty(relevantProperties)) {
            return false;
         }

         return partialUpdate.updates.some(isUpdateRelevant);
      }

      function isUpdateRelevant(update) {
         var mor = update.data;
         var objectId = defaultUriSchemeUtil.createVmomiUri(
               mor.type, mor.value, mor.serverGuid
         );

         if ($scope.hasObjectStateProperty && $scope.hasObjectStateProperty === 'true') {
            return $scope.objectIds.indexOf(objectId) >= 0
                  && update.metadata
                  && update.metadata['hasObjectStateProperty'];
         }

         return $scope.objectIds.indexOf(objectId) >= 0 &&
               update.deltaProperties.some(function (prop) {
                  return _.has(relevantProperties, prop);
               });
      }

      function onObjectDetailsChanged(event, partialUpdate) {
         debouncedRefreshCallback();
      }

      function isModelChangeRelevant(event, objectChangeInfo) {
         var objectIdsToWatchFor = $scope.objectIds;

         var changedId = null;
         if (objectChangeInfo.operationType === 'CHANGE') {
            changedId = objectChangeInfo.objectId;
         }

         return objectIdsToWatchFor &&
               objectIdsToWatchFor.indexOf(changedId) >= 0;
      }

      function onModelChanged(event, objectChangeInfo) {
         // Use debounced refresh if model change and live refresh updates are
         // both enabled to avoid multiple view refreshes. A debounce will not
         // ensure that in general, but should improve the chances and is easy
         // to implement.
         var refreshCallback = objectDetailsChangedEventEnabled
               ? debouncedRefreshCallback
               : $scope.refreshCallback;
         // TODO smarathe: WORKAROUND for VC bug - for cases like
         // https://bugzilla.eng.vmware.com/show_bug.cgi?id=1508760
         // In some cases, the edit action takes place on the server and
         // returns without a task (VC server bug). In this case, if there
         // is no timeout set, the view refreshes before VC server has actually
         // completed the task. For those rare mutations, let the view know
         // that it has to refresh after a timeout.
         if ($scope.delayRefreshOnObjectUpdatesBy > 0) {
            timeoutPromise = $timeout(refreshCallback, $scope.delayRefreshOnObjectUpdatesBy);
         } else {
            refreshCallback();
         }
      }

      // Cancel and nullify the promise when the scope is destroyed (meaning if the view is destroyed).
      $scope.$on('$destroy', function() {
         if (timeoutPromise) {
            $timeout.cancel(timeoutPromise);
            timeoutPromise = null;
         }

         if (dataUpdateNotificationSubscriberId !== null) {
            visibilityAwareDataUpdateNotificationService.unsubscribe(
               dataUpdateNotificationSubscriberId
            );
            dataUpdateNotificationSubscriberId = null;
         }
      });
}
})();

/*
 *  Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential
 */
/*
 * Resizes the contained kendo widgets when the expression value changes
 */
angular.module('com.vmware.platform.ui').directive('vxKendoResize', ['vxZoneService',
function (vxZoneService) {
   'use strict';
   return {
      restrict: 'A',
      scope: false,
      link: function($scope, $element, $attr) {
         function resize() {
            kendo.resize($element, true);
         }

         var resizeTimeoutId = null;

         // $watchCollection to support observing multiple objects
         $scope.$watchCollection($attr.vxKendoResize, function () {
            // use timeout to ensure that any ng-ifs ng-shows have added/removed nodes
            // from the DOM
            if (resizeTimeoutId !== null) {
               return;
            }

            vxZoneService.runOutsideAngular(function () {
               resizeTimeoutId = setTimeout(function () {
                  resizeTimeoutId = null;
                  resize();
               }, 1);
            });
         });

         $scope.$on('$destroy', function () {
            if (resizeTimeoutId !== null) {
               vxZoneService.runOutsideAngular(function () {
                  clearTimeout(resizeTimeoutId);
                  resizeTimeoutId = null;
               });
            }
         });
      }
   };
}]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * A type of container that supports the navigation system.
 *
 * 2 Usages:
 * 1. Navigational view: <vx-view>
 * 2. Non-navigational view: <vx-view="extension">
 *    This form is still preliminary.
 *        Might split into <extension-container="randomExtension"> vs <vx-view="onlyImmidiateChildExtensionAllowed">
 *
 * Originally inspired by ui-view
 */
angular.module('com.vmware.platform.ui').directive(
'vxView',
['navigation', 'extensionFrameworkConstants', '$compile', function(
      navigation, extensionFrameworkConstants, $compile) {
   var SANDBOX_TEMPLATE_URL = 'resources/ui/views/plugins/sandboxTemplate.html';
   var EXTENSION_VIEW_WRAPPER_TEMPLATE =
      '<div class="fill-parent">' +
      '  <div class="fill-parent">' +
      '     <div class="fill-parent" ng-include="_vxViewNodeData.url"' +
      '           vx-extension-view-id="{{_vxViewNodeData.node.$id}}"></div>' +
      '  </div>' +
      '</div>';

   var active = false;
   var directive = {
      restrict : 'ECA',
      scope: true, // ideally I want isolated scope for this template, but not sure if possible to pass the parent scope into vx-container
      link: function($scope, $element, attr) {
         var cache = {};
         // top <vx-view> has a depth of 0, the next one 1, etc
         // this depth is used to get the selected node at the
         // corresponding level in the navigation tree
         var parentVxViewNodeData = $scope.$parent._vxViewNodeData;
         var parentNode = parentVxViewNodeData ?
            parentVxViewNodeData.node : null;
         var parentNodeDepth = parentVxViewNodeData ?
            parentVxViewNodeData.depth : null;
         var info = {
            depth: (typeof parentNodeDepth === 'number') ? parentNodeDepth + 1 : 0,
            parentNode: parentNode || null
         };

         //Remove all cached vxView elements from the cache
         //including the detach one, so that they
         //to be destroyed correctly.
         $scope.$on("$destroy", function () {
            Object.keys(cache).forEach(function (nodeId) {
               var entry = cache[nodeId];
               entry.element.remove();
            });
         });

         $scope.$on('vxRouteChangeSuccess', function(evt, tree, route, previousRoute){
            update();
         });

         $scope.$on("viewDidUnload", function() {
            if (active) {
               active = false;
               info.scope.$broadcast("viewDidUnload", info.node.$id);
            }
         });

         if (!!attr.vxView) {
            $scope.$watch(attr.vxView, function(cur, prev) {
               if (cur === prev || angular.equals(cur, prev)) {
                  return; //init case
               }
               update();
            });
         }

         update();

         function update(){
            // handle <vx-view="node"> case, mainly for non-navigational view such as portlets
            var specificNodeMode = !!attr.vxView;

            var node = null;
            if (specificNodeMode) {
               node = $scope.$eval(attr.vxView);
            } else {
               var tree = navigation.getTree();
               if (!tree) {
                  return;
               }

               var newSelectedNodeParentsIds = [];
               node = tree.getNodeAtLevel(info.depth);
               // Node might be null be it will still have a parent, meaning
               // that we should read the node at the previous level to handle
               // correctly the case where we go from non-null node to null node
               if (info.depth > 0) {
                  var newSelectedNodeParent = tree.getNodeAtLevel(info.depth - 1);
                  while (newSelectedNodeParent) {
                     newSelectedNodeParentsIds.push(newSelectedNodeParent.$id);
                     newSelectedNodeParent = newSelectedNodeParent.$parent;
                  }
               }

               var parentNodesIds = [];
               var parentNode = info.parentNode;
               while (parentNode) {
                  parentNodesIds.push(parentNode.$id);
                  parentNode = parentNode.$parent;
               }

               // We need to compare the parent nodes of our vx-view to
               // the ones of the newly selected node. This is needed so that we don't
               // render unrelated nodes in this vx-view. If we don't do this check then
               // for example if we have 2 vx-views that render nodes on level 3, then
               // when the selected nodes change, both of these vx-views would render
               // the newly selected level 3 node which would cause duplication of the
               // extension views (i.e. we would render the extension view 2 times in
               // 2 different vx-views, only one of the vx-views would be visible though)
               if (JSON.stringify(newSelectedNodeParentsIds) !== JSON.stringify(parentNodesIds)) {
                  return;
               }
            }

            var route = navigation.getRoute();
            var previousRoute = navigation.getPreviousRoute();
            // if the new node is the same as the old node, determine if we should do nothing
            if (node && info.node
                  && (info.node.$id === node.$id)
                  && (specificNodeMode || !navigation.shouldReload(node,
                        info.node, route, previousRoute))) {
               // need to do this as the node could actually be a new js object fetched via ajax
               // (even though by content it is the same)
               // so data-binding will reflect the new object
               if (node !== info.node) {
                  angular.extend(info.node, node);
               }

               if (!active) {
                  active = true;
                  info.scope.$broadcast("viewDidLoad", info.node.$id);
               } else {
                  info.scope.$broadcast("viewDidUpdate", info.node.$id);
               }

               return; // same node, do nothing (probably one of the child changed)
            }

            updateView(node);
         }

         function updateView(node) {
            // deal with the previous DOM, either destroy it or hide it depending on the persist setting
            if (info.node) {
               var retainPrevious = isNodeViewRetained(info.node);
               var previousId = info.node.$id;

               if (!retainPrevious) {
                  removeCacheEntry(previousId);
               } else {
                  addRemoveCacheEntryElementFromDomTree(previousId, false);
               }

               info.node = null;
               info.scope = null;
            }

            if (node) {
               var id = node.$id;

               if (cache[id] && isNodeViewRetained(node)) {
                  angular.extend(cache[id].node, node);
               } else {
                  createCacheEntry(node);
               }

               addRemoveCacheEntryElementFromDomTree(id, true);

               info.node = node;
               info.scope = cache[id].scope;
            }
         }

         function createCacheEntry(node) {
            var extensionViewUrl =  (node.contentSpec && node.contentSpec.sandbox) ?
               SANDBOX_TEMPLATE_URL : node.$templateUrl;

            var extensionViewWrapperScope = $scope.$new(false);
            extensionViewWrapperScope._view = node;
            extensionViewWrapperScope._vxViewNodeData = {
               url: extensionViewUrl,
               depth: info.depth,
               node: node
            };

            var extensionViewWrapper =
                  $compile(EXTENSION_VIEW_WRAPPER_TEMPLATE)(extensionViewWrapperScope);

            cache[node.$id] = {
               node: node,
               scope: extensionViewWrapperScope,
               element: extensionViewWrapper
            };
         }

         function removeCacheEntry(nodeId) {
            var entry = cache[nodeId];

            entry.scope.$destroy();
            entry.element.remove();

            delete cache[nodeId];
         }

         function addRemoveCacheEntryElementFromDomTree(entryId, add) {
            var entry = cache[entryId];
            var element = entry.element;

            if (add) {
               entry.scope.$broadcast('viewDidLoad', entryId);
               element.appendTo($element);
               kendo.resize(element);
            } else {
               entry.scope.$broadcast('viewDidUnload', entryId);
               element.detach();
            }
         }

         function isNodeViewRetained(node) {
            var policy = node.$viewRetentionPolicy ||
                  extensionFrameworkConstants.ViewRetentionPolicy.INHERIT;

            switch (policy) {
               case extensionFrameworkConstants.ViewRetentionPolicy.NONE:
               case extensionFrameworkConstants.ViewRetentionPolicy.DESCENDANTS_ONLY:
                  return false;

               case extensionFrameworkConstants.ViewRetentionPolicy.SELF_ONLY:
               case extensionFrameworkConstants.ViewRetentionPolicy.SELF_AND_DESCENDANTS:
                  return true;

               case extensionFrameworkConstants.ViewRetentionPolicy.INHERIT:
                  while (node.$parent) {
                     var parentPolicy = node.$parent.$viewRetentionPolicy ||
                           extensionFrameworkConstants.ViewRetentionPolicy.INHERIT;

                     switch (parentPolicy) {
                        case extensionFrameworkConstants.ViewRetentionPolicy.NONE:
                        case extensionFrameworkConstants.ViewRetentionPolicy.SELF_ONLY:
                           return false;

                        case extensionFrameworkConstants.ViewRetentionPolicy.DESCENDANTS_ONLY:
                        case extensionFrameworkConstants.ViewRetentionPolicy.SELF_AND_DESCENDANTS:
                           return true;

                        case extensionFrameworkConstants.ViewRetentionPolicy.INHERIT:
                           node = node.$parent;
                           break;

                        default:
                           return false;
                     }
                  }
            }

            return false;
         }
      }
   };
   return directive;
}]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

(function() {
   'use strict';

   angular.module('com.vmware.platform.ui').directive('vxFocusAndSelect', vxFocusAndSelect);

   function vxFocusAndSelect() {
      return {
         require: 'ngModel',
         link: function(scope, element, attrs, ngModel) {
            ngModel.$render = function() {
               element.val(ngModel.$viewValue);
               element[0].select();
            };
         }
      };
   }
})();
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * GenericSettingsViewController
 */
(function () {
   'use strict';
   angular.module('com.vmware.platform.ui').controller(
         'GenericSettingsViewController', GenericSettingsViewController);

   GenericSettingsViewController.$inject = ['$scope', 'dataService'];

   function GenericSettingsViewController($scope, dataService) {
      var self = this;
      var objectId = $scope._route.objectId;

      self.refresh = refresh;
      self.title = $scope._view.name;
      self.watchForObjects = [objectId];

      self.settingsViewHeaderAccessor = {};

      self.actions = [];
      // extract action ids and custom labels from the ViewSpec metadata (view plugin.xml)
      var actionIndex = 1;
      while ($scope._view.contentSpec.metadata[getActionIdKey(actionIndex)]) {
         self.actions.push({
            actionUid: $scope._view.contentSpec.metadata[
                  getActionIdKey(actionIndex)],
            customLabel: $scope._view.contentSpec.metadata[
                  getActionCustomLabelKey(actionIndex)]
         });

         actionIndex++;
      }

      self.delayRefreshOnObjectUpdatesBy = 0;
      if ($scope._view.contentSpec && $scope._view.contentSpec.metadata) {
         var metadata = $scope._view.contentSpec.metadata;
         self.cssClass = metadata.cssClass || '';
         if (metadata.liveRefreshProperties) {
            self.liveRefreshProperties = _.map(
               metadata.liveRefreshProperties.split(","),
               function (prop) {
                  return prop.trim();
               });
         }
         if (metadata.delayRefreshOnObjectUpdatesBy &&
               !isNaN(Number(metadata.delayRefreshOnObjectUpdatesBy))) {
            self.delayRefreshOnObjectUpdatesBy = Number(metadata.delayRefreshOnObjectUpdatesBy);
         }
      }

      function getProperties() {
         if ($scope._view && $scope._view.contentSpec &&
               $scope._view.contentSpec.metadata &&
               $scope._view.contentSpec.metadata.propertyToRetrieve) {

            var propertyToRetrieve =
                  $scope._view.contentSpec.metadata.propertyToRetrieve;

            dataService.getProperties(objectId, [propertyToRetrieve]).then(
                  function (response) {
                     if (response) {
                        var newPropertyItems = response[propertyToRetrieve] || [];

                        // Try to apply expanded states to the newPropertyItems.
                        if (self.propertyItems && self.propertyItems.length > 0) {
                           // Map containing all expanded items.
                           var expandedPropertyItems = {};
                           _.forEach(self.propertyItems, function(item) {
                              if (item && item.expanded) {
                                 expandedPropertyItems[item.label] = true;
                              }
                           });

                           _.forEach(newPropertyItems, function(item) {
                              if (expandedPropertyItems[item.label] === true) {
                                 item.expanded = true;
                              }
                           });
                        }

                        self.propertyItems = newPropertyItems;
                     } else {
                        self.propertyItems = [];
                     }
                  });
         }
      }

      function refresh() {
         getProperties();

         if (self.settingsViewHeaderAccessor && self.settingsViewHeaderAccessor.refresh) {
            self.settingsViewHeaderAccessor.refresh();
         }
      }

      getProperties();
   }

   function getActionIdKey(actionIndex) {
      return 'action' + actionIndex + 'Id';
   }

   function getActionCustomLabelKey(actionIndex) {
      return 'action' + actionIndex + 'CustomLabel';
   }

})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function () {
   'use strict';
   angular.module('com.vmware.platform.ui').component('settingsViewHeader', {
      templateUrl: 'resources/ui/components/settingsView/settingsViewHeader.html',
      controller: SettingsViewHeader,
      controllerAs: 'ctrl',
      bindings: {
         // Mandatory
         headerTitle: '<',
         // Optional
         actions: '<',
         objectIds: '<',
         accessor: '<' // accessor pattern to make it easy to call the directive
         // functions from hosting components. Used to call the
         // directive's 'evaluateActionAvailability' function when needed
         // (on global refresh for instance
      }
   });

   SettingsViewHeader.$inject = [
      'actionsService'
   ];

   function SettingsViewHeader(actionsService) {
      var ctrl = this;
      ctrl.actionsToRender = [];

      var actionUids = [];
      var customLabelMap = {};

      ctrl.$onInit = function () {
         if (ctrl.actions && ctrl.actions.length) {
            _.each(ctrl.actions, function (action) {
               actionUids.push(action.actionUid);
               customLabelMap[action.actionUid] = action.customLabel;
            });
         }

         if (ctrl.accessor) {
            ctrl.accessor.refresh = function () {
               evaluateActionAvailability();
            };
         }

         evaluateActionAvailability();
      };

      ctrl.invokeAction = function ($event, action) {
         // The settings view header has to provide as context of the action
         // object not array which brakes the contract of invokeAction method.
         // As I manage to verify the objectIds are not used and the change the
         // settings view header to provide object as context probably will
         // not affect other components
         var context = {
           objectIds: ctrl.objectIds,
           focusTarget: $event.target
         };
         actionsService.invokeAction(action.eval, context);
      };

      function evaluateActionAvailability() {
         if (!actionUids || actionUids.length === 0) {
            return;
         }

         // Request action evaluations from the backend
         actionsService.getActions(ctrl.objectIds, actionUids)
            .then(function (actionEvalutaions) {
               var actionToRenderMap = {};

               // Build actions to render items
               _.each(actionEvalutaions, function (actionEvaluation) {

                  var actionUid = actionEvaluation.action.uid;
                  var customLabel = customLabelMap[actionUid];

                  actionToRenderMap[actionUid] = {
                     label: customLabel || actionEvaluation.action.label,
                     actionId: actionEvaluation.action.uid,
                     isEnabled: actionEvaluation.available,
                     eval: actionEvaluation
                  };
               });

               // Add actions in the same order as specified in the
               // directive.actions property.
               var actionsToRender = [];
               _.each(actionUids, function (actionUid) {
                  if (actionToRenderMap[actionUid]) {
                     actionsToRender.push(actionToRenderMap[actionUid]);
                  }
               });
               ctrl.actionsToRender = actionsToRender;
            });
      }

   }
}());

(function() {
   angular.module('com.vmware.platform.ui').directive(
      'vxSharesControl', vxSharesControl);

   vxSharesControl.$inject = ['i18nService', 'sharesLevelsConstants'];

   function vxSharesControl(i18nService, sharesLevelsConstants) {

      function getSharesOptions() {

         var sharesLevelLabels = {};
         sharesLevelLabels[sharesLevelsConstants.sharesLevel.LOW] =
            i18nService.getString('Common', 'SharesControl.SharesInfoLevel.Low');
         sharesLevelLabels[sharesLevelsConstants.sharesLevel.NORMAL] =
            i18nService.getString('Common', 'SharesControl.SharesInfoLevel.Normal');
         sharesLevelLabels[sharesLevelsConstants.sharesLevel.HIGH] =
            i18nService.getString('Common', 'SharesControl.SharesInfoLevel.High');
         sharesLevelLabels[sharesLevelsConstants.sharesLevel.CUSTOM] =
            i18nService.getString('Common', 'SharesControl.SharesInfoLevel.Custom');

         return _.map(sharesLevelsConstants.sharesLevel, function(level) {
            return {
               id: level,
               label: sharesLevelLabels[level]
            };
         });
      }

      return {
         restrict: 'A',
         templateUrl: 'resources/ui/components/shares/vxSharesControl.html',
         scope: {
            sharesInfo: '=',
            defaultShares: '=',
            multiplier: '=',
            sharesAriaLabel: '<?',
            quantityCaretAriaLabel: "<?",
            quantityAriaLabel: "<?"
         },
         controller: ['$scope', function($scope) {

            var DEFAULT_MIN_CUSTOM_SHARES = 0;
            var DEFAULT_MAX_CUSTOM_SHARES = 1000000;

            $scope.sharesOptions = getSharesOptions();

            $scope.$watch('sharesInfo.level', function() {
               if ($scope.isSharesLevelCustom()) {
                  return;
               }
               $scope.sharesInfo.shares = getNumShares();
            });

            $scope.isSharesLevelCustom = function() {
               return $scope.sharesInfo.level ===
                  sharesLevelsConstants.sharesLevel.CUSTOM;
            };

            $scope.getMinCustomShares = function() {
               return DEFAULT_MIN_CUSTOM_SHARES;
            };

            $scope.getMaxCustomShares = function() {
               return DEFAULT_MAX_CUSTOM_SHARES;
            };

            $scope.sharesRecommendations = [
               {
                  value: $scope.getMinCustomShares(),
                  name: i18nService.getString('Common',
                     'SharesControl.MinCustomShares')
               }, {
                  value: $scope.getMaxCustomShares(),
                  name: i18nService.getString('Common',
                     'SharesControl.MaxCustomShares')
               }
            ];

            var sharesRangeErrorMessage = function() {
               return i18nService.getString('Common', 'SharesControl.RangeError',
                  $scope.getMinCustomShares(), $scope.getMaxCustomShares());
            };
            $scope.shareValueErrorMessages = {
               min: sharesRangeErrorMessage,
               max: sharesRangeErrorMessage
            };

            function getNumShares() {
               var levelMultiplier = 1;
               if ($scope.sharesInfo.level === sharesLevelsConstants.sharesLevel.LOW) {
                  levelMultiplier = 1/2;
               }
               if ($scope.sharesInfo.level === sharesLevelsConstants.sharesLevel.HIGH) {
                  levelMultiplier = 2;
               }
               var result = levelMultiplier * $scope.multiplier * $scope.defaultShares;
               result = Math.min(result, $scope.getMaxCustomShares());
               return Math.floor(result);
            }
         }]
      };
   }
})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Expands all panes in a splitter if a watched value is
 * set from false to true. Unregisters the watcher
 * after that.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
         .directive('vxVuiSplitterExpandIf', vxVuiSplitterExpandIf);

   function vxVuiSplitterExpandIf() {

      return {
         link: link
      };

      function link(scope, element, attrs) {
         var removeWatch = scope.$watch(attrs.vxVuiSplitterExpandIf, function (newValue, oldValue) {
            if (!oldValue && newValue) {
               var splitter = element.find('[kendo-splitter]').data('kendoSplitter');
               var panes = splitter.element.find(".k-pane");

               if (panes) {
                  panes.each(function (index, pane) {
                     splitter.expand(pane);
                  });
               }
               removeWatch();
            }
         });
      }
   }
})();
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Watches the vx-vui-splitter-resize-notifier attribute and triggers
 * a resize on the contained kendo-splitter, when the value changes.
 * This directive works around a problem with split-views - if the splitter is
 * initialized before its child panes' contents, the view is not rendered
 * properly.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
         .directive('vxVuiSplitterResizeNotifier', vxVuiSplitterResizeNotifier);

   vxVuiSplitterResizeNotifier.$inject = ['$timeout'];

   function vxVuiSplitterResizeNotifier($timeout) {

      return {
         priority: -500,
         link: link
      };

      function link(scope, element, attrs) {
         var triggerResize = function() {
            var splitter = element.find('[kendo-splitter]').data('kendoSplitter');
            if(splitter) {
               splitter.resize(true);
            }
         };
         scope.$watch(attrs.vxVuiSplitterResizeNotifier, function(value) {
            if (typeof attrs.noDelay !== 'undefined') {
               triggerResize();
            } else {
               $timeout(triggerResize, 0);
            }
         });
      }
   }
})();
angular.module('com.vmware.platform.ui').controller('vxStackviewController', ['$scope',
    function($scope) {
        var thisController = this;
        $scope.stackviewItems = [];

        $scope.commitProperties = function() {
            if ($scope._stackViewItemsChanged) {
                thisController.analyzeStackviewItems();
                delete $scope._stackViewItemsChanged;
            }
        };

        this.registerStackviewItem = function(stackviewItemScope) {
            if ($scope.stackviewItems.indexOf(stackviewItemScope) < 0) {
                $scope.stackviewItems.push(stackviewItemScope);
            }
            //leave this outside of the if block. This method can be used for level changes etc and not just for registering new stackViewItems.
            $scope._stackViewItemsChanged = true;
        };

        this.unregisterStackviewItem = function(stackviewItemScope) {
            var idx = $scope.stackviewItems.indexOf(stackviewItemScope);
            if (idx > -1) {
                $scope.stackviewItems.splice(idx, 1);
                $scope._stackViewItemsChanged = true;
            }
        };

        this.analyzeStackviewItems = function() {
            var i, j;
            var chkParentScope;
            var len = $scope.stackviewItems.length;
            var level;
            var parentLevel;
            var parentScope;
            var stackviewItems = $scope.stackviewItems;
            var stackviewItemScope;

            for (i=0; i<len; i++) {
                stackviewItemScope = stackviewItems[i];
                parentScope = null;
                stackviewItemScope.children = null;
                level = parseInt(stackviewItemScope.level, 10);
                level = !level ? 0 : level;

                //find the parent
                for (j=i-1; j>=0; j--) {
                    chkParentScope = stackviewItems[j];
                    parentLevel = parseInt(chkParentScope.level, 10);
                    parentLevel = !parentLevel ? 0 : parentLevel;
                    if (parentLevel < level) {
                        parentScope = chkParentScope;
                        break;
                    }
                }

                if (parentScope) {
                    if (!parentScope.children) {
                        parentScope.children = [];
                    }
                    parentScope.children.push(stackviewItemScope);
                    stackviewItemScope.indent = parentScope.indent+1;
                    stackviewItemScope.isVisible = !!parentScope.isExpanded;
                } else {
                    stackviewItemScope.indent = 0;
                    stackviewItemScope.isVisible = true;
                }
            }

            $scope.$watch($scope.commitProperties);
        };
    }
]);


/**
 * @ngdoc directive
 * @name com.vmware.platform.ui.directive:vxStackview
 *
 * @description
 * A Stackview widget with expand/ collapse functionality for read/ edit child views.<BR><BR>
 *
 * The StackView displays dynamic data (using ng-repeat) or flat data (JSON structure). This widget provides the following functionality ... <BR>
 * 1. Expand/ Collapse button to the left if a StackviewItem is the parent of other StackviewItems.<BR>
 * 2. Multi levels: There is no restriction to the number of levels the Stackview can expand up to. <BR><BR>
 *
 * Sample usage with dynamic data (ng-repeat):<BR>
 * <pre><code>
 *      <table vx-stackview>
 *           <tr level="{{obj.lvlx}}" vx-stackview-item ng-repeat="obj in myData">
 *               <td vx-stackview-item-label>{{obj.firstName}}</td>
 *               <td vx-stackview-item-value>{{obj.lvlx}}</td>
 *           </tr>
 *       </table>
 *
 *       OR
 *
 *       <vx-stackview>
 *           <vx-stackview-item level="{{obj.lvlx}}"  ng-repeat="obj in myData">
 *               <vx-stackview-item-label>{{obj.firstName}}</vx-stackview-item-label>
 *               <vx-stackview-item-value>{{obj.lvlx}}</vx-stackview-item-value>
 *           </vx-stackview-item>
 *       </vx-stackview> *
 * </code></pre>
 *
 * level: It is the responsibility of the developer (using this widget) to provide the level (refer above example and below too). Levels are
 * what determine the parent/ child relationships. They are relative numbers (relative between the parent/child).<BR><BR>
 *
 * Sample usage with flat data (JSON structure):<BR>
 * <pre><code>
            <vx-stackview>
                <vx-stackview-item level="100">
                    <vx-stackview-item-label>Name: </vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.fullName}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="101">
                    <vx-stackview-item-label>First Name:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.firstName}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="101">
                    <vx-stackview-item-label>Middle Name:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.middleName}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="101">
                    <vx-stackview-item-label>Last Name:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.lastName}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="50">
                    <vx-stackview-item-label>Address: </vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.fullAddress}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="51">
                    <vx-stackview-item-label>Street:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.address.street1}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="51">
                    <vx-stackview-item-label>City:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.address.city}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="51">
                    <vx-stackview-item-label>State:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.address.state}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="51">
                    <vx-stackview-item-label>zip:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.address.zip}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="51">
                    <vx-stackview-item-label>Country:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.address.fullCountry}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="52">
                    <vx-stackview-item-label>Code:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.address.country.code}}</vx-stackview-item-value>
                </vx-stackview-item>
                <vx-stackview-item level="52">
                    <vx-stackview-item-label>Name:</vx-stackview-item-label>
                    <vx-stackview-item-value>{{employee.address.country.name}}</vx-stackview-item-value>
                </vx-stackview-item>
            </vx-stackview>
 * </code></pre>
 *
 * Some things to note in the above example ...<BR>
 * 1. The 1st StackviewItem has a level=100. The 2nd StackviewItem has level=101. Hence the 2nd StackviewItem is the child of the 1st StackviewItem and the 1st
 * StackviewItem will show the expand/ collapse button (because it has at least 1 child).<BR>
 * 2. The StackviewItemLabel's inner HTML will become the label for that StackviewItem.<BR>
 * 3. The StackviewItemValue's inner HTML will become the value for that StackviewItem.<BR>
 * 4. The inner HTML of the label and value can be complex html structure (as long it is vaid).<BR>
 * 5. The above example could have been written with table, tr, td tags. Except that those tags would need to contain the relevant
 * Stackview attributes (refer to the ng-repeat) example. <BR><BR>
 *
 * @element table
 * @scope isolated
 * @priority default
 * @transclude true
 *
 *
 * @see com.vmware.platform.ui.directive:vxStackviewItem
 * @see com.vmware.platform.ui.directive:vxStackviewItemLabel
 * @see com.vmware.platform.ui.directive:vxStackviewItemValue
 */

angular.module('com.vmware.platform.ui').directive('vxStackview', [
    function() {
        return {
            restrict: 'EA',
            scope: {},
            template: '<table ng-transclude ng-class="{stackview: true}"></table>',
            replace: true,
            transclude: true,
            controller: 'vxStackviewController',
            link: function(scope, iElement, iAttrs, controller) {
                controller.analyzeStackviewItems();
            }
        };
    }
]);


/**
 * @ngdoc directive
 * @name com.vmware.platform.ui.directive:vxStackviewItem
 *
 * @description
 * A StackviewItem is a child of the Stackview.<BR><BR>
 *
 * @element tr
 * @scope isolated
 * @priority default
 * @transclue true
 *
 *
 * @see com.vmware.platform.ui.directive:vxStackview
 * @see com.vmware.platform.ui.directive:vxStackviewItemLabel
 * @see com.vmware.platform.ui.directive:vxStackviewItemValue
 */


angular.module('com.vmware.platform.ui').directive('vxStackviewItem', [
    function() {
        return {
            require: '^vxStackview',
            restrict: 'EA',
            scope: {level: '@'},
            template: '<tr ng-transclude ng-show="isVisible"></tr>',
            replace: true,
            transclude: true,
            controller: ["$scope", function($scope) {
                this.registerLabelValue = function(stackviewItemLabelValueScope) {
                    stackviewItemLabelValueScope.stackviewItem = $scope;
                };
            }],
            link: function(scope, iElement, iAttrs, stackviewController) {
                var tr = iElement;

                scope.level = scope.level || 0;

                scope.getItemCSS = function(value) {
                    var newClass = 'sv-indent' + scope.indent;
                    if (!scope.hasChildItems()) {
                        newClass += ' sv-expandCollapseNone';
                    } else {
                        if (scope.isExpanded) {
                            newClass += ' sv-expanded';
                        } else {
                            newClass += ' sv-collapsed';
                        }
                    }

                    return newClass;
                };

                scope.hasChildItems = function() {
                   return scope.children && scope.children.length;
                };

                scope.expandCollapse = function(value) {
                    scope.showHideChildren();
                };


                scope.showHideChildren = function() {
                    var i, childScope,
                        children = scope.children,
                        len = children ? children.length : 0;

                    for (i=0; i<len; i++) {
                        childScope = children[i];
                        childScope.isVisible = scope.isExpanded && scope.isVisible;
                    }
                };

                scope.onLevelChange = function(value) {
                    stackviewController.registerStackviewItem(scope);
                };

                scope.$watch('isExpanded', scope.expandCollapse);
                scope.$watch('isVisible', scope.expandCollapse);
                scope.$watch('level', scope.onLevelChange);

                stackviewController.registerStackviewItem(scope);
            },
            compile: function(tElement, tAttrs, transclude) {
                return this.link;
            }
        };
    }
]);


/**
 * @ngdoc directive
 * @name com.vmware.platform.ui.directive:vxStackviewItemLabel
 *
 * @description
 * A StackviewItemLabel is a child of the StackviewItem.<BR><BR>
 *
 * @element td
 * @scope isolated
 * @priority default
 * @transclue true
 *
 *
 * @see com.vmware.platform.ui.directive:vxStackview
 * @see com.vmware.platform.ui.directive:vxStackviewItem
 * @see com.vmware.platform.ui.directive:vxStackviewItemValue
 */


angular.module('com.vmware.platform.ui').directive('vxStackviewItemLabel', [
    function() {
        return {
            require: ['^vxStackviewItem'],
            restrict: 'EA',
            template: '<td class="sv-label" ng-click="toggle()"><div class="sv-hbox"><div ng-class="stackviewItem.getItemCSS()"></div><div ng-transclude></div></div></td>',
            replace: true,
            transclude: true,
            controller: ["$scope", function($scope) {
                $scope.toggle = function() {
                   if($scope.stackviewItem.hasChildItems()) {
                      $scope.stackviewItem.isExpanded = !$scope.stackviewItem.isExpanded;
                   }
                };
            }],
            link: function(scope, iElement, iAttrs, controllers) {
                var stackviewItemController = controllers[0];

                stackviewItemController.registerLabelValue(scope);
            }
        };
    }
]);




/**
 * @ngdoc directive
 * @name com.vmware.platform.ui.directive:vxStackviewItemValue
 *
 * @description
 * A StackviewItemValue is a child of the StackviewItem.<BR><BR>
 *
 * @element td
 * @scope isolated
 * @priority default
 * @transclue true
 *
 *
 * @see com.vmware.platform.ui.directive:vxStackview
 * @see com.vmware.platform.ui.directive:vxStackviewItem
 * @see com.vmware.platform.ui.directive:vxStackviewItemLabel
 */
angular.module('com.vmware.platform.ui').directive('vxStackviewItemValue', [
    function() {
        return {
            require: '^vxStackviewItem',
            restrict: 'EA',
            template: '<td class="sv-value"><div ng-transclude ng-show="!stackviewItem.isExpanded"></div></td>',
            replace: true,
            transclude: true,
            link: function(scope, iElement, iAttrs, stackviewItemController) {
                stackviewItemController.registerLabelValue(scope);
            }
        };
    }
]);





var common_ui;
(function (common_ui) {
    var StorageProfilesData = (function () {
        function StorageProfilesData(storageProfiles, vmRef, existingVmProfileAssignment, selectedProfile, error) {
            this._currentVmProfileAssignment = {
                vmHomeProfile: {
                    id: '',
                    label: ''
                }
            };
            this._storageProfiles = storageProfiles;
            if (vmRef) {
                this._vmRef = vmRef;
            }
            if (existingVmProfileAssignment) {
                this.existingVmProfileAssignment = existingVmProfileAssignment;
            }
            if (this.existingVmProfileAssignment) {
                this.assignExistingAssignments();
            }
            if (selectedProfile) {
                this.selectedProfile = selectedProfile;
            }
            if (storageProfiles && storageProfiles.length) {
                this.selectedProfile = storageProfiles[0];
            }
            if (error) {
                this._error = error;
                this._storageProfiles = [];
                this._currentVmProfileAssignment.vmHomeProfile.id = null;
            }
        }
        Object.defineProperty(StorageProfilesData.prototype, "selectedProfile", {
            get: function () {
                return this._currentVmProfileAssignment.vmHomeProfile;
            },
            set: function (profile) {
                if (this.areProfilesEqual(this._currentVmProfileAssignment.vmHomeProfile, profile)) {
                    return;
                }
                if (profile && profile.keepExistingProfileAssignments) {
                    this._currentVmProfileAssignment.vmHomeProfile = profile;
                    if (this.existingVmProfileAssignment
                        && this.existingVmProfileAssignment.diskProfileAssignments) {
                        this._currentVmProfileAssignment.diskProfileAssignments
                            = angular.copy(this.existingVmProfileAssignment.diskProfileAssignments);
                    }
                    return;
                }
                for (var i = 0; i < this._storageProfiles.length; i++) {
                    if (this.areProfilesEqual(this._storageProfiles[i], profile)) {
                        this._currentVmProfileAssignment.vmHomeProfile
                            = this._storageProfiles[i];
                        this.assignProfileToDisks(this._storageProfiles[i]);
                        break;
                    }
                }
            },
            enumerable: true,
            configurable: true
        });
        ;
        Object.defineProperty(StorageProfilesData.prototype, "existingHomeProfile", {
            get: function () {
                return this.existingVmProfileAssignment.vmHomeProfile;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(StorageProfilesData.prototype, "storageProfiles", {
            get: function () {
                return this._storageProfiles;
            },
            enumerable: true,
            configurable: true
        });
        ;
        Object.defineProperty(StorageProfilesData.prototype, "error", {
            get: function () {
                return this._error;
            },
            enumerable: true,
            configurable: true
        });
        StorageProfilesData.prototype.getDiskProfile = function (diskKey) {
            var diskAssignments = this._currentVmProfileAssignment.diskProfileAssignments;
            return this.getDiskProfileInternal(diskKey, diskAssignments);
        };
        StorageProfilesData.prototype.getExistingDiskProfile = function (diskKey) {
            var diskAssignments = this.existingVmProfileAssignment.diskProfileAssignments;
            return this.getDiskProfileInternal(diskKey, diskAssignments);
        };
        StorageProfilesData.prototype.getDiskProfileInternal = function (diskKey, diskAssignments) {
            if (diskAssignments) {
                for (var _i = 0, diskAssignments_1 = diskAssignments; _i < diskAssignments_1.length; _i++) {
                    var diskAssignment = diskAssignments_1[_i];
                    if (diskAssignment.diskId === diskKey.toString()) {
                        return diskAssignment.profile;
                    }
                }
            }
            return null;
        };
        StorageProfilesData.prototype.assignExistingAssignments = function () {
            var existingDiskAssignments = this.existingVmProfileAssignment.diskProfileAssignments;
            if (existingDiskAssignments) {
                this._currentVmProfileAssignment = angular.copy(this.existingVmProfileAssignment);
            }
        };
        StorageProfilesData.prototype.assignProfileToDisks = function (profile) {
            var vmAssignments = this._currentVmProfileAssignment.diskProfileAssignments;
            if (vmAssignments) {
                for (var i = 0; i < vmAssignments.length; i++) {
                    vmAssignments[i].profile = profile;
                }
            }
        };
        // If the StorageProfile interface gets implemented,
        // implement equality interface as well and refactor.
        StorageProfilesData.prototype.areProfilesEqual = function (p1, p2) {
            if (p1 === p2) {
                return true;
            }
            if (p1 && !p2 || p2 && !p1) {
                return false;
            }
            return p1.id === p2.id && p1.label === p2.label;
        };
        return StorageProfilesData;
    }());
    common_ui.StorageProfilesData = StorageProfilesData;
})(common_ui || (common_ui = {}));



var common_ui;
(function (common_ui) {
    var StorageSelectorData = (function () {
        function StorageSelectorData() {
        }
        return StorageSelectorData;
    }());
    common_ui.StorageSelectorData = StorageSelectorData;
    var StorageSelectorInitialConfig = (function () {
        function StorageSelectorInitialConfig() {
        }
        return StorageSelectorInitialConfig;
    }());
    common_ui.StorageSelectorInitialConfig = StorageSelectorInitialConfig;
})(common_ui || (common_ui = {}));



var common_ui;
(function (common_ui) {
    var StorageSelectorDialogData = (function () {
        function StorageSelectorDialogData() {
        }
        return StorageSelectorDialogData;
    }());
    common_ui.StorageSelectorDialogData = StorageSelectorDialogData;
})(common_ui || (common_ui = {}));



var common_ui;
(function (common_ui) {
    var StorageSelectorDiskFormatSettings = (function () {
        function StorageSelectorDiskFormatSettings() {
        }
        return StorageSelectorDiskFormatSettings;
    }());
    common_ui.StorageSelectorDiskFormatSettings = StorageSelectorDiskFormatSettings;
})(common_ui || (common_ui = {}));



var common_ui;
(function (common_ui) {
    var StorageSelectorModeSettings = (function () {
        function StorageSelectorModeSettings() {
        }
        return StorageSelectorModeSettings;
    }());
    common_ui.StorageSelectorModeSettings = StorageSelectorModeSettings;
})(common_ui || (common_ui = {}));



var common_ui;
(function (common_ui) {
    var StorageSelectorState = (function () {
        function StorageSelectorState() {
        }
        return StorageSelectorState;
    }());
    common_ui.StorageSelectorState = StorageSelectorState;
    var StorageSelectorBasicState = (function () {
        function StorageSelectorBasicState() {
        }
        return StorageSelectorBasicState;
    }());
    common_ui.StorageSelectorBasicState = StorageSelectorBasicState;
    /**
     * NOTE: Do not use the data from this class outside the storageSelector itself.
     */
    var StorageSelectorHeaderComponentState = (function () {
        function StorageSelectorHeaderComponentState() {
            /**
             * The baseline ids for which the PMem hints are NOT shown.
             *
             * By default all hints are shown - but the user can choose to hide some
             * of them via the "X" button on the informational hints.
             */
            this.hiddenBaselineHints = {};
        }
        return StorageSelectorHeaderComponentState;
    }());
    common_ui.StorageSelectorHeaderComponentState = StorageSelectorHeaderComponentState;
})(common_ui || (common_ui = {}));



var common_ui;
(function (common_ui) {
    var VmStorageConfig = (function () {
        function VmStorageConfig() {
        }
        VmStorageConfig.prototype.getVmHomeProfile = function () {
            return this.vmHome && this.vmHome.storageProfile;
        };
        VmStorageConfig.prototype.getVmHomeStorage = function () {
            return this.vmHome && this.vmHome.storageObj;
        };
        VmStorageConfig.prototype.getReplicationGroupAssignments = function () {
            var result = [];
            if (this.vmHome && this.vmHome.replicationGroup) {
                result.push(this.vmHome.replicationGroup);
            }
            _.forEach(this.vmDisks, function (diskConfig) {
                if (diskConfig && diskConfig.replicationGroup) {
                    result.push(diskConfig.replicationGroup);
                }
            });
            return result;
        };
        return VmStorageConfig;
    }());
    common_ui.VmStorageConfig = VmStorageConfig;
    var VmComponentStorageConfig = (function () {
        function VmComponentStorageConfig() {
        }
        return VmComponentStorageConfig;
    }());
    common_ui.VmComponentStorageConfig = VmComponentStorageConfig;
})(common_ui || (common_ui = {}));



var common_ui;
(function (common_ui) {
    var StorageLocator = (function () {
        function StorageLocator() {
            this.templateUrl = "resources/ui/components/storageLocator/storageLocator.html";
            this.controller = StorageLocatorController;
            this.bindings = {
                storageLocatorItemsData: "=",
                podDisplayDisabled: "=?",
                drsDisabled: "=?",
                selectedItem: "=?",
                onSelectionChanged: "&",
                storageProfilesData: "=?",
                diskFormatSettings: "=?",
                datagridPreselect: "=?",
                disableDefaultPreselection: "<?",
                ensurePreselectionVisibility: "<?",
                vmIds: "<?",
                vmDestinationHosts: "<?",
                vmStorageConfigs: "<?",
                replicationGroupSettings: "<?",
                showEncryptionOptions: "<?",
                isEncryptionOptionsDisabled: "<?",
                encryptionOptionsDisabledReason: "<?"
            };
        }
        return StorageLocator;
    }());
    common_ui.StorageLocator = StorageLocator; // class StorageLocator
    var ReplicationGroupSettings = (function () {
        function ReplicationGroupSettings() {
        }
        return ReplicationGroupSettings;
    }());
    common_ui.ReplicationGroupSettings = ReplicationGroupSettings;
    var StorageLocatorController = (function () {
        function StorageLocatorController($scope, $element, vuiConstants, i18nService, dataService, featureFlagsService, columnRenderersRegistry, defaultUriSchemeUtil, bytesFilter, storageProfileService, listUtil, diskFormatService, $timeout, spbmReplicationGroupInfoService) {
            this.$scope = $scope;
            this.$element = $element;
            this.vuiConstants = vuiConstants;
            this.i18nService = i18nService;
            this.dataService = dataService;
            this.featureFlagsService = featureFlagsService;
            this.columnRenderersRegistry = columnRenderersRegistry;
            this.defaultUriSchemeUtil = defaultUriSchemeUtil;
            this.bytesFilter = bytesFilter;
            this.storageProfileService = storageProfileService;
            this.listUtil = listUtil;
            this.diskFormatService = diskFormatService;
            this.$timeout = $timeout;
            this.spbmReplicationGroupInfoService = spbmReplicationGroupInfoService;
            this._isInitalized = false;
            this._preserveSelectedItem = false;
            this.rgSignPostConfig = {
                title: this.i18nService.getString("Common", "help"),
                message: this.i18nService.getString("Common", "StorageLocatorControl.protectionGroup.info")
            };
        }
        Object.defineProperty(StorageLocatorController.prototype, "drsDisabled", {
            get: function () {
                return this._drsDisabled;
            },
            set: function (value) {
                var oldValue = this._drsDisabled;
                this._drsDisabled = value;
                if (oldValue !== this._drsDisabled && this._isInitalized) {
                    this.populateStorageListItems();
                }
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(StorageLocatorController.prototype, "selectedReplicationGroupItem", {
            get: function () {
                return this._selectedRgItem;
            },
            set: function (item) {
                this._selectedRgItem = item;
                if (item) {
                    this.replicationGroupSettings.selectedReplicationGroup = item.rgInfo;
                }
                else {
                    this.replicationGroupSettings.selectedReplicationGroup = null;
                }
                this.updateReplicationGroupValidationError();
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(StorageLocatorController.prototype, "showReplicationGroupSelector", {
            get: function () {
                return this.replicationGroupSettings.showReplicationGroups &&
                    this.replicationGroupItems &&
                    this.replicationGroupItems.length > 0;
            },
            enumerable: true,
            configurable: true
        });
        StorageLocatorController.prototype.$onInit = function () {
            var _this = this;
            this.compatibleStorageData = null;
            this._isInitalized = true;
            this.diskFormatSettings = this.diskFormatSettings || {};
            this.replicationGroupSettings = this.replicationGroupSettings ||
                new ReplicationGroupSettings();
            _.defaults(this.diskFormatSettings, {
                diskFormatSupported: false,
                sameAsSourceSupported: true,
                thickDiskFormatSupported: true,
                selectedDiskFormat: null
            });
            if (_.isUndefined(this.datagridPreselect)) {
                this.datagridPreselect = true;
            }
            if (!_.isUndefined(this.selectedItem)) {
                this._preserveSelectedItem = true;
            }
            this.encryptionOptionsLabel = this.encryptionOptionsDisabledReason
                ? this.i18nService.getString("Common", "storageSelector.encryptVmWithReason", this.encryptionOptionsDisabledReason)
                : this.i18nService.getString("Common", "storageSelector.encryptVm");
            if (!!this.storageProfilesData) {
                if (this.storageProfilesData.storageProfiles) {
                    this.lastNonEncryptionProfile = this.storageProfilesData.storageProfiles[0];
                }
                this.onStorageProfileChanged(this.storageProfilesData.selectedProfile);
            }
            this.refreshStorageProfiles();
            this.i18n = this.i18nService.getString;
            this.rawItemDataMap = {};
            this.updateDatagridOptions([], null);
            // selection changes listener, updates the scope.selectedItem
            this.$scope.$watch(function () {
                if (_this.datagridOptions) {
                    return _this.datagridOptions.selectedItems;
                }
            }, function (newValue, oldValue) {
                if (!_this.datagridOptions) {
                    return;
                }
                if (_this.isEmptyArrayOrNull(newValue) && _this.isEmptyArrayOrNull(oldValue)) {
                    return;
                }
                if (newValue !== oldValue) {
                    var oldSelection = _this.selectedItem;
                    if (!_this.disableDefaultPreselection) {
                        _this._preserveSelectedItem = false;
                    }
                    if (newValue && newValue.length > 0) {
                        var selectedListItem = newValue[0];
                        // if the item has been selected, reset it.
                        _this.formattedItemToSelect = null;
                        _this.selectedItem = selectedListItem ? _this.rawItemDataMap[selectedListItem.id] : null;
                    }
                    else {
                        _this.selectedItem = null;
                    }
                    var selectionChanged = !_this.areStorageLocatorDataItemsEqual(oldSelection, _this.selectedItem);
                    _this.onStorageSelected(selectionChanged);
                }
            });
            this.$onInitContinued();
        };
        StorageLocatorController.prototype.toggleEncryptVm = function () {
            if (this.isEncryptVmEnabled && this.lastEncryptionProfile) {
                this.storageProfilesData.selectedProfile = this.lastEncryptionProfile;
            }
            else if (!this.isEncryptVmEnabled && this.lastNonEncryptionProfile) {
                this.storageProfilesData.selectedProfile = this.lastNonEncryptionProfile;
            }
            this.isProfileSetFromDropDown = false;
            this.refreshStorageProfiles();
        };
        StorageLocatorController.prototype.refreshStorageProfiles = function () {
            var _this = this;
            if (!this.storageProfilesData || _.isEmpty(this.storageProfilesData.storageProfiles)) {
                return;
            }
            this.filteredStorageProfiles = this.filterStorageProfiles(this.storageProfilesData.storageProfiles);
            // Set the selection
            if (!_.isEmpty(this.filteredStorageProfiles) &&
                (!this.storageProfilesData.selectedProfile ||
                    !_.some(this.filteredStorageProfiles, function (profile) { return profile.id === _this.storageProfilesData.selectedProfile.id; }))) {
                this.storageProfilesData.selectedProfile = this.filteredStorageProfiles[0];
            }
        };
        StorageLocatorController.prototype.isEmptyArrayOrNull = function (value) {
            return !value || (value && !value.length);
        };
        StorageLocatorController.prototype.onStorageProfileChanged = function (storageProfile) {
            this.storageProfilesData.selectedProfile = storageProfile;
            // Enable VM encryption if encryption storage profile is selected
            if (!this.isEncryptionOptionsDisabled) {
                this.isEncryptVmEnabled = this.storageProfileService
                    .isEncryptionStorageProfile(storageProfile);
            }
            this.isProfileSetFromDropDown = true;
            if (this.isEncryptVmEnabled) {
                this.lastEncryptionProfile = storageProfile;
            }
            else {
                this.lastNonEncryptionProfile = storageProfile;
            }
            this.afterProfileOrStorageChanged();
        };
        StorageLocatorController.prototype.notifySelectionChanged = function (selectedItem) {
            if (this.onSelectionChanged) {
                this.onSelectionChanged({ selectedItem: selectedItem });
            }
        };
        StorageLocatorController.prototype.onStorageSelected = function (selectionChanged) {
            var selectedListItem = this.datagridOptions.selectedItems && this.datagridOptions.selectedItems.length > 0
                ? this.datagridOptions.selectedItems[0]
                : null;
            this.notifySelectionChanged(selectedListItem);
            if (selectedListItem) {
                var datastoreType = void 0;
                var vStorageSupported = void 0;
                if (selectedListItem.isDatastore) {
                    datastoreType = this.rawItemDataMap[selectedListItem.id].type;
                    vStorageSupported = this.rawItemDataMap[selectedListItem.id].vStorageSupported;
                }
                else {
                    // Storage POD item
                    if (selectedListItem && selectedListItem.childDatastoreDataItems &&
                        selectedListItem.childDatastoreDataItems.length > 0) {
                        datastoreType = selectedListItem.childDatastoreDataItems[0].type;
                        vStorageSupported = selectedListItem.childDatastoreDataItems[0].vStorageSupported;
                    }
                }
                // If this is newly selected datastore, we need to
                // reset the selectedDiskFormat
                if (selectionChanged) {
                    this.diskFormatSettings.selectedDiskFormat = null;
                }
                this.diskFormats = this.diskFormatService.getAvailableDiskFormats(datastoreType, vStorageSupported, this.diskFormatSettings.sameAsSourceSupported, this.diskFormatSettings.thickDiskFormatSupported);
            }
            else {
                this.diskFormats = [];
            }
            this.updateReplicationGroupItems();
            this.afterProfileOrStorageChanged();
        };
        StorageLocatorController.prototype.afterProfileOrStorageChanged = function () {
            this.overrideDiskFormatsIfNeeded();
        };
        StorageLocatorController.prototype.isStorageSelected = function () {
            if (!this.datagridOptions) {
                return false;
            }
            var items = this.datagridOptions.selectedItems;
            return items && items.length > 0;
        };
        StorageLocatorController.prototype.overrideDiskFormatsIfNeeded = function () {
            if (this.isStorageSelected()) {
                return;
            }
            // Only apply extra logic if no datastore selected
            // and deployment will go via compute-DRS placement
            // which is currently only Ovf template
            if (this.diskFormatSettings.drsPlacement) {
                var profile = this.storageProfilesData.selectedProfile;
                // Show thick, thin, ezt instead of empty list.
                // Profile is reserved for future use.
                this.diskFormats = this.diskFormatService.getDrsDiskFormats(profile);
            }
        };
        StorageLocatorController.prototype.getSelectItemCompatibilityResult = function () {
            var selectedListItem = this.datagridOptions.selectedItems && this.datagridOptions.selectedItems.length > 0
                ? this.datagridOptions.selectedItems[0]
                : null;
            if (selectedListItem && this.compatibleStorageData &&
                this.rawItemDataMap[selectedListItem.id] &&
                this.rawItemDataMap[selectedListItem.id].storageRef) {
                var storageRefValue_1 = this.rawItemDataMap[selectedListItem.id].storageRef.value;
                return _.find(this.compatibleStorageData.compatibilityResults, function (cr) {
                    return cr.hub && cr.hub.hubId === storageRefValue_1;
                }) || null;
            }
            return null;
        };
        StorageLocatorController.prototype.getAvailableReplicationGroups = function () {
            var _this = this;
            var compatibilityResult = this.getSelectItemCompatibilityResult();
            if (!compatibilityResult || !this.compatibleStorageData) {
                return [];
            }
            var hostRefs = [];
            _.forEach(this.vmDestinationHosts, function (hostId) {
                var hostRef = _this.defaultUriSchemeUtil.getManagedObjectReference(hostId);
                if (hostRef && hostRef.type === "HostSystem") {
                    hostRefs.push(hostRef);
                }
            });
            return this.spbmReplicationGroupInfoService.extractReplicationGroupInfos(compatibilityResult, hostRefs, this.compatibleStorageData.replicationGroupInfo);
        };
        StorageLocatorController.prototype.updateReplicationGroupItems = function () {
            var _this = this;
            var replicationGroups = this.getAvailableReplicationGroups();
            if (replicationGroups) {
                this.replicationGroupItems = replicationGroups.map(function (rgInfo) {
                    return {
                        label: _this.spbmReplicationGroupInfoService.getReplicationGroupName(rgInfo),
                        rgInfo: rgInfo
                    };
                });
                var selectedRgInfo_1 = this.replicationGroupSettings &&
                    this.replicationGroupSettings.selectedReplicationGroup;
                if (selectedRgInfo_1) {
                    this.selectedReplicationGroupItem = _.find(this.replicationGroupItems, function (rgItem) {
                        return _this.spbmReplicationGroupInfoService.equalReplicationGroupInfos(rgItem.rgInfo, selectedRgInfo_1);
                    }) || null;
                }
                else {
                    // If Automatic option is available select it as default option
                    this.selectedReplicationGroupItem = _.find(this.replicationGroupItems, function (rgItem) {
                        return _this.spbmReplicationGroupInfoService.isAutoReplicationGroup(rgItem.rgInfo);
                    }) || null;
                }
            }
            else {
                this.replicationGroupItems = [];
                this.selectedReplicationGroupItem = null;
            }
        };
        StorageLocatorController.prototype.updateDatagridOptions = function (items, groupOrder, selectedFormattedItem) {
            // preselectComparator will select the formattedItemToSelect
            this.formattedItemToSelect = selectedFormattedItem;
            this.datagridOptions = {
                columnDefs: this.getColumnDefs(),
                data: items,
                height: "100%",
                selectionMode: this.vuiConstants.grid.selectionMode.SINGLE,
                searchable: false,
                resizable: true,
                selectedItems: [],
                groupOrder: groupOrder,
                sortOrder: [{ dir: "asc", field: "initialIndex" }],
                pageConfig: {
                    hidePager: true
                }
            };
        };
        StorageLocatorController.prototype.$onInitContinued = function () {
            var _this = this;
            this.requestCompatibleStorage().finally(function () {
                _this.populateStorageListItems();
            });
            // re-create all storage items when storageLocatorItemsData directive attribute is changed.
            // from outside.
            this.$scope.$watch(function () {
                return _this.storageLocatorItemsData;
            }, function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    _this.requestCompatibleStorage().finally(function () {
                        _this.populateStorageListItems();
                    });
                }
            });
            if (this.storageProfilesData) {
                // re-create all storage items when storage profile selection changes.
                this.$scope.$watch(function () {
                    return _this.storageProfilesData.selectedProfile;
                }, function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        _this.requestCompatibleStorage().finally(function () {
                            _this.populateStorageListItems();
                        });
                    }
                });
            }
            this.preselectComparator = function (gridItem) {
                var itemIdToSelect;
                if (_this.formattedItemToSelect) {
                    itemIdToSelect = _this.formattedItemToSelect.id;
                }
                else if (_this.selectedItem) {
                    itemIdToSelect = _this.defaultUriSchemeUtil.getVsphereObjectId(_this.selectedItem.storageRef);
                }
                return itemIdToSelect && gridItem && itemIdToSelect === gridItem.id;
            };
        };
        StorageLocatorController.prototype.populateStorageListItems = function () {
            var _this = this;
            var formattedStorageItems = [];
            this.drsCheckboxVisible = false;
            var storagePodListItems = {};
            if (this.storageLocatorItemsData && this.storageLocatorItemsData.storagePodItems) {
                _.forEach(this.storageLocatorItemsData.storagePodItems, function (podDataItem) {
                    var podId = _this.defaultUriSchemeUtil.getVsphereObjectId(podDataItem.storageRef);
                    _this.rawItemDataMap[podId] = podDataItem;
                    podDataItem.storageRef.isSdrsEnabled = podDataItem.drsEnabled;
                    if (podDataItem.drsEnabled === true) {
                        _this.drsCheckboxVisible = true;
                        if (!_this.drsDisabled && !_this.podDisplayDisabled) {
                            var storagePodListItem = _this.buildStoragePodListItem(podDataItem);
                            formattedStorageItems.push(storagePodListItem);
                            storagePodListItems[podId] = storagePodListItem;
                        }
                    }
                });
            }
            if (this.storageLocatorItemsData.datastoreItems) {
                _.forEach(this.storageLocatorItemsData.datastoreItems, function (dsDataItem) {
                    // Pmem datastores are not shown in the datastore list.
                    if (_this.isPmemDatastoreItem(dsDataItem)) {
                        return;
                    }
                    var dsId = _this.defaultUriSchemeUtil.getVsphereObjectId(dsDataItem.storageRef);
                    _this.rawItemDataMap[dsId] = dsDataItem;
                    var parentPodDataItem;
                    if (dsDataItem.parentStoragePod) {
                        var parentPodId = _this.defaultUriSchemeUtil.getVsphereObjectId(dsDataItem.parentStoragePod);
                        parentPodDataItem = _this.rawItemDataMap[parentPodId];
                        dsDataItem.parentStoragePod.isSdrsEnabled = parentPodDataItem.drsEnabled;
                        if (storagePodListItems[parentPodId]) {
                            storagePodListItems[parentPodId].childDatastoreDataItems.push(dsDataItem);
                        }
                    }
                    if (_this.isDatastoreItemVisible(parentPodDataItem)) {
                        formattedStorageItems.push(_this.buildDatastoreListItem(dsDataItem, parentPodDataItem));
                    }
                });
            }
            _.each(formattedStorageItems, function (item, index) {
                item.initialIndex = index;
            });
            var groupOrder = null;
            // Holds the item which will be selected.
            // Will be initialized with one of the following values:
            // 1. [highest priority] the formatted item for the scope.selectedItem (if such is available)
            // 2. the first compatible storage pod or the first compatible datastore with Datastore.AllocateSpace privilege if disableDefaultPreselection flag is false
            // 3. the first compatible item if disableDefaultPreselection flag is false and there is no compatible item with Datastore.AllocateSpace privilege
            // 4. the first storage pod or the first datastore with Datastore.AllocateSpace privilege if disableDefaultPreselection flag is false
            // 5. [lowest priority] the first item in the list if disableDefaultPreselection flag is false
            var formattedItemToBeSelected = null;
            if (this.compatibleStorageData && this.compatibleStorageData.compatibleStorage) {
                var compatibleStr_1 = this.i18nService.getString("Common", "StorageLocatorControl.Compatible");
                var incompatibleStr_1 = this.i18nService.getString("Common", "StorageLocatorControl.Incompatible");
                _.forEach(formattedStorageItems, function (item) {
                    item.compatibility = _this.compatibleStorageData.compatibleStorage[item.id] === true
                        ? compatibleStr_1
                        : incompatibleStr_1;
                    // Have to select the first storage pod or the first compatible datastore with allocateSpace privilege
                    if (!_this.disableDefaultPreselection && !formattedItemToBeSelected &&
                        item.compatibility === compatibleStr_1 && (!item.isDatastore || item.hasAllocateSpacePrivilege === true)) {
                        formattedItemToBeSelected = item;
                    }
                });
                if (!this.disableDefaultPreselection && !formattedItemToBeSelected) {
                    // There are no compatible datastores with allocateSpace privilege. Select the first compatible item.
                    formattedItemToBeSelected = _.find(formattedStorageItems, function (item) {
                        return item.compatibility === compatibleStr_1;
                    }) || formattedItemToBeSelected;
                }
                var dir = "asc";
                if (compatibleStr_1 > incompatibleStr_1) {
                    dir = "desc";
                }
                groupOrder = [{
                        field: "compatibility",
                        dir: dir
                    }];
            }
            // In case there are no compatible items:
            // 1. select the first storage pod in the list or the first datastore with AllocateSpace privilege in the list
            // 2. select first item in the list
            if (!this.disableDefaultPreselection && !formattedItemToBeSelected &&
                formattedStorageItems && formattedStorageItems.length) {
                var storageItemWithPrivilege = _.find(formattedStorageItems, function (item) {
                    return !item.isDatastore || item.hasAllocateSpacePrivilege;
                });
                formattedItemToBeSelected = storageItemWithPrivilege || formattedStorageItems[0];
            }
            if (this._preserveSelectedItem && this.selectedItem) {
                var selectedItemAsFormattedItem = _.find(formattedStorageItems, function (item) {
                    return _this.defaultUriSchemeUtil.getVsphereObjectId(_this.selectedItem.storageRef) === item.id;
                });
                if (!selectedItemAsFormattedItem) {
                    this.selectedItem = null;
                }
                else {
                    // if there is a valid formatted item assign it to the formattedItemToBeSelected
                    formattedItemToBeSelected = selectedItemAsFormattedItem;
                }
            }
            this.updateDatagridOptions(formattedStorageItems, groupOrder, formattedItemToBeSelected);
            if (this.ensurePreselectionVisibility) {
                this.scrollToPreselection();
            }
        };
        StorageLocatorController.prototype.requestCompatibleStorage = function () {
            var _this = this;
            // This will remove the grid from the DOM
            this.datagridOptions = null;
            // Clear the selection while loading
            var previouslySelectedItem = this.selectedItem;
            this.selectedItem = null;
            this.compatibleStorageData = null;
            var spec;
            if (this.storageProfilesData && this.storageProfilesData.selectedProfile &&
                this.storageProfilesData.selectedProfile.keepExistingProfileAssignments &&
                this.vmIds && this.vmStorageConfigs &&
                this.vmStorageConfigs.some(this.isVmStorageAssignedToNonDefaultStorageProfile)) {
                spec = this.storageProfileService.createCompatibleStorageQuerySpecForVms(this.vmIds, this.getDatastoreRefs(), this.getDrsEnabledStoragePodRefs());
            }
            else {
                // No request to the backend should be made when the selected storage profile is:
                // 1. Default
                // 2. Keep existing... when all vm's storage components are assigned to the default storage profile.
                // In case (2) the profile's info will be null which will be handled as like default storage profile is chosen (1).
                spec = this.storageProfileService.createCompatibleStorageQuerySpecForProfile(this.storageProfilesData, this.getDatastoreRefs(), this.getDrsEnabledStoragePodRefs());
            }
            return this.storageProfileService.requestCompatibleStorage(spec).then(function (result) {
                _this.selectedItem = previouslySelectedItem;
                _this.compatibleStorageData = result;
                if (_this.compatibleStorageData) {
                    _this.compatibleStorageData.compatibleStorage = {};
                    _.forEach(_this.compatibleStorageData.datastoreRefs, function (moRef) {
                        var storageObjId = _this.defaultUriSchemeUtil.getVsphereObjectId(moRef);
                        _this.compatibleStorageData.compatibleStorage[storageObjId] = true;
                    });
                    _.forEach(_this.compatibleStorageData.storagePodsRefs, function (moRef) {
                        var storageObjId = _this.defaultUriSchemeUtil.getVsphereObjectId(moRef);
                        _this.compatibleStorageData.compatibleStorage[storageObjId] = true;
                    });
                }
                return result;
            });
        };
        StorageLocatorController.prototype.updateReplicationGroupValidationError = function () {
            if (this.isStorageSelected()
                && this.shouldShowAdvancedModeOrChangePolicyWarning()
                && this.hasCurrentDatastoreMatchingReplicationGroups()) {
                var configurePerDiskLabel = this.i18nService.getString("Common", "storageSelector.configurePerDisk");
                this.replicationGroupSettings.replicationGroupValidationError =
                    this.i18nService.getString("Common", "DiskLocatorControl.ReplicationGroup.advancedModeOrAnotherPolicyNeededError", configurePerDiskLabel);
            }
            else if (this.showReplicationGroupSelector &&
                !this.replicationGroupSettings.selectedReplicationGroup) {
                this.replicationGroupSettings.replicationGroupValidationError =
                    this.i18nService.getString("Common", "DiskLocatorControl.ReplicationGroup.noSelectionError");
            }
            else {
                this.replicationGroupSettings.replicationGroupValidationError = null;
            }
        };
        /**
         * This warning should be shown when all are true:
         *    1. Selected policy is "Keep existing"
         *    2. One of the existing policies is replication and RG could not be configured from the dropdown
         */
        StorageLocatorController.prototype.shouldShowAdvancedModeOrChangePolicyWarning = function () {
            return this.storageProfilesData
                && this.storageProfilesData.selectedProfile
                && this.storageProfilesData.selectedProfile.keepExistingProfileAssignments
                && this.replicationGroupSettings.showReplicationGroups
                && (!this.replicationGroupItems || this.replicationGroupItems.length === 0);
        };
        StorageLocatorController.prototype.hasCurrentDatastoreMatchingReplicationGroups = function () {
            var _this = this;
            var dsRefs = (this.compatibleStorageData || {}).datastoresWithReplicationGroupsRefs;
            return dsRefs && dsRefs.length > 0 && dsRefs.some(function (datastoreRef) { return datastoreRef.value === _this.selectedItem.storageRef.value; });
        };
        StorageLocatorController.prototype.getDatastoreRefs = function () {
            return _.pluck(this.storageLocatorItemsData.datastoreItems, "storageRef");
        };
        StorageLocatorController.prototype.getDrsEnabledStoragePodRefs = function () {
            var result = [];
            if (this.storageLocatorItemsData && this.storageLocatorItemsData.storagePodItems) {
                _.forEach(this.storageLocatorItemsData.storagePodItems, function (podDataItem) {
                    if (podDataItem.drsEnabled === true) {
                        result.push(podDataItem.storageRef);
                    }
                });
            }
            return result;
        };
        StorageLocatorController.prototype.isDatastoreItemVisible = function (parentPodDataItem) {
            return this.drsDisabled || !parentPodDataItem || parentPodDataItem.drsEnabled === false
                || this.podDisplayDisabled;
        };
        StorageLocatorController.prototype.isVmStorageAssignedToNonDefaultStorageProfile = function (vmStorageConfig) {
            return [vmStorageConfig.vmHome].concat(vmStorageConfig.vmDisks)
                .filter(function (vmComponent) { return vmComponent.storageProfile; })
                .some(function (vmComponent) { return vmComponent.storageProfile.id !== "defaultId"; });
        };
        StorageLocatorController.prototype.scrollToPreselection = function () {
            var _this = this;
            this.$timeout(function () {
                if (!_this.$element) {
                    return;
                }
                var grid = _this.$element.find("#storageLocatorGrid div[kendo-grid]").data("kendoGrid");
                if (!grid) {
                    return;
                }
                var vs = grid.wrapper.find(".k-grid-content").data("kendoVirtualScrollable");
                if (!vs) {
                    return;
                }
                if (!grid.select().length) {
                    return;
                }
                var offset = grid.select().position().top;
                vs.verticalScrollbar.animate({ scrollTop: offset }, 400);
            }, 0);
        };
        StorageLocatorController.prototype.buildStoragePodListItem = function (podDataItem) {
            return {
                id: this.defaultUriSchemeUtil.getVsphereObjectId(podDataItem.storageRef),
                isDatastore: false,
                name: podDataItem.name,
                childDatastoreDataItems: [],
                icon: "vsphere-icon-datastore-cluster",
                capacity: podDataItem.capacity,
                formattedCapacity: this.bytesFilter(podDataItem.capacity),
                provisionedSpace: podDataItem.provisionedSpace,
                formattedProvisionedSpace: this.bytesFilter(podDataItem.provisionedSpace),
                freeSpace: podDataItem.freeSpace,
                formattedFreeSpace: this.bytesFilter(podDataItem.freeSpace),
                formattedType: "",
                storageDRS: podDataItem.drsEnabled ?
                    this.i18nService.getString("Common", "StorageListItem.sdrsEnabled") :
                    this.i18nService.getString("Common", "StorageListItem.sdrsDisabled"),
                thinProvisioning: this.formatThinProvisioningSupported(podDataItem),
                access: this.formatMultipleHostAccess(podDataItem),
                hardwareAcceleration: podDataItem.hardwareAcceleration,
                storagePodName: ""
            };
        };
        StorageLocatorController.prototype.buildDatastoreListItem = function (dsDataItem, parentPodDataItem) {
            return {
                id: this.defaultUriSchemeUtil.getVsphereObjectId(dsDataItem.storageRef),
                isDatastore: true,
                name: dsDataItem.name,
                icon: "vsphere-icon-datastore",
                capacity: dsDataItem.capacity,
                formattedCapacity: this.bytesFilter(dsDataItem.capacity),
                provisionedSpace: dsDataItem.provisionedSpace,
                formattedProvisionedSpace: this.bytesFilter(dsDataItem.provisionedSpace),
                freeSpace: dsDataItem.freeSpace,
                formattedFreeSpace: this.bytesFilter(dsDataItem.freeSpace),
                formattedType: dsDataItem.formattedType,
                storageDRS: "",
                thinProvisioning: this.formatThinProvisioningSupported(dsDataItem),
                access: this.formatMultipleHostAccess(dsDataItem),
                hardwareAcceleration: dsDataItem.hardwareAcceleration,
                parentPodName: parentPodDataItem ? parentPodDataItem.name : "",
                parentPodIcon: parentPodDataItem ? "vsphere-icon-datastore-cluster" : null,
                hasAllocateSpacePrivilege: dsDataItem.hasAllocateSpacePrivilege
            };
        };
        StorageLocatorController.prototype.formatMultipleHostAccess = function (item) {
            return item.multipleHostAccess
                ? this.i18nService.getString("Common", "StorageListItem.MultipleHostAccess")
                : this.i18nService.getString("Common", "StorageListItem.SingleHostAccess");
        };
        StorageLocatorController.prototype.formatThinProvisioningSupported = function (item) {
            return item.thinProvisioningSupported
                ? this.i18nService.getString("Common", "StorageListItem.ThinProvisioningSupported")
                : this.i18nService.getString("Common", "StorageListItem.ThinProvisioningNotSupported");
        };
        StorageLocatorController.prototype.getColumnDefs = function () {
            var _this = this;
            var columns = [
                {
                    field: "name",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.NameColumnHeader"),
                    width: 200,
                    template: this.iconNameRendererFactory("name", "icon")
                },
                {
                    field: "compatibility",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.CompatibilityColumnHeader"),
                    width: 110,
                    visible: false,
                    template: function (record) {
                        return record.compatibility;
                    }
                },
                {
                    field: "formattedCapacity",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.CapacityColumnHeader"),
                    width: 110,
                    sortable: function (item1, item2) {
                        return _this.listUtil.compareNumericValues(item1, item2, "capacity");
                    },
                    template: function (record) {
                        return record.formattedCapacity;
                    }
                },
                {
                    field: "formattedProvisionedSpace",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.ProvisionedSpaceColumnHeader"),
                    width: 110,
                    sortable: function (item1, item2) {
                        return _this.listUtil.compareNumericValues(item1, item2, "provisionedSpace");
                    },
                    template: function (record) {
                        return record.formattedProvisionedSpace;
                    }
                },
                {
                    field: "formattedFreeSpace",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.FreeSpaceColumnHeader"),
                    width: 110,
                    sortable: function (item1, item2) {
                        return _this.listUtil.compareNumericValues(item1, item2, "freeSpace");
                    },
                    template: function (record) {
                        return record.formattedFreeSpace;
                    }
                },
                {
                    field: "formattedType",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.TypeColumnHeader"),
                    width: 110,
                    template: function (record) {
                        return record.formattedType;
                    }
                },
                {
                    field: "storagePodName",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.StoragePodColumnHeader"),
                    width: 200,
                    template: this.iconNameRendererFactory("parentPodName", "parentPodIcon")
                },
                {
                    field: "storageDRS",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.StorageDrsColumnHeader"),
                    width: 110,
                    template: function (record) {
                        return record.storageDRS;
                    }
                },
                {
                    field: "thinProvisioning",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.ThinProvisioningColumnHeader"),
                    width: 110,
                    template: function (record) {
                        return record.thinProvisioning;
                    }
                },
                {
                    field: "access",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.AccessColumnHeader"),
                    width: 110,
                    template: function (record) {
                        return record.access;
                    }
                },
                {
                    field: "hardwareAcceleration",
                    displayName: this.i18nService.getString("Common", "StorageLocatorControl.HardwareAccelerationColumnHeader"),
                    width: 110,
                    template: function (record) {
                        return record.hardwareAcceleration;
                    }
                }
            ];
            return columns;
        };
        StorageLocatorController.prototype.iconNameRendererFactory = function (nameField, iconField) {
            var _this = this;
            return (function (data) {
                var iconName = data[iconField];
                var objectLinkRenderer = _this.columnRenderersRegistry.getColumnRenderer("object-link");
                return objectLinkRenderer([undefined, nameField, iconName], data);
            });
        };
        StorageLocatorController.prototype.areStorageLocatorDataItemsEqual = function (itemA, itemB) {
            if (!itemA && !itemB) {
                return true;
            }
            if (itemA && itemB) {
                return this.defaultUriSchemeUtil.getVsphereObjectId(itemA.storageRef) ===
                    this.defaultUriSchemeUtil.getVsphereObjectId(itemB.storageRef);
            }
            return false;
        };
        StorageLocatorController.prototype.isPmemDatastoreItem = function (dsDataItem) {
            return dsDataItem.type === "PMEM";
        };
        StorageLocatorController.prototype.filterStorageProfiles = function (storageProfiles) {
            var _this = this;
            var hasEncryptionPolicies = false;
            var filteredProfiles = _.reduce(storageProfiles, function (memo, profile) {
                var isEncryptionPolicy = _this.storageProfileService
                    .isEncryptionStorageProfile(profile);
                hasEncryptionPolicies = hasEncryptionPolicies || isEncryptionPolicy;
                if (_this.isEncryptVmEnabled) {
                    if (!isEncryptionPolicy) {
                        return memo;
                    }
                }
                // Skip Pmem profiles in the result
                if (_this.storageProfileService.isPmemStorageProfile(profile)) {
                    return memo;
                }
                memo.push(profile);
                return memo;
            }, []);
            this.hasEncryptionPolicies = hasEncryptionPolicies;
            return filteredProfiles;
        };
        StorageLocatorController.$inject = [
            "$scope",
            "$element",
            "vuiConstants",
            "i18nService",
            "dataService",
            "featureFlagsService",
            "columnRenderersRegistry",
            "defaultUriSchemeUtil",
            "bytesFilter",
            "storageProfileService",
            "listUtil",
            "diskFormatService",
            "$timeout",
            "spbmReplicationGroupInfoService"
        ];
        return StorageLocatorController;
    }()); // class StorageLocatorController
    angular.module("com.vmware.platform.ui").component("storageLocator", new StorageLocator());
})(common_ui || (common_ui = {})); // namespace



/* Copyright 2017 Vmware, Inc. All rights reserved. -- Vmware Confidential */
var common_ui;
(function (common_ui) {
    var StorageSelectorDialogData = common_ui.StorageSelectorDialogData;
    var StorageLocatorAdvancedModeApi = (function () {
        function StorageLocatorAdvancedModeApi() {
        }
        return StorageLocatorAdvancedModeApi;
    }());
    common_ui.StorageLocatorAdvancedModeApi = StorageLocatorAdvancedModeApi;
    var StorageLocatorAdvancedMode = (function () {
        function StorageLocatorAdvancedMode() {
            this.template = "<div vui-datagrid=\"$ctrl.datagridOptions\" class=\"flex-grid\" ng-if=\"$ctrl.datagridOptions\"></div>";
            this.controller = StorageLocatorAdvancedModeController;
            this.bindings = {
                onSelectionChanged: "&",
                vmStorageConfig: "<",
                storageProfilesData: "<?",
                diskFormatSettings: "<?",
                storageLocatorItemsData: "<",
                recentlySelectedStorageItems: "<",
                controlApi: "<",
                podDisplayDisabled: "<?",
                disableDefaultPreselection: "<",
                showReplicationGroups: "<?",
                isEncryptionOptionsDisabled: "<?",
                isVmtxWorkflow: "<?",
                isDiskGroupsAvailable: "<?"
            };
        }
        return StorageLocatorAdvancedMode;
    }());
    common_ui.StorageLocatorAdvancedMode = StorageLocatorAdvancedMode; // class
    var StorageLocatorAdvancedModeController = (function () {
        function StorageLocatorAdvancedModeController(i18nService, diskFormatService, defaultUriSchemeUtil, $q, storageSelectorService, spbmReplicationGroupInfoService, $element, $timeout, storageProfileService) {
            this.i18nService = i18nService;
            this.diskFormatService = diskFormatService;
            this.defaultUriSchemeUtil = defaultUriSchemeUtil;
            this.$q = $q;
            this.storageSelectorService = storageSelectorService;
            this.spbmReplicationGroupInfoService = spbmReplicationGroupInfoService;
            this.$element = $element;
            this.$timeout = $timeout;
            this.storageProfileService = storageProfileService;
            this.originalStorageItems = {};
        }
        StorageLocatorAdvancedModeController.prototype.$onInit = function () {
            this.recentlySelectedStorageItems = this.recentlySelectedStorageItems || [];
            if (this.controlApi) {
                this.controlApi.validateSelection = this.validateSelection.bind(this);
            }
            this.buildDatagridOptions();
        };
        StorageLocatorAdvancedModeController.prototype.validateSelection = function () {
            var hasMissingStorage = !!_.find(this.vmStorageConfig, function (vmConfig) {
                if (!vmConfig.vmHome.storageObj) {
                    return true;
                }
                return !!_.find(vmConfig.vmDisks, function (vmDisk) { return !vmDisk.storageObj; });
            });
            if (hasMissingStorage) {
                return this.i18nService.getString("Common", "storageSelector.incompleteSelection");
            }
            return null;
        };
        StorageLocatorAdvancedModeController.prototype.getAvailableDiskFormatsForStorageObj = function (storageObj) {
            var _this = this;
            var datastoreType;
            var vStorageSupported;
            if (storageObj.storageRef.type !== "Datastore") {
                var storagePodId_1 = this.defaultUriSchemeUtil.getVsphereObjectId(storageObj.storageRef);
                var datastoreObj = _.find(this.storageLocatorItemsData.datastoreItems, function (dsItem) {
                    return dsItem.parentStoragePod &&
                        _this.defaultUriSchemeUtil.getVsphereObjectId(dsItem.parentStoragePod) === storagePodId_1;
                });
                if (!datastoreObj) {
                    return [];
                }
                datastoreType = datastoreObj.type;
                vStorageSupported = datastoreObj.vStorageSupported;
            }
            else {
                datastoreType = storageObj.type;
                vStorageSupported = storageObj.vStorageSupported;
            }
            return this.diskFormatService.getAvailableDiskFormats(datastoreType, vStorageSupported, this.diskFormatSettings.sameAsSourceSupported, this.diskFormatSettings.thickDiskFormatSupported);
        };
        /**
         * Suggests a storage profile for a vm vmx/disk. Typically, there is no need to
         * change the storage profile when new storage is selected. However, sometimes
         * the current profile is not applicable for the selected storage and a new one
         * needs to be selected. Such is the case with PMEM profiles which are not
         * applicable to any storage other than the PMEM storage. In this case we suggest
         * that the default storage profile is to be used.
         *
         * @param vmComponentConfig - The storage component fow which to suggest
         *    a new profile
         * @returns {any} - Storage profile to be used with the storage.
         */
        StorageLocatorAdvancedModeController.prototype.suggestProfileForVmComponent = function (vmComponentConfig) {
            if (this.storageProfileService
                .isPmemStorageProfile(vmComponentConfig.storageProfile)) {
                return this.storageProfileService.getDefaultProfile();
            }
            return vmComponentConfig.storageProfile;
        };
        StorageLocatorAdvancedModeController.prototype.triggerOnSelectionChange = function () {
            if (this.onSelectionChanged) {
                this.onSelectionChanged();
            }
        };
        StorageLocatorAdvancedModeController.prototype.saveOriginalStorageItems = function () {
            var _this = this;
            this.originalStorageItems = {};
            _.forEach(this.vmStorageConfig, function (vmConfig) {
                _this.originalStorageItems[vmConfig.vmId] = vmConfig.vmHome.storageObj;
                _.forEach(vmConfig.vmDisks, function (vmDisk) {
                    _this.originalStorageItems[vmConfig.vmId + ":" + vmDisk.key] = vmDisk.storageObj;
                });
            });
        };
        StorageLocatorAdvancedModeController.prototype.buildDatagridOptions = function () {
            this.saveOriginalStorageItems();
            this.datagridOptions = {
                height: "100%",
                resizable: true,
                reorderable: true,
                data: this.buildStorageLocatorItems(),
                columnDefs: this.getColumnDefs(),
                searchable: false,
                selectedItems: []
            };
        };
        StorageLocatorAdvancedModeController.prototype.buildStorageLocatorItems = function () {
            var _this = this;
            var items = [];
            _.forEach(this.vmStorageConfig, function (vmConfig) {
                if (vmConfig.vmHome && !_this.isDiskGroupsAvailable) {
                    items.push(_this.buildStorageLocatorItem(vmConfig, true, vmConfig.vmHome));
                }
                _.forEach(vmConfig.vmDisks, function (diskComponent) {
                    items.push(_this.buildStorageLocatorItem(vmConfig, false, diskComponent));
                });
            });
            return items;
        };
        StorageLocatorAdvancedModeController.prototype.buildStorageLocatorItem = function (vmConfig, isVmHome, vmComponent) {
            var result = new StorageLocatorItem();
            result.uniqueId = (isVmHome ? vmConfig.vmId : vmConfig.vmId + vmComponent.key)
                .replace(/\:/g, "_");
            result._isVmHome = isVmHome;
            result.vmName = vmConfig.vmName;
            result._vmComponent = vmComponent;
            result._destinationHost = vmConfig.destinationHostId;
            result.getAvailableDiskFormatsForStorageObj = this.getAvailableDiskFormatsForStorageObj.bind(this);
            result.suggestProfileForVmComponent = this.suggestProfileForVmComponent.bind(this);
            result.onSelectionChange = this.triggerOnSelectionChange.bind(this);
            result.i18nService = this.i18nService;
            result.spbmReplicationGroupInfoService = this.spbmReplicationGroupInfoService;
            result.browseForStorageObj = this.browseForStorageObj.bind(this, isVmHome);
            result.onRecentItemsChange = this.onRecentItemsChange.bind(this);
            result.storageLocatorItemsData = this.storageLocatorItemsData;
            result._recentlySelectedStorageItems = this.recentlySelectedStorageItems;
            result.originalStorageItem = isVmHome
                ? this.originalStorageItems[vmConfig.vmId]
                : this.originalStorageItems[vmConfig.vmId + ":" + vmComponent.key];
            result.init();
            result.diskGroupName = vmComponent.diskGroupName;
            return result;
        };
        StorageLocatorAdvancedModeController.prototype.onRecentItemsChange = function (itemIdToSelect) {
            var _this = this;
            _.forEach(this.datagridOptions.data, function (item) { return item.updateStorageItems(); });
            // This seems to be the only way to refresh the grid.
            this.datagridOptions.data = this.buildStorageLocatorItems();
            if (itemIdToSelect) {
                this.$timeout(function () {
                    var matchingItems = _this.$element.find("#" + itemIdToSelect);
                    if (matchingItems && matchingItems[0]) {
                        matchingItems[0].focus();
                    }
                }, 1);
            }
        };
        StorageLocatorAdvancedModeController.prototype.browseForStorageObj = function (isVmHome, vmComponent, destinationHost) {
            var initialSelection = new StorageSelectorDialogData();
            if (vmComponent.storageObj && !vmComponent.storageObj.parentStoragePod) {
                initialSelection.storageObj = vmComponent.storageObj;
            }
            initialSelection.storageProfile = vmComponent.storageProfile;
            initialSelection.replicationGroup = vmComponent.replicationGroup;
            var isPmemOptionDisabled = this.isVmComponentASystemDiskGroup(vmComponent);
            return this.storageSelectorService.browseForStorage(this.storageLocatorItemsData, this.storageProfilesData, initialSelection, this.podDisplayDisabled, this.disableDefaultPreselection, destinationHost, this.showReplicationGroups, this.isEncryptionOptionsDisabled, isVmHome, isPmemOptionDisabled);
        };
        StorageLocatorAdvancedModeController.prototype.getColumnDefs = function () {
            var browseOptionLabel = this.i18nService.getString("Common", "DiskLocatorControl.Browse");
            var showColumnsForDiskGroups = this.isDiskGroupsAvailable ? this.isDiskGroupsAvailable : false;
            var showColumnsForVmtx = this.isVmtxWorkflow ? this.isVmtxWorkflow : false;
            var columnDefs = [
                {
                    displayName: this.i18nService.getString("Common", "DiskLocatorControl.Vm"),
                    width: 180,
                    field: "vmName",
                    type: "string",
                    sortable: true,
                    visible: !showColumnsForDiskGroups,
                },
                {
                    displayName: this.i18nService.getString("ProvisioningUiLib", "DiskGroupLocator.diskGroup"),
                    width: 180,
                    field: "diskGroupName",
                    type: "string",
                    sortable: true,
                    visible: showColumnsForDiskGroups,
                },
                {
                    displayName: this.i18nService.getString("Common", "DiskLocatorControl.File"),
                    width: 180,
                    field: "fileName",
                    type: "string",
                    sortable: true,
                    visible: !showColumnsForDiskGroups,
                },
                {
                    displayName: this.i18nService.getString("Common", "DiskLocatorControl.Storage"),
                    width: 180,
                    template: function (dataItem) {
                        return "\n                        <div class=\"select\">\n                          <select id=\"{{dataItem.uniqueId}}-storage-selector\"\n                                  aria-label=\"{{dataItem.i18nService.getString('Common', 'DiskLocatorControl.Storage')}}\"\n                                  ng-model=\"dataItem.storageItemId\"\n                                  ng-change=\"dataItem.setStorageItemId(dataItem.storageItemId)\"\n                                  ng-click=\"dataItem.onDatastoreComboClick($event)\"\n                                  ng-options=\"option.id as option.label for option in dataItem.storageItems\">\n                               <option value=\"\" disabled style=\"display: none; visibility:hidden\">" + browseOptionLabel + "</option>\n                           </select>\n                        </div>";
                    }
                },
                {
                    displayName: this.i18nService.getString("Common", "DiskLocatorControl.DiskFormat"),
                    width: 200,
                    visible: !showColumnsForVmtx,
                    template: function (dataItem) {
                        return "\n                        <div class=\"select\" >\n                          <select ng-model=\"dataItem.diskFormat\"\n                                  aria-label=\"{{dataItem.i18nService.getString('Common', 'DiskLocatorControl.DiskFormat')}}\"\n                                  ng-change=\"dataItem.updateDiskFormatVmComponent(dataItem.diskFormat)\"\n                                  ng-options=\"diskFormat as diskFormat.name for diskFormat in dataItem.availableDiskFormats track by diskFormat.type\"\n                                  ng-disabled=\"!dataItem.isDiskFormatEnabled\">\n                        </div>";
                    }
                },
                {
                    displayName: this.i18nService.getString("Common", "DiskLocatorControl.VmStorageProfile"),
                    width: 200,
                    field: "storageProfileLabel",
                    type: "string",
                    visible: !showColumnsForVmtx,
                    template: function (dataItem) {
                        return '<div>{{dataItem.storageProfileLabel}}</div>';
                    },
                    sortable: true
                }
            ];
            if (this.showReplicationGroups && !showColumnsForDiskGroups && !showColumnsForVmtx) {
                columnDefs.push({
                    displayName: this.i18nService.getString("Common", "DiskLocatorControl.ReplicationGroup"),
                    width: 200,
                    field: "replicationGroupLabel",
                    type: "string",
                    template: function (dataItem) {
                        return "<span>{{dataItem.replicationGroupLabel}}</span>";
                    },
                    sortable: true
                });
            }
            return columnDefs;
        };
        StorageLocatorAdvancedModeController.prototype.isVmComponentASystemDiskGroup = function (vmComponent) {
            return vmComponent &&
                (vmComponent.key === StorageLocatorAdvancedModeController.SYSTEM_DISK_GROUP_KEY);
        };
        StorageLocatorAdvancedModeController.VVOL_DS_TYPE = "VVOL";
        StorageLocatorAdvancedModeController.SYSTEM_DISK_GROUP_KEY = "ngcArtificialSystemDiskGroup";
        StorageLocatorAdvancedModeController.$inject = [
            "i18nService",
            "diskFormatService",
            "defaultUriSchemeUtil",
            "$q",
            "storageSelectorService",
            "spbmReplicationGroupInfoService",
            "$element",
            "$timeout",
            "storageProfileService"];
        return StorageLocatorAdvancedModeController;
    }());
    var StorageLocatorItem = (function () {
        function StorageLocatorItem() {
            this.MAX_STORAGE_ITEMS_OPTIONS = 10;
            this.BROWSER_OPTION_ID = "browse";
            this.NO_SELECTION_OPTION_ID = null;
        }
        Object.defineProperty(StorageLocatorItem.prototype, "fileName", {
            /**
             * The name
             * @returns {string}
             */
            get: function () {
                return this._vmComponent.name;
            },
            enumerable: true,
            configurable: true
        });
        StorageLocatorItem.prototype.init = function () {
            this.storageItemId = this._vmComponent.storageObj
                ? this._vmComponent.storageObj.storageRef.value
                : this.NO_SELECTION_OPTION_ID;
            this.updateStorageItems();
            this.updateAvailableDiskFormats();
            this.updateStorageProfileLabel();
            this.updateReplicationGroupLabel();
        };
        StorageLocatorItem.prototype.updateStorageProfileLabel = function () {
            if (this._vmComponent.storageProfile) {
                this.storageProfileLabel = this._vmComponent.storageProfile.label;
            }
            else {
                this.storageProfileLabel = "";
            }
        };
        StorageLocatorItem.prototype.updateReplicationGroupLabel = function () {
            if (this._vmComponent.replicationGroup) {
                this.replicationGroupLabel =
                    this.spbmReplicationGroupInfoService.getReplicationGroupName(this._vmComponent.replicationGroup);
            }
            else {
                this.replicationGroupLabel = "";
            }
        };
        /**
         * Update the disk format in the data model.
         */
        StorageLocatorItem.prototype.updateDiskFormatVmComponent = function (diskFormat) {
            // Check if this is the N/A item, if it's
            // set the null as current diskFormat.
            if (diskFormat && !diskFormat.type) {
                diskFormat = null;
            }
            if (diskFormat !== this._vmComponent.diskFormat) {
                this._vmComponent.diskFormat = diskFormat
                    ? {
                        name: diskFormat.name,
                        type: diskFormat.type
                    }
                    : null;
                this.onSelectionChange();
            }
        };
        StorageLocatorItem.prototype.updateAvailableDiskFormats = function () {
            var _this = this;
            if (this._isVmHome || !this._vmComponent.storageObj) {
                this.availableDiskFormats = [];
            }
            else {
                this.availableDiskFormats = this.getAvailableDiskFormatsForStorageObj(this._vmComponent.storageObj);
            }
            if (!this.availableDiskFormats || this.availableDiskFormats.length === 0) {
                this.availableDiskFormats = [{
                        type: null,
                        name: this.i18nService.getString("Common", "DiskLocatorControl.na")
                    }];
            }
            if (!this._vmComponent.diskFormat) {
                this.diskFormat = this.availableDiskFormats[0];
            }
            else {
                if (_.find(this.availableDiskFormats, function (diskFormat) { return diskFormat.type === _this._vmComponent.diskFormat.type; })) {
                    this.diskFormat = this._vmComponent.diskFormat;
                }
                else {
                    this.diskFormat = this.availableDiskFormats[0];
                }
            }
            this.isDiskFormatEnabled = !this._isVmHome && this.availableDiskFormats.length > 1;
            this.updateDiskFormatVmComponent(this.diskFormat);
        };
        StorageLocatorItem.prototype.changeStorageSelection = function (storageObj) {
            this._vmComponent.storageObj = storageObj;
            if (storageObj) {
                this.storageItemId = storageObj.storageRef.value;
                this.updateAvailableDiskFormats();
            }
            this.onSelectionChange();
        };
        /**
         * Reset the last selected item in the storage combo.
         */
        StorageLocatorItem.prototype.restoreLastStorageSelection = function () {
            if (this._vmComponent.storageObj) {
                this.storageItemId = this._vmComponent.storageObj.storageRef.value;
            }
            else {
                this.storageItemId = this.NO_SELECTION_OPTION_ID;
            }
        };
        /**
         * Checks if the only item in the storage combo is the "browse" option.
         * If this is the case opens the browse storage dialog.
         */
        StorageLocatorItem.prototype.onDatastoreComboClick = function (event) {
            if (this.storageItems && this.storageItems.length === 1) {
                if (event && event.target && event.target.blur) {
                    // hide the dropdown's pop-up
                    event.target.blur();
                }
                this.setStorageItemId(this.storageItemId);
            }
        };
        StorageLocatorItem.prototype.addNewRecentItem = function (newItem) {
            if (newItem && newItem.type === StorageLocatorAdvancedModeController.VVOL_DS_TYPE) {
                // The only way to select a VVOL datastore should be via the "Browse..." option.
                return false;
            }
            if (newItem && !_.find(this._recentlySelectedStorageItems, function (item) {
                return item.storageRef.value === newItem.storageRef.value;
            })) {
                this._recentlySelectedStorageItems.unshift(newItem);
                if (this._recentlySelectedStorageItems.length > this.MAX_STORAGE_ITEMS_OPTIONS) {
                    this._recentlySelectedStorageItems.pop();
                }
                return true;
            }
            return false;
        };
        /**
         * Handles selection changed events in the storage items dropdown.
         * @param selectedItemId
         */
        StorageLocatorItem.prototype.setStorageItemId = function (selectedItemId) {
            var _this = this;
            if (selectedItemId === this.BROWSER_OPTION_ID || selectedItemId === this.NO_SELECTION_OPTION_ID) {
                this.browseForStorageObj(this._vmComponent, this._destinationHost).then(function (storageSelectorDialogData) {
                    if (!storageSelectorDialogData) {
                        // when there is no selection revert to previous selection (if any)
                        _this.restoreLastStorageSelection();
                    }
                    else {
                        _this._vmComponent.storageProfile = storageSelectorDialogData.storageProfile;
                        _this.updateStorageProfileLabel();
                        _this._vmComponent.replicationGroup = storageSelectorDialogData.replicationGroup;
                        _this.updateReplicationGroupLabel();
                        _this.changeStorageSelection(storageSelectorDialogData.storageObj);
                        _this.updateStorageItems();
                        if (_this.addNewRecentItem(storageSelectorDialogData.storageObj)) {
                            _this.onRecentItemsChange(_this.uniqueId + "-storage-selector");
                        }
                    }
                }, function () {
                    // in case of error replace browse with the last selection without
                    // triggering selection change events.
                    _this.restoreLastStorageSelection();
                });
            }
            else {
                // Find the actual storage object by its id
                var storageObj = _.find(this.storageLocatorItemsData.datastoreItems, function (dsItem) {
                    return dsItem.storageRef.value === selectedItemId;
                });
                if (!storageObj) {
                    storageObj = _.find(this.storageLocatorItemsData.storagePodItems, function (podItem) {
                        return podItem.storageRef.value === selectedItemId;
                    });
                }
                if (this._vmComponent.replicationGroup) {
                    // reset replication group as it's no longer available for the
                    // newly selected datastore
                    this._vmComponent.replicationGroup = null;
                    this.updateReplicationGroupLabel();
                }
                this._vmComponent.storageProfile =
                    this.suggestProfileForVmComponent(this._vmComponent);
                this.updateStorageProfileLabel();
                this.changeStorageSelection(storageObj);
                this.updateStorageItems();
            }
        };
        StorageLocatorItem.prototype.buildStorageItemOption = function (storageObj) {
            return {
                id: storageObj.storageRef.value,
                label: storageObj.name
            };
        };
        StorageLocatorItem.prototype.addStorageItemOptionToList = function (items, itemToAdd) {
            if (items.length < this.MAX_STORAGE_ITEMS_OPTIONS &&
                !_.find(items, function (item) { return item.id === itemToAdd.id; })) {
                items.push(itemToAdd);
            }
        };
        StorageLocatorItem.prototype.updateStorageItems = function () {
            var _this = this;
            var items = [];
            if (this._vmComponent.storageObj) {
                this.addStorageItemOptionToList(items, this.buildStorageItemOption(this._vmComponent.storageObj));
            }
            // The only way to select a VVOL datastore should be via the "Browse..." option.
            if (this.originalStorageItem && this.originalStorageItem.type !==
                StorageLocatorAdvancedModeController.VVOL_DS_TYPE) {
                this.addStorageItemOptionToList(items, this.buildStorageItemOption(this.originalStorageItem));
            }
            _.forEach(this._recentlySelectedStorageItems, function (recentItem) { return _this.addStorageItemOptionToList(items, _this.buildStorageItemOption(recentItem)); });
            items = _.sortBy(items, "label");
            items.push({
                id: this.BROWSER_OPTION_ID,
                label: this.i18nService.getString("Common", "DiskLocatorControl.Browse")
            });
            this.storageItems = items;
        };
        return StorageLocatorItem;
    }());
    angular.module("com.vmware.platform.ui").component("storageLocatorAdvancedMode", new StorageLocatorAdvancedMode());
})(common_ui || (common_ui = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service for retrieving available storage locator items for VM provisioning.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('storageLocatorService', storageLocatorService);

   storageLocatorService.$inject = ['dataService', 'defaultUriSchemeUtil', 'managedEntityConstants'];

   function storageLocatorService (dataService, defaultUriSchemeUtil, managedEntityConstants) {

      // Public API
      var service = {
         getStorageLocatorData: getStorageLocatorData,
         getProvisioningStorageLocatorData: getProvisioningStorageLocatorData,
         getStorageObjectNameMap: getStorageObjectNameMap
      };
      return service;

      /**
       * For a given objectId, uses its EnvironmentBrowser to request datastores and
       * storagePods available for VM provisioning.
       *
       * @param objectId {String} String representation of the object reference which should be used
       *  to retrieve the available datastores.
       *  Should be of type HostSystem, ClusterComputeResource, ResourcePool or VirtualApp.
       *  For any other type retrieve the root folder's datastore information
       *
       * @param hostContext {optional} {String} String representation of context object which should
       * be passed to the environment browser when querying for the available storage objects.
       *
       * @returns {Promise} Promise with a single parameter which is the response data.
       */
      function getStorageLocatorData (objectId, hostContext) {
         if (isGetStorageLocatorDataForRootFolderToBeUsed(objectId, undefined)) {
            return getStorageLocatorDataForRootFolder(objectId);
         }

         var STORAGE_LOCATOR_ITEMS_DATA = "storageLocator:storageLocatorItemsData";
         if (hostContext) {
            return dataService.getProperties(
                  objectId,
                  [STORAGE_LOCATOR_ITEMS_DATA],
                  {
                     propertyParams: [{
                        propertyName: STORAGE_LOCATOR_ITEMS_DATA,
                        parameterType: 'com.vmware.vim.binding.vmodl.ManagedObjectReference',
                        parameter: defaultUriSchemeUtil.getManagedObjectReference(hostContext)
                     }]
                  }).then(function(response) {
                     return response ? response[STORAGE_LOCATOR_ITEMS_DATA] : null;

                  },
                  function(failureReason) {
                     failureReason = null; // avoid warning 'unused'
                     // If for whatever reason we can't read,
                     // proceed with returning null.
                     // Common reason could be missing System.Read permission
                     return null;
                  }
                  );
         }
         return dataService
               .getProperties(objectId, [STORAGE_LOCATOR_ITEMS_DATA])
               .then(function(response) {
                  return response ? response[STORAGE_LOCATOR_ITEMS_DATA] : null;
               });
      }

      /**
       * This method is used in the provisioning wizard. The original
       * getStorageLocatorData method is left for the other cases.
       *
       * @param {string} objectId
       */
      function getProvisioningStorageLocatorData (objectId) {
         if (isGetStorageLocatorDataForRootFolderToBeUsed(
               objectId, [managedEntityConstants.COMPUTE_RESOURCE])) {
            return getStorageLocatorDataForRootFolder(objectId);
         }

         var PROVISIONING_STORAGE_LOCATOR_ITEMS_DATA =
               "storageLocator:provisioningStorageLocatorItemsData";
         return dataService
               .getProperties(objectId, [PROVISIONING_STORAGE_LOCATOR_ITEMS_DATA])
               .then(function(response) {
                  return response ?
                        response[PROVISIONING_STORAGE_LOCATOR_ITEMS_DATA] : null;
               });
      }

      /**
       * For a given root folder, retrieve all datastore information
       * TODO: Add storage pod support when needed
       *
       * @param {string} objectId String representation of the object reference which
       * should be used to retrieve the available datastores. From it the root folder
       * object will be constructed automatically.
       *
       * @returns {Promise} Promise with a single parameter which is the response data.
       */
      function getStorageLocatorDataForRootFolder (objectId) {
         var folderId = defaultUriSchemeUtil.getRootFolderFromVsphereObjectId(objectId);
         var ALL_DATASTORE_INFO_PROPERTY = "storage:allDatastoresInfo";

         return dataService
            .getProperties(folderId, [ ALL_DATASTORE_INFO_PROPERTY ])
            .then(function(response) {
               var datastoreItems = response ? response[ALL_DATASTORE_INFO_PROPERTY] : null;
               return { "datastoreItems": datastoreItems, "storagePodItems": [] };
            });
      }

      /**
       * Given a StorageLocatorItemsData instance returns a map with datastore/StoragePOD ids as keys and
       * datastore/StoragePOD names as values.
       *
       * @param storageLocatorItemsData {StorageLocatorItemsData}
       *
       * @returns {Map} with all datastore/StoragePOD names.
       */
      function getStorageObjectNameMap (storageLocatorItemsData) {
         var nameMap = {};
         if (storageLocatorItemsData && storageLocatorItemsData.datastoreItems) {
            _.forEach(storageLocatorItemsData.datastoreItems, function(datastoreItem) {
               nameMap[defaultUriSchemeUtil.getVsphereObjectId(datastoreItem.storageRef)] = datastoreItem.name;
            });
         }

         if (storageLocatorItemsData && storageLocatorItemsData.storagePodItems) {
            _.forEach(storageLocatorItemsData.storagePodItems, function(podItem) {
               nameMap[defaultUriSchemeUtil.getVsphereObjectId(podItem.storageRef)] = podItem.name;
            });
         }
         return nameMap;
      }

      /**
       * @param {string} objectId
       *
       * @param {string[]} additionalTypesSupportingStorageLocatorItemsData
       *    A set of additional object types that support retrieval of storage
       *    locator data directly on them as a property.
       *
       *    The core set of objects is already predefined in this method body and is
       *    [HostSystem, ClusterComputeResource, ResourcePool, VirtualApp]
       *
       * @returns {boolean}
       */
      function isGetStorageLocatorDataForRootFolderToBeUsed(
            objectId,
            additionalTypesSupportingStorageLocatorItemsData) {
         var entityType = defaultUriSchemeUtil.getEntityType(objectId);

         const typesSupportingStorageLocatorItemsData = [
               managedEntityConstants.HOST,
               managedEntityConstants.CLUSTER,
               managedEntityConstants.RESOURCE_POOL,
               managedEntityConstants.V_APP
         ];

         if (typesSupportingStorageLocatorItemsData.indexOf(entityType) !== -1) {
            return false;
         }

         if (additionalTypesSupportingStorageLocatorItemsData &&
               (additionalTypesSupportingStorageLocatorItemsData
                     .indexOf(entityType) !== -1)) {
            return false;
         }

         return true;
      }

   }
})();

/* Copyright 2017 Vmware, Inc. All rights reserved. -- Vmware Confidential */
var common_ui;
(function (common_ui) {
    var StorageLocatorAdvancedModeApi = common_ui.StorageLocatorAdvancedModeApi;
    var StorageSelectorBasicState = common_ui.StorageSelectorBasicState;
    var ReplicationGroupSettings = common_ui.ReplicationGroupSettings;
    var StorageSelectorApi = (function () {
        function StorageSelectorApi() {
        }
        return StorageSelectorApi;
    }());
    common_ui.StorageSelectorApi = StorageSelectorApi;
    var StorageSelector = (function () {
        function StorageSelector() {
            this.templateUrl = "resources/ui/components/storageLocator/storageSelector.html";
            this.controller = StorageSelectorController;
            this.bindings = {
                modeSettings: "=?",
                onSelectionChanged: "&",
                storageSelectorState: "=",
                storageSelectorData: "=",
                storageSelectorApi: "=",
                diskFormatSettings: "=?",
                disableDefaultPreselectionInBasicMode: "<?",
                ensurePreselectionVisibilityInBasicMode: "<?",
                podDisplayDisabled: "<?",
                showReplicationGroups: "<?",
                showStorageBaselineSignpostHints: "<?",
                unsupportedStorageBaselineIds: "<?",
                isVmtxWorkflow: "<?",
                isDiskGroupsAvailable: "<?",
                isPmemOptionDisabled: "<?",
                showEncryptionOptions: "<?",
                isEncryptionOptionsDisabled: "<?",
                encryptionOptionsDisabledReason: "<?"
            };
        }
        return StorageSelector;
    }());
    common_ui.StorageSelector = StorageSelector; // class
    var StorageSelectorController = (function () {
        function StorageSelectorController($scope, $element, $timeout, i18nService, defaultUriSchemeUtil, storageSelectorService, storageSelectorConstants, storageProfileService) {
            this.$scope = $scope;
            this.$element = $element;
            this.$timeout = $timeout;
            this.i18nService = i18nService;
            this.defaultUriSchemeUtil = defaultUriSchemeUtil;
            this.storageSelectorService = storageSelectorService;
            this.storageSelectorConstants = storageSelectorConstants;
            this.storageProfileService = storageProfileService;
        }
        StorageSelectorController.prototype.$onInit = function () {
            var _this = this;
            if (this.storageSelectorApi) {
                this.storageSelectorApi.validateSelection = this.validateSelection.bind(this);
                this.storageSelectorApi.validateReplicationGroupSelection =
                    this.validateReplicationGroupSelection.bind(this);
            }
            if (this.onSelectionChanged) {
                this._onSelectionChangedDebounced = _.debounce(this.onSelectionChanged, 20);
            }
            this.advancedModeApi = new StorageLocatorAdvancedModeApi();
            this.vmIds = [];
            this.vmDestinationHosts = [];
            _.forEach(this.storageSelectorData.sourceVmStorageConfig, function (vmConfig) {
                _this.vmIds.push(vmConfig.vmId);
                if (vmConfig.destinationHostId) {
                    _this.vmDestinationHosts.push(vmConfig.destinationHostId);
                }
            });
            this.initBasicModeData();
            this.initAdvancedModeData();
        };
        StorageSelectorController.prototype.onSelectionModeChange = function (newSelectionMode) {
            this.storageSelectorState.mode = newSelectionMode;
            switch (newSelectionMode) {
                case this.storageSelectorConstants.BASIC_MODE:
                    this.selectionModeButtonLabel = this.i18nService.getString("Common", "DatastoreSelectControl.Advanced");
                    this.updateSelectionInBasicMode();
                    break;
                case this.storageSelectorConstants.ADVANCED_MODE:
                    this.selectionModeButtonLabel = this.i18nService.getString("Common", "DatastoreSelectControl.Basic");
                    this.onSelectionChangedInAdvancedMode();
                    // This is needed because the grid size is not calculated properly by the
                    // kendo when the user goes directly in the advanced mode of the wizard
                    // because while rendering new vui wizard page the new one starts
                    // rendering before the previous is gone.
                    this.resizeAdvancedGrid();
                    break;
            }
        };
        StorageSelectorController.prototype.initAdvancedModeData = function () {
            var _this = this;
            if (!this.storageSelectorState.vmStorageConfigInAdvancedMode) {
                this.storageSelectorState.vmStorageConfigInAdvancedMode =
                    angular.copy(this.storageSelectorData.sourceVmStorageConfig);
            }
            if (!this.storageSelectorState.recentlySelectedStorageItemsInAdvancedMode) {
                this.storageSelectorState.recentlySelectedStorageItemsInAdvancedMode = [];
            }
            else {
                this.storageSelectorState.recentlySelectedStorageItemsInAdvancedMode = _.filter(this.storageSelectorState.recentlySelectedStorageItemsInAdvancedMode, function (item) { return _this.isStorageObjAvailable(item); });
            }
            // Remove selected storage objects that are no longer available
            _.forEach(this.storageSelectorState.vmStorageConfigInAdvancedMode, function (vmConfig) {
                if (vmConfig.vmHome) {
                    _this.removeUnavailableStorage(vmConfig.vmHome);
                }
                _.forEach(vmConfig.vmDisks, function (vmDisk) {
                    return _this.removeUnavailableStorage(vmDisk);
                });
            });
        };
        StorageSelectorController.prototype.isStorageObjAvailable = function (storageItem) {
            if (storageItem && storageItem.storageRef) {
                var storageId = this.defaultUriSchemeUtil.getVsphereObjectId(storageItem.storageRef);
                return !!this.storageSelectorService.getStorageObjectFromId(storageId, this.storageSelectorData.storageLocatorItemsData);
            }
            return false;
        };
        StorageSelectorController.prototype.removeUnavailableStorage = function (component) {
            if (component.storageObj) {
                var storageId = this.defaultUriSchemeUtil.getVsphereObjectId(component.storageObj.storageRef);
                var isSdrsEnabled = component.storageObj.storageRef.isSdrsEnabled;
                component.storageObj = this.storageSelectorService.getStorageObjectFromId(storageId, this.storageSelectorData.storageLocatorItemsData);
                if (component.storageObj && component.storageObj.storageRef) {
                    component.storageObj.storageRef.isSdrsEnabled = isSdrsEnabled;
                }
                if (component.storageObj && component.storageObj.parentStoragePod) {
                    var parentId = this.defaultUriSchemeUtil.getVsphereObjectId(component.storageObj.parentStoragePod);
                    component.storageObj.parentStoragePod.isSdrsEnabled =
                        this.storageSelectorService.getStorageObjectFromId(parentId, this.storageSelectorData.storageLocatorItemsData).drsEnabled;
                }
            }
        };
        StorageSelectorController.prototype.initBasicModeData = function () {
            var _this = this;
            if (!this.storageSelectorState.basicModeState) {
                this.initBasicModeState();
            }
            if (this.storageSelectorState.basicModeState.profilesData) {
                this.$scope.$watch(function () {
                    return _this.storageSelectorState.basicModeState.profilesData.selectedProfile;
                }, function (newValue, oldValue) {
                    if (newValue !== oldValue) {
                        _this.updateSelectionInBasicMode();
                    }
                });
            }
            this.$scope.$watch(function () {
                return _this.storageSelectorState.basicModeState.selectedItem;
            }, function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    _this.updateSelectionInBasicMode();
                }
            });
            this.$scope.$watch(function () {
                return _this.storageSelectorState.basicModeState.replicationGroupSettings.selectedReplicationGroup;
            }, function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    _this.updateSelectionInBasicMode();
                }
            });
            this.$scope.$watch(function () {
                return _this.storageSelectorState.basicModeState.diskFormatSettings.
                    selectedDiskFormat;
            }, function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    _this.updateSelectionInBasicMode();
                }
            });
        };
        StorageSelectorController.prototype.initBasicModeState = function () {
            var _this = this;
            this.storageSelectorState.basicModeState = new StorageSelectorBasicState();
            var rgSettings = new ReplicationGroupSettings();
            this.storageSelectorState.basicModeState.replicationGroupSettings = rgSettings;
            rgSettings.replicationGroupValidationError = null;
            rgSettings.showReplicationGroups = this.showReplicationGroups;
            rgSettings.selectedReplicationGroup = this.storageSelectorData.initialConfig
                ? this.storageSelectorData.initialConfig.selectedReplicationGroupInBasicMode
                : null;
            this.storageSelectorState.basicModeState.diskFormatSettings = {
                drsPlacement: this.diskFormatSettings.drsPlacement,
                diskFormatSupported: this.diskFormatSettings.diskFormatSupported,
                sameAsSourceSupported: this.diskFormatSettings.sameAsSourceSupported,
                thickDiskFormatSupported: this.diskFormatSettings.thickDiskFormatSupported,
                selectedDiskFormat: this.storageSelectorData.initialConfig
                    ? this.storageSelectorData.initialConfig.selectedDiskFormatInBasicMode
                    : null
            };
            this.storageSelectorState.basicModeState.selectedItem = null;
            if (this.storageSelectorData.initialConfig) {
                this.storageSelectorState.basicModeState.selectedItem =
                    this.storageSelectorData.initialConfig.selectedItemInBasicMode;
            }
            if (this.storageSelectorData.storageProfilesData) {
                this.storageSelectorState.basicModeState.profilesData = {
                    error: this.storageSelectorData.storageProfilesData.error,
                    storageProfiles: this.storageSelectorData.storageProfilesData.storageProfiles,
                    selectedProfile: this.storageSelectorData.initialConfig
                        ? this.storageSelectorData.initialConfig.selectedStorageProfileInBasicMode
                        : null
                };
            }
            // Determine the drsDisabled value
            this.storageSelectorState.basicModeState.drsDisabled = false; /* default value */
            // If the selectedItemInBasicMode in initialConfig is datastore part of drs-enabled cluster
            // we should disable the drs checkbox
            if (this.storageSelectorData.initialConfig
                && this.storageSelectorData.initialConfig.selectedItemInBasicMode
                && this.storageSelectorData.initialConfig.selectedItemInBasicMode.parentStoragePod) {
                var parentPodId_1 = this.defaultUriSchemeUtil.getVsphereObjectId(this.storageSelectorData.initialConfig.selectedItemInBasicMode.parentStoragePod);
                var parentPodItem = _.find(this.storageSelectorData.storageLocatorItemsData.storagePodItems, function (podItem) {
                    return parentPodId_1 === _this.defaultUriSchemeUtil.getVsphereObjectId(podItem.storageRef);
                });
                if (parentPodItem && parentPodItem.drsEnabled) {
                    this.storageSelectorState.basicModeState.drsDisabled = true;
                }
            }
            this.storageSelectorState.basicModeState.headerState =
                new common_ui.StorageSelectorHeaderComponentState();
        };
        StorageSelectorController.prototype.onSelectionChangedInAdvancedMode = function () {
            this.storageSelectorData.vmStorageConfig = this.storageSelectorState.
                vmStorageConfigInAdvancedMode;
            this.triggerOnSelectionChange();
        };
        StorageSelectorController.prototype.updateVmComponentInBasicMode = function (component, isVmHome) {
            if (!component) {
                return;
            }
            component.storageObj = this.storageSelectorState.basicModeState.selectedItem;
            component.replicationGroup = this.storageSelectorState.basicModeState
                .replicationGroupSettings.selectedReplicationGroup;
            if (isVmHome) {
                component.diskFormat = null;
                this.updateVmComponentProfileInBasicMode(component, true);
            }
            else {
                // VM Disk
                component.diskFormat = this.storageSelectorState.basicModeState.
                    diskFormatSettings.selectedDiskFormat;
                this.updateVmComponentProfileInBasicMode(component, false);
            }
        };
        StorageSelectorController.prototype.updateVmComponentProfileInBasicMode = function (component, isVmHome) {
            if (!this.storageSelectorState.basicModeState.profilesData) {
                return;
            }
            // VM Disks
            if (!isVmHome) {
                if (this.storageSelectorState.storageBaselineId ===
                    this.storageSelectorConstants.PMEM_STORAGE_BASELINE.id) {
                    // All Disks go to PMem storage - no discussion.
                    component.storageProfile = this.storageProfileService.findPmemStorageProfile(this.storageSelectorData.storageProfilesData.storageProfiles);
                    component.storageObj = null;
                    return;
                }
                if (this.storageSelectorState.storageBaselineId ===
                    this.storageSelectorConstants.HYBRID_STORAGE_BASELINE.id) {
                    if (component.storageProfile && this.storageProfileService.
                        isPmemStorageProfile(component.storageProfile)) {
                        // In hybrid mode we keel the same storage profile - if this is a
                        // Pmem storage profile, just nullify the storageObj
                        component.storageObj = null;
                        return;
                    }
                }
            }
            // VM Home or fall through
            var isKeepExisingSelected = !!this.storageSelectorState.basicModeState.profilesData.selectedProfile
                && this.storageSelectorState.basicModeState.profilesData.selectedProfile.
                    keepExistingProfileAssignments;
            if (!isKeepExisingSelected) {
                // If the selected option is different from `Keep existing` then update.
                component.storageProfile = this.storageSelectorState.basicModeState.
                    profilesData.selectedProfile;
                return;
            }
            // If selected option is `Keep existing` and we are using STANDARD baseline
            // and the component is using PMEM policy we cannot keep that PMEM policy
            // and need to default to something else.
            var isUsingPmemPolicy = component.storageProfile
                && this.storageProfileService.isPmemStorageProfile(component.storageProfile);
            var isStandardBaseline = this.storageSelectorState.storageBaselineId ===
                this.storageSelectorConstants.STANDARD_STORAGE_BASELINE.id;
            if (isStandardBaseline && isUsingPmemPolicy) {
                component.storageProfile = this.storageProfileService.getDefaultProfile();
            }
        };
        StorageSelectorController.prototype.updateSelectionInBasicMode = function () {
            var _this = this;
            this.storageSelectorData.vmStorageConfig = angular.copy(this.storageSelectorData.sourceVmStorageConfig);
            _.forEach(this.storageSelectorData.vmStorageConfig, function (vmConfig) {
                // update vm home
                _this.updateVmComponentInBasicMode(vmConfig.vmHome, true);
                // Update disks
                _.forEach(vmConfig.vmDisks, function (disk) {
                    return _this.updateVmComponentInBasicMode(disk, false);
                });
            });
            this.triggerOnSelectionChange();
        };
        ;
        StorageSelectorController.prototype.triggerOnSelectionChange = function () {
            if (this._onSelectionChangedDebounced) {
                this._onSelectionChangedDebounced();
            }
        };
        StorageSelectorController.prototype.validateSelection = function () {
            var _this = this;
            if (this.storageSelectorState.mode ===
                this.storageSelectorConstants.ADVANCED_MODE) {
                return this.advancedModeApi.validateSelection();
            }
            else {
                if (this.storageSelectorState.basicModeState
                    .replicationGroupSettings.replicationGroupValidationError) {
                    return this.storageSelectorState.basicModeState
                        .replicationGroupSettings.replicationGroupValidationError;
                }
                var hasMissingStorage = _.any(this.storageSelectorData.vmStorageConfig, function (vmConfig) {
                    if (vmConfig.vmHome && !vmConfig.vmHome.storageObj) {
                        return true;
                    }
                    return _.any(vmConfig.vmDisks, function (vmDisk) {
                        return !_this.storageProfileService.isPmemStorageProfile(vmDisk.storageProfile)
                            && !vmDisk.storageObj;
                    });
                });
                if (hasMissingStorage) {
                    return this.i18nService.getString("Common", "storageSelector.incompleteSelection");
                }
            }
            // no errors
            return null;
        };
        StorageSelectorController.prototype.validateReplicationGroupSelection = function () {
            if (this.showReplicationGroups &&
                this.storageSelectorState.mode === this.storageSelectorConstants.BASIC_MODE) {
                return this.storageSelectorState.basicModeState
                    .replicationGroupSettings.replicationGroupValidationError;
            }
            // no errors
            return null;
        };
        StorageSelectorController.prototype.resizeAdvancedGrid = function () {
            var _this = this;
            this.$timeout(function () {
                var grid = _this.$element.find(".storage-selector-advanced-mode [kendo-grid]");
                if (!grid) {
                    return;
                }
                var kendoGrid = grid.data("kendoGrid");
                if (!kendoGrid) {
                    return;
                }
                kendoGrid.resize(true);
            }, 0);
        };
        StorageSelectorController.prototype.onStorageBaselineSelectionChange = function (newStorageBaselineId) {
            this.storageSelectorState.storageBaselineId = newStorageBaselineId;
            // This is needed because the storage baseline Id is evaluated each time
            // when the user goes directly in the advanced mode of the wizard and then the
            // selections should not be updated according to the basic view selections.
            if (this.storageSelectorState.mode === this.storageSelectorConstants.BASIC_MODE) {
                this.updateSelectionInBasicMode();
            }
        };
        StorageSelectorController.prototype.isLocatorInBasicMode = function () {
            var vmHomeConfig = _.find(this.storageSelectorData.vmStorageConfig, function (vmConfig) { return !!vmConfig.vmHome; });
            return this.storageSelectorState.mode === this.storageSelectorConstants.BASIC_MODE
                && (this.storageSelectorConstants.PMEM_STORAGE_BASELINE.id
                    !== this.storageSelectorState.storageBaselineId
                    || !!vmHomeConfig);
        };
        StorageSelectorController.$inject = [
            "$scope",
            "$element",
            "$timeout",
            "i18nService",
            "defaultUriSchemeUtil",
            "storageSelectorService",
            "storageSelectorConstants",
            "storageProfileService"
        ];
        return StorageSelectorController;
    }()); // class
    angular.module("com.vmware.platform.ui").component("storageSelector", new StorageSelector());
})(common_ui || (common_ui = {})); // namespace



/* Copyright 2017 Vmware, Inc. All rights reserved. -- Vmware Confidential */
var common_ui;
(function (common_ui) {
    var StorageSelectorConstants = (function () {
        function StorageSelectorConstants(i18nService) {
            this.i18nService = i18nService;
            this.STANDARD_STORAGE_BASELINE = {
                label: "na",
                id: "stdBaseline"
            };
            this.PMEM_STORAGE_BASELINE = {
                label: "na",
                id: "pmemBaseline"
            };
            this.HYBRID_STORAGE_BASELINE = {
                label: "na",
                id: "hybridBaseline"
            };
            this.BASIC_MODE = "basicMode";
            this.ADVANCED_MODE = "advancedMode";
            this.STANDARD_STORAGE_BASELINE.label =
                i18nService.getString("Common", "storageSelector.stdBaseline.label");
            this.PMEM_STORAGE_BASELINE.label =
                i18nService.getString("Common", "storageSelector.pmemBaseline.label");
            this.HYBRID_STORAGE_BASELINE.label =
                i18nService.getString("Common", "storageSelector.hybridBaseline.label");
        }
        StorageSelectorConstants.$inject = [
            "i18nService"
        ];
        return StorageSelectorConstants;
    }());
    common_ui.StorageSelectorConstants = StorageSelectorConstants; // class StorageSelectorConstants
    angular.module("com.vmware.platform.ui").service("storageSelectorConstants", StorageSelectorConstants);
})(common_ui || (common_ui = {})); // namespace



/* Copyright 2017 Vmware, Inc. All rights reserved. -- Vmware Confidential */
var common_ui;
(function (common_ui) {
    var StorageSelectorHeaderComponent = (function () {
        function StorageSelectorHeaderComponent() {
            this.templateUrl = "resources/ui/components/storageLocator/storageSelectorHeaderComponent.html";
            this.controller = StorageSelectorHeaderComponentController;
            this.bindings = {
                storageProfiles: "<",
                datastoreItems: "<",
                sourceVmStorageConfig: "<?",
                storageBaselineId: "<?",
                showStorageBaselineSignpostHints: "<?",
                unsupportedStorageBaselineIds: "<?",
                storageSelectorState: "<?",
                showSelectionModeSelector: "<?",
                selectionMode: "<?",
                componentState: "<",
                onStorageBaselineIdChange: "&",
                onSelectionModeChange: "&",
                isPmemOptionDisabled: "<?",
                isDiskGroupsAvailable: "<?"
            };
        }
        return StorageSelectorHeaderComponent;
    }());
    common_ui.StorageSelectorHeaderComponent = StorageSelectorHeaderComponent; // class StorageLocator
    var StorageSelectorHeaderComponentController = (function () {
        function StorageSelectorHeaderComponentController(i18nService, storageProfileService, storageSelectorConstants, featureFlagsService) {
            this.i18nService = i18nService;
            this.storageProfileService = storageProfileService;
            this.storageSelectorConstants = storageSelectorConstants;
            this.featureFlagsService = featureFlagsService;
            this.baselineHints = {};
            this.i18n = i18nService.getString;
            this.signpostParams = {
                title: i18nService.getString("Common", "storageSelector.pmemStorage"),
                message: i18nService.getString("Common", "storageSelector.pmemBaseline.signpost")
            };
        }
        StorageSelectorHeaderComponentController.prototype.$onInit = function () {
            this.initSelectionModeSelector();
            this.initStorageBaselineSelector();
        };
        StorageSelectorHeaderComponentController.prototype.initSelectionModeSelector = function () {
            this.selectionMode = this.selectionMode ||
                this.storageSelectorConstants.BASIC_MODE;
            this.onSelectionModeChange({ newSelectionMode: this.selectionMode });
        };
        StorageSelectorHeaderComponentController.prototype.toggleSelectionMode = function () {
            switch (this.selectionMode) {
                case this.storageSelectorConstants.BASIC_MODE:
                    this.selectionMode = this.storageSelectorConstants.ADVANCED_MODE;
                    break;
                case this.storageSelectorConstants.ADVANCED_MODE:
                    this.selectionMode = this.storageSelectorConstants.BASIC_MODE;
                    break;
            }
            this.onSelectionModeChange({ newSelectionMode: this.selectionMode });
        };
        StorageSelectorHeaderComponentController.prototype.initStorageBaselineSelector = function () {
            var _this = this;
            // Scan for any Pmem profiles (actually just one) available
            var pmemProfile = _.any(this.storageProfiles, function (profile) {
                return _this.storageProfileService.isPmemStorageProfile(profile);
            });
            if (!pmemProfile) {
                this.availableStorageBaselines = undefined;
                this.setSelectedStorageBaselineId(this.storageSelectorConstants.STANDARD_STORAGE_BASELINE.id);
                return;
            }
            // Scan for any PMem datastores available
            var pmemDatastoreAvailable = _.any(this.datastoreItems, function (item) {
                return item.type === "PMEM";
            });
            if (!pmemDatastoreAvailable || this.isPmemOptionDisabled) {
                this.availableStorageBaselines = undefined;
                this.setSelectedStorageBaselineId(this.storageSelectorConstants.STANDARD_STORAGE_BASELINE.id);
                return;
            }
            // Only VM disks can be placed on PMEM, if no disks then no need for PMEM.
            var hasDiskItems = _.any(this.sourceVmStorageConfig, function (vmStorage) {
                return !_.isEmpty(vmStorage.vmDisks);
            });
            if (!hasDiskItems) {
                this.availableStorageBaselines = undefined;
                this.setSelectedStorageBaselineId(this.storageSelectorConstants.STANDARD_STORAGE_BASELINE.id);
                return;
            }
            // Both PMem profile and PMem datastore are available
            // Should show at least two baselines: Standard and PMem
            this.availableStorageBaselines = [
                this.storageSelectorConstants.STANDARD_STORAGE_BASELINE
            ];
            var pmemBaselineSupported = _.indexOf(this.unsupportedStorageBaselineIds, this.storageSelectorConstants.PMEM_STORAGE_BASELINE.id) < 0;
            if (pmemBaselineSupported) {
                this.availableStorageBaselines.push(this.storageSelectorConstants.PMEM_STORAGE_BASELINE);
            }
            var pmemDiskCount = 0;
            var totalDiskCount = 0;
            _.each(this.sourceVmStorageConfig, function (vmStorage) {
                _.each(vmStorage.vmDisks, function (compConfig) {
                    if (_this.storageProfileService.isPmemStorageProfile(compConfig.storageProfile)) {
                        pmemDiskCount++;
                    }
                    ;
                    totalDiskCount++;
                });
            });
            var suggestedBaseline = this.storageSelectorConstants.STANDARD_STORAGE_BASELINE.id;
            if (pmemDiskCount > 0) {
                if (pmemDiskCount === totalDiskCount) {
                    // All PMEM items
                    suggestedBaseline = this.storageSelectorConstants.PMEM_STORAGE_BASELINE.id;
                }
                else {
                    // Some PMEM items -> Hybrid config
                    this.availableStorageBaselines.push(this.storageSelectorConstants.HYBRID_STORAGE_BASELINE);
                    suggestedBaseline = this.storageSelectorConstants.HYBRID_STORAGE_BASELINE.id;
                }
            }
            // If we have just one available storage baseline, we nullify the value
            // to trigger proper UI configuration - if one option is available - no need
            // of the storage baseline id selector element.
            if (_.size(this.availableStorageBaselines) <= 1) {
                this.availableStorageBaselines = undefined;
            }
            this.setSelectedStorageBaselineId(this.pickInitialStorageBaselineId(suggestedBaseline));
            this.initBaselineHints();
        };
        StorageSelectorHeaderComponentController.prototype.pickInitialStorageBaselineId = function (suggestedBaseline) {
            if (!this.availableStorageBaselines) {
                return this.storageSelectorConstants.STANDARD_STORAGE_BASELINE.id;
            }
            var baselineToSelect = this.storageBaselineId || suggestedBaseline;
            if (baselineToSelect) {
                var storageBaseline = _.findWhere(this.availableStorageBaselines, { id: baselineToSelect });
                if (storageBaseline) {
                    return baselineToSelect;
                }
            }
            // Prefer hybrid if available
            if (this.availableStorageBaselines.indexOf(this.storageSelectorConstants.HYBRID_STORAGE_BASELINE) >= 0) {
                return this.storageSelectorConstants.HYBRID_STORAGE_BASELINE.id;
            }
            // Otherwise prefer standard
            return this.storageSelectorConstants.STANDARD_STORAGE_BASELINE.id;
        };
        StorageSelectorHeaderComponentController.prototype.setSelectedStorageBaselineId = function (storageBaselineId) {
            if (this.selectedStorageBaselineId === storageBaselineId) {
                return;
            }
            this.selectedStorageBaselineId = storageBaselineId;
            this.onSelectedStorageBaselineIdChange();
        };
        StorageSelectorHeaderComponentController.prototype.initBaselineHints = function () {
            if (!this.availableStorageBaselines) {
                return;
            }
            var baseline = this.storageSelectorConstants.PMEM_STORAGE_BASELINE;
            if (!this.componentState.hiddenBaselineHints[baseline.id] &&
                (this.availableStorageBaselines.indexOf(baseline) >= 0)) {
                var hasSingleDisk = this.sourceVmStorageConfig.length === 1
                    && !this.sourceVmStorageConfig[0].vmHome
                    && this.sourceVmStorageConfig[0].vmDisks
                    && this.sourceVmStorageConfig[0].vmDisks.length === 1;
                if (hasSingleDisk) {
                    this.baselineHints[baseline.id] = [{
                            message: this.i18n("Common", "storageSelector.pmemBaseline.singleDisk.hint.line1"),
                            bold: true
                        }, {
                            message: this.i18n("Common", "storageSelector.pmemBaseline.singleDisk.hint.line2"),
                            bold: false
                        }];
                }
                else {
                    this.baselineHints[baseline.id] = [{
                            message: this.i18n("Common", "storageSelector.pmemBaseline.hint.line1"),
                            bold: true
                        }, {
                            message: this.i18n("Common", "storageSelector.pmemBaseline.hint.line2"),
                            bold: false
                        }];
                }
            }
            baseline = this.storageSelectorConstants.HYBRID_STORAGE_BASELINE;
            if (!this.componentState.hiddenBaselineHints[baseline.id] &&
                (this.availableStorageBaselines.indexOf(baseline) >= 0)) {
                this.baselineHints[baseline.id] = [{
                        message: this.i18n("Common", "storageSelector.hybridBaseline.hint"),
                        bold: true
                    }];
            }
        };
        StorageSelectorHeaderComponentController.prototype.getHintFor = function (storageBaselineId) {
            // None of the alerts is visible in advanced mode.
            if (this.selectionMode === this.storageSelectorConstants.ADVANCED_MODE) {
                return undefined;
            }
            return this.baselineHints[storageBaselineId];
        };
        StorageSelectorHeaderComponentController.prototype.onSelectedStorageBaselineIdChange = function () {
            this.onStorageBaselineIdChange({
                newStorageBaselineId: this.selectedStorageBaselineId });
        };
        StorageSelectorHeaderComponentController.prototype.onBaselineHintClose = function () {
            this.baselineHints[this.selectedStorageBaselineId] = undefined;
            this.componentState.hiddenBaselineHints[this.selectedStorageBaselineId] = true;
        };
        StorageSelectorHeaderComponentController.$inject = [
            "i18nService",
            "storageProfileService",
            "storageSelectorConstants",
            "featureFlagsService"
        ];
        return StorageSelectorHeaderComponentController;
    }()); // class StorageBaselineComponentController
    angular.module("com.vmware.platform.ui").component("storageSelectorHeaderComponent", new StorageSelectorHeaderComponent());
})(common_ui || (common_ui = {})); // namespace



var common_ui;
(function (common_ui) {
    var StorageSelectorState = common_ui.StorageSelectorState;
    var StorageSelectorData = common_ui.StorageSelectorData;
    var VmStorageConfig = common_ui.VmStorageConfig;
    var VmComponentStorageConfig = common_ui.VmComponentStorageConfig;
    var StorageSelectorModeSettings = common_ui.StorageSelectorModeSettings;
    var StorageSelectorDiskFormatSettings = common_ui.StorageSelectorDiskFormatSettings;
    var StorageSelectorApi = common_ui.StorageSelectorApi;
    var StorageSelectorInitialConfig = common_ui.StorageSelectorInitialConfig;
    var StorageSelectorDialogData = common_ui.StorageSelectorDialogData;
    var StorageSelectorService = (function () {
        function StorageSelectorService($q, i18nService, storageProfileService, defaultUriSchemeUtil, bytesFilter, clarityModalService, clarityConstants) {
            this.$q = $q;
            this.i18nService = i18nService;
            this.storageProfileService = storageProfileService;
            this.defaultUriSchemeUtil = defaultUriSchemeUtil;
            this.bytesFilter = bytesFilter;
            this.clarityModalService = clarityModalService;
            this.clarityConstants = clarityConstants;
        }
        StorageSelectorService.prototype.getStorageSelectorApiObj = function () {
            return new StorageSelectorApi();
        };
        StorageSelectorService.prototype.getStorageSelectorState = function () {
            var state = new StorageSelectorState();
            state.mode = "basicMode";
            return state;
        };
        StorageSelectorService.prototype.getStorageSelectorInitialConfig = function (selectedItemInBasicMode, storageProfile, replicationGroup) {
            var initialConfig = new StorageSelectorInitialConfig();
            initialConfig.selectedItemInBasicMode = selectedItemInBasicMode;
            initialConfig.selectedStorageProfileInBasicMode = storageProfile;
            initialConfig.selectedReplicationGroupInBasicMode = replicationGroup;
            return initialConfig;
        };
        StorageSelectorService.prototype.getStorageSelectorModeSettings = function (showAdvancedMode) {
            var settings = new StorageSelectorModeSettings();
            settings.showAdvancedMode = showAdvancedMode;
            return settings;
        };
        StorageSelectorService.prototype.getStorageSelectorData = function (objectId, storageLocatorItemsData, includeKeepExistingPolicies, vmData, storageProfilesData) {
            var _this = this;
            vmData = vmData || [];
            var vcGuid = this.defaultUriSchemeUtil.getPartsFromVsphereObjectId(objectId).serverGuid;
            var profileRequest = storageProfilesData
                ? this.$q.when(storageProfilesData)
                : this.storageProfileService.fetchStorageProfilesData(vcGuid, {
                    includeKeepExisting: includeKeepExistingPolicies
                });
            var requests = {
                storageLocatorItemsDataRequest: this.$q.when(storageLocatorItemsData),
                storageProfilesDataRequest: profileRequest
            };
            return this.$q.all(requests).then(function (response) {
                var selectorData = new StorageSelectorData();
                if (!response) {
                    return selectorData;
                }
                selectorData.storageLocatorItemsData = response.storageLocatorItemsDataRequest;
                selectorData.storageProfilesData = response.storageProfilesDataRequest;
                // Set the group labels for the storage profiles
                _.each(selectorData.storageProfilesData.storageProfiles, function (profile) {
                    // "Encryption" group label
                    var isEncryptionPolicy = _this.storageProfileService
                        .isEncryptionStorageProfile(profile);
                    if (isEncryptionPolicy) {
                        profile.groupLabel = _this.i18nService
                            .getString("Common", "storage.policy.dropdown.group.encryption");
                    }
                    else {
                        profile.groupLabel = "";
                    }
                    // Add logic for other group labels below..
                });
                var vmIds = [];
                _.forEach(vmData, function (vm) {
                    if (vm && vm.id) {
                        vmIds.push(vm.id);
                    }
                });
                if (!vmIds.length) {
                    var firstVmData = vmData && vmData.length ? vmData[0] : null;
                    // If there are no source VMs, create a dummy VmStorageConfig so that
                    // storageSelector have a way to report the selected storage, policy &
                    // disk format. This case should handle selecting storage for a
                    // new VM or Deploy from OVF/CL.
                    var storageConfig = _this.buildDummyVmConfig(selectorData.storageLocatorItemsData, selectorData.storageProfilesData, firstVmData);
                    selectorData.sourceVmStorageConfig = [storageConfig];
                    return selectorData;
                }
                // Request vm profile assignments
                var vmAssignmentsPromise;
                var isSpbmEnabled = selectorData.storageProfilesData && !selectorData.storageProfilesData.error;
                if (isSpbmEnabled) {
                    vmAssignmentsPromise = storageProfilesData && storageProfilesData.vmProfileAssignments
                        && storageProfilesData.vmReplicationGroupAssignments
                        ? _this.$q.when({
                            vmProfileAssignments: storageProfilesData.vmProfileAssignments,
                            vmReplicationGroupAssignments: storageProfilesData.vmReplicationGroupAssignments
                        })
                        : _this.storageProfileService.requestVmProfileAndReplicationGroupAssignments(vmIds);
                }
                else {
                    // Spbm service is down or the user doesn't have privileges.
                    vmAssignmentsPromise = _this.$q.when({
                        vmProfileAssignments: {},
                        vmReplicationGroupAssignments: {}
                    });
                }
                return vmAssignmentsPromise.then(function (vmAssignmentsResponse) {
                    selectorData.sourceVmStorageConfig = _.map(vmData, function (vm) {
                        return _this.buildVmConfig(vm, vmAssignmentsResponse.vmProfileAssignments[vm.id], isSpbmEnabled, vmAssignmentsResponse.vmReplicationGroupAssignments[vm.id], selectorData.storageLocatorItemsData, selectorData.storageProfilesData.storageProfiles);
                    });
                    return selectorData;
                });
            });
        };
        StorageSelectorService.prototype.buildDummyVmConfig = function (storageLocatorItemsData, storageProfilesData, dummyVmData) {
            if (!dummyVmData || _.isEmpty(dummyVmData.disksData)) {
                // We provide a default storage config with VM HOME and one disk.
                var storageConfig = new VmStorageConfig();
                storageConfig.vmHome = new VmComponentStorageConfig();
                storageConfig.vmDisks = [this.buildDummyDiskVmConfig()];
                return storageConfig;
            }
            // We don't have VM id, but we have some disk data (supposedly fake/dummy).
            var dummyVmProfileAssignments = this.buildDummyVmProfileAssignments(storageProfilesData, dummyVmData.disksData);
            dummyVmData.id = "undefined";
            return this.buildVmConfig(dummyVmData, dummyVmProfileAssignments, true /*spbmEnabled*/, [] /*replication group assignments*/, storageLocatorItemsData, storageProfilesData.storageProfiles);
        };
        StorageSelectorService.prototype.buildDummyDiskVmConfig = function () {
            var dummyDisk = new VmComponentStorageConfig();
            dummyDisk.name = "__placeholder_disk__";
            dummyDisk.key = -1;
            return dummyDisk;
        };
        StorageSelectorService.prototype.buildDummyVmProfileAssignments = function (storageProfilesData, dummyVmDisksData) {
            var result = {
                vm: {
                    value: undefined
                },
                homeStorageProfile: undefined,
                diskAssignments: []
            };
            _.each(dummyVmDisksData, function (virtualDisk) {
                if (!virtualDisk.$profileId) {
                    return;
                }
                var foundProfile = _.find(storageProfilesData.storageProfiles, function (profile) {
                    return (profile.id === virtualDisk.$profileId);
                });
                if (!foundProfile) {
                    return;
                }
                result.diskAssignments.push({
                    diskId: result.vm.value + ":" + virtualDisk.key,
                    profile: foundProfile.profileObj
                });
            });
            return result;
        };
        /**
         * Opens a dialog with storageSelector in basic mode.
         *
         * Returns a promise with StorageSelectorDialogData
         *
         * @param profilesData
         *    IStorageProfileData instance, will filter out keep existing policies option if present.
         *
         * @param storageLocatorItemsData
         *    Contains all available datastore and storagePOD items.
         *
         * @param initialData
         *    Optional param, if specified will be used to preselect the selected storage item and storage profile.
         *
         * @param podDisplayDisabled
         *    Don't show storage pods.
         *
         * @param disableDefaultPreselection
         *    Controls default preselection.
         *
         * @param destinationHostId
         *    Optional parameter, can specify compute resource which will be used to access the datastore.
         *    If provided will be used to determine the applicable replication groups for the
         *    selected storage policy and datastore. Used only when showReplicationGroups is TRUE.
         *
         * @param showReplicationGroups
         *    Optional parameter, if set to TRUE the storage selector dialog will show
         *    replication group selector in case there are available replication groups for
         *    the selected datastore and storage policy.
         * @param isVmHome
         *    Optional parameter indicating whether storage will be browsed for vm home
         *    location (vm config files) or for a vm disk.
         *    Default is true (browse for vm home location)
         */
        StorageSelectorService.prototype.browseForStorage = function (storageLocatorItemsData, profilesData, initialData, podDisplayDisabled, disableDefaultPreselection, destinationHostId, showReplicationGroups, isEncryptionOptionsDisabled, isVmHome, isPmemOptionDisabled) {
            var _this = this;
            if (isVmHome === void 0) { isVmHome = true; }
            if (isPmemOptionDisabled === void 0) { isPmemOptionDisabled = false; }
            showReplicationGroups = showReplicationGroups || false; // default value false
            // show only basic mode
            var selectorModeSettings = this.getStorageSelectorModeSettings(false);
            // hide disk format options
            var diskFormatSettings = new StorageSelectorDiskFormatSettings();
            diskFormatSettings.diskFormatSupported = false;
            // initialize storage selector data with single VmStorageConfig containing
            // only one VM home component.
            var storageSelectorData = new StorageSelectorData();
            var storageConfig = new VmStorageConfig();
            storageConfig.destinationHostId = destinationHostId;
            var componentConfig = new VmComponentStorageConfig();
            if (isVmHome) {
                storageConfig.vmHome = componentConfig;
            }
            else {
                storageConfig.vmDisks = [componentConfig];
            }
            storageSelectorData.sourceVmStorageConfig = [storageConfig];
            // Set the initial configuration in case initialData param is provided or valid.
            if (initialData) {
                // Validate the initial data property.
                componentConfig.storageProfile = initialData.storageProfile;
                componentConfig.storageObj = initialData.storageObj;
                var profileToSelect = null;
                if (initialData.storageProfile
                    && !this.storageProfileService.isPmemStorageProfile(initialData.storageProfile)) {
                    profileToSelect = _.find(profilesData.storageProfiles, function (profile) {
                        return (initialData.storageProfile &&
                            profile.id === initialData.storageProfile.id &&
                            profile.label === initialData.storageProfile.label);
                    }) || null;
                }
                storageSelectorData.initialConfig = this.getStorageSelectorInitialConfig(initialData.storageObj, profileToSelect, initialData.replicationGroup);
            }
            // create new IStorageProfileData instance by filtering out the keep existing profiles option.
            storageSelectorData.storageProfilesData = {
                storageProfiles: _.filter(profilesData.storageProfiles, function (profile) {
                    return !profile.keepExistingProfileAssignments;
                }),
                selectedProfile: null,
                error: profilesData.error
            };
            storageSelectorData.storageLocatorItemsData = storageLocatorItemsData;
            var storageSelectorApi = this.getStorageSelectorApiObj();
            var deferredResult = this.$q.defer();
            var modalOptions = {
                contentTemplate: "resources/ui/components/storageLocator/storageSelectorDialog.html",
                title: this.i18nService.getString("Common", "StorageLocatorDialog.Title"),
                defaultButton: "submit",
                size: "lg",
                dialogData: {
                    modeSettings: selectorModeSettings,
                    storageSelectorState: this.getStorageSelectorState(),
                    storageSelectorData: storageSelectorData,
                    storageSelectorApi: storageSelectorApi,
                    diskFormatSettings: diskFormatSettings,
                    podDisplayDisabled: podDisplayDisabled,
                    disableDefaultPreselection: disableDefaultPreselection,
                    showReplicationGroups: showReplicationGroups,
                    isEncryptionOptionsDisabled: isEncryptionOptionsDisabled,
                    isPmemOptionDisabled: isPmemOptionDisabled
                },
                alerts: [],
                onSubmit: function () {
                    var validationError = storageSelectorApi.validateSelection() ||
                        storageSelectorApi.validateReplicationGroupSelection();
                    if (validationError) {
                        modalOptions.alerts = [{
                                text: validationError,
                                type: _this.clarityConstants.notifications.type.ERROR
                            }];
                        return false;
                    }
                    var result = new StorageSelectorDialogData();
                    if (isVmHome) {
                        result.storageObj = storageSelectorData.vmStorageConfig[0].getVmHomeStorage();
                        result.storageProfile = storageSelectorData.vmStorageConfig[0].getVmHomeProfile();
                        result.replicationGroup = storageSelectorData.vmStorageConfig[0].vmHome
                            ? storageSelectorData.vmStorageConfig[0].vmHome.replicationGroup
                            : null;
                    }
                    else {
                        result.storageObj = storageSelectorData.vmStorageConfig[0].vmDisks[0].storageObj;
                        result.storageProfile = storageSelectorData.vmStorageConfig[0].vmDisks[0].storageProfile;
                        result.replicationGroup = storageSelectorData.vmStorageConfig[0].vmDisks[0].replicationGroup;
                    }
                    deferredResult.resolve(result);
                    return true;
                },
                onCancel: function () {
                    deferredResult.resolve(null);
                    return true;
                }
            };
            this.clarityModalService.openOkCancelModal(modalOptions);
            return deferredResult.promise;
        };
        StorageSelectorService.prototype.getRgAssignment = function (rgAssignments, id) {
            var result = null;
            if (rgAssignments) {
                rgAssignments.forEach(function (assignment) {
                    if (assignment && assignment.vmObjectId === id) {
                        result = assignment.replicationGroup;
                    }
                });
            }
            return result;
        };
        StorageSelectorService.prototype.buildVmConfig = function (vmData, vmProfileAssignments, isSpbmEnabled, vmReplicationGroupAssignments, storageLocatorItemsData, profiles) {
            var _this = this;
            var vmConfig = new VmStorageConfig();
            vmConfig.vmId = vmData.id;
            vmConfig.vmName = vmData.name;
            vmConfig.vmHome = new VmComponentStorageConfig();
            vmConfig.vmHome.name = this.i18nService.getString("Common", "DiskLocatorControl.fileType.configuration");
            vmConfig.vmHome.storageObj = this.getStorageObjectFromId(vmData.homeDatastore, storageLocatorItemsData);
            vmConfig.destinationHostId = vmData.destinationHost;
            var vmMorValue = this.defaultUriSchemeUtil.getPartsFromVsphereObjectId(vmData.id).value;
            vmConfig.vmHome.replicationGroup =
                this.getRgAssignment(vmReplicationGroupAssignments, vmMorValue);
            if (vmProfileAssignments && vmProfileAssignments.homeStorageProfile) {
                vmConfig.vmHome.storageProfile = this.buildProfileItem(vmProfileAssignments.homeStorageProfile, profiles);
            }
            else if (isSpbmEnabled) {
                vmConfig.vmHome.storageProfile = this.storageProfileService.getDefaultProfile();
            }
            vmConfig.vmDisks = _.map(vmData.disksData, function (virtualDisk) {
                var vmDiskConfig = new VmComponentStorageConfig();
                vmDiskConfig.key = virtualDisk.key;
                vmDiskConfig.name = _this.getVirtualDiskLabel(virtualDisk);
                vmDiskConfig.storageObj = _this.getStorageObjectFromId(_this.defaultUriSchemeUtil.getVsphereObjectId(virtualDisk.backing.datastore), storageLocatorItemsData);
                vmDiskConfig.capacityInBytes = virtualDisk.capacityInBytes;
                vmDiskConfig.replicationGroup = _this.getRgAssignment(vmReplicationGroupAssignments, vmMorValue + ":" + virtualDisk.key);
                if (vmProfileAssignments) {
                    // get disk profile
                    var diskId_1 = vmProfileAssignments.vm.value + ":" + virtualDisk.key;
                    var diskProfileAssignment = _.find(vmProfileAssignments.diskAssignments, function (diskData) { return diskId_1 === diskData.diskId; });
                    if (diskProfileAssignment && diskProfileAssignment.profile) {
                        vmDiskConfig.storageProfile = _this.buildProfileItem(diskProfileAssignment.profile, profiles);
                    }
                }
                // If disk is using PMEM unset storage object.
                // PMEM datastore should not be visible in UI.
                if (_this.storageProfileService.isPmemStorageProfile(vmDiskConfig.storageProfile)) {
                    vmDiskConfig.storageObj = undefined;
                }
                if (!vmDiskConfig.storageProfile && isSpbmEnabled) {
                    vmDiskConfig.storageProfile = _this.storageProfileService.getDefaultProfile();
                }
                //VM ID won't be available during deploy template workflows.
                if (vmConfig.vmId === "undefined") {
                    vmDiskConfig.diskGroupName = virtualDisk.deviceInfo.label;
                }
                return vmDiskConfig;
            });
            return vmConfig;
        };
        StorageSelectorService.prototype.getVirtualDiskLabel = function (virtualDisk) {
            var capacity = this.bytesFilter(virtualDisk.capacityInKB, "KB", "Auto", 2);
            return this.i18nService.interpolate("{0} ({1})", [virtualDisk.deviceInfo.label, capacity]);
        };
        StorageSelectorService.prototype.buildProfileItem = function (profile, profiles) {
            if (!profile) {
                return null;
            }
            return _.find(profiles, function (storageProfile) {
                return storageProfile.id === profile.profileId.uniqueId;
            }) || null;
        };
        StorageSelectorService.prototype.getStorageObjectFromId = function (storageId, storageLocatorItemsData) {
            var _this = this;
            if (!storageId || !storageLocatorItemsData) {
                return null;
            }
            var datastoreObj = _.find(storageLocatorItemsData.datastoreItems, function (dastoreItem) {
                return _this.defaultUriSchemeUtil.getVsphereObjectId(dastoreItem.storageRef) === storageId;
            });
            if (datastoreObj) {
                return datastoreObj;
            }
            var storagePodObj = _.find(storageLocatorItemsData.storagePodItems, function (storagePodItem) {
                return _this.defaultUriSchemeUtil.getVsphereObjectId(storagePodItem.storageRef) === storageId;
            });
            return storagePodObj || null;
        };
        StorageSelectorService.$inject = ["$q", "i18nService", "storageProfileService",
            "defaultUriSchemeUtil", "bytesFilter",
            "clarityModalService", "clarityConstants"];
        return StorageSelectorService;
    }());
    common_ui.StorageSelectorService = StorageSelectorService;
    angular.module("com.vmware.platform.ui")
        .service("storageSelectorService", StorageSelectorService);
})(common_ui || (common_ui = {}));



/* Copyright 2018 Vmware, Inc. All rights reserved. -- VMware Confidential */
var common_ui;
(function (common_ui) {
    /**
     * Wrapper component designed specifically to upgrade StorageSelector directive and
     * allow storage selector usage in angular.next components.
     * This component is not intended to be used by angular 1.5 components. For this
     * purpose the StorageSelector directive should continue to be used.
     */
    var UpgradableStorageSelector = (function () {
        function UpgradableStorageSelector() {
            this.controller = UpgradableStorageSelectorController;
            this.bindings = {
                modeSettings: "=?",
                onSelectionChanged: "&",
                storageSelectorState: "=",
                storageSelectorData: "=",
                storageSelectorApi: "=",
                diskFormatSettings: "=?",
                disableDefaultPreselectionInBasicMode: "<?",
                ensurePreselectionVisibilityInBasicMode: "<?",
                podDisplayDisabled: "<?",
                showReplicationGroups: "<?",
                showStorageBaselineSignpostHints: "<?",
                unsupportedStorageBaselineIds: "<?",
                isVmtxWorkflow: "<?",
                isDiskGroupsAvailable: "<?",
                showEncryptionOptions: "<?",
                isEncryptionOptionsDisabled: "<?",
                encryptionOptionsDisabledReason: "<?"
            };
            this.template =
                "<storage-selector class=\"display-flex-col\"\n                  mode-settings=\"$ctrl.modeSettings\"\n                  on-selection-changed=\"$ctrl.onSelectionChanged()\"\n                  storage-selector-state=\"$ctrl.storageSelectorState\"\n                  storage-selector-data=\"$ctrl.storageSelectorData\"\n                  storage-selector-api=\"$ctrl.storageSelectorApi\"\n                  disk-format-settings=\"$ctrl.diskFormatSettings\"\n                  disable-default-preselection-in-basic-mode=\"$ctrl.disableDefaultPreselectionInBasicMode\"\n                  ensure-preselection-visibility-in-basic-mode=\"$ctrl.ensurePreselectionVisibilityInBasicMode\"\n                  pod-display-disabled=\"$ctrl.podDisplayDisabled\"\n                  show-replication-groups=\"$ctrl.showReplicationGroups\"\n                  show-storage-baseline-signpost-hints=\"$ctrl.showStorageBaselineSignpostHints\"\n                  unsupported-storage-baseline-ids=\"$ctrl.unsupportedStorageBaselineIds\"\n                  is-vmtx-workflow=\"$ctrl.isVmtxWorkflow\"\n                  is-disk-groups-available=\"$ctrl.isDiskGroupsAvailable\"\n                  show-encryption-options=\"$ctrl.showEncryptionOptions\"\n                  is-encryption-options-disabled=\"$ctrl.isEncryptionOptionsDisabled\"\n                  encryption-options-disabled-reason=\"$ctrl.encryptionOptionsDisabledReason\"\n               ></storage-selector>";
        }
        return UpgradableStorageSelector;
    }());
    common_ui.UpgradableStorageSelector = UpgradableStorageSelector; // class
    var UpgradableStorageSelectorController = (function () {
        function UpgradableStorageSelectorController() {
        }
        return UpgradableStorageSelectorController;
    }()); // class
    angular.module("com.vmware.platform.ui").component("vxUpgradableStorageSelector", new UpgradableStorageSelector());
})(common_ui || (common_ui = {})); // namespace



angular.module('com.vmware.platform.ui').directive('storageProfile', [
   function () {
      return {
         scope: {
            selectedStorageProfile: '=',
            storageProfiles: '=',
            readOnly: '=',
            warning: '=',
            errorConfig: '=',
            onChangeCallback: '&',
            selectAriaLabel: '<?'
         },
         templateUrl: 'resources/ui/components/storageProfile/storageProfile.html'
      };
   }]);

angular.module('com.vmware.platform.ui').directive('vxTabPane', [
   function() {
      return {
         link: function($scope, element){
            var tabId = element.attr('vx-tab-pane');

            $scope.$on('vxTab.showTab', function(event, tabBeingShown){
               if(tabBeingShown === tabId) {
                  $scope.$eval(element.attr('vx-tab-on-show'));
               }
            });
         }
      };
   }
]);
/**
 * vx-tabs
 *
 * A directive that supports switching between active tabs.
 * Currently, it only adds/removes the `active` class from
 * the tab and content for the selected/unselected element.
 *
 * If the `vx-tab-pane` has a `vx-tab-on-show`, the callback
 * will be called when the tab is shown.
 *
 * If you need to size tabs with flexbox, you'll need to add
 * `vx-tabs-flexy` to the `vx-tabs` element. This will replace
 * `display: block` of the active `vx-tab-pane` with `display: flex`
 *
 * Markup:
 * <div vx-tabs class="styleguide-tabs">
 * 	<div vx-tab-headers>
 * 	   <div class="btn-group nav-secondary">
 * 		   <div vx-tab-header="myFirstTab" class="btn btn-default active">Look at this tab</div>
 * 		   <div vx-tab-header="mySecondTab" class="btn btn-default">And this other one</div>
 * 		</div>
 * 	</div>
 * 	<div vx-tab-content>
 * 		<div vx-tab-pane="myFirstTab" class="active">
 * 			Isn't this content great
 * 		</div>
 * 		<div vx-tab-pane="mySecondTab" vx-tab-on-show="myAwesomeCallback()">
 * 			So much tab
 * 		</div>
 * 	</div>
 * </div>
 *
 * Style guide: vx.tabs
 */

angular.module('com.vmware.platform.ui').directive('vxTabs', [ '$timeout',
   function($timeout) {
      return {
         link: function($scope, element, attributes){
            var initialTabId = attributes.vxTabsInitialActiveTab;
            if(initialTabId) {
               activateTab(element, initialTabId, $scope);
            }

            element.on('click', '[vx-tab-header]', function(event) {
               var clickedHeader = $(event.currentTarget);
               if(clickedHeader.hasClass('active')) {
                  return;
               }
               var tabId = clickedHeader.attr('vx-tab-header');
               activateTab(element, tabId, $scope);
            });

            // TODO remove temp patch
            // update it to get called when the content element size (tabContentSection)
            //  var clickedHeader = $(event.currentTarget);
            //  var contentId = clickedHeader.attr("id").replace("Link","Content");
            //  var tabContentSection = element.find("#"+contentId).find("section");
            // is available
            element.on('click', 'clr-tab-link', function(event) {
                $timeout(function () {
                    $scope.$broadcast('resize');
                }, 0);
            });
         }
      };
      function activateTab(element, tabId, $scope) {
         element.find('[vx-tab-header].active').removeClass('active');
         element.find('[vx-tab-pane].active').removeClass('active');
         element.find('[vx-tab-header="' + tabId + '"]').addClass('active');
         element.find('[vx-tab-pane="' + tabId + '"]').addClass('active');
         $scope.$broadcast('vxTab.showTab', tabId);
         $scope.$broadcast('resize');
      }
   }
]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Directive to display tabs.
 *
 * Usage:
 * <div vx-view-tabs="tabs"></div>
 * Where 'tabs' is an array of vx-view nodes to render
 */
angular.module('com.vmware.platform.ui').directive('vxViewTabs', ['navigation',
   function(navigation) {
      return {
         scope: {
            tabs: '=vxViewTabs',
         },
         template: "<div class='fill-parent'> " +
         "<ul class='nav nav-tabs'> " +
            "<li ng-class='{active: isSelected($index)}' ng-repeat='tab in tabs'>" +
               "<a ng-click='switchTab($index)'>" +
               "<i class='{{tab.icon}}'></i>{{tab.title}}</a>" +
            "</li>" +
         "</ul>" +
         "<div class = 'tab-content fill-parent' vx-view = 'getSelectedTab()'> </div>" +
         "</div>",
         link: function($scope) {
            navigation.populateScope($scope);
            init();
            // set first tab as selected
            function init() {
               $scope.selectedTabId = 0;
            }

            //--------------------- scope functions -------------------

            /*
             * Set given tabId as the selectedTabId
             * @param tabId
             */
            $scope.switchTab = function(tabId) {
               $scope.selectedTabId = tabId;
            };

            /*
             * Returns true if the selectedTabId is equal to the given tabId
             * @param tabId
             */
            $scope.isSelected = function(tabId) {
               return $scope.selectedTabId === tabId;
            };

            /*
             * Get the selectedTab.
             */
            $scope.getSelectedTab = function() {
               if (angular.isDefined($scope.tabs) && angular.isArray($scope.tabs)) {
                  return $scope.tabs[$scope.selectedTabId];
               }
            };
         }
      };
   }]);
/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * This directive compiles a template string and inserts it in the DOM.
 * It helps reuse column renderers.
 */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxTemplate', vxTemplate);

   vxTemplate.$inject = ['$compile'];

   function vxTemplate($compile) {
      return {
         restrict: 'A',
         link: function(scope, element, attrs) {
            attrs.$observe('vxTemplate', function(template) {
               if (template) {
                  // compile the provided template against the current scope
                  var contentElement = $compile(template)(scope);

                  element.empty();
                  // add the template content
                  element.append(contentElement);
               }
            });
         }
      };
   }
})();
/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */

(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').directive('vxTimePicker', [vxTimePicker]);

   function vxTimePicker() {
      var VALUE_MOMENT_FORMATS = ["HH:mm:ss", "HH:mm"];
      var DISPLAY_VALUE_MOMENT_FORMATS = ['HH:mm:ss', 'HH:mm'];

      return {
         restrict: "A",
         require: "ngModel",
         link: function(scope, element, attrs, ngModelCtrl) {

            function formatTime(value) {
               if (typeof value !== 'string') {
                  return '';
               }

               var valueMoment =
                     moment(value, VALUE_MOMENT_FORMATS, true);
               if (!valueMoment.isValid()) {
                  return '';
               }

               return valueMoment.format(DISPLAY_VALUE_MOMENT_FORMATS[0]);
            }

            function parseTime(displayValue) {
               if (typeof displayValue !== 'string') {
                  return '';
               }

               var displayValueMoment =
                     moment(displayValue, DISPLAY_VALUE_MOMENT_FORMATS, true);
               if (!displayValueMoment.isValid()) {
                  return '';
               }

               return displayValueMoment.format(VALUE_MOMENT_FORMATS[0]);
            }

            ngModelCtrl.$formatters.push(formatTime);
            ngModelCtrl.$parsers.push(parseTime);
         }
      };
   }
})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Enhanced version of ng-transclude
 *
 * Supports a onTransclude function which will be called with the transcludedScope supplied.
 * <div vx-transclude="onTransclude($transcludedScope)"></div>
 *
 * TODO: contribute back to ng-transclude?
 */
angular.module('com.vmware.platform.ui').directive('vxTransclude', function() {
          return {
             controller: ['$transclude', '$element', '$attrs', '$parse', '$scope',
                function($transclude, $element, $attrs, $parse, $scope) {
                   $transclude(function(clone, transcludedScope) {
                     $element.append(clone);

                     // invokes the onTransclude function
                     var getter = $parse($attrs.vxTransclude);
                     getter($scope, {
                        $transcludedScope: transcludedScope
                     });

                });
              }]
          };
        });
/**
 * Tree list directive that creates a kendo tree list.
 *
 * Example:
 * <div vx-tree-list vx-tree-list-options="treeListOptions"></div>
 *
 * @name treeListOptions
 * @description
 *    Configuration object for tree list view.
 *    Contains properties to specify a TreeList and populate it with data.
 *
 *    Example:
 *    ```js
 *    var treeListOptions =  {
 *                dataSource: {
 *                   data: [
 *                      { id: 1, Name: "Root item 1", Status: "Normal", parentId: null },
 *                      { id: 2, Name: "Root item 2", Status: "Warning", parentId: null },
 *                      { id: 34, Name: "First child of the root item 1", Status: "N/A", parentId: 1 },
 *                      { id: 67, Name: "First child of the root item 2", Status: "Warning", parentId: 2 },
 *                      { id: 72, Name: "Second child of the root item 2", Status: "Error", parentId: 2 },
 *                      ....
 *                   ],
 *                   schema: {
 *                      model: {
 *                         id: "id",
 *                         expanded: false
 *                      }
 *                   }
 *                },
 *                sortable: true,
 *                height : '100%',
 *                width: '100%',
 *                columns: [
 *                   { field: "Name", title: "Name", width: "150px" },
 *                   { field: "Status" }
 *                ],
 *                resizable: true,
 *                selectable: "row"
 *             };
 */
angular.module('com.vmware.platform.ui').directive('vxTreeList', function() {
   'use strict';

   return {
      restrict: 'A',
      scope: {
         'vxTreeListOptions': '='
      },
      link: function(scope, element, attrs) {
         var kendoTreeListWidget = null;

         function bindWidgetInParentScope() {
            if (!attrs['vxTreeList'] || !kendoTreeListWidget) {
               return;
            }

            scope.$parent.$eval(
                  attrs['vxTreeList'] + ' = ' + '$vxTreeListWidget',
                  { '$vxTreeListWidget': kendoTreeListWidget }
            );
         }


         scope.$watch('vxTreeListOptions.dataSource', function(value) {
            if (!kendoTreeListWidget) {
               return;
            }

            kendoTreeListWidget.setDataSource(value);
         });

         if (scope.vxTreeListOptions) {
            var oldDataSource = scope.vxTreeListOptions.dataSource;
            kendoTreeListWidget = element.kendoTreeList(
                  scope.vxTreeListOptions
            ).data('kendoTreeList');
            var newDataSource = scope.vxTreeListOptions.dataSource;

            bindWidgetInParentScope();

            if (!angular.equals(newDataSource, oldDataSource)) {
               kendoTreeListWidget.setDataSource(scope.vxTreeListOptions.dataSource);
            }
         } else {
            var unbindWatcher = scope.$watch('vxTreeListOptions', function() {
               if (!kendoTreeListWidget && scope.vxTreeListOptions) {
                  kendoTreeListWidget = element.kendoTreeList(
                        scope.vxTreeListOptions
                  ).data('kendoTreeList');
                  bindWidgetInParentScope();
                  unbindWatcher();
               }
            });
         }
      }
   };
});

/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    "use strict";
    var TreeSelectionError = (function () {
        function TreeSelectionError() {
            this.name = "selection";
        }
        return TreeSelectionError;
    }());
    platform.TreeSelectionError = TreeSelectionError;
    var TreeViewErrorConstants = (function () {
        function TreeViewErrorConstants() {
        }
        TreeViewErrorConstants.SELECTION = new TreeSelectionError();
        return TreeViewErrorConstants;
    }());
    platform.TreeViewErrorConstants = TreeViewErrorConstants;
    angular.module("com.vmware.platform.ui")
        .constant("treeViewErrorConstants", TreeViewErrorConstants);
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var platform;
(function (platform) {
    'use strict';
    var CollectorKind;
    (function (CollectorKind) {
        CollectorKind[CollectorKind["Change"] = 0] = "Change";
        CollectorKind[CollectorKind["Children"] = 1] = "Children";
    })(CollectorKind || (CollectorKind = {}));
    /**
     * Service that holds different buffers for tree live updates and performs server
     * data fetch operations on a given time interval.
     */
    var TreeLiveUpdateBufferService = (function () {
        function TreeLiveUpdateBufferService($rootScope, $timeout, $http, treeNodeService, logService, configurationService, $log) {
            var _this = this;
            this.$rootScope = $rootScope;
            this.$timeout = $timeout;
            this.$http = $http;
            this.treeNodeService = treeNodeService;
            this.logService = logService;
            this.configurationService = configurationService;
            this.$log = $log;
            this.collectors = {};
            $rootScope.$on("$destroy", function () {
                _this.collectors = {};
            });
        }
        /**
         * Create a new change update buffer for the given treeId.
         *
         * Overrides previous buffer if any.
         *
         * @param treeId              The tree id.
         * @param httpDoneCallback    Called on each successful http request.
         *    Callback in the following format:
         *
         *       function(serverData, bufferMap);
         *
         *    `serverData`   is the server response.
         *    `bufferMap`    contains the buffered entries by objectIds.
         */
        TreeLiveUpdateBufferService.prototype.createChangeBuffer = function (treeId, httpDoneCallback) {
            var _this = this;
            if (!this.collectors[treeId]) {
                this.collectors[treeId] = {};
            }
            if (this.collectors[treeId][CollectorKind.Change]) {
                this.collectors[treeId][CollectorKind.Change].destroy();
            }
            this.collectors[treeId][CollectorKind.Change] = new ChangeUpdateCollector(new ChangeUpdateBuffer(), this.$timeout, this.logService('treeLiveChangeUpdateBuffer'), this.configurationService, httpDoneCallback, function (bufferMap) {
                return _this.$http({
                    method: 'POST',
                    url: 'tree/propertiesByObjectIds',
                    skipLoadingNotification: true,
                    data: {
                        objectIds: Object.keys(bufferMap)
                    }
                }).then(function (resp) {
                    // { objectId => properties } mapping
                    return resp ? resp.data || {} : {};
                });
            });
        };
        /**
         * Create a new children update buffer for the given treeId.
         *
         * Overrides previous buffer if any.
         *
         * @param treeId              The tree id.
         * @param httpDoneCallback    Called on each successful http request.
         *    Callback in the following format:
         *
         *       function(serverData, bufferMap);
         *
         *    `serverData`   is the server response.
         *    `bufferMap`    contains the buffered entries by objectIds.
         */
        TreeLiveUpdateBufferService.prototype.createChildrenBuffer = function (treeId, httpDoneCallback) {
            var _this = this;
            if (!this.collectors[treeId]) {
                this.collectors[treeId] = {};
            }
            if (this.collectors[treeId][CollectorKind.Children]) {
                this.collectors[treeId][CollectorKind.Children].destroy();
            }
            this.collectors[treeId][CollectorKind.Children] = new ChildrenUpdateCollector(new ChildrenUpdateBuffer(), this.$timeout, this.logService('treeLiveChildrenUpdateBuffer'), this.configurationService, httpDoneCallback, function (bufferMap) {
                var parents = _.values(bufferMap);
                var parentsAsJson = JSON.stringify(parents);
                _this.$log.debug("TreeLiveUpdateBufferService: calling treeNodeService#getChildrenByObjectIds for '"
                    + parentsAsJson + "'");
                // { objectId => children } mapping
                return _this.treeNodeService.getChildrenByObjectIds(treeId, parents);
            });
        };
        /**
         * Destroy existing change update buffer for the given treeId.
         *
         * @param treeId              The tree id.
         * @returns {boolean}         False if the buffer does not exist.
         */
        TreeLiveUpdateBufferService.prototype.destroyChangeBuffer = function (treeId) {
            if (!this.collectors[treeId] || !this.collectors[treeId][CollectorKind.Change]) {
                return false;
            }
            this.collectors[treeId][CollectorKind.Change].destroy();
            delete this.collectors[treeId][CollectorKind.Change];
            return true;
        };
        /**
         * Destroy existing children update buffer for the given treeId.
         *
         * @param treeId              The tree id.
         * @returns {boolean}         False if the buffer does not exist.
         */
        TreeLiveUpdateBufferService.prototype.destroyChildrenBuffer = function (treeId) {
            if (!this.collectors[treeId] || !this.collectors[treeId][CollectorKind.Children]) {
                return false;
            }
            this.collectors[treeId][CollectorKind.Children].destroy();
            delete this.collectors[treeId][CollectorKind.Children];
            return true;
        };
        /**
         * Add a new change update to the given treeId's change update buffer.
         *
         * @param treeId              The tree id.
         * @param objectId            The object id. Will be used as a key for the given entry.
         * @param entry               The data that will be buffered.
         * @returns {boolean}         False if the buffer does not exist.
         */
        TreeLiveUpdateBufferService.prototype.addChangeEntry = function (treeId, objectId, entry) {
            if (!this.collectors[treeId] || !this.collectors[treeId][CollectorKind.Change]) {
                return false;
            }
            this.collectors[treeId][CollectorKind.Change].addEntry(objectId, entry);
            return true;
        };
        /**
         * Add a new children update to the given treeId's children update buffer.
         *
         * @param treeId              The tree id.
         * @param objectId            The object id. Will be used as a key for the given entry.
         * @param entry               The data that will be buffered.
         * @returns {boolean}         False if the buffer does not exist.
         */
        TreeLiveUpdateBufferService.prototype.addChildrenEntry = function (treeId, objectId, entry) {
            if (!this.collectors[treeId] || !this.collectors[treeId][CollectorKind.Children]) {
                return false;
            }
            this.collectors[treeId][CollectorKind.Children].addEntry(objectId, entry);
            return true;
        };
        TreeLiveUpdateBufferService.$inject = [
            "$rootScope",
            "$timeout",
            "$http",
            "treeNodeService",
            "logService",
            "configurationService",
            "$log"
        ];
        return TreeLiveUpdateBufferService;
    }());
    platform.TreeLiveUpdateBufferService = TreeLiveUpdateBufferService;
    /**
     * The common base class for live update collectors.
     *
     * Collectors handle the throttling and the server data retrieval.
     * For internal data buffering they use a variant of `LiveUpdateBuffer`.
     *
     * The throttling algorithm for a given throttle interval is as follows:
     *    1. A server call is made immediately when the first entry is added and
     *       a throttle timer is started.
     *
     *    2. All new entries are buffered until both the http call and
     *       the throttle timer are due.
     *
     *    3. When the http call is done the given callback is executed.
     *
     *    4. When both the http call and the throttle timer are due a check is made whether
     *       new entries have been added to the buffer in that period.
     *
     *    5. If so an http call is made and a new throttle timer starts. Otherwise the
     *       collector is in it's initial state and the process repeats.
     *
     * The throttle interval is configurable from `webclient.properties` with the key
     * `live.updates.navtree.throttle.interval`:
     *
     *    negative number stands for using the default value,
     *    0 disables the throttling,
     *    positive number overrides the default value.
     *
     * If live.updates.navtree.throttle.interval is missing in the
     * webclient.properties file, the interval will be set to its default value
     * `LIVE_UPDATES_THROTTLE_INTERVAL_MS`
     */
    var LiveUpdateCollector = (function () {
        function LiveUpdateCollector(buffer, $timeout, logger, configurationService, callback, getData) {
            this.buffer = buffer;
            this.$timeout = $timeout;
            this.logger = logger;
            this.configurationService = configurationService;
            this.callback = callback;
            this.getData = getData;
            this.timer = new Timer();
            this.isHttpAndThrottleDone = true;
        }
        LiveUpdateCollector.prototype.destroy = function () {
            // Prevent calling of consumer callback after destruction
            this.callback = angular.noop;
        };
        LiveUpdateCollector.prototype.addEntry = function (objectId, entry) {
            this.buffer.addEntry(objectId, entry);
            if (this.isHttpAndThrottleDone) {
                this.flushBuffer();
            }
        };
        LiveUpdateCollector.prototype.flushBuffer = function () {
            var _this = this;
            var bufferMap = this.buffer.getMapAndReset();
            this.isHttpAndThrottleDone = false;
            this.timer.start();
            this.getData(bufferMap)
                .then(function (data) {
                _this.callback(data, bufferMap);
                _this.throttle();
            }, function (err) {
                _this.logger.warn(err);
                _this.throttle();
            });
        };
        LiveUpdateCollector.prototype.throttle = function () {
            var _this = this;
            this.configurationService.getProperty('live.updates.navtree.throttle.interval')
                .then(function (prop) {
                var throttleInterval = parseInt(prop);
                if (isNaN(throttleInterval) || throttleInterval < 0) {
                    throttleInterval = LiveUpdateCollector.LIVE_UPDATES_THROTTLE_INTERVAL_MS;
                }
                var wait = throttleInterval - _this.timer.elapsed();
                wait = wait < 0 ? 0 : wait;
                _this.$timeout(function () {
                    _this.isHttpAndThrottleDone = true;
                    if (!_this.buffer.isEmpty()) {
                        // If the buffer is not empty we need initiate another http call
                        // for the values in the buffer.
                        _this.flushBuffer();
                    }
                }, wait);
            });
        };
        LiveUpdateCollector.LIVE_UPDATES_THROTTLE_INTERVAL_MS = 1 * 1000;
        return LiveUpdateCollector;
    }());
    var ChangeUpdateCollector = (function (_super) {
        __extends(ChangeUpdateCollector, _super);
        function ChangeUpdateCollector() {
            _super.apply(this, arguments);
        }
        return ChangeUpdateCollector;
    }(LiveUpdateCollector));
    var ChildrenUpdateCollector = (function (_super) {
        __extends(ChildrenUpdateCollector, _super);
        function ChildrenUpdateCollector() {
            _super.apply(this, arguments);
        }
        return ChildrenUpdateCollector;
    }(LiveUpdateCollector));
    /**
     * The common base class for live update buffers.
     */
    var LiveUpdateBuffer = (function () {
        function LiveUpdateBuffer() {
            this.map = {};
        }
        LiveUpdateBuffer.prototype.getMapAndReset = function () {
            var oldMap = this.map;
            this.map = {};
            return oldMap;
        };
        LiveUpdateBuffer.prototype.addEntry = function (objectId, entry) {
            this.map[objectId] = entry;
        };
        LiveUpdateBuffer.prototype.isEmpty = function () {
            return !Object.keys(this.map).length;
        };
        return LiveUpdateBuffer;
    }());
    /**
     * Mapping objectId to the last update for that object.
     *
     * NOTE: Non-rename updates don't override name updates.
     */
    var ChangeUpdateBuffer = (function (_super) {
        __extends(ChangeUpdateBuffer, _super);
        function ChangeUpdateBuffer() {
            _super.apply(this, arguments);
        }
        ChangeUpdateBuffer.prototype.addEntry = function (objectId, update) {
            if (!this.map[objectId] || update.data.isNameUpdate) {
                this.map[objectId] = update;
            }
        };
        return ChangeUpdateBuffer;
    }(LiveUpdateBuffer));
    /**
     * Mapping objectId to parent info.
     */
    var ChildrenUpdateBuffer = (function (_super) {
        __extends(ChildrenUpdateBuffer, _super);
        function ChildrenUpdateBuffer() {
            _super.apply(this, arguments);
        }
        return ChildrenUpdateBuffer;
    }(LiveUpdateBuffer));
    /**
     * Simple timer
     */
    var Timer = (function () {
        function Timer() {
            this.startTime = 0;
        }
        Timer.prototype.start = function () {
            this.startTime = _.now();
        };
        Timer.prototype.elapsed = function () {
            return _.now() - this.startTime;
        };
        return Timer;
    }());
    angular.module('com.vmware.platform.ui')
        .service('treeLiveUpdateBufferService', TreeLiveUpdateBufferService);
})(platform || (platform = {}));



/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service for retrieving tree nodes from the backend
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('treeNodeService', treeNodeService);

   treeNodeService.$inject = ['$http', 'logService'];

   /**
    * Keeps a mapping between object aliases and primary object Id associated with a specific tree node.
    * Certain objects are not displayed in the tree (e.g. root resource pool of standalone host or cluster etc.), but
    * we still need to be able to map them to a specific tree node, so when we get a children_updated for those objects
    * we update children of the associated tree node.
    */
   var objAliasesToPrimaryObjId = {};

   function treeNodeService($http, logService) {

      var log = logService('treeONodeService');

      //Public API
      var service = {
         getRoot: getRoot,
         getChildren: getChildren,
         getChildrenByObjectIds: getChildrenByObjectIds,
         getPath: getPath,
         getSupportedTypes: getSupportedTypes,
         objAliasesToPrimaryObjId: objAliasesToPrimaryObjId
      };
      return service;

      /**
       * Performs a get request to the backend and retrieves the root node of the tree
       * @param treeId {String} the id of the tree
       * @param rootObjRef {String} /Optional/ String representation of object reference of the root node
       * @returns      {Promise} Promise with a single parameter which is the response data
       */
      function getRoot(treeId, rootObjRef) {
         var httpConfig = {
            method: 'GET',
            url: 'tree/root',
            params: {
               treeId: treeId
            }
         };

         //objRef is added to the params only when provided
         if (rootObjRef) {
            httpConfig.params.objRef = rootObjRef;
         }
         return getData(httpConfig);
      }

      /**
       * Performs a get request to the backend and retrieves the children of a given node
       *
       * For the multi node version of this function see `getChildrenByObjectIds`.
       *
       * @param treeId     {String} the id of the tree
       * @param nodeTypeId {String} the type of the node.
       *                   See the serverside tree definition for more details.
       * @param objRef     {String} String representation of object reference of the parent node
       * @returns {*}      {Promise} Promise with a single parameter which is the response data
       */
      function getChildren(treeId, nodeTypeId, objRef) {
         var httpConfig = {
            method: 'GET',
            url: 'tree/children',
            params: {
               treeId: treeId,
               nodeTypeId: nodeTypeId,
               objRef: objRef
            }
         };
         return getData(httpConfig).then(function(data) {
            // Every time we retrieve a new node, we check if there are alias objects associated with that node and
            // add them to objAliasesToPrimaryObjId map, so that when we get an update for an alias object we know which
            // tree node to update.
            _.each(data, function(object) {
               if (object.nodeTypeId) {
                  object.spriteCssClass = object.spriteCssClass || "";
                  object.spriteCssClass += " " + object.nodeTypeId;
               }
               _.each(object.aliases, function(alias) {
                  objAliasesToPrimaryObjId[alias] = object.objRef;
               });
            });
            return data;
         });
      }

      /**
       * Performs a post request to the backend and retrieves the children of multiple nodes
       *
       * For the single node version of this function see `getChildren`.
       *
       * @param treeId     {String} the id of the tree
       * @param parents    {Object[]} parents who's children are to be fetched
       *    [
       *       {
       *          nodeTypeId: <String>, // the type of the parent node
       *          objRef: <String> // the id of the parent node
       *       },
       *       ...
       *    ]
       * @returns {*}      {Promise} Promise with a single parameter which is the response data
       *    {
       *       objRef: [
       *          <childObject>,
       *          ...
       *       ],
       *       ...
       *    }
       */
      function getChildrenByObjectIds(treeId, parents) {
         var httpConfig = {
            method: 'POST',
            url: 'tree/childrenByObjectIds',
            skipLoadingNotification: true,
            data: {
               treeId: treeId,
               parents: parents
            }
         };
         return getData(httpConfig).then(function(data) {
            // Every time we retrieve a new node, we check if there are alias objects associated with that node and
            // add them to objAliasesToPrimaryObjId map, so that when we get an update for an alias object we know which
            // tree node to update.
            _.each(data, function (children) {
               _.each(children, function(child) {
                  _.each(child.aliases, function(alias) {
                     objAliasesToPrimaryObjId[alias] = child.objRef;
                  });
               });
            });

            return data;
         });
      }

      /**
       * Performs a request to the backend and retrieves the available paths from a root object
       * (FROM_OBJECT) down to another object (TO_OBJECT) for a given tree id
       *
       * @param params the available properties are:
       *        treeId     {String} the id of the tree
       *        rootObjRef {String} Id of the root node. Optional when the root node is a fixed object.
       *                   Required when the root of the tree is not a fixed item (e.g. Datacenter as a root)
       *        objRef     {String} The id of the (TO_OBJECT)
       *        options    additional object for custom usage. Currently used to hold data that
       *                   the caller may relate to. A future possible usage is holding
       *                   an extra config options for the request
       * @returns object:
       *                {
       *                   paths:   [  [path1], [path2], etc.] //array of paths
       *                   options: JSON.toString(options_object_from_the_request)
       *                }
       */
      function getPath(params) {
         var httpConfig = {
            method: 'GET',
            url: 'tree/path',
            skipLoadingNotification: true,
            params: angular.copy(params)
         };
         return getData(httpConfig);
      }

      /**
       * Performs a request to the backend and retrieves a list of types supported by
       * the tree with the given id.
       * @param treeId the id of the tree for which the supported types will be computed.
       * @returns an array of strings representing the supported types.
       */
      function getSupportedTypes(treeId) {
         var httpConfig = {
            method: 'GET',
            url: 'tree/supportedTypes',
            params: {
               treeId: treeId
            }
         };
         return getData(httpConfig);
      }

      function getData(httpConfig) {
         angular.extend(httpConfig, {
               skipErrorInterceptor: true
         });
         return $http(httpConfig).then(function (resp) {
            return resp ? resp.data || {} : {};
         }).catch(function (err) {
            log.error(err);
         });
      }

   }

})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * LiveRefresh update types for the inventory tree (destination "/topic/navTree"), same as NavTreeUpdate.java
 */
angular.module('com.vmware.platform.ui').constant('treeUpdatesConstants', {
        PROPERTIES_UPDATE: 0,
        CHILDREN_UPDATE: 1,
        PARENT_UPDATE: 2,
        DELETE_OBJECT: 3
});
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service for handling tree updates like item modified, added etc.
 *
 * It has to be initialized by providing: kendoTreeView, treeId, rootObjectId
 * Example:
 *    var handler = treeUpdatesHandler(kendoTreeView, treeId, rootObjectId);
 *    handler.add(object_id)
 *    ...
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('treeUpdatesHandler', treeUpdatesHandler);

   treeUpdatesHandler.$inject = [
      '$q',
      '$timeout',
      'treeNodeService',
      'treeNodesVisibilityStateService',
      'chunkExecutor',
      'defaultUriSchemeUtil',
      'logService',
      'dataService',
      'treeLiveUpdateBufferService',
      'resourceUtil',
      '$log'
   ];

   //the injected services
   var $q, $timeout, treeNodeService, treeNodesVisibilityStateService, chunkExecutor,
      defaultUriSchemeUtil, dataService, treeLiveUpdateBufferService, resourceUtil, $log;

   //the actual logger
   var logLog;

   //A flag for optimizing getChildren call,
   //When true the request to the server for getting a node children is debounced (see _.debounce)
   //for GET_CHILDREN_DELAY period
   //Example: GET_CHILDREN_DELAY = 1s
   // isOptimizedGetChildren = true
   // time | operation
   //  ms
   // 0000 | modified 'a' with parent node 1
   // 0500 | modified 'b' with parent node 1
   // 0500 | modified 'c' with parent node 2
   // 0800 | modified 'd' with parent node 1
   // 1200 | modified 'e' with parent node 1
   // 1500 | request to the server for children of node 2 (will update c)
   // 1700 | modified 'f' with parent node 1
   // 2700 | request to the server for children of node 1 (will update a,b,d,e,f)
   //
   // isOptimizedGetChildren = false
   // time | operation
   //  ms
   // 0000 | modified 'a' with parent node 1
   // 0000 | request to the server for children of node 2 (will update a)
   // 0500 | modified 'b' with parent node 1
   // 0500 | request to the server for children of node 2 (will update b)
   // 0500 | modified 'c' with parent node 2
   // 0500 | request to the server for children of node 2 (will update c)
   // 0800 | modified 'd' with parent node 1
   // 0800 | request to the server for children of node 2 (will update d)
   // 1200 | modified 'e' with parent node 1
   // 1200 | request to the server for children of node 2 (will update e)
   // 1700 | modified 'f' with parent node 1
   // 1700 | request to the server for children of node 1 (will update f)
   var isOptimizedGetChildren = true;

   var supportedTypesByTreeId;

   //A secret way to test the performance improvement
   //Get the treeUpdatesHandler service and call .setOptimizedGetChildren(false/true);
   //In the browser dev console one can turn it off by:
   //angular.element("#main-app-div").injector().get('treeUpdatesHandler').setOptimizedGetChildren(false);
   getHandler.setOptimizedGetChildren = function(flag) {
      isOptimizedGetChildren = !!flag;
   };

   //The debounce wait time when get children is optimized
   //TODO irahov: consider using h5Constants.REFRESH_DELAY
   var GET_CHILDREN_DELAY = 1000;
   var ITEM_MOVE = 0;
   var ITEM_NEW = 1;
   var ITEM_MOVE_BEFORE = 0;
   var ITEM_MOVE_AFTER = 1;

   var GENERIC_FOLDER_TYPE = "Folder";
   var ROOT_FOLDER_VALUE = "group-d1";
   var ROOT_FOLDER_TYPE = "rootFolder";
   var SPECIFIC_FOLDER_TYPES = {
      "group-d": "datacenterFolder",
      "group-h": "hostFolder",
      "group-v": "vmFolder",
      "group-s": "storageFolder",
      "group-n": "networkFolder"
   };
   var CONFIG_TEMPLATE_PROPERTY = "config.template";
   var GENERIC_VIRTUAL_MACHINE_TYPE = "VirtualMachine";
   var NODETYPE_VM_CLASSES = ".StandaloneHostVm, .ClusterVm, .ResPoolVm";

   function treeUpdatesHandler(
      _$q,
      _$timeout,
      _treeNodeService,
      _treeNodesVisibilityStateService,
      _chunkExecutor,
      _defaultUriSchemeUtil,
      logService,
      _dataService,
      _treeLiveUpdateBufferService,
      _resourceUtil,
      _$log) {

      //one time initializers
      var log = logService('treeUpdatesHandler');
      $q = _$q;
      $timeout = _$timeout;
      treeNodeService = _treeNodeService;
      treeNodesVisibilityStateService = _treeNodesVisibilityStateService;
      chunkExecutor = _chunkExecutor;
      defaultUriSchemeUtil = _defaultUriSchemeUtil;
      dataService = _dataService;
      treeLiveUpdateBufferService = _treeLiveUpdateBufferService;
      resourceUtil = _resourceUtil;
      supportedTypesByTreeId = {};

      logLog = log.log.bind(log);
      $log = _$log;

      //the initialization function, which also provides the public api
      return getHandler;
   }

   /**
    * Generates a handler for a specific kendoTreeView.
    *
    * @param kendoTreeView the kendo tree that this handler operates on
    * @param treeId the id of the underlying tree
    * @param rootObjectId {optional} the root id of the tree
    * @param preserveSelection callback in the following format: function(updatedItems)
    * @returns tree updates handler (handling updates like: add, change, etc.)
    */
   function getHandler(kendoTreeView, treeId, rootObjectId, preserveSelection) {

      //This object is used in order to call the server with a delay:
      // 1.To overcome data sync issue: see https://reviewboard.eng.vmware.com/r/922365/
      // 2.To introduce performance improvement - may reduce several requests to 'getChildren' into 1
      var delayedGetChildren = {};

      treeLiveUpdateBufferService.createChangeBuffer(treeId, updateTree);
      treeLiveUpdateBufferService.createChildrenBuffer(treeId, updateParents);
      treeNodesVisibilityStateService.initAsync();

      //Public API
      var handler = {
         add: add,
         change: change,
         handleDelete: handleDelete,
         handleMove: handleMove,
         handleNodesVisibility: handleNodesVisibility,
         childrenUpdate: childrenUpdate,
         liveChildrenUpdate: liveChildrenUpdate,
         liveDelete: liveDelete,
         liveChangeUpdate: liveChangeUpdate,
         destroy: destroy
      };
      return handler;

      /**
       * Destroys the buffers to avoid any update operations after
       * kendoTreeView's element is gone.
       */
      function destroy() {
         treeLiveUpdateBufferService.destroyChangeBuffer(treeId);
         treeLiveUpdateBufferService.destroyChildrenBuffer(treeId);
      }

      /**
       * Handles change events for a given object.
       * @param objectId the id of the modified object.
       */
      function change(objectId) {
         //change events are handled only for currently available items
         if (!getDataItem(kendoTreeView, objectId)) {
            return $q.resolve();
         }

         return updateAround(objectId);
      }

      /**
       * Handles add event for a specific object.
       * @param objectId
       */
      function add(objectId) {
         updateAround(objectId);
      }

      /**
       * Handles delete event for a specific object
       * @param objectId the id of the deleted object
       */
      function handleDelete(objectId) {
         removeItemFromTree(kendoTreeView, objectId);
      }

      /**
       * Handles tree nodes visibility change
       * @param nodeTypes array of node types to be shown/hidden
       */
      function handleNodesVisibility(nodeTypes) {
         return removeItemsOfTypesFromTree(kendoTreeView, nodeTypes);
      }

      function handleMove(objectId) {
         var item = getDataItem(kendoTreeView, objectId);

         if (!item) {
            return updateAround(objectId);
         }

         return getPathsToObject(objectId)
               .then(getParentFromPath)
               .then(function (parent) {
                  if (!parent) {
                     return $q.reject("undefined parent for object id: " + objectId);
                  }
                  return treeNodeService
                     .getChildren(treeId, parent.nodeTypeId, parent.objRef)
                     .then(checkIfViewExists)
                     .then(function(children) {
                        kendoTreeView.remove(kendoTreeView.findByUid(item.uid));
                        return diffUpdateNodeChildren(parent, children);
                     });
               })
               .catch(logLog);
      }

      function childrenUpdate(objectId) {
         var item = getDataItem(kendoTreeView, objectId);

         if (!item) {
            return;
         }

         return treeNodeService.getChildren(treeId, item.nodeTypeId, item.objRef)
               .then(checkIfViewExists)
               .then(function(children) {
                  return diffUpdateNodeChildren(item, children);
               })
               .then(function () {
                  var properties = ['primaryIconId', 'name', 'labelIds'];
                  // get `config.template` property if the node type s VM as we need to distinguish VMs an VM templates
                  if(item.nodeTypeId === GENERIC_VIRTUAL_MACHINE_TYPE){
                     properties.push(CONFIG_TEMPLATE_PROPERTY);
                  }
                  return dataService.getProperties(item.objRef, properties,
                      {queryName:"treeUpdatesHandler." + childrenUpdate.name})
                        .then(function (res) {
                           updateNodeState(item, {
                              icon: res.primaryIconId,
                              name: res.name,
                              labelIds: res.labelIds,
                              isVmTemplate: res[CONFIG_TEMPLATE_PROPERTY]
                           });
                        });
               })
               .catch(logLog);
      }

      function liveChangeUpdate(update) {
         if (isUpdateOfHiddenNode(treeId, update)) {
            return;
         }
         getSupportedTypes(treeId)
            .then(checkIfViewExists)
            .then(function(supportedTypes) {
               if (!isRelevantUpdate(update, supportedTypes)) {
                  return;
               }

               var objId = getObjectIdFromUpdateData(update);
               var item = getDataItem(kendoTreeView, objId);

               if (!item) {
                  return;
               }

               treeLiveUpdateBufferService.addChangeEntry(treeId, objId, update);
            })
            .catch(logLog);
      }

      function liveChildrenUpdate(update) {
         if (isUpdateOfHiddenChildVm(treeId, update)) {
            return;
         }
         getSupportedTypes(treeId)
            .then(checkIfViewExists)
            .then(function(supportedTypes) {
               if (isRelevantUpdate(update, supportedTypes)) {
                  handleLiveChildrenUpdate(getObjectIdFromUpdateData(update));
               }
            })
            .catch(logLog);
      }

      function liveDelete(update) {
         if (isUpdateOfHiddenNode(treeId, update)) {
            return;
         }
         getSupportedTypes(treeId)
            .then(checkIfViewExists)
            .then(function(supportedTypes) {
               if (!isRelevantUpdate(update, supportedTypes)) {
                  return;
               }
               removeItemFromTree(kendoTreeView, getObjectIdFromUpdateData(update));
            })
            .catch(logLog);
      }

      function getObjectIdFromUpdateData(update) {
         var mor = update.source;
         return defaultUriSchemeUtil.createVmomiUri(
             mor.type,
             mor.value,
             mor.serverGuid
         );
      }

      function isRelevantUpdate(update, supportedTypes) {
         if (!update) {
            return false;
         }
         if (!angular.isArray(supportedTypes) || supportedTypes.length === 0) {
            return true;
         }
         var moRef = update.source;
         var type = moRef.type;
         if (type === GENERIC_FOLDER_TYPE) {
            type = getSpecificFolderType(moRef.value) || moRef.type;
         }
         return (supportedTypes.indexOf(type) !== -1);
      }

      function isUpdateOfHiddenChildVm (treeId, update) {
         if (!update) {
            return false;
         }
         var childrenProperties = update.data ? update.data.childrenProperties : [];
         if (childrenProperties.length === 1 && childrenProperties[0] === "vm") {
            var isChildVmVisible = treeNodesVisibilityStateService.isNodeTypeVisibleSync(treeId, "VirtualMachine");
            return !isChildVmVisible;
         }
         return false;
      }

      function isUpdateOfHiddenNode (treeId, update) {
         if (!update) {
            return false;
         }
         var moRef = update.source;
         var type = moRef.type;
         var isVisibleNode = treeNodesVisibilityStateService.isNodeTypeVisibleSync(treeId, type);
         return !isVisibleNode;
      }


      /**
       * Handles children_update coming from the live refresh.
       */
      function handleLiveChildrenUpdate(objectId) {
         if (!angular.isString(objectId)) {
            return;
         }

         var parent = treeNodeService.objAliasesToPrimaryObjId[objectId];
         if (parent) {
            objectId = parent;
         }
         //try to get the item
         var item = getDataItem(kendoTreeView, objectId);

         //item is not currently loaded, ignore the update
         if (!item) {
            return;
         }

         //Final step: the item is loaded, but make sure it is visible
         //If a item is not expanded then mark that item for a reload
         //and stop further processing
         if (!item.expanded) {
            item.loaded(false);
            return;
         }

         treeLiveUpdateBufferService.addChildrenEntry(treeId, objectId, item);
      }

      /**
       * Callback for the children update buffer
       *
       * @param data Contains the children for the parents that should be updated
       * @param parents The parents as kendo items
       */
      function updateParents(data, parents) {
         if (!data || !parents) {
            return;
         }

         var movedChildren = _.reduce(parents, function(acc, parent) {
            return acc.concat(updateChildren(data[parent.objRef], parent));
         }, []);

         preserveSelection(movedChildren);
      }

      function updateChildren(children, parent) {
         if (!children) {
            return [];
         }

         var movedChildren = [];
         var parentNode = kendoTreeView.findByUid(parent.uid);
         if (!kendoTreeView.dataItem(parentNode)) {
            return movedChildren;
         }

         var oldChildren = parent.children && _.isFunction(parent.children.data) ? parent.children.data() : [];
         oldChildren = _.extend([], oldChildren);
         var latestChildrenRef = _.pluck(children, 'objRef');

         _.each(oldChildren, function (x) {
            if (!(_.contains(latestChildrenRef, x.objRef))) {
               movedChildren.push(x.objRef);
               $log.debug("treeUpdatesHandler#updateChildren: removing '" + x.text + "' from '" + parent.text + "'");
               kendoTreeView.remove(kendoTreeView.findByUid(x.uid));
            }
         });

         var isFirstChild = true;
         _.each(children, function (curr, i) {
            var existingItem = getDataItem(kendoTreeView, curr.objRef);
            if (!existingItem || existingItem.parentNode().objRef !== parent.objRef) {
               $log.debug("treeUpdatesHandler#updateChildren: inserting '" + curr.text + "' under '" + parent.text + "'");
               // when the item is existing the opType should be MOVE, otherwise
               // the opType is NEW and the passed item is the JSON object - curr
               const opType = existingItem ? ITEM_MOVE : ITEM_NEW;
               const item = existingItem ? existingItem : curr;
               if (isFirstChild) {
                  insertFront(item, parentNode, opType);
               } else {
                  insertAfter(item, children[i - 1], opType);
               }
               movedChildren.push(curr.objRef);
            }
            if (isFirstChild) {
               isFirstChild = false;
            }
         });
         return movedChildren;
      }

      function getObjectType(objectId) {
         return defaultUriSchemeUtil.getPartsFromVsphereObjectId(objectId).type;
      }

      /**
       * Updates the tree elements' icons, names and labels.
       *
       * @param dataObject
       *    Contains objectId to properties mapping.
       * @param bufferMap
       *    `treeLiveUpdateBufferService`'s change update buffer map.
       */
      function updateTree(dataObject, bufferMap) {
         Object.keys(bufferMap).forEach(function(objectId) {
            var currentDataObject = dataObject[objectId];
            if (!dataObject ||
                !Object.keys(dataObject).length ||
                !currentDataObject) {
               return;
            }

            var name = currentDataObject.name;
            var labelIds = currentDataObject.labelIds;
            var icon = currentDataObject.primaryIconId;
            var isVmTemplate = currentDataObject[CONFIG_TEMPLATE_PROPERTY];

            var dataItem = getDataItem(kendoTreeView, objectId);
            if (!dataItem) {
               return;
            }
            var objectType = getObjectType(objectId);

            var parent = dataItem.parentNode();

            if (!parent) {
               return;
            }
            var allChildren = parent.children.data() || [];

            // Get only the children of the same type.
            var children = _.filter(allChildren, function(child) {
               return getObjectType(child.objRef) === objectType;
            });

            var item = kendoTreeView.findByUid(dataItem.uid);

            if (!kendoTreeView.dataItem(item)) {
               return;
            }
            // Move the element if necessary.
            if (bufferMap[objectId].data.isNameUpdate || bufferMap[objectId].data.isTemplateUpdate) {
               var startIndex = 0;
               var endIndex = children.length;

               // If the childrens are VMs and VmTemplates divide them in two groups
               if (isVmTemplate !== null && isVmTemplate !== undefined) {
                  // get number of vms
                  var templateStartingIndex = children.filter(function (child) {
                     return !child.isVmTemplate;
                  }).length;
                  if (isVmTemplate) {
                     startIndex = templateStartingIndex;
                  } else {
                     endIndex = templateStartingIndex;
                  }
               }
               var options = {
                  startIndex: startIndex,
                  endIndex: endIndex,
                  isVmTemplate: isVmTemplate,
                  name: name
               };
               moveElementInTree(dataItem, children, options);
            }

            var kInItem = $($(item[0]).find(".k-in")[0]);
            if (kInItem) {
               kInItem.removeClass('italic');
               var italic = resourceUtil.getItalicClassName(labelIds, icon);
               if (italic) {
                  kInItem.addClass(italic);
               }
            }

            updateNodeState(dataItem, { icon: icon, name: name, labelIds: labelIds, isVmTemplate: isVmTemplate});
         });
      }

      /**
       * Move element in tree
       *
       * @param dataItem - element to move
       * @param children - children element of the parent node
       * @param options - object containing few options needed for the operation:
       *                  - startIndex - start index of the children of the same type
       *                  - endIndex - end index of the children of the same type
       *                  - isVmTemplate - denotes if the element is vmTemplate
       *                  - name - the name of the object
       */
      function moveElementInTree(dataItem, children, options) {
         var item = kendoTreeView.findByUid(dataItem.uid);
         var nextItem = findNextTreeNode(dataItem, children, options);
         if (!nextItem) {
            var lastDataItem = children[options.endIndex - 1];
            moveElementAtPosition(item, lastDataItem, ITEM_MOVE_AFTER);
            return;
         }
         moveElementAtPosition(item, nextItem, ITEM_MOVE_BEFORE);
      }

      /**
       * Find the next element of given node in the tree
       *
       * @param dataItem - element to move
       * @param children - children element of the parent node
       * @param options - object containing few options needed for the operation:
       *                  - startIndex - start index of the children of the same type
       *                  - endIndex - end index of the children of the same type
       *                  - isVmTemplate - denotes if the element is vmTemplate
       *                  - name - the name of the object
       * @returns {*}
       */
      function findNextTreeNode(dataItem, children, options) {
         // if there aren't any VMs in the tree and VmTemplate is being converted to VM,
         // it should become first child
         if (options.startIndex === options.endIndex && options.isVmTemplate === false) {
            return children[0];
         }
         var nextTreeNode;
         for (var i = options.startIndex; i < options.endIndex; i++) {
            if (!(children[i] && children[i].text)) {
               continue;
            }
            if (children[i].text.toLocaleLowerCase().localeCompare(options.name.toLocaleLowerCase()) > 0 &&
                children[i].text.localeCompare(dataItem.text) !== 0) {
               nextTreeNode = children[i];
               break;
            }
         }
         return nextTreeNode;
      }

      /**
       * Moves element in tree before/after another element
       *
       * @param item - element to move
       * @param node - node in the tree which will be before/after the current one
       * @param movePosition - denotes before or after given node the current element will be moved
       */
      function moveElementAtPosition(item, node, movePosition) {
         var nodeElement = kendoTreeView.findByUid(node.uid);
         if (!kendoTreeView.dataItem(nodeElement)) {
            return;
         }
         if (item.text().localeCompare(node.text) === 0) {
            return;
         }
         if (movePosition === ITEM_MOVE_BEFORE) {
            kendoTreeView.insertBefore(item, nodeElement);
            return;
         }
         kendoTreeView.insertAfter(item, nodeElement);
      }

      /**
       * Updates the tree around a given object.
       * Basically the logic here goes like this:
       *   1. Check if the item is in the tree
       *     1.1. If not - then find its parent by requesting it from the server
       *     1.2. If yes - get the parent from the tree
       *   2. The following logic is valid for the parent of the item:
       *     2.1. if it is not loaded or not expanded - do nothing
       *     2.2. if it is loaded and its state is:
       *       2.2.1. collapsed, then just mark it for a reload
       *       2.2.2. expanded, then update the children of this parent
       *
       * @param objectId the id of the item
       */
      function updateAround(objectId) {
         var deferred = $q.defer();

         if (!angular.isString(objectId)) {
            deferred.resolve();
         } else {
            var item, parent;

            //try to get the item
            item = getDataItem(kendoTreeView, objectId);

            //item is not currently loaded, so get the paths to this object from the server
            if (!item) {
               getPathsToObject(objectId)
                  .then(getParentFromPath)
                  .then(getChildrenForDiffUpdate)
                  .then(deferred.resolve)
                  .catch(logLog);
            } else {
               parent = item.parentNode();

               //no parent, it's a root node update
               if (!parent) {
                  //TODO irahov: figure out what should be the exact handling for the root
                  deferred.resolve();
               } else {
                  //Final step: the item is loaded, but make sure it is visible
                  //If a parent is not expanded then mark that parent for a reload
                  //and stop further processing
                  do {
                     if (!parent.expanded) {
                        parent.loaded(false);
                        deferred.resolve();
                        return deferred.promise;
                     }
                  } while ((parent = parent.parentNode()));

                  // Update the children of the parent
                  // This will update the item itself (including its position in case of
                  // a rename)
                  getChildrenForDiffUpdate(item.parentNode()).then(deferred.resolve);
               }
            }
         }

         return deferred.promise;
      }

      /**
       * Retrieves the available paths from the root of the tree to a given object.
       *
       * @param objectId the id of the object to which the available paths will be retrieved
       * @returns a promise which is resolved with an array of available paths
       */
      function getPathsToObject(objectId) {
         //prepare parameters for the getPath request to the server
         var params = {
            treeId: treeId,
            objRef: objectId
         };
         //in case the root of the tree is not a fixed object
         if (rootObjectId) {
            params.rootRef = rootObjectId;
         }

         //call the server to provide available paths
         return treeNodeService.getPath(params).then(checkIfViewExists);
      }

      /**
       * Retrieves the immediate parent data item based on the available paths.
       * If a parent is not expanded it is marked for a reload.
       *
       * An available path is an array of ids starting from the tree root (being the first element)
       * to a given item (being the last item).
       *
       * @param data array with available paths
       * @returns the parent data item or null (if that parent is not loaded or not expanded)
       */
      function getParentFromPath(data) {
         var path, allAvailablePaths,
               objectId, parent, parentId;

         //just return if the server hasn't found valid paths
         if (!data || !angular.isArray(data.paths) || !data.paths.length) {
            return;
         }
         allAvailablePaths = data.paths;

         //make a shallow copy of the paths
         allAvailablePaths = allAvailablePaths.slice();

         while (allAvailablePaths.length) {
            path = allAvailablePaths.shift();

            //make a shallow copy of the path
            path = path.slice();

            //We pop the last item because we are searching for its parent
            objectId = path.pop();

            while (path.length) {
               parentId = path.shift();
               parent = getDataItem(kendoTreeView, parentId);

               //if a parent does not exist this means that this is either a non valid path
               //or the parent is not currently loaded in the tree
               //In both cases break further walk through and let examine another available path
               if (!parent) {
                  break;
               }

               //if a parent is not expanded then mark that parent for a reload
               //and break further walk through and let examine another available path
               if (!parent.expanded) {
                  prepareForLoading(parent);
                  break;
               }

               //there are no other check to be done for the parents
               //but we are interested in the immediate(first level) parent
               //so continue with next in the list
               if (path.length) {
                  continue;
               }

               return parent;
            }
         }

         return null;
      }

      /**
       * Gets the children for a given node from the server and then calls diffUpdateNodeChildren.
       * Getting the children from the server is optimized by a debounce technique (see _ js)
       *
       * @param parent the parent data item
       */
      function getChildrenForDiffUpdate(parent) {
         var deferred = $q.defer();

         function getChildrenForDiffUpdateInternal() {
            treeNodeService
               .getChildren(treeId, parent.nodeTypeId, parent.objRef)
               .then(checkIfViewExists)
               .then(function(children) {
                  diffUpdateNodeChildren(parent, children).then(deferred.resolve);
               })
               .catch(logLog);
         }

         if (!parent) {
            deferred.resolve();
         } else {
            if (!isOptimizedGetChildren) {
               getChildrenForDiffUpdateInternal();
            } else {
               // Debounce getting data for the same parent
               var key = parent.objRef;
               if (delayedGetChildren[key]) {
                  $timeout.cancel(delayedGetChildren[key]);
               }

               delayedGetChildren[key] = $timeout(function() {
                  delayedGetChildren[key] = null;
                  getChildrenForDiffUpdateInternal();
               }, GET_CHILDREN_DELAY);
            }
         }

         return deferred.promise;
      }

      /**
       * Updates the children of a given node.
       * The function takes two parameters a data item (the parent) and its latestChildren.
       * Then a diff is performed between the existing children and the latestChildren.
       * The diff is used to apply the relevant modifications.
       *
       * @param parent the parent data item which children will be updated
       * @param latestChildren a list of the latest children
       */
      function diffUpdateNodeChildren(parent, latestChildren) {
         var deferred = $q.defer();

         if (!parent) {
            logLog('diffUpdateNodeChildren', 'parent is required');
         }
         if (!angular.isArray(latestChildren)) {
            logLog('diffUpdateNodeChildren', 'latestChildren should be array');
         }

         var parentNode = kendoTreeView.findByUid(parent.uid);
         if (!kendoTreeView.dataItem(parentNode)) {
            return deferred.promise;
         }

         var oldChildren = parent.children && _.isFunction(parent.children.data) ?
            parent.children.data() :
            [];
         var latestChildrenByRef = _.reduce(latestChildren, function (acc, x) {
            acc[x.objRef] = x;
            return acc;
         }, {});

         var removedChildren = [];
         var promises = [];
         _.each(oldChildren, function (x) {
            if (!latestChildrenByRef[x.objRef]) {
               removedChildren.push(x);
               // An item has been removed, but this may also mean moved, so lets update
               // around it but do it after the current diff update has finished, i.e.
               // use timeout.
               promises.push($timeout(null, 0).then(function () {
                  return updateAround(x.objRef);
               }));
            }
         });

         _.each(removedChildren, function (x) {
            kendoTreeView.remove(kendoTreeView.findByUid(x.uid));
         });

         var isFirstChild = true;
         _.each(latestChildren, function (curr, i) {
            var existingItem = getDataItem(kendoTreeView, curr.objRef);
            if (existingItem) {
               if (existingItem.spriteCssClass !== curr.spriteCssClass) {
                  existingItem.set('spriteCssClass', curr.spriteCssClass);
               }
               if (isStructuralUpdate(existingItem, curr)) {
                  if (existingItem.text !== curr.text) {
                     existingItem.set('text', curr.text);
                  }
                  if (isFirstChild) {
                     insertFront(existingItem, parentNode, ITEM_MOVE);
                  } else {
                     insertAfter(existingItem, latestChildren[i - 1], ITEM_MOVE);
                  }
               }
            } else {
               if (isFirstChild) {
                  insertFront(curr, parentNode, ITEM_NEW);
               } else {
                  insertAfter(curr, latestChildren[i - 1], ITEM_NEW);
               }
            }

            if (isFirstChild) {
               isFirstChild = false;
            }
         });

         $q.all(promises).then(deferred.resolve);

         return deferred.promise;
      }

      /**
       * Checking whether after the change of the item's state tree elements should be rearranged
       *
       * @param oldItem - current value of the tree item
       * @param newItem - updated value of the tree item
       * @returns {boolean}
       */
      function isStructuralUpdate(oldItem, newItem) {
         return oldItem.text !== newItem.text ||
             oldItem.isVmTemplate !== newItem.isVmTemplate;
      }

      function insertFront(item, parentNode, opType) {
         var firstNode = parentNode.find('.k-item:first');
         if (opType === ITEM_MOVE) {
            var firstDataItem = kendoTreeView.dataItem(firstNode);
            // position did not change, do nothing
            if (firstDataItem && firstDataItem.objRef === item.objRef) {
               return;
            }
            item = kendoTreeView.findByUid(item.uid);
            if (!kendoTreeView.dataItem(item)) {
               return;
            }
         }

         if (firstNode.size()) {
            kendoTreeView.insertBefore(item, firstNode);
         } else {
            kendoTreeView.append(item, parentNode);
         }
      }

      function insertAfter(item, afterItem, opType) {
         if (opType === ITEM_MOVE) {
            item = kendoTreeView.findByUid(item.uid);
            if (!kendoTreeView.dataItem(item)) {
               return;
            }
         }
         var lastItem = kendoTreeView.dataSource.get(afterItem.objRef);
         if(!lastItem){
            return;
         }
         var lastDataItem = kendoTreeView.findByUid(lastItem.uid);
         if (!kendoTreeView.dataItem(lastDataItem)) {
            return;
         }
         kendoTreeView.insertAfter(item, lastDataItem);
      }

      function checkIfViewExists(data) {
         return kendoTreeView.element ?
            $q.resolve(data) :
            $q.reject('KendoTreeView does not exist.');
      }
   }

   /**
    * Removes the relevant node from the kendo tree.
    * If the node is the currently selected one, then its parent is automatically selected.
    *
    * @param item the data item(model) or its id that describes the node
    */
   function removeItemFromTree(kendoTreeView, item) {

      //if the item is string then gets the relevant model
      var model;
      if (angular.isString(item)) {
         model = getDataItem(kendoTreeView, item);
      }

      if (!model) {
         return;
      }

      var node = kendoTreeView.findByUid(model.uid);
      if (!node || !node.length) {
         $log.debug("treeUpdatesHandler#removeItemFromTree: no tree node found for item with uid '" + model.uid + "'");
         return;
      }

      var selectedNode = kendoTreeView.select();
      if (node.get(0) === selectedNode.get(0)) {
         selectedNode = kendoTreeView.parent(node);
         kendoTreeView.select(selectedNode);
      }
      $log.debug("treeUpdatesHandler#removeItemFromTree: removing '"  + node.text() + "'");
      kendoTreeView.remove(node);
   }

   /**
    * Removes all elements of given type from kendo tree.
    * If among the removed nodes is the currently selected one, then its parent is automatically selected.
    *
    * @param kendoTreeView
    * @param nodeTypes types of nodes to be hidden
    */
   function removeItemsOfTypesFromTree (kendoTreeView, nodeTypes) {
      if (!kendoTreeView.element) {
         return Promise.resolve(false);
      }
      var vmLiElems = kendoTreeView.element.find(NODETYPE_VM_CLASSES).closest("li");
      var selectedNode = kendoTreeView.select();
      var selectedElem = selectedNode && selectedNode.get(0);
      if (selectedElem && _.contains(vmLiElems, selectedElem)) {
         kendoTreeView.select(kendoTreeView.parent(selectedNode));
      }
      return chunkExecutor.executeOnChunks(function(node) {
         kendoTreeView.remove(node);
      }, vmLiElems, 250, 1000);

   }

   /**
    * Gets the data item (model) with the specified id from the kendo tree
    *
    * @param kendoTreeView the kendo tree view
    * @param itemId The id of the model to look for.
    * @returns kendo.data.Model the model instance or undefined if a model with the specified id is not found.
    *
    * @see http://docs.telerik.com/kendo-ui/api/javascript/data/datasource#methods-get
    */
   function getDataItem(kendoTreeView, itemId) {
      var dataItem = null;
      //try-catch needed to overcome a kendo bug
      //observed when 'loadingRootNode' and the root node is being expanded
      try {
         dataItem = kendoTreeView.dataSource.get(itemId);
      } catch (ex) {
      }

      return dataItem;
   }

   function getSupportedTypes(treeId) {
      var deferred = $q.defer();
      if (supportedTypesByTreeId.hasOwnProperty(treeId)) {
         deferred.resolve(supportedTypesByTreeId[treeId]);
      } else {
         treeNodeService.getSupportedTypes(treeId).then(function (result) {
            supportedTypesByTreeId[treeId] = result;
            deferred.resolve(result);
         });
      }
      return deferred.promise;
   }

   function getSpecificFolderType(moRefValue) {
      if (moRefValue === ROOT_FOLDER_VALUE) {
         return ROOT_FOLDER_TYPE;
      }
      var key = _.find(Object.keys(SPECIFIC_FOLDER_TYPES), function (key) {
         return (moRefValue.indexOf(key) !== -1);
      });
      // Returns the specific folder type if key is found, otherwise returns null.
      return ((key && SPECIFIC_FOLDER_TYPES[key]) || null);
   }

   function updateNodeState(item, opts) {
      if (!item) {
         return;
      }
      if (opts.icon) {
         item.set('spriteCssClass', opts.icon);
      }
      if (opts.name) {
         var fullName = opts.name;
         if (opts.labelIds) {
            fullName += resourceUtil.getTaggingLabelString(opts.labelIds);
         }
         item.set('text', fullName);
      }
      if (opts.isVmTemplate !== null && opts.isVmTemplate !== undefined) {
         item.set('isVmTemplate', opts.isVmTemplate);
      }
   }

   function prepareForLoading(node) {
      node.hasChildren = true;
      node.loaded(false);
      node.load();
   }
})();

angular.module('com.vmware.platform.ui').factory('treeViewLocalStorageService', ['$q', 'localStorageService', 'simpleObjectStorageService',
   function ($q, localStorageService, simpleObjectStorageService) {
      function TreeViewLocalStorage(treeId) {
         var treeViewLocalStorage = this,

         //the treeId used for this directive
            _treeId = treeId,

         // Storage where the data will be stored
            _storage = simpleObjectStorageService.getObjectStorage();

         // Future pointing to the last save persistence call
            var savePersistenceFuture = $q.when();

         /**
          * Set whether persistence is enabled
          * @param enablePersistence true when data should be persisted
          */
         treeViewLocalStorage.enablePersistence = function (enablePersistence) {
            if (enablePersistence === true) {
               _storage = localStorageService;
            } else if (_storage === localStorageService) {
               // Initialize with instance storage only if it isn't initialized yet
               _storage = simpleObjectStorageService.getObjectStorage();
            }
         };

         /**
          * Node selection change listener.
          * Currently used to persist the last selected node as persisted is enabled.
          * @param item The data item of the selected node
          */
         treeViewLocalStorage.selectionChanged = function (item) {
            extendPersistedData({lastSelectedNode: item.objRef, lastSelectedNodeExpanded: item.expanded});
         };

         /**
          * Node expand listener
          * @param item The data item of the node that is being expanded
          */
         treeViewLocalStorage.nodeExpanded = function (item) {
            getPersistedData().then(function (persistedData) {
               //persist the expanded status only for the currently selected node
               if (persistedData.lastSelectedNode === item.objRef) {
                  extendPersistedData({lastSelectedNodeExpanded: true});
               }

               setExpansionPersistanceTree(persistedData, item, function (parent) {
                  var treeNode = parent.children[item.objRef];
                  if (treeNode) {
                     treeNode.expanded = true;
                  } else {
                     parent.children[item.objRef] = {expanded: true, children: {}};
                  }
               });
            });
         };

         /**
          * Node collapse listener
          * @param item The data item of the node that is being collapsed
          */
         treeViewLocalStorage.nodeCollapsed = function (item) {
            getPersistedData().then(function (persistedData) {
               //persist the expanded status only for the currently selected node
               if (persistedData.lastSelectedNode === item.objRef) {
                  extendPersistedData({lastSelectedNodeExpanded: false});
               }

               setExpansionPersistanceTree(persistedData, item, function (parent) {
                  var treeNode = parent.children[item.objRef];
                  if (!treeNode) {
                     return;
                  }

                  if (Object.keys(treeNode.children).length > 0) {
                     // If the there are expanded children, we just need to update the expand state
                     treeNode.expanded = false;
                  } else {
                     // If the node doesn't have children, we don't need it anymore
                     delete parent.children[item.objRef];
                  }
               });
            });
         };

         /**
          * Retrieve data for the last selected node as persisted in the local storage
          * The functionality is dependent on whether or not the persistence is enabled
          * @returns object containing data for the last selected node
          */
         treeViewLocalStorage.getLastSelectedNodeData = function () {
            return getPersistedData().then(function (persistedData) {
                  return {
                     node: persistedData.lastSelectedNode,
                     expanded: persistedData.lastSelectedNodeExpanded
                  };
               }
            );
         };

         /**
          * Retrieve data for the last expanded nodes as persisted in the local storage
          * The functionality is dependent on whether or not the persistence is enabled
          * @returns object containing a root node of the expanded elements in the tree
          */
         treeViewLocalStorage.getExpandedNodesData = function () {
            return getPersistedData().then(buildPersistedTree);
         };

         /**
          * Clean and return the expanded nodes data
          */
         treeViewLocalStorage.cleanExpandedNodesData = function () {
            return getPersistedData().then(function (persistedData) {
               extendPersistedData({expandedNodes: {children: {}}});
               return persistedData.expandedNodes;
            });
         };

         /**
          * Retrieves the data from the persistence storage.
          * Depends on whether or not the persistence is enabled.
          * The data is lazily loaded and stored into the local variable.
          * @returns JS object representing the data persisted in the local storage
          *          or empty object if persistence is not enabled
          */
         function getPersistedData() {
            return _storage.getUserData(_treeId)
               .then(function (localStorageData) {
                  return localStorageData || {};
               });
         }

         /**
          * Preserve data in the persistence storage if persistence is enabled.
          * Note that the data may not be the complete object, but just a subset of it.
          * @param data the data that is going to be persisted
          * @param newData the data that is going to be persisted, this will be replaced in the persistedData
          */
         function setPersistedData(persistedData, newData) {
            var data = angular.copy(persistedData);
            if (newData) {
               angular.extend(data, newData);
            }
            _storage.setUserData(_treeId, data);
         }

         /**
          * Preserve data in the persistence storage if persistence is enabled.
          * Note that the data may not be the complete object, but just a subset of it.
          * @param data the data that is going to be persisted, this may be just a subset of the
          *             whole local storage data
          */
         function extendPersistedData(data) {
            // Making sure that each extend of the persisted data will happen after the previous one
            // This will ensure that we will extend always the latest data
            savePersistenceFuture = savePersistenceFuture.then(getPersistedData).then(function (persistedData) {
               setPersistedData(persistedData, data);
            });
         }

         function setExpansionPersistanceTree(persistedData, item, modifyDirectParentFunction) {
            var expandedTree = buildPersistedTree(persistedData);
            var itemPath = buildItemPath(item);

            // Search for the direct parent of currently expanded/collapsed in the persisted tree
            var currentNode = expandedTree;
            for (var i = itemPath.length - 1; i > 0 && currentNode; --i) {
               currentNode = currentNode.children[itemPath[i]];
            }

            if (currentNode) {
               // If we found the direct parent of the item, just update the tree
               modifyDirectParentFunction(currentNode);
            }

            extendPersistedData({expandedNodes: expandedTree});
         }

         function buildPersistedTree(data) {
            if (!data.expandedNodes) {
               return {children: {}};
            }

            return data.expandedNodes;
         }

         function buildItemPath(item) {
            var path = [];
            var currentItem = item;
            while (currentItem) {
               path.push(currentItem.objRef);
               currentItem = currentItem.parentNode();
            }
            return path;
         }

         return this;
      }

      function getLocalStorageByTreeId(treeId) {
         return new TreeViewLocalStorage(treeId);
      }

      return {
         getLocalStorageByTreeId: getLocalStorageByTreeId
      };
   }]);
/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Tree view directive that creates a kendo tree view by dynamically loading the tree nodes
 * from the server based on a tree id
 *
 * Example:
 * 1) bare minimum (even without a controller)
 * <div vx-tree-view  tree-id="vsphere.core.physicalInventorySpec"></div>
 *
 * 2) Controller with onChange callback
 * <div ng-controller="InventoryTreeViewController as ctrl">\
 *    <div
 *       vx-tree-view
 *       tree-id="vsphere.core.physicalInventorySpec"
 *       on-change="ctrl.onChange(objRef)"
 *    ></div>
 * </div>
 *
 * 3) Controller with onError callback
 * <div ng-controller="InventoryTreeViewController as ctrl">\
 *    <div
 *       vx-tree-view
 *       tree-id="vsphere.core.physicalInventorySpec"
 *       on-error="ctrl.onError(error)"
 *    ></div>
 * </div>
 *
 * 4) Providing a reference to the root node (rootObjRef)
 * <div ng-controller="InventoryTreeViewController as ctrl">\
 *    <div
 *       vx-tree-view
 *       tree-id="vsphere.core.physicalInventorySpec"
 *       on-change="ctrl.onChange(objRef)"
 *       root-obj-ref="ctrl.treeRootObjRef"   //or if the scope is used: root-obj-ref="treeRootObjRef"
 *    ></div>
 * </div>
 *
 * 5) Providing a preselected node or means to change the current selection programmatically.
 *   If the corresponding node is not currently loaded a request to the server
 *   will be send to get the available paths to from the root down to that node.
 *   Note:
 *   selectNode is being watched for changes, so that changing it will result in a tree selection change
 *
 * <div ng-controller="InventoryTreeViewController as ctrl">\
 *    <div
 *       vx-tree-view
 *       tree-id="vsphere.core.physicalInventorySpec"
 *       select-node="ctrl.id_of_object_to_select"
 *    ></div>
 * </div>
 *
 * 6) Providing 'persistselection' in the 'options' attribute will allow the directive to persist
 *    the last selected node so that the node be selected automatically the next time this tree is
 *    being rendered
 *
 * <div ng-controller="InventoryTreeViewController as ctrl">\
 *    <div
 *       vx-tree-view
 *       tree-id="vsphere.core.physicalInventorySpec"
 *       options="persistselection"
 *    ></div>
 * </div>*
 *
 * 7) Providing 'config' may fine tune the directive behavior
 *
 * ctrl.treeConfig = {
 *    preselectRoot : false/true   //defaults to true if missing
 * }
 * preselectRoot - if explicitly set to false the root node will not be selected
 *                otherwise  the root node will be preselected.
 *                This config is applied only if there is no other item to be preselected,
 *                i.e. there is no 'select-node' and 'persistselection' options.
 *
 *
 * <div ng-controller="InventoryTreeViewController as ctrl">\
 *    <div
 *       vx-tree-view
 *       tree-id="vsphere.core.physicalInventorySpec"
 *       config="ctrl.treeConfig"
 *    ></div>
 * </div>*
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
         .directive('vxTreeView', vxTreeView);

   function vxTreeView() {

      return {
         link: link,
         scope: {
            treeId: '@treeId',
            options: '@options',
            change: '&onChange',
            error: '&onError',
            rootObjRef: '=',
            selectNode: '=',
            config: '='
         },
         controller: 'VxTreeViewController'
      };

      function link(scope, element, attrs, vxTreeViewController) {

         //this attribute is needed for the CSS rules, but do not set it into the html
         //because it is also an angular directive, so it will start a whole bunch of processing
         element.attr('vui-tree-view', '');

         // note mibryamov: in order the keyboard navigation of kendo tree view
         // to work correctly and read by screen readers, there should be two
         // attributes on the wrapping html element provided - role and id.
         // Since all the instances of the vx-tree-view directive provides
         // a tree-id attribute (that should be unique), we will use it to
         // auto-generate the id attribute (if not provided).
         var idAttr = element.attr('id');
         if (!idAttr) {
            var treeIdAttr = element.attr('tree-id');
            if (treeIdAttr) {
               element.attr('id', treeIdAttr);
            }
         }
         element.attr('role', 'tree');

         //create the kendo tree view
         var kendoTreeView = element.kendoTreeView({
            dragAndDrop: scope.config ? scope.config.dragAndDrop : false,
            // resolves https://jira.eng.vmware.com/browse/VSUIP-2503
            // Pre-selecting the root object in a vui tree breaks JAWS reader
            dataBound: function () {
              element.find('ul[role=tree]').attr('role', null);
            }
         }).data('kendoTreeView');

         vxTreeViewController.setupAndRun(kendoTreeView, scope.config);
      }
   }
})();

/* Copyright 2016-2017 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Angular Controller to manage the vx-tree-view directive.
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui')
         .controller('VxTreeViewController', VxTreeViewController);

   VxTreeViewController.$inject = ['$scope', '$rootScope', '$q', '$timeout',
      'treeNodeService', 'treeUpdatesHandler',
      'treeViewLocalStorageService',
      'websocketMessagingService',
      'defaultUriSchemeUtil',
      'treeUpdatesConstants',
      'configurationService',
      'treeViewErrorConstants',
      '$log'];

   function VxTreeViewController($scope, $rootScope, $q, $timeout,
         treeNodeService, treeUpdatesHandler,
         treeViewLocalStorageService,
         websocketMessagingService,
         defaultUriSchemeUtil,
         treeUpdatesConstants,
         configurationService,
         treeViewErrorConstants,
         $log) {
      var DRAGSTART = "dragstart";
      var DRAG = "drag";
      var DRAGEND = "dragend";
      var DROP = "drop";

      /**
       * The following map contains supported properties for children update.
       * @type {{}}
       */
      var SUPPORTED_PROPERTIES_FOR_CHILDREN_UPDATE = {
         "vsphere.core.physicalInventorySpec" : {
            "Folder" : new Set(["childEntity"]),
            "Datacenter" : new Set(["childEntity"]),
            "ComputeResource" : new Set(["childEntity", "vm", "resourcePool", "host"]),
            "ClusterComputeResource" : new Set(["childEntity", "vm", "resourcePool", "host"]),
            "HostSystem" : new Set(["childEntity", "vm", "resourcePool"]),
            "ResourcePool" : new Set(["childEntity", "vm", "resourcePool"]),
            "VirtualApp" : new Set(["childEntity", "vm", "resourcePool"])
         },
         "vsphere.core.virtualInventorySpec" : {
            "Folder" : new Set(["childEntity"]),
            "Datacenter" : new Set(["childEntity"])
         },
         "vsphere.core.storageInventorySpec" : {
            "Folder" : new Set(["childEntity"]),
            "Datacenter" : new Set(["childEntity"]),
            "StoragePod" : new Set(["childEntity"])
         },
         "vsphere.core.networkingInventorySpec" : {
            "Folder" : new Set(["childEntity"]),
            "Datacenter" : new Set(["childEntity"]),
            "VmwareDistributedVirtualSwitch" : new Set(["childEntity", "portgroup"]),
            "DistributedVirtualSwitch" : new Set(["childEntity", "portgroup"])
         }
      };

      //configuration parameter set on the directive, see vx-tree-view for more details
      var _config;

      //the controller itself
      var vxTreeViewController = this;

      //These are internally created and used;
      var _kendoTreeView;
      //tracks the node that has to be selected based on the last 'path' request
      var _pendingNodeSelection;
      //the service that manages the updates to the tree
      var _treeUpdatesHandler;
      //the service that persist data for the tree view
      var _treeViewLocalStorage;
      //the flag indicating that the live updates for the inventory tree are enabled
      var _liveUpdatesEnabled;

      //these are initialized based on the directive, see vxTreeView for more details
      var _rootObjRef = $scope.rootObjRef;
      var _preselectedNode = $scope.selectNode;
      var _treeId = $scope.treeId;
      var _persistSelection = !!($scope.options && $scope.options.indexOf('persistselection') > -1);

      // contains the object ids of all VCs which have an opened inventory changelog listener
      var _openedChangelogs = {};

      /**
       * Call this function and provide the kendo tree view to start rolling.
       * It will bind to the necessary events, create and initialize the needed
       * supporting objects and start loading the tree
       * @param kendoTreeView the kendo tree view component
       */
      vxTreeViewController.setupAndRun = function (kendoTreeView, config) {
         _config = angular.extend({
            preselectRoot: true,
            refreshEnabled: false,
            expandPreselectedNode: false
         }, config);

         //preserve the reference to the kendo tree
         _kendoTreeView = kendoTreeView;
         fixExpandPath(kendoTreeView);

         //setup _treeViewLocalStorage
         _treeViewLocalStorage = treeViewLocalStorageService.getLocalStorageByTreeId(_treeId);
         _treeViewLocalStorage.enablePersistence(_persistSelection);

         //trigger loading the tree by binding to the actual datasource
         _kendoTreeView.setDataSource(getDataSourceDefinition());

         //bind the tree events
         bindTreeEvents();

         //get and setup the treeUpdatesHandler
         _treeUpdatesHandler = treeUpdatesHandler(_kendoTreeView, _treeId, _rootObjRef,
            function preserveSelection(updatedItems) {
               var selectedObject = $scope.selectNode;
               if (_.contains(updatedItems, selectedObject)) {
                  locateAndSelect(selectedObject, true);
               }
            }
         );

         //bind to the scope events after the _treeUpdatesHandler is initialized
         bindScopeEvents();
      };

      /**
       * Get the kendo tree datasource
       * @returns {kendo.data.HierarchicalDataSource}
       */
      function getDataSourceDefinition() {
         return new kendo.data.HierarchicalDataSource({
            //The schema of tha data retrieved from the server
            schema: {
               model: {
                  //objRef is the reference to the real object, so we can use it as an id
                  //which is needed for retrieving the children of a node
                  id: 'objRef'
               }
            },

            //data will be retrieved from the server dynamically, so specify a transport
            transport: {
               read: getDataFromServer
            }
         });
      }

      /**
       * Function to be used in the datasource transport for reading
       * @param options See kendo documentation for more details
       * http://docs.telerik.com/kendo-ui/api/javascript/data/datasource#configuration-transport.read
       */
      function getDataFromServer(options) {
         var item, objRef, nodeTypeId, loadingRootNode, gettingData;

         //when expanding a given node its ID(in our case it is objRef) is being provided
         objRef = options.data && options.data.objRef;

         //the presence of objRef is the way to determine the root element or the children
         loadingRootNode = !objRef;
         if (loadingRootNode) {
            gettingData = treeNodeService.getRoot(_treeId, _rootObjRef);
         } else {
            //Sometimes when deleting a node from the tree by calling kendoTreeView.remove(node)
            //the kendo triggers an avalanche of events which finally land here - in
            //an attempt to load the children of the deleted item !
            //Found by deleting a vApp from another machine and the live updates trigger
            //the deletion on this machine
            item = _kendoTreeView.dataSource.get(objRef);
            if (!item) {
               return;
            }
            nodeTypeId = item.nodeTypeId;
            gettingData = treeNodeService.getChildren(_treeId, nodeTypeId, objRef);
         }

         //on successful retrieval show the fetch data
         gettingData.then(options.success);

         if (loadingRootNode) {
            var navTreeLiveUpdatesFlagPromise = configurationService
                  .getProperty('live.updates.navtree.enabled');
            $q.all([gettingData, navTreeLiveUpdatesFlagPromise]).then(function(results) {
               var data = results[0];
               var flagValue = results[1];
               _liveUpdatesEnabled = flagValue && flagValue.toUpperCase() === "TRUE";
               setSelectionAfterLoadingRoot(data);
            });
         }
      }

      function openChangelog(rootId) {
         if (!defaultUriSchemeUtil.isRootFolder(rootId)) {
            return;
         }
         if (_openedChangelogs[rootId]) {
            return;
         }
         if (!_liveUpdatesEnabled) {
            return;
         }
         _openedChangelogs[rootId] = true;
         sendOpenInventoryMessage(rootId);
      }

      function sendOpenInventoryMessage(rootId) {
         var serverGuid = defaultUriSchemeUtil.getPartsFromVsphereObjectId(rootId).serverGuid;
         websocketMessagingService.openInventory(serverGuid);
      }

      function initializeWebsocket() {
         _.each(Object.keys(_openedChangelogs), function (rootId) {
            sendOpenInventoryMessage(rootId);
         });
      }

      function setSelectionAfterLoadingRoot(data) {
         var deferredSelect = $q.defer();
         var initFirstSelection = (function (node, expand) {
            var rootId = data && data[0] && data[0].objRef;
            //create a fallback handleRoot function that may be reused
            //when locateAndSelect doesn't succeed for any reason
            var handleRoot = angular.noop;
            if (rootId) {
               if  (_config.preselectRoot) {
                  handleRoot = _.partial(selectExisting, rootId, true);
               } else {
                  //at least we expand the root
                  handleRoot = function() {
                     _kendoTreeView.expandPath([rootId]);
                     onError(treeViewErrorConstants.SELECTION);
                  };
               }
            }
            //try to locate and select a the specified node, fallback to handleRoot
            locateAndSelect(node, expand)
                  .then(function (isSuccessful) {
                     //if the operation is not successful select the root
                     if (!isSuccessful) {
                        handleRoot();
                     }
                     deferredSelect.resolve();
                  })
                  //some error has occurred so select the root
                  .catch(handleRoot);
         });

         // We have to expand the tree using the persisted expansion data, which is gathered after the clean
         // We have to clean the data, because the inventory might have changed, so the persisted data could be outdated
         // The persisted data will be used only for restoring the previous selection if possible
         var futureExpand = _treeViewLocalStorage.cleanExpandedNodesData().then(expandChildren);
         if (_preselectedNode) {
            //at this point if _preselectedNode is set, it is set from 'scope.selectNode'
            //which means there is a preselection configuration for the directive
            initFirstSelection(_preselectedNode, !!_config.expandPreselectedNode);

            //Delete the _preselectedNode since it is needed only for the very initial
            //loading of the tree and will lead to a buggy behavior - if the tree is refreshed
            //the last selected node should be selected again, not the initial _preselectedNode
            _preselectedNode = null;
         } else {
            _treeViewLocalStorage.getLastSelectedNodeData().then(function (data) {
               initFirstSelection(data.node, data.expanded);
            });
         }

         // When expansion and selection is completed we scroll to the selected element
         $q.all([deferredSelect.promise, futureExpand]).then(scrollToSelectedItem);
      }

      /**
       * Binds to the necessary tree events
       */
      function bindTreeEvents() {
         _kendoTreeView.bind("change", change);
         _kendoTreeView.bind("navigate", navigate);
         _kendoTreeView.bind("expand", expand);
         _kendoTreeView.bind("collapse", collapse);

         var isDragAndDropEnabled = _config ? _config.dragAndDrop : false;

         if (isDragAndDropEnabled) {
            _kendoTreeView.bind(DRAGSTART, onDragStart);
            _kendoTreeView.bind(DRAG, onDrag);
            _kendoTreeView.bind(DRAGEND, onDragEnd);
            _kendoTreeView.bind(DROP, onDrop);

            _kendoTreeView.element.kendoDropTarget({
               group: "gridGroup",
               drop: onDropFromGrid
            });
         }

         function change() {
            var item = _kendoTreeView.dataItem(_kendoTreeView.select());
            if (!item) {
               return;
            }
            $scope.change({
               objRef: item.objRef,
               text: item.text,
               nodeTypeId: item.nodeTypeId,
               item: item
            });
            //notify the local storage
            _treeViewLocalStorage.selectionChanged(item);
         }

         function navigate(evt) {
            var node = evt.node;
            if (!node) {
               return;
            }
            _kendoTreeView.select(node);
         }

         function expand(evt) {
            var item = _kendoTreeView.dataItem(evt.node);
            _treeViewLocalStorage.nodeExpanded(item);
            openChangelog(item.id);
         }

         function collapse(evt) {
            var item = _kendoTreeView.dataItem(evt.node);
            _treeViewLocalStorage.nodeCollapsed(item);
            //when the current selection is inside the node that is being collapsed
            //then change the selection to the collapsed node.
            //This is also the behavior of the flex client
            if (_kendoTreeView.select().closest(evt.node).length) {
               _kendoTreeView.select(evt.node);
            }
         }

         function onDragStart(evt) {
            invokeHandler(acquireHandler(DRAGSTART), evt, evt.sourceNode);
         }

         function onDrag(evt) {
            invokeHandler(acquireHandler(DRAG), evt, evt.dropTarget);
         }

         function onDragEnd(evt) {
            invokeHandler(acquireHandler(DRAGEND), evt, evt.node);
         }

         function onDrop(evt) {
            invokeHandler(acquireHandler(DROP), evt, evt.destinationNode);
         }

         function onDropFromGrid(evt) {
            var destinationNode = $(evt.target).closest('.k-item');
            invokeHandler(acquireHandler(DROP), evt, destinationNode);
         }

         /**
          * Augment the supplied 'evt' object with additional data and
          * invoke the event handler hooked at the $scope object.
          */
         function invokeHandler(fn, evt, dataNode) {
            if (!fn) {
               return;
            }

            // Prepopulate the event object with some additional data.
            evt.vxKendoTreeView = _kendoTreeView;
            evt.vxDataItem = _kendoTreeView.dataItem(dataNode);
            fn(evt);
         }

         function acquireHandler(name) {
            if (!_config["dragAndDropEventHandler"]) {
               return null;
            }

            return _config.dragAndDropEventHandler[name];
         }
      }

      /**
       * Bind to the scope events
       */
      function bindScopeEvents() {
         //Attach a listener for scope.selectNode changes so that the tree may respond
         //by selecting the corresponding node
         $scope.$watch('selectNode', function (newValue, oldValue) {
            //act only upon real changes
            if (newValue === oldValue) {
               return;
            }
            //if the node is already selected skip further processing
            var currentSelectedObj = _kendoTreeView.dataItem(_kendoTreeView.select());
            if (currentSelectedObj && currentSelectedObj.objRef === newValue) {
               return;
            }
            locateAndSelect(newValue, false);
         });

         $rootScope.$on('treeVisibilityStateChanged', function(event, visibilityStateInfo) {
            if (_treeId === "vsphere.core.physicalInventorySpec") {
               if (visibilityStateInfo.isVisible) {
                  _kendoTreeView.dataSource.read();
               } else {
                  $rootScope.$emit("hidingVms", true);
                  _treeUpdatesHandler.handleNodesVisibility(visibilityStateInfo.nodeTypes).then(
                     function(success) {
                        $rootScope.$emit("hidingVms", false);
                        if (!success) {
                           $log.warn("Hiding VMs has failed. VMs might be partially hidden.");
                        }
                     }, function(error) {
                        error.message = error.message || "";
                        $log.error("An error occurred while hiding VMs: " + error.message);
                        $rootScope.$emit("hidingVms", false);
                     }
                  );
               }
            }
         });

         if (_config.refreshEnabled) {
            //Attach a listener for a global refresh event
            $scope.$on('dataRefreshInvocationEvent', function() {
               _kendoTreeView.dataSource.read();
            });

            //Attach a listener for modelChanged event
            $scope.$on('modelChanged', function(event, objectChangeInfo) {
               var objectId = objectChangeInfo.objectId;
               var op = objectChangeInfo.operationType;
               if (op === 'ADD') {
                  _treeUpdatesHandler.add(objectId);
               } else if (op === 'CHANGE') {
                  _treeUpdatesHandler.change(objectId);
               } else if (op === 'DELETE') {
                  _treeUpdatesHandler.handleDelete(objectId);
               } else if (op === 'RELATIONSHIP_CHANGE') {
                  _treeUpdatesHandler.handleMove(objectId).then(function () {
                     var scope = event.currentScope;
                     var preserveSelection = (scope && scope.selectNode === objectId);
                     if (preserveSelection) {
                        locateAndSelect(objectId, true);
                     }
                  });
               } else if (op === 'CHILDREN_UPDATE') {
                  _treeUpdatesHandler.childrenUpdate(objectId);
               }
            });

            // CDC based refresh - 'live refresh'
            $scope.$on('navTree', function (event, partialUpdate) {
               var updates = partialUpdate.updates;
               if (!updates) {
                  return;
               }

               _.each(removeDuplicatedUpdates(updates), function (update) {
                  var updateAsJsonString = JSON.stringify(update);
                  $log.debug(updateAsJsonString);
                  var updateType = update.data.type;
                  if (updateType === treeUpdatesConstants.CHILDREN_UPDATE) {
                     if (!update.source) {
                        return;
                     }
                     var objectType = update.source.type;
                     if (!SUPPORTED_PROPERTIES_FOR_CHILDREN_UPDATE[_treeId][objectType]) {
                        return;
                     }
                     var childrenProperties = update.data.childrenProperties;

                     var hasSupportedChildrenProperty = true;
                     if (childrenProperties && childrenProperties.length > 0) {
                        hasSupportedChildrenProperty = false;
                        for (var property in childrenProperties) {
                           if (SUPPORTED_PROPERTIES_FOR_CHILDREN_UPDATE[_treeId][objectType]
                                    .has(childrenProperties[property])) {
                              hasSupportedChildrenProperty = true;
                              break;
                           }
                        }
                     }
                     if (hasSupportedChildrenProperty) {
                        _treeUpdatesHandler.liveChildrenUpdate(update);
                     }
                  } else if (updateType === treeUpdatesConstants.PROPERTIES_UPDATE) {
                     _treeUpdatesHandler.liveChangeUpdate(update);
                  } else if (updateType === treeUpdatesConstants.DELETE_OBJECT) {
                     _treeUpdatesHandler.liveDelete(update);
                  }
                  // Do nothing when PARENT_UPDATE or invalid update type arrives
               });
            });
         }

         $scope.$on('vxRouteChangeSuccess', function(evt, tree, route) {
            if (route.extensionId === "OBJECT_NOT_FOUND") {
               // Update the tree if it happens that during navigation we found that the
               // object no longer exists.
               _treeUpdatesHandler.change(route.objectId);
            }
         });

         //Re-opened web sockets event listener
         $scope.$on('reOpenWebSocketsEvent', initializeWebsocket);

         $scope.$on('$destroy', function() {
            _treeUpdatesHandler.destroy();
         });
      }

      /**
       * Filters out duplicated partial updates.
       * @param updates An array of partial updates.
       * @returns {Array}
       */
      function removeDuplicatedUpdates(updates) {
         // Certain objects (we call these aliases) are not visible in the tree,
         // but we nevertheless receive updates for them. Sometimes this can cause
         // problems, e.g. when we migrate a VM we receive children updates on the
         // host and its root resource pool, but we only need to handle one of the
         // updates, otherwise we end up with a duplicated node for the migrated
         // VM.
         var result = [];
         var updatesById = _.groupBy(updates, function (update) {
            return defaultUriSchemeUtil.getVsphereObjectId(update.source);
         });
         _.each(updates, function (update) {
            var object = defaultUriSchemeUtil.getVsphereObjectId(update.source);
            var parent = treeNodeService.objAliasesToPrimaryObjId[object];
            // Updates on an object and its alias are considered duplicates if
            // they have the same payload. In this case the update on the alias
            // is filtered out.
            if (!parent
               || !_.some(_.pluck(updatesById[parent], "data"),
                  _.partial(_.isEqual, update.data))) {
               result.push(update);
            }
         });
         return result;
      }

      function getTreeObjectData(objId) {
         return _kendoTreeView.dataSource.get(objId);
      }

      /**
       * If a node that corresponds to the provided objId is already loaded,
       * then select and optionally expand it.
       * Returns true if the operation was successfully accomplished,
       * i.e the node was found and selected, false otherwise
       *
       * @param objId the id of an object which node is to be located and selected
       * @param expand if true the node is expanded upon selection
       * @returns true if the node was found and selected
       */
      function selectExisting(objId, expand) {
         var dataItem = getTreeObjectData(objId);
         if (dataItem) {
            // extra check for null pointers seen in race conditions
            if (!_kendoTreeView.element) {
               return false;
            }
            _kendoTreeView.expandTo(dataItem);
            var node = _kendoTreeView.findByUid(dataItem.uid);
            _kendoTreeView.select(node);
            if (expand) {
               _kendoTreeView.expand(node);
            }
            scrollToSelectedItem();
         }

         return !!dataItem;
      }

      /**
       * This function tries to find a node corresponding to objId in the currently loaded tree nodes.
       * If such a node exists then it is selected.
       * If the node is not found, then a request to the server is sent to 'locate' the node.
       * The server may provide available paths from the root to that node.
       * If exists those paths are used to load the tree up to that node and select it.
       *
       * @param objId the id of tan object which node is to be located and selected
       * @param expand if true the node is expanded upon selection
       * @returns a promise which is resolved when the process has finished.
       *          Resolved with:
       *             null -  if for some reason the expansion did not succeeded
       *             objId - the id of the selected item after a successful expansion
       */
      function locateAndSelect(objId, expand) {
         if (!objId) {
            return $q.resolve(null);
         }

         //try to find the corresponding node, and if it is already loaded select it and return
         if (selectExisting(objId, expand)) {
            return $q.resolve(objId);
         }

         //prepare parameters for the getPath request to the server
         var params = {
            treeId: _treeId,
            objRef: objId,
            options: {
               //the server will return the options parameter as it is
               //so use this to preserve the objId
               selectNode: objId
            }
         };
         //in case the root of the tree is not a fixed object
         if (_rootObjRef) {
            params.rootRef = _rootObjRef;
         }

         //preserve the value before calling the server
         _pendingNodeSelection = objId;
         //call the server to provide available paths
         return treeNodeService.getPath(params).then(validateAndExpandPath);

         function validateAndExpandPath(data) {
            //return if the server hasn't found valid paths
            if (!data || !angular.isArray(data.paths) || !data.paths.length) {
               return $q.resolve(null);
            }

            //in case of a multiple subsequent requests to the server we'd like to
            //proccess only the last one and skip all the previous ones.
            //_pendingNodeSelection contains the last change
            if (data && angular.fromJson(data.options).selectNode !== _pendingNodeSelection) {
               return $q.resolve(null);
            }
            //_pendingNodeSelection is not needed anymore
            _pendingNodeSelection = null;

            //expand the valid path
            return expandValidPath(data.paths, expand);
         }
      }

      /**
       * Expand the path the node choosing the valid path from a list of available paths.
       * This function is called recursively until the valid path for the tree is
       * found or the path list has been exhausted.
       *
       * @param paths available paths from the root node provided by the server
       * @param expand if true the node is expanded upon selection
       * @param deferred (passed automatically during the recursion) a deferred object
       *                 which will be resolved once the expandPath has finished.
       * @returns a promise which is resolved when the process has finished.
       *          Resolved with:
       *             null -  if for some reason the expansion did not succeeded
       *             objId - the id of the selected item after a successful expansion
       */
      function expandValidPath(paths, expand, deferred) {
         if (!deferred) {
            deferred = $q.defer();
         }

         //get the first path and remove it from the list
         var path = paths.shift();
         if (!path) {
            deferred.resolve(null);
            return deferred.promise;
         }

         // We pop the last item because if it is not an expandable element the kendo framework
         // will not call the provided callback
         var objId = path.pop();

         _kendoTreeView.expandPath(path, function () {
            //try to find the corresponding node, and if it is already loaded select it
            //if it is not found than continue to check the remaining paths
            if (selectExisting(objId, expand)) {
               //operation is successful, so resolve the promise
               deferred.resolve(objId);
            } else {
               // There is one kendo flaw that may interfere here:
               // When expanding/loading a node and the server response is being handled
               // the children of that node are built.
               // Then kendo first fires a change notification for that node and after that
               // it marks the node as loaded. This leads to a case where a node may be fully loaded
               // but still loaded() will return false.
               // Since this callback may be called within such a change notification the next
               // expandPath is called after the current call stack has completed, in order to allow
               // kendo to finish its internal processes.
               $timeout(function(){
                  expandValidPath(paths, expand, deferred);
               }, 0);
            }
         });
         return deferred.promise;
      }

      /**
       * Expand the children of the provided node recursively
       */
      function expandChildren(node) {
         var nodeExpansion = $q.defer();
         if (!node || !node.children || Object.keys(node.children).length === 0) {
            nodeExpansion.resolve();
            return nodeExpansion.promise;
         }

         var childrenExpansion = [];
         _.each(node.children, function (childNode, childObjRef) {
            if (!childNode.expanded || !getTreeObjectData(childObjRef)) {
               // The child is has been collapsed or missing. It might be moved or deleted
               return;
            }

            var childExpansion = $q.defer();
            childrenExpansion.push(childExpansion.promise);
            _kendoTreeView.expandPath([childObjRef], function () {
               // Once the whole tree under that child is expanded we resolve the child as resolved
               expandChildren(childNode).then(childExpansion.resolve);
            });
         });

         // Once all the children are expanded we resolve the expansion of the node
         $q.all(childrenExpansion).then(nodeExpansion.resolve);

         return nodeExpansion.promise;
      }

      /**
       * Scroll to the selected item in the tree
       */
      function scrollToSelectedItem() {
         // PR 1899798
         var kendoTreeElement = _kendoTreeView.element;
         if (!kendoTreeElement) {
            return;
         }

         var treeGlobalOffsetTop = kendoTreeElement.offset().top;
         var item = _kendoTreeView.select();
         if (!item || !item.offset()) {
            return;
         }

         var treeScrollTop = kendoTreeElement.scrollTop();
         var itemGlobalScrollTop = item.offset().top;
         var itemLocalScrollTop = (treeScrollTop + itemGlobalScrollTop) - treeGlobalOffsetTop;
         kendoTreeElement.scrollTop(itemLocalScrollTop);
      }

      function onError(error) {
         if (!$scope.error) {
            return;
         }

         $scope.error({
            error: error
         });
      }
   }

   /**
    * kendoTreeView expandPath has a number of issues.
    *
    * 1. If the last item in the path is a leaf (i.e. not an expandable item)
    *    kendo will not call the callback.
    *
    * 2. If an item is in the process of loading, kendo will invoke the callback as though the
    *    whole expandPath process has finished.
    *    Consider the case when the user expands a node (or another expandPath has been triggered
    *    which results in node expansion). Тhen kendo begins to load the children of that node
    *    by first marking that node as expanded, but not loaded(not loaded is expected).
    *    On the other hand when a new expandPath is triggered, kendo checks
    *     node.expanded || node.loaded()
    *    to determine if the node's children are loaded. This is evaluated to TRUE, and the logic
    *    that follows that condition leads to prematurely calling the callback.
    *
    * 3. Calling expandPath will bind to the underlying dataStore each time. This not only leeks
    *    but also envokes the relevant callbacks although the expandPath-s (they may be numerous)
    *    have already finished.
    *
    * This function overrides the original expandPath and fixes issues: 2 & 3
    */
   function fixExpandPath(kendoTreeView) {
      if (kendo.version !== '2015.3.1214') {
         throw 'Verify expandPath of kendoTreeView with the new kendo version';
      }

      //override the original function
      kendoTreeView.expandPath = function(path, complete) {
         path = path.slice(0);
         var treeview = this;
         var dataSource = this.dataSource;
         var node = dataSource.get(path[0]);
         complete = complete || $.noop;

         function tryExpand(node, complete, context) {
            if (node && !node.loaded()) {
               node.set("expanded", true);
            } else {
               // vmware fixing 3
               dataSource.unbind("change", expandLevel);
               complete.call(context);
            }
         }

         // expand loaded nodes
         // vmware fixing 2
         //while (path.length > 0 && node && (node.expanded || node.loaded())) {
         while (path.length > 0 && node && node.loaded()) {
            node.set("expanded", true);
            path.shift();
            node = dataSource.get(path[0]);
         }

         if (!path.length) {
            return complete.call(treeview);
         }

         var expandLevel = function(e) {
            // listen to the change event to know when the node has been loaded
            var id = e.node && e.node.id;
            var node;

            // proceed if the change is caused by the last fetching
            if (id && id === path[0]) {
               path.shift();

               if (path.length) {
                  node = dataSource.get(path[0]);

                  tryExpand(node, complete, treeview);
               } else {
                  // vmware fixing 3
                  dataSource.unbind("change", expandLevel);
                  complete.call(treeview);
               }
            }
         };
         // expand async nodes
         dataSource.bind("change", expandLevel);

         tryExpand(node, complete, treeview);
      };
   }
})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Util methods to help implement directives.
 *
 * Some(most?) should be integrated into AngularJS itself.
 */
angular.module('com.vmware.platform.ui').factory('directiveUtilService', [
function() {
   'use strict';
   return {
      /*
       * Find a parent controller by walking up the dom tree.
       *
       * Should be in angular itself: https://github.com/angular/angular.js/issues/2057
       */
      findParentController: function(elm, controllerName){

         // mostly copy/pasted from angular.js
         var name = '$' + controllerName + 'Controller';
         var element = elm.parent();
         var value;

         while (element.length) {
            value = element.data(name);
            if (value) {
               return value;
            }
            element = element.parent();
          }
      }
   };
}]);
/*
 * This is directly taken from
 * https://github.com/angular-ui/bootstrap/tree/master/src/position
 */
angular.module('com.vmware.platform.ui')

/**
 * A set of utility methods that can be use to retrieve position of DOM elements.
 * It is meant to be used where we need to absolute-position DOM elements in
 * relation to other, existing elements (this is the case for tooltips, popovers,
 * typeahead suggestions etc.).
 */
   .factory('positionService', ['$document', '$window', function ($document, $window) {
      'use strict';
      function getStyle(el, cssprop) {
         if (el.currentStyle) { //IE
            return el.currentStyle[cssprop];
         } else if ($window.getComputedStyle) {
            return $window.getComputedStyle(el)[cssprop];
         }
         // finally try and get inline style
         return el.style[cssprop];
      }

      /**
       * Checks if a given element is statically positioned
       * @param element - raw DOM element
       */
      function isStaticPositioned(element) {
         return (getStyle(element, 'position') || 'static' ) === 'static';
      }

      /**
       * returns the closest, non-statically positioned parentOffset of a given element
       * @param element
       */
      var parentOffsetEl = function (element) {
         var docDomEl = $document[0];
         var offsetParent = element.offsetParent || docDomEl;
         while (offsetParent && offsetParent !== docDomEl && isStaticPositioned(offsetParent)) {
            offsetParent = offsetParent.offsetParent;
         }
         return offsetParent || docDomEl;
      };

      return {
         /**
          * Provides read-only equivalent of jQuery's position function:
          * http://api.jquery.com/position/
          */
         position: function (element) {
            var elBCR = this.offset(element);
            var offsetParentBCR = {top: 0, left: 0};
            var offsetParentEl = parentOffsetEl(element[0]);
            if (offsetParentEl !== $document[0]) {
               offsetParentBCR = this.offset(angular.element(offsetParentEl));
               offsetParentBCR.top += offsetParentEl.clientTop - offsetParentEl.scrollTop;
               offsetParentBCR.left += offsetParentEl.clientLeft - offsetParentEl.scrollLeft;
            }

            var boundingClientRect = element[0].getBoundingClientRect();
            return {
               width: boundingClientRect.width || element.prop('offsetWidth'),
               height: boundingClientRect.height || element.prop('offsetHeight'),
               top: elBCR.top - offsetParentBCR.top,
               left: elBCR.left - offsetParentBCR.left
            };
         },

         /**
          * Provides read-only equivalent of jQuery's offset function:
          * http://api.jquery.com/offset/
          */
         offset: function (element) {
            var boundingClientRect = element[0].getBoundingClientRect();
            return {
               width: boundingClientRect.width || element.prop('offsetWidth'),
               height: boundingClientRect.height || element.prop('offsetHeight'),
               top: boundingClientRect.top + ($window.pageYOffset || $document[0].documentElement.scrollTop),
               left: boundingClientRect.left + ($window.pageXOffset || $document[0].documentElement.scrollLeft)
            };
         },

         /**
          * Provides coordinates for the targetEl in relation to hostEl
          */
         positionElements: function (hostEl, targetEl, positionStr, appendToBody) {

            var positionStrParts = positionStr.split('-');
            var pos0 = positionStrParts[0], pos1 = positionStrParts[1] || 'center';

            var hostElPos,
               targetElWidth,
               targetElHeight,
               targetElPos,
               shiftWidth,
               shiftHeight;
            hostElPos = appendToBody ? this.offset(hostEl) : this.position(hostEl);

            targetElWidth = targetEl.prop('offsetWidth');
            targetElHeight = targetEl.prop('offsetHeight');

            shiftWidth = {
               center: function () {
                  return hostElPos.left + hostElPos.width / 2 - targetElWidth / 2;
               },
               left: function () {
                  return hostElPos.left;
               },
               right: function () {
                  return hostElPos.left + hostElPos.width;
               }
            };

            shiftHeight = {
               center: function () {
                  return hostElPos.top + hostElPos.height / 2 - targetElHeight / 2;
               },
               top: function () {
                  return hostElPos.top;
               },
               bottom: function () {
                  return hostElPos.top + hostElPos.height;
               }
            };

            switch (pos0) {
               case 'right':
                  targetElPos = {
                     top: shiftHeight[pos1](),
                     left: shiftWidth[pos0]()
                  };
                  break;
               case 'left':
                  targetElPos = {
                     top: shiftHeight[pos1](),
                     left: hostElPos.left - targetElWidth
                  };
                  break;
               case 'bottom':
                  targetElPos = {
                     top: shiftHeight[pos0](),
                     left: shiftWidth[pos1]()
                  };
                  break;
               default:
                  targetElPos = {
                     top: hostElPos.top - targetElHeight,
                     left: shiftWidth[pos1]()
                  };
                  break;
            }

            return targetElPos;
         }
      };
   }]);
/**
 * Directive from Angular-ui-bootstrap project that provides a service to apply
 * CSS3 transitions.
 *
 * Original:  https://github.com/angular-ui/bootstrap/blob/master/src/transition/transition.js
 */
/*global document */
/**
 * transitionService provides a consistent interface to trigger CSS 3 transitions and to be informed when they complete.
 * @param  {DOMElement} element  The DOMElement that will be animated.
 * @param  {string|object|function} trigger  The thing that will cause the transition to start:
 *   - As a string, it represents the css class to be added to the element.
 *   - As an object, it represents a hash of style attributes to be applied to the element.
 *   - As a function, it represents a function to be called that will cause the transition to occur.
 * @return {Promise}  A promise that is resolved when the transition finishes.
 */
angular
   .module('com.vmware.platform.ui')
   .factory('transitionService', ['$q', '$timeout', '$rootScope', function($q, $timeout, $rootScope) {

  var $transition = function(element, trigger) {

    var deferred = $q.defer();
    var transitionEndHandler = function(event) {
      $rootScope.$apply(function() {
      element.unbind($transition.transitionEndEventName, transitionEndHandler);
        deferred.resolve(element);
      });
    };

    // Only bind if the browser supports transitions
    if ( $transition.transitionEndEventName ) {
      element.bind($transition.transitionEndEventName, transitionEndHandler);
    }

    // Wrap in a timeout to allow the browser time to update the DOM before the transition is to occur
    $timeout(function() {
      if ( angular.isString(trigger) ) {
        element.addClass(trigger);
      } else if ( angular.isFunction(trigger) ) {
        trigger(element);
      } else if ( angular.isObject(trigger) ) {
        element.css(trigger);
      }

      // If the browser doesn't support transitions then we immediately resolve the event
      if ( !$transition.transitionEndEventName ) {
        deferred.resolve(element);
      }
    });

    // Add out custom cancel function to the promise that is returned
    // We can call this if we are about to run a new transition, which we know will prevent this transition from ending,
    // i.e. it will therefore never raise a transitionEnd event for that transition
    deferred.promise.cancel = function() {
      if ( $transition.transitionEndEventName ) {
        element.unbind($transition.transitionEndEventName, transitionEndHandler);
      }
      deferred.reject('Transition cancelled');
    };

    return deferred.promise;
  };

  // Work out the name of the transitionEnd event
  var transElement = document.createElement('trans');
  var transitionEndEventNames = {
    'WebkitTransition': 'webkitTransitionEnd',
    'MozTransition': 'transitionend',
    'OTransition': 'oTransitionEnd',
    'msTransition': 'MSTransitionEnd',
    'transition': 'transitionend'
  };
  for (var name in transitionEndEventNames){
    if (transElement.style[name] !== undefined) {
      $transition.transitionEndEventName = transitionEndEventNames[name];
    }
  }
  return $transition;
}]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * @ngdoc directive
 * @name com.vmware.platform.ui:vxError
 *
 * @description
 *
 * Directive to show an error tooltip on error in an input.
 * Tooltip is shown when mouseenter event is triggered on the element the directive is attached to.
 * The tooltip will be visible only if the message is not empty and isVisible is set to true. The tooltip is hidden on mouseleave or if the error message becomes empty.
 *
 * |---------|  /-----------------------|
 * | Input   | <  This is the tooltip   |
 * |---------|  \-----------------------|
 *
 *
 * ******
 * Usage:
 * ******
 *
 *  <input type="text" vx-error="booleanConfig"></input>
 *  <input type="text" vx-error="functionConfig"></input>
 *
 *  <script>
 *     $scope.booleanConfig = {
 *        message: 'Some error message',
 *        isVisible: true/false
 *     };
 *
 *     $scope.functionConfig = {
 *        message: 'Some error message',
 *        isVisible: function() {
 *          if(condition){ return true; }
 *          return false;
 *        }
 *     };
 *  </script>
 *
 *<BR>
 *
 *
 *
 * @element input
 * @priority default
 *
 */
(function () {
   'use strict';
angular.module('com.vmware.platform.ui')
   .directive('vxError', [
      '$compile', '$window', '$rootScope', 'positionService',
      function($compile, $window, $rootScope, positionService) {

         return {
            restrict: 'EA',
            require: 'ngModel',
            scope: {
               'vxError': '=' // two way binding
            },
            link: function(scope, element, attrs, ctrl) {
               element.bind('mouseenter', show);
               element.bind('mouseleave', hide);

               var bodyElement = angular.element($window.document.body);
               var templateElement;

               scope.getMessage = function() {
                  if (!scope.vxError) {
                     return '';
                  }
                  if (typeof(scope.vxError.message) === 'function') {
                     return scope.vxError.message();
                  }

                  return scope.vxError.message;
               };

               var template = '<div class="vx-error-tooltip tooltip right in">' +
                  '<div class="tooltip-arrow"></div>' +
                  '<div class="tooltip-inner">{{getMessage()}}</div>' +
                  '</div>';

               templateElement = $compile(template)(scope);

               function positionTooltip() {
                  var ttPosition = positionService.positionElements(element, templateElement, 'right', true);
                  ttPosition.top += 'px';
                  ttPosition.left += 'px';

                  templateElement.css(ttPosition);
               }

               function show() {
                  var isErrorMessageVisible;
                  if (typeof(scope.vxError.isVisible) === 'function') {
                     isErrorMessageVisible = scope.vxError.isVisible.call(scope.vxError, ctrl);
                  } else if (typeof(scope.vxError.isVisible) === 'boolean') {
                     isErrorMessageVisible = scope.vxError.isVisible;
                  }
                  if (isErrorMessageVisible) {
                     bodyElement.append(templateElement);
                     positionTooltip();
                  }
               }

               function hide() {
                  if (templateElement) {
                     templateElement.remove();
                  }
               }

               scope.$on('$destroy', function() {
                  if (templateElement) {
                     templateElement.remove();
                  }
                  cancelOnMessageChange();
               });

               var cancelOnMessageChange = scope.$watch('vxError.message', function(value) {
                  if (_.isEmpty(value)) {
                     hide();
                  }
               });
            }
         };
      }
   ]);
}());

/* Copyright 2014 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * @ngdoc directive
 * @name com.vmware.platform.ui:vxPasswordMatch
 *
 * @description
 * Directive to tell if Confirm password matches password field.
 *
 * ******
 * Usage:
 * ******
 * <pre><code>
 *
 *    <input type="password" id="password" name="password"
 *          ng-model="passwordModel">
 *    </input>
 *
 *    <input type="password" id="confirmPassword" name="confirmPassword"
 *                ng-model="confirmPassword"
 *                vx-password-match="password">
 *    </input>
 *
 *
 *    <span ng-show="showPasswordMatchError(confirmPassword)">
 *       <p>Password mismatch.</p>
 *     </span>
 *
 *    <script>
 *          $scope.showPasswordMatchError = function(elem) {
 *             return elem.$error.passwordMatch;
 *          };
 *    </script>
 *
 * </code></pre>
 *
 * @element input
 * @scope parent
 * @priority default
 *
 */
angular.module('com.vmware.platform.ui').directive('vxPasswordMatch', function () {
   'use strict';
   return {
      require: 'ngModel',
      link: function (scope, elem, attrs, ctrl) {
         var firstPassword = '#' + attrs.vxPasswordMatch;
         elem.bind('focusout', function () {
            var validity = elem.val() === angular.element(firstPassword).val();
            ctrl.$setValidity('passwordMatch', validity);
         });
         elem.add(firstPassword).on('focusout', function () {
            var validity = elem.val() === angular.element(firstPassword).val();
            ctrl.$setValidity('passwordMatch', validity);
         });
      }
   };
});
/* Copyright 2014 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * @ngdoc directive
 * @name com.vmware.platform.ui:vxValid
 *
 * @description
 ** Directive to validate an input field for combination ONE or MORE of the following:<BR>
 * 1. IPv4, IPv6, fully qualified domain name(FQDN). <BR>
 * 2. RegExp expression. <BR>
 * 3. Validation Function.<BR><BR>
 *
 ** Most important part of this directive is that all the validations will be performed
 * and "LOGICAL AND" will be performed on all the results. This means that vxValid element
 * will be marked 'invalid' even if one of the validationRules turns out 'invalid'.<BR>
 *
 ** validationRules: Can have SINGLE or MULTIPLE options.These options can be a combination
 * of contants, regex expressions, and custom validation functions.<BR><BR>
 *
 ** Each validation entry is an javascript object containing a single validation rule,
 * which is in the form of {key: validationOption}. Key is the key which can be used to
 * get the validation result of the validationOption. validationOption could be constant,
 * a regular expression, or a custom validation function. Note that the custom validation
 * function should return a boolean value to indicate if the input passes the validation
 * or not. Any non-boolean value as returned will be ignored and the validity will be false.
 *
 * The validation result (validity) of a rule can be obtained by:
 * someForm.someControl.$error.myErrorKey. myErrorKey is the key of the validation entry.
 *
 ** In case, if input value is an empty string then this directive will not validate the field.
 * To handle validation for non-empty inputs, please use "required" directive like this:
 * <input required/>.
 *
 * In below are examples 'vx-valid' takes a 'vxValidConfig' object.<BR><BR>
 *
 * ******
 * Usage:
 * ******
 * <pre><code>
 *    <input vx-valid ="vxValidConfig" />
 *
 *    <script>
 *      $scope.vxValidConfig = {
 *         validationRules: [
 *            { ipv4: 'ipv4' },
 *            { fqdn: 'fqdn' },
 *            { key1: new RegExp("/^[a-zA-Z ]*$/",'i') },
 *            { key2: function a(input) {return true;} },
 *            { key3: /^[a-zA-Z ]*$/i }
 *         ]
 *      };
 *    </script>
 * </code></pre>
 *<BR>
 *
 * PS: In case you need to add more RegExp constants, you can add them to 'regexConstants' object.<BR>
 *
 * @element input
 * @scope parent
 * @priority default
 *
 */
angular.module('com.vmware.platform.ui')

/**
 * Service which provides regular expressions based on constant strings.
 * In case you need to add more RegExp constants, you can add them to 'regexConstants' object.
 ** Examples:
 * ipv4 and ipv6 - matches with standard IP address formats.
 * fqdn - matches with fully qualified domain name similar to 'promc12-49.vmware.com'
 * port - integer number ranging in between 1 and 49151.
 * url - urls matching with strings beginning with http/https/ftp. For example: https://vapp-upds.vmware.com/catalog/alm/8e7-69/5.5.0.10.latest
 * or it could match with simple urls like http://acme.com/
 **/
.constant(
   'regexConstants', {
      'ipv4': /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,
      'ipv6': /^((?=.*::)(?!.*::.+::)(::)?([\dA-F]{1,4}:(:|\b)|){5}|([\dA-F]{1,4}:){6})((([\dA-F]{1,4}((?!\3)::|:\b|$))|(?!\2\3)){2}|(((2[0-4]|1\d|[1-9])?\d|25[0-5])\.?\b){4})$/i,
      'fqdn': /^(?=.{1,254}$)((?=[a-z0-9-]{1,63}\.)(xn--)?[a-z0-9]+(-[a-z0-9]+)*\.)+[a-z]{2,63}$/i,
      'port': /^(4915[0-1]|491[0-4]\d|490\d\d|4[0-8]\d{3}|[1-3]\d{4}|[1-9]\d{0,3}|0)$/,
      'url' : /\(?(?:(http|https|ftp):\/\/)?(?:((?:[^\W\s]|\.|-|[:]{1})+)@{1})?((?:www.)?(?:[^\W\s]|\.|-)+[\.][^\W\s]{2,4}|localhost(?=\/)|\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})(?::(\d*))?([\/]?[^\s\?]*[\/]{1})*(?:\/?([^\s\n\?\[\]\{\}\#]*(?:(?=\.)){1}|[^\s\n\?\[\]\{\}\.\#]*)?([\.]{1}[^\s\?\#]*)?)?(?:\?{1}([^\s\n\#\[\]]*))?([\#][^\s\n]*)?\)?/
   }
)

.directive('vxValid', ['regexConstants',

   function(regexConstants) {
      'use strict';

      return {
         restrict: 'A',
         require: 'ngModel',
         link: function(scope, element, attrs, ctrl) {

            /**
             * TODO - Below is a work around for retrieving the validation options from
             * the scope of <input/>. This work around needs to be modified once angularjs
             * is updgraded to 1.2.0 RC3 or above. Scope of this directive must be changed
             * to isolated. This is happening because ngModel doesnt work in isolated scope.
             **/
            var validationRules = scope[attrs.vxValid].validationRules;

            function getRegExp(key) {
               return regexConstants[key];
            }

            /**
             * Add a parser to the <input/> element.
             * This function is invoked everytime the input is edited.
             **/
            ctrl.$parsers.unshift(function(input) {
               var isValid = false;
               var isValidationPerformed = false;

               if (typeof(validationRules) !== 'undefined' && input !== '') {
                  if(!Array.isArray(validationRules)){
                     validationRules = [validationRules];
                  }

                  // Validation is performed for every option in validationRules.
                  validationRules.forEach(function(option) {
                     // get the key and the validation rule
                     var key = Object.keys(option)[0];
                     var validationRule = option[key];
                     var valid = false;

                     /**
                      * 1. Input validated against constant RegExp.
                      * 2. Else, Input validated against custom RegExp.
                      * 3. Else, Input validated against executable Function.
                      **/
                     if (typeof(validationRule) === 'string') {
                        valid = getRegExp(validationRule).test(input);
                     } else if (validationRule instanceof RegExp) {
                        valid = validationRule.test(input);
                     } else if (typeof(validationRule) === 'function') {
                        var funcResult = validationRule(input);
                        if(typeof(funcResult) === 'boolean'){
                           valid = funcResult;
                        }
                     }

                     isValid = isValid || valid;

                     ctrl.$setValidity(key, valid);
                  });
                  isValidationPerformed = true;
               }

               // If none of the above validations are peformed then return true.
               isValid = isValid || !isValidationPerformed;

               // Set the vailidity of the input element with the result of validation.
               ctrl.$setValidity('vxValid', isValid);

               // If input is valid then return the input else return undefined.
               if (isValid) {
                  return input;
               } else {
                  return undefined;
               }
            });
         }
      };
   }
]);
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Filter turn boolean into @trueValue/@falseValue or Yes/No by default
 */
angular.module('com.vmware.platform.ui').filter('boolean', ['$filter', 'i18nService',
   function($filter, i18nService) {
      'use strict';
      return function(value, trueValue, falseValue) {
         trueValue = trueValue || i18nService.getString("Common", "yes.label");
         falseValue = falseValue || i18nService.getString("Common", "no.label");
         return value ? trueValue : falseValue;
      };
   }]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Filter turn format numbers into the closest byte unit Eg: 1024 to 1 kB,
 * 1024*1024 to 1 MB
 */
// originally from https://gist.github.com/thomseddon/3511330
angular.module('com.vmware.platform.ui').filter('bytes', bytesFilter);

bytesFilter.$inject = ['numberFormatterService'];

function bytesFilter (numberFormatterService) {
   'use strict';

   return function (bytes, sourceUnit, targetUnit, fractionSize) {
      return numberFormatterService.formatStorage(bytes, sourceUnit, targetUnit, fractionSize);
   };
}

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Display a mhz value as either MHz or GHz depending on the magnitude
 */
angular.module('com.vmware.platform.ui').filter('cpuClock', cpuClockFilter);

cpuClockFilter.$inject = ['i18nService', 'numberFormatterService'];

function cpuClockFilter(i18nService, numberFormatterService) {
   'use strict';
   return function (cpuMhz) {
      var suffixMHz = i18nService.getString('VmUi', "VmCpu.MHz");
      var suffixGHz = i18nService.getString('VmUi', "VmCpu.GHz");

      if (cpuMhz < 0) {
         return i18nService.getString('VmUi', "labelUnlimited");
      }

      var suffix;

      if (((cpuMhz % 1000) === 0) && (cpuMhz > 0)) {
         cpuMhz = cpuMhz / 1000;
         suffix = suffixGHz;
      } else {
         suffix = suffixMHz;
      }

      return numberFormatterService.format(cpuMhz, { suffix: suffix });
   };
}

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Takes in the resource-info valueTypeName and apply a default formatter to it
 */
angular.module('com.vmware.platform.ui').filter('dataFormat', ['$filter',
function($filter) {
   return function(raw, valueTypeName) {

      // valueTypeName to formatter definition
      var map = {
            'Storage.B' : {
               name: 'bytes'
            }
      };
      var meta = map[valueTypeName];
      if (!meta) {
         return raw;
      }

      return $filter(meta.name)(raw);
   };
}]);
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Filter turn boolean into @trueValue/@falseValue or Yes/No by default
 */
angular.module('com.vmware.platform.ui').filter('dateLocale', ['timeFormatterService',
   function(timeFormatterService) {
      'use strict';
      return function(value) {
         return timeFormatterService.timestampToText(value);
      };
   }]);
/**
 * Created by vmware on 12/2/16.
 */
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Filter turn boolean into @trueValue/@falseValue or Enabled/Disabled by default
 */
angular.module('com.vmware.platform.ui').filter('enabled', ['$filter', 'i18nService',
   function($filter, i18nService) {
      'use strict';
      return function(value, trueValue, falseValue) {
         trueValue = trueValue || i18nService.getString("Common", "enabled");
         falseValue = falseValue || i18nService.getString("Common", "disabled");

         value = !!value;
         return value ? trueValue : falseValue;
      };
   }]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
angular.module('com.vmware.platform.ui').filter('errorFormat',
   function () {
   'use strict';

   /**
    * @param newLineSymbol
    *    The string to use instead of the default new line symbol. The default value
    *    is <br> as this is going to be used for HTML error display.
    */
   return function (errorObject, newLineSymbol) {
      if (errorObject === null) {
         return "null";
      }

      if (!newLineSymbol) {
         newLineSymbol = "<br>";
      }

      var message, messageData;

      // This is a JavaScript error object.
      if (errorObject instanceof Error) {
         messageData = [];
         if (errorObject.message) {
            messageData.push(errorObject.message);
         }
         if (errorObject.name) {
            messageData.push("name: " + errorObject.name);
         }
         // MS
         if (errorObject.description) {
            messageData.push(errorObject.description);
         }
         if (errorObject.number) {
            messageData.push("number: " + errorObject.number);
         }
         // Mozilla
         if (errorObject.fileName) {
            messageData.push("file: " + errorObject.fileName);
         }
         if (errorObject.lineNumber) {
            messageData.push("line: " + errorObject.lineNumber);
         }
         if (errorObject.columnNumber) {
            messageData.push("col: " + errorObject.columnNumber);
         }
         if (errorObject.stack) {
            messageData.push("stack: " + errorObject.stack);
         }
         message = "UnexpectedError (js): " + messageData.join("\n");
         return escape(message, newLineSymbol);
      }

      // We prefer the object's own error formatting (if available);
      message = errorObject.toString();
      if (message !== "[object Object]") {
         return message;
      }

      // We recognize some Angular supplied pure objects, i.e ones returned by
      // the $httpBackend when remote calls return errors.
      if (errorObject.data) {
         messageData = [];
         var data = errorObject.data;
         if (data.message) {
            messageData.push(data.message);
         }
         if (data.cause) {
            messageData.push("cause: " + data.cause);
         }
         if (data.stackTrace) {
            messageData.push("stack: " + data.stackTrace);
         }

         if (messageData.length > 0) {
            message = "UnexpectedError (object): " + messageData.join("\n");
            return escape(message, newLineSymbol);
         }
      }

      // Stringify the object. That is the default formatting when all other
      // options are exhausted.
      message = JSON.stringify(errorObject);
      return escape("UnexpectedError (json): " + message, newLineSymbol);

      function escape(message, newLineSeparator) {
         var newMessage = _.escape(message);
         if (newLineSeparator !== "\n") {
            newMessage = newMessage.replace(/\n|\\n/g, newLineSeparator);
         }
         return newMessage;
      }
   };
});

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/*
 * Filter turns floating point numbers into integers always rounding to the higher integer using Math.ceil
 */

angular.module('com.vmware.platform.ui').filter('ceil', function() {
   return function(input) {
      return Math.ceil(input);
   };
});
/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Reverse an array
 */
angular.module('com.vmware.platform.ui').filter('reverse', [
function() {
   return function(items) {
      return items.slice().reverse();
    };
}]);
/* Copyright (c) 2018 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var HtmlBridgePluginModalIFrame = (function () {
        function HtmlBridgePluginModalIFrame() {
            this.bindings = {
                "url": "<",
                "closeModal": "&"
            };
            this.template = "<iframe ng-src=\"{{$ctrl.url}}\" class=\"sandbox-iframe\"></iframe>";
            this.controller = HtmlBridgePluginModalIFrameController;
        }
        return HtmlBridgePluginModalIFrame;
    }());
    var HtmlBridgePluginModalIFrameController = (function () {
        function HtmlBridgePluginModalIFrameController($element, h5SdkCommonService, telemetryService) {
            this.$element = $element;
            this.h5SdkCommonService = h5SdkCommonService;
            this.telemetryService = telemetryService;
        }
        HtmlBridgePluginModalIFrameController.prototype.$onInit = function () {
            var _this = this;
            var element = this.$element[0];
            element.classList.add("plugin-resource(" + this.url + ")");
            var iframe = element.querySelector("iframe");
            iframe.addEventListener("load", function (event) {
                iframe.focus();
                if (!iframe.contentWindow ||
                    _this.h5SdkCommonService.isCrossDomainIFrame(iframe)) {
                    return;
                }
                iframe.contentWindow.addEventListener("keyup", function (evt) {
                    if (evt.keyCode === 27 || evt.key === "Escape") {
                        _this.closeModal();
                    }
                });
                _this.telemetryService
                    .startTrackingWindowEvents(iframe.contentWindow);
                iframe.contentWindow.addEventListener("unload", function () {
                    if (iframe.contentWindow &&
                        !_this.h5SdkCommonService.isCrossDomainIFrame(iframe)) {
                        _this.telemetryService
                            .stopTrackingWindowEvents(iframe.contentWindow);
                    }
                });
            });
        };
        HtmlBridgePluginModalIFrameController.$inject = [
            "$element",
            "h5SdkCommonService",
            "telemetryService"
        ];
        return HtmlBridgePluginModalIFrameController;
    }());
    angular.module("com.vmware.platform.ui").component("htmlBridgePluginModalIframe", new HtmlBridgePluginModalIFrame());
})(platform || (platform = {}));



/* Copyright (c) 2017-2019 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    function pluginIframe() {
        return {
            restrict: "E",
            template: "",
            scope: {
                viewUrl: "<",
                isModal: "<?",
                viewUrlParams: "<?",
                context: "<?",
                viewId: "<?",
                remotePluginExtensionContext: "<?"
            },
            controller: PluginIframeController,
            controllerAs: "ctrl"
        };
    }
    /**
     * The class is used to create a plugin pinger that pings periodically a given plugin and
     * associates the plugin session with the client session making an HTTP request.
     */
    var PingPlugin = (function () {
        function PingPlugin(pluginUrlService, vxZoneService, pingUrl) {
            this.pluginUrlService = pluginUrlService;
            this.vxZoneService = vxZoneService;
            this.pingUrl = pingUrl;
            this.PING_INTERVAL = 25 * 60 * 1000; // 25 minutes
            this.timerId = null;
        }
        /**
         * Starts a timer and starts pinging the specified plugin url.
         */
        PingPlugin.prototype.start = function () {
            var _this = this;
            this.stop();
            this.vxZoneService.runOutsideAngular(function () {
                _this.timerId =
                    setInterval(_this.onTimerTriggerEvent.bind(_this), _this.PING_INTERVAL);
            });
        };
        /**
         * Stops the timer and stops pinging the specified plugin url.
         */
        PingPlugin.prototype.stop = function () {
            var _this = this;
            this.vxZoneService.runOutsideAngular(function () {
                if (_this.timerId !== null) {
                    clearInterval(_this.timerId);
                    _this.timerId = null;
                }
            });
        };
        /**
         * Associates a plugin session with the client session
         * once the ping interval passed.
         */
        PingPlugin.prototype.onTimerTriggerEvent = function () {
            this.pluginUrlService.associatePluginSessionWithClientId(this.pingUrl);
        };
        return PingPlugin;
    }());
    /**
     * This controller defines how plugin iframe is created and destroyed.
     */
    var PluginIframeController = (function () {
        function PluginIframeController($scope, $element, h5SdkApiService, configurationService, pluginUrlService, vxZoneService, iframeNavigationDataCache, $q, $compile, sessionTimeoutService, userSessionService, $log, $location, h5RemoteSdkAdapterService, h5SdkCommonService, telemetryService) {
            var _this = this;
            this.$scope = $scope;
            this.$element = $element;
            this.h5SdkApiService = h5SdkApiService;
            this.configurationService = configurationService;
            this.pluginUrlService = pluginUrlService;
            this.vxZoneService = vxZoneService;
            this.iframeNavigationDataCache = iframeNavigationDataCache;
            this.$q = $q;
            this.$compile = $compile;
            this.sessionTimeoutService = sessionTimeoutService;
            this.userSessionService = userSessionService;
            this.$log = $log;
            this.$location = $location;
            this.h5RemoteSdkAdapterService = h5RemoteSdkAdapterService;
            this.h5SdkCommonService = h5SdkCommonService;
            this.telemetryService = telemetryService;
            this.onIframeUnloadBound = this.onIframeUnload.bind(this);
            this.extendUserSessionBound = this.extendUserSession.bind(this);
            this.redispatchIframeMouseEventBound = this.redispatchIframeMouseEvent.bind(this);
            this.userSessionExtendedTime = new Date().getTime();
            this.lastSdkReloadPluginExtensionsValue = "";
            this.EXTEND_USER_SESSION_INTERVAL = 5 * 60 * 1000; // 5 minutes
            this.isRemotePlugin = !!this.$scope.remotePluginExtensionContext;
            this.pingPlugin =
                new PingPlugin(pluginUrlService, vxZoneService, this.$scope.viewUrl);
            var sdkFeaturesEnabledPromise = this.configurationService
                .getProperty('experimental.sdk.features.enabled')
                .then(function (propVal) { return _this.$q.when(propVal === 'true'); });
            var userSessionLocalePromise = this.userSessionService
                .getUserSession()
                .then(function (userSession) { return _this.$q.when(userSession.locale); });
            this.$q.all({
                sdkFeaturesEnabled: sdkFeaturesEnabledPromise,
                userSessionLocale: userSessionLocalePromise
            }).then(function (result) {
                // session association is not needed for remote plugins since they come
                // from a different domain
                if (!_this.isRemotePlugin) {
                    return _this.pluginUrlService
                        .associatePluginSessionWithClientId(_this.$scope.viewUrl)
                        .then(function () { return result; });
                }
                else {
                    return result;
                }
            }).then(function (result) {
                _this.$scope.$on("viewDidLoad", function (event, viewId) {
                    if (_this.$scope.viewId !== viewId) {
                        return;
                    }
                    _this.replaceNavigationData();
                });
                _this.$scope.$on("viewDidUpdate", function (event, viewId) {
                    if (_this.$scope.viewId !== viewId) {
                        return;
                    }
                    /*
                     * See comment in H5SdkApplicationApi.navigateTo() for more
                     * information why this check is performed.
                     */
                    var route = _this.$location.search();
                    if (!route || !route.sdkReloadPluginExtensions ||
                        route.sdkReloadPluginExtensions === _this.lastSdkReloadPluginExtensionsValue) {
                        return;
                    }
                    _this.lastSdkReloadPluginExtensionsValue =
                        route.sdkReloadPluginExtensions;
                    _this.replaceNavigationData();
                    /*
                     * When a "viewDidUpdate" event comes we need to reload the
                     * plugin view in case the navigation data has changed.
                     * See https://jira.eng.vmware.com/browse/VUSP-2156 or
                     * https://bugzilla.eng.vmware.com/show_bug.cgi?id=2273357
                     */
                    _this.reloadPluginView();
                });
                _this.replaceNavigationData();
                return result;
            }).then(function (result) {
                var iframeTemplateString = _this.isRemotePlugin ?
                    PluginIframeController.REMOTE_PLUGIN_IFRAME_TEMPLATE :
                    PluginIframeController.LOCAL_PLUGIN_IFRAME_TEMPLATE;
                _this.iframe = _this.$compile(iframeTemplateString)(_this.$scope).get(0);
                _this.locale = result.userSessionLocale;
                _this.setIframeUrl();
                _this.$scope.$watch('viewUrlParams.vcSelectorSelection', function (newValue, oldValue) {
                    if (newValue === oldValue) {
                        return;
                    }
                    _this.setIframeUrl();
                });
                var classList = $element[0].classList;
                if (_this.$scope.viewId) {
                    classList.add("plugin-extension(" + _this.$scope.viewId + ")");
                }
                else {
                    var viewUrl = _this.trustedUrl.valueOf();
                    if (_this.isRemotePlugin) {
                        if (!PluginIframeController.REMOTE_PLUGIN_PROXIED_URL_REGEX.test(viewUrl)) {
                            $log.warn(("PluginIframeController: viewUrl: " + viewUrl) +
                                (" for remote plugin extension context id: " + _this.$scope.remotePluginExtensionContext.contextId) +
                                " is not proxied!");
                        }
                        viewUrl = viewUrl.replace(PluginIframeController.REMOTE_PLUGIN_PROXIED_URL_REGEX, "$1/<obfuscated>$3");
                    }
                    classList.add("plugin-resource(" + viewUrl + ")");
                }
                _this.h5SdkInitializer =
                    _this.h5SdkApiService.getH5SdkApi(_this.$scope);
                _this.htmlClientSdk = _this.h5SdkInitializer.sdk;
                if (_this.isRemotePlugin && _this.supportsShadowDom) {
                    _this.iframe.style.display = "block";
                    _this.iframe.style.boxSizing = "border-box";
                    _this.iframe.style.width = "100%";
                    _this.iframe.style.height = "100%";
                    _this.iframe.style.border = "0";
                    _this.shadowRoot = _this.$element[0].attachShadow({
                        mode: h5.debug ? "open" : "closed"
                    });
                    _this.shadowRoot.appendChild(_this.iframe);
                }
                else {
                    _this.$element.append(_this.iframe);
                }
                return result;
            }).then(function (result) {
                // Closes the modal dialog on ESC button click inside an iframe
                if (_this.$scope.isModal) {
                    _this.iframe.addEventListener("load", function (event) {
                        // focus on the iframe, after the iframe is loaded
                        // (also fixing a bug when a modal is opened and the selected
                        // object is behind the modal)
                        _this.iframe.focus();
                    });
                }
                if (_this.isRemotePlugin) {
                    _this.bootstrapRemotePluginSdk();
                }
                else {
                    _this.bootstrapLocalPluginSdk();
                }
                return result;
            });
        }
        Object.defineProperty(PluginIframeController.prototype, "supportsShadowDom", {
            get: function () {
                return !!this.$element[0].attachShadow;
            },
            enumerable: true,
            configurable: true
        });
        PluginIframeController.prototype.$onInit = function () {
            // pinging is not needed for remote plugins since they come
            // from a different domain
            if (!this.isRemotePlugin) {
                this.pingPlugin.start();
            }
        };
        PluginIframeController.prototype.$onDestroy = function () {
            this.pingPlugin.stop();
            this.pingPlugin = null;
            if (this.isRemotePlugin) {
                if (this.h5RemoteSdkAdapter) {
                    this.h5RemoteSdkAdapter.destroy();
                    this.h5RemoteSdkAdapter = null;
                }
            }
            else {
                if (this.iframe) {
                    this.iframe.htmlClientSdk = null;
                    if (this.iframe.contentWindow &&
                        !this.h5SdkCommonService.isCrossDomainIFrame(this.iframe)) {
                        this.iframe.contentWindow.removeEventListener("unload", this.onIframeUnloadBound);
                        this.iframe.contentWindow.removeEventListener("mousedown", this.extendUserSessionBound);
                        for (var _i = 0, _a = PluginIframeController.mouse_event_names; _i < _a.length; _i++) {
                            var mouseEventName = _a[_i];
                            this.iframe.contentWindow.removeEventListener(mouseEventName, this.redispatchIframeMouseEventBound);
                        }
                        this.telemetryService.stopTrackingWindowEvents(this.iframe.contentWindow);
                    }
                }
            }
            if (this.h5SdkInitializer) {
                this.h5SdkInitializer.destroy();
                this.h5SdkInitializer = null;
            }
        };
        /**
         * Replace the value returned by getNavigationData() API.
         */
        PluginIframeController.prototype.replaceNavigationData = function () {
            this.iframeNavigationDataCache.updateNavigationData(this.$scope.viewId);
        };
        /**
         * Handles the unload of the iframe content
         */
        PluginIframeController.prototype.onIframeUnload = function () {
            if (!this.h5SdkCommonService.isCrossDomainIFrame(this.iframe) &&
                this.iframe.contentWindow) {
                this.telemetryService.stopTrackingWindowEvents(this.iframe.contentWindow);
            }
            if (this.h5SdkInitializer) {
                this.h5SdkInitializer.onIframeUnload();
            }
        };
        /**
         * Extends the user session in the iframe so that it does not expire while
         * in a plugin's view
         */
        PluginIframeController.prototype.extendUserSession = function () {
            var currentTime = new Date().getTime();
            var timeDifference = Math.abs(currentTime - this.userSessionExtendedTime);
            if (timeDifference > this.EXTEND_USER_SESSION_INTERVAL) {
                this.sessionTimeoutService.resetSessionTimeout();
                this.userSessionExtendedTime = currentTime;
            }
        };
        PluginIframeController.prototype.redispatchIframeMouseEvent = function (mouseEventProperties) {
            var iframeOffset = this.iframe.getBoundingClientRect();
            var clientX = iframeOffset.left + mouseEventProperties.clientX;
            var clientY = iframeOffset.top + mouseEventProperties.clientY;
            var redispatchedEvent;
            // handle IE's lack of support for new MouseEvent()
            if (typeof MouseEvent !== 'function') {
                redispatchedEvent = document.createEvent('MouseEvents');
                // https://developer.mozilla.org/en-US/docs/Web/API/MouseEvent/initMouseEvent
                redispatchedEvent.initMouseEvent(mouseEventProperties.type, // type
                true, // canBubble
                true, // cancelable
                window, // view
                0, // detail
                mouseEventProperties.screenX, // screenX
                mouseEventProperties.screenY, // screenY
                clientX, // clientX
                clientY, // clientY
                false, // ctrlKey
                false, // altKey
                false, // shiftKey
                false, // metaKey
                mouseEventProperties.button, // button
                null // relatedTarget
                );
            }
            else {
                redispatchedEvent = new MouseEvent(mouseEventProperties.type, {
                    bubbles: true,
                    cancelable: true,
                    button: mouseEventProperties.button,
                    buttons: mouseEventProperties.buttons,
                    screenX: mouseEventProperties.screenX,
                    screenY: mouseEventProperties.screenY,
                    clientX: clientX,
                    clientY: clientY
                });
            }
            this.$element[0].dispatchEvent(redispatchedEvent);
        };
        PluginIframeController.prototype.bootstrapLocalPluginSdk = function () {
            var _this = this;
            // Bootstrap JavaScript APIs.
            this.iframe.htmlClientSdk = Object.freeze(this.htmlClientSdk);
            this.iframe.addEventListener("load", function (event) {
                if (_this.h5SdkCommonService.isCrossDomainIFrame(_this.iframe)) {
                    return;
                }
                if (_this.$scope.isModal) {
                    _this.iframe.contentWindow.addEventListener("keyup", function (evt) {
                        if (evt.keyCode === 27 || evt.key === "Escape") {
                            _this.iframe.htmlClientSdk.modal.close();
                        }
                    });
                }
                _this.iframe.contentWindow.addEventListener("unload", _this.onIframeUnloadBound);
                _this.iframe.contentWindow.addEventListener("mousedown", _this.extendUserSessionBound);
                for (var _i = 0, _a = PluginIframeController.mouse_event_names; _i < _a.length; _i++) {
                    var mouseEventName = _a[_i];
                    _this.iframe.contentWindow.addEventListener(mouseEventName, _this.redispatchIframeMouseEventBound);
                }
                _this.telemetryService.startTrackingWindowEvents(_this.iframe.contentWindow);
            });
        };
        PluginIframeController.prototype.bootstrapRemotePluginSdk = function () {
            this.h5RemoteSdkAdapter = this.h5RemoteSdkAdapterService.createH5RemoteSdkAdapter(this.iframe, this.htmlClientSdk, this.$scope, this.extendUserSessionBound, this.onIframeUnloadBound, this.redispatchIframeMouseEventBound);
        };
        PluginIframeController.prototype.reloadPluginView = function () {
            if (!this.iframe || !this.iframe.parentNode) {
                return;
            }
            var iframeParentNode = this.iframe.parentNode;
            iframeParentNode.removeChild(this.iframe);
            iframeParentNode.appendChild(this.iframe);
        };
        PluginIframeController.prototype.setIframeUrl = function () {
            if (!this.$scope.viewUrlParams) {
                this.$scope.viewUrlParams = {};
            }
            this.$scope.viewUrlParams.locale = this.locale;
            if (this.isRemotePlugin) {
                this.trustedUrl = this.pluginUrlService.trustPluginUrl(this.$scope.viewUrl);
            }
            else {
                this.trustedUrl = this.pluginUrlService.buildUrl(this.$scope.viewUrl, this.$scope.viewUrlParams);
            }
        };
        PluginIframeController.$inject = [
            "$scope",
            "$element",
            "h5SdkApiService",
            "configurationService",
            "pluginUrlService",
            "vxZoneService",
            "iframeNavigationDataCache",
            "$q",
            "$compile",
            "sessionTimeoutService",
            "userSessionService",
            "$log",
            "$location",
            "h5RemoteSdkAdapterService",
            "h5SdkCommonService",
            "telemetryService"
        ];
        PluginIframeController.REMOTE_PLUGIN_PROXIED_URL_REGEX = new RegExp("^(/plugins/[^/]+)(/[^/]+)(/.*$)", "i");
        PluginIframeController.LOCAL_PLUGIN_IFRAME_TEMPLATE = "<iframe ng-src=\"{{ctrl.trustedUrl}}\" class=\"sandbox-iframe\"></iframe>";
        PluginIframeController.REMOTE_PLUGIN_IFRAME_TEMPLATE = "<iframe ng-src=\"{{ctrl.trustedUrl}}\" sandbox=\"allow-scripts allow-same-origin allow-forms\" class=\"sandbox-iframe\"></iframe>";
        PluginIframeController.mouse_event_names = ["mousedown", "mouseup", "mousemove", "click"];
        return PluginIframeController;
    }());
    angular.module("com.vmware.platform.ui").directive("pluginIframe", pluginIframe);
})(platform || (platform = {}));



/* Copyright (c) 2018 VMware, Inc. All rights reserved. -- VMware
 Confidential */
var platform;
(function (platform) {
    /**
     * Wrapper component designed specifically to upgrade pluginIframe directive and
     * allow pluginIframe usage in angular.next components.
     */
    var UpgradablePluginIframe = (function () {
        function UpgradablePluginIframe() {
            this.controller = UpgradablePluginIframeController;
            this.bindings = {
                viewUrl: "=",
                isModal: "=?",
                viewUrlParams: "=?",
                context: "=?",
                viewId: "=?",
            };
            this.template =
                "<plugin-iframe\n                  ng-style=\"style\"\n                  class=\"sandbox-iframe vx-portlet-content\"\n                  view-url=\"$ctrl.viewUrl\"\n                  is-modal=\"$ctrl.isModal\"\n                  view-url-params=\"$ctrl.viewUrlParams\"\n                  context=\"$ctrl.context\"\n                  view-id=\"$ctrl.viewId\"\n            ></plugin-iframe>";
        }
        return UpgradablePluginIframe;
    }());
    platform.UpgradablePluginIframe = UpgradablePluginIframe;
    var UpgradablePluginIframeController = (function () {
        function UpgradablePluginIframeController() {
        }
        return UpgradablePluginIframeController;
    }());
    angular.module("com.vmware.platform.ui")
        .component("upgradablePluginIframe", new UpgradablePluginIframe());
})(platform || (platform = {}));



/* Copyright (c) 2017 VMware, Inc. All rights reserved. */
var platform;
(function (platform) {
    var H5RemoteSdkAdapterService = (function () {
        function H5RemoteSdkAdapterService($http, $log, telemetryService, telemetryHelperService) {
            this.$http = $http;
            this.$log = $log;
            this.telemetryService = telemetryService;
            this.telemetryHelperService = telemetryHelperService;
        }
        H5RemoteSdkAdapterService.prototype.createH5RemoteSdkAdapter = function (pluginIFrame, htmlClientSdk, $scope, extendUserSession, onIframeUnload, redispatchIframeMouseEvent) {
            return new H5RemoteSdkAdapter(this.$http, this.$log, this.telemetryService, this.telemetryHelperService, window, pluginIFrame, htmlClientSdk, $scope, extendUserSession, onIframeUnload, redispatchIframeMouseEvent);
        };
        H5RemoteSdkAdapterService.$inject = [
            '$http',
            '$log',
            'telemetryService',
            'telemetryHelperService'
        ];
        return H5RemoteSdkAdapterService;
    }());
    platform.H5RemoteSdkAdapterService = H5RemoteSdkAdapterService;
    var H5RemoteSdkAdapter = (function () {
        function H5RemoteSdkAdapter($http, $log, telemetryService, telemetryHelperService, appWindow, pluginIFrame, htmlClientSdk, $scope, extendUserSession, onIframeUnload, redispatchIframeMouseEvent) {
            var _this = this;
            this.$http = $http;
            this.$log = $log;
            this.telemetryService = telemetryService;
            this.telemetryHelperService = telemetryHelperService;
            this.appWindow = appWindow;
            this.pluginIFrame = pluginIFrame;
            this.htmlClientSdk = htmlClientSdk;
            this.$scope = $scope;
            this.extendUserSession = extendUserSession;
            this.onIframeUnload = onIframeUnload;
            this.redispatchIframeMouseEvent = redispatchIframeMouseEvent;
            this.onPluginIFrameMessageBound = this.onPluginIFrameMessage.bind(this);
            this.appWindow.addEventListener("message", this.onPluginIFrameMessageBound);
            this.removeContentWindowValueWatch = $scope.$watch(function () { return _this.pluginIFrame.contentWindow; }, function (newValue, oldValue) {
                if (!newValue && oldValue) {
                    _this.onIframeUnload();
                }
            });
        }
        H5RemoteSdkAdapter.prototype.destroy = function () {
            this.appWindow.removeEventListener("message", this.onPluginIFrameMessageBound);
            if (this.removeContentWindowValueWatch) {
                this.removeContentWindowValueWatch();
                this.removeContentWindowValueWatch = null;
            }
        };
        H5RemoteSdkAdapter.prototype.onPluginIFrameMessage = function (event) {
            var _this = this;
            if (!this.pluginIFrame ||
                !event.source ||
                event.source !== this.pluginIFrame.contentWindow) {
                return;
            }
            var operation = event.data.operation;
            var payload = event.data.payload;
            /*
             * INTERNAL
             */
            if (operation === "htmlClientSdk.internal.init") {
                this.postMessage("htmlClientSdk.internal.init$response", {
                    isModal: this.$scope.isModal,
                    cachedApiData: {
                        app: {
                            apiEndpoints: {
                                uiApiEndpoint: {
                                    origin: window.location.origin,
                                    pathname: "/api/ui",
                                    queryParams: [],
                                    fullUrl: window.location.origin + "/api/ui"
                                }
                            },
                            navigationData: this.htmlClientSdk.app.getNavigationData(),
                            clientInfo: this.htmlClientSdk.app.getClientInfo(),
                            contextObjects: this.htmlClientSdk.app.getContextObjects(),
                            clientLocale: this.htmlClientSdk.app.getClientLocale(),
                            theme: this.htmlClientSdk.app.getTheme()
                        },
                        modal: {
                            customData: this.htmlClientSdk.modal.getCustomData()
                        }
                    }
                });
                this.htmlClientSdk.event.onThemeChanged(this.onThemeChanged.bind(this));
            }
            if (operation === "htmlClientSdk.internal.extendUserSession") {
                this.extendUserSession();
            }
            if (operation === "htmlClientSdk.internal.redispatchIframeMouseEvent") {
                if (!payload || !payload.mouseEventProperties) {
                    return;
                }
                this.redispatchIframeMouseEvent(payload.mouseEventProperties);
            }
            if (operation === "htmlClientSdk.internal.trackTelemetryEvent$MouseEvent") {
                if (!payload ||
                    !payload.eventType ||
                    !payload.targetNodesDataChain ||
                    !payload.targetNodesDataChain.length) {
                    return;
                }
                var eventType = payload.eventType;
                var currentNodeWrapper = void 0;
                var parentNodeWrapper = new platform.TelemetryDomNodeWrapper(this.pluginIFrame, this.telemetryHelperService);
                for (var i = payload.targetNodesDataChain.length - 1; i >= 0; i--) {
                    var currentNodeData = payload.targetNodesDataChain[i];
                    currentNodeWrapper = {
                        id: currentNodeData.id,
                        classList: currentNodeData.classList,
                        index: currentNodeData.index,
                        nodeType: currentNodeData.nodeType,
                        nodeName: currentNodeData.nodeName,
                        textContents: currentNodeData.textContents,
                        isEmbeddedNodeWrapper: true,
                        parentNodeWrapper: parentNodeWrapper
                    };
                    parentNodeWrapper = currentNodeWrapper;
                }
                this.telemetryService.trackMouseEvent(eventType, currentNodeWrapper);
            }
            /*
             * APP
             */
            if (operation === "htmlClientSdk.app.navigateTo") {
                if (!payload || !payload.navigationOptions) {
                    return;
                }
                this.htmlClientSdk.app.navigateTo(payload.navigationOptions);
            }
            if (operation === "htmlClientSdk.app.getSessionInfo") {
                if (!payload || !payload.requestId) {
                    return;
                }
                var sessionInfoUrl = "/ui/plugins/" +
                    this.$scope.remotePluginExtensionContext.fullyQualifiedPluginInstanceId +
                    "/session";
                this.$http.get(sessionInfoUrl).then(function (httpResponse) {
                    _this.postMessage("htmlClientSdk.app.getSessionInfo$response", {
                        requestId: payload.requestId,
                        sessionInfo: httpResponse.data
                    });
                });
            }
            /*
             * MODAL
             */
            if (operation === "htmlClientSdk.modal.open") {
                if (!payload || !payload.modalId || !payload.modalConfig) {
                    return;
                }
                var modalId_1 = payload.modalId;
                var modalConfig = payload.modalConfig;
                if (modalConfig.onClosed === true) {
                    modalConfig.onClosed = function (result) {
                        _this.postMessage("htmlClientSdk.modal.open$onClosed()", {
                            modalId: modalId_1,
                            modalResult: result
                        });
                    };
                }
                else {
                    modalConfig.onClosed = undefined;
                }
                this.htmlClientSdk.modal.open(modalConfig);
            }
            if (operation === "htmlClientSdk.modal.close") {
                var closeResult = null;
                if (payload) {
                    closeResult = payload.closeResult;
                }
                this.htmlClientSdk.modal.close(closeResult);
            }
            if (operation === "htmlClientSdk.modal.setOptions") {
                if (!payload || !payload.newModalConfig) {
                    return;
                }
                this.htmlClientSdk.modal
                    .setOptions(payload.newModalConfig);
            }
            /*
             * EVENT
             */
            if (operation === "htmlClientSdk.event.onGlobalRefresh") {
                this.htmlClientSdk.event.onGlobalRefresh(function () {
                    _this.postMessage("htmlClientSdk.event.onGlobalRefresh$callback()");
                });
            }
        };
        H5RemoteSdkAdapter.prototype.postMessage = function (operation, payload) {
            if (!this.pluginIFrame.contentWindow) {
                this.$log.warn(("Can't post message with operation id '" + operation + "'") +
                    (" to remote plugin extension '" + this.$scope.viewId + "'") +
                    " because iframe.contentWindow is null!");
                return;
            }
            this.pluginIFrame.contentWindow.postMessage({
                operation: operation,
                payload: payload
            }, "*");
        };
        H5RemoteSdkAdapter.prototype.onThemeChanged = function (theme) {
            this.postMessage("htmlClientSdk.internal.onThemeChanged$event", { theme: theme });
        };
        return H5RemoteSdkAdapter;
    }());
    platform.H5RemoteSdkAdapter = H5RemoteSdkAdapter;
    angular
        .module("com.vmware.platform.ui")
        .service("h5RemoteSdkAdapterService", H5RemoteSdkAdapterService);
})(platform || (platform = {}));



/* Copyright (c) 2018 VMware, Inc. All rights reserved. */
var platform;
(function (platform) {
    /**
     * This service class is used to initialize the SDK action invokers registered with the
     * actionsService.
     */
    var H5SdkActionService = (function () {
        function H5SdkActionService($http, h5SdkModalService) {
            this.$http = $http;
            this.h5SdkModalService = h5SdkModalService;
        }
        H5SdkActionService.prototype.bindActionHandlers = function () {
            h5.actions["com.vmware.vsphere.client.HtmlPluginModalAction"] = this.handleHtmlPluginModalAction.bind(this);
            h5.actions["com.vmware.vsphere.client.HtmlPluginHeadlessAction"] = this.handleHtmlPluginHeadlessAction.bind(this);
            h5.actions["com.vmware.vsphere.client.pluginActions"] = this.handlePluginActions.bind(this);
        };
        H5SdkActionService.prototype.handleHtmlPluginModalAction = function (actionEval, availableTargets) {
            if (actionEval.additionalData) {
                var contextObjects = _.map(availableTargets, function (targetId) {
                    return {
                        id: targetId
                    };
                });
                var modalOptions = {
                    url: actionEval.additionalData.actionUrl,
                    title: actionEval.additionalData.dialogTitle,
                    closable: (actionEval.additionalData.closable !== "false"),
                    contextObjects: contextObjects
                };
                if (actionEval.additionalData.dialogSize) {
                    var sizeArray = actionEval.additionalData.dialogSize.split(",");
                    var size = {
                        width: parseInt(sizeArray[0], 10),
                        height: parseInt(sizeArray[1], 10)
                    };
                    modalOptions.size = size;
                }
                this.h5SdkModalService.openModal(modalOptions, actionEval.remotePluginExtensionContext);
            }
        };
        ;
        H5SdkActionService.prototype.handleHtmlPluginHeadlessAction = function (actionEval, availableTargets) {
            if (actionEval.additionalData) {
                var params = { targetIds: availableTargets.toString() };
                this.$http.post(actionEval.additionalData.actionUrl, null, { params: params });
            }
        };
        ;
        H5SdkActionService.prototype.handlePluginActions = function (actionEval, availableTargets) {
            var modalSizeRegExp = /^(\d+),(\d+)$/i;
            if (actionEval.pluginData) {
                if (actionEval.pluginData.headless === "true") {
                    var params = { targetIds: availableTargets.toString() };
                    this.$http.post(actionEval.pluginData.url, null, { params: params });
                }
                else {
                    var contextObjects = _.map(availableTargets, function (targetId) {
                        return {
                            id: targetId
                        };
                    });
                    var closable = null;
                    if (typeof actionEval.pluginData.closable === "string") {
                        try {
                            closable = JSON.parse(actionEval.pluginData.closable);
                        }
                        catch (e) {
                        }
                    }
                    if (typeof closable !== "boolean") {
                        closable = null;
                    }
                    var modalOptions = {
                        url: actionEval.pluginData.url,
                        title: actionEval.pluginData.title,
                        closable: closable,
                        contextObjects: contextObjects
                    };
                    if (typeof (actionEval.pluginData.size) === "string" &&
                        modalSizeRegExp.test(actionEval.pluginData.size)) {
                        var modalSizeGroups = actionEval.pluginData.size.match(modalSizeRegExp);
                        var pixelWidth = parseInt(modalSizeGroups[1], 10);
                        var pixelHeight = parseInt(modalSizeGroups[2], 10);
                        if (0 < pixelWidth && 0 < pixelHeight) {
                            modalOptions.size = {
                                width: pixelWidth,
                                height: pixelHeight
                            };
                        }
                    }
                    this.h5SdkModalService.openModal(modalOptions, actionEval.remotePluginExtensionContext);
                }
            }
        };
        ;
        H5SdkActionService.$inject = [
            "$http",
            "h5SdkModalService"];
        return H5SdkActionService;
    }());
    platform.H5SdkActionService = H5SdkActionService;
    angular
        .module("com.vmware.platform.ui")
        .service("h5SdkActionService", H5SdkActionService);
})(platform || (platform = {}));



/* Copyright (c) 2017-2018 VMware, Inc. All rights reserved. */
var platform;
(function (platform) {
    /**
     * The class initializes the html client SDK.
     */
    var H5SdkInitializer = (function () {
        function H5SdkInitializer($scope, h5SdkApplicationService, h5SdkModalService, h5SdkEventService) {
            this.eventApiInitializer = h5SdkEventService.createH5SdkEventApi($scope);
            var locale = $scope.viewUrlParams.locale.replace("_", "-");
            this.sdk = {
                app: h5SdkApplicationService.createH5SdkApplicationApi($scope, locale),
                modal: h5SdkModalService.createH5SdkModalApi($scope),
                event: this.eventApiInitializer.api,
            };
        }
        H5SdkInitializer.prototype.onIframeUnload = function () {
            this.eventApiInitializer.onIframeUnload();
        };
        H5SdkInitializer.prototype.destroy = function () {
            this.eventApiInitializer.destroy();
        };
        return H5SdkInitializer;
    }());
    platform.H5SdkInitializer = H5SdkInitializer;
    /**
     * This service class is used to create objects of type H5SdkApi.
     * The service also takes care of the needed dependencies.
     */
    var H5SdkApiService = (function () {
        function H5SdkApiService(h5SdkApplicationService, h5SdkModalService, h5SdkEventService) {
            this.h5SdkApplicationService = h5SdkApplicationService;
            this.h5SdkModalService = h5SdkModalService;
            this.h5SdkEventService = h5SdkEventService;
        }
        H5SdkApiService.prototype.getH5SdkApi = function (scope) {
            return new H5SdkInitializer(scope, this.h5SdkApplicationService, this.h5SdkModalService, this.h5SdkEventService);
        };
        H5SdkApiService.$inject = [
            "h5SdkApplicationService",
            "h5SdkModalService",
            "h5SdkEventService"];
        return H5SdkApiService;
    }());
    platform.H5SdkApiService = H5SdkApiService;
    angular
        .module("com.vmware.platform.ui")
        .service("h5SdkApiService", H5SdkApiService);
})(platform || (platform = {}));



/* Copyright (c) 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * This service class is used to create objects of type H5SdkApplicationApi.
     * The service also takes care of the needed dependencies.
     */
    var H5SdkApplicationService = (function () {
        function H5SdkApplicationService(navigation, i18nService, pluginUrlService, iframeNavigationDataCache, vxZoneService, h5SdkThemeService, $q, $http) {
            this.navigation = navigation;
            this.i18nService = i18nService;
            this.pluginUrlService = pluginUrlService;
            this.iframeNavigationDataCache = iframeNavigationDataCache;
            this.vxZoneService = vxZoneService;
            this.h5SdkThemeService = h5SdkThemeService;
            this.$q = $q;
            this.$http = $http;
        }
        H5SdkApplicationService.prototype.createH5SdkApplicationApi = function (pluginIframeScope, locale) {
            return new H5SdkApplicationApi(pluginIframeScope, this, this.i18nService, this.pluginUrlService, this.iframeNavigationDataCache, this.h5SdkThemeService, locale);
        };
        H5SdkApplicationService.prototype.navigateTo = function (options, remotePluginExtensionContext) {
            var _this = this;
            if (options.targetViewId && remotePluginExtensionContext) {
                options.targetViewId =
                    remotePluginExtensionContext.pluginNavigableExtensionIdsPrefix +
                        options.targetViewId;
            }
            if (options.customData && options.targetViewId &&
                // exclude the summary (portlets) view
                options.targetViewId.search("^vsphere\.core\..*\.summary$") === -1) {
                this.iframeNavigationDataCache.setNavigationData({
                    viewId: options.targetViewId,
                    customData: options.customData
                });
            }
            if (typeof options.objectId === "string" && options.objectId.trim().length === 0) {
                throw new Error("Navigation failed: objectId cannot be an empty string");
            }
            this.vxZoneService.runInsideAngular(function () {
                var navigationContext = {
                    /*
                     * If we are executing navigation to an already visible
                     * plugin view we need to reload it to ensure that if the
                     * navigation data has changed the view will re-read it.
                     * To do this we put the "sdkReloadPluginExtensions" parameter to
                     * cause the route to change which will trigger the
                     * "viewDidUpdate" for  the active pluginIframe view if any.
                     * We are using this long descriptive parameter name to avoid
                     * collisions with other parameters that are used for refreshing
                     * as this might have undesirable side effects. An example of
                     * such parameter is "sdkUpdateRpxcSelector", part of
                     * RemotePluginExtensionContextSelectorController.
                     *
                     * Bug:
                     * See https://jira.eng.vmware.com/browse/VUSP-2156 or
                     * https://bugzilla.eng.vmware.com/show_bug.cgi?id=2273357
                     */
                    sdkReloadPluginExtensions: Math.random()
                };
                if (remotePluginExtensionContext && !options.objectId) {
                    navigationContext.rpxcId =
                        remotePluginExtensionContext.contextId;
                }
                _this.getActualTargetViewId(options.targetViewId, remotePluginExtensionContext)
                    .then(function (actualTargetViewId) {
                    if (actualTargetViewId && options.objectId) {
                        _this.navigation.navigateToViewAndObject(actualTargetViewId, options.objectId, navigationContext);
                    }
                    else if (actualTargetViewId && !options.objectId) {
                        _this.navigation.navigateToView(actualTargetViewId, navigationContext);
                    }
                    else if (!actualTargetViewId && options.objectId) {
                        _this.navigation.navigateToObject(options.objectId, navigationContext);
                    }
                    else {
                        throw new Error("Navigation failed: At least one of" +
                            " targetViewId and objectId parameters must be specified");
                    }
                });
            });
        };
        H5SdkApplicationService.prototype.getActualTargetViewId = function (targetViewId, remotePluginExtensionContext) {
            if (!targetViewId || !remotePluginExtensionContext) {
                return this.$q.when(targetViewId);
            }
            return this.getStandardExtensionIdToSharedExtensionIdMap()
                .then(function (map) {
                if (map[targetViewId]) {
                    return map[targetViewId];
                }
                return targetViewId;
            });
        };
        H5SdkApplicationService.prototype.getStandardExtensionIdToSharedExtensionIdMap = function () {
            var _this = this;
            if (!this._standardExtensionIdToSharedExtensionIdMapPromise) {
                this._standardExtensionIdToSharedExtensionIdMapPromise = this.$http
                    .get("/ui/plugins/standardExtensionIdToSharedExtensionIdMap")
                    .then(function (response) {
                    return response.data;
                }, function (error) {
                    _this._standardExtensionIdToSharedExtensionIdMapPromise = null;
                    return {};
                });
            }
            return this._standardExtensionIdToSharedExtensionIdMapPromise;
        };
        H5SdkApplicationService.$inject = [
            "navigation",
            "i18nService",
            "pluginUrlService",
            "iframeNavigationDataCache",
            "vxZoneService",
            "h5SdkThemeService",
            "$q",
            "$http"
        ];
        return H5SdkApplicationService;
    }());
    platform.H5SdkApplicationService = H5SdkApplicationService;
    /**
     * The class defines APIs related to the H5C application.
     */
    var H5SdkApplicationApi = (function () {
        function H5SdkApplicationApi(pluginIframeScope, h5SdkApplicationService, i18nService, pluginUrlService, iframeNavigationDataCache, h5SdkThemeService, locale) {
            this.navigateTo = function (options) {
                h5SdkApplicationService.navigateTo(options, pluginIframeScope.remotePluginExtensionContext);
            };
            this.getClientInfo = function () {
                var version = i18nService.getString("CommonUi", "client.version");
                version = version.split('-')[0];
                var clientInfo = {
                    type: "html",
                    version: version
                };
                return clientInfo;
            };
            this.getContextObjects = function () {
                if (pluginIframeScope.isModal) {
                    if (!pluginIframeScope.context) {
                        return [];
                    }
                    return pluginIframeScope.context.contextObjects ?
                        pluginIframeScope.context.contextObjects : [];
                }
                var contextObjectId = pluginUrlService
                    .getUrlParameterValue(window.location.href, "objectId");
                if (contextObjectId) {
                    return [{
                            id: contextObjectId
                        }];
                }
                return [];
            };
            this.getClientLocale = function () {
                return locale;
            };
            this.getNavigationData = function () {
                return iframeNavigationDataCache.getReturnedNavigationData();
            };
            this.getTheme = function () {
                return h5SdkThemeService.getPluginTheme();
            };
        }
        return H5SdkApplicationApi;
    }());
    platform.H5SdkApplicationApi = H5SdkApplicationApi;
    angular
        .module("com.vmware.platform.ui")
        .service("h5SdkApplicationService", H5SdkApplicationService);
})(platform || (platform = {}));



/* Copyright (c) 2018 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * This service class provides common APIs used by the other SDK services,
     * components and other parties.
     */
    var H5SdkCommonService = (function () {
        function H5SdkCommonService() {
        }
        /**
         * Determines whether an IFrame element content is cross-domain.
         * The cross-domain state should be checked after each "load" event of
         * the IFrame element.
         */
        H5SdkCommonService.prototype.isCrossDomainIFrame = function (iframe) {
            try {
                /*
                Safari does not have addEventListener function,
                all other browsers throw an exception when addEventListener
                method is accessed. So we just need to check whether
                addEventListener is present.
                */
                return !iframe.contentWindow.addEventListener;
            }
            catch (error) {
                return true;
            }
        };
        return H5SdkCommonService;
    }());
    platform.H5SdkCommonService = H5SdkCommonService;
    angular
        .module("com.vmware.platform.ui")
        .service("h5SdkCommonService", H5SdkCommonService);
})(platform || (platform = {}));



/* Copyright (c) 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * This service class is used to create objects of type H5SdkEventApi.
     */
    var H5SdkEventService = (function () {
        H5SdkEventService.$inject = ['vcH5ConstantsService', 'h5SdkThemeService'];
        function H5SdkEventService(vcH5ConstantsService, h5SdkThemeService) {
            this.vcH5ConstantsService = vcH5ConstantsService;
            this.h5SdkThemeService = h5SdkThemeService;
            this.$inject = [
                "vcH5ConstantsService",
                "h5SdkThemeService"
            ];
        }
        H5SdkEventService.prototype.createH5SdkEventApi = function (scope) {
            return new H5SdkEventApiInitializer(scope, this.vcH5ConstantsService, this.h5SdkThemeService);
        };
        return H5SdkEventService;
    }());
    platform.H5SdkEventService = H5SdkEventService;
    /**
     * Initializes the H5 SDK Event APIs.
     */
    var H5SdkEventApiInitializer = (function () {
        function H5SdkEventApiInitializer(scope, vcH5ConstantsService, h5SdkThemeService) {
            var _this = this;
            this.scope = scope;
            this.vcH5ConstantsService = vcH5ConstantsService;
            this.h5SdkThemeService = h5SdkThemeService;
            this.globalRefreshEvent = null;
            this.onThemeChangedCallback = null;
            this.api = {
                onGlobalRefresh: function (onGlobalRefreshHandler) {
                    _this.destroyGlobalRefreshEvent();
                    _this.globalRefreshEvent = scope.$on(vcH5ConstantsService.DATA_REFRESH_INVOCATION_EVENT, onGlobalRefreshHandler);
                },
                onThemeChanged: function (onThemeChangedCallback) {
                    if (typeof onThemeChangedCallback !== 'function') {
                        throw new Error('\'callback\' must be a function!');
                    }
                    _this.destroyThemeChangedCallback();
                    _this.h5SdkThemeService.subscribeToThemeChanged(onThemeChangedCallback);
                    _this.onThemeChangedCallback = onThemeChangedCallback;
                }
            };
        }
        /**
         * Destroys event listeners.
         */
        H5SdkEventApiInitializer.prototype.onIframeUnload = function () {
            this.destroyGlobalRefreshEvent();
            this.destroyThemeChangedCallback();
        };
        /**
         * Destroys event listeners and performs clean-up.
         */
        H5SdkEventApiInitializer.prototype.destroy = function () {
            this.destroyGlobalRefreshEvent();
            this.destroyThemeChangedCallback();
        };
        /**
         * Unregister the global refresh event handler the plugin iframe has subscribed to.
         */
        H5SdkEventApiInitializer.prototype.destroyGlobalRefreshEvent = function () {
            if (this.globalRefreshEvent) {
                this.globalRefreshEvent();
                this.globalRefreshEvent = null;
            }
        };
        /**
         * Unregister the plugin theme changed event handler the plugin iframe
         * has subscribed to.
         */
        H5SdkEventApiInitializer.prototype.destroyThemeChangedCallback = function () {
            if (this.onThemeChangedCallback) {
                this.h5SdkThemeService.unsubscribeFromThemeChanged(this.onThemeChangedCallback);
                this.onThemeChangedCallback = null;
            }
        };
        return H5SdkEventApiInitializer;
    }());
    platform.H5SdkEventApiInitializer = H5SdkEventApiInitializer;
    angular
        .module("com.vmware.platform.ui")
        .service("h5SdkEventService", H5SdkEventService);
})(platform || (platform = {}));



/* Copyright (c) 2017 VMware, Inc. All rights reserved. */
var platform;
(function (platform) {
    /**
     * The class defines APIs related to the modal dialogs.
     */
    var H5SdkModalApi = (function () {
        function H5SdkModalApi(pluginIframeScope, $rootScope, h5SdkModalService) {
            this.open = function (config) {
                h5SdkModalService.openModal(config, pluginIframeScope.remotePluginExtensionContext);
            };
            this.close = function (result) {
                if (pluginIframeScope.context && pluginIframeScope.context.closeModal) {
                    pluginIframeScope.context.closeModal(result);
                }
            };
            this.setOptions = function (newModalConfig) {
                if (!newModalConfig) {
                    return;
                }
                if (pluginIframeScope.context && pluginIframeScope.context.setOptions) {
                    pluginIframeScope.context.setOptions(newModalConfig);
                }
                $rootScope.$apply();
            };
            this.getCustomData = function () {
                return (pluginIframeScope.context && pluginIframeScope.context.customData) ?
                    pluginIframeScope.context.customData : null;
            };
        }
        return H5SdkModalApi;
    }());
    platform.H5SdkModalApi = H5SdkModalApi;
    var H5SdkModalService = (function () {
        H5SdkModalService.$inject = ['clarityModalService', 'logService', '$rootScope'];
        function H5SdkModalService(clarityModalService, logService, $rootScope) {
            this.clarityModalService = clarityModalService;
            this.$rootScope = $rootScope;
            this.$inject = ["clarityModalService", "logService", "$rootScope"];
            this.logger = logService('h5SdkModalService');
        }
        H5SdkModalService.prototype.openModal = function (config, remotePluginExtensionContext) {
            var _this = this;
            var width = H5SdkModalService.DEFAULT_WIDTH;
            if (config.size && config.size.width) {
                if (config.size.width < H5SdkModalService.MIN_WIDTH) {
                    width = H5SdkModalService.MIN_WIDTH;
                    this.logger.info("Setting modal's width to " + H5SdkModalService.MIN_WIDTH +
                        ", because it cannot be smaller than " + H5SdkModalService.MIN_WIDTH);
                }
                else if (config.size.width > H5SdkModalService.MAX_WIDTH) {
                    width = H5SdkModalService.MAX_WIDTH;
                    this.logger.info("Setting modal's width to " + H5SdkModalService.MAX_WIDTH +
                        ", because it cannot be greater than " + H5SdkModalService.MAX_WIDTH);
                }
                else {
                    width = config.size.width;
                }
            }
            var height = H5SdkModalService.DEFAULT_HEIGHT;
            if (config.size && config.size.height) {
                height = config.size.height;
            }
            var title = config.title ? config.title.trim() : '';
            var closable = (config.closable !== null && config.closable !== undefined) ?
                !!config.closable : true;
            var htmlModalOptions = {
                title: title,
                pluginSize: { width: width, height: height },
                closable: closable,
                url: config.url,
                iframeContext: {
                    closeModal: closeModal,
                    contextObjects: config.contextObjects,
                    setOptions: setOptions,
                    customData: config.customData
                },
                remotePluginExtensionContext: remotePluginExtensionContext
            };
            var actionEval = {
                action: {}
            };
            var modalTemplateUrl = 'resources/ui/views/plugins/pluginModalTemplate.html';
            var modalScope = this.clarityModalService.openModal(actionEval, null, htmlModalOptions, modalTemplateUrl);
            // Callback that is invoked when the user dismisses the modal by clicking the X
            // or the ESC button.
            modalScope.onCancelModal = function (result) {
                if (config.onClosed) {
                    try {
                        config.onClosed(result);
                    }
                    catch (e) {
                        _this.logger.error("Error occurred while invoking the onClosed callback: ", e);
                    }
                }
            };
            function closeModal(result) {
                modalScope.closeModal(result);
            }
            function setOptions(options) {
                if (options.title) {
                    modalScope.modalOptions.dialogData.title = options.title;
                }
                if (options.height) {
                    modalScope.modalOptions.dialogData.pluginSize.height = options.height;
                }
            }
        };
        H5SdkModalService.prototype.createH5SdkModalApi = function (pluginIframeScope) {
            return new H5SdkModalApi(pluginIframeScope, this.$rootScope, this);
        };
        // The default width of the modal is 24rem (576px) which is Clarity recommended width
        // Width sizes according to Clarity
        H5SdkModalService.ONE_REM = 24;
        H5SdkModalService.DEFAULT_WIDTH = H5SdkModalService.ONE_REM * 24; // medium Clarity width
        H5SdkModalService.MIN_WIDTH = H5SdkModalService.ONE_REM * 12; // small Clarity width
        H5SdkModalService.MAX_WIDTH = H5SdkModalService.ONE_REM * 48; // xl Clarity width
        H5SdkModalService.DEFAULT_HEIGHT = H5SdkModalService.ONE_REM * 13.5;
        return H5SdkModalService;
    }());
    platform.H5SdkModalService = H5SdkModalService;
    angular
        .module("com.vmware.platform.ui")
        .service('h5SdkModalService', H5SdkModalService);
})(platform || (platform = {}));



/* Copyright (c) 2018 VMware, Inc. All rights reserved. */
var platform;
(function (platform) {
    /**
     * This service provides APIs for plugin themes.
     */
    var H5SdkThemeService = (function () {
        H5SdkThemeService.$inject = ['themeService', '$log'];
        function H5SdkThemeService(themeService, $log) {
            var _this = this;
            this.themeService = themeService;
            this.$log = $log;
            this.$inject = [
                "themeService",
                "$log"
            ];
            this.themeChangedCallbacks = [];
            this.DEFAULT_CLIENT_THEME_NAME = themeService.getKeys().light;
            this.CLIENT_THEME_NAME_TO_PLUGIN_THEME_NAME = {};
            this.CLIENT_THEME_NAME_TO_PLUGIN_THEME_NAME[themeService.getKeys().light] = PluginThemeName.LIGHT;
            this.CLIENT_THEME_NAME_TO_PLUGIN_THEME_NAME[themeService.getKeys().dark] = PluginThemeName.DARK;
            themeService.subscribeToThemeChanged(function () {
                var pluginTheme = _this.getPluginTheme();
                for (var i = 0; i < _this.themeChangedCallbacks.length; i++) {
                    try {
                        _this.themeChangedCallbacks[i](pluginTheme);
                    }
                    catch (e) {
                        $log.error("Error while invoking themeChangedCallback with index " + i + "!", e);
                    }
                }
            });
        }
        /**
         * Returns information about the theme plugins should use.
         * @returns a PluginTheme object.
         */
        H5SdkThemeService.prototype.getPluginTheme = function () {
            var currentClientThemeName = this.themeService.getCurrentTheme();
            if (!this.CLIENT_THEME_NAME_TO_PLUGIN_THEME_NAME[currentClientThemeName]) {
                currentClientThemeName = this.DEFAULT_CLIENT_THEME_NAME;
            }
            var pluginThemeName = this.CLIENT_THEME_NAME_TO_PLUGIN_THEME_NAME[currentClientThemeName];
            return {
                name: pluginThemeName
            };
        };
        /**
         * Subscribe for notifications when the theme plugins should use changes.
         *
         * @param callback to invoke when the theme changes.
         * The callback has the following signature:
         * <code>function(theme: PluginTheme): void</code>
         */
        H5SdkThemeService.prototype.subscribeToThemeChanged = function (callback) {
            if (this.themeChangedCallbacks.indexOf(callback) !== -1) {
                return;
            }
            this.themeChangedCallbacks.push(callback);
        };
        /**
         * Unsubscribe for notifications when the theme plugins should use changes.
         *
         * @param callback that was used when subscribing (through the
         * <code>subscribeToThemeChanged</code> method) for theme changes.
         */
        H5SdkThemeService.prototype.unsubscribeFromThemeChanged = function (callback) {
            var callbackIndex = this.themeChangedCallbacks.indexOf(callback);
            if (callbackIndex === -1) {
                return;
            }
            this.themeChangedCallbacks.splice(callbackIndex, 1);
        };
        return H5SdkThemeService;
    }());
    platform.H5SdkThemeService = H5SdkThemeService;
    /**
     * Enumerates all possible plugin theme names.
     * Current values are "light" and "dark".
     */
    //amarinov: https://stackoverflow.com/questions/15490560/create-an-enum-with-string-values-in-typescript
    (function (PluginThemeName) {
        PluginThemeName[PluginThemeName["LIGHT"] = 'light'] = "LIGHT";
        PluginThemeName[PluginThemeName["DARK"] = 'dark'] = "DARK";
    })(platform.PluginThemeName || (platform.PluginThemeName = {}));
    var PluginThemeName = platform.PluginThemeName;
    angular
        .module("com.vmware.platform.ui")
        .service("h5SdkThemeService", H5SdkThemeService);
})(platform || (platform = {}));



/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     This cache is used to store and retrieve custom data that is passed to
     navigateTo() API.
     */
    var IframeNavigationDataCache = (function () {
        function IframeNavigationDataCache() {
        }
        IframeNavigationDataCache.prototype.setNavigationData = function (newNavigationData) {
            this.navigationData = newNavigationData;
        };
        IframeNavigationDataCache.prototype.getReturnedNavigationData = function () {
            return this.returnedNavigationData;
        };
        IframeNavigationDataCache.prototype.updateNavigationData = function (extensionId) {
            var currentNavData = this.navigationData;
            this.navigationData = undefined;
            if (currentNavData && currentNavData.viewId !== extensionId) {
                currentNavData = undefined;
            }
            this.returnedNavigationData = currentNavData ? currentNavData.customData : undefined;
        };
        return IframeNavigationDataCache;
    }());
    platform.IframeNavigationDataCache = IframeNavigationDataCache;
    angular.module("com.vmware.platform.ui")
        .service("iframeNavigationDataCache", IframeNavigationDataCache);
})(platform || (platform = {}));



var platform;
(function (platform) {
    /**
     * Help service used for manipulating the plugin url.
     */
    var PluginUrlService = (function () {
        function PluginUrlService(defaultUriSchemeUtil, $sce, $http, $q) {
            this.defaultUriSchemeUtil = defaultUriSchemeUtil;
            this.$sce = $sce;
            this.$http = $http;
            this.$q = $q;
        }
        /**
         * Associates the plugin session with the client session by means of requestInterceptor
         * that adds the 'webClientSessionId' header and the SessionManagementFilter
         * that does the association itself.
         * @param url - plugin url used for associating the plugin with the client session.
         */
        PluginUrlService.prototype.associatePluginSessionWithClientId = function (url) {
            // Don't send such a request, since no session association is needed for full https URLs
            // which are either local plugins going straight to their back-end, or remote plugins
            var isHttpsRegex = /^https?:\/\//i;
            if (!isHttpsRegex.test(url)) {
                return this.$http.get(url).then(function () { return true; }, function () { return true; });
            }
            else {
                return this.$q.when(true);
            }
        };
        /**
         * Builds a plugin url which means to associate the plugin session with the client session,
         * append any additional params to the plugin url and trust the plugin url.
         * @param url - plugin url.
         * @param urlParams - additional params to be appended to the plugin url.
         * @returns {any} - return a trusted plugin url.
         */
        PluginUrlService.prototype.buildUrl = function (url, urlParams) {
            var params = this.buildAndValidateParams(urlParams);
            url = this.appendParams(url, params);
            return this.trustPluginUrl(url);
        };
        /**
         * Appends params to the given url.
         * @param url - the url which will be extended with additional params.
         * @param params - url params to be added to the specified url.
         * @returns {string} - returns the URL as a string.
         */
        PluginUrlService.prototype.appendParams = function (url, params) {
            // quick last-minute dirty fix
            // url may be an $sce-returned object coming from
            // buildUrl() so convert it to normal string
            //TODO fix it with Pivotal Story #142274059
            url = url.toString();
            url += (url.indexOf("?") > 0) ? "&" : "?";
            url += PluginUrlService.convertParamsToString(params);
            return url;
        };
        /**
         * Converts the object which holds the url params to a string.
         */
        PluginUrlService.convertParamsToString = function (params) {
            return _.map(params, function (value, key) {
                return key + "=" + value;
            }).join("&");
        };
        /**
         * Creates an object which holds the url params.
         * It does validation on the given params and adds additional params
         * like objectType and vc selector related data.
         * @param urlParams - an object which represents the url params.
         * @returns {PluginUrlParams}
         */
        PluginUrlService.prototype.buildAndValidateParams = function (urlParams) {
            var params = {
                locale: urlParams.locale
            };
            var objectId = urlParams.objectId;
            var isValidManagedObjectId = objectId &&
                this.defaultUriSchemeUtil.isValidManagedObjectId(objectId);
            if (objectId) {
                params.objectId = objectId.replace("/", PluginUrlService.FORWARD_SLASH_ENCODED2);
            }
            // Add objectType for vSphere ManagedObjects only because we can't get extract the type of other objects
            // out of their objectId without making a server call and that would be overkill.
            var objectType;
            if (isValidManagedObjectId) {
                var parts = this.defaultUriSchemeUtil.getPartsFromVsphereObjectId(objectId);
                objectType = parts.type;
                params.objectType = objectType;
            }
            // VC Selector related url params.
            var vcSelectorSelection = urlParams.vcSelectorSelection;
            if (vcSelectorSelection) {
                params.serviceGuid = vcSelectorSelection.serviceGuid;
                params.sessionId = vcSelectorSelection.sessionKey;
                params.serviceUrl = vcSelectorSelection.serviceUrl;
            }
            return params;
        };
        /**
         * Marks plugin url as trusted before binding the plugin url
         * to ng-src in the iframe tag. That will skip the automatic
         * security checks that Angular runs.
         */
        PluginUrlService.prototype.trustPluginUrl = function (url) {
            return this.$sce.trustAsResourceUrl(url);
        };
        /**
         * Returns the parameter value or
         * null if the parameter is missing in the url.
         * @param url
         * @param name - parameter name to be searched for in the specified url.
         * @returns {string|null}
         */
        PluginUrlService.prototype.getUrlParameterValue = function (url, name) {
            var paramValue = null;
            var resultArray = (new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)')).exec(url);
            if (resultArray && resultArray.length > 1) {
                paramValue = resultArray[1].replace(/\+/g, '%20');
            }
            return paramValue;
        };
        PluginUrlService.FORWARD_SLASH_ENCODED2 = "%252F";
        PluginUrlService.$inject = ["defaultUriSchemeUtil", "$sce", "$http", "$q"];
        return PluginUrlService;
    }());
    platform.PluginUrlService = PluginUrlService;
    angular.module("com.vmware.platform.ui").service("pluginUrlService", PluginUrlService);
})(platform || (platform = {}));



/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Http interceptor to intercept http response errors.
 */
angular.module('com.vmware.platform.ui').factory('errorResponseInterceptor',
   ['$q', '$rootScope', 'vuiConstants', '$log',
function($q, $rootScope, vuiConstants, $log){
   'use strict';
   /**
    * Default notification options
    * @type {{type: string, title: string, content: string}}
    */
   var notificationOptions = {
      'type': 'error',
      'title': '',
      'content': '',
      'unhandledError': true
   };
   return {
      'responseError': function(rejection) {
         if (rejection.config && rejection.config.skipErrorInterceptor) {
            return $q.reject(rejection);
         }
          // Internal server error likely come from the controllers or the controller exception handler.
          if (rejection.status === 500) {
             notificationOptions.title = rejection.statusText;
             notificationOptions.content = rejection.data;
             $rootScope.$broadcast('notificationEvent', notificationOptions);
          } else if (rejection.status === 400 || rejection.status === 404) {
             // 400 = bad request, 404 = not found
             notificationOptions.title = rejection.statusText;
             var url = rejection.config.url;
             if (url && url.length > 1000) {
                url = url.substring(0, 100) + '... (' + (url.length - 100) + ' more chars)';
             }
             notificationOptions.content = url;
             $rootScope.$broadcast('notificationEvent', notificationOptions);
          } else {
             // Don't show other errors in the UI except for local dev and acceptance
             var errMsg = 'ResponseError ' + rejection.statusText +
                ', status: ' + rejection.status +
                ', data: ' + (rejection.data ? rejection.data.toString() : '') +
                ', url: ' + (rejection.config ? rejection.config.url : '');
             var location = window.location.toString();
             if (location.indexOf('localhost:9443') === -1 &&
                 location.indexOf('h5-acceptance-ui.eng.vmware.com') === -1) {
                $log.error(errMsg);
             } else {
                notificationOptions.title = rejection.statusText;
                notificationOptions.content = errMsg;
                $rootScope.$broadcast('notificationEvent', notificationOptions);
             }
          }

          return $q.reject(rejection);
      }
   };
}]);

angular.module('com.vmware.platform.ui').config(['$httpProvider',function($httpProvider) {
   'use strict';
   $httpProvider.interceptors.push('errorResponseInterceptor');
}]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Adds the cancelOnDestroy: $scope, option to $http() requests. When specified, the http
 * request will be automatically aborted if the scope $destroy event fires.
 */
angular.module('com.vmware.platform.ui').config(["$httpProvider", function($httpProvider) {

   $httpProvider.interceptors.push(["$q", function($q) {
      return {
         'request' : function(config) {
            if (config.cancelOnDestroy) {
               var deferred = $q.defer();

               config.timeout = deferred.promise;
               config.cancelOnDestroy.$on("$destroy", function(){
                  deferred.resolve();
               });
            }

            return config;
         }
      };
   }]);

}]);

/* Copyright 2014 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * Http request interceptor which injects custom header for each request made from angular.
     */
    var RequestInterceptor = (function () {
        function RequestInterceptor(userSessionService, $window, $q) {
            var _this = this;
            this.userSessionService = userSessionService;
            this.$window = $window;
            this.$q = $q;
            this.vac_url = "https://vcsa.vmware.com";
            this.request = function (config) {
                // If logout is in progress, any requests that occur in the meantime have to be
                // blocked from executing as at this point it is possible the client session
                // to be already invalidated. By blocking the requests and not rejecting them
                // altogether, it is being prevented executing callers' error handlers
                // and showing unnecessary errors before the logout actually completes.
                if (_this.$window.h5.isLogoutInProgress) {
                    return _this.$q.defer().promise;
                }
                // Don't add extra header for VAC requests
                // TODO change this logic to only add headers for local requests to Virgo
                var addSessionIdHeader = _this.userSessionService.webClientSessionId &&
                    config.url && !config.url.startsWith(_this.vac_url);
                if (addSessionIdHeader) {
                    //Add web client session id to the request header, needed to
                    //an application other than h5ngc (DispatcherServlets of the plugins).
                    config.headers[_this.userSessionService.WEB_CLIENT_SESSION_ID] =
                        _this.userSessionService.webClientSessionId;
                }
                return config;
            };
        }
        return RequestInterceptor;
    }());
    platform.RequestInterceptor = RequestInterceptor;
    angular.module('com.vmware.platform.ui').factory('requestInterceptor', [
        'userSessionService', '$window', '$q', function (userSessionService, $window, $q) {
            return new RequestInterceptor(userSessionService, $window, $q);
        }]);
    angular.module('com.vmware.platform.ui').config(['$httpProvider', function ($httpProvider) {
            $httpProvider.interceptors.push('requestInterceptor');
            // change all GET headers to contain Pragma: no-cache header
            // this is required for IE 10/11 to prevent it from caching GET requests and
            // forcing all GET requests to hit the server.
            // https://github.com/saintmac/angular-cache-buster may be a better solution
            // initialize get if not there
            if (!$httpProvider.defaults.headers.get) {
                $httpProvider.defaults.headers.get = {};
            }
            //disable IE ajax request caching
            $httpProvider.defaults.headers.get['Pragma'] = 'no-cache';
        }]);
})(platform || (platform = {}));



/* Copyright 2014-2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Http interceptor to handle ajax timeout errors.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
      .factory('responseErrorInterceptor', responseErrorInterceptor);

   responseErrorInterceptor.$inject = ['$q', '$injector', '$window'];

   function responseErrorInterceptor($q, $injector, $window) {
      var isErrorShown = false;

      var interceptor = {
         responseError: function (response) {
            // If the app is navigating away, don't throw errors.
            if (response.status === -1) {
               var neverResolvingPromise = $q.defer().promise;
               return neverResolvingPromise;
            }

            // If the error is due to session timeout, then logout.
            if (response.status === 401 && !isErrorShown) {
               // The application is loading for the first time and we check whether
               // the user is authenticated. If authentication check fails, we redirect
               // to the login page (see redirect.js). The application may try to access
               // secure resources before the authentication check completes and we will
               // receive "401" response. In this case don't show alert and directly
               // navigate to the login page.
               if (!$window.h5.isLoggedIn) {
                  $window.location.href = 'login';
                  return;
               }

               isErrorShown = true;

               // Request the service through the $injector to avoid circular dependency.
               var logoutService = $injector.get('logoutService');

               logoutService.logout({ showNotification: true });
            }

            return $q.reject(response);
         },

         isErrorShown: function() {
            return isErrorShown;
         }
      };

      return interceptor;
   }

   angular.module('com.vmware.platform.ui').config(['$httpProvider',
      function ($httpProvider) {
         $httpProvider.interceptors.push('responseErrorInterceptor');
      }
   ]);
}());

/* Copyright 2014 VMware, Inc. All rights reserved. -- VMware Confidential */

angular.module('com.vmware.platform.ui').factory('refreshHttpInterceptor', ['$q', '$rootScope',
function($q, $rootScope){
      var requestCount = 0;

      return {
         'request': function(config) {
            if (!config || config.skipLoadingNotification !== true) {
               requestCount++;
               $rootScope.$broadcast('showRefreshSpinner');
            }
            return config || $q.when(config);
         },
         'requestError': function(rejection) {
            return $q.reject(rejection);
         },
         'response': function(response) {
            if (!response.config || response.config.skipLoadingNotification !== true) {
               requestCount--;
            }
            // broadcast when no requests are pending
            if (requestCount === 0) {
               $rootScope.$broadcast('hideRefreshSpinner');
            }
            return response || $q.reject(response);
         },
         'responseError': function(rejection) {
            if (!rejection.config || rejection.config.skipLoadingNotification !== true) {
               requestCount--;
            }
             if (requestCount === 0) {
               $rootScope.$broadcast('hideRefreshSpinner');
            }
            return $q.reject(rejection);
         }
      };
   }]);

angular.module('com.vmware.platform.ui').config(['$httpProvider',
   function($httpProvider) {
   $httpProvider.interceptors.push('refreshHttpInterceptor');

   var spinnerFunction = function spinnerFunction(data, headersGetter) {
      return data;
   };
   $httpProvider.defaults.transformRequest.push(spinnerFunction);
}]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function () {
   'use strict';
   /**
    * Service to alter the browser window history title (inherently the document.title) on each router (UR) change.
    */
   angular.module('com.vmware.platform.ui').factory('browserHistoryService',
   ['$document', 'i18nService', function ($document, i18nService) {
      var savedObjectId, savedObjectName, savedViewName, savedAdditionalText;
      var productName =  i18nService.getString('Common', 'productName');
      var productNameWithSucceedingDash = productName + " - " ;

      return {
         setBrowserTitle: setBrowserTitle,
         notifyCurrentObjNameChanged: notifyCurrentObjNameChanged
      };

      /**
       * Sets the browser title to the title like
       * '<objectName> - <viewName>[: "<additionalText>"] - <productName>'
       * based on the current context. The additionalText may or may not be present.
       *
       * @param tree
       *    Navigation Tree
       * @param objectId
       *    Optional objectId
       * @param additionalText
       *    Optional additional text to be displayed after the view name
       */
      function setBrowserTitle(tree, objectId, additionalText) {
         if (!($document) || !($document[0])) {
            return;
         }
         if (objectId) {
            setTitleWithObject(tree, objectId, additionalText);
            return;
         }
         setTitle(null, tree, additionalText);
      }

      /**
       * Gives the name for the object with objectId .
       * @param objectId
       *    Object Identifier whose name is given in second param
       * @param objectName
       *    Name of the object.
       */
      function notifyCurrentObjNameChanged(objectId, objectName) {
         if (savedObjectId === objectId) {
            savedObjectName = objectName;
            setTitle(savedObjectName);
         }
      }

      // Private functions
      /**
       * Sets the title of the browser given a tree and objectId.
       * If the savedObjectId is the same as the objectId given, the savedObjectName is used in the title
       * else the we cache the new objectId and clean up the savedObjectName and show nothing for object name
       * in the title.
       * @param tree - NavigationTree
       * @param objectId - objectId
       * @param additionalText
       */
      function setTitleWithObject(tree, objectId, additionalText) {
         if (objectId) {
            if (savedObjectId !== objectId) {
               savedObjectId = objectId;
               savedObjectName = null;
            }
            setTitle(savedObjectName, tree, additionalText);
         }
      }

      function setTitle(partialTitle, tree, additionalText) {
         // The general title format is:
         // <product name> - <partialTitle> - <view name>[: <additionalText>].
         var title = "";
         if (partialTitle) {
            title = partialTitle;
         }
         if (tree) {
            savedViewName = getSelectedLeafNodeName(tree);
            savedAdditionalText = additionalText;
         }
         if (isValidNodeName(savedViewName)) {
            if (title) {
               title += " - " + savedViewName;
            } else {
               title = savedViewName;
            }
         }
         if (title) {
            title = productNameWithSucceedingDash + title;
         } else {
            title = productName;
         }
         if (additionalText) {
            savedAdditionalText = additionalText;
         }
         if (savedAdditionalText) {
            title += ': "' + savedAdditionalText + '"';
         }
         if ($document && $document[0]) {
            $document[0].title = title;
         }
      }

      /**
       * Gets the name of the lead node of the NavigationTree.
       * In case of relatedObjectViews, label is used.
       *
       * @param tree - NavigationTree
       */
      function getSelectedLeafNodeName(tree)  {
         var leafNode = tree.getSelectedLeafNode();
         if (leafNode) {
            if (leafNode.name) {
               return leafNode.name;
            } else {
               return leafNode.label;
            }
         }
         return "";
      }

      function isValidNodeName(name) {
         // This, alas, is a hack. Blame it on the genius decision to
         // use a random string for the name of a non-existing leaf node.
         // Otherwise the 'missing name' creeps into our browser history.
         // Unlocalized. Because it is hard-coded.
         return name && name !== '(missing name)';
      }
   }]);

})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Url routing.
 *
 * Supports nested <vx-view> directive backed by a tree data structure.
 *
 * Originally inspired by ui-router.
 *
 */
var platform;
(function (platform) {
    "use strict";
    var Navigation = (function () {
        function Navigation($rootScope, $location, $http, $templateCache, $q, $log, navigationTreeService, navigationPreferenceService, navigatorRelationsService, browserHistoryService, urlService, telemetryTimeTrackerFactory, navigationConstants) {
            this.$rootScope = $rootScope;
            this.$location = $location;
            this.$http = $http;
            this.$templateCache = $templateCache;
            this.$q = $q;
            this.$log = $log;
            this.navigationTreeService = navigationTreeService;
            this.navigationPreferenceService = navigationPreferenceService;
            this.navigatorRelationsService = navigatorRelationsService;
            this.browserHistoryService = browserHistoryService;
            this.urlService = urlService;
            this.telemetryTimeTrackerFactory = telemetryTimeTrackerFactory;
            this.navigationConstants = navigationConstants;
            this.route = {};
            this.previousRoute = {};
            this.offLocationChangeSuccess = null;
            this.retries = 0;
        }
        Navigation.prototype.getTree = function () {
            return this.tree;
        };
        Navigation.prototype.getRoute = function () {
            return this.route;
        };
        Navigation.prototype.getPreviousRoute = function () {
            return this.previousRoute;
        };
        Navigation.prototype.populateScope = function (scope) {
            var self = this;
            angular.extend(scope, {
                _route: self.route,
                _navigate: self.navigate.bind(self),
                _navigateToObject: self.navigateToObject.bind(self),
                _navigateToViewAndObject: self.navigateToViewAndObject.bind(self),
                _navigateToView: self.navigateToView.bind(self)
            });
        };
        Navigation.prototype.fetch = function (searchParam, options) {
            var _this = this;
            // If this call is coming because of navigate(), we might have already
            // got the tree for this extensionId and objectId if extensionId is 'serverObjectView'.
            if (this.tree
                && this.extensionId && this.extensionId === searchParam.extensionId
                && this.objectId && this.objectId === searchParam.objectId
                && this.relatedItem === searchParam.relatedItem) {
                // Cancel previous request to avoid late http resolve with the wrong data.
                this.navigationTreeService.cancelPrevious();
                // Reuse once is enough since we want to deal with only back-to-back fetch() calls only.
                this.extensionId = null;
                this.objectId = null;
                this.relatedItem = undefined;
                return this.$q.resolve(this.tree);
            }
            // Optimization added that when the user is on the search view and the search view is requested again,
            // send the same navigation tree. The navigationTree for search view is constant and does not depend on the
            // query or any dynamic user input.
            if (this.tree && this.extensionId && this.extensionId === searchParam.extensionId
                && this.extensionId === this.navigationConstants.SEARCH_VIEW_EXTENSION_ID) {
                return this.$q.resolve(this.tree);
            }
            var cancellable = !(options && options.cancellable === false);
            return this.navigationTreeService
                .fetchNavigationTree(searchParam, cancellable).then(function (tree) {
                _this.tree = tree;
                _this.extensionId = searchParam.extensionId;
                _this.objectId = searchParam.objectId;
                _this.relatedItem = searchParam.relatedItem || undefined;
                return tree;
            }, function (err) {
                return _this.$q.reject(err);
            });
        };
        Navigation.prototype.getRouteFromUrl = function () {
            var search = this.$location.search();
            if (search.objectId === 'null') {
                search.objectId = null;
            }
            var route = angular.copy(search);
            if (!search.extensionId && !search.objectId && !search.navigator) {
                // front page
                // Create an empty route
                route.extensionId = null;
                route.objectId = null;
                route._frontPage = true;
            }
            else if (!search.extensionId && !search.navigator && search.objectId) {
                // uses a default extensionId if only objectId is specified
                // I'm not sure if we actually need this TBO
                route.extensionId = h5.ext;
            }
            // helper function to get additional query params from the route or from a passed argument
            // checks through a list of params and returns the rest
            route.getAdditionalParams = function (nav) {
                var r = (nav === undefined) ? this : nav;
                var queryParams = {};
                var PARAMS = ['extensionId', 'objectId', '_navigationParam'];
                for (var key in r) {
                    if (PARAMS.indexOf(key) === -1 && !angular.isFunction(r[key])) {
                        queryParams[key] = r[key];
                    }
                }
                return queryParams;
            };
            return route;
        };
        Navigation.prototype.navigateToServerObject = function (searchParam, navParam) {
            var _this = this;
            this.applyUserRoutePreferences(searchParam)
                .then(function (route) {
                return _this.fetch(route);
            })
                .then(function (tree) {
                if (searchParam.extensionId !== _this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID) {
                    // Navigating to non default extension. Check extension availability.
                    var node = tree.getById(searchParam.extensionId);
                    if (!node || !node.parent || node.parent.$childIndexToActivate < 0) {
                        // The object either has no node with this extension or other node should be activated.
                        // Navigate to nodeToActivate extension
                        var nodeToActivate = _this.tree.getSelectedLeafNode();
                        searchParam.extensionId = nodeToActivate.$id;
                    }
                }
                _this.retries = 0;
                _this._navigationParam = navParam;
                var location = _this.$location.search();
                var search = _this.$location.search(searchParam);
                // Caution, the following should be regarded as a hack/patch. It
                // handles a couple of very specific cases that occur rarely, but
                // lead to some weird behavior, e.g. the browser history buttons
                // not working properly. A lot of issues related to browser
                // navigation are caused by the fact that 'navigation' in the H5
                // client does not necessarily correspond to a single URL change,
                // in fact there are cases where more than two calls to
                // $location.search() are made. Note that a call to search() without
                // replace() causes a new history record to be written. If you ever
                // come across issues with browser navigation, watch out for multiple
                // calls to $location.search().
                //
                // Without further ado, the special cases are the following:
                // 1) The previous call to $location.search() was made as a result
                // of handling an inventory tree event (in that case the extensionId
                // is a vi tree id).
                // 2) The only modified URL parameter is 'navigator' with the
                // additional restriction that the previous value was the bogus
                // 'tree' and the new value is one of the tree IDs. For example this
                // can happen when navigating using hyperlinks and the navigator is
                // changed from object selector to inventory tree.
                if (location
                    && ((location.extensionId
                        && _.contains(_this.navigationConstants.NAVIGATOR_IDS, location.extensionId))
                        || (location.extensionId === searchParam.extensionId
                            && location.objectId === searchParam.objectId
                            && location.navigator === "tree"
                            && _.contains(_this.navigationConstants.NAVIGATOR_IDS, searchParam.navigator)))) {
                    search.replace();
                }
            }, function (err) {
                if (_this.retries >= _this.navigationConstants.RETRIES_THRESHOLD) {
                    _this.retries = 0;
                    return _this.$q.reject(err);
                }
                if (err.status !== 500) {
                    return _this.$q.reject(err);
                }
                _this.retries++;
                // We failed to retrieve the extension id. Clear the invalid extension id in
                // the local storage and navigate the user to the first object tab.
                _this.navigationPreferenceService.invalidate(searchParam.objectId);
                _this.navigate(_this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID, searchParam.objectId);
                return _this.$q.reject(err);
            });
        };
        Navigation.prototype.navigateToRelatedObject = function (objectId, relation, relatedItemUri) {
            var searchParam = angular.extend({}, {
                extensionId: this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID,
                objectId: objectId
            });
            this.navigatorRelationsService.setRelationContext(relation, relatedItemUri);
            this.$location.search(searchParam);
        };
        Navigation.prototype.navigate = function (extensionId, objectId, arg, _navigationParam) {
            //all navigation does is set the url in the correct format so onLocationChange can read it back
            _navigationParam = _navigationParam || this._navigationParam || true;
            arg = arg || {};
            // special case for related item
            if (arg.relatedItemParentId) {
                arg.relatedItem = extensionId;
                extensionId = arg.relatedItemParentId;
                delete arg.relatedItemParentId;
            }
            var searchParam = angular.extend({
                extensionId: extensionId,
                objectId: objectId
            }, arg);
            var currView = this.$location.search();
            if (angular.equals(currView, searchParam)
                || (searchParam.extensionId === this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID
                    && searchParam.objectId === currView.objectId
                    && searchParam.navigator === currView.navigator)) {
                return;
            }
            // start time counter for the current navigation request
            this.telemetryTimeTracker.startTimeTracking();
            if (searchParam.objectId) {
                this.navigateToServerObject(searchParam, _navigationParam);
            }
            else {
                this._navigationParam = _navigationParam; //see note at variable declaration
                this.$location.search(searchParam);
                this.telemetryTimeTracker.stopTimeTracking();
            }
        };
        Navigation.prototype.init = function () {
            this.route = angular.copy(this.getRouteFromUrl());
            this.populateScope(this.$rootScope);
            this.telemetryTimeTracker = this.telemetryTimeTrackerFactory.createTelemetryTracker(this.navigationConstants.NAVIGATION_REQUEST_DURATION_MEDIAN, this.navigationConstants.NAVIGATION_REQUEST_BUFFER_TIME_PROP);
            this.route = angular.copy(this.getRouteFromUrl());
            this.populateScope(this.$rootScope);
        };
        Navigation.prototype.doInitialRouting = function () {
            var _this = this;
            var applyUserPreferencesIfNeeded = this.route._frontPage ?
                this.applyUserRoutePreferences(this.route) :
                this.$q.when(this.route);
            return applyUserPreferencesIfNeeded.then(function (route) {
                if (route._frontPage) {
                    _this.$location.search({
                        extensionId: route.extensionId || _this.navigationConstants.DEFAULT_CLIENT_LOCATION
                    }).replace();
                }
                return _this.onLocationChange({ cancellable: false, forceNavigate: true }).then(function () {
                    // Subscribe for $locationChangeSuccess here so that
                    // onLocationChange() does not get fired twice when initially loading
                    // the client where we change the browser location through
                    // this.$location.search() call.
                    _this.subscribeForLocationChange();
                }, function (err) {
                    _this.$log.error(err);
                    _this.subscribeForLocationChange();
                });
            });
        };
        Navigation.prototype.navigateToObject = function (objectId, context) {
            var finalContext = angular.extend({ navigator: "tree" }, context);
            this.navigate(this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID, objectId, finalContext, { triggerONChange: true });
        };
        Navigation.prototype.navigateToViewAndObject = function (extensionId, objectId, context) {
            var finalContext = angular.extend({ navigator: "tree" }, context);
            this.navigate(extensionId, objectId, finalContext, { triggerONChange: true });
        };
        Navigation.prototype.navigateToView = function (extensionId, context) {
            this.navigate(extensionId, null, context, { triggerONChange: true });
        };
        Navigation.prototype.shouldReload = function (node, previousNode, route, previousRoute) {
            return (route.objectId !== previousRoute.objectId);
        };
        Navigation.prototype.onLocationChange = function (options) {
            var _this = this;
            this.telemetryTimeTracker.stopTimeTracking();
            var route = this.getRouteFromUrl();
            var cancellable = !(options && options.cancellable === false);
            if (options && options.forceNavigate === true) {
                route.forceNavigate = true;
            }
            //TODO: corner case:
            // Eg: navigate to host view (which shows the host summary tab), then navigate to host summary tab
            // two possible approaches:
            // 1. if we navigate to a middle of the tree, we might want to replace the url with the leaf extId
            // 2. OR, fetch on navigate, if returned tree is same, then do nothing.
            var promise = this.fetch(route, { cancellable: cancellable }).then(function (tree) {
                return _this.handleRelatedItemLeafNode(tree, route);
            }, function (err) {
                if (_this.retries >= _this.navigationConstants.RETRIES_THRESHOLD) {
                    _this.retries = 0;
                    return _this.$q.reject(err);
                }
                if (err.status !== 500) {
                    return _this.$q.reject(err);
                }
                _this.retries++;
                var newRoute = _this.$location.search();
                // We failed to retrieve the extension id. Clear the invalid extension id in
                // the local storage and navigate the user to the first object tab.
                if (newRoute.objectId) {
                    newRoute.extensionId = _this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID;
                    _this.navigationPreferenceService.invalidate(route.objectId);
                }
                else {
                    newRoute.extensionId = _this.navigationConstants.HOME_EXTENSION_ID;
                }
                // Conditionally subscribe for location change in case this method was
                // called directly from the init() method. This is the case where user
                // opens the browser and navigates to an invalid URL or to an invalid
                // bookmark or there is invalid URL in the local storage.
                _this.subscribeForLocationChange();
                _this.$location.search(newRoute).replace();
                return _this.$q.reject(err);
            });
            route._navigationParam = this._navigationParam;
            this._navigationParam = null; // see note above
            return promise.then(function (tree) {
                _this.browserHistoryService.setBrowserTitle(tree, route.objectId, route.query);
                if (tree.constructor !== NavigationTree) {
                    throw 'tree needs to be of type NavigationTreeModel';
                }
                _this.tree = tree;
                angular.copy(_this.route, _this.previousRoute);
                angular.copy(route, _this.route);
                return _this.precacheTemplates(_this.tree).then(function () {
                    _this.preCacheTemplateCallback(route);
                }, function (err) {
                    _this.$log.error("Failed to retrieve one or more html templates." + err);
                    _this.preCacheTemplateCallback(route);
                });
            });
        };
        // load all html templates to reduce flickering
        // this fetches the navi path htmls + sibling htmls.
        // We could stop fetching siblings if this is too aggressive.
        Navigation.prototype.precacheTemplates = function (tree) {
            var _this = this;
            var promises = [];
            tree.everyNode(function (node) {
                // url used in iframe src is not a template so no request should be sent
                var iframeRelated = node.contentSpec && node.contentSpec.sandbox;
                if (node.$templateUrl && !iframeRelated) {
                    promises.push(_this.$http.get(node.$templateUrl, { cache: _this.$templateCache }));
                }
            });
            return this.$q.all(promises);
        };
        Navigation.prototype.preCacheTemplateCallback = function (route) {
            if (route.extensionId
                && route.extensionId !== this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID) {
                this.navigationPreferenceService.persistLastExtension(route.objectId, route.extensionId, route.relatedItem, route.navigator);
            }
            // this is to trigger all existing <vx-view> to tell them to update themselves
            this.$rootScope.$broadcast('vxRouteChangeSuccess', this.tree, this.route, this.previousRoute);
        };
        Navigation.prototype.subscribeForLocationChange = function () {
            var _this = this;
            if (!this.offLocationChangeSuccess) {
                this.offLocationChangeSuccess =
                    this.$rootScope.$on('$locationChangeSuccess', function (event, newUrl, oldUrl) {
                        // Don't handle URL changes if only the list view selection
                        // parameter was changed (we're not really changing location
                        // in this case).
                        newUrl = _this.urlService.removeParameter(newUrl, h5.listViewSelectedItemIdProperty);
                        oldUrl = _this.urlService.removeParameter(oldUrl, h5.listViewSelectedItemIdProperty);
                        if (newUrl !== oldUrl) {
                            _this.onLocationChange();
                        }
                    });
            }
        };
        // code to handle relatedItems as they come from a different endpoint
        // if the leaf node has related items as children, we fetch from a different endpoint
        // and add the results as its children into the tree
        Navigation.prototype.handleRelatedItemLeafNode = function (tree, route) {
            var leaf = tree.getSelectedLeafNode();
            if (!(leaf.extensionObject &&
                leaf.extensionObject.contentSpec &&
                leaf.extensionObject.contentSpec.metadata &&
                (leaf.extensionObject.contentSpec.metadata.fetchRelatedAsChildren ||
                    leaf.extensionObject.contentSpec.metadata.showRelationsFor))) {
                return this.$q.resolve(tree);
            }
            if (leaf.$children.length !== 0) {
                throw "Assumption violated: any extension with fetchRelatedAsChildren or " +
                    "showRelationsFor set should not have any children as they come " +
                    "from a different data structure";
            }
            var url;
            var params = {
                relationsViewId: leaf.uid
            };
            if (leaf.extensionObject.contentSpec.metadata.fetchRelatedAsChildren) {
                url = 'relateditems/list/' + route.objectId;
            }
            else {
                url = 'relateditems/listspec/' + leaf.extensionObject.contentSpec.metadata.showRelationsFor;
                params.onlyFavorites = false;
            }
            return this.$http({
                method: 'get',
                url: url,
                params: params
            }).then(function (resp) {
                var data = resp.data;
                leaf.$children = data;
                leaf.$selectedChildIndex = data.length ? 0 : -1;
                for (var i = 0; i < data.length; i++) {
                    var relatedNode = data[i];
                    var url_1 = (relatedNode.listSpec && relatedNode.listSpec.contentSpec) ?
                        relatedNode.listSpec.contentSpec.url :
                        null;
                    angular.extend(relatedNode, {
                        $id: relatedNode.listSpec.uid,
                        $children: [],
                        $parent: leaf,
                        $selectedChildIndex: -1,
                        $templateUrl: url_1,
                        //$viewRetentionPolicy: node.extensionObject.contentSpec.viewRetentionPolicy //TODO: copy over this field
                        liveRefreshEnabled: true
                    });
                    // if url specified a related item to go to, set the index correctly
                    if (route.relatedItem === relatedNode.$id) {
                        leaf.$selectedChildIndex = i;
                    }
                }
                return tree;
            });
        };
        /**
         * Applies the user preferences for the route.
         *
         * @param searchParam the location
         * @returns {Function} future with applied modifications to the search param
         */
        Navigation.prototype.applyUserRoutePreferences = function (searchParam) {
            var self = this;
            if (!searchParam.extensionId || this.navigationConstants.SERVER_OBJECT_VIEW_EXTENSION_ID === searchParam.extensionId) {
                // No extension specified for object - swap with the last extension the user navigated to
                return this.navigationPreferenceService.getLastExtension(searchParam.objectId)
                    .then(function (userSetting) {
                    if (userSetting && userSetting.extensionId) {
                        searchParam.extensionId = userSetting.extensionId;
                    }
                    if (userSetting && userSetting.relatedItem) {
                        searchParam.relatedItem = userSetting.relatedItem;
                    }
                    return searchParam;
                }, function (err) {
                    self.$log.error("User preferences for the route not applied correctly." + err);
                });
            }
            return this.$q.resolve(searchParam);
        };
        Navigation.$inject = [
            '$rootScope',
            '$location',
            '$http',
            '$templateCache',
            '$q',
            '$log',
            'navigationTreeService',
            'navigationPreferenceService',
            'navigatorRelationsService',
            'browserHistoryService',
            'urlService',
            'telemetryTimeTrackerFactory',
            'navigationConstants'
        ];
        return Navigation;
    }());
    platform.Navigation = Navigation;
    angular.module("com.vmware.platform.ui").service("navigation", Navigation);
})(platform || (platform = {}));



"use strict";
angular
    .module("com.vmware.platform.ui")
    .constant("navigationConstants", {
    DEFAULT_CLIENT_LOCATION: "vsphere.core.viTree.hostsAndClustersView",
    SERVER_OBJECT_VIEW_EXTENSION_ID: "vsphere.core.inventory.serverObjectViewsExtension",
    SEARCH_VIEW_EXTENSION_ID: "vsphere.core.search.domainView",
    NAVIGATOR_IDS: [
        "vsphere.core.viTree.hostsAndClustersView",
        "vsphere.core.viTree.vmsAndTemplatesView",
        "vsphere.core.viTree.storageView",
        "vsphere.core.viTree.networkingView",
    ],
    HOME_EXTENSION_ID: "com.vmware.samples.dashboard.mainView",
    SHORTCUTS_EXTENSION_ID: "vsphere.core.controlcenter.domainView",
    HOSTS_AND_CLUSTERS_EXTENSION_ID: "vsphere.core.viTree.hostsAndClustersView",
    VMS_EXTENSION_ID: "vsphere.core.viTree.vmsAndTemplatesView",
    STORAGE_EXTENSION_ID: "vsphere.core.viTree.storageView",
    NETWORKING_EXTENSION_ID: "vsphere.core.viTree.networkingView",
    DATASTORES_EXTENSION_ID: "vsphere.core.viLibraries.domainView",
    GLOBAL_INVENTORY_LISTS_EXTENSION_ID: "vsphere.core.viHome.domainView",
    // retry 3 times at most, when navigating to an invalid extension
    RETRIES_THRESHOLD: 3,
    NAVIGATION_REQUEST_DURATION_MEDIAN: "navReqDurationMed",
    NAVIGATION_REQUEST_BUFFER_TIME_PROP: "telemetry.navigation.bufferTime"
});



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Persistence of the navigation object extensions.
 */
angular.module('com.vmware.platform.ui').factory(
   'navigationPreferenceService',
   ['localStorageService', 'defaultUriSchemeUtil', '$q',
      function (localStorageService, defaultUriSchemeUtil, $q) {
         var LOCAL_STORAGE_KEY = 'navigation.history.extension';

         var _isPersistenceEnabled = true;

         // public API
         return {
            disablePersistence: disablePersistence,
            enablePersistence: enablePersistence,
            getLastExtension: getLastExtension,
            persistLastExtension: persistLastExtension,
            invalidate: invalidate
         };

         /**
          * Disables the navigation settings persistence.
          */
         function disablePersistence() {
            _isPersistenceEnabled = false;
         }

         /**
          * Enables the persistence of the navigation settings.
          */
         function enablePersistence() {
            _isPersistenceEnabled = true;
         }

         /**
          * Extracts the last extension id which was navigated to in the client.
          * If given an objectId then extracts the last extension id for that particular
          * inventory object
          *
          * @param objectId the server object id
          * @returns {string|*|Object|the} extension id as a string
          */
         function getLastExtension(objectId) {
            if (!_isPersistenceEnabled) {
               return $q.resolve();
            }

            return localStorageService.getUserData(generateStorageKey(objectId));
         }

         /**
          * Invalidates an entry for a particular inventory object
          *
          * @param objectId the server object id
          * @returns {Boolean} false if persistence is not enabled, true otherwise.
          */
         function invalidate(objectId) {
            if (!_isPersistenceEnabled) {
               return false;
            }

            localStorageService.setUserData(generateStorageKey(objectId), {});

            return true;
         }

         /**
          * Persists the extension id in the browsers local storage
          *
          * @param objectId the server object id
          * @param extensionId extension id to persist
          * @param relatedItem related item id to persist
          * @param navigator The extensionId of the view which is used to navigate to
          *    the object and view described by objectId and extensionId params.
          */
         function persistLastExtension(objectId, extensionId, relatedItem, navigator) {
            if (_isPersistenceEnabled) {
               if (navigator && navigator !== 'tree') {
                  localStorageService.setUserData(generateStorageKey(), {
                     extensionId: navigator
                  });
               }
               localStorageService.setUserData(generateStorageKey(objectId), {
                  extensionId: extensionId,
                  relatedItem: relatedItem
               });
            }
         }

         /**
          * Generates the key for local storage per object
          *
          * @param objectId
          * @returns {string}
          */
         function generateStorageKey(objectId) {
            var storageKey = objectId ?
                  LOCAL_STORAGE_KEY + '.' + getEntityTypeKey(objectId) :
                  LOCAL_STORAGE_KEY;

            return storageKey;
         }

         /**
          * Extracts entity type from object id
          *
          * @param objectId
          * @returns {Promise} with the entity
          */
         function getEntityTypeKey(objectId) {
            if (defaultUriSchemeUtil.isRootFolder(objectId)) {
               return "RootFolder";
            }
            return defaultUriSchemeUtil.getEntityType(objectId);
         }
      }]);
/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
var NavigationTree = (function () {
    /**
     * root is of the form:
     * {
     *    $id: string,
     *    $selectedChildIndex: int,
     *    $children: [],
     *    other fields...
     * }
     */
    function NavigationTree(root) {
        var _this = this;
        this.root = root;
        // this adds the helper getSelectedChild() method to every node
        // we might refactor to use proper prototypes in the future
        this.everyNode(function (node) {
            node.getSelectedChild = function () {
                return _this.getSelectedChild(node);
            };
            node.getNonEmptyChildren = function () {
                var result = [];
                for (var i = 0; i < node.$children.length; i++) {
                    var child = node.$children[i];
                    // Skip extensions created by vsphere.core.inventory.objectViewTemplate
                    // for which there is no content yet, to avoid empty tabs
                    if (child.$templateUrl !== "resources/ui/views/TocView.html" ||
                        (angular.isArray(child.$children) && (child.$children.length > 0))) {
                        result.push(child);
                    }
                }
                return result;
            };
        });
    }
    NavigationTree.everyNode = function (node, visitor, childFieldName, parent) {
        visitor(node, parent);
        node[childFieldName].forEach(function (child) {
            NavigationTree.everyNode(child, visitor, childFieldName, node);
        });
    };
    // visitor(node,parent) function will be called on every node of this tree
    NavigationTree.prototype.everyNode = function (visitor) {
        return NavigationTree.everyNode(this.root, visitor, '$children');
    };
    ;
    // returns the leaf node of the navigation tree
    NavigationTree.prototype.getSelectedLeafNode = function () {
        var n = this.root;
        var child;
        while (n.getSelectedChild && (child = n.getSelectedChild())) {
            n = child;
        }
        return n;
    };
    ;
    // searches for a node by id, then return {node, parent}
    NavigationTree.prototype.getById = function (id) {
        var result = {};
        // not the most optimized way...
        this.everyNode(function (node, parent) {
            if (node.$id === id) {
                result.node = node;
                result.parent = parent;
            }
        });
        return result;
    };
    ;
    // returns the node at a certain depth, 0 being the root node
    NavigationTree.prototype.getNodeAtLevel = function (idx) {
        var n = this.root;
        for (var i = 0; i < idx; i++) {
            n = this.getSelectedChild(n);
            if (!n) {
                return null;
            }
        }
        return n;
    };
    ;
    // return the selected node at the next level, or null
    NavigationTree.prototype.getSelectedChild = function (node) {
        if (node && node.$selectedChildIndex !== -1) {
            return node.$children[node.$selectedChildIndex] || null;
        }
        return null;
    };
    return NavigationTree;
}());



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service to persist the navigation tree
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('navigationTreeService', navigationTreeService);

   navigationTreeService.$inject = ['$http', '$q', 'httpCancellationService', 'logService'];

   function navigationTreeService($http, $q, httpCancellationService, logService) {
      var notImplementedUrl = "common-module-ui/resources/common-module/views/NotImplemented.html";
      var notSupportedUrl = "common-module-ui/resources/common-module/views/NotSupported.html";
      var errorUrls = {
         OBJECT_NOT_FOUND: "resources/ui/views/objectnavigator/error/ObjectNotFound.html"
      };
      var cancellableRequest = httpCancellationService();

      var log = logService('navigationTreeService');

      // Public API
      return {
         /**
          * Fetch the NavigationTree for a given navigation route.
          *
          * @param {Object} searchParam
          * @param {boolean} cancellable
          * @returns {NavigationTree}
          */
         fetchNavigationTree: fetchNavigationTree,

         /**
          * Cancels previous navigation tree fetch.
          */
         cancelPrevious: cancellableRequest.cancel
      };

      function fetchNavigationTree(searchParam, cancellable) {
         var config = {
            method: 'get',
            url: 'navigation/data/' + searchParam.extensionId,
            params: {
               objectId: searchParam.objectId
            },
            // errorResponseInterceptor.js will intercept all 40x, 500, etc errors
            // and it will display a popup with an error message. We want to prevent
            // that code from executing and handle the error ourselves. The reason
            // is that it's possible to send a request for an invalid extension id,
            // because extension ids for tabs are cached in the local storage. Those extension ids
            // could be invalidated by renaming the extension, uninstalling the plugin providing
            // the extension, etc. In that case, we'll clear the local storage entry
            // and navigate the user to the 1st tab of the object.
            skipErrorInterceptor: true
         };

         var promise = cancellable ? cancellableRequest.fetch(config) : $http(config);

         return promise.then(function (resp) {
            if (!resp) {
               var reason = 'undefined response to navigation/data/' + searchParam.extensionId;
               log.error(reason);
               return  $q.reject(reason);
            }
            var tree = resp.data;
            NavigationTree.everyNode(tree, function (node, parent) {
               // Having a contentSpec but no contentSpec.url means it's a non supported Flex view
               var url = errorUrls[node.error] ||
                  (node.extensionObject.contentSpec && (node.extensionObject.contentSpec.url || notSupportedUrl)) ||
                  notImplementedUrl;

               angular.extend(node, {
                  $id: node.error || node.extensionObject.uid,
                  $children: node.children,
                  $parent: parent || null,
                  $selectedChildIndex: node.childIndexToActivate,
                  $templateUrl: url,
                  $viewRetentionPolicy: (node.extensionObject && node.extensionObject.contentSpec && node.extensionObject.contentSpec.viewRetentionPolicy) ?
                        node.extensionObject.contentSpec.viewRetentionPolicy : null
               }, node.extensionObject);
            }, 'children');

            return new NavigationTree(tree);
         }, function (err) {
            return $q.reject(err);
         });
      }
   }
})();

/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
       A ---STATEFUL--- service used to preserve metadata about object navigator relations
       during a navigation procedure.
     */
    var NavigatorRelationsService = (function () {
        function NavigatorRelationsService() {
        }
        NavigatorRelationsService.prototype.setRelationContext = function (relation, relatedItemUri) {
            this.relationContext = {
                relation: relation,
                relatedItemUri: relatedItemUri
            };
        };
        NavigatorRelationsService.prototype.consumeRelationContext = function () {
            var context = this.relationContext;
            this.relationContext = undefined;
            return context;
        };
        return NavigatorRelationsService;
    }());
    platform.NavigatorRelationsService = NavigatorRelationsService;
    angular.module("com.vmware.platform.ui")
        .service("navigatorRelationsService", NavigatorRelationsService);
})(platform || (platform = {}));



/* Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential */
var sandbox;
(function (sandbox) {
    var GLOBAL_REFRESH_EVENT = 'dataRefreshInvocationEvent';
    /**
     * This service implements the business logic of plugin messaging API such as:
     * - handling requests from the plugins
     * - listening for platform events and eventually notifying the plugins
     *
     * The service may be initialized only once.
     *
     * Internally it uses {@link SandboxMessagingService} to do the actual communication
     * with the plugins.
     */
    var SandboxBridgeService = (function () {
        function SandboxBridgeService($rootScope, sandboxMessagingService) {
            this.$rootScope = $rootScope;
            this.sandboxMessagingService = sandboxMessagingService;
            this.initialized = false;
        }
        SandboxBridgeService.prototype.init = function () {
            var _this = this;
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.$rootScope.$on(GLOBAL_REFRESH_EVENT, function () { return _this.sendGlobalRefreshMessage(); });
            this.sandboxMessagingService.subscribeForMessages(function (message, source) { return _this.onMessage(message, source); });
        };
        SandboxBridgeService.prototype.sendGlobalRefreshMessage = function () {
            var message = { message: "globalRefresh" };
            this.sandboxMessagingService.broadcastMessage(message);
        };
        SandboxBridgeService.prototype.onMessage = function (pluginMessage, source) {
        };
        SandboxBridgeService.$inject = [
            '$rootScope',
            'sandboxMessagingService'
        ];
        return SandboxBridgeService;
    }());
    sandbox.SandboxBridgeService = SandboxBridgeService;
    angular
        .module('com.vmware.platform.ui')
        .service('sandboxBridgeService', SandboxBridgeService);
})(sandbox || (sandbox = {}));



/* Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential */



/* Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential */
var sandbox;
(function (sandbox) {
    /**
     * This service is responsible for the actual communication with the plugin.
     * It has no business logic but just:
     *  - sends already prepared messages to the iframe(s)
     *  - receives messages from the iframes and pass them to the subscribed listeners
     */
    var SandboxMessagingService = (function () {
        function SandboxMessagingService($window) {
            var _this = this;
            this.$window = $window;
            this.listeners = [];
            this.$window.addEventListener("message", function (messageEvent) { return _this.receiveMessage(messageEvent); }, false);
        }
        SandboxMessagingService.prototype.broadcastMessage = function (message) {
            _.each(this.$window.frames, function (iframeWindow) { return iframeWindow.postMessage(message, "*"); });
        };
        SandboxMessagingService.prototype.subscribeForMessages = function (listener) {
            if (this.listeners.indexOf(listener) === -1) {
                this.listeners.push(listener);
            }
        };
        SandboxMessagingService.prototype.receiveMessage = function (message) {
            _.each(this.listeners, function (listener) { return listener(message.data, message.source); });
        };
        SandboxMessagingService.$inject = ["$window"];
        return SandboxMessagingService;
    }());
    sandbox.SandboxMessagingService = SandboxMessagingService;
    angular
        .module('com.vmware.platform.ui')
        .service('sandboxMessagingService', SandboxMessagingService);
})(sandbox || (sandbox = {}));



(function() {

   'use strict';

   angular.module('com.vmware.platform.ui')
         .service('actionConfirmationService', actionConfirmationService);

   actionConfirmationService.$inject = ['$compile', '$rootScope', 'i18nService', 'jsUtils',
         'logService', 'clarityModalService', 'defaultUriSchemeUtil', 'managedByMessageBuilderService'];

   function actionConfirmationService($compile, $rootScope, i18nService, jsUtils,
         logService, clarityModalService, defaultUriSchemeUtil, managedByMessageBuilderService) {

      var log = logService('actionConfirmationService');

      /**
       * Constant used to identify that a default confirmation message shouldn't be
       * displayed by the action framework.
       *
       * In multiple targets scenario if some of the confirmation messages
       * (confirmationTextNone, confirmationTextSome or confirmationTextAll) is not
       * defined we are displaying a default message. If you want to skip that default
       * message just set the corresponding confirmation text in plugin.xml to "CUSTOM".
       */
      var CUSTOM_CONFIRMATION = 'CUSTOM';

      var MANAGEDBY_PROPERTY = 'managedByExtensionKey';

      /**
       * All the actions that are defined by plugins have one of those invokers.
       * In case tha action is defined by a plugin, we do not display a managed by warning message
       */
      var pluginActionsInvokers = ['com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate',
         'com.vmware.vsphere.client.pluginActions', 'com.vmware.vsphere.client.HtmlPluginHeadlessAction',
         'com.vmware.vsphere.client.HtmlPluginModalAction'];

      return {
         confirmIfRequired: confirmIfRequired,
         showConfirmationDialog: showConfirmationDialog,
         showWarningDialog: showWarningDialog
      };

      function confirmIfRequired(actionEval, confirmHandler, skipManagedByCheck) {

         if (jsUtils.isUndefinedOrNull(actionEval)) {
            log.error('ActionEval not found');
            return;
         }

         if (!actionEval.action) {
            log.error('ActionEval\'s action not found');
            return;
         }

         var actionId = actionEval.action.uid;
         if (!actionEval.invoker || actionEval.invoker.length === 0) {
            log.error('No invoker specified for action: ' + actionId);
            return;
         }

         var confirmationText;
         var showConfirmationFunc = showConfirmationDialog;
         var isMultipleTargets = false;

         if (actionEval.evaluationStatuses) {
            var totalTargetsCount = Object.keys(actionEval.evaluationStatuses).length;
            isMultipleTargets = totalTargetsCount > 1;

            if (!isMultipleTargets) {
               if (!actionEval.available) {
                  log.error('Unavailable action ' + actionId + ' for single object');
                  return;
               }

               // in case the text is empty or custom set the confirmationText to an empty string
               // - if the text is CUSTOM the confirmation will be handled by the action
               // - if it is just not set, if needed a warning for managed entity will be displayed
               confirmationText = getConfirmationText(actionEval.action.confirmationText, "");
            } else {
               if (!actionEval.available) {
                  // this is hit when the action is not available for any of the selected
                  // targets
                  confirmationText = getConfirmationText(
                        actionEval.action.confirmationTextNone,
                        i18nService.getString('Common', 'defaultConfirmation.noneOK'));

                  // in this case we need to display a warning dialog that has only OK button
                  // instead of Yes/No
                  showConfirmationFunc = showWarningDialog;
               } else {
                  var availableTargetsCount = 0;

                  _.each(actionEval.evaluationStatuses, function(evalStatus) {
                     if (evalStatus.available) {
                        availableTargetsCount++;
                     }
                  });

                  if (totalTargetsCount === availableTargetsCount) {
                     confirmationText = getConfirmationText(
                           i18nService.interpolate(actionEval.action.confirmationTextAll,
                                 [availableTargetsCount]),
                           i18nService.getString('Common', 'defaultConfirmation.allOK',
                                 availableTargetsCount));
                  } else {
                     confirmationText = getConfirmationText(
                           i18nService.interpolate(actionEval.action.confirmationTextSome,
                                 [availableTargetsCount, totalTargetsCount]),
                           i18nService.getString('Common', 'defaultConfirmation.someOK',
                                 availableTargetsCount, totalTargetsCount));
                  }
               }
            }
         }

         /**
          * Only check if the entity is managed in case skipManagedByCheck flag is false,
          * the action is available, the action is not defined by a plugin and the managed by property is set
          */
         var checkIfManaged = !skipManagedByCheck && actionEval.available &&
               actionEval.additionalProperties &&
               actionEval.additionalProperties[MANAGEDBY_PROPERTY] &&
               !_.contains(pluginActionsInvokers, actionEval.invoker);

         if (!!confirmationText) {
            var properties = getConfirmationDialogProperties(actionEval, confirmationText, confirmHandler);
            /**
             * In case the context object is managed by a solution, retrieve the name of the solution
             * and build the necessary text to be prepended to the confirmation text
             */
            if (checkIfManaged) {
               managedByMessageBuilderService.buildConfirmationText(actionEval.context.targetObjects, confirmationText)
                     .then(function(managedByConfirmationText) {
                        if (managedByConfirmationText) {
                           properties.message = managedByConfirmationText;
                        }
                        showConfirmationFunc(properties);
                     });
               return;
            }
            showConfirmationFunc(properties);
            return;
         }

         // we hit this case ONLY for managed VMs and vApps, for single target
         // that does not have custom handling of the confirmation logic
         // for all other cases of single objects, no matter if the confirmation text
         // is CUSTOM or not set at all confirmHandler will be called and
         // any confirmations defined in there will be shown
         if (!isMultipleTargets && checkIfManaged &&
               actionEval.action.confirmationText !== CUSTOM_CONFIRMATION) {
            managedByMessageBuilderService.buildConfirmationText(actionEval.context.targetObjects, "", true)
                  .then(function(managedByConfirmationText) {
                     if(managedByConfirmationText) {
                        var properties = getConfirmationDialogProperties(actionEval, confirmationText, confirmHandler);
                        properties.message = managedByConfirmationText;
                        showConfirmationFunc(properties);
                     } else {
                        // in case the managed by properties can not be retrieved invoke the action
                        if (confirmHandler && typeof confirmHandler === 'function') {
                           confirmHandler();
                        }
                     }
                  });
            return;
         }


         // we hit this call only for single target when there is no confirmationText
         // specified
         if (confirmHandler && typeof confirmHandler === 'function') {
            confirmHandler();
         }
      }

      /**
       * Displays a confirmation dialog for an action.
       *
       * @static
       * @memberOf actionConfirmationService
       * @param {Object} alertProperties An object with properties describing the dialog:
       *    title {string} - The title of the dialog.
       *    message {string} - The message in the dialog.
       *    yesHandler {Function} - A function called if the 'Yes' button is pressed.
       *    noHandler {Function} - A function called if the 'No' button is pressed.
       *
       *    OPTIONAL:
       *    useClarity {boolean} - Whether to use a clarity dialog or a vx one.
       *       Clarity is recommended, so set this to true.
       *    icon {string} - The icon to use. Its default value is "icon-warning-32".
       *       If null is used, there is no icon.
       *    yesIsDefaultButton {boolean} - The button focused by default is 'Yes' if this
       *       evaluates to true. This property works only if useClarity is set to true!
       * @returns {void}
       * @example
       * actionConfirmationService.showConfirmationDialog({
       *    useClarity: true,
       *    title: 'Log "foo"',
       *    message: 'Press the "Yes" button to log "foo" in the console.',
       *    yesHandler: function() { console.log('foo') }
       * });
       */
      function showConfirmationDialog(alertProperties) {
         _.defaults(alertProperties, {
            icon: 'icon-warning-32',
            yesHandler: function () {},
            noHandler: function () {}
         });
         _.extend(alertProperties, {
            yesLabel: i18nService.getString('Common', 'yes.label'),
            noLabel: i18nService.getString('Common', 'no.label')
         });

         if (alertProperties.useClarity) {
            showClarityConfirmationDialog(alertProperties);
         } else {
            showVxConfirmationDialog(alertProperties);
         }
      }

      //region Helper functions

      function showVxConfirmationDialog(alertProperties) {
         var scope = $rootScope.$new();

         scope.alertOptions = {
            title: alertProperties.title,
            text: alertProperties.message,
            icon: alertProperties.icon,
            visible: true,
            confirmOptions: {
               label: alertProperties.yesLabel,
               visible: true,
               disabled: false,
               onClick: function() {
                  alertProperties.yesHandler();
                  closeConfirmationDialog();
               }
            },
            rejectOptions: {
               label: alertProperties.noLabel,
               visible: true,
               disabled: false,
               focused: true,
               onClick: function() {
                  alertProperties.noHandler();
                  closeConfirmationDialog();
               }
            }
         };
         var alertTemplate = '<div id="action-confirmation" ' +
               'class="action-confirmation" vx-alert="alertOptions"></div>';
         var alertDialog = angular.element(alertTemplate);
         var compiledAlertDialog = $compile(alertDialog)(scope);

         var parentId = alertProperties.parent || "#main-app-div";
         angular.element(parentId).append(compiledAlertDialog);
      }

      function showClarityConfirmationDialog(alertProperties) {
         var modalOptions = {
            title: alertProperties.title,
            subTitle: alertProperties.subTitle,
            message: alertProperties.message,
            icon: alertProperties.icon,
            preserveNewlines: true,
            saveButtonLabel: alertProperties.yesLabel,
            cancelButtonLabel: alertProperties.noLabel,
            showXIcon: alertProperties.showXIcon,
            submit: alertProperties.yesHandler,
            onCancel: alertProperties.noHandler
         };

         if (!_.isEmpty(alertProperties.clarityIcon)) {
            modalOptions.clarityIcon = alertProperties.clarityIcon;
         }

         if(!alertProperties.yesIsDefaultButton) {
            modalOptions.defaultButton = 'close';
         }

         clarityModalService.openConfirmationModal(modalOptions);
      }

      function closeConfirmationDialog() {
         angular.element("#action-confirmation").remove();
      }

      /**
       * Gets confirmation text - if action confirmation text is not specified, we return
       * the default one. If the message is specified and is different than CUSTOM - we
       * return the message, otherwise - return null.
       */
      function getConfirmationText(actionConfirmationText, defaultConfirmationText) {
         if (!actionConfirmationText) {
            return defaultConfirmationText;
         }

         if (actionConfirmationText !== CUSTOM_CONFIRMATION) {
            return actionConfirmationText;
         }

         // if the confirmation is provided by the action definition and it's value is
         // CUSTOM - we don't have to show confirmation from this service
         return null;
      }

      function showWarningDialog(alertProperties) {
         clarityModalService.openConfirmationModal({
            title: alertProperties.title,
            message: alertProperties.message,
            submit: function () {},
            preserveNewlines: true,
            saveButtonLabel: i18nService.getString('Common', 'alert.ok'),
            cancelButtonLabel: null,
            hideCancelButton: true,
            clarityIcon: {
               shape: "warning",
               class: "is-warning",
               size: 48
            },
            showXIcon: false
         });
      }

      function getConfirmationDialogProperties(actionEval, confirmationText, confirmHandler) {
         var confirmationTitle = !!actionEval.action.confirmationTitle ?
               actionEval.action.confirmationTitle :
               actionEval.action.label;
         var properties = {
            useClarity: true,
            title: confirmationTitle,
            message: confirmationText,
            yesHandler: confirmHandler,
            icon: null,
            clarityIcon: {
               shape: "warning",
               class: "is-warning",
               size: 48
            },
            showXIcon: false
         };

         if (actionEval.context && actionEval.context.targetObjects.length === 1) {
            _.extend(properties, {
               subTitle: {
                  objectId: defaultUriSchemeUtil.getVsphereObjectId(actionEval.context.targetObjects[0])
               }
            });
         }

         return properties;
      }
      //endregion
   }
})();

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Service for opening dialogs and wizards (all popups) based on actions framework actions.
 * Can be extended to work for other non-action integrated actions later on. Also will be integrated with TIWO
 */
angular.module('com.vmware.platform.ui')
.factory('actionDialogService',['$q', '$rootScope', 'vuiDialogService', 'dataService', 'i18nService', function($q, $rootScope, vuiDialogService, dataService, i18nService) {

   //======================= Public Functions ==========================
   /**
    * Opens an OK/Cancel modal dialog in the application.
    *
    * @param actionEval {Object} ActionEval associated with the action that is being invoked.
    *
    * @param availableTargets {string[]} Identifiers for server objects on which the action will be performed.
    *
    * @param dialogData {Object} Additional data passed to the dialog/wizard from the source.
    *
    * @param contentUrl {string} Url of the html template of the dialog content.
    *
    * @param extraDialogOptions {Object} Additional data for vuiDialogService to use (height, width...)
    */
   var openActionDialog = function(actionEval, availableTargets, dialogData, contentUrl, extraDialogOptions, modalOptions) {
      var scope = $rootScope.$new();
      var dialogOptions = angular.extend({
         show: true,
         iconClass: actionEval.action.icon,
         contentUrl: contentUrl,
         actionDetails: {
            actionEval: actionEval,
            availableTargets: availableTargets,
            dialogData: dialogData
         },
         width: '400px',
         height: '200px'
      }, extraDialogOptions || {});

      if (extraDialogOptions) {
         // amarinov: Merge dialogOptions back to extraDialogOptions so that the caller would be given the ability to
         // modify the dialog options after the dialog is shown through the extraDialogOptions
         dialogOptions = angular.extend(extraDialogOptions, dialogOptions);
      }

      scope.dialogOptions = dialogOptions;

      scope.dialogOptions.title = getDialogTitle(actionEval, availableTargets, scope.dialogOptions);

      var options = angular.merge({}, modalOptions);
      options = angular.extend(options, {
         scope: scope,
         configObjectName: 'dialogOptions'
      });

      return vuiDialogService(options);
   };

   //======================= Private Functions ==========================
   /**
    * Immediately returns some title so that the dialog can be shown as soon as
    * possible.
    * If needed, schedules a request for the target object's name.
    */
   function getDialogTitle(actionEval, availableTargets, dialogOptions) {
      // we have a localized title without placeholders
      if (dialogOptions.title && dialogOptions.title.indexOf('{0}') === -1) {
         return dialogOptions.title;
      }
      if (!availableTargets) {
         return actionEval.action.label;
      }
      if (availableTargets.length === 1) {
         // Get the name of the object and make the new title.
         setTitleForSingleObject(availableTargets[0], dialogOptions, actionEval,
               dialogOptions.title);
         return actionEval.action.label;
      } else {
         return i18nService.getString('Common', 'dialogTitleFormatMultiple',
               availableTargets.length, actionEval.action.label);
      }
   }

   function setTitleForSingleObject(objectId, dialogOptions, actionEval, placeholderTitle) {
      return dataService.getProperties(objectId, ['name']).then(function(data) {
         if (!data.name) {
            return;
         }
         if (placeholderTitle) {
            // Remove the placeholder from the localized title if it exists
            dialogOptions.title = i18nService.interpolate(placeholderTitle,
                  [data.name]);
         } else {
            dialogOptions.title = i18nService.getString('Common',
                  'dialogTitleFormat', data.name, actionEval.action.label);
         }
      });
   }

   // ======================= Public API ==========================
   return {
      openActionDialog : openActionDialog
   };
}]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service for retrieving and invoking actions and showing menus.
 */
angular.module('com.vmware.platform.ui').factory('actionsService',
      ['$http', '$window', 'logService', 'i18nService', 'vuiActionsMenuService',
      'vuiConstants', '$q', 'actionConfirmationService', 'jsUtils', '$timeout',
      '$analytics', 'dataService','keyboardShortcutMapper',
      function($http, $window, logService, i18nService, vuiActionsMenuService,
            vuiConstants, $q, actionConfirmationService, jsUtils, $timeout, $analytics,
            dataService, keyboardShortcutMapper) {

   'use strict';
   var log = logService('actionsService');
   var menuItemTypes = {
      MENU : 'MENU',
      SEPARATOR: 'SEPARATOR',
      ACTION : 'ACTION'
   };
   var lastMenuItemId = 0;
   var menuContainerId = 'applicationMenuContainer';
   var solutionMenusExtensionPoint = 'vise.menus.context.solutionMenus';
   // combines the 6.0 and 6.5 menu types to support 6.0 plugins
   var objectContextMenuTypes = 'vise.menus.context,vise.menus.context.solutionMenus';

   /**
    * Builds, stores the menu item in MenuStore if it is of type 'ACTION'
    * and returns a menu item.
    *
    * @param item Menu object.
    *
    * @param menuItemsByActionUid Menu object Store.
    *
    * @param callInvoker The menu click handler.
    *
    * @return Object representing a menu Item.
    */
   function buildMenuItem(item, menuItemsByActionUid, targets, callInvoker) {
      var menuItem = {
         id: item.id,
         label: item.label,
         iconClass: item.icon,
         enabled: true
      };
      if (item.type === menuItemTypes.SEPARATOR) {
         return vuiConstants.actions.SEPARATOR;
      } else if (item.type === menuItemTypes.MENU) {
         if (!item.id) {
            item.id = generateMenuItemId();
         }
         menuItem.items = item.children.map(function(item) {
            return buildMenuItem(item, menuItemsByActionUid, targets, callInvoker);
         });
      } else if (item.type === menuItemTypes.ACTION) {
         menuItem.onClick = function(eventInfo) {
            callInvoker(item.id, targets, eventInfo);
         };
         menuItem.keyboardShortcut = keyboardShortcutMapper
               .getFormattedKeyboardShortcut(item.id);
      }
      menuItemsByActionUid[menuItem.id] = menuItem;
      return menuItem;
   }

   /**
    * Extracts and returns the object ids from the given target objects.
    *
    * @param targets {Object[]} The target objects to extract the ids from.
    *
    * @return {string[]} Array of object ids. Null if null is passed in.
    */
   var extractObjectIds = function (targets) {
      if (targets === null) {
         return null;
      }
      var idArray = [];
      $.each(targets, function(index, value) {
         idArray.push(value.id);
      });
      return idArray;
   };

   /**
    * Creates and returns a menu Header object.
    *
    * @param targets Object[] The target objects.
    *
    * @returns Object The generic menu label.
    */
   var buildGenericMenu = function(targets) {
      var labelText, iconClass;
      if (targets && targets.length > 0) {

         var actionObjectsStr = '';
         if (targets.length > 1) {
            actionObjectsStr = i18nService.getString(
                  'Common', 'contextMenu.title.nObjects', targets.length);
         } else if (targets.length === 1) {
            var target = targets[0];
            actionObjectsStr = target.name ?
                  target.name :
                  i18nService.getString('Common', 'contextMenu.title.oneObject');
            if (target.primaryIconId) {
               iconClass = target.primaryIconId;
            }
         }

         labelText =
               i18nService.getString('Common', 'contextMenu.title', actionObjectsStr);
      }
      return buildHeaderItem(labelText, iconClass);
   };

   /**
    * Builds and returns menu header item given
    * label and iconClass.
    *
    * @param label Header item label.
    *
    * @param iconClass Header item iconClass (optional)
    */
   function buildHeaderItem(label, iconClass) {
      var item = {
         id: 'header_id',
         label: label,
         iconClass: iconClass
      };
      return item;
   }

   /**
    * Creates and returns a menu item containing
    * text like "No actions available".
    *
    * @returns Object The new "no actions" menu item.
    */
   function buildEmptyItem() {
      var noActionsStr = i18nService.getString(
            'Common', 'contextMenu.noActionsItem');
      var item = {
         id: generateMenuItemId(),
         label: noActionsStr,
         enabled: false
      };
      return item;
   }

   var generateMenuItemId = function () {
      return (lastMenuItemId++).toString();
   };

   /**
    * Creates and returns a disabled menu item containing
    * text like "Loading..".
    *
    * @returns Object The new "loading" menu item.
    */
   function buildLoadingItem() {
      var noActionsStr = i18nService.getString(
            'Common', 'contextMenu.loadingItem');
      var item = {
         id: generateMenuItemId(),
         label: noActionsStr,
         enabled: false
      };
      return item;
   }

   /**
    * Gets menu of the specified type and for specified target objects.
    *
    * @param type {string} Identifiers menu types eg. 'vise.menus.user',
    *  'vise.menus.help' or 'vise.menus.context,vise.menus.context.solutionMenus'
    *
    * @param targetIds {string[]} Identifiers for server objects to evaluate and
    * return actions menu for.
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the menu.
    */
   function getMenu(type, targetIds) {
      var url = 'actionsService/menu/';
      var params = {
         menuType: type
      };
      return getData(url, params, {}, targetIds, 'post');
   }

   function getEvaluatedMenus(menuIds, targetIds) {
      var url = 'actionsService/menus/' + menuIds.join(',');
      return getData(url, {}, {}, targetIds, 'post');
   }

   /**
    * Gets global toolbar actions of the specified list view.
    *
    * @param listViewId {string} Extension id of the object list view.
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the toolbar actions.
    */
   function getToolbarActions(listViewId) {
      var url = 'actionsService/toolbar/';
      var params = {
         listViewId: listViewId
      };
      return getData(url, params);
   }

   //======================= Public Functions ==========================
   /**
    * Gets the specified action for the specified target objects.
    *
    * @param actionId {string} The unique identifier of an action registered
    * with the action service to fetch.
    *
    * @param targetIds {string[]} Identifiers for server objects to evaluate the
    * requested action against. It could be a single value.
    *
    * @param skipErrorInterceptor {boolean} (optional) if true sends the request with
    * skipErrorInterceptor property which determines if a notification message is shown
    * when an error occurs in the actions service backend
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the
    * evaluated action.
    */
   var getAction = function (actionId, targetIds, skipErrorInterceptor) {
      skipErrorInterceptor = (skipErrorInterceptor ? skipErrorInterceptor : false);
      // TODO mcritch: implement ability to send large array of targets with request.
      var url = 'actionsService/actions/evaluations/' + actionId;
      var params = {};
      if (targetIds && targetIds.length !== 0) {
         params.targetUids = targetIds;
      }
      var additionalParams = {};
      additionalParams.skipErrorInterceptor = skipErrorInterceptor;

      return getData(url, params, additionalParams);
   };

   /**
    * Gets actions with evaluations for the specified target objects.
    *showActionsMenuIds {string[]} Identifiers of actions registered with
    * the action service to fetch.
    *
    * @param targetIds {string[], string} Identifier/Identifiers for server objects to evaluate and
    * return actions for.
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the
    * evaluated actions.
    */
   var getActions = function (targetIds, actionIds, skipActionFilteringStage, params) {
      params = params === undefined  || params === null ? {} : params;
      if (!targetIds) {
         targetIds = [];
      }
      if (_.isString(targetIds)) {
         targetIds = [targetIds];
      }
      if (actionIds && actionIds.length !== 0) {
         params.actionUids =  actionIds;
      }
      if (skipActionFilteringStage) {
         params.skipActionFilteringStage = true;
      }
      return getData('actionsService/actions/evaluations', params, {}, targetIds, 'post');
   };

   /**
    * Gets data from a REST endpoint.
    *
    * @param url {string} Endpoint URL.
    *
    * @param params {object} Request parameters.
    *
    * @param additionalParams {object} Additional parameters that have to be passed to
    * the request
    *
    * @returns {HttpPromise} An angularjs HttpPromise to return the
    * requested data.
    *
    */
   var getData = function(url, params, additionalParams, data, method) {
      additionalParams = additionalParams ? additionalParams : {};
      method = method || 'get';
      return $http({
         method: method,
         url: url,
         params: params,
         data: data,
         skipLoadingNotification: true,
         skipErrorInterceptor: additionalParams.skipErrorInterceptor ? true : false
      }).then(function(resp) {
         // Extract the data from the $http response before resolving
         return resp.data;
      });
   };

   /**
    * Invokes the action specified in the action evaluation against the
    * available targets in the evaluation, if any.
    *
    * If the given action is not available, it is not invoked.
    *
    * In order to invoke the action, the actionEval should contain an "invoker"
    * property that names a function located in the h5.actions map. That
    * function should accept the actionEval and an array of available targets
    * as parameters.
    *
    * @param actionEval {Object} The evaluated action to invoke.
    * @param context {Object} Additional free-format data, that will be passed
    * to the action invoker.
    */
   var invokeAction = function (actionEval, context) {
      // Could check actionEval.timestamp here to determine whether
      // this eval is too stale.

      // Extract the available targets from the evaluation statuses.
      var targets = extractTargets(actionEval);

      // TODO: smarathe - Check if the analytics is enabled
      // Action, Category, Name/Label, Value
      $analytics.eventTrack(actionEval.action.uid, { category: 'h5.actions.trigger', label: targets });

      var confirmHandler = function() {
         return h5.actions[actionEval.invoker](actionEval, targets, context);
      };
      actionConfirmationService.confirmIfRequired(actionEval, confirmHandler);
   };

   /**
    * Shows a custom menu of the given type that is applicable to the
    * given targetIds.
    *
    * <p>If more than one such custom menu is applicable to the given targets,
    * one is chosen to show arbitrarily.
    * Note that it is an error to introduce non-mutually exclusive menus to
    * the service in this way.</p>
    *
    * <p>If no custom menu exists for the given targets, but applicable actions
    * do exist, a generic menu is constructed from those actions and shown.
    * If no applicable actions exist either, nothing happens.</p>
    *
    * @param $event The click event that was raised to trigger the menu. Used
    * for getting the target element (event.target) on which the click was done
    * for anchoring the menu.
    *
    * @param menuType The type of the menu to show.
    *
    * @param scope The scope from which the function is invoked.
    *
    * @param targets The target objects to show the menu for. (Optional)
    *
    * @param x The left co-ordinate from where the menu should render. (Optional)
    *
    * @param y The top co-ordinate from where the menu should render. (Optional)
    *
    * @param targetElement Specifies the element on which the actions menu should open.
    * (Optional) If this is not specified $event.target is used. If $event is null or undefined,
    * the default element is document body.
    */
   var showActionsMenu = function($event, menuType, scope, targets, x, y, targetElement, focusable) {
      var deferred = $q.defer();
      if (!(targets instanceof Array)) {
         targets = jsUtils.isUndefinedOrNull(targets) ? [] : [targets];
      }

      // New scope object for the vuiActionsMenu two way binding
      var localScope = scope.$new();
      var target = targetElement;
      if (!target && $event) {
         target = $event.target;
      }
      // build Menu Data
      buildMenu(menuType, targets, focusable)
         .then(function(actionsMenu) {
            localScope.actionsMenu = actionsMenu;

            var menuOptions = {
               scope: localScope,
               configObjectName: 'actionsMenu',
               target: target,
               menuContainerId: menuContainerId
            };
            if (!jsUtils.isUndefinedOrNull(x) && !jsUtils.isUndefinedOrNull(y)) {
               menuOptions.coordinates = {
                  x: x,
                  y: y
               };
            }

            vuiActionsMenuService.showMenu(menuOptions);
            setTooltips();
            deferred.resolve(actionsMenu);
         })

         .finally(function() {
            // TODO: smarathe - Check if the analytics is enabled
            // Action, Category, Name/Label, Value
            var targetIds = targets.map(function(currTarget) {
               return currTarget.id;
            });
            $analytics.eventTrack('h5.viewActions', { category: 'h5.actions.view', label: targetIds });
         });

      return deferred.promise;
   };

   var showObjectContextMenu = function($event, scope, targets, x, y, targetElement, focusable) {
      return showActionsMenu($event, objectContextMenuTypes, scope, targets, x, y, targetElement, focusable);
   };


   /**
    * Function to calculate the position of actions menu
    *
    * @param vui_action_menu target to calculate the position
    * @param bodyElement dom element body
    * @param left dom element position
    * @param top dom element position
    */
   var calculateActionsMenuPosition = function (vui_action_menu, bodyElement, left, top) {
      var coordinates_x = Math.min(left, (bodyElement.outerWidth() - vui_action_menu.outerWidth()));

      var applicationMenuContainerElement = getApplicationMenuContainerElement();
      applicationMenuContainerElement.css({left: coordinates_x + "px"});
      applicationMenuContainerElement.css({top: top + "px"});

      configureVirtualMenuScroller(applicationMenuContainerElement, top, vui_action_menu);
   };

   function configureVirtualMenuScroller(menuContainer, menuContainerTop, menuElement) {
      var windowHeight = $(window).height();
      var menuContainerOuterHeight = menuContainer.outerHeight(true);
      if (windowHeight - menuContainerTop < menuContainerOuterHeight) {
         var menuContainerVerticalEdgeThickness =
            menuContainerOuterHeight - menuContainer.height();
         menuContainer.css({
            maxHeight: windowHeight - menuContainerVerticalEdgeThickness - menuContainerTop
         });
         var menuElementVerticalEdgeThickness =
            menuElement.outerHeight(true) - menuElement.height();
         var menuElementMaxHeight = windowHeight - (menuElementVerticalEdgeThickness +
            menuContainerTop + menuContainerVerticalEdgeThickness);
         menuElement.css({
            maxHeight: menuElementMaxHeight
         });
         menuElement.addClass(vuiConstants.actions.VUI_MENU_SCROLLER_CLASS);
      }
   }

   // vuiActionMenu does not support tooltips like the docs say
   function setTooltips() {
      $('.k-menu.k-menu-vertical.k-context-menu span.k-link').each(function (index, menuItem) {
         // Set title attribute only if the contents of the menu item will overflow.
         if (menuItem.offsetWidth < menuItem.scrollWidth) {
            var $menuItem = $(menuItem);
            $menuItem.attr('title', $menuItem.text());
         }
      });
   }

   /**
    * Manager for preparation and invocation of actions.
    *
    * @returns {object} The public functions that can be called on the ActionInvoker.
    */
   function ActionInvoker() {
      var actionEvalsByActionUid = {};
      var pendingActionId = null;

      /**
       * Fetches all specified actions applicable to the specified targets and
       * evaluates their state.
       *
       * @param targets {object} All targets for which the actions are applicable.
       *
       * @param vuiMenuItemsByActionUid {object} All action items mapped to their IDs.
       *
       * @param options {object} Custom options for controlling the action evaluations.
       *
       * @returns {HttpPromise} An angularjs HttpPromise to return the
       * requested data.
       *
       */
      function evaluateActions(targets, vuiMenuItemsByActionUid, skipActionFilteringStage, options) {
         var deferred = $q.defer();
         if (vuiMenuItemsByActionUid === null){
            return deferred.promise;
         }
         var actionIds = Object.keys(vuiMenuItemsByActionUid);
         var targetIds = extractObjectIds(targets);

         if (actionIds.length !== 0) {
            getActions(targetIds, actionIds, skipActionFilteringStage).then(function(actionEvals) {
               if (actionEvals === null || !_.isArray(actionEvals)){
                  return;
               }
               if (targets && targets.length === 1) {
                  var targetName = targets[0]['name'];

                  actionEvals.forEach(function(actionEval) {
                     if (actionEval && actionEval.action &&
                        actionEval.action.confirmationText) {
                        actionEval.action.confirmationText = i18nService.interpolate(
                           actionEval.action.confirmationText, [targetName]);
                     }
                  });
               }
               setActionEvaluations(vuiMenuItemsByActionUid, actionEvals, options);
               $timeout(setTooltips, 0);
               deferred.resolve();
            }, function() {
               log.error('Get Actions call Failed for targets ' + targetIds + ' and actions ' + actionIds);
            });
         }
         return deferred.promise;
      }

      /**
       * Applies the action evaluations to the current list of actions.
       * In the case when a pending action exists (that is, when there are multiple
       * targets) the pending action is invoked.
       *
       * @param vuiMenuItemsByActionUid {object} Menu items mapped by their IDs.
       *
       * @param actionEvals {object} The action evaluations.
       *
       * @param options {object} Custom options for controlling the action evaluations.
       *
       * @returns {HttpPromise} An angularjs HttpPromise to return the
       * requested data.
       *
       */
      function setActionEvaluations(vuiMenuItemsByActionUid, actionEvals, options) {
         // update vuiMenuItemsByActionUid
         actionEvals.forEach(function(actionEval) {
            if (!options || !options.skipSetMenuItemEnabled) {
               vuiMenuItemsByActionUid[actionEval.action.uid].enabled =
                     actionEval.available;
            }
            actionEvalsByActionUid[actionEval.action.uid] = actionEval;
         });
         if (pendingActionId !== null && actionEvalsByActionUid[pendingActionId]) {
            // call action corresponding to the menu item clicked by the user.
            callInvoker(pendingActionId);
            pendingActionId = null;
         }
      }

      /**
       * Invokes the specified action.
       *
       * @param actionId {object} The action to invoke.
       *
       * @param targets {object} All targets for which the action is applicable.
       *
       * @param eventInfo {object} Details about the event.
       *
       */
      function callInvoker(actionId, targets, eventInfo) {
         if (targets && targets.length > 1) {
            // in case of multiple targets action's evaluation is done on action click
            var actionIdItems = {};
            actionIdItems[actionId] = {};
            evaluateActions(targets, actionIdItems, true /*skipActionsFilteringStage*/, { skipSetMenuItemEnabled: true }).then(function(){
               tryInvokeAction(actionId);
            });
         } else {
            // in case of single target - actions' evaluation is already done
            tryInvokeAction(actionId);
         }
      }

      /**
       * Checks if the action evaluations are available and invokes action.
       * @param actionId
       *    Id of the action to be evaluated.
       */
      function tryInvokeAction(actionId) {
         // Check if Action Evals have been fetched
         if (!actionEvalsByActionUid[actionId]) {
            pendingActionId = actionId;
            return;
         }

         var actionEval = actionEvalsByActionUid[actionId];
         invokeAction(actionEval);
      }

      function getActionEvalsByActionUid() {
         return actionEvalsByActionUid;
      }

      return {
         evaluateActions: evaluateActions,
         setActionEvaluations: setActionEvaluations,
         callInvoker: callInvoker,
         getActionEvalsByActionUid: getActionEvalsByActionUid
      };
   }

   function buildMenu(menuType, targets, focusable) {
      var targetIds = extractObjectIds(targets);
      // Map of the items in the menu. Used to enable/disable actions when
      // the evaluations arrive.
      var vuiMenuItemsByActionUid = {};
      // Map of the items in the menu that come from plugins.
      // Used to request plugin actions separately and later append them
      // to their corresponding parent menu item.
      var vuiPluginMenuItemsByActionUid = {};

      var actionInvoker = new ActionInvoker();
      var deferred = $q.defer();
      getMenu(menuType, targetIds).then(function(menuItem) {
         var vuiMenu;

         if (menuItem.label) {
            vuiMenu = buildHeaderItem(menuItem.label, menuItem.icon);
         } else {
            // Build Generic menu label
            vuiMenu = buildGenericMenu(targets);
         }

         if (!jsUtils.isEmpty(menuItem.children)) {
            vuiMenu.items = menuItem.children.map(function(menuItem) {
               if (menuItem.extendedPoint === solutionMenusExtensionPoint) {
                  return buildMenuItem(menuItem, vuiPluginMenuItemsByActionUid,
                        targets, actionInvoker.callInvoker);
               } else {
                  return buildMenuItem(menuItem, vuiMenuItemsByActionUid,
                        targets, actionInvoker.callInvoker);
               }
            });
         } else {
            vuiMenu.items = [buildEmptyItem()];
         }

         vuiMenu.focusable = focusable;

         // Evaluate actions only if there is no target (Help or User menu) or
         // it is a single target. For multiple targets all the relevant actions are
         // enabled by default and they are evaluated on action (menu item) click
         if (!targets || (targets.length <= 1)) {
            actionInvoker.evaluateActions(targets, vuiMenuItemsByActionUid,
                  true /*skipActionsFilteringStage since calling 2nd time*/);
         }

         if (!_.isEmpty(vuiPluginMenuItemsByActionUid)) {
            _.each(vuiPluginMenuItemsByActionUid, function (menuItem) {
               menuItem.items.push(buildLoadingItem());
            });
            getEvaluatedMenus(_.keys(vuiPluginMenuItemsByActionUid), targetIds)
                  .then(function (evaluatedMenuData) {
                     addPluginMenus(vuiPluginMenuItemsByActionUid, actionInvoker,
                           targets, evaluatedMenuData);
                  });
         }

         // Resolve the promise in the next frame to make the browser first to dispatch
         // http request for action evaluations and then render the menu
         $timeout(function() {
            deferred.resolve(vuiMenu);
         }, 0);
      }).catch(function() {
         log.error('Get menu call Failed');
         var vuiMenu = buildGenericMenu(targets);
         vuiMenu.items = [buildEmptyItem()];
         deferred.resolve(vuiMenu);
      });
      return deferred.promise;
   }

   /**
    * Appends plugin menu actions to their corresponding menu item.
    * @param vuiPluginMenuItemsByActionUid {object} Plugin menu items mapped to by IDs.
    * @param actionInvoker The action invoker of the menu instance.
    * @param targets Object[] The target objects.
    * @param evaluatedMenuData An object containing the plugin menus with actions
    *    and the evaluations of those actions.
    */
   function addPluginMenus(vuiPluginMenuItemsByActionUid, actionInvoker, targets, evaluatedMenuData) {
      var actionEvalsByActionUid = {};
      if (!targets || targets.length === 1) {
         _.each(evaluatedMenuData.evaluations, function (actionEval) {
            actionEvalsByActionUid[actionEval.action.uid] = actionEval;
         });
      }

      // Remove "Loading.." placeholder items.
      _.each(vuiPluginMenuItemsByActionUid, function (menuItem) {
         menuItem.items = [];
      });

      _.each(evaluatedMenuData.menus, function (menu) {
         var menuItem = vuiPluginMenuItemsByActionUid[menu.id];
         menuItem.items = menu.children.reduce(function(siblings, item) {
            var evaluation = actionEvalsByActionUid[item.id];
            if (targets) {
               var menuItem = buildMenuItem(item,
                     vuiPluginMenuItemsByActionUid, targets,
                     actionInvoker.callInvoker);
               siblings.push(menuItem);
            }
            return siblings;
         }, []);
      });

      // Insert "No actions available" items into menus that are still empty.
      _.each(vuiPluginMenuItemsByActionUid, function (menuItem) {
         if (menuItem.items && menuItem.items.length === 0) {
            menuItem.items.push(buildEmptyItem());
         }
      });

      if (evaluatedMenuData.evaluations) {
         actionInvoker.setActionEvaluations(vuiPluginMenuItemsByActionUid,
               evaluatedMenuData.evaluations, { skipSetMenuItemEnabled: false });
      }
   }

   /**
    * Prepares all actions for list view toolbar.
    * @param listViewId {String} The extension ID of a list view.
    */
    function buildActionsToolbar(listViewId){
       var deferred = $q.defer();
       var itemsByActionUid = {};
       var actionInvoker = new ActionInvoker();
       getToolbarActions(listViewId).then(function(items) {
          if (items === null){
             $timeout(function() {
                deferred.resolve([]);
             }, 0);
             return;
          }
          $.each(items, function (index, item) {
             itemsByActionUid[item.id] = {
                id: item.id,
                label: item.label,
                iconClass: item.icon,
                enabled: true,
                onClick : function(eventInfo) {
                  actionInvoker.callInvoker(item.id, null, eventInfo);
               }
             };
          });
          actionInvoker.evaluateActions(null, itemsByActionUid);
          $timeout(function() {
             deferred.resolve(itemsByActionUid);
          }, 0);
       }).catch(function() {
          log.error('Build actions toolbar failed for list view: ' + listViewId);
          $timeout(function() {
             deferred.resolve([]);
          }, 0);
       });
       return deferred.promise;
    }

   /**
    * If the confirmationText for single object needs to be formatted,
    * the object name is retrieved and the text is changed.
    * Then invokeAction is invoked
    * @param actionEval {Object} The evaluated action to invoke.
    * @param context {Object} Additional free-format data, that will be passed
    * to the action invoker.
    */
   function invokeActionWithConfirmation(actionEval, context, targets) {
      if (!actionEval) {
         return;
      }
      if (!targets) {
         targets = extractTargets(actionEval);
      }
      // if there is only one target and there is a defined message in
      // plugin xml, we need to take the name of the target and change the
      // confirmationText to contain that name
      if (shouldFormatConfirmationText(actionEval, targets)) {
         dataService.getProperties(targets[0], ['name'])
               .then(function(properties) {
                  actionEval.action.confirmationText = i18nService.interpolate(
                        actionEval.action.confirmationText, [properties.name]);
                  invokeAction(actionEval, context);
               });
      } else {
         if(targets.length > 1
               || (actionEval.available === true && targets.length === 1)) {
            invokeAction(actionEval, context);
         }
      }
   }

   function extractTargets(actionEval) {
      var index = 0;
      var targets = [];
      if(actionEval && actionEval.evaluationStatuses) {
         for (var targetId in actionEval.evaluationStatuses) {
            if (actionEval.evaluationStatuses[targetId].available) {
               targets[index++] = targetId;
            }
         }
      }
      return targets;
   }

   function shouldFormatConfirmationText(actionEval, targets){
      return actionEval.available === true
            && targets.length === 1
            && actionEval.action
            && actionEval.action.confirmationText
            && actionEval.action.confirmationText.includes('{0}');
   }

   function getApplicationMenuContainerElement(){
      return $("#" + menuContainerId);
   }


   return {
      getAction : getAction,
      getActions : getActions,
      getApplicationMenuContainerElement: getApplicationMenuContainerElement,
      getData: getData,
      invokeAction : invokeAction,
      showActionsMenu : showActionsMenu,
      showObjectContextMenu: showObjectContextMenu,
      buildActionsToolbar : buildActionsToolbar,
      invokeActionWithConfirmation : invokeActionWithConfirmation,
      calculateActionsMenuPosition : calculateActionsMenuPosition
   };

}]);

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service responsible for showing menus and invoking actions related to alarm issues.
 */
angular.module('com.vmware.platform.ui').factory('alarmIssueActionService',
    ['$http', '$window', 'logService', 'i18nService', 'vuiActionsMenuService',
        'mutationService', 'authorizationService', 'defaultUriSchemeUtil', '$rootScope',
        'vuiConstants', '$q', 'jsUtils', '$timeout', '$analytics',
        function($http, $window, logService, i18nService, vuiActionsMenuService,
                 mutationService, authorizationService, defaultUriSchemeUtil, $rootScope,
                 vuiConstants, $q, jsUtils, $timeout, $analytics) {

    'use strict';
    var log = logService('alarmIssueActionService');

    var ACKNOWLEDGE_ACTION_UID = 'vsphere.opsmgmt.alarms.acknowledge';
    var RESET_TO_GREEN_ACTION_UID = 'vsphere.opsmgmt.alarms.reset';
    var ACTIONS_UIDS = [
        ACKNOWLEDGE_ACTION_UID,
        RESET_TO_GREEN_ACTION_UID
    ];

    var ACTION_UID_TO_DESCRIPTOR = {};
    ACTION_UID_TO_DESCRIPTOR[ACKNOWLEDGE_ACTION_UID] = {
        actionUid: ACKNOWLEDGE_ACTION_UID,
        iconClass: 'vx-icon-acknowledged',
        label: i18nService.getString('CommonModuleUi', 'alarmAction.acknowledge.label'),
        requiredPrivileges: [ 'Alarm.Acknowledge' ],
        availabilityPreCheck: function(alarmInfo, alarmState) {
            return alarmState.acknowledged === false;
        }
    };
    ACTION_UID_TO_DESCRIPTOR[RESET_TO_GREEN_ACTION_UID] = {
        actionUid: RESET_TO_GREEN_ACTION_UID,
        iconClass: 'vx-icon-reset_green',
        label: i18nService.getString('CommonModuleUi', 'alarmAction.reset.label'),
        requiredPrivileges: [ 'Alarm.SetStatus' ],
        availabilityPreCheck: function(alarmInfo, alarmState) {
            return alarmInfo.expression !== null;
        }
    };

    /**
     * Shows an actions menu for an AlarmIssue similar to the one in actionsService.
     *
     * @param event The click event that was raised to trigger the menu. Used
     * for getting the target element (event.target) on which the click was done
     * for anchoring the menu.
     *
     * @param scope The scope from which the function is invoked.
     *
     * @param alarmInfo A com.vmware.vim.binding.vim.alarm.AlarmInfo object describing an alarm.
     *
     * @param alarmState A com.vmware.vim.binding.vim.alarm.AlarmState object describing an alarm state.
     *
     * @param x The left co-ordinate from where the menu should render. (Optional)
     *
     * @param y The top co-ordinate from where the menu should render. (Optional)
     *
     * @param targetElement Specifies the element on which the actions menu should open.
     * If this is not specified event.target is used. If event is null or undefined,
     * the default element is document body. (Optional)
     */
    function showActionsMenu(event, scope, alarmInfo, alarmState, x, y, targetElement) {
        // New scope object for the vuiActionsMenu two way binding
        var localScope = scope.$new();
        localScope.menuDescriptor = buildMenuDescriptor(alarmInfo, alarmState);
        var target = targetElement;
        if (!target && event) {
            target = event.target;
        }

        var menuOptions = {
            scope: localScope,
            configObjectName: 'menuDescriptor',
            target: target,
            menuContainerId: 'applicationMenuContainer'
        };
        if (!jsUtils.isUndefinedOrNull(x) && !jsUtils.isUndefinedOrNull(y)) {
            menuOptions.coordinates = {
                x: x,
                y: y
            };
        }

        vuiActionsMenuService.showMenu(menuOptions);
        setMenuTooltips();
        $analytics.eventTrack('h5.viewActions', { category: 'h5.actions.view', label: alarmState.key });
    }

    /**
     * Builds an AlarmIssue actions menu descriptor.
     *
     * @param alarmInfo A com.vmware.vim.binding.vim.alarm.AlarmInfo object describing an alarm
     *
     * @param alarmState A com.vmware.vim.binding.vim.alarm.AlarmState object describing an alarm state .
     *
     * @return {object} representing an AlarmIssue actions menu descriptor.
     */
    function buildMenuDescriptor(alarmInfo, alarmState) {
        var menuItemsDescriptors = buildAlarmActions(alarmInfo, alarmState);

        var actionsText = i18nService.getString('Common', 'contextMenu.title.actions');
        var menuHeaderIcon = getAlarmOverallStatusIconClass(alarmState);
        var menuHeaderText = actionsText + ' - ' + alarmInfo.name;

        var menuDescriptor = {
            label: menuHeaderText,
            iconClass: menuHeaderIcon,
            items: menuItemsDescriptors
        };

        return menuDescriptor;
    }

    /**
     * Builds a list of alarm actions (acknowledge, reset to green...) including their label and availability
     *
     * @param alarmInfo A com.vmware.vim.binding.vim.alarm.AlarmInfo object describing an alarm
     *
     * @param alarmState A com.vmware.vim.binding.vim.alarm.AlarmState object describing an alarm state .
     *
     * @return {object} representing an AlarmIssue actions menu descriptor.
     */
    function buildAlarmActions(alarmInfo, alarmState){
        var actionsMenuContext = {
            actionUidToMenuItemDescriptor: { },
            actionUidToEvaluatedAvailability: { },
            pendingAction: null
        };

        var menuItemsDescriptors = [];
        _.forEach(ACTIONS_UIDS, function(actionUid) {
            var actionDescriptor = ACTION_UID_TO_DESCRIPTOR[actionUid];

            var menuItemDescriptor = buildMenuItemDescriptor(
               actionDescriptor, alarmInfo, alarmState, actionsMenuContext
            );
            menuItemsDescriptors.push(menuItemDescriptor);
            actionsMenuContext.actionUidToMenuItemDescriptor[actionUid] = menuItemDescriptor;
        });

        evaluateActionsAvailability(alarmInfo, alarmState, actionsMenuContext);

        return menuItemsDescriptors;
    }

    function buildMenuItemDescriptor(actionDescriptor, alarmInfo, alarmState, actionsMenuContext) {
        return {
            enabled: true,
            iconClass: actionDescriptor.iconClass,
            id: actionDescriptor.actionUid,
            label: actionDescriptor.label,
            onClick: function(eventInfo) {
                return invokeAction(alarmState, actionsMenuContext, actionDescriptor.actionUid);
            }
        };
    }

    // vuiActionMenu does not support tooltips like the docs say
    function setMenuTooltips() {
        $('.k-menu.k-menu-vertical.k-context-menu span.k-link').each(function (index, menuItem) {
            // Set title attribute only if the contents of the menu item will overflow.
            if (menuItem.offsetWidth < menuItem.scrollWidth) {
                var $menuItem = $(menuItem);
                $menuItem.attr('title', $menuItem.text());
            }
        });
    }

    /**
     * Given a com.vmware.vim.binding.vim.alarm.AlarmState object describing the state of an alarm
     * returns the CSS icon class to use for that alarm.
     *
     * @param alarmState object describing the state of the alarm
     * @returns {string} the name of icon class to use
     */
    function getAlarmOverallStatusIconClass(alarmState) {
        switch (alarmState.overallStatus) {
            case 'green':
                return 'vsphere-icon-status-ok';
            case 'yellow':
                return 'vsphere-icon-status-warning';
            case 'red':
                return 'vsphere-icon-status-error';
            case 'gray':
                return 'vui-icon-datagrid-status-unknown';
            default :
                return 'vui-icon-datagrid-status-unknown';
        }
    }

    function evaluateActionsAvailability(alarmInfo, alarmState, actionsMenuContext) {
        var privilegesToCheck = [];

        _.forEach(ACTIONS_UIDS, function(actionUid) {
            var actionDescriptor = ACTION_UID_TO_DESCRIPTOR[actionUid];

            var isActionAvailable = true;
            if (typeof actionDescriptor.availabilityPreCheck === 'function') {
                isActionAvailable = actionDescriptor.availabilityPreCheck(alarmInfo, alarmState);
            }

            if (isActionAvailable) {
                if (_.isEmpty(actionDescriptor.requiredPrivileges)) {
                    actionsMenuContext.actionUidToEvaluatedAvailability[actionUid] = true;
                    actionsMenuContext.actionUidToMenuItemDescriptor[actionUid].enabled = true;
                } else {
                    Array.prototype.push.apply(privilegesToCheck, actionDescriptor.requiredPrivileges);
                }
            } else {
                actionsMenuContext.actionUidToEvaluatedAvailability[actionUid] = false;
                actionsMenuContext.actionUidToMenuItemDescriptor[actionUid].enabled = false;
            }
        });

        privilegesToCheck = _.unique(privilegesToCheck, false);
        if (_.isEmpty(privilegesToCheck)) {
            return;
        }

        authorizationService.checkPrivileges(
            defaultUriSchemeUtil.getVsphereObjectId(alarmState.entity), privilegesToCheck
        ).then(function(privilegesStatuses) {
            var privilegeToStatus = _.object(privilegesToCheck, privilegesStatuses);
            var actionDescriptor;

            for (var actionUid in ACTION_UID_TO_DESCRIPTOR) {
                if (!ACTION_UID_TO_DESCRIPTOR.hasOwnProperty(actionUid)) {
                    continue;
                }

                actionDescriptor = ACTION_UID_TO_DESCRIPTOR[actionUid];
                if (typeof actionsMenuContext.actionUidToEvaluatedAvailability[actionUid] === 'boolean') {
                    continue;
                }

                /*jshint loopfunc: true */
                var actionAvailable = _.every(actionDescriptor.requiredPrivileges, function(requiredPrivilege) {
                    return privilegeToStatus[requiredPrivilege];
                });
                /*jshint loopfunc: false */

                actionsMenuContext.actionUidToEvaluatedAvailability[actionUid] = actionAvailable;
                actionsMenuContext.actionUidToMenuItemDescriptor[actionUid].enabled = actionAvailable;
            }

            if (actionsMenuContext.pendingAction !== null) {
                actionDescriptor = ACTION_UID_TO_DESCRIPTOR[actionsMenuContext.pendingAction.uid];
                var deferred = actionsMenuContext.pendingAction.deferred;
                invokeAction(alarmState, actionsMenuContext, actionDescriptor.actionUid).then(function () {
                    deferred.resolve();
                });
            }
        });
    }

    function invokeAction(alarmState, actionsMenuContext, actionUid) {
        actionsMenuContext.pendingAction = null;

        if (typeof actionsMenuContext.actionUidToEvaluatedAvailability[actionUid] === 'undefined') {
            var deferred = $q.defer();
            actionsMenuContext.pendingAction = {uid: actionUid, deferred: deferred};
            return deferred.promise;
        }

        if (actionsMenuContext.actionUidToEvaluatedAvailability[actionUid] === false) {
            showActionNotAvailableDialog(actionUid);
            return $q.reject();
        }

        return h5.actions[actionUid](null, null, alarmAndEntityContext(alarmState));
    }

    function alarmAndEntityContext(alarmState){
        return {
            alarm: defaultUriSchemeUtil.extractManagedObjectReference(alarmState.alarm),
            entity: alarmState.entity,
            entityId: defaultUriSchemeUtil.getVsphereObjectId(alarmState.entity)
        };
    }

    function showActionNotAvailableDialog(actionUid) {
        //TODO amarinov: implement action not available dialog as in actionsService
        //alert('Action \'' + ACTION_UID_TO_DESCRIPTOR[actionUid].label + '\' is not available!');
    }

    return {
        showActionsMenu: showActionsMenu,
        buildAlarmActions: buildAlarmActions
    };
}]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function () {
   'use strict';
   /**
    * Service to retrieve triggered alarms.
    */
   angular.module('com.vmware.platform.ui').factory('alarmService', ['$http', '$q', 'i18nService', 'dataService', 'defaultUriSchemeUtil', 'logService',
   function ($http, $q, i18nService, dataService, defaultUriSchemeUtil, logService) {
      // Endpoint to get all alarms from
      var ALARMS_ENDPOINT = 'alarms';
      // Endpoint to get alarms per selected object from
      var ENTITY_ALARMS_ENDPOINT = 'entityAlarms';

      var log = logService('alarmService');

      return {
         getAlarms: getAlarms,
         getStatusIconClass: getStatusIconClass,
         getAcknowledgedStatusIconClass: getAcknowledgedStatusIconClass,
         getSeverity: getSeverity,
         getAcknowledgedStatus: getAcknowledgedStatus
      };

      /**
       * Retrieve triggered alarms.
       *
       * @param count
       *    Number of alarms to return.
       */
      function getAlarms(objectId, count) {
         var alarmsEndpoint = (!!objectId) ? ENTITY_ALARMS_ENDPOINT : ALARMS_ENDPOINT;

         var promise = $http({
            method: 'GET',
            url: alarmsEndpoint,
            params: {
               objectId: objectId,
               count: count
            }
         }).then(function (response) {
            if (!response) {
               var reason = 'undefined response to ' + alarmsEndpoint;
               log.error(reason);
               return $q.reject(reason);
            }
            return response.data;
         });
         return promise;
      }

      /**
       * Given the status, returns the name of iconClass to use
       *
       * @param status
       *    the given status
       * @returns {string}
       *    the name of iconClass to use
       */
      function getStatusIconClass(status) {
         var iconClass;
         switch(status) {
            case 'green':
               iconClass = 'vsphere-icon-status-ok';
               break;
            case 'yellow':
               iconClass = 'vsphere-icon-status-warning';
               break;
            case 'red':
               iconClass = 'vsphere-icon-status-error';
               break;
            default :
               iconClass = 'vui-icon-datagrid-status-unknown';
         }

         return iconClass;
      }

      /**
       * Given the alarm acknowledged status, returns the name of iconClass to use
       *
       * @param isAcknowledged
       *    the given status
       * @returns {string}
       *    the name of iconClass to use
       */
      function getAcknowledgedStatusIconClass(isAcknowledged) {
         return isAcknowledged ? 'vx-icon-acknowledgedAlarm' : '';
      }

      /**
       * Given the status, returns a severity level
       *
       * @param status
       *    the given status
       * @returns {string}
       *    the name severity level for the given status
       */
      function getSeverity(status) {
         var severity;
         switch (status) {
            case 'red':
               severity = i18nService.getString('Common',
                     'alarmsView.tableContentText.severity.critical');
               break;
            case 'yellow':
               severity = i18nService.getString('Common',
                     'alarmsView.tableContentText.severity.warning');
               break;
            default:
            case 'green':
               severity = i18nService.getString('Common',
                     'alarmsView.tableContentText.severity.green');
               break;
         }

         return severity;
      }

      /**
       * Parse the "acknowledged" and "acknowledgedByUser" fields to determine the acknowledged Status of an alarm
       *
       * @param alarmState
       *    the alarmState object describing an alarm
       * @returns {string}
       *    the acknowledged status of an alarm
       */
      function getAcknowledgedStatus(alarmState) {
         var acknowledgedStatus = alarmState.acknowledged ?
            i18nService.getString('AlarmsUi', 'AlarmDetailsView.acknowledged', alarmState.acknowledgedByUser) :
            i18nService.getString('AlarmsUi', 'AlarmDetailsView.new');

         return acknowledgedStatus;
      }
   }]);

})();

/* Copyright 2015-2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 */
angular.module('com.vmware.platform.ui')
.factory('alertService',['$rootScope', '$compile', 'i18nService',
   function($rootScope, $compile, i18nService) {
      'use strict';

      var compiledAlertDialog;
      var scope;

      /**
       * Alert close reasons.
       *
       * Passed to the `closeHandler` callback in the `alertService.error` function.
       *
       * @property REJECTED
       *    Passed when the alert is closed by pressing escape.
       *
       * @property CONFIRMED
       *    Passed when the alert is closed by clicking the OK button.
       */
      var closeReasons = Object.freeze({
         REJECTED: 0,
         CONFIRMED: 1
      });

      /**
       * Show Alert.
       *
       * @param {string} alertOptions
       *    see vxAlert.
       */
      function showAlert(alertOptions) {
         scope = $rootScope.$new();
         scope.alertOptions = alertOptions;
         var alertDialog = angular.element('<div id="alert-popup" '
            + 'class="action-confirmation" '
            + 'vx-alert="alertOptions"></div>');

         compiledAlertDialog = $compile(alertDialog)(scope);
         angular.element("#main-app-div").append(compiledAlertDialog);
      }

      /**
       * Show Alert with the desired title and text
       *
       * @param {string} title
       *    Alert title.
       *
       * @param {string} text
       *    Alert message.
       *
       * @param {callback} closeHandler (optional)
       *    Invoked when the Alert is closed.
       *
       *    Format:
       *       function (reason) { ... }
       *
       *    Where `reason` is one of the close reasons above.
       */
      function error(title, text, closeHandler) {
         function closeWithReason(reason) {
            closeConfirmationDialog();
            if (_.isFunction(closeHandler)) {
               closeHandler(reason);
            }
         }

         var alertOptions = {
            title: title,
            text: text,
            icon: 'vui-icon32-error',
            visible: true,
            confirmOptions: {
               label: i18nService.getString('Common', 'alert.ok'),
               onClick: function () {
                  closeWithReason(closeReasons.CONFIRMED);
               }
            },
            rejectOptions: {
               visible: false,
               onClick: function() {
                  closeWithReason(closeReasons.REJECTED);
               }
            }
         };
         showAlert(alertOptions);
      }
      /**
       * Show warning Alert with OK and Cancel buttons.
       *
       * @param {string} title
       *    Alert title.
       *
       * @param {string} text
       *    Alert message.
       *
       * @param {callback} okHandler
       *    Invoked when the Alert is closed with OK.
       *
       * @param {callback} cancelHandler (optional)
       *    Invoked when the Alert is closed with Cancel.
       */
      function okCancel(title, text, okHandler, cancelHandler) {
         var alertOptions = {
            title: title,
            text: text,
            icon: 'icon-warning-32',
            visible: true,
            confirmOptions: {
               label: i18nService.getString('Common', 'alert.ok'),
               visible: true,
               disabled: false,
               onClick: function () {
                  closeConfirmationDialog();
                  okHandler();
               }
            },
            rejectOptions: {
               label: i18nService.getString('Common', 'alert.cancel'),
               visible: true,
               disabled: false,
               focused: true,
               onClick: function () {
                  closeConfirmationDialog();
                  cancelHandler();
               }
            }
         };
         showAlert(alertOptions);
      }

      function closeConfirmationDialog() {
         // Use evalAsync because when trying to remove the DOM element
         // `$apply already in progress` error occurs after which the next popup show
         // doesn't interpolate it's angular expressions immediately.
         $rootScope.$evalAsync(function() {
            scope.$destroy();
            compiledAlertDialog.remove();
         });
      }

      return {
         error: error,
         okCancel: okCancel,
         closeReasons: closeReasons
      };
   }]);

var platform;
(function (platform) {
    /***
     * The class wraps the ng-next-app/platform/services/authorization/authorization.service.proxy
     */
    var AuthorizationServiceWrapper = (function () {
        function AuthorizationServiceWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(AuthorizationServiceWrapper.prototype, "ng2AuthorizationService", {
            get: function () {
                // Injecting authorization.proxy.service bridged from ng-next-app.
                // Using regular injection within .service('string',[...]) does not work,
                // due to race condition:
                // Downgraded NG2 modules are registered AFTER .service(..) injections are resolved
                // This way we're postponing injection till first call
                if (!this._ng2AuthorizationService) {
                    this._ng2AuthorizationService = this.$injector.get("vcAuthorizationService");
                }
                return this._ng2AuthorizationService;
            },
            enumerable: true,
            configurable: true
        });
        AuthorizationServiceWrapper.prototype.checkPrivilege = function (objectId, privilege) {
            return this.ng2AuthorizationService.checkPrivilege(objectId, privilege);
        };
        AuthorizationServiceWrapper.prototype.checkPrivileges = function (objectId, privileges) {
            return this.ng2AuthorizationService.checkPrivileges(objectId, privileges);
        };
        AuthorizationServiceWrapper.prototype.checkPrivilegesForMultipleObjects = function (objectIds, privileges) {
            return this.ng2AuthorizationService.checkPrivilegesForMultipleObjects(objectIds, privileges);
        };
        AuthorizationServiceWrapper.prototype.checkGrantedPrivilege = function (objectId, privilege) {
            return this.ng2AuthorizationService.checkGrantedPrivilege(objectId, privilege);
        };
        AuthorizationServiceWrapper.prototype.checkGrantedPrivileges = function (objectId, privileges) {
            return this.ng2AuthorizationService.checkGrantedPrivileges(objectId, privileges);
        };
        AuthorizationServiceWrapper.prototype.checkGrantedPrivilegesForMultipleObjects = function (objectIds, privileges) {
            return this.ng2AuthorizationService.checkGrantedPrivilegesForMultipleObjects(objectIds, privileges);
        };
        AuthorizationServiceWrapper.$inject = ["$injector"];
        return AuthorizationServiceWrapper;
    }());
    platform.AuthorizationServiceWrapper = AuthorizationServiceWrapper;
    angular.module("com.vmware.platform.ui")
        .service("authorizationService", AuthorizationServiceWrapper);
})(platform || (platform = {}));



/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    var BrowserLanguageServiceWrapper = (function () {
        function BrowserLanguageServiceWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(BrowserLanguageServiceWrapper.prototype, "vcBrowserLanguageService", {
            get: function () {
                if (!this._vcBrowserLanguageService) {
                    this._vcBrowserLanguageService = this.$injector.get('vcBrowserLanguageService');
                }
                return this._vcBrowserLanguageService;
            },
            enumerable: true,
            configurable: true
        });
        BrowserLanguageServiceWrapper.prototype.get = function () {
            return this.vcBrowserLanguageService.get();
        };
        BrowserLanguageServiceWrapper.$inject = ['$injector'];
        return BrowserLanguageServiceWrapper;
    }());
    platform.BrowserLanguageServiceWrapper = BrowserLanguageServiceWrapper;
    /**
     * @ngdoc service
     * @name com.vmware.platform.ui.browserLanguage
     * @module com.vmware.platform.ui
     *
     * @description
     *    Browser language Service.
     */
    angular.module('com.vmware.platform.ui').service('browserLanguage', BrowserLanguageServiceWrapper);
})(platform || (platform = {}));



/* Copyright 2019 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * @ngdoc service
 * @name com.vmware.platform.ui:arraysUtil
 * @module com.vmware.platform.ui
 *
 * @description
 *    The `ChunkExecutor` service provides utility method to execute some task
 *    for each element of the data array, on chunks with given size and timeout between chunks .
 */
var platform;
(function (platform) {
    var ChunkExecutor = (function () {
        ChunkExecutor.$inject = ['$q', '$timeout'];
        function ChunkExecutor($q, $timeout) {
            this.$q = $q;
            this.$timeout = $timeout;
        }
        /**
         * Execute some task for each element of the data array, on chunks
         * with given size and timeout between chunks. Each chunk is executed asynchronously.
         * @param {Function} callback represents task to be executed for each element.
         * @param {any[]} data input containing elements.
         * @param {number} chunckSize size of chunks to separate data and execute asynchronously.
         * @param {number} timeoutBetweenChunks minimum amount of time to wait
         * before starting execute next chunk, after the time previous has started.
         *
         * @returns {Promise<boolean>} promise resolved with true when all chunks
         * executions has finished successfully.
         */
        ChunkExecutor.prototype.executeOnChunks = function (callback, data, chunckSize, timeoutBetweenChunks) {
            var _this = this;
            var deferred = this.$q.defer();
            var chunkExecutions = [];
            // Replace with _.chunk as soon as underscorejs is bumped to 1.9.1
            _.chunk(data, chunckSize).forEach(function (chunk, index) {
                var nextTimeout = index * timeoutBetweenChunks;
                chunkExecutions[index] = _this.scheduleChunkExecution(callback, chunk, nextTimeout);
            });
            this.$q.all(chunkExecutions).then(function () {
                deferred.resolve(true);
            }, function (error) {
                deferred.reject(error);
            });
            return deferred.promise;
        };
        ChunkExecutor.prototype.scheduleChunkExecution = function (callback, chunk, nextTimeout) {
            var _this = this;
            return this.$timeout(function () {
                _this.executeOnChunk(callback, chunk);
            }, nextTimeout);
        };
        ChunkExecutor.prototype.executeOnChunk = function (callback, chunk) {
            chunk.forEach(function (item) {
                callback(item);
            });
        };
        return ChunkExecutor;
    }());
    platform.ChunkExecutor = ChunkExecutor;
    angular.module("com.vmware.platform.ui")
        .service("chunkExecutor", ChunkExecutor);
})(platform || (platform = {}));



/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';

   angular
      .module('com.vmware.platform.ui')
      .constant('clarityConstants', {
         notifications: {
            type: {
               INFO: 'info',
               SUCCESS: 'success',
               WARNING: 'warning',
               ERROR: 'error'
            }
         },
         keys: {
            ENTER: 13,
            ESC: 27,
            TAB: 9
         }
      });
})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';

   /**
    * Provides modal dialogs based on Clarity Design.
    */
   angular
      .module('com.vmware.platform.ui')
      .service('clarityModalService', clarityModalService);

   clarityModalService.$inject = [
      '$document',
      '$rootScope',
      '$compile',
      '$templateRequest',
      'clarityConstants',
      'clarityModalServiceHelper',
      'dataService',
      '$q',
      'focusTraceService',
      'i18nService',
      'vxModalKeyService',
      '$timeout'];


   function clarityModalService($document,
                                $rootScope,
                                $compile,
                                $templateRequest,
                                clarityConstants,
                                clarityModalHelper,
                                dataService,
                                $q,
                                focusTraceService,
                                i18nService,
                                vxModalKeyService,
                                $timeout) {

      return {
         openModal: openModal,
         openConfirmationModal: openConfirmationModal,
         openOkCancelModal: openOkCancelModal,
         openPopUp: openPopUp
      };

      function openModal(actionEval, availableTargets, dialogData, templateUrl) {
         var scope = clarityModalHelper.prepareModalScope(actionEval,
                                                          availableTargets,
                                                          dialogData,
                                                          templateUrl);

         scope.submitModal = function() {
            if (dialogData.submit) {
               if (dialogData.submit()) {
                  scope.destroyModal();
               }
            }
         };
         _openModal(scope, templateUrl);
         // This is done only to support the SDK use case, see HtmlBridgeService closeDialog.
         return scope;
      }

      /**
       * Creates modal dialog with OK and Cancel buttons.
       *
       * @param modalOptions
       *       title - title of the modal dialog.
       *       message - title of the modal dialog.
       *       contentTemplate - the path to template that is the warning content.
       *       submit - primary button callback
       *       onCancel - cancel button callback
       *
       *       OPTIONAL:
       *       subTitle: {
       *          text: subtitle of the modal dialog
       *          objectId: if text is not specified, you can fetch name for objectId
       *       }
       *       icon - icon class
       *       clarityIcon: configuration object for the clarityIcon according to their iconography
       *       saveButtonLabel - Text for primary button, OK is default text
       *       cancelButtonLabel - Text for the secondary button, Cancel is the default text
       *       preserveNewlines - default FALSE
       *       defaultButton - Specifies which button ('submit' or 'close') is highlighted. 'submit' by default.
       *       hideCancelButton - hide the cancel button from the footer, leaving the modal with only one button.
       *       modalClass - Specify wrapper class for the clarity modal
       *       contentTemplateContext - object to be injected into the scope of the contentTemplate.
       */
      function openConfirmationModal (modalOptions) {
         var templateUrl = 'resources/ui/views/dialogs/confirmationModal.html';
         var scope = $rootScope.$new();
         scope.modalOptions = modalOptions;
         scope.modalOptions.modalOpen = true;
         _.defaults(scope.modalOptions, {
            defaultButton: 'submit',
            showXIcon: true
         });

         var confirmationDefered = $q.defer();
         if (scope.modalOptions.submit === undefined) {
            scope.modalOptions.submit = function() {
               confirmationDefered.resolve(true);
            };
         }
         if (scope.modalOptions.onCancel === undefined) {
            scope.modalOptions.onCancel = function() {
               confirmationDefered.resolve(false);
            };
         }

         setSubtitle(modalOptions);

         scope.submitModal = submitModal;
         scope.onCancelModal = scope.modalOptions.onCancel;

         function submitModal() {

            var closePredicate = scope.modalOptions.submit();
            if (closePredicate || closePredicate === undefined) {
               scope.destroyModal();
            }
         }

         decorateScope(scope, modalOptions);
         _openModal(scope, templateUrl);
         return confirmationDefered.promise;
      }

      /**
       * Creates and opens a modal dialog with OK and Cancel buttons.
       *
       * @param modalOptions - Object containing the parameters used by the dialog.
       *
       *  Example:
       *
       * <pre><code>
       *
       *       var modalOptions = {
       *         title: "Modal Dialog Title",
       *         subTitle: {
       *           objectId: 'vmObjectId',
       *         },
       *         contentTemplate: '/featureFolder/someTemplate.html',
       *         onSubmit: function(){
       *           mutationService.apply(...)
       *         },
       *         dialogData: {
       *           vmName: "My VM",
       *           hostDetails: {
       *             hostName: ''
       *           }
       *         }
       *          ....
       *       }
       *
       * </pre></code>
       *
       *    The following properties are available:
       *
       *      Required:
       *
       *       - title - title of the modal dialog.
       *       - contentTemplate - the path to template that is a content of the modal.
       *          The template must be inside &lt;div class="modal-body"&gt;&lt;/div&gt; tag.
       *       - onSubmit - OK button callback
       *       - onCancel - Cancel button callback
       *
       *      Optional:
       *
       *       - dialogData - all additional data which will be used in the content template
       *       - subTitle.text - text string to display as subtitle
       *       - subTitle.objectId - if subTitle.text is not set, objectId can be provided instead. The objectId's name will be fetched and displayed as the subtitle
       *       - size - modal dialog's size. Values are 'sm', <none>, 'lg'.
       *       - alerts - list of {text, type} notifications to be displayed in the dialog.
       *       - defaultButton - Specifies which button ('submit' or 'close') is highlighted.
       *       - modalClass - Specify wrapper class for the clarity modal
       *       - hideSubmitButton - hides the Submit button from the footer, leaving the modal with only one button.
       *       - closeButtonTitle - title of the close button
       *       - submitButtonTitle - title of the submit button
       *       - submitDisabled : flag to enable/disable the Ok/submi button
       */
      function openOkCancelModal(modalOptions) {
         var templateUrl = 'resources/ui/views/dialogs/okCancelModal.html';

         validateModalOptions(modalOptions);
         setSubtitle(modalOptions);

         var scope = $rootScope.$new();
         scope.modalOptions = _.extend(
               modalOptions ? modalOptions : {}, {
               modalOpen: true,
               submitDisabled: _.has(modalOptions, "submitDisabled") ? modalOptions.submitDisabled : false
            });

         scope.onSubmitModal = onSubmitModal;
         scope.onCancelModal = scope.modalOptions.onCancel;

         scope.$watch(function() {
            return scope.modalOptions.alerts;
         }, function(alerts) {
            _.forEach(alerts, function(alert) {
               switch (alert.type) {
                   case clarityConstants.notifications.type.ERROR:
                       alert.className = 'danger';
                       alert.iconShape = 'exclamation-circle';
                       break;

                   case clarityConstants.notifications.type.WARNING:
                       alert.className = 'warning';
                       alert.iconShape = 'exclamation-triangle';
                       break;

                   case clarityConstants.notifications.type.INFO:
                       alert.className = 'info';
                       alert.iconShape = 'info-circle';
                       break;

                   case clarityConstants.notifications.type.SUCCESS:
                       alert.className = 'success';
                       alert.iconShape = 'check-circle';
                       break;

                   default:
                       alert.className = '';
                       alert.iconShape = null;
               }
            });
         });

         decorateScope(scope, modalOptions);
         _openModal(scope, templateUrl);

         function validateModalOptions(modalOptions) {
            if (!hasNonEmptyStringProperty(modalOptions, 'title')) {
               throw Error('modalOptions.title is not defined or is empty.');
            }

            if (!hasNonEmptyStringProperty(modalOptions, 'contentTemplate')) {
               throw Error('modalOptions.contentTemplate is not defined or is empty.');
            }
         }



         function onSubmitModal() {
            //prevent modal resubmission
            if(!scope.isSubmitInProgress) {
               if (typeof scope.modalOptions.onSubmit === 'function') {
                  var onSubmitResult = scope.modalOptions.onSubmit();
                  if (onSubmitResult === true) {
                     scope.destroyModal();
                  } else if (onSubmitResult !== false && onSubmitResult !== undefined) {
                     scope.isSubmitInProgress = true;
                     onSubmitResult.then(function(promiseResult) {
                        if (promiseResult === true) {
                           scope.destroyModal();
                        }
                        scope.isSubmitInProgress = false;
                     }, function() {
                        scope.isSubmitInProgress = false;
                     });
                  }
               }
            }
         }
      }

      /**
       * Creates pop-up dialog with a header.
       *
       * @param scope
       *    The pop-up's scope. It contains modalOptions property as it is described
       *    below.
       *
       *    scope.modalOptions
       *       title - title of the pop-up dialog.
       *       size - pop-up's size. Values are 'sm', <none>, 'lg'.
       *       contentUrl - the path to template that is a content of the pop-up.
       *          The template must be inside &lt;div class="modal-body"&gt;&lt;/div&gt; tag.
       */
      function openPopUp(scope) {
         //  Why does template need alerts, if none of the callers use it?
         var templateUrl = 'resources/ui/views/dialogs/popUpDialog.html';

         scope.modalOptions = angular.extend(
            scope.modalOptions || {}, {
               modalOpen: true
            });

         _openModal(scope, templateUrl);
      }

      function _openModal(scope, templateUrl) {
         var modal;

         scope.closeModal = closeModal;
         scope.destroyModal = destroyModal;
         if (scope.modalOptions.focusTarget === undefined) {
            scope.modalOptions.focusTarget = focusTraceService.popFocusableElement();
         }

         var bodyElement = angular.element($document[0].body);

         $templateRequest(templateUrl).then(function(template) {
            // Attach our handlers before clarity's
            setKeyPressHandler('on');
            $(window).on('resize', resizeModalKendoContent);

            modal = $compile(template)(scope);

            bodyElement.append(modal);

            scope.$watch('modalOptions.modalOpen', function(newValue, oldValue) {
               if (oldValue && !newValue) {
                  scope.$evalAsync("closeModal()");
               }
            });

            scope.$on('$destroy', function() {
               setKeyPressHandler('off');
               $(window).off('resize', resizeModalKendoContent);
            });
         });

         var onKeydownHandler = function ($event) {
            vxModalKeyService.onKeydownHandler($event, closeModal.bind(this));
         };

         function resizeModalKendoContent() {
            kendo.resize(modal, true);
         }

         function destroyModal() {
            setKeyPressHandler('off');
            $(window).off('resize', resizeModalKendoContent);

            // move the focus back to the trigger element if there is any
            if (scope.modalOptions.focusTarget) {
               var focusElement = scope.modalOptions.focusTarget;
               // Without timeout the element is some time focused sometime
               // not
               $timeout(function () {
                  if (focusElement) {
                    focusElement.focus();
                    focusElement = null;
                  }

               },0);
            }
            delete scope['closeModal'];

            scope.$destroy();

            if(modal) {
               modal.remove();
               modal = null;
            }
         }

         function closeModal(result) {
            if (_.isFunction(scope.onCancelModal)) {
               scope.onCancelModal(result);
            }
            destroyModal();
         }

         // Turn the keypress handler on/off
         function setKeyPressHandler(state) {
            if (state === 'on') {
               $document.on('keydown', onKeydownHandler);
               // Shadow Clarity's keyup handler on the body.
               $document.find('body').on('keyup', onKeyUp);
            } else {
               $document.off('keydown', onKeydownHandler);
               $document.find('body').off('keyup', onKeyUp);
            }
         }

         function onKeyUp(event) {
            var keyCode = event.which || event.keyCode;

            if (keyCode === clarityConstants.keys.ENTER
                  || keyCode === clarityConstants.keys.ESC) {
               event.stopImmediatePropagation();
               event.preventDefault();
               return false;
            }

            return true;
         }
      }

      function setSubtitle(modalOptions) {
         if (_.has(modalOptions, 'subTitle') && _.isObject(modalOptions.subTitle)) {
            if (hasNonEmptyStringProperty(modalOptions.subTitle, 'text')) {
               modalOptions.subTitle = modalOptions.subTitle.text;
            }
            else if (hasNonEmptyStringProperty(modalOptions.subTitle, 'objectId')) {
               var objectId = modalOptions.subTitle.objectId;
               modalOptions.subTitle = '';
               dataService
                     .getProperties(objectId, ['name'])
                     .then(function(data) {
                        if (data && data.name) {
                           modalOptions.subTitle = data.name;
                        }
                     });
            } else {
               modalOptions.subTitle = '';
            }
         }
      }

      function hasNonEmptyStringProperty(object, property) {
         return _.has(object, property) && isNonEmptyString(object[property]);
      }

      function isNonEmptyString(string) {
         return !_.isUndefined(string) && !_.isNull(string) && _.isString(string) && !_.isEmpty(
                     string);
      }

      function decorateScope(scope, modalOptions) {
         scope.getOkBtnLabel = function () {
            return modalOptions.saveButtonLabel !== undefined ?
               modalOptions.saveButtonLabel :
               i18nService.getString("Common", "saveButtonLabel");
         };

         scope.getCancelBtnLabel = function () {
            return modalOptions.cancelButtonLabel !== undefined ?
               modalOptions.cancelButtonLabel :
               i18nService.getString("Common", "cancelButtonLabel");
         };
      }
   }
})();

(function() {
   'use strict';

   /**
    * Provides modal dialogs based on Clarity Design.
    */
   clarityModalServiceHelper.$inject = ['$rootScope', 'dataService', 'i18nService'];
   angular
         .module('com.vmware.platform.ui')
         .service('clarityModalServiceHelper', clarityModalServiceHelper);

   clarityModalServiceHelper.inject = [
      '$rootScope',
      'dataService',
      'i18nService'
   ];

   function clarityModalServiceHelper($rootScope, dataService, i18nService) {
      return {
         prepareModalScope: prepareModalScope
      };


      function prepareModalScope(actionEval, availableTargets, dialogData, templateUrl) {
         var scope = $rootScope.$new();

         scope.modalOptions = {
            modalOpen: true,
            iconClass: actionEval && actionEval.action ? actionEval.action.icon : '',
            contentUrl: templateUrl,
            actionEval: actionEval,
            availableTargets: availableTargets,
            dialogData: dialogData,
            defaultButton: dialogData ? dialogData.defaultButton : '',
            title: dialogData ? dialogData.title : '',
            size: dialogData ? dialogData.size : '',
            secondaryTitle: dialogData ? dialogData.secondaryTitle : '',
            focusTarget: dialogData && dialogData.focusTarget ? $(dialogData.focusTarget) : null
         };

         constructAndSetModalOptionsTitle(scope.modalOptions);

         return scope;
      }

      /**
       * Immediately returns some title so that the dialog can be shown as soon as
       * possible.
       * If needed, schedules a request for the target object's name.
       */
      function constructAndSetModalOptionsTitle(modalOptions) {
         var availableTargets = modalOptions.availableTargets;
         if (!availableTargets) {
            modalOptions.title = undefined;
         } else if (_.isEmpty(availableTargets) || availableTargets.length === 1) {
            setTitleForSingleEntity(modalOptions);
         } else {
            setTitleForMultipleEntities(modalOptions);
         }
      }

      function setTitleForSingleEntity(modalOptions) {
         var primaryTitle = modalOptions.title;
         if (primaryTitle && titleContainsPlaceholder(primaryTitle)) {
            setTitleToPlaceholderValue(modalOptions);
         } else if (primaryTitle && !titleContainsPlaceholder(primaryTitle)) {
            constructAndSetSecondaryTitle(modalOptions);
         } else if (!primaryTitle) {
            setPrimaryTitleToActionLabel(modalOptions);
            constructAndSetSecondaryTitle(modalOptions);
         }
      }

      function setTitleForMultipleEntities(modalOptions) {
         modalOptions.title = i18nService.getString('Common', 'dialogTitleFormatMultiple', modalOptions.availableTargets.length, "");
      }

      function titleContainsPlaceholder(title) {
         return title.indexOf('{0}') !== -1;
      }

      function setTitleToPlaceholderValue(modalOptions) {
         var availableTarget = modalOptions.availableTargets[0];
         if (availableTarget) {
            dataService
                  .getProperties(availableTarget, ['name'])
                  .then(function(data) {
                     if (data && data.name) {
                        modalOptions.title = i18nService.interpolate(modalOptions.title, [data.name]);
                        modalOptions.secondaryTitle = null;
                     }
                  });
         }
      }

      function setPrimaryTitleToActionLabel(modalOptions) {
         modalOptions.title = modalOptions.actionEval.action.label.replace(/\.+$/g, "");
      }

      function constructAndSetSecondaryTitle(modalOptions) {
         var secondaryTitle = modalOptions.secondaryTitle;
         if (!secondaryTitle) {
            fetchSecondaryTitleNameFromObjectId(modalOptions);
         }
      }

      function fetchSecondaryTitleNameFromObjectId(modalOptions) {
         var availableTarget = modalOptions.availableTargets[0];
         if (availableTarget) {
            dataService
                  .getProperties(availableTarget, ['name'])
                  .then(function(data) {
                     if (data && data.name) {
                        modalOptions.secondaryTitle = data.name;
                     }
                  });
         }
      }
   }
})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   angular.module('com.vmware.platform.ui').service('commonActionBarService', CommonActionBarService);

   CommonActionBarService.$inject = ['actionsService', 'vuiConstants', '$q'];

   function CommonActionBarService(actionsService, vuiConstants, $q) {
      var pendingActionRequestsData = [];
      return {
         createActionBar: createActionBar,
         updateActionBar: updateActionBar
      };

      function updateActionBar(actionsWrapperObject,
                               actionsPropertyName,
                               targetIds,
                               actionSpecs,
                               commonActionBarServiceCacheObject) {
         if(actionsWrapperObject[actionsPropertyName] &&
             actionsWrapperObject[actionsPropertyName].length) {
            return refreshActionBar(actionsWrapperObject,
                actionsPropertyName,
                targetIds,
                actionSpecs,
                commonActionBarServiceCacheObject);
         } else {
            return createActionBar(actionsWrapperObject, actionsPropertyName,
                targetIds, actionSpecs, commonActionBarServiceCacheObject);
         }
      }

      function createActionBar(actionsWrapperObject, actionsPropertyName, targetIds,
            actionSpecs, commonActionBarServiceCacheObject) {
         // this is needed to prevent 'no actions passed' error when loading the action
         // bar for the very first time
         if (!actionsWrapperObject[actionsPropertyName]) {
            actionsWrapperObject[actionsPropertyName] = [];
         }

         var actionEvalsPromise = commonActionBarServiceCacheObject ?
               commonActionBarServiceCacheObject :
               requestActions(targetIds, actionSpecs);

         return $q.when(actionEvalsPromise).then(function(actionEvalsById) {
            var actionButtons = [];
            _.forEach(actionSpecs, function(actionSpec) {
               var button;
               if (actionSpec === vuiConstants.actions.SEPARATOR) {
                  button = createSeparator();
                  if (button) {
                     actionButtons.push(button);
                  }
                  return;
               }

               if (actionSpec && actionSpec.actionId) {
                  button = createActionButton(
                        actionEvalsById[actionSpec.actionId],
                        getOnActionInvocationFunction(actionSpec, actionEvalsById),
                        actionSpec);
                  if (button) {
                     actionButtons.push(button);
                  }
               }
            });

            // the action bar is updated at once when all the buttons are created to
            // prevent the UI from flickering - if you initially reset (remove all the
            // actions ) the actions bar and then update the actions one by one UI is
            // flickering
            actionsWrapperObject[actionsPropertyName] = actionButtons;
            return actionEvalsById;
         });
      }

      function refreshActionBar(actionsWrapperObject,
                                actionsPropertyName,
                                targetIds,
                                actionSpecs,
                                commonActionBarServiceCacheObject) {
         var actionEvalsPromise = null;
         if(commonActionBarServiceCacheObject) {
            actionEvalsPromise = commonActionBarServiceCacheObject;
         } else {
            actionEvalsPromise = requestActions(targetIds, actionSpecs);
         }

         return $q.when(actionEvalsPromise).then(function(actionEvalsById) {
            var actionSpecsById = {};
            _.forEach(actionSpecs, function(spec) {
               actionSpecsById[spec.actionId] = spec;
            });
            _.forEach(actionsWrapperObject[actionsPropertyName], function(actionButton) {
               if(actionButton === vuiConstants.actions.SEPARATOR) {
                  return;
               }
               var actionId = actionButton.actionId;
               var actionEval = actionEvalsById[actionId];
               actionButton.onClick = getOnActionInvocationFunction(actionSpecsById[actionId], actionEvalsById);
               updateActionButtonAvailability(actionButton, actionEval);
               updateActionButtonVisibility(actionButton, actionEval);
            });
            return actionEvalsById;
         });
      }

      function createSeparator() {
         return vuiConstants.actions.SEPARATOR;
      }

      function createActionButton(actionEval, onClickCallback, actionSpec) {
         if(!actionEval) {
            return;
         }
         var label = actionEval.action.label;
         var tooltipText = actionEval.action.description;

         if(actionSpec.noLabel) {
            label = null;
            tooltipText = actionEval.action.label;
         }

         if(actionSpec.customLabel) {
            label = actionSpec.customLabel;
         }

         var actionButton = {
            actionId: actionEval.action.uid,
            tooltipText: tooltipText,
            label: label,
            iconClass: actionSpec.hideIcon ? "" : actionEval.action.icon,
            onClick: onClickCallback,
            isAvailableCustomCallback: actionSpec.isActionAvailable,
            isVisibleCustomCallback: actionSpec.isActionVisible
         };

         updateActionButtonAvailability(actionButton, actionEval);
         updateActionButtonVisibility(actionButton, actionEval);

         return actionButton;
      }

      function updateActionButtonAvailability(actionButton, actionEval) {
         if(!actionButton) {
            return;
         }

         if(!actionEval) {
            actionButton.enabled = false;
            return;
         }

         if(actionButton.isAvailableCustomCallback) {
            actionButton.enabled = !!actionButton.isAvailableCustomCallback(actionEval);
         } else {
            actionButton.enabled = !!actionEval.available;
         }
      }

      function updateActionButtonVisibility(actionButton, actionEval) {
         if (!actionButton) {
            return;
         }
         if (!actionEval) {
            actionButton.visible = true;
         }

         if(actionButton.isVisibleCustomCallback) {
            actionButton.visible = !!actionButton.isVisibleCustomCallback(actionEval);
         } else {
            actionButton.visible = true;
         }
      }

      /**
       * Requests action definitions for all action IDs in actionSpec array
       * @return map with action's uid as keys and actionDefintions as values.
       */
      function requestActions(targetIds, actionSpecs) {
         if(!actionSpecs) {
            return $q.when({});
         }

         var actionIds = actionSpecs.filter(function(actionSpec) {
            return actionSpec && actionSpec.actionId;
         }).map(function(actionSpec) {
            return actionSpec.actionId;
         });

         if(!actionIds || !actionIds.length) {
            return $q.when({});
         }

         var pendingActionRequestId = actionIds.join('\n');
         var pendingActionRequestData = pendingActionRequestsData[pendingActionRequestId];
         if (!pendingActionRequestData) {
            pendingActionRequestData = {
               targetIds: targetIds
            };
            pendingActionRequestsData[pendingActionRequestId] = pendingActionRequestData;
            pendingActionRequestData.request =
                requestActionsFromActionsService(targetIds, actionIds, pendingActionRequestId);
         } else {
            pendingActionRequestData.targetIds = targetIds;
         }

         return pendingActionRequestData.request
             .then(function(actionEvals) {
                return angular.copy(actionEvals);
             });
      }

      function requestActionsFromActionsService(targetIds, actionIds, pendingActionRequestId) {
         return actionsService.getActions(targetIds, actionIds).then(function(actionEvals) {

            var pendingRequest = pendingActionRequestsData[pendingActionRequestId];
            if (!angular.equals(targetIds, pendingRequest.targetIds)) {
               return requestActionsFromActionsService(pendingRequest.targetIds, actionIds, pendingActionRequestId);
            }

            var actionEvalsById = {};
            _.forEach(actionEvals, function(actionEval) {
               actionEvalsById[actionEval.action.uid] = actionEval;
            });

            delete pendingActionRequestsData[pendingActionRequestId];

            return actionEvalsById;
         });
      }

      function getOnActionInvocationFunction(actionSpec, actionEvalsById) {
         return function($event) {
            var actionEval = actionEvalsById[actionSpec.actionId];
            if(actionSpec.onInvokeAction) {
               actionSpec.onInvokeAction(actionEval);
            }
            var actionInvocationContext = actionSpec.getActionInvocationContext ?
                actionSpec.getActionInvocationContext() : null;
            if ($event && $event.currentTarget) {
               actionInvocationContext = actionInvocationContext ? angular.copy(actionInvocationContext) : {};
               actionInvocationContext.focusTarget = $event.currentTarget;
            }
            actionsService.invokeAction(actionEval, actionInvocationContext);
         };
      }
   }
})();


/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Provides webclient.properties flags and feature states.
 * Returns true if feature is enabled or false otherwise.
 */
(function() {
   "use strict";
   angular.module("com.vmware.platform.ui")
         .factory("configurationService", configurationService);

   configurationService.$inject = ["$http","$q", "logService"];

   function configurationService($http, $q, logService) {

      var log = logService("configurationService");

      var getConfiguration = function() {
         return $q.when(h5.configuration);
      };

      var getProperty = _.memoize(function (propertyName) {
         return getConfiguration().then(function(configPayload) {
            if (configPayload && configPayload.configParams) {
               return configPayload.configParams[propertyName];
            }
            return undefined;
         });
      });

      var getFeatureState = _.memoize(function (featureName) {
         return getConfiguration().then(function(configPayload) {
            if (configPayload && configPayload.featureStates) {
               return configPayload.featureStates[featureName];
            }
            return undefined;
         });
      });

      var isFeatureEnabled = _.memoize(function (featureName) {
         return getFeatureState(featureName).then(function(featureState) {
            return !!(featureState && featureState === "ENABLED");
         });
      });

      return {
         getConfiguration: getConfiguration,
         getProperty: getProperty,
         isFeatureEnabled: isFeatureEnabled
      };
   }
})();

(function () {
   'use strict';
   angular
         .module('com.vmware.platform.ui')
         .factory('contextObjectService', contextObjectService);
   contextObjectService.$inject = ['$rootScope'];

   /**
    * @ngdoc service
    * @name contextObjectService
    * @module com.vmware.platform.ui
    *
    * @description
    *    Service to get the selected context objects
    * @param $rootScope
    * @returns {{
         getSelection: getSelection
      }}
    */
   function contextObjectService($rootScope) {
      var service = {
         getSelection: getSelection
      };

      return service;

      /**
       * Returns the selected context objects
       * @returns [selectedElements]
       */
      function getSelection() {
         //used to check if a modal has been opened
         //this is the class of the modal background
         //if a modal exists with different class this check will not work.
         //The class should be added to the check as well
         var modalOpened = $('div[class*="modal-backdrop"]');

         var selection = [];
         if(modalOpened.length === 0) {
            var contentList = $('div[vx-extension-view-id="vsphere.core.inventory.serverObjectViewsExtension"] list-view div[kendo-grid]:first');
            if (contentList.length > 0) {
               var grid = contentList.data('kendoGrid');
               var selectedRows = grid.select();
               if (selectedRows.length > 0) {
                  for (var i = 0; i < selectedRows.length; i++) {
                     var data = grid.dataItem(selectedRows[i]);
                     selection.push(data.id);
                  }
               }
            } else if ($rootScope._route.objectId) {
               selection.push($rootScope._route.objectId);
            }
         }
         return selection;
      }

   }
}());


/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').service('datagridActionBarService',
         ['commonActionBarService', function(commonActionBarService) {

            function updateActionBar(datagridOptions, targetIds, actionSpecs, datagridActionBarServiceCacheObject) {
               var actionBarOptions;
               if(datagridOptions.actionsOptions) {
                  actionBarOptions = datagridOptions.actionsOptions;
                  datagridOptions.toolbar = [{
                     template: "<action-bar options=\"datagridOptions.actionsOptions\"></action-bar>"
                  }];
               } else {
                  datagridOptions.actionBarOptions = datagridOptions.actionBarOptions || {};
                  actionBarOptions = datagridOptions.actionBarOptions;
               }

               return commonActionBarService.updateActionBar(
                     actionBarOptions,
                     'actions',
                     targetIds,
                     actionSpecs,
                     datagridActionBarServiceCacheObject
               );
            }

            return {
               updateActionBar: updateActionBar
            };
         }]);
})();

var platform;
(function (platform) {
    var DataService = (function () {
        function DataService($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(DataService.prototype, "vcDataService", {
            get: function () {
                if (!this._vcDataService) {
                    this._vcDataService = this.$injector.get('vcDataService');
                }
                return this._vcDataService;
            },
            enumerable: true,
            configurable: true
        });
        DataService.prototype.getData = function (objectId, modelClassName, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getData(objectId, modelClassName, options);
        };
        DataService.prototype.getProperties = function (objectId, properties, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getProperties(objectId, properties, options);
        };
        DataService.prototype.getPropertiesForObjects = function (objectIds, properties, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getPropertiesForObjects(objectIds, properties, options);
        };
        DataService.prototype.getPropertiesByRelation = function (objectId, relation, targetType, properties, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getPropertiesByRelation(objectId, relation, targetType, properties, options);
        };
        DataService.prototype.getPropertiesByFilter = function (filterSpec, properties, resourceModels, options) {
            if (options === void 0) { options = {}; }
            return this.vcDataService.getPropertiesByFilter(filterSpec, properties, resourceModels, options);
        };
        DataService.$inject = ["$injector"];
        return DataService;
    }());
    platform.DataService = DataService;
    /**
     * @ngdoc service
     * @name com.vmware.platform.ui.dataService
     * @module com.vmware.platform.ui
     *
     * @description
     *    Utility methods for fetching data from the /data endpoint.
     */
    angular.module("com.vmware.platform.ui").service("dataService", DataService);
})(platform || (platform = {}));



/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Utilities for the dataService
 */
angular.module('com.vmware.platform.ui').factory('dataServiceUtil',
      ['$injector',
function($injector) {
   var _dataService = $injector.get('dataService');
   var _vcDataServiceUtil = $injector.get('vcDataServiceUtil');


   return {
      /**
       * Helper method to make it easier to use the modelChanged event.
       * Retrieves attribute on changed objects, and then updates existing object with new attributes.
       *
       * @param $scope
       *    Scope to listens for changes on.
       * @param attrsToFetch
       *    Array of attributes to fetch for changed objects
       * @param getMatching
       *    A function that returns an array of matching objects for a given id
       * @param mappingFunction
       *    A function that receives the new attributes and called on each matching objects
       */
      onModelChanged: function($scope, attrsToFetch, getMatching, mappingFunction) {
         $scope.$on('modelChanged', function(event, objectChangeInfo) {
            if (!objectChangeInfo || !objectChangeInfo.objectId) {
               return;
            }
            var matchedEntries = getMatching(objectChangeInfo);

            if (!matchedEntries.length) {
               return;
            }

            _dataService.getProperties(objectChangeInfo.objectId, attrsToFetch).then(function(resp){
               matchedEntries.forEach(function(entry){
                  mappingFunction(entry, resp);
               });
            });
         });
      },

      /**
       * The function is a wrapper around 'dataService.getPropertiesForObjects',
       * but  supports heterogeneous object set. It works around the original
       * 'dataService' limitation by grouping the supplied objects by type and then
       * issuing separate (but parallel) requests for each group. Once all requests
       * are back - the result is merged and returned to the caller.
       *
       * @see dataService.getPropertiesForObjects
       */
      getPropertiesForObjects: function (objectIds, properties, options) {
         return _vcDataServiceUtil.getPropertiesForObjects(
               objectIds, properties, options);
      },

      /**
       * This method is inspired by the 'dataService.getPropertiesByRelation'
       * function, but works on multiple input objects.
       *
       * @param objectIds
       *    The 'ids' of the objects that are the source of the relation.
       * @param relation
       *    The relation, which allow the code to jump from the source objects to
       *    a new set of objects.
       * @param properties
       *    The properties to obrain on the final set of objects retrived via the
       *    relation hop.
       * @param options
       *    options supplied when requesting the property set
       */
      getPropertiesForObjectsByRelation: function (objectIds, relation, properties, options) {
         return _vcDataServiceUtil.getPropertiesForObjectsByRelation(
               objectIds, relation, properties, options);
      },

      /**
       * A helper method that builds a map from the property results you
       * get back from the 'dataService' when requesting properties for multiple
       * objects. What you get back from the data service is a map
       * {
       *    objectId1: {
       *        prop1: value1,
       *        prop2: value2,
       *        ...
       *    }
       *    objectId2: {
       *       prop1: value21,
       *       prop2: value22,
       *       ...
       *    }
       * }
       *
       * calling this method with 'propertyName' say 'prop1' will return the following
       * map:
       * {
       *    objectId1: value1,
       *    objectId2: value2,
       *    ...
       * }
       *
       * this structure is often more convenient for processing by the property
       * data requester.
       *
       * @param propertyValuesByObjectId
       *    The result returned by the 'getPropertiesForObjects' method
       *
       * @param propertyName
       *    The name of the property which value should be put in the resulting map
       */
      createPropertyByObjectMap: function (propertyValuesByObjectId, propertyName) {
         return _vcDataServiceUtil.createPropertyByObjectMap(
               propertyValuesByObjectId, propertyName);
      }
   };
}]);

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * @name com.vmware.platform.ui:datastoreBrowserConstants
 * @module com.vmware.platform.ui
 *
 * @description
 *    The `datastoreBrowserConstants` service holds datastores browser related constants.
 *
 *    List of available constants:
 *
 *    - fileQueryType
 *       - **`VM_DISK`** : flag which represents the query type corresponding to the VM
 *             disk files
 *       - **`FLOPPY_IMAGE`** : flag which represents the query type corresponding to
 *             the floppy image files
 *       - **`ISO_IMAGE`** : flag which represents the query type corresponding to the
 *             ISO image files.
 *       - **`VM_CONFIG_FILES`** : flag which represents the query type corresponding
 *             to the VM configuration (*.vmx, *.vmtx) file.
 *       - **`ALL_FILES`** : flag which represents the query type corresponding to
 *             the all file types.
 *       - **`FOLDERS`** : flag which represents the query type corresponding to folder
 *             types.
 */
angular.module('com.vmware.platform.ui').constant('datastoreBrowserConstants', {
   fileQueryType : {
      VM_DISK: parseInt("0x0001", 16),
      FLOPPY_IMAGE: parseInt("0x0002", 16),
      ISO_IMAGE: parseInt("0x0004", 16),
      VM_CONFIG_FILES: parseInt("0x0008", 16),
      ALL_FILES: parseInt("0x0010", 16),
      FOLDERS: parseInt("0x0020", 16),
      VM_DISK_TYPE_WITH_DETAILS: parseInt("0x0040", 16)
   }
});

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Defines datastore type constants
 */
angular.module('com.vmware.platform.ui').constant('datastoreTypeConstants', {
   VMFS: 'VMFS',
   NFS: 'NFS',
   NFS41: 'NFS41',
   VSAN: 'vsan',
   VVOL: 'VVOL'
});

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {

   'use strict';

   angular.module('com.vmware.platform.ui').factory('dragAndDropManager',
         ['logService', 'defaultUriSchemeUtil', 'dragAndDropRulesService',
            'actionsService','validationExpressionParserService',
            function(logService, defaultUriSchemeUtil, dragAndDropRulesService,
                  actionsService, validationExpressionParserService) {

               function DragAndDropManager(logService, defaultUriSchemeUtil,
                     dragAndDropRulesService, validationExpressionParserService) {
                  var self = this;

                  self._log = logService('dragAndDropManager');
                  self._cachedActionContextsByDropTargetUid = {};
                  self._rulesLookupByDragObjectType = {};

                  dragAndDropRulesService.getRules().then(function(rules) {
                     self.setDragAndDropRules(rules);
                  });

                  self.clearCache = function() {
                     self._cachedActionContextsByDropTargetUid = {};
                  };

                  self.isDropValid = function(dragItems, dropTarget) {
                     dragItems = removeDropTargetFromDragItems(dragItems, dropTarget);

                     if (!dropTarget || !isDragValid(dragItems)) {
                        return false;
                     }

                     var cachedResult =
                           self._cachedActionContextsByDropTargetUid[dropTarget.objRef];

                     if (typeof cachedResult === 'boolean') {
                        return cachedResult;
                     }

                     var validDraggedObjects =
                           getValidDragObjects(dragItems, dropTarget);

                     var isDropTargetValid = validDraggedObjects.length > 0;

                     return setCachedResultAndReturn(dropTarget.objRef, !!isDropTargetValid);
                  };

                  self.invokeAction = function(dragItems, dropTarget) {
                     dragItems = removeDropTargetFromDragItems(dragItems, dropTarget);

                     if (!self.isDropValid(dragItems, dropTarget)) {
                        return;
                     }

                     var validDraggedObjects =
                           getValidDragObjects(dragItems, dropTarget);

                     if(validDraggedObjects.length > 0) {
                        var rulesByDragObjectType =  getRulesByDragObject(dragItems[0]);
                        evaluateActionAndInvokeFunction(
                              rulesByDragObjectType.actionUid, validDraggedObjects, dropTarget.objRef);
                     }

                  };

                  self.setDragAndDropRules = function(rules) {
                     self._rulesLookupByDragObjectType = rules;
                  };

                  function isDragValid (dragItems) {
                     if (_.isEmpty(dragItems)) {
                        return false;
                     }
                     var dragSource = dragItems[0];

                     // if the selection is of a mixed type the drag is not valid
                     var isMixedDrag = isDragMixed(dragItems);
                     if (isMixedDrag) {
                        return false;
                     }

                     var rulesByDragObjectType = getRulesByDragObject(dragSource);
                     if (!rulesByDragObjectType) {
                        return false;
                     }

                     return true;
                  }

                  function setCachedResultAndReturn(targetObjRef, result) {
                     self._cachedActionContextsByDropTargetUid[targetObjRef] = result;
                     return result;
                  }

                  function getRulesByDragObject(dragSource) {
                     if (!dragSource) {
                        return null;
                     }
                     var sourceType = defaultUriSchemeUtil.getEntityType(dragSource.objRef);
                     var rules = self._rulesLookupByDragObjectType[sourceType];
                     return rules;
                  }

                  function evaluateActionAndInvokeFunction(actionId, targets, dropTarget){
                     if (targets.length > 0) {
                        actionsService.getAction(actionId, targets).then(function(actionEval) {
                           if(actionEval && actionEval.available === true) {
                              actionsService.invokeAction(actionEval, {dropTarget: dropTarget});
                           }
                        });
                     }
                  }

                  /**
                   * if the drop target is among the selected drag items,
                   * removes it from the list
                   * @param dragItems
                   * @param dropTarget
                   * @returns {*}
                   */
                  function removeDropTargetFromDragItems(dragItems, dropTarget) {
                     if (_.isEmpty(dragItems) || !dropTarget) {
                        return [];
                     }
                     return _.filter(dragItems, function(dragItem) {
                        return dragItem.objRef !== dropTarget.objRef;
                     });
                  }

                  function isDragMixed(dragItems) {

                     var dragSource = dragItems[0];
                     var sourceType = defaultUriSchemeUtil.getEntityType(dragSource.objRef);
                     // get the item that has a different entity type
                     var isMixedDrag = _.some(dragItems, function(dragItem) {
                        var dragItemType =
                              defaultUriSchemeUtil.getEntityType(dragItem.objRef);
                        return dragItemType !== sourceType;
                     });

                     // if the selection is of a mixed type the drag is not valid
                     return isMixedDrag;
                  }

                  function getValidDragObjects(dragItems, dropTarget) {
                     var dragSource = dragItems[0];
                     var rulesByDragObjectType = getRulesByDragObject(dragSource);

                     // if more than one drag item and the rule's allowMultipleDragObjects
                     // flag is false do not allow drop
                     if(dragItems.length > 1
                           && !rulesByDragObjectType.allowMultipleDragObjects) {
                        return [];
                     }

                     var sourceIds = _.map(dragItems, function(dragItem) {
                        return dragItem.id;
                     });

                     var targetType = defaultUriSchemeUtil.getEntityType(dropTarget.objRef);
                     var isDropTargetValid =
                           (rulesByDragObjectType.dropTargetTypesList.indexOf(targetType) >= 0);

                     var validDraggedObjects =
                           validationExpressionParserService.evaluateValidationExpressions(
                                       rulesByDragObjectType.validationExpressions,
                                       sourceIds, dropTarget.id, dragItems, dropTarget);


                     isDropTargetValid = isDropTargetValid && (validDraggedObjects.length > 0);

                     return isDropTargetValid ? validDraggedObjects : [];
                  }
               }

               return new DragAndDropManager(logService, defaultUriSchemeUtil,
                     dragAndDropRulesService, validationExpressionParserService);
            }]);
})();

(function() {

   'use strict';

   angular.module('com.vmware.platform.ui')
         .factory('dragAndDropRulesService', dragAndDropRulesService);

   dragAndDropRulesService.$inject = [
      '$http'
   ];

   function dragAndDropRulesService($http) {

      var getRules = _.memoize(function() {
         return $http({
            method: 'get',
            url: 'dragAndDrop/rules'
            }).then(function(resp) {
               return resp.data;
            });
      });

      return {
         getRules: getRules
      };
   }
})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
angular.module('com.vmware.platform.ui').factory('entityStatusService', ['i18nService', function (i18nService) {
   return {
      statusProperties: function (status) {
         var iconClass = 'vui-icon-datagrid-status-unknown';
         var label = i18nService.getString('Common', 'entityStatus.gray');
         if (status === 'green') {
            iconClass = 'vsphere-icon-status-ok';
            label = i18nService.getString('Common', 'entityStatus.green');
         } else if (status === 'yellow') {
            iconClass = 'vsphere-icon-status-warning';
            label = i18nService.getString('Common', 'entityStatus.yellow');
         } else if (status === 'red') {
            iconClass = 'vsphere-icon-status-error';
            label = i18nService.getString('Common', 'entityStatus.red');
         }
         return {
            iconClass: iconClass,
            label: label
         };
      }
   };
}]);
(function () {
   'use strict';
   angular.module('com.vmware.platform.ui').factory('$exceptionHandler',
      ['$log', '$injector', function ($log, $injector) {
      var notificationService;

         // Overrides Angular's $exceptionHandler to show error in notification popup and collect it in PhoneHome.
         // For release builds the error popup won't show up.  Error collection depends on CEIP approval
      return function (exception, cause) {
         if (window.jasmine) {
            throw exception;
         }

         // If the app is in debug mode, keep track of all of the exceptions that
         // occurred in the jsErrors array.
         if (window.h5.debug) {
            window.jsErrors = window.jsErrors || {};
            window.jsErrors[exception.message] = exception.stack;
         }

         if (!notificationService) {
            notificationService = $injector.get('notificationService');
         }
         $log.error.apply($log, arguments);
         notificationService.notifyError(null, exception.message, exception.stack, true);
      };
   }]);
}());
/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Utility method
 */
angular.module('com.vmware.platform.ui').factory('extensionCategoryUtil', [
function() {
   'use strict';
   return {
      /*
       * Given the categories(parentExtensions) and a list of childextensions, map the
       * children to a parent by matching the categoryUid of the child with the uid of the parent
       *
       */
      mergeCategories: function(categories, extensions) {
         if (!(extensions && extensions[0])) {
            return [];
         }
         //Add two empty categories to handle uncategorised extensions

         var UNCATEGORIZED_VSPHERE_EXT = "_Uncategorized_vSphere_Extensions_";
         var UNCATEGORIZED_PLUGIN_EXT = "_Uncategorized_Plugin_Extensions_";
         categories.push({uid: UNCATEGORIZED_VSPHERE_EXT});
         categories.push({uid: UNCATEGORIZED_PLUGIN_EXT});
         // [childSpecs] to {categoryId,[extensions]}
         var group = _(extensions).groupBy(function(extension) {
            if (!extension.categoryUid) {
               if (extension.contentSpec && extension.contentSpec.sandbox) {
                  extension.categoryUid = UNCATEGORIZED_PLUGIN_EXT;
               } else {
                  extension.categoryUid = UNCATEGORIZED_VSPHERE_EXT;
               }
            }
            return extension.categoryUid;
         });

         var combinedCategories = _.chain(categories)
               .map(function(category) {
                  if (!group[category.uid]) {
                      return null;
                  }
                  var extensions = group[category.uid];
                  var isExternalPlugin = extensions && extensions[0] &&
                        extensions[0].contentSpec && extensions[0].contentSpec.sandbox;
                  return {
                     title: category.label,
                     exts: group[category.uid],
                     categoryId: category.uid,
                     isExternalPlugin: isExternalPlugin
                  };
               })
               .compact()
               .partition(function (category) {
                  return category.isExternalPlugin;
               })
               .sortBy(function (partition) {
                  var isExternalPlugin = partition.length && partition[0].isExternalPlugin;
                  return isExternalPlugin ? 1 : 0;
               })
               .compact()
               .flatten(true).value();
         return combinedCategories;
      }
   };
}]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Defines extension framework related constants
 */
angular.module('com.vmware.platform.ui').constant('extensionFrameworkConstants', {
   ViewRetentionPolicy: {
      NONE: "NONE",
      INHERIT: "INHERIT",
      SELF_ONLY: "SELF_ONLY",
      DESCENDANTS_ONLY: "DESCENDANTS_ONLY",
      SELF_AND_DESCENDANTS: "SELF_AND_DESCENDANTS"
   }
});


/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Handles extension related logic.
 */
angular.module('com.vmware.platform.ui').factory('extensionService', ['$http',
function($http) {
   return {
      /**
       * Get a extensions array keyed by a pointId, the array content is filtered using the objectId.
       */
      getExtensions: function(pointId, objectId) {
         return $http({
            method: 'get',
            url: 'extensions/' + pointId + '/' + objectId
         }).then(function(resp){
            return resp.data;
         });
      },
      /**
       * Given a extension, determine the child pointId, and return the associated extensions array filtered by the objectId.
       *
       * Note: in plugin.xml, the child pointId is specified as the "hostedPoint" of a extension.
       */
      getHostedExtensions: function(extensionId, objectId) {
         var params;
         if (angular.isDefined(objectId) && objectId !== null) {
            params = {
               objectId: objectId
            };
         }
         return $http({
            method: 'get',
            url: 'hostedextensions/' + extensionId,
            params: params
         }).then(function(resp){
            return resp.data;
         });
      },

      /**
       * Check if new plugins have been registered after login
       */
      checkForNewPlugins: function() {
         return $http({
            method: 'get',
            url: 'checkForNewPlugins',
            skipLoadingNotification: true
         }).then(function(resp){
            return resp.data;
         });
      },
   };
}]);

(function() {
   'use strict';
   angular.module('com.vmware.platform.ui').service('featureFlagsService', featureFlagsService);

   featureFlagsService.$inject = ['configurationService'];

   function featureFlagsService(configurationService) {
      var self = {};

      fetchFeatureFlag('h5uiVmLibraryActionAddFlag');
      fetchFeatureFlag('hardwareV14_vbs');
      fetchFeatureFlag('h5uiCLSoverVAPI');
      fetchFeatureFlag('h5uiOvfDeployFromLocal');
      fetchFeatureFlag('h5uiDirectIsoMountFromCL');
      fetchFeatureFlag('h5uiImportItemToCL');
      fetchFeatureFlag('h5uiMoveVmToHostAndCluster');
      fetchFeatureFlag('h5uiAddNetworkingBindToPnic');
      fetchFeatureFlag('h5uiNRP');
      fetchFeatureFlag('HWv14');
      fetchFeatureFlag('VMcrypt2');
      fetchFeatureFlag('DeferHistoryImport');
      fetchFeatureFlag('PMem');
      fetchFeatureFlag('VRDMA_ROCEV2');
      fetchFeatureFlag('HCI');
      fetchFeatureFlag('CL_Native_VMTX_Phase2');
      fetchFeatureFlag('CL_OVA_Support');
      fetchFeatureFlag('CL_VMTX_Sync');
      fetchFeatureFlag('h5uiLicensingOnlineSync');

      function fetchFeatureFlag(flagName) {
         self[flagName + 'Enabled'] = function() { return false; };

         configurationService.isFeatureEnabled(flagName).then(function(featureIsEnabled) {
            self[flagName + 'Enabled'] = function() {
               return featureIsEnabled;
            };
         });
      }

      return self;
   }

   window.featureFlagsService = featureFlagsService;
})();

/**
 * Service providing an API for saving a string in a file.
 */
//TODO use ng4 service
(function () {
   'use strict';
   angular.module('com.vmware.platform.ui').service('fileSaverService', fileSaverService);
   fileSaverService.$inject = ['logService'];

   function fileSaverService(logService) {
      var log = logService('fileSaverService');
      return {
         save: save
      };

      function save(data, fileName) {
         if (!_.isString(data)) {
            log.error('Data argument should be a string');
            return;
         }
         if (!_.isString(fileName) || _.isEmpty(fileName)) {
            log.error('Filename argument should be a not empty string');
            return;
         }
         var blob = new Blob([data], {type: "text/plain;charset=utf-8"});
         saveBlob(blob, fileName, true);
      }

      function saveBlob(blob, fileName, disableAutoBOM) {
         saveAs(blob, fileName, disableAutoBOM);
      }
   }
})();

// Copyright (c) 2015 VMware, Inc.  All rights reserved. -- VMware Confidential
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
         .service('helpService', HelpService);

   HelpService.$inject = ['$window', '$httpParamSerializer', 'configurationService'];

   /**
    * Help service for opening a help page
    */
   function HelpService($window, $httpParamSerializer, configurationService) {

      // --------------- public APIs  ----------------

      return {
         showHelpPage: showHelpPage,
         getHelpPageUrl: getHelpPageUrl,
         showVmcOnAwsPage: showVmcOnAwsPage
      };

      // --------------- API implementation ----------------
      /**
       * Open a specific help page by providing a contextId.
       * If you do not provide a specific context then the global documentation page is
       * opened.
       * @param contextId The specific id for a help page
       * Example:
       * showHelpPage('com.vmware.vsphere.vm_admin.doc.vc_312') -> opens a page with the
       * provided context id
       * showHelpPage() -> opens the default documentation page
       */
      function showVmcOnAwsPage(){
         return configurationService.getProperty('vmcOnAws.url').then(function(vmcOnAwsPageUrl) {
            $window.open(vmcOnAwsPageUrl, '_blank');
         });
      }

      function showHelpPage(contextId) {
         createPageUrl(contextId).then(function(url) {
            $window.open(url, '_blank');
         });
      }

      function getHelpPageUrl(contextId) {
         return createPageUrl(contextId);
      }

      function createPageUrl(contextId) {
         if (contextId) {
            return configurationService.getProperty('help.url.contextual').then(function(helpUrl) {
               var url = getFormattedHelpUrl(helpUrl);
               url = insertLocaleInUrl(url);

               var contextParam = $httpParamSerializer({
                  id: contextId
               });
               url += 'context?' + contextParam;

               return url;
            });
         } else {
            return configurationService.getProperty('help.url').then(function(helpUrl) {
               var url = getFormattedHelpUrl(helpUrl);
               url = insertLocaleInUrl(url);
               return url;
            });
         }
      }

      function getLocale() {
         var fullLocale = h5.locale || "en-US";
         fullLocale = fullLocale.toLowerCase();
         var localeLangCode;
         switch(fullLocale){
            case "zh-cn":
               localeLangCode = fullLocale.split("-")[1];
               break;
            case "zh-tw":
               localeLangCode = fullLocale.split("-")[1];
               break;
            default:
               localeLangCode = fullLocale.split("-")[0];
               break;
         }
         return localeLangCode;
      }

      function getFormattedHelpUrl(url) {
         if(url !== undefined){
            var result = url;
            if (result.lastIndexOf("/") !== (url.length - 1)) {
               result = url + "/";
            }
            return result;
         }
         else {
            return "http://docs.vmware.com/";
         }
      }

      function insertLocaleInUrl(url) {
         var result = url.replace("{0}", getLocale());
         return result;
      }
   }
})();

// Copyright (c) 2015-2017 VMware, Inc.  All rights reserved. -- VMware Confidential
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
      .service('htmlBridgeService', htmlBridgeService);

   htmlBridgeService.$inject = ['$http', '$rootScope', 'userSessionService',
         'clarityModalService', 'notificationService', 'defaultUriSchemeUtil',
         'pluginUrlService', 'logService'];

   /*
    * Service for supporting 6.0 Html plugins.
    * This service is in addition to platformService.js which exposes the WEB_PLATFORM API.
    */
   function htmlBridgeService ($http, $rootScope, userSessionService, clarityModalService,
                               notificationService, defaultUriSchemeUtil, pluginUrlService,
                               logService) {

      // Cached userSession and server infos
      var userSession = null;
      var userSessionServerInfo = null;

      // Cached dialog options when modal dialog is opened
      var htmlDialogOptions = null;

      // Cached modal dialog and action dialog scope
      var htmlModalDialog = null;
      var htmlActionDialog = null;

      // Cached action targets to be able to send modelChange events
      var targetsByActionId = {};

      // Cached current objectId when opening a modal dialog
      var modalDialogObjectId = null;

      var FORWARD_SLASH_ENCODED2 = "%252F";
      var FORWARD_SLASH_REGEX = /\//g;

      var DEFAULT_WIDTH = 500;
      var DEFAULT_HEIGHT = 400;

      var log = logService('htmlBridgeService');

      // --------------- public APIs  ----------------

      var service = {
         init: init,
         callActionsController: callActionsController,
         getUserSession: getUserSession,
         sendNavigationRequest: sendNavigationRequest,
         openModalDialog: openModalDialog,
         closeDialog: closeDialog,
         setDialogTitle: setDialogTitle,
         setDialogSize: setDialogSize,
         sendModelChangeEvent: sendModelChangeEvent
      };

      return service;

      // --------------- API implementation ----------------

      function init() {
         // Since the platform SDK API used to give the userSession with vc server info, lets continue to do that for
         // backward compatibility.
         // TODO smarathe - Ideally we need to introduce another public API method which returns a Promise with the serverInfos.

         // For now - doing all this in init() since the callers expect it to be a synchronous function.
         // Cache userSession
         userSessionService.getUserSession().then(function(session) {
            userSession = getSdkUserSession(session);
         });

         userSessionService.getAllServersInfo().then(function(info) {
            userSessionServerInfo = getSdkUserSessionServerInfo(info);
         });

         // Register the HtmlActionDelegate used by plugins
         window.h5.actions["com.vmware.vsphere.client.htmlbridge.HtmlActionDelegate"] =
            function(actionEval, targets) {
               // targets is an array of 0 or more objectIds
               targetsByActionId[actionEval.action.uid] = targets;

               if (!actionEval.additionalData.dialogTitle) {
                  // Direct server call, no UI involved
                  handleHeadlessAction(actionEval);
               } else {
                  // Modal dialog. All server calls will be made within the plugin's own code.
                  openActionDialog(actionEval, targets);
               }
            };
      }

      function getSdkUserSession(rawUserSessionInfo) {
         // com.vmware.vsphere.client.usersession.
         var sdkUserSession = rawUserSessionInfo;

         if (!sdkUserSession) {
            return sdkUserSession;
         }

         sdkUserSession = _.pick(
               sdkUserSession,
               [
                  "userName",
                  "locale",
                  "clientId",
                  "hashedClientId"
               ]
         );

         return sdkUserSession;
      }

      function getSdkUserSessionServerInfo(rawUserSessionServerInfo) {
         // com.vmware.vsphere.client.usersession.UserSessionServerInfo
         var sdkUserSessionServerInfo = rawUserSessionServerInfo;

         if (!sdkUserSessionServerInfo) {
            return sdkUserSessionServerInfo;
         }

         sdkUserSessionServerInfo = _.pick(
               sdkUserSessionServerInfo,
               [
                  "serversInfo",
                  "linkedServersInfo"
               ]
         );

         if (sdkUserSessionServerInfo["serversInfo"]) {
            sdkUserSessionServerInfo["serversInfo"] =
                  getSdkServersInfo(sdkUserSessionServerInfo["serversInfo"]);
         }

         if (sdkUserSessionServerInfo["linkedServersInfo"]) {
            sdkUserSessionServerInfo["linkedServersInfo"] =
                  getSdkLinkedServersInfo(sdkUserSessionServerInfo["linkedServersInfo"]);
         }

         return sdkUserSessionServerInfo;
      }

      function getSdkLinkedServersInfo(rawLinkedServersInfo) {
         // com.vmware.vise.vim.commons.vcservice.ServerInfoEx[][]
         var sdkLinkedServersInfo = rawLinkedServersInfo;

         if (!sdkLinkedServersInfo) {
            return sdkLinkedServersInfo;
         }

         sdkLinkedServersInfo = _.map(
               sdkLinkedServersInfo,
               getSdkServersInfo
         );

         return sdkLinkedServersInfo;
      }

      function getSdkServersInfo(rawServersInfo) {
         // com.vmware.vise.vim.commons.vcservice.ServerInfoEx[]
         var sdkServersInfo = rawServersInfo;

         if (!sdkServersInfo) {
            return sdkServersInfo;
         }

         sdkServersInfo = _.map(
               sdkServersInfo,
               getSdkServerInfo
         );

         return sdkServersInfo;
      }

      function getSdkServerInfo(rawServerInfo) {
         // com.vmware.vise.vim.commons.vcservice.ServerInfoEx
         var sdkServerInfo = rawServerInfo;

         if (!sdkServerInfo) {
            return sdkServerInfo;
         }

         sdkServerInfo = _.pick(
               sdkServerInfo,
               [
                  // com.vmware.vise.usersession.ServerInfo
                  "name",
                  "serviceUrl",
                  "serviceGuid",
                  "thumbprint",
                  "version",
                  "sessionKey",
                  "sessionCookie",

                  // com.vmware.vise.vim.commons.vcservice.ServerInfoEx
                  "ssoDomain",
                  "nodeId",
                  "serviceInstance",
                  "content",
                  "errorCode"
               ]
         );

         if (sdkServerInfo["ssoDomain"]) {
            sdkServerInfo["ssoDomain"] = getSdkSsoDomain(
                  sdkServerInfo["ssoDomain"]
            );
         }

         // com.vmware.vim.binding.vmodl.ManagedObjectReference
         if (sdkServerInfo["serviceInstance"]) {
            sdkServerInfo["serviceInstance"] = angular.copy(
                  sdkServerInfo["serviceInstance"]
            );
         }

         // com.vmware.vim.binding.vim.ServiceInstanceContent
         if (sdkServerInfo["content"]) {
            sdkServerInfo["content"] = angular.copy(
                  sdkServerInfo["content"]
            );
         }

         return sdkServerInfo;
      }

      function getSdkSsoDomain(rawSsoDomain) {
         // com.vmware.sso.tokenmgmt.SsoDomain
         var sdkSsoDomain = rawSsoDomain;

         if (!sdkSsoDomain) {
            return sdkSsoDomain;
         }

         sdkSsoDomain = _.pick(
               sdkSsoDomain,
               [
                  "id",
                  "name",
                  "type",
                  "isLocal"
               ]
         );

         return sdkSsoDomain;
      }

      // Ideally we need to introduce a public API method which returns a Promise for this call and even split this call
      // into 2 kinsd - get normal session information and getVCServersInfo(). SDK team has these items in
      // the backlog. Someone needs to mark this methods as deprecated.
      function getUserSession() {
         if (userSession) {
            return angular.extend(userSession, userSessionServerInfo);
         }
         return null;
      }

      function handleHeadlessAction(actionEval) {
         var actionUrl = actionEval.additionalData.actionUrl;
         if (actionUrl.indexOf('?') < 0) {
            actionUrl += '?';
         }
         actionUrl += '&actionUid=' + actionEval.action.uid + '&locale=' + userSession.locale;

         callActionsController(actionUrl, null, actionEval.action.uid);
      }

      function callActionsController(url, jsonData, actionUid) {

         var params = {};

         // When this is called from a modal dialog (and not an action dialog) we must set
         // targetsByActionId to the cached modalDialogObjectId since this is the real target
         if (modalDialogObjectId) {
            targetsByActionId[actionUid] = [modalDialogObjectId];
         }
         var targetObjects = targetsByActionId[actionUid];


         if (!angular.isArray(targetObjects)) {
            throw new Error("invalid targets for action " + actionUid);
         }

         if (targetObjects.length > 0) {
            // Pass object ids as a comma separated string. Better as params than on Url
            // No need to encode objectIds
            params.targets = targetObjects.toString();
         }

         if (jsonData) {
            // convert jsonData to an object so that $httpParamSerializer adds it to the request
            params.json = JSON.parse(jsonData);
         }

         $http.post(url, null, { params: params }).then(function(resp) {
            // Handle the response like HtmlActionDelegate.as in NGC.
            // See various ActionResult use cases in the chassisA-service ActionController.java
            if (resp.data) {
               var actionSuccessfull = false;
               var targetObjects = null;
               if (resp.data.actionUid) {
                  targetObjects = targetsByActionId[resp.data.actionUid];
                  if (!targetObjects) {
                     log.error("Missing target objects or invalid action id: " + resp.data.actionUid);
                  }
               }
               if (resp.data.result) {
                  // result is either true/false for edit & delete, or the new object URI
                  var result = resp.data.result;
                  if (typeof result === 'boolean') {
                     actionSuccessfull = result;
                  } else if (typeof result === 'string' && resp.data.uriType) {
                     actionSuccessfull = true;
                     var objectId = result;
                     targetObjects = [ objectId ];
                  }
               }

               if (actionSuccessfull && resp.data.operationType && targetObjects) {
                  handleModelChange(resp.data, targetObjects);
               }
               if (resp.data.errorMessage) {
                  displayActionError(resp.data);
               }
               // Done with this action
               if (targetObjects && resp.data.actionUid) {
                  targetsByActionId[resp.data.actionUid] = null;
               }
            }

         });
      }

      // Open a vUI dialog in "sandbox" mode to support 6.0 Html plugins.
      // - actionEval.additionalData contains parameters parsed from the 6.0 plugin.xml:
      //
      //  <actionUrl>/vsphere-client/chassisa/resources/editChassisAction.html</actionUrl>
      //  <dialogTitle>#{chassis.editAction}</dialogTitle>
      //  <dialogSize>500,300</dialogSize>
      //  <dialogIcon>#{editChassis}</dialogIcon>
      //
      // - The sandbox flag added to dialogOptons below tells vuiDialogService to use an iFrame and to
      // remove the default footer buttons because OK/Cancel is handled by the plugin code
      function openActionDialog(actionEval, targetObjects) {
         var width = DEFAULT_WIDTH;
         var height = DEFAULT_HEIGHT;

         if (actionEval.additionalData.dialogSize) {
            var size = actionEval.additionalData.dialogSize.split(",");
            width = parseInt(size[0], 10);
            if (isNaN(width) || width <= 0) {
               width = DEFAULT_WIDTH;
            }
            height = parseInt(size[1], 10);
            if (isNaN(height) || height <= 0) {
               height = DEFAULT_HEIGHT;
            }
         }

         var actionUrl = pluginUrlService.buildUrl(actionEval.additionalData.actionUrl,
             {objectId: null, locale: userSession.locale}) ;

         var additionalParams = {
            'actionUid': actionEval.action.uid
         };
         if (targetObjects) {
            // Double encoding of "/" required as elsewhere for objectIds
            additionalParams['targets'] = targetObjects.toString().replace(FORWARD_SLASH_REGEX, FORWARD_SLASH_ENCODED2);
         }

         actionUrl = pluginUrlService.appendParams(actionUrl, additionalParams);

         htmlDialogOptions = {
            title: actionEval.additionalData.dialogTitle,
            url: actionUrl,
            pluginSize: {
               width: width,
               height: height
            },
            // size: getSize(size[0]),
            iconClass: (actionEval.additionalData.dialogIcon) ? actionEval.additionalData.dialogIcon : actionEval.action.icon
         };

         pluginUrlService.associatePluginSessionWithClientId(actionEval.additionalData.actionUrl)
            .then(function() {
               htmlActionDialog = _openModal(actionEval, targetObjects, htmlDialogOptions);
            });
      }

      /**
       * Navigate to the given view
       * @param extensionId
       * @param objectId
       */
      function sendNavigationRequest(extensionId, objectId) {
            $rootScope._navigateToViewAndObject(extensionId, objectId);
      }

      /**
       * Triggers an internal modelChange event.  This is mostly useful to refresh custom
       * objects in the RHS navigator (because vSphere objects are refreshed automatically)
       * after a plugin made some changes AND didn't use the standard ActionController which
       * supports such model update (See ActionsController.java in samples)
       *
       * @param objectId   The object affected by the change
       * @param opType     "add", "change", "delete" or "relationship_change"
       */
      function sendModelChangeEvent(objectId, opType) {
         if (!objectId) {
            return;
         }
         var objectType = defaultUriSchemeUtil.getEntityType(objectId);
         var targetObjects = [objectId];
         var data = {operationType: opType, uriType: objectType};
         handleModelChange(data, targetObjects);
      }

      /**
       * Propagate modelChanged event after an action completes successfully
       */
      function handleModelChange(data, targetObjects) {
         var opType = data.operationType.toUpperCase();
         if (opType !== "ADD" && opType !== "CHANGE" && opType !== "DELETE" &&
            opType !== 'RELATIONSHIP_CHANGE') {
            throw new Error("Invalid operation type " + data.operationType +
               (data.actionUid ? (' returned for action ' + data.actionUid) : ''));
         }
         // Supports only 1 object for now
         // TODO see story https://www.pivotaltracker.com/story/show/121523243 for multiple objects
         var objectId = targetObjects[0];

         var objectChangeInfo = { objectId: objectId, operationType: opType };
         if (opType === "ADD") {
            objectChangeInfo.object = { type: data.uriType};
         }

         $rootScope.$broadcast('modelChanged', objectChangeInfo);
      }

      /**
       * Display the error message sent back by the plugin's ActionController
       */
      function displayActionError(data) {
         // The message is either a string already localized or an object
         var errorMsg = null;
         if (angular.isString(data.errorMessage)) {
            errorMsg = data.errorMessage;
         } else {
            var key = data.errorMessage.key;
            var bundleName = data.errorMessage.bundleName;
            var params = data.errorMessage.params;
            if (key && bundleName) {
               errorMsg = $rootScope.i18n(bundleName, key, params);
            } else {
               log.error("Invalid errorMessage object returned by action " + data.actionUid);
               return;
            }
         }

         // TODO for now we use the non-intrusive notification popup but we could
         // use a H5C modal dialog here or the banner (it wasn't possible in NGC)
         notificationService.notifyError(null, errorMsg);
      }

      /**
       * Open modal dialog in this scope.
       *
       * @param title    Modal dialog title
       * @param url      URL to html page.
       * @param width    Modal dialog width, need to be number
       * @param height   Modal dialog height, need to be number
       * @param objectId
       * TODO add icon parameter
       */
      function openModalDialog(title, url, width, height, objectId) {
         if (!url) {
            return;
         }
         // TODO this logic doesn't work anymore because ClarityModalService allows to close the dialog without
         // going through CloseDialog().  Unfortunately there is no quick way to solve this so I will leave it as
         // bug to fix in a future Fling and document in SDK 6.5

         // if (htmlModalDialog){
         //    console.error('Modal dialog is already opened');
         //    return;
         // }

         // Remember the objectId to use as an action target in callActionsController
         modalDialogObjectId = objectId;
         var availableTargets = [objectId];

         var trustedUrl = pluginUrlService.buildUrl(url, {objectId: objectId, locale: userSession.locale});

         if (!angular.isNumber(width) || width <= 0) {
            width = DEFAULT_WIDTH;
         }
         if (!angular.isNumber(height) || height <= 0) {
            height = DEFAULT_HEIGHT;
         }

         var actionEval = {
            action: { }
         };
         htmlDialogOptions = {
            title: title,
            url: trustedUrl,
            pluginSize: {
               width: width,
               height: height
            }
            // size: getSize(width)
         };

         pluginUrlService.associatePluginSessionWithClientId(url).then(function() {
               htmlModalDialog = _openModal(actionEval, availableTargets, htmlDialogOptions);
            });
      }

      function _openModal(actionEval, availableTargets, dialogOptions) {
         var dialogScope = clarityModalService.openModal(
               actionEval, availableTargets, dialogOptions, 'resources/ui/views/plugins/htmlBridgePluginModalTemplate.html');

         // Handler called by clarityModalService.closeModal(). When user closes the modal with ESC or click
         // in X box in header we must call closeDialog ourselves since their plugin code won't do it.
         dialogScope.onCancelModal = function() {
            _closeDialog(true);
         };

         return dialogScope;
      }

      /**
       * Public API to close a modal dialog (either a dialog from a menu action, or from openModalDialog)
       */
      function closeDialog() {
         _closeDialog(false);
      }

      /**
       * Internal version of closeDialog API which is either called from plugin code, or when the user
       * clicks on the X button in the dialog header.
       *
       * @param fromCancelModal  true when this is called internally from clarityModalService.closeModal(),
       *          this is necessary to avoid an infinite loop!
       * @private
       */
      function _closeDialog(fromCancelModal){
         // Plugin can only have 1 dialog at a time.  This is a documented SDK limitation.
         if (htmlModalDialog) {
            if (!fromCancelModal) {
               htmlModalDialog.closeModal();
            }
            htmlModalDialog = null;
            modalDialogObjectId = null;
            return;
         }
         if (htmlActionDialog) {
            if (!fromCancelModal) {
               htmlActionDialog.closeModal();
            }
            htmlActionDialog = null;
         }
      }

      /**
       * Set the dialog's title.
       * @param title
       */
      function setDialogTitle(title){
         if (htmlDialogOptions === null) {
            log.error("Invalid use of setDialogTitle API");
            return;
         }
         htmlDialogOptions.title = title;

         //trigger the angular digest cycle in order to reflect the changes
         $rootScope.$apply();
      }

      /**
       * Set the dialog's width and height
       * @param width
       * @param height
       */
      function setDialogSize(width, height){
         log.error("Not supported in HTML Client SDK 6.5");

         /*
         if (htmlDialogOptions === null ||
            !(angular.isNumber(width) && width > 0) ||
            !(angular.isNumber(height) && height > 0)) {
            console.error("Invalid use of setDialogSize API");
            return;
         }
         htmlDialogOptions.width = width+'px';
         htmlDialogOptions.height = height+'px';
         //trigger the angular digest cycle in order to reflect the changes
         $rootScope.$apply();
         */
      }

      /* NOT USED FOR NOW
       * Get the predefined size for the clarity modal, see http://clarity.vmware.com/documentation/modals
       *
       * @param width
       * @returns {modal size}: 'sm', '<none>', 'lg' or 'xl'
       *
      function getSize(width) {
         if(width <= 288) {
            return 'sm';
         } else if(width <= 576){
            return '<none>';
         } else if(width <= 864) {
            return 'lg';
         }
         return 'xl'; // 'xl' is 1152, only in Clarity 0.5.1
      }
      */
   }
})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Wraps $http to provide request cancellation logic.
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
      .factory('httpCancellationService', httpCancellationService);

   httpCancellationService.$inject = ['$http', '$q'];

   function httpCancellationService($http, $q) {
      return function() {
         var deferred;

         function fetch(httpConfig) {
            cancel();

            deferred = $q.defer();

            httpConfig = httpConfig || {};
            httpConfig.timeout = deferred.promise;

            return $http(httpConfig);
         }

         function cancel() {
            if (deferred) {
               // $http timeout allows only promises created by $timeout to be
               // used as parameter. However we want to cancel the request not
               // based on elapsed time but rather based on the fact that a new
               // navigation request has been dispatched so we ser $$timeoutId to
               // imitate a promise created by $timeout.
               // https://github.com/angular/angular.js/blob/v1.7.x/src/ng/httpBackend.js#L173
               deferred.promise.$$timeoutId = -1;
               // Do not report error on rejected promise.
               // https://github.com/angular/angular.js/blob/v1.7.x/src/ng/q.js#L682
               deferred.promise.$$state.pur = true;
               // $timeout.cancel() internally calls promise.reject() so we do the same
               // https://github.com/angular/angular.js/blob/v1.7.x/src/ng/timeout.js#L102
               deferred.reject('canceled');
            }
         }

         // Public API
         return {
            /**
             * Wraps $http.
             *
             * Always cancels previous fetch.
             *
             * @param {Object} httpConfig Passed to $http.
             * @returns {Promise}
             */
            fetch: fetch,

            /**
             * Cancels the previously initiated fetch request.
             *
             * NOTES:
             * This does not resolve neither reject the $http promise.
             * Subsequent calls to cancel do nothing unless a fetch is in progress.
             */
            cancel: cancel
         };
      };
   }
}());


/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /**
     * Wrapper over downgraded service \vim-clients\applications\h5\ng-next-app\src\app\platform\services\translation\i18n.service.ts
     */
    var I18nServiceWrapper = (function () {
        function I18nServiceWrapper($injector) {
            var _this = this;
            this.$injector = $injector;
            // Note: Using arrow functions instead of a regular class method because many users of this service
            // like to grab a handle to getString method from the service but doing so
            // losing the class context with regular class methods. Arrow functions maintains this functionality
            this.getString = function (bundle, key) {
                var interpolations = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    interpolations[_i - 2] = arguments[_i];
                }
                return (_a = _this.vcI18nService).getString.apply(_a, [bundle, key].concat(interpolations));
                var _a;
            };
            this.getEscapedString = function (bundle, key) {
                var interpolations = [];
                for (var _i = 2; _i < arguments.length; _i++) {
                    interpolations[_i - 2] = arguments[_i];
                }
                return (_a = _this.vcI18nService).getEscapedString.apply(_a, [bundle, key].concat(interpolations));
                var _a;
            };
            this.interpolate = function (localizedString, interpolations) {
                return _this.vcI18nService.interpolate(localizedString, interpolations);
            };
            this.interpolateAndEscape = function (localizedString, interpolations) {
                return _this.vcI18nService.interpolateAndEscape(localizedString, interpolations);
            };
            this.getLocale = function () {
                return _this.vcI18nService.getLocale();
            };
        }
        Object.defineProperty(I18nServiceWrapper.prototype, "vcI18nService", {
            get: function () {
                if (!this._vcI18nService) {
                    this._vcI18nService = this.$injector.get('vcI18nService');
                }
                return this._vcI18nService;
            },
            enumerable: true,
            configurable: true
        });
        I18nServiceWrapper.$inject = ['$injector'];
        return I18nServiceWrapper;
    }());
    platform.I18nServiceWrapper = I18nServiceWrapper;
    /**
     * @ngdoc service
     * @name com.vmware.platform.ui.i18nService
     * @module com.vmware.platform.ui
     *
     * @description
     *    Internationalization Service.
     */
    angular.module('com.vmware.platform.ui').service('i18nService', I18nServiceWrapper);
})(platform || (platform = {}));



angular
      .module('com.vmware.platform.ui')
      .service('informationalDialogService', ['$rootScope', 'vuiDialogService',

         function ($rootScope, vuiDialogService) {
            return {
               display: function (params) {
                  var $scope = $rootScope.$new();
                  $scope.informationalDialogOptions = {
                     title: params.title,
                     contentUrl: 'resources/ui/views/dialogs/InformationalDialog.html',
                     show: true,
                     confirmOptions: {
                        onClick: function () {
                           return true;
                        }
                     },
                     rejectOptions: {
                        visible: false
                     },
                     width: params.width || '400px'
                  };

                  var options = {
                     scope: $scope,
                     configObjectName: 'informationalDialogOptions'
                  };

                  $scope.informationalMessage = params.content;

                  $scope.imageUrl = params.imagePath;
                  vuiDialogService(options);
               }
            };
         }
      ]
);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Service providing an API for working with IP addresses.
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').service('ipParserService', ipParserService);

   function ipParserService() {
      var SUBNET_MASK_MAX_QUAD_VALUE = 255;
      var SUBNET_MASK_VALID_QUAD_VALUES = [0, 128, 192, 224, 240, 248, 252, 254];
      var MAX_PORT = Math.pow(2, 16);
      var IPV6_BRACKETED_NOTATION_REGEX = new RegExp('^\\[(.*)\\](:(\\d+))?$'); // capture groups are: [fullText, address, portWithColon, port]
      var DIGITS_REGEX = new RegExp('^\\d+$');
      var ZONE_INDEX_REGEXP = /^\w+$/;

      return {
         parse: parse,
         isSubnetMaskValid: isSubnetMaskValid,
         isSubnetPrefixValid: isSubnetPrefixValid,
         isIpv4AddressValid: isIpv4AddressValid,
         isIpv6AddressValid: isIpv6AddressValid,
         isAddressValid: isAddressValid,
         isSameIpv4Subnet: isSameIpv4Subnet,
         expandIpv6Address: expandIpv6Address,
         equalIpv6Addresses: equalIpv6Addresses
      };

      function isIpv4AddressValid(ipAddress) {
         return ipaddr.IPv4.isValid(ipAddress) && validIpV4Address(ipAddress);
      }

      function isIpv6AddressValid(ipAddress, acceptZoneIndex) {
         if (!ipAddress) {
            return false;
         }

         var addr = ipAddress.trim();

         if (acceptZoneIndex) {
            var delimiterIndex = addr.indexOf('%');

            if (delimiterIndex > -1) {
               var zoneIndex = addr.substring(delimiterIndex + 1);

               if (!ZONE_INDEX_REGEXP.test(zoneIndex)) {
                  return false;
               }

               addr = addr.substring(0, delimiterIndex);
            }
         }

         return ipaddr.IPv6.isValid(addr);
      }

      /**
       * @param ipAddressFirst - first ipv4Address for comparison
       * @param ipAddressSecond - second ipv4Address for comparison
       * @param subnetMask - subnetMask associated with the given IPs
       * @returns {boolean} true if all parameters are valid and ipAddressFirst
       *          subnet matches the ipAddressSecond subnet, otherwise returns false
       */
      function isSameIpv4Subnet(ipAddressFirst, ipAddressSecond, subnetMask) {
         if (!isIpv4AddressValid(ipAddressFirst)
               || !isIpv4AddressValid(ipAddressSecond)
               || !isSubnetMaskValid(subnetMask)) {
            return false;
         }

         var splitIpFirst = ipAddressFirst.split('.');
         var splitIpSecond = ipAddressSecond.split('.');
         var splitSubnet = subnetMask.split('.');

         // enable bitwise operations
         /*jshint bitwise:false */
         for (var i = 0; i < 4; i++) {
            if ((splitIpFirst[i] & splitSubnet[i]) !== (splitIpSecond[i] & splitSubnet[i])) {
               return false;
            }
         }

         return true;
      }

      /**
       * Returns true if provided ipAddress is valid IPv4 or IPv6 address
       * @param ipAddress
       */
      function isAddressValid(ipAddress) {
         return isIpv6AddressValid(ipAddress) || isIpv4AddressValid(ipAddress);
      }

      function expandIpv6Address(ipAddress) {
         if (!ipAddress ||
                  (!isIpv4AddressValid(ipAddress) && !isIpv6AddressValid(ipAddress))) {
            return ipAddress;
         }

         var parsedAddress = ipaddr.parse(ipAddress);
         return (typeof parsedAddress.toNormalizedString !== 'undefined')
               ? parsedAddress.toNormalizedString() : ipAddress;
      }

      function validIpV4Address(ipAddress) {
         var splittedIpAddress = ipAddress.split('.');
         if(splittedIpAddress.length !== 4){
            return false;
         }

         return _.every(splittedIpAddress, function(item) {
            return item >= 0 && item <= 255;
         });
      }

      function isSubnetPrefixValid(prefix) {
         return prefix >= 1 && prefix <= 128;
      }

      function isSubnetMaskValid(subnetMask) {
         if (!subnetMask) {
            return false;
         }

         // If the mask ends with '.', or has no number between two '.', then the .split()
         // would return "" in this case, which transformed into a number results in `0`.
         // This should be avoided by filtering the non-empty strings.
         var maskBytes = [];
         _.each(subnetMask.split('.'), function (octet) {
            if (!!octet) {
               maskBytes.push(Number(octet));
            }
         });

         // The first octet cannot be 0 for a valid IP
         if (maskBytes.length !== 4 || maskBytes[0] === 0) {
            return false;
         }

         // Find the first quad that is not equal to 255
         var firstNonMaxQuadIndex = 0;

         for (var i = 0; i < maskBytes.length; i++) {
            if (maskBytes[i] !== SUBNET_MASK_MAX_QUAD_VALUE) {
               break;
            } else {
               firstNonMaxQuadIndex++;
            }
         }

         // All quads are equal to 255 -> valid subnet mask
         if (firstNonMaxQuadIndex === maskBytes.length) {
            return true;
         }

         // Quad should be contiguous
         if (!_.contains(SUBNET_MASK_VALID_QUAD_VALUES, maskBytes[firstNonMaxQuadIndex])) {
            return false;
         }

         // Following quads should be zero
         for (var j = firstNonMaxQuadIndex + 1; j < maskBytes.length; j++) {
            if (maskBytes[j] !== 0) {
               return false;
            }
         }

         return true;
      }

      /**
       * Compares its two ipv6 addresses. Returns true if it's the same ip address even
       * if the format is different.
       *
       * @param addr1 The first valid ipv6 address to be compared
       * @param addr2 The second valid ipv6 address to be compared
       * @returns {boolean}
       */
      function equalIpv6Addresses(addr1, addr2){
         return getNormalizedIpv6Address(addr1) === getNormalizedIpv6Address(addr2);
      }

      /**
       * Returns normalized form of IPv6 and IPv4 address
       * @param ipAddress
       *
       */
      function getNormalizedIpv6Address(ipAddress){
         var addr = ipaddr.parse(ipAddress);

         if(addr.kind() === "ipv4") {
            addr = addr.toIPv4MappedAddress();
         }

         return addr.toNormalizedString();
      }

      function parse(addressString) {
         var addressAndPort = detectParts(addressString);
         var portResult = parsePort(addressAndPort.port);
         var addressResult = parseAddress(addressAndPort.address);

         if (portResult.valid && addressResult.valid) {
            return buildIpAddress(addressResult.address, portResult.port);
         } else {
            return null;
         }
      }

      function detectParts(addressString) {
         var parts = addressString.split(':');

         if (parts.length > 2) {
            return detectIPv6Parts(addressString);
         } else {
            return {
               address: parts[0],
               port: parts[1]
            };
         }
      }

      function detectIPv6Parts(address) {
         var match = IPV6_BRACKETED_NOTATION_REGEX.exec(address);
         if (match) {
            return {
               address: match[1],
               port: match[3]
            };
         } else {
            return {
               address: address
            };
         }
      }

      function parseAddress(address) {
         if (!ipaddr.isValid(address)) {
            return {valid: false};
         }

         return {
            valid: true,
            address: ipaddr.parse(address).toString()
         };
      }

      function parsePort(port) {
         if (port === undefined) {
            return {valid: true, port: undefined};
         }

         if (!DIGITS_REGEX.test(port)) {
            return {valid: false};
         }

         var parsedPort = parseInt(port, 10);
         if (parsedPort <= 0) {
            return {valid: false};
         } else if (parsedPort >= MAX_PORT) {
            return {valid: false};
         } else {
            return {valid: true, port: parsedPort};
         }
      }

      function buildIpAddress(address, port) {
         return {
            address: address,
            port: port
         };
      }
   }
})();

(function () {
   'use strict';
   angular
      .module('com.vmware.platform.ui')
      .factory('issueService', issueService);
   issueService.$inject = ['$http'];

   /**
    * @ngdoc service
    * @name issueService
    * @module com.vmware.platform.ui
    *
    * @description
    *    Service to retrieve issues.
    * @param $http
    * @returns {{getIssues: getIssues}}
    */
   function issueService($http) {
      var ISSUES_ENDPOINT = 'issues';
      var ISSUES_ACTIONS_ENDPOINT = 'issues/actions/evaluations';
      var service = {
         getIssues: getIssues,
         evaluateActions: evaluateActions
      };

      return service;

      /**
       * Retrieve issues from the server for a given objectId
       * @param objectId
       *    Identifier of the object whose issues are to be fetched.
       * @param count
       *    Max count of issues to be fetched.
       * @param getActionEvaluations
       *    Boolean flag whether to get actions for each issue.
       */
      function getIssues(objectId, count, getActionEvaluations) {

         var promise = $http({
            method: 'GET',
            url: ISSUES_ENDPOINT,
            params: {
               objectId: objectId,
               pageSize: count,
               getActionEvaluations: getActionEvaluations
            }
         }).then(function (response) {
            return response.data;
         });
         return promise;
      }

      /**
       * Retrieves the action evaluations for an issue and the object to which the issue belongs to
       * @param objectId
       *    Identifier of the object whose actions will be evaluated
       * @param issueId
       *    Identifier of the issue whose actions will be retrieved
       * @param details
       *    Details for the provided issue, used to filter some of the actions
       */
      function evaluateActions(objectId, issueId, details) {
         var promise = $http({
            method: 'POST',
            url: ISSUES_ACTIONS_ENDPOINT,
            params: {
               objectId: objectId,
               issueId: issueId
            },
            data: {
               details: details
            }
         }).then(function (response) {
            return response.data;
         });
         return promise;
      }
   }
}());


(function () {
   'use strict';
   angular
         .module('com.vmware.platform.ui')
         .factory('keyboardShortcutMapper', keyboardShortcutMapper);
   keyboardShortcutMapper.$inject = [
   ];

   /**
    * This service has one purpose and one purpose only: keeping the mapping
    * between a keyboard shortcut and action invoked as result of the shortcut.
    */
   function keyboardShortcutMapper() {
      var shortcutsByActionId = {};

      var service = {
        getKeyboardShortcut: getKeyboardShortcut,
        getFormattedKeyboardShortcut: getFormattedKeyboardShortcut,
        putKeyboardShortcut: putKeyboardShortcut
      };
      return service;


      function getKeyboardShortcut(actionId) {
         var info = shortcutsByActionId[actionId];
         if (!info) {
            return undefined;
         }

         return info.raw;
      }

      function getFormattedKeyboardShortcut(actionId) {
         var info = shortcutsByActionId[actionId];
         if (!info) {
            return undefined;
         }

         return info.formatted;
      }

      function putKeyboardShortcut(actionId, shortcut) {
         shortcutsByActionId[actionId] = {
            raw: shortcut,
            formatted: formatKeyboardShortcut(shortcut)
         };
      }

      function formatKeyboardShortcut(shortcut) {
         if (shortcut === undefined) {
            return undefined;
         }

         var keys = shortcut.split("+");

         for (var i = 0; i < keys.length - 1; i++) {
            keys[i] = keys[i].trim().toLowerCase();
         }
         keys[keys.length - 1] = keys[keys.length - 1].trim().toUpperCase();

         return keys.join(" + ");
      }

   }
}());


/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function () {
   'use strict';
   angular
      .module('com.vmware.platform.ui')
      .factory('keyboardShortcutService', keyboardShortcutService);
   keyboardShortcutService.$inject = [
      'actionsService',
      'contextObjectService',
      'keyboardShortcutMapper',
      'notificationService',
      'navigation',
      'vxZoneService',
      'telemetryService'
   ];

   var NO_ACTION_WITH_ID = "No Action registered with ID";

   /**
    * @ngdoc service
    * @name keyboardShortcutService
    * @module com.vmware.platform.ui
    *
    * @description
    *    Service to bind shortcuts to a specific action or function.
    * @param actionsService
    * @param contextObjectService
    * @returns {{
         bindFunction: bindFunction,
         bindAction: bindAction
      }}
    */
   function keyboardShortcutService(actionsService, contextObjectService, keyboardShortcutMapper, notificationService, navigation, vxZoneService, telemetryService) {
      var service = {
         bindFunction: bindFunction,
         bindAction: bindAction,
         bindNavigationShortcut: bindNavigationShortcut,
         invokeNavigation: invokeNavigation
      };
      var blockedShortcuts = {};

      return service;

      /**
       * Binds a function to a specific shortcut
       * Sample:
       *    keyboardShortcutService.bindFunction('ctrl+f', function(event) {...});
       *    event parameter is of KeyboardEvent type
       * @param shortcut - a sequence of keyboard keys
       * @param functionToBind - function to be invoked when the shortcut is pressed
       */
      function bindFunction(shortcut, functionToBind) {

         Mousetrap.bind(shortcut, function (event, shortcut) {
            if (blockedShortcuts[shortcut]) {
               return false;
            }
            // we simulate a mouse click so that if there are any opened pop-up
            // (such as actions-menu, context menu or other) will be closed
            simulateClick();
            blockedShortcuts[shortcut] = true;
            vxZoneService.runInsideAngular(function () {
               trackTelemetryKeyboardEvent(shortcut);
               functionToBind(event);
            });
            //this is used to prevent the default browser behaviour of some shortcuts
            return false;
         }, 'keydown');

         Mousetrap.bind(shortcut, function (event, shortcut) {
            if (blockedShortcuts[shortcut]) {
               delete blockedShortcuts[shortcut];
            }
            return false;
         }, 'keyup');
      }

      /**
       * Invokes a given action when the specified keyboard shortcut is triggered. Action
       * is invoked on the currently selected object in the H5 app.
       * Sample:
       *    keyboardShortcutService.bindAction('ctrl+alt+b', 'vsphere.core.vm.powerOnAction');
       * @param shortcut - a sequence of keyboard keys
       * @param actionId - an action id from plugin.xml that will be evaluated and invoked
       * when the shortcut is pressed
       */
      function bindAction(shortcut, actionId) {
         keyboardShortcutMapper.putKeyboardShortcut(actionId, shortcut);
         bindFunction(shortcut, evaluateActionAndInvokeFunction.bind({}, actionId));
      }

      /**
       * Invokes navigation to a specific view when the corresponding keyboard shortcut
       * is triggered.
       * Sample:
       *    keyboardShortcutService.bindNavigationShortcut('ctrl+alt+1',
       *    'vsphere.core.controlcenter.domainView');
       * @param shortcut - a sequence of keyboard keys
       * @param extensionId - an extension id from plugin.xml that will be evaluated and invoked
       * when the shortcut is pressed
       */
      function bindNavigationShortcut(shortcut, extensionId) {
         keyboardShortcutMapper.putKeyboardShortcut(extensionId, shortcut);
         bindFunction(shortcut, invokeNavigation.bind({}, extensionId));
      }

      function trackTelemetryKeyboardEvent(shortcut, extensionId) {
         telemetryService.trackEvent("keyboard", "shortcut", shortcut, extensionId);
      }

      function invokeNavigation(extensionId, event) {
         navigation.navigateToView(extensionId);
      }

      function evaluateActionAndInvokeFunction(actionId, event) {
         var targets = contextObjectService.getSelection();
         if (targets.length > 0) {
            actionsService.getAction(actionId, targets, true)
               .then(function (actionEval) {
                  actionsService.invokeActionWithConfirmation(actionEval, {}, targets);
               })
               .catch(function (error) {
                  if (error.status && error.status === 500) {
                     var message = error.data.message;
                     if (message && message.lastIndexOf(NO_ACTION_WITH_ID, 0) < 0) {
                        var notificationParam = {};
                        notificationParam.content = message;
                        notificationParam.type = notificationService.type.ERROR;
                        notificationService.notify(notificationParam);
                     }
                  }
               });
         }
      }

      function simulateClick() {
         $(document.body).mousedown();
      }
   }
}());
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';

   /**
    * @ngdoc service
    * @name com.vmware.platform.ui:listUtil
    * @module com.vmware.platform.ui
    *
    * @description
    *    The `listUtil` service holds list related utility functions.
    *
    */
   angular.module('com.vmware.platform.ui').factory('listUtil', [function () {

      return {
         compareNumericValues: compareNumericValues
      };

      function compareNumericValues(item1, item2, field) {
         var firstValue = Number(item1[field]);
         var secondValue = Number(item2[field]);

         if (isNaN(firstValue) && isNaN(secondValue)) {
            return 0;
         }
         if (isNaN(firstValue)) {
            return -1;
         }
         if (isNaN(secondValue)) {
            return 1;
         }

         if (firstValue < secondValue) {
            return -1;
         }
         if (firstValue > secondValue) {
            return 1;
         }
         return 0;
      }
   }]);
})();

/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service to save data to local storage.
 * There are two flavors for getting/setting data:
 * getData/setData & getUserData/setUserData
 *
 * The first one gets/sats the dada into the local storage directly,
 * while the second one modifies the key to include the username
 * (thus its usage is best for data manipulation specific to the currently logged user)
 * and that's why it uses promises, i.e. the result of getUserData is a primise
 * which when resolved will contain the actual data
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('localStorageService', localStorageService);

   localStorageService.$inject = ['$window', '$q', 'userSessionService', 'logService'];

   function localStorageService($window, $q, userSessionService, logService) {
      //deferred object used to optimise the process of retrieving the username,
      //i.e. when the username is retrieved this deferred object is being reused henceforth
      var _deferredUsername;

      //define and initialize the log
      var log = logService('localStorageService');

      //the real local storage object
      var localStorage = getLocalStorage();

      //Public API
      var service = {
         getData: getData,
         setData: setData,
         getUserData: getUserData,
         setUserData: setUserData,
         removeUserData: removeUserData
      };
      return service;

      /**
       * Retrieving data from the local storage.
       * @param key the key to the local storage data
       * @returns the object being saved in the local storage,
       *         Note that the stored data is converted through angular.fromJson()
       */
      function getData(key) {
         var data = (localStorage ? localStorage.getItem(key) : null);
         data = angular.fromJson(data);
         return data;
      }

      /**
       * Setting data into the local storage.
       * The data is stringified through angular.toJson() before being written
       * @param key the key to the local storage data
       * @param data to be stored
       */
      function setData(key, data) {
         data = angular.toJson(data);
         if (localStorage) {
            try {
               localStorage.setItem(key, data);
            } catch(e) {
               // ignore case of mobile browser or safari incognito mode where localStorage is not fully supported
               // see "QuotaExceededError: DOM Exception 22" in http://h5-feedbackportal.eng.vmware.com:3000/feedback?errlist=1
            }
         }
      }

      /**
       * Removing data from local storage
       * @param key the key to the local storage data
       */
      function removeData(key) {
         if (localStorage) {
            try {
               localStorage.removeItem(key);
            } catch(e) {
               // ignore case of mobile browser or safari incognito mode
               // where localStorage is not fully supported
               // see "QuotaExceededError: DOM Exception 22"
               // in http://h5-feedbackportal.eng.vmware.com:3000/feedback?errlist=1
            }
         }
      }

      /**
       * Retrieving user specific data from the local storage.
       * This method is similar to getData() and it uses it internally.
       * The key is concatenated with the username to build the final key.
       *
       * @param key the key to the local storage data
       * @returns a promise which when resolved will hold the object being saved in the local storage
       */
      function getUserData(key) {
         var deferred = $q.defer();
         getUsername().then(function (username) {
            var data = getData(key + username);
            deferred.resolve(data);
         });
         return deferred.promise;
      }

      /**
       * Setting user specific data into the local storage.
       * This method is similar to setData() and it uses it internally.
       * The key is concatenated with the username to build the final key.
       */
      function setUserData(key, data) {
         getUsername().then(function (username) {
            setData(key + username, data);
         });
      }

      /**
       * Removing user specific data from the local storage
       * This method is similar to removeData() and it uses it internally.
       * The key is concatenated with the username to build the final key.
       */
      function removeUserData(key) {
         getUsername().then(function (username) {
            removeData(key + username);
         });
      }

      /**
       * Retrieves the username from the userSessionService
       * @returns a promise which when resolved will hold the username converted to lowercase
       */
      function getUsername() {
         if (_deferredUsername) {
            return _deferredUsername.promise;
         }

         //this deferred object is used until the username is successfully retrieved
         var deferred = $q.defer();
         userSessionService.getUserSession().then(function (userSession) {
            if (userSession.userName) {
               //set the _deferredUsername so that it can be reused
               _deferredUsername = deferred;
               _deferredUsername.resolve(userSession.userName.toLowerCase());
            } else {
               log.error('Error getting username from userSessionService');
            }
         });
         return deferred.promise;
      }

      /**
       * Gets the local storage that this service is build upon
       * @returns the browser local storage if such exists, or a fake one
       */
      function getLocalStorage() {
         // Need a try/catch because IE may throw "access denied"
         try {
            if ($window.localStorage) {
               return $window.localStorage;
            }
         } catch(e) {
            log.error(e);
         }

         // fake storage returning always null data
         var dict = {};
         return {
            getItem: function (key) {
               return dict[key];
            },
            setItem: function (key, value) {
               dict[key] = value;
            }
         };
      }
   }
})();

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service that handles log out operations.
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').factory('logoutService', logoutService);
   logoutService.$inject = ['$window', 'AngularInjector', 'i18nService', 'alertService'];

   function logoutService($window, AngularInjector, i18nService, alertService) {

      var alertConfig = (function () {
         var getString = _.partial(i18nService.getString, 'Common');
         var productName = getString('client.productName');

         return {
            title: getString('error.connectionError.title'),
            message: getString('error.notAuthenticatedError', productName)
         };
      }());

      // Public API
      var service = {
         logout: logout
      };
      return service;

      /**
       * Log out of the client.
       *
       * @param {Object} options (optional)
       *    Contains optional parameters.
       *
       * @param {boolean} options.showNotification (optional)
       *    If true show an alert and log out when the alert is closed.
       *    Otherwise directly log out of the client. Defaults to false.
       */
      function logout(options) {
         var validatedOptions = _.isObject(options) ? options : {};

         if (validatedOptions.showNotification === true) {
            alertService.error(alertConfig.title, alertConfig.message, internalLogout);
         } else {
            internalLogout();
         }
      }

      function internalLogout() {
         var vApiServiceAngular = AngularInjector.get('vscVapiService');
         vApiServiceAngular.logout();

         // Stores redirect URL. After a successful login the user is redirected to the URL.
         $window.location.href = h5.logoutUrl;
         $window.h5.isLogoutInProgress = true;
      }
   }
}());

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Logging service wrapper over angular $log
 * Example usage:
 * var log = logService('MyController');
 * var someObject = {key:'value'}
 * log.log('simple log');
 * log.warn('warning');
 * log.debug('debugging',);
 * log.info('some info',someObject);
 * log.error('bad error');
 */

angular.module('com.vmware.platform.ui').config(["$logProvider", function($logProvider){
   $logProvider.debugEnabled(true);  // to enable/disable debugging
}])
.value('logServiceWhiteList', /.*/)  // regex to control logs displayed
.factory('logService', ['$log','logServiceWhiteList','$location',
function($log,logServiceWhiteList,$location) {

   logServiceWhiteList = logServiceWhiteList || /.*/ ;
   var queryParam = $location.search();
   var logLevel = queryParam.logLevel ;
   logServiceWhiteList = logLevel ? new RegExp(logLevel,'i') : logServiceWhiteList;

   return function(caller){

      return{
         log: log('log'),
         debug: log('debug'),
         info: log('info'),
         warn: log('warn'),
         error: log('error'),
         setLogLevel: setWhiteList()
      };

   function setWhiteList(regex){
      return function(regex){
         logServiceWhiteList = new RegExp(regex);
      };

   }

   function log(level){

      var match = logServiceWhiteList ?
            caller.match(logServiceWhiteList) || level.match(logServiceWhiteList) : true;

      // ignore log/info/debug messages if we are not in debug mode
      if (!h5.debug && (
            level === 'log' ||
            level === 'info' ||
            level === 'debug')) {

         return angular.noop;
      }

      if (match){
         return function(){
            if (!$log[level]){
               level = 'log'; // workaround for debug in firefox
            }
            var args = Array.prototype.slice.call(arguments);
            if (caller){
               args.unshift('['+caller+']');
            }
            // NOTE: args.join returns a string containing the printed value.
            // We need this as the Selenium framework that captures the
            // console data in case of error, cannot obtain/get any argument
            // supplied to the $log call, besides the first one. So we join all
            // args into a single string value. As the log statements are most useful
            // for analysis of automated test runs using Selenium, we tailor our logging
            // to best fit the most useful use case.
            // Caveat: This means that if you are used to seeing live JS objects in
            // the browser console log - you will no longer see them as they will
            // be replaced with their string representation after the call to
            // args.join() below
            $log[level].apply($log, [args.join(" ")]);
         };
      }else {
         return angular.noop;
      }
   }

   /*
   * Returns the stack trace
   */
   function getStackTrace(){
      var err = new Error();
      return err.stack;
   }
};

}]);

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */

/**
 * Service that handles logging to the server's log.
 *
 * Example usage:
 *
 *    var logToServer = logToServerService('myDirective');
 *    logToServer.info('Linking...');
 *
 * This would log something like:
 *
 *    `[INFO ] <some_data> [H5_CLIENT][<client-id>][<username>][myDirective]: Linking...`
 */
(function() {
   'use strict';

   angular.module('com.vmware.platform.ui')
      .factory('logToServerService', logToServerService);

   logToServerService.$inject = [
      '$http',
      '$q',
      'logService',
      'userSessionService'
   ];

   function logToServerService($http, $q, logService, userSessionService) {
      var logToClient = logService('logToServerService');
      var deferredMessageTags;

      return init;

      /**
       * Binds the api to a given caller.
       *
       * @param {string} caller
       *    Sent to the server with each request to easily identify the log message's
       *    caller.
       */
      function init(caller) {
         var validatedCaller = _.isString(caller) ? caller : 'UnknownCaller';

         // Public API
         return {
            error : _.partial(log, validatedCaller, 'error'),
            warn  : _.partial(log, validatedCaller, 'warn'),
            info  : _.partial(log, validatedCaller, 'info'),
            debug : _.partial(log, validatedCaller, 'debug'),
            trace : _.partial(log, validatedCaller, 'trace')
         };
      }

      /**
       * Logs to the server.
       *
       * @param {string} caller
       *    See `init`.
       *
       * @param {string} level
       *    The log level. Can be one of the log levels exposed by the public api.
       *
       * @param {string | Object} message
       *    The log message. If type is Object, JSON.stringify is used. Note that Arrays
       *    are Objects.
       */
      function log(caller, level, message) {
         var msg;

         if (_.isString(message)) {
            msg = message;
         } else if (_.isObject(message)) {
            msg = JSON.stringify(message);
         } else {
            logToClient.warn('Log to server message was not a string nor an object.');
            return;
         }

         buildMessageTags(caller).then(function(tags) {
            $http({
               method: 'POST',
               url: 'log/',
               data: {
                  level: level,
                  message: tags + msg
               }
            });
         });
      }

      /**
       * Builds the userName, clientId and caller into tags which will be sent
       * to the server as a part of the message.
       *
       * @param {string} caller
       *    See `init`.
       */
      function buildMessageTags(caller) {
         if (deferredMessageTags) {
            return deferredMessageTags.promise;
         }

         var deferred = $q.defer();

         userSessionService.getUserSession().then(function(session) {
            var validatedSession = session ? session : {};

            var tags =
               '[' + validatedSession.clientId + ']' +
               '[' + validatedSession.userName + ']' +
               '[' + caller + ']: ';

            deferredMessageTags = deferred;
            deferredMessageTags.resolve(tags);
         }, function() {
            logToClient.error('Error getting session from userSessionService');
         });

         return deferred.promise;
      }
   }
}());

/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
/**
 * Service for validating MAC address.
 */
(function () {
   'use strict';

   angular.module('com.vmware.platform.ui').service('macAddressValidatorService', MacAddressValidatorService);

   MacAddressValidatorService.$inject = ['i18nService'];

   function MacAddressValidatorService(i18nService) {
      var SEPARATED_MAC_FORMAT = /^([0-9a-fA-F]{2}[:\-\s.]){5}[0-9a-fA-F]{2}$/;
      var MAC_ADDRESS_MAX_LENGTH = 17;
      var FORMAT_ERROR = i18nService.getString('VmUi', 'NetworkConfig.MACFormatError');

      this.validate = function(value) {
         if(!validateLength(value) || !validateFormat(value)){
            return buildResult(FORMAT_ERROR, false);
         } else {
            return buildResult(null, true);
         }
      };

      function validateLength (value) {
         return (value &&
            value.length >0 &&
            value.length <= MAC_ADDRESS_MAX_LENGTH)
            ? true : false;
      }

      function validateFormat (value) {
         return SEPARATED_MAC_FORMAT.test(value);
      }

      function buildResult (message, result) {
         return {
            error: message,
            result: result
         };
      }

      return this;
   }
})();

var platform;
(function (platform) {
    var ManagedByMessageBuilderService = (function () {
        function ManagedByMessageBuilderService($q, dataService, i18nService, defaultUriSchemeUtil, managedEntityConstants) {
            this.$q = $q;
            this.dataService = dataService;
            this.i18nService = i18nService;
            this.defaultUriSchemeUtil = defaultUriSchemeUtil;
            this.managedEntityConstants = managedEntityConstants;
            this.MANAGED_BY_INFO_PROPERTY = "managedByInfo";
            this.TEMPLATE_PROPERTY = "template";
        }
        ManagedByMessageBuilderService.prototype.buildConfirmationText = function (targetsRefs, confirmationText, withProceedMsg) {
            var _this = this;
            if (confirmationText === void 0) { confirmationText = ""; }
            if (withProceedMsg === void 0) { withProceedMsg = false; }
            if (_.isEmpty(targetsRefs)) {
                return this.$q.when();
            }
            var targetIds = this.defaultUriSchemeUtil.getVsphereObjectIds(targetsRefs);
            var managedByPropertiesPromise = this.retrieveManagedByProperties(targetIds);
            return managedByPropertiesPromise.then(function (managedByProperties) {
                return _this.buildMessage(targetIds, managedByProperties, withProceedMsg, confirmationText);
            }, function () {
                // in case the data can not be retrieved return the confirmationText as if the entity is not managed
                return confirmationText;
            });
        };
        ManagedByMessageBuilderService.prototype.buildWarningMessage = function (targetIds, withProceedMsg, managedByProperties) {
            var _this = this;
            if (withProceedMsg === void 0) { withProceedMsg = false; }
            if (managedByProperties === void 0) { managedByProperties = {}; }
            if (_.isEmpty(targetIds)) {
                return this.$q.when();
            }
            var managedByPropertiesPromise;
            if (_.isEmpty(managedByProperties)) {
                managedByPropertiesPromise = this.retrieveManagedByProperties(targetIds);
            }
            else {
                managedByPropertiesPromise = this.$q.when(managedByProperties);
            }
            return managedByPropertiesPromise.then(function (managedByProperties) {
                return _this.buildMessage(targetIds, managedByProperties, withProceedMsg);
            }, function () {
                // in case the data can not be retrieved return an empty message as if the entity is not managed
                return;
            });
        };
        ManagedByMessageBuilderService.prototype.retrieveManagedByProperties = function (targetIds) {
            var properties = [this.MANAGED_BY_INFO_PROPERTY];
            if (this.defaultUriSchemeUtil.getEntityType(targetIds[0]) === this.managedEntityConstants.VIRTUAL_MACHINE) {
                properties.push(this.TEMPLATE_PROPERTY);
            }
            return this.dataService.getPropertiesForObjects(targetIds, properties, { skipErrorInterceptor: true });
        };
        ManagedByMessageBuilderService.prototype.buildMessage = function (targetIds, managedByProperties, withProceedMsg, additionalMessage) {
            var _this = this;
            if (withProceedMsg === void 0) { withProceedMsg = false; }
            if (additionalMessage === void 0) { additionalMessage = ""; }
            var singleEntityManagedByWarning;
            var multiEntityManagedByWarning;
            switch (this.defaultUriSchemeUtil.getEntityType(targetIds[0])) {
                case this.managedEntityConstants.VIRTUAL_MACHINE:
                    singleEntityManagedByWarning = "singleVmManagedByWarning";
                    multiEntityManagedByWarning = "multiVmManagedByWarning";
                    if (managedByProperties[targetIds[0]][this.TEMPLATE_PROPERTY]) {
                        singleEntityManagedByWarning = "singleTemplateManagedByWarning";
                        multiEntityManagedByWarning = "multiTemplateManagedByWarning";
                    }
                    break;
                case this.managedEntityConstants.V_APP:
                    singleEntityManagedByWarning = "singleVAppManagedByWarning";
                    multiEntityManagedByWarning = "multiVAppManagedByWarning";
                    break;
                default:
                    singleEntityManagedByWarning = "singleEntityManagedByWarning";
                    multiEntityManagedByWarning = "multiEntityManagedByWarning";
                    break;
            }
            var warning = "";
            var suffix = additionalMessage ? "\n\n" + additionalMessage : "";
            if (withProceedMsg) {
                suffix = this.i18nService.getString("Common", "managedByWarningProceed");
            }
            if (targetIds.length === 1) {
                var managedByInfo = managedByProperties[targetIds[0]][this.MANAGED_BY_INFO_PROPERTY];
                if (managedByInfo) {
                    warning = this.i18nService.getString("Common", singleEntityManagedByWarning, managedByInfo) + suffix;
                    return warning;
                }
                return warning;
            }
            _.each(targetIds, function (targetId) {
                var managedByInfo = managedByProperties[targetId][_this.MANAGED_BY_INFO_PROPERTY];
                if (managedByInfo) {
                    warning = _this.i18nService.getString("Common", multiEntityManagedByWarning) +
                        suffix;
                    return;
                }
            });
            return warning;
        };
        ManagedByMessageBuilderService.$inject = [
            "$q",
            "dataService",
            "i18nService",
            "defaultUriSchemeUtil",
            "managedEntityConstants"
        ];
        return ManagedByMessageBuilderService;
    }());
    platform.ManagedByMessageBuilderService = ManagedByMessageBuilderService;
    angular.module("com.vmware.platform.ui")
        .service("managedByMessageBuilderService", ManagedByMessageBuilderService);
})(platform || (platform = {}));



/* Copyright 2017 VMware, Inc. All rights reserved. -- VMware Confidential */
var platform;
(function (platform) {
    /***
     * The class wraps the ng-next-app/platform/services/mutation.service.proxy
     */
    var MutationServiceWrapper = (function () {
        function MutationServiceWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(MutationServiceWrapper.prototype, "ng2MutationService", {
            get: function () {
                // Injecting mutation.proxy.service bridged from ng-next-app.
                // Using regular injection within .service('string',[...]) does not work,
                // due to race condition:
                // Downgraded NG2 modules are registered AFTER .service(..) injections are resolved
                // This way we're postponing injection till first call
                if (!this._ng2MutationService) {
                    this._ng2MutationService = this.$injector.get('vcMutationService');
                }
                return this._ng2MutationService;
            },
            enumerable: true,
            configurable: true
        });
        MutationServiceWrapper.prototype.add = function (propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.add(propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.addMulti = function (propertyObjectType, propertySpecs, operation) {
            return this.ng2MutationService.addMulti(propertyObjectType, propertySpecs, operation);
        };
        MutationServiceWrapper.prototype.apply = function (objectId, propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.apply(objectId, propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.applyByPropName = function (objectId, propertyName, data, operation) {
            return this.ng2MutationService.applyByPropName(objectId, propertyName, data, operation);
        };
        MutationServiceWrapper.prototype.applyOnMultiEntity = function (objectIds, propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.applyOnMultiEntity(objectIds, propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.applyMultiSpec = function (objectId, propertyObjectType, propertySpecs, operation) {
            return this.ng2MutationService.applyMultiSpec(objectId, propertyObjectType, propertySpecs, operation);
        };
        MutationServiceWrapper.prototype.applyMulti = function (propertyObjectType, entitySpecs, operation) {
            return this.ng2MutationService.applyMulti(propertyObjectType, entitySpecs, operation);
        };
        MutationServiceWrapper.prototype.remove = function (objectId, propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.remove(objectId, propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.removeOnMultiEntity = function (objectIds, propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.removeOnMultiEntity(objectIds, propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.validate = function (objectId, propertyObjectType, propertySpec) {
            return this.ng2MutationService.validate(objectId, propertyObjectType, propertySpec);
        };
        MutationServiceWrapper.prototype.validateSpec = function (propertyObjectType, propertySpec, operation) {
            return this.ng2MutationService.validateSpec(propertyObjectType, propertySpec, operation);
        };
        MutationServiceWrapper.prototype.validateMultiSpec = function (propertyObjectType, specObjects) {
            return this.ng2MutationService.validateMultiSpec(propertyObjectType, specObjects);
        };
        MutationServiceWrapper.prototype.validateOnMultiEntity = function (objectIds, propertyObjectType, propertySpec) {
            return this.ng2MutationService.validateOnMultiEntity(objectIds, propertyObjectType, propertySpec);
        };
        MutationServiceWrapper.$inject = ['$injector'];
        return MutationServiceWrapper;
    }());
    platform.MutationServiceWrapper = MutationServiceWrapper;
    angular.module('com.vmware.platform.ui')
        .service('mutationService', MutationServiceWrapper);
})(platform || (platform = {}));



/*jshint scripturl:true*/
(function () {
   'use strict';
   angular.module('com.vmware.platform.ui').factory('notificationService', notificationService);

   notificationService.$inject = [
      '$timeout',
      '$rootScope',
      '$location',
      'vuiConstants',
      'vuiNotificationService',
      'feedbackService',
      'responseErrorInterceptor',
      'vFeedDialogService',
      'i18nService',
      '$log'
   ];

   function notificationService(
      $timeout,
      $rootScope,
      $location,
      vuiConstants,
      vuiNotificationService,
      feedbackService,
      responseErrorInterceptor,
      vFeedDialogService,
      i18nService,
      $log) {

      var INTERNAL_SERVER_ERROR = 'Internal Server Error';

      var _warningActive = false;
      var _lastErrorOptions;
      const ERROR_DURATION = 60000;  // 60 seconds
      const TASK_ERROR_DURATION_MS = 15000;  // 15 seconds

      $rootScope.showErrorNotification = h5.isErrorPopupEnabled;
      window._rootscope = $rootScope;

      // Public API
      var service = {
         notify: notify,
         notifyError: notifyError,
         notifyTaskError: notifyTaskError,
         isWarningActive: isWarningActive,
         showLastError: showLastError,
         type: {
            INFO: vuiConstants.notifications.type.INFO,
            SUCCESS: vuiConstants.notifications.type.SUCCESS,
            WARNING: vuiConstants.notifications.type.WARNING,
            ERROR: vuiConstants.notifications.type.ERROR
         }
      };
      return service;

      // PRIVATE functions

      /**
       * @return true if an error/warning was notified less than ERROR_DURATION seconds earlier
       */
      function isWarningActive() {
         return _warningActive;
      }

      function notifyError(title, message, stack, unhandledError) {
         if (!title) {
            title = i18nService.getString('Common', 'error.jsException.title');
         }
         notify({title: title, content: message, stack: stack, unhandledError: unhandledError});
      }

      /**
       * Directly call vuiNotificationService.
       * We may want additional logic to limit the number of notifications displayed.
       * @param options
       */
      function notify(options) {
         if (!options.content) {
            options.content = '';
         }
         var content = options.content;
         var message = '';

         if (typeof content === 'string') {
            // Leave only the <%= errorMessage %> part from error.jsp (Java exception)
            var startTag = '<div id="errorMessage">';
            var indexStart = content.indexOf(startTag);
            if (indexStart > 0) {
               content = content.substring(indexStart + startTag.length, content.indexOf('</div>', indexStart));
            }
            else if (content.indexOf('<html') >= 0) {
               // Leave only the <body> content in case of other HTML message
               content = content.replace(/[\s\S]*<body>/, '');
               content = content.replace(/h1>/, 'b>');
               content = content.replace(/<img .*\/>/,'');
               content = content.replace(/<\/body>[\s\S]*/, '');
            }
            message = content;

         } else if (typeof content === 'object') {
            // Case of response error returned as a json object
            if (content.message) {
               message = content.message;
            }
            if (content.cause) {
               message += '\n' + i18nService.getString('Common', 'notification.cause', content.cause);
            }
            if (content.de_properties) {
               message += '\n\n' + i18nService.getString('Common', 'notification.properties', content.de_properties);
            }
            if (content.de_objects) {
               message += '\n\n' + i18nService.getString('Common', 'notification.objects', content.de_objects);
            }

            if (content.stackTrace && !options.stack) {
               options.stack = content.stackTrace;
            }
         } else {
            message = content.toString();
         }

         if (!options.type) {
            options.type =  vuiConstants.notifications.type.ERROR;
         }

         options.content = options.displayAsHtml ? message : _.escape(message).replace(/\n/g, '<br/>');
         if (options.type === vuiConstants.notifications.type.ERROR) {
            if (!responseErrorInterceptor.isErrorShown()) {
               handleError(options, message);
            }
         } else {
            vuiNotificationService.notify(options);
         }
      }

      // Note: message remains unescaped to be able to capture the correct data in PhoneHome
      // It is escaped in options.content which is what is being displayed.
      function handleError(options, message) {
         var localClient = ($location.host === 'localhost');

         if (!localClient && $rootScope.showErrorNotification) {
            // In line script to set the global flag showErrorNotification within the notification popup. It also
            // closes the popup automatically. Sorry, no cleaner way to do this right now...
            var setFlagScript = "javascript:_rootscope.showErrorNotification=false;" +
                  "var _elts = document.getElementsByClassName('vui-icon18-dialog-close');" +
                  "angular.element(_elts[_elts.length-1]).trigger('click');";
            var hideFutureErrors = i18nService.getString('Common', 'notification.hideFutureErrorsInThisSession.label');
            options.content += "<br/><br/><i>" +
                  "<a href=\"" + setFlagScript + "\">" + hideFutureErrors + "</a></i>";
         }

         if (!options.duration) {
            // Leave error message opened for 1 minute (vui default is 10 seconds)
            options.duration = ERROR_DURATION;
         }

         var addDetailsHere = i18nService.getString('Common', 'notification.addDetailsHere.label');
         var addDetailsNote = '\n\n(' + addDetailsHere + ')';
         if (options.title === INTERNAL_SERVER_ERROR) {
            // Less scary title than "Internal Server Error"
            options.title = i18nService.getString('Common', 'error.javaException.title');
         }

         var errorData = {
            type: 'error',
            title: options.title,
            message: message,  // unescaped on purpose
            stack: options.stack
         };

         // Errors are collected to PhoneHome automatically EXCEPT for dev runtime OR on release builds where
         // telemetry (i.e. CEIP) was disabled AND when not in debug mde.
         var collectErrors = !localClient && (h5.isTelemetryEnabled || !h5.isReleaseBuild || h5.debug);
         if (collectErrors) {
            feedbackService.sendFeedback(errorData);
         }
         if (!options.no_linkConfig) {
            var sendDetailsToVMware = i18nService.getString('Common', 'notification.sendDetailsToVMware.label');
            options.linkConfig = {
               'label': sendDetailsToVMware,
               'onClick': function () {
                  if (localClient) {
                     feedbackService.sendFeedback(errorData);
                  }
                  // Open feedback dialog to enter more information
                  $rootScope.errMessage = message + addDetailsNote;
                  $rootScope.stackTrace = errorData.stack;
                  vFeedDialogService.showFeedbackDialog(true);
               }
            };
         }
         _lastErrorOptions = options;

         // Leave a trace in the browser console from the error.
         $log.error("notificationService::handleError",
               "\nmessage = ", errorData.message,
               "\nstack = ", errorData.stack);

         // Error popup shown automatically when in debug mode OR not a release build (i.e. it's a Fling) OR not an
         // unhandled exception (i.e. a valid error to display) AND the user never clicked to hide all errors.

         var displayErrorPopup = (h5.debug || !options.unhandledError)
               && $rootScope.showErrorNotification;

         if (displayErrorPopup) {
            showLastError();
         } else {
            // This will trigger the display of a warning icon in the bottom right corner, that the
            // user can click to get the full error popup
            _warningActive = true;

            $timeout(function() {
               _warningActive = false;
            }, ERROR_DURATION);
         }
      }

      function showLastError() {
         _warningActive = false;
         vuiNotificationService.notify(_lastErrorOptions);
         updateNotificationPopupZIndex();
      }

      function updateNotificationPopupZIndex() {
         // Work-around to make error notifications appear above dialogs and wizards...
         $timeout(function () {
            var elts = document.getElementsByClassName('vui-popup vui-notification bottom-right');
            for (var i = 0; i < elts.length; i++) {
               angular.element(elts[i]).css("z-index", "1051");
            }
         }, 200);
      }

      function notifyTaskError(taskInfo) {
         if (!taskInfo) {
            return;
         }

         var content =
            '<ul class="failed-tasks-notification">' +
               '<li class="item">' +
                  '<span class="name">' + i18nService.getString('Common', 'errorTask.name') + '</span>' +
                  '<div ng-non-bindable><span class="value">' + _.escape(taskInfo.name) + '</span></div>' +
               '</li>' +
               '<li class="item">' +
                  '<span class="name">' + i18nService.getString('Common', 'errorTask.target') + '</span>' +
                  '<div ng-non-bindable><span class="value">' + _.escape(taskInfo.entityName) + '</span></div>' +
               '</li>' +
               '<li class="item">' +
                  '<span class="name">' + i18nService.getString('Common', 'errorTask.status') + '</span>' +
                  '<div ng-non-bindable><span class="value">' + _.escape(taskInfo.errorMessage) + '</span></div>' +
               '</li>' +
            '</ul>';

         var options = {
            title: i18nService.getString('CommonUi', 'notification.operationFailed2'),
            content: content,
            type: vuiConstants.notifications.type.ERROR,
            duration: TASK_ERROR_DURATION_MS,
            linkConfig: {
               label: i18nService.getString('Common', 'allTasks'),
               onClick: function() {
                  $rootScope._navigateToView('vsphere.core.tasks.domainView');
               }
            }
         };

         vuiNotificationService.notify(options);
         updateNotificationPopupZIndex();
      }
   }
}());

var platform;
(function (platform) {
    /**
     * Wrapper over downgraded service \vim-clients\applications\h5\ng-next-app\src\app\platform\services\format\number-formatter.service.ts
     */
    var NumberFormatterServiceWrapper = (function () {
        function NumberFormatterServiceWrapper($injector) {
            this.$injector = $injector;
        }
        Object.defineProperty(NumberFormatterServiceWrapper.prototype, "downgradedNumberFormatterService", {
            get: function () {
                if (!this._downgradedNumberFormatterService) {
                    this._downgradedNumberFormatterService = this.$injector.get('vcNumberFormatterService');
                }
                return this._downgradedNumberFormatterService;
            },
            enumerable: true,
            configurable: true
        });
        NumberFormatterServiceWrapper.prototype.format = function (num, options /*NumberOptions*/) {
            return this.downgradedNumberFormatterService.format(num, options);
        };
        NumberFormatterServiceWrapper.prototype.formatStorage = function (num, sourceUnit, targetUnit, fractionSize) {
            return this.downgradedNumberFormatterService.formatStorage(num, sourceUnit, targetUnit, fractionSize);
        };
        NumberFormatterServiceWrapper.prototype.formatBandwidth = function (num, sourceUnit, targetUnit, precision, trimTrailingZeroes) {
            return this.downgradedNumberFormatterService.formatBandwidth(num, sourceUnit, targetUnit, precision, trimTrailingZeroes);
        };
        NumberFormatterServiceWrapper.$inject = ['$injector'];
        return NumberFormatterServiceWrapper;
    }());
    platform.NumberFormatterServiceWrapper = NumberFormatterServiceWrapper;
    angular.module('com.vmware.platform.ui')
        .service('numberFormatterService', NumberFormatterServiceWrapper);
})(platform || (platform = {}));



/* Copyright 2015 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';

   angular
         .module('com.vmware.platform.ui')
         .factory('objectTypesService', objectTypesService);

   objectTypesService.$inject = ['$http'];

   /*
    * Service for retrieving ObjectTypeSpec registered for the given object type.
    */
   function objectTypesService ($http) {

      // --------------- public APIs  ----------------
      var service = {
         getObjectTypeSpec: _.memoize(getObjectTypeSpec),
         getAllObjectTypeSpecs: _.memoize(getAllObjectTypeSpecs)
      };

      var URLS = {
         fetchObjectTypeSpec: function(objectType) {
            return 'objectTypes/' + objectType + '/';
         },
         fetchAllObjectTypeSpecs: function () {
            return 'objectTypes/';
         }
      };

      return service;

      // --------------- API implementation ----------------

      function get(url, params) {
         return $http.get(url, {params: params}).then(function(result) {
            return result.data;
         });
      }

      function getObjectTypeSpec(objectType) {
         var url = URLS.fetchObjectTypeSpec(objectType);
         var params = [];
         return get(url, params);
      }

      function getAllObjectTypeSpecs() {
         var url = URLS.fetchAllObjectTypeSpecs();
         return get(url);
      }
   }
})();
/* Copyright 2016 VMware, Inc. All rights reserved. -- VMware Confidential */
(function() {
   'use strict';

   angular
      .module('com.vmware.platform.ui')
      .factory('periodicRefreshService', periodicRefreshService);

   periodicRefreshService.$inject = ['$rootScope', 'dataService', 'vcService',
      'vcH5ConstantsService', 'configurationService', 'vxZoneService'];

   /**
    * This service provides periodic refresh for all views
    * when some properties of the context object change. This service works only for
    * vCenter 6.0 managed entities.
    * This service should not be injected by anyone. It is initialized on
    * application level.
    *
    * Service polls for changes in generation number of context object. If a change is
    * detected, it will broadcast modelChanged event.
    */
   function periodicRefreshService ($rootScope, dataService, vcService,
                                    vcH5ConstantsService, configurationService, vxZoneService) {

      var periodicRefreshIntervalId = null;

      var lastKnownGenerationNumber;

      var contextObject;

      // Default poll interval is 20 sec. Could be overridden in webclient.properties
      // file see vc60.periodic.refresh.rate property.
      var pollInterval = 20000;

      var PERIODIC_REFRESH_SERVICE = 'periodicRefreshService';

      // --------------- public APIs  ----------------
      var service = {
         init: init
      };

      // --------------- API implementation ----------------

      function init() {
         configurationService.getProperty('vc60.periodic.refresh.rate').then(
            function(rawRefreshRate) {
               var refreshRate = parseInt(rawRefreshRate, 10);
               if (refreshRate === -1) {
                  // Disable periodic refresh
                  return;
               }

               if (refreshRate.toString() === rawRefreshRate && refreshRate > 10) {
                  pollInterval = refreshRate * 1000;
               }
               subscribeForContextObjectChange();
            }, function() {
               // ignore error and proceed with default poll interval
               subscribeForContextObjectChange();
            }
         );
      }

      function subscribeForContextObjectChange() {
         $rootScope.$watch(
            function () {
               return $rootScope._route.objectId;
            },
            function (newValue) {
               startPeriodicRefresh(newValue);
            });
         $rootScope.$on(vcH5ConstantsService.MODEL_CHANGED_EVENT, onModelChanged);
      }

      function clearPeriodicRefreshInterval(){
         vxZoneService.runOutsideAngular(function() {
            if (periodicRefreshIntervalId !== null) {
               clearInterval(periodicRefreshIntervalId);
               periodicRefreshIntervalId = null;
            }
         });
      }

      function startPeriodicRefresh(objectId) {
         clearPeriodicRefreshInterval();
         lastKnownGenerationNumber = 0;
         if(!objectId || !vcService.isValidManagedEntityId(objectId)) {
            contextObject = null;
            return;
         }
         vcService.is65VcOrLater(objectId).then(function(is65VcOrLater) {
            if (!is65VcOrLater) {
               contextObject = objectId;
               monitorForObjectChange(objectId);
               vxZoneService.runOutsideAngular(function() {
                  periodicRefreshIntervalId =
                     setInterval(monitorForObjectChange, pollInterval, objectId);
               });
            } else {
               contextObject = null;
            }
         });
      }

      function monitorForObjectChange(objectId) {
         if (!objectId) {
            return;
         }
         getGeneration(objectId).then(
            function(data) {
               var currentGenerationNumber;
               if (data.hasOwnProperty('@generation') && data['@generation'].length > 0) {
                  if (data['@generation'][0].key === contextObject) {
                     currentGenerationNumber = data['@generation'][0].value;
                  } else {
                     // Context object has changed while retrieving data for previous
                     // context object. Just invalidate this request.
                     return;
                  }
               } else {
                  // Object has been deleted.
                  // No need to continue polling
                  contextObject = null;
                  clearPeriodicRefreshInterval();
                  // No need to notify for changes
                  return;
               }
               if (contextObject && lastKnownGenerationNumber &&
                     currentGenerationNumber !== lastKnownGenerationNumber) {
                  var changeInfo = {
                     operationType: 'CHANGE',
                     objectId: contextObject,
                     source: PERIODIC_REFRESH_SERVICE
                  };
                  vxZoneService.runInsideAngular(function() {
                     $rootScope.$broadcast(vcH5ConstantsService.MODEL_CHANGED_EVENT, changeInfo);
                  });
               }
               lastKnownGenerationNumber = currentGenerationNumber;
            }
         );

      }

      function getGeneration(objectId) {
         return dataService.getProperties(objectId, ['@generation']);
      }

      function onModelChanged (event, objectChangeInfo) {
         if (objectChangeInfo.source === PERIODIC_REFRESH_SERVICE ||
               objectChangeInfo.objectId !== contextObject) {
            // avoid self looping and changes on non context object
            return;
         }
         if (contextObject) {
            // Restart object change monitor for context object
            startPeriodicRefresh(contextObject);
         }
      }

      $rootScope.$on('$destroy', function(){
         clearPeriodicRefreshInterval();
      });

      return service;
   }
})();

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/*
 * Service for retrieving and persisting remote data.
 */
angular.module('com.vmware.platform.ui').factory('persistenceService', ['$http',
function($http) {

   function get(url, params) {
      return $http.get(url, {params: params}).then(function(result) {
         if (result) {
            return result.data;
         }
         return [];
      });
   }

   function post(url, data) {
      return $http.post(url, data).then(function(result) {
         return result.data;
      });
   }

   function remove(url, params) {
      return $http.delete(url, {params: params}).then(function(result) {
          return result.data;
      });
   }

   function isNullOrEmptyString(str) {
      if (!str || !str.replace(/^\s+|\s+$/g,'')) {
         return true;
      }
      return false;
   }

   return {

      /**
       * Get the metadata by specifying the search condition and the path.
       * The condition object must look like this:
       * {
       *    "key":"<some key>", // e.g. com.vmware.usersettings.category.uid
       *    "op":"=",
       *    "value":"<some value>" // e.g. com.vmware.usersetting.savedsearches
       * }
       * The path is optional.
       */
      getMetadata: function(conditionObj, path) {
         path = path || "";
         var params = {
            "key" : conditionObj.key,
            "value" : conditionObj.value,
            "op" : conditionObj.op,
            "path" : path
         };
         var url = "persistence/metadata/";
         return get(url, params);
       },

       /**
        * Get the data for the setting by specifying the search condition and the path.
        * The condition object must look like this:
        * {
        *    "key":"<some key>", // e.g. "com.vmware.usersettings.uid""
        *    "op":"=",
        *    "value":"<some value>" // e.g. "80501CE2-A5A7-00EB-FF1A-0146AA9EEEE9"
        * }
        * The path is optional.
        */
      getData : function(conditionObj, path) {
         path = path || "";
         var params = {
            "key" : conditionObj.key,
            "value" : conditionObj.value,
            "op" : conditionObj.op,
            "path" : path
         };
         var url = "persistence/data/";
         return get(url, params);
      },

      /**
       * Set the data for the setting.
       * @param uid The unique id for the setting.
       * @param value The serialized value to be stored.
       * @param addtionalData Object which has additional data to be saved along with the value.
       * @param categoryId The category to which the setting.
       *    belongs to. e.g. com.vmware.usersetting.savedsearches.
       * @param contentType The content type of the data. This field is optional.
       *   Valid values are "CONTENT_TYPE_XML", "CONTENT_TYPE_BINARY", "CONTENT_TYPE_TEXT", "CONTENT_TYPE_JSON".
       */
      setData : function(uid, value, additionalData, categoryId, contentType) {
         if (isNullOrEmptyString(uid) || !value || isNullOrEmptyString(categoryId)) {
            return;
         }

         // Add category info to metadata
         additionalData["com.vmware.usersettings.category.uid"] = categoryId;
         additionalData["uid"] = uid;
         additionalData["com.vmware.usersettings.uid"] = uid;

         var metadata = {
            uid : uid,
            additionalData : additionalData,
         };

         var userData = {
            contentType : contentType,
            metadata : metadata,
            value : value
         };
         var url = "persistence/save/";
         return post(url, userData);
      },

      /**
       * Removes the data based on the setting uid.
       * @param uid The array of uid of the setting to remove.
       */
      removeData: function(uid) {
         var url = "persistence/remove/";
         var params = {
           uid: uid
         };
         return remove(url, params);
      },

      /**
       * Resets the user's persisted data.
       */
      reset: function() {
         var url = "persistence/reset/";
         return remove(url);
      }
   };
}]);

/* Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential */
/* TODO mtonev: Remove devel once we have better error reporting */
/*jshint bitwise: false, devel:true */
/*
 * Service that exposes the platform api to plugins using a different h5 technology
 * like extJs etc.  Their views are sandboxed into an iFrame and they can access apis through
 * the WEB_PLATFORM global object.
 *
 * WEB_PLATFORM also allows to support 6.0 plugins built using the SDK's Html Bridge.
 * See doc at http://vmweb.vmware.com/~ldelamar/NGC-SDK-6.0.0/html-bridge/docs/html-bridge.html
 *
 * Plugins are distributed with a web-platform.js which extends the WEB_PLATFORM object created here
 * with more functions: getObjectId, getActionUid, getActionTargets and getVcSelectorInfo.
 * They do not have to be implemented here as they would be overwritten later.
 */

//global vSphereClientSDK exposed in to the browser window
window.vSphereClientSDK = {};

var WEB_PLATFORM = (function() {
   'use strict';
   // Angular's rootScope.
   var rootScope = null;
   var htmlBridgeService = null;
   var platformNgZone = null;

   var refreshMap = {};

   var platformService = {
      /**
       * Passes in any angular service that is required by htmlBridgeService.
       * @internal
       */
      onAngularLoad: function(rs, ds, hbs, $window) {
         rootScope = rs;
         this.dataService = ds;
         htmlBridgeService = hbs;
         //save the current ng zone to be used later
         platformNgZone = window.Zone.current;
         if (platformNgZone.name !== "angular") {
            console.warn("The web platform APIs run outside the angular ng zone.");
         }

         //bootstrap the ability to provide the API to the plugins
         bootstrapWebPlatformApi($window);

         rootScope.$on('dataRefreshInvocationEvent', handlePluginsGlobalRefresh);
         rootScope.domXmlSerializer = new XMLSerializer();
      },

      // -------------------------- Public APIs --------------------------------

      /**
       * DataService instance to fetch data.
       */
      dataService: null,

      /**
       * Get the localized string for the given key.
       */
      getString: function(bundleName, key, params) {
         var args = [bundleName, key];
         if (angular.isDefined(params)) {
            args = args.concat(params);
         }
         return rootScope.i18n.apply(rootScope, args);
      },

      apply: function(fn) {
         rootScope.$apply(fn);
      },

      /**
       * Get the root of the web plugin context path.
       * This is also defined in NGC 6.5.
       * For NGC this is defined directly in web-platform.js in each plugin code
       */
      getRootPath: function() {
         return "/ui";
      },

      /**
       * Get the current client type.
       * This is also defined in NGC 6.5.