angular.module('com.vmware.platform.ui').run(['$templateCache', function($templateCache) {$templateCache.put('resources/ui/components/action-bar/action-bar.component.html','<!-- Action bar template that uses vui style action bar with ability to add clarity icon -->\r\n<div  ng-if="!$ctrl.clrTemplate" class="vui-action-bar clr-action-bar">\r\n   <ul>\r\n      <!-- loop over each action -->\r\n      <li id="{{action.id}}"\r\n            ng-repeat="action in $ctrl.options.actions track by $index"\r\n            ng-if="$ctrl.isVisible(action)">\r\n         <span ng-if="$ctrl.isSeparator(action)" class="vui-actionbar-separator"></span>\r\n         <!-- applying a disabled class-->\r\n         <a ng-if="!$ctrl.isSeparator(action) && $ctrl.hasLabel(action)"\r\n               ng-class="{disabled: $ctrl.isDisabled(action)}"\r\n               class="action-link-container"\r\n               title="{{action.tooltipText && action.tooltipText.trim().length ?\r\n                        action.tooltipText : action.label}}"\r\n               ng-click="$ctrl.clickAction($event,action)"\r\n               href="">\r\n            <clr-icon ng-if="$ctrl.hasClarityIcon(action)" size="18" ng-attr-shape="{{action.shape}}"></clr-icon>\r\n            <span ng-if="!$ctrl.hasClarityIcon(action) && action.iconClass"\r\n                  class="vui-icon-placeholder {{action.iconClass}}">\r\n            </span>\r\n            <span ng-if="action.label" class="vui-action-label">{{action.label}}</span>\r\n            <span ng-if="action.isMenu" class="caret"></span>\r\n         </a>\r\n      </li>\r\n   </ul>\r\n</div>\r\n<!-- Action bar that uses clarity buttons -->\r\n<div ng-if="$ctrl.clrTemplate" class="vui-action-bar clr-action-bar">\r\n   <div class="btn-group">\r\n      <!-- loop over each action -->\r\n      <div ng-repeat="action in $ctrl.options.actions track by $index"\r\n            ng-if="$ctrl.isVisible(action)">\r\n         <span ng-if="$ctrl.isSeparator(action)" class="vui-actionbar-separator"></span>\r\n         <!-- applying a disabled class-->\r\n         <button id="{{action.id}}" ng-if="!$ctrl.isSeparator(action) && $ctrl.hasLabel(action)"\r\n               ng-class="{disabled: $ctrl.isDisabled(action)}"\r\n               class="btn btn-sm btn-link clr-no-border-button"\r\n               title="{{action.tooltipText && action.tooltipText.trim().length ?\r\n                        action.tooltipText : action.label}}"\r\n               ng-click="$ctrl.clickAction($event,action)">\r\n            <clr-icon ng-if="$ctrl.hasClarityIcon(action)" size="18"\r\n                  ng-attr-shape="{{action.shape}}"></clr-icon>\r\n            <span ng-if="!$ctrl.hasClarityIcon(action) && action.iconClass"\r\n                  class="vui-icon-placeholder {{action.iconClass}}">\r\n            </span>\r\n            <span ng-show="action.label" class="vui-action-label">{{action.label}}</span>\r\n            <span ng-if="action.isMenu" class="caret"></span>\r\n         </button>\r\n      </div>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/activityIndicator/vxActivityIndicator.html','<div class="center-dialog-content" ng-show="isVisible" ng-class="{\'block-input\': !isInteractive}"\r\n     role="alert" aria-live="assertive"\r\n     aria-label="{{loadingAriaLabel ? loadingAriaLabel : title}}">\r\n <span ng-switch="size">\r\n    <span ng-switch-when="medium" class="spinner spinner-md"></span>\r\n    <span ng-switch-when="large" class="spinner spinner-lg"></span>\r\n    <span ng-switch-default class="spinner spinner-inline"></span>\r\n </span>\r\n <span class="word-break-margin" ng-if="title" ng-bind="title" aria-hidden="true"></span>\r\n</div>\r\n<div ng-transclude></div>');
$templateCache.put('resources/ui/components/alert/vxAlertTemplate.html','<div ng-show="vxAlert.visible" >\r\n   <div class="vx-modal-backdrop"></div>\r\n   <div class="vx-alert-modal" vxDraggable>\r\n      <div class="vx-modal-titlebar">\r\n         <span class="vx-modal-header">\r\n            {{vxAlert.title}}\r\n         </span>\r\n      </div>\r\n      <div class="vx-alert-body">\r\n         <div ng-if="vxAlert.icon" class="vx-alert-icon pull-left">\r\n            <span ng-class="vxAlert.icon"></span>\r\n         </div>\r\n         <div class="vx-alert-text" ng-bind="vxAlert.htmlSafe"></div>\r\n      </div>\r\n      <div class="vx-alert-footer">\r\n         <span>\r\n            <!-- Cancel button -->\r\n            <button class="btn reject-button"\r\n                    ng-disabled="isRejectDisabled()"\r\n                    ng-click="onRejectClick()"\r\n                    ng-show="isRejectVisible()">\r\n               {{getRejectText()}}\r\n            </button>\r\n         </span>\r\n         <span>\r\n            <!-- Ok button -->\r\n            <button class="btn btn-primary confirm-button"\r\n                    ng-disabled="isConfirmDisabled()"\r\n                    ng-click="onConfirmClick()"\r\n                    ng-show="isConfirmVisible()">\r\n                  {{getConfirmText()}}\r\n            </button>\r\n         </span>\r\n    </div>\r\n  </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/datastore-file-browser/datastore-file-browser.html','<div>\r\n   <div vui-splitter="$ctrl.splitterOptions" class="fill-parent iso-chooser-splitter">\r\n      <div class="chooser-panel folder-chooser">\r\n         <div class="chooser-panel-title"><b>{{$ctrl.i18n(\'Common\', \'dsBrowser.datastores\')}}</b></div>\r\n         <div class="chooser-panel-content flexbox">\r\n            <div class="scrollableDatastoreBrowserTree flex-auto"\r\n               datastore-browser-tree\r\n               object-ref="$ctrl.objectId"\r\n               datastores="$ctrl.datastoreIds"\r\n               file-query-type="$ctrl.fileQueryType"\r\n               show-vm-images-folder="$ctrl.showVmImagesFolder"\r\n               on-selected-item-changed="$ctrl.selectedTreeItemChanged(selectedTreeItem)"\r\n               on-selected-item-files-loaded="$ctrl.selectedTreeItemFilesLoaded(selectedTreeItemContentFiles)"\r\n               accessor="$ctrl.dsBrowserTreeAccessor">\r\n            </div>\r\n         </div>\r\n      </div>\r\n      <div class="chooser-panel file-chooser">\r\n         <div class="chooser-panel-title"><b>{{$ctrl.i18n(\'Common\', \'dsBrowser.contents\')}}</b></div>\r\n         <div data-test-id="conent-files" class="chooser-panel-content">\r\n            <vx-activity-indicator is-visible="$ctrl.areContentItemsLoading"\r\n               title="{{::$ctrl.i18n(\'Common\', \'loadingTitle\')}}"></vx-activity-indicator>\r\n            <ul>\r\n               <li ng-repeat="item in $ctrl.contentItems"\r\n                  ng-click="$ctrl.selectedContentItemChanged(item)"\r\n                  ng-class="{selected: !!$ctrl.selectedFile && item.path === $ctrl.selectedFile.path}">\r\n                  <span class="{{item.spriteCssClass}}"></span><span>{{item.friendlyName ? item.friendlyName : item.name}}</span>\r\n               </li>\r\n            </ul>\r\n         </div>\r\n      </div>\r\n      <div class="chooser-panel file-information">\r\n         <div class="chooser-panel-title"><b>{{$ctrl.i18n(\'Common\', \'dsBrowser.information\')}}</b></div>\r\n         <div class="chooser-panel-content" ng-if="$ctrl.isDatastoreItemSelected() && !$ctrl.isFileItemSelected()">\r\n            <div><span>{{$ctrl.i18n(\'Common\', \'dsBrowser.name\')}}</span><span>{{$ctrl.selectedTreeItem.name}}</span></div>\r\n            <div><span>{{$ctrl.i18n(\'Common\', \'dsBrowser.capacity\')}}</span><span>{{$ctrl.selectedTreeItem.totalCapacity}}</span></div>\r\n            <div><span>{{$ctrl.i18n(\'Common\', \'dsBrowser.freeSpace\')}}</span><span>{{$ctrl.selectedTreeItem.availableCapacity}}</span></div>\r\n         </div>\r\n         <div class="chooser-panel-content" ng-if="$ctrl.isFolderItemSelected() && !$ctrl.isFileItemSelected()">\r\n            <div><span>{{$ctrl.i18n(\'Common\', \'dsBrowser.name\')}} </span><span>{{$ctrl.selectedTreeItem.name}}</span></div>\r\n            <span>{{$ctrl.i18n(\'Common\', \'dsBrowser.modified\')}} </span><span>{{$ctrl.selectedTreeItem.lastModified | dateLocale }}</span>\r\n         </div>\r\n         <div class="chooser-panel-content" ng-if="$ctrl.isFileItemSelected()">\r\n            <div><span>{{$ctrl.i18n(\'Common\', \'dsBrowser.name\')}} </span><span>{{$ctrl.selectedFile.name}}</span></div>\r\n            <div><span>{{$ctrl.i18n(\'Common\', \'dsBrowser.size\')}}</span><span>{{$ctrl.selectedFile.size | bytes:\'B\'}}</span></div>\r\n            <div><span>{{$ctrl.i18n(\'Common\', \'dsBrowser.modified\')}}</span><span>{{$ctrl.selectedFile.lastModified | dateLocale}}</span></div>\r\n            <div data-test-id="encryption-info">\r\n               <span>{{$ctrl.i18n(\'Common\', \'dsBrowser.encrypted\')}}</span>\r\n               <span ng-bind="$ctrl.selectedFile.isEncrypted ? $ctrl.i18n(\'Common\', \'dsBrowser.EncryptedYes\') : $ctrl.i18n(\'Common\', \'dsBrowser.EncryptedNo\')"></span>\r\n            </div>\r\n         </div>\r\n      </div>\r\n   </div>\r\n   <div class="ptm" ng-if="$ctrl.selectedFileQueryType"><b>{{$ctrl.i18n(\'Common\', \'dsBrowser.fileType\')}}</b>\r\n      <select\r\n         name="fileQueryTypes"\r\n         ng-model="$ctrl.selectedFileQueryType"\r\n         ng-options="item as item.label for item in $ctrl.filterFileQueryTypes track by item.value"\r\n         ng-change="$ctrl.fileQueryTypeChange($ctrl.selectedFileQueryType)">\r\n      </select>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/diskFormatSelector/diskFormatSelector.html','<div class="select">\r\n   <select class="disk-format-selector"\r\n           aria-labelledby="{{ctrlAriaLabeledBy}}"\r\n           ng-disabled="readOnly || isDisabled"\r\n           ng-model="selectedFormat"\r\n           ng-options="diskFormat as diskFormat.name for diskFormat in diskFormats track by diskFormat.type">\r\n   </select>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/forms/vxValueInUnits.html','<div ng-form name="ctrl.valueInUnitsForm" class="value-in-units">\r\n   <div class="vui-dropdown rich-combo-box input-container">\r\n      <input name="quantity"\r\n             data-quantity-for="{{::ctrl.name}}"\r\n             type="{{::ctrl.type}}"\r\n             step="any"\r\n             class="edit-setting-input spinfree"\r\n             ng-model="ctrl.selection.quantity"\r\n             ng-change="ctrl.updateModelFromFields(ctrl.selection.quantity, ctrl.selection.unit)"\r\n             vx-error="ctrl.vxErrorConfig"\r\n             ng-class="{\'has-error\': ctrl.valueInUnitsForm.quantity.$invalid}"\r\n             allowed-characters="{{::ctrl.allowedCharacters}}"\r\n             ng-disabled="ctrl.isDisabled"\r\n             aria-label="{{::ctrl.quantityAriaLabel}}"\r\n             required/>\r\n      <div class="input-group-btn" ng-if="ctrl.recommendedValues && !ctrl.isDisabled">\r\n         <button class=\'dropdown-toggle\'\r\n                 ng-click="ctrl.clickDropdownButton()"\r\n                 aria-label="{{::ctrl.quantityCaretAriaLabel}}"\r\n                 aria-expanded="ctrl.properties.recommendedValuesExpanded"\r\n                 aria-haspopup="listbox">\r\n            <span class="caret"></span>\r\n         </button>\r\n      </div>\r\n      <table role="listbox" ng-if="ctrl.properties.recommendedValuesExpanded" class="recommended-values" tabindex="-1">\r\n         <tr ng-click="ctrl.setModelValue(recommendation); ctrl.properties.recommendedValuesExpanded = false"\r\n             ng-repeat="recommendation in ctrl.recommendedValues"\r\n             ng-class="{highlighted: recommendation.isHighlighted}"\r\n             role="option"\r\n             class="recommended-value">\r\n            <td>{{::recommendation.name}}</td>\r\n            <td>{{::recommendation.formattedValue || recommendation.value}}</td>\r\n         </tr>\r\n      </table>\r\n   </div>\r\n   <div class="select" ng-if="ctrl.showUnits">\r\n      <select name="unit"\r\n              data-unit-for="{{::ctrl.name}}"\r\n              ng-options="unit.label for unit in ctrl.unitOptions"\r\n              ng-model="ctrl.selection.unit"\r\n              ng-change="ctrl.updateModelFromFields(ctrl.selection.quantity, ctrl.selection.unit)"\r\n              ng-disabled="ctrl.isDisabled"\r\n              aria-label="{{::ctrl.unitAriaLabel}}">\r\n      </select>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/macAddressControl/macAddressControl.html','<span ng-form name="ctrl.macAddressForm">\r\n   <input\r\n      type="text"\r\n      name="macAddressInput"\r\n      aria-label="{{::ctrl.ARIA_LBL_MAC}}"\r\n      ng-model="ctrl.assignedMacAddress"\r\n      class="edit-setting-input"\r\n\r\n      ng-disabled="ctrl.disabled || ctrl.isAutomatic"\r\n      vx-error="ctrl.macAddressValidateErrorConfig"\r\n      ng-class="{ \'has-error\' : ctrl.macAddressForm.macAddressInput.$invalid }"\r\n      ng-change="ctrl.validateMacAddress()" />\r\n</span>\r\n\r\n<span class="select">\r\n   <select\r\n      ng-model="ctrl.selectedOption"\r\n      ng-change="ctrl.onSelectionChange()"\r\n      ng-options="option.label for option in ctrl.dropDownOptions track by option.id"\r\n      ng-disabled="ctrl.disabled"\r\n      aria-label="{{::ctrl.ARIA_LBL_MAC_TYPE}}"\r\n   ></select>\r\n</span>\r\n');
$templateCache.put('resources/ui/components/masterdetails/vxMasterDetailsComponent.html','<div class="fill-parent vx-master-details-view" ng-class="{\'vx-master-details-hide-splitter\': !$ctrl.isResizable}">\r\n   <div class="flex-column fill-parent storage-vui-splitter"\r\n        vui-splitter="$ctrl.splitterOptions"\r\n        vx-vui-splitter-resize-notifier="masterDetailsViewContext">\r\n      <!-- Master list view -->\r\n      <div class="flex-grow-auto relative-container">\r\n         <div class="absolute-container fill-parent">\r\n            <div class="fill-parent" ng-include="$ctrl.masterViewTemplateUrl"/>\r\n         </div>\r\n      </div>\r\n\r\n      <div class="flex-grow-auto relative-container">\r\n         <div class="absolute-container master-details-details-container">\r\n            <!-- No items selected -->\r\n            <div class="fill-parent"\r\n                 ng-if="!masterDetailsViewContext.selectedItems || masterDetailsViewContext.selectedItems.length === 0">\r\n               <vx-no-items-selected message="$ctrl.noItemsSelectedWarning"/>\r\n            </div>\r\n\r\n            <!-- Multiple items selected -->\r\n            <div class="fill-parent"\r\n                 ng-if="masterDetailsViewContext.selectedItems && masterDetailsViewContext.selectedItems.length > 1">\r\n                  <vx-no-items-selected message="$ctrl.multipleItemsSelectedWarning"/>\r\n            </div>\r\n\r\n            <!-- Default Tabbed details view-->\r\n            <div class="fill-parent"\r\n                 ng-include="$ctrl.detailsViewTemplateUrl"\r\n                 ng-if="masterDetailsViewContext.selectedItems && masterDetailsViewContext.selectedItems.length === 1">\r\n            </div>\r\n         </div>\r\n      </div>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/masterdetails/vxMasterDetailsView.html','<div ng-controller="vxMasterDetailsViewController as ctrl"\r\n     class="fill-parent vx-master-details-view">\r\n   <vx-master-details-component ng-if="ctrl.detailsViewTemplateUrl && ctrl.masterViewTemplateUrl"\r\n                                class="fill-parent"\r\n                                master-view-template-url="{{::ctrl.masterViewTemplateUrl}}"\r\n                                master-details-view-context="masterDetailsViewContext"\r\n                                details-view-template-url="{{::ctrl.detailsViewTemplateUrl}}">\r\n   </vx-master-details-component>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/masterdetails/vxSingleExtensionTab.html','<div ng-controller="vxSingleExtensionTabController as ctrl" class="fill-parent">\r\n   <div class="fill-parent" ng-include="ctrl.viewTemplateUrl"/>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/masterdetails/vxTabbedDetailsView.html','<div ng-controller="vxTabbedDetailsViewController as ctrl" class="fill-parent">\r\n   <vx-tabbed-view ng-if="ctrl.tabs"\r\n                   tabs="ctrl.tabs"\r\n                   selected-tab="ctrl.selectedTab"\r\n                   control="ctrl.tabViewApi"\r\n                   params="{masterDetailsViewContext : masterDetailsViewContext}"\r\n                   class="fill-parent">\r\n   </vx-tabbed-view>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/menu/vxMenuTemplate.html','<!-- Copyright 2013 VMware, Inc. All rights reserved. VMware Confidential -->\r\n<ul class="actions-menu" ng-click="clickHandler($event)"\r\n      ng-show="vxMenu.showMenu" vx-document-click="vxMenu.onDismissMenuEvent($event)"\r\n      ng-style="styles">\r\n   <li class="disabled actions-menu-header" ng-show="vxMenu.header.show">\r\n      <span class="vui-icon {{vxMenu.header.icon}}"></span>\r\n      <span title="{{vxMenu.header.label}}">{{vxMenu.header.label}}</span>\r\n   </li>\r\n   <li ng-repeat="item in vxMenu.menuItems track by $index"\r\n         class="{{isDivider(item) ? \'divider\' : \'\'}}" id="{{item.id}}"\r\n         ng-class="item.enabled ? \'\' : \'disabled\'">\r\n      <a ng-if="!isDivider(item)">\r\n         <span class="vui-icon {{item.icon}}"></span>\r\n         <span>{{item.label}}</span>\r\n      </a>\r\n   </li>\r\n</ul>\r\n');
$templateCache.put('resources/ui/components/meter/vxResourceMeter.html','<div title="{{percentage}}%" class="{{orientation}}-resource-meter">\r\n   <div class="meter-gauge">\r\n      <span ng-style="{ \'width\' : percentage+\'%\' }"\r\n            class="meter-gauge-value"\r\n            ng-class="(percentage > 80) ? \'resource-meter-usage-danger\'\r\n                     :(percentage > 60) ? \'resource-meter-usage-warning\'\r\n                     :\'resource-meter-usage-normal\'"></span>\r\n   </div>\r\n</div>');
$templateCache.put('resources/ui/components/modal/modalTitle.html','<div class="primaryTitle" ng-bind="primaryTitle"\r\n     ng-class=" secondaryTitle ? \'\' : \'secondaryTitleIsEmpty\' "\r\n     ng-attr-title="{{ primaryTitle }}"></div>\r\n<div class="separator" ng-show="secondaryTitle"></div>\r\n<div class="h5 secondaryTitle" ng-bind="secondaryTitle"\r\n     ng-attr-title="{{ secondaryTitle }}"></div>\r\n');
$templateCache.put('resources/ui/components/objectselector/browseTab.html','<div class="word-wrap" ng-if="config.treeTabConfig.caption">{{config.treeTabConfig.caption}}</div>\r\n<div\r\n        vx-tree-view\r\n        tree-id="{{treeConfig.treeId}}"\r\n        root-obj-ref="treeConfig.rootObjRef"\r\n        on-change="onTreeSelectionChanged(item)"\r\n        config="treeConfig"\r\n        select-node="treePreselectedNode"\r\n>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/objectselector/filterTab.html','<div ng-if="filterTabOptions" vui-tabs="filterTabOptions"></div>\r\n');
$templateCache.put('resources/ui/components/objectselector/selectObjectsTab.html','<div ng-if="tab.gridOpts"\r\n     vui-datagrid="tab.gridOpts"\r\n     vx-stretch-grid\r\n     id="selected-objects"\r\n     class="fill-parent flex-grid">\r\n</div>');
$templateCache.put('resources/ui/components/objectselector/tabContent.html','<list-view ng-if="!tab.deferInstantiation"\r\n           list-view-id="{{tab.listViewId}}"\r\n           object-id="tab.contextObject"\r\n           right-clickable="false"\r\n           navigatable="false"\r\n           on-selection-changed="tab.onSelectionChanged(newItems, oldItems)"\r\n           selection-mode={{tab.selectionMode}}\r\n           filter-id="{{ tab.filterId }}"\r\n           filter-params="tab.filterParams"\r\n           property-params="tab.propertyParams"\r\n           relation-id="tab.relationId"\r\n           data-models="tab.dataModels"\r\n           show-filter="true"\r\n           class="fill-parent flex-grid"\r\n           preselect-comparator="tab.preselectComparator(item)"\r\n           use-persistent-selection-context="false"\r\n           show-loading-indicator-while-fetching-columns="{{tab.showLoadingIndicatorWhileFetchingColumns}}"\r\n           loading-indicator-size="{{tab.loadingIndicatorSize}}">\r\n</list-view>\r\n');
$templateCache.put('resources/ui/components/objectselector/vxObjectSelector.html','<div ng-if="primaryTabOptions" vui-tabs="primaryTabOptions"></div>');
$templateCache.put('resources/ui/components/portlet/portlets.html','<div class="vx-portlets">\r\n    <div class="col"\r\n        ng-repeat="column in columns"\r\n        ui-sortable="sortableOptions"\r\n        ng-model="column">\r\n\r\n        <div class="vx-portlet"\r\n            ng-repeat="portlet in column track by portlet._view.uid"\r\n            portlet-id="{{portlet._view.uid}}"\r\n            ng-class="portlet.collapsed ? \'collapsed\' : \'\'">\r\n\r\n            <div class="portlet-titlebar"\r\n                ng-click="toggleCollapsed(portlet, $event)"\r\n                role="button"\r\n                aria-expanded="{{portlet.collapsed ? \'false\' : \'true\'}}"\r\n                aria-controls="{{portlet._view.uid}}-panel">\r\n                <span class="arrow">\r\n                    <svg height="20" viewBox="0 0 32 32" width="20"><path d="M16.7 11.3c-0.4-0.4-1-0.4-1.4 0l-9 9c-0.4 0.4-0.4 1 0 1.4 0.4 0.4 1 0.4 1.4 0L16 13.4l8.3 8.3c0.4 0.4 1 0.4 1.4 0 0.4-0.4 0.4-1 0-1.4L16.7 11.3z" fill="#121313"/></svg>\r\n                </span>\r\n                <span class="titlebar-text" title="{{portlet.title}}"\r\n                    id="{{portlet._view.uid}}-title">{{portlet.title}}</span>\r\n            </div>\r\n\r\n            <!-- Portlet content must use iframe for sandboxed plugins -->\r\n            <plugin-iframe ng-if="portlet.sandbox && !portlet.collapsed"\r\n                           ng-style="portlet.style" class="sandbox-iframe vx-portlet-content"\r\n                           view-url="portlet.contentUrl" view-url-params="portlet.contentUrlParams"\r\n                           view-id="portlet._view.uid"\r\n                           role="region"\r\n                           aria-labelledby="{{portlet._view.uid}}-title"\r\n                           id="{{portlet._view.uid}}-panel"\r\n                           remote-plugin-extension-context="portlet.remotePluginExtensionContext">\r\n            </plugin-iframe>\r\n\r\n            <div ng-if="!portlet.sandbox && !portlet.collapsed" class="vx-portlet-content"\r\n                 ng-include="portlet.contentUrl"\r\n                 role="region"\r\n                 aria-labelledby="{{portlet._view.uid}}-title"\r\n                 id="{{portlet._view.uid}}-panel">\r\n            </div>\r\n\r\n            <div class="vx-portlet-footer">\r\n                <div ng-repeat="action in portlet.actions">\r\n                    <a ng-if="hasLabel(action) && action.enabled" tabindex="0"\r\n                          href=""\r\n                          ng-attr-title="{{action.tooltipText}}"\r\n                          ng-attr-aria-label="{{link.ariaLabel}}"\r\n                          ng-click="action.onClick()" class="vx-portlet-footer-link">\r\n                        {{action.label}}\r\n                    </a>\r\n                    <span ng-if="!action.enabled" class="vx-portlet-footer-link k-state-disabled">{{action.label}}</span>\r\n                </div>\r\n                <div ng-repeat="link in portlet.footerLinks">\r\n                    <a ng-if="hasLabel(link) && link.enabled" tabindex="0"\r\n                       href=""\r\n                       ng-attr-title="{{link.tooltipText}}"\r\n                       ng-attr-aria-label="{{link.ariaLabel}}"\r\n                       ng-click="clickAction($event,link)" class="vx-portlet-footer-link">\r\n                        {{link.label}}\r\n                    </a>\r\n                    <span ng-if="!link.enabled" class="vx-portlet-footer-link k-state-disabled">{{link.label}}</span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/progress/vxProgress.html','<div class="progress progress-striped active">\r\n   <div class="progress-bar" style="width: 100%"\r\n      role="alert" aria-live="assertive" aria-label="{{loadingAriaLabel ? loadingAriaLabel : message}}">\r\n   </div>\r\n</div>\r\n<div class="progress-text" ng-if="message" aria-hidden="true">{{message}}</div>');
$templateCache.put('resources/ui/components/progress/vxStaticProgressIndicator.html','<div class="horizontal-flex-container" >\r\n\r\n   <div class="progress-static flex-column flex-grow-auto">\r\n      <div class="progress-meter" data-value="{{::vx_spi_ctrl.progress}}"></div>\r\n   </div>\r\n\r\n   <div role="percentage" ng-bind-template="{{::vx_spi_ctrl.progress}}%"></div>\r\n\r\n   <div role="cancelButton"\r\n        ng-click="vx_spi_ctrl.events.onCancelClickEvent($event)"\r\n        class="{{vx_spi_ctrl.resources.resolvedCancelClass}}"\r\n        title="{{vx_spi_ctrl.resources.cancelTooltip}}">\r\n   </div>\r\n\r\n</div>\r\n\r\n');
$templateCache.put('resources/ui/components/propertyview/propertyView.html','<div class="vx-property-view">\r\n\r\n   <div ng-if="data.categories.length &gt; 1" vx-navi-tab-headers="data" level="details"></div>\r\n\r\n   <div class="vx-property-view-table-wrapper">\r\n      <table class="vx-property-view-table">\r\n         <tbody ng-repeat="item in getSelectedCategory().content"\r\n               ng-if="item.type === \'Section\'"\r\n               ng-init="section = item"\r\n               data-test-id="section-{{section.id}}"\r\n               class="vx-property-view-section">\r\n\r\n            <tr ng-if="section.title || section.titleIcon"\r\n                  class="vx-property-view-section-title">\r\n               <td colspan="2">\r\n\r\n                  <span ng-if="section.titleIcon"\r\n                        ng-class="section.titleIcon"\r\n                        class="vx-property-view-section-title-icon"></span>\r\n                  <span ng-if="!section.renderAsHtml && !section.compileAsHtml"\r\n                        class="vx-property-view-section-title-text"\r\n                        ng-bind="section.title"></span>\r\n                  <span ng-if="section.renderAsHtml && !section.compileAsHtml"\r\n                        class="vx-property-view-section-title-text"\r\n                        ng-bind-html="section.title | trusted"></span>\r\n                  <span ng-if="section.compileAsHtml"\r\n                        class="vx-property-view-section-title-text"\r\n                        vx-bind-html-and-compile="section.title"></span>\r\n\r\n                  <div class="vx-property-view-section-actions-container"\r\n                        ng-if="section.actions && section.actions.length">\r\n                     <a ng-repeat="action in section.actions"\r\n                           href="javascript:void(0)"\r\n                           ng-disabled="!action.isEnabled"\r\n                           ng-class="{disabled: !action.isEnabled}"\r\n                           ng-click="action.clickHandler($event, action)">{{action.title}}</a>\r\n                  </div>\r\n\r\n               </td>\r\n            </tr>\r\n\r\n            <tr ng-repeat-start="item in section.content"\r\n                  ng-if="item.type === \'Message\'"\r\n                  ng-init="message = item"\r\n                  ng-class="{ \'vx-property-view-section-padded-content\': section.title }"\r\n                  class="vx-property-view-section-message">\r\n               <td colspan="2">\r\n\r\n                  <span ng-if="message.icon"\r\n                        ng-class="message.icon"\r\n                        class="vx-property-view-section-message-icon"></span>\r\n                  <span ng-if="!message.renderAsHtml"\r\n                        class="vx-property-view-section-message-text"\r\n                        ng-bind="message.text"></span>\r\n                  <span ng-if="message.renderAsHtml"\r\n                        class="vx-property-view-section-message-text"\r\n                        ng-bind-html="message.text | trusted"></span>\r\n\r\n               </td>\r\n            </tr>\r\n\r\n            <tr ng-repeat-end\r\n                  ng-if="item.type === \'Property\'"\r\n                  ng-init="property = item"\r\n                  ng-class="{ \'vx-property-view-section-padded-content\': section.title }"\r\n                  class="vx-property-view-section-property">\r\n\r\n               <td class="vx-property-view-section-property-key-column">\r\n                  <span ng-if="property.key.icon"\r\n                        ng-class="property.key.icon"\r\n                        class="vx-property-view-section-property-key-icon"></span>\r\n                  <span class="vx-property-view-section-property-key-text">{{property.key.text}}</span>\r\n\r\n               </td>\r\n\r\n               <td class="vx-property-view-section-property-values-column">\r\n                  <span class="vx-property-view-section-property-values-table">\r\n                     <span ng-repeat="value in property.content"\r\n                           class="vx-property-view-section-property-value">\r\n\r\n                        <span ng-if="value.icon"\r\n                              ng-class="value.icon"\r\n                              class="vx-property-view-section-property-value-icon">\r\n                        </span>\r\n                        <a ng-if="value.link" ng-click="navigate(value.link);">\r\n                              {{value.text}}\r\n                        </a>\r\n                        <span ng-if="!value.link" class="vx-property-view-section-property-value-text">{{value.text}}</span>\r\n                     </span>\r\n                  </span>\r\n               </td>\r\n\r\n            </tr>\r\n\r\n         </tbody>\r\n      </table>\r\n   </div>\r\n\r\n</div>\r\n');
$templateCache.put('resources/ui/components/settingsView/GenericSettingsView.html','<div ng-controller="GenericSettingsViewController as ctrl" ng-class="ctrl.cssClass">\r\n\r\n   <settings-view-header header-title="ctrl.title" actions="ctrl.actions"\r\n         object-ids="ctrl.watchForObjects" accessor="ctrl.settingsViewHeaderAccessor">\r\n   </settings-view-header>\r\n\r\n  <clr-stack-view class="clr-component"\r\n         vx-refreshable refresh=\'ctrl.refresh()\'\r\n         live-refresh-properties="ctrl.liveRefreshProperties"\r\n         delay-refresh-on-object-updates-by="{{ctrl.delayRefreshOnObjectUpdatesBy}}"\r\n         watch-objects=\'{{ctrl.watchForObjects}}\'>\r\n\r\n      <clr-stack-block ng-repeat="propertyItem in ctrl.propertyItems" [(clr-sb-expanded)]="propertyItem.expanded">\r\n         <clr-stack-label>{{propertyItem.label}}</clr-stack-label>\r\n         <clr-stack-content>\r\n            <span ng-if="!propertyItem.expanded">{{propertyItem.value}}</span>\r\n         </clr-stack-content>\r\n\r\n         <clr-stack-block ng-if="propertyItem.nestedProperties"\r\n               ng-repeat="nestedPropertyItem in propertyItem.nestedProperties">\r\n            <clr-stack-label>{{nestedPropertyItem.label}}</clr-stack-label>\r\n            <clr-stack-content>{{nestedPropertyItem.value}}</clr-stack-content>\r\n         </clr-stack-block>\r\n      </clr-stack-block>\r\n   </clr-stack-view>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/settingsView/settingsViewHeader.html','<div class="settingsViewHeader">\r\n   <span class="settingsBlockTitle" ng-bind="ctrl.headerTitle" title="{{ctrl.headerTitle}}"></span>\r\n   <button class="sizing-button btn btn-sm"></button>\r\n   <div class="settingsBlockBtnGroup btn-group btn-outline-primary btn-sm" ng-if="ctrl.actionsToRender.length">\r\n      <button class="btn btn-default btn-sm" ng-repeat="action in ctrl.actionsToRender track by action.actionId"\r\n              ng-disabled="!action.isEnabled"\r\n              ng-click="ctrl.invokeAction($event, action)">{{action.label}}\r\n      </button>\r\n   </div>\r\n</div>');
$templateCache.put('resources/ui/components/shares/vxSharesControl.html','<div class="horizontal-flex-container shares-control">\r\n   <div class="select">\r\n      <select ng-model="sharesInfo.level" aria-label="{{::sharesAriaLabel}}"\r\n            ng-options="option.id as option.label for option in sharesOptions">\r\n      </select>\r\n   </div>\r\n   <vx-value-in-units type="number"\r\n         ng-model="sharesInfo.shares"\r\n         recommended-values="sharesRecommendations"\r\n         is-disabled="!isSharesLevelCustom()"\r\n         min="{{ getMinCustomShares() }}"\r\n         max="{{ getMaxCustomShares() }}"\r\n         allowed-characters="0-9"\r\n         show-units="false"\r\n         error-messages="::shareValueErrorMessages"\r\n         quantity-aria-label="::quantityAriaLabel"\r\n         quantity-caret-aria-label="::quantityCaretAriaLabel">\r\n   </vx-value-in-units>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/storageLocator/storageLocator.html','<div class="flex-column flex-grow-auto">\r\n   <!-- Encrypt virtual machine checkbox -->\r\n   <div ng-if="$ctrl.showEncryptionOptions">\r\n      <fieldset class="encryption-options"\r\n                ng-disabled="$ctrl.isEncryptionOptionsDisabled">\r\n            <span class="checkbox">\r\n               <input type="checkbox" id="encryptVm"\r\n                      ng-model="$ctrl.isEncryptVmEnabled"\r\n                      ng-disabled="$ctrl.isEncryptionOptionsDisabled"\r\n                      ng-change="$ctrl.toggleEncryptVm()">\r\n               <label for="encryptVm">{{ $ctrl.encryptionOptionsLabel }}</label>\r\n\r\n               <vsc-sign-post [sign-post-position]="\'right\'"\r\n                              [sign-post-content]="$ctrl.i18n(\'Common\', \'storageSelector.encryptVm.tooltip\')"\r\n                              ng-if="!$ctrl.isEncryptionOptionsDisabled">\r\n               </vsc-sign-post>\r\n            </span>\r\n      </fieldset>\r\n   </div>\r\n\r\n   <table role="presentation" class="storage-locator-settings-table">\r\n      <!-- disk format selector -->\r\n      <tr ng-if="$ctrl.diskFormatSettings.diskFormatSupported">\r\n         <td>\r\n            <span id="storage-locator-disk-format-label" class="settings-label">{{$ctrl.i18n(\'Common\', \'StorageLocatorControl.format\')}}</span>\r\n         </td>\r\n         <td>\r\n            <disk-format-selector\r\n                  disk-formats="$ctrl.diskFormats"\r\n                  selected-format="$ctrl.diskFormatSettings.selectedDiskFormat"\r\n                  ctrl-aria-labeled-by="\'storage-locator-disk-format-label\'">\r\n            </disk-format-selector>\r\n         </td>\r\n      </tr>\r\n\r\n      <!-- Storage profile selector -->\r\n      <tr ng-if="$ctrl.storageProfilesData">\r\n         <td>\r\n            <span class="settings-label">{{$ctrl.i18n(\'Common\', \'StorageLocatorControl.VmStorageProfile\')}}</span>\r\n         </td>\r\n         <td>\r\n            <storage-profile-menu\r\n                  class="storage-profile-menu-as-select"\r\n                  [selected-storage-profile]="$ctrl.storageProfilesData.selectedProfile"\r\n                  [storage-profiles]="$ctrl.filteredStorageProfiles"\r\n                  [group-profiles]="$ctrl.showEncryptionOptions && !$ctrl.isEncryptionOptionsDisabled\r\n                     && ($ctrl.isProfileSetFromDropDown || !$ctrl.isEncryptVmEnabled)"\r\n                  [read-only]="!!$ctrl.storageProfilesData.error"\r\n                  [warning]="$ctrl.storageProfilesData.error"\r\n                  [aria-label]="$ctrl.i18n(\'Common\', \'StorageLocatorControl.VmStorageProfile\')"\r\n                  [is-encryption-disabled]="!!$ctrl.isEncryptionOptionsDisabled"\r\n                  (on-change)="$ctrl.onStorageProfileChanged($event)">\r\n            </storage-profile-menu>\r\n         </td>\r\n      </tr>\r\n   </table>\r\n\r\n   <label ng-if="$ctrl.drsCheckboxVisible && !$ctrl.podDisplayDisabled">\r\n      <input type="checkbox" ng-model="$ctrl.drsDisabled" />\r\n      {{$ctrl.i18n(\'Common\', \'StorageLocatorControl.DisableSdrs\')}}\r\n   </label>\r\n\r\n   <div id="storageLocatorGrid" vui-datagrid="$ctrl.datagridOptions" class="flex-grid"\r\n        ng-if="$ctrl.datagridOptions"\r\n        vx-stretch-grid\r\n        vx-datagrid-preselect-item="{{$ctrl.datagridPreselect}}"\r\n        preselect-comparator="$ctrl.preselectComparator"\r\n        reselect-on-change="true">\r\n   </div>\r\n\r\n   <!-- Replication group selector -->\r\n   <div ng-if="$ctrl.showReplicationGroupSelector" class="replication-group-container">\r\n\r\n      <label for="storage-locator-replication-group-select" class="settings-label">{{::$ctrl.i18n(\'Common\', \'StorageLocatorControl.protectionGroup\')}}</label>\r\n\r\n      <div class="select">\r\n         <select ng-model="$ctrl.selectedReplicationGroupItem"\r\n                 id="storage-locator-replication-group-select"\r\n                 ng-options="rgInfo as rgInfo.label for rgInfo in $ctrl.replicationGroupItems">\r\n\r\n            <option ng-if="!$ctrl.selectedReplicationGroupItem" value="">\r\n               {{::$ctrl.i18n("Common", "StorageLocatorControl.protectionGroup.hint")}}\r\n            </option>\r\n         </select>\r\n      </div>\r\n\r\n      <span class="vx-icon-info_normal"\r\n            vui-sign-post="$ctrl.rgSignPostConfig">\r\n      </span>\r\n   </div>\r\n\r\n</div>\r\n');
$templateCache.put('resources/ui/components/storageLocator/storageSelector.html','<storage-selector-header-component\r\n      storage-profiles="$ctrl.storageSelectorState.basicModeState.profilesData.storageProfiles"\r\n      datastore-items="$ctrl.storageSelectorData.storageLocatorItemsData.datastoreItems"\r\n      source-vm-storage-config="$ctrl.storageSelectorData.sourceVmStorageConfig"\r\n      storage-baseline-id="$ctrl.storageSelectorState.storageBaselineId"\r\n      on-storage-baseline-id-change="$ctrl.onStorageBaselineSelectionChange(newStorageBaselineId)"\r\n      show-storage-baseline-signpost-hints="$ctrl.showStorageBaselineSignpostHints"\r\n      unsupported-storage-baseline-ids="$ctrl.unsupportedStorageBaselineIds"\r\n      show-selection-mode-selector="$ctrl.modeSettings.showAdvancedMode"\r\n      selection-mode="$ctrl.storageSelectorState.mode"\r\n      on-selection-mode-change="$ctrl.onSelectionModeChange(newSelectionMode)"\r\n      component-state="$ctrl.storageSelectorState.basicModeState.headerState"\r\n      is-disk-groups-available="$ctrl.isDiskGroupsAvailable"\r\n      is-pmem-option-disabled="$ctrl.isPmemOptionDisabled">\r\n</storage-selector-header-component>\r\n\r\n<storage-locator drs-disabled="$ctrl.storageSelectorState.basicModeState.drsDisabled"\r\n      pod-display-disabled="$ctrl.podDisplayDisabled"\r\n      storage-locator-items-data="$ctrl.storageSelectorData.storageLocatorItemsData"\r\n      selected-item="$ctrl.storageSelectorState.basicModeState.selectedItem"\r\n      storage-profiles-data="$ctrl.storageSelectorState.basicModeState.profilesData"\r\n      disk-format-settings="$ctrl.storageSelectorState.basicModeState.diskFormatSettings"\r\n      disable-default-preselection="$ctrl.disableDefaultPreselectionInBasicMode"\r\n      ensure-preselection-visibility="$ctrl.ensurePreselectionVisibilityInBasicMode"\r\n      storage-baseline-id="$ctrl.storageSelectorState.storageBaselineId"\r\n      show-encryption-options="$ctrl.showEncryptionOptions"\r\n      is-encryption-options-disabled="!!$ctrl.isEncryptionOptionsDisabled"\r\n      encryption-options-disabled-reason="$ctrl.encryptionOptionsDisabledReason"\r\n      vm-ids="$ctrl.vmIds"\r\n      vm-destination-hosts="$ctrl.vmDestinationHosts"\r\n      vm-storage-configs="$ctrl.storageSelectorData.sourceVmStorageConfig"\r\n      replication-group-settings="$ctrl.storageSelectorState.basicModeState.replicationGroupSettings"\r\n      class="storage-selector-basic-mode flex-column flex-grow-auto"\r\n      ng-if="$ctrl.isLocatorInBasicMode()">\r\n</storage-locator>\r\n\r\n<storage-locator-advanced-mode\r\n      on-selection-changed="$ctrl.onSelectionChangedInAdvancedMode()"\r\n      pod-display-disabled="$ctrl.podDisplayDisabled"\r\n      storage-locator-items-data="$ctrl.storageSelectorData.storageLocatorItemsData"\r\n      storage-profiles-data="$ctrl.storageSelectorData.storageProfilesData"\r\n      disk-format-settings="$ctrl.diskFormatSettings"\r\n      disable-default-preselection="$ctrl.disableDefaultPreselectionInBasicMode"\r\n      vm-storage-config="$ctrl.storageSelectorState.vmStorageConfigInAdvancedMode"\r\n      recently-selected-storage-items="$ctrl.storageSelectorState.recentlySelectedStorageItemsInAdvancedMode"\r\n      show-replication-groups="$ctrl.showReplicationGroups"\r\n      control-api="$ctrl.advancedModeApi"\r\n      is-encryption-options-disabled="!!$ctrl.isEncryptionOptionsDisabled"\r\n      class="storage-selector-advanced-mode flex-column flex-grow-auto"\r\n      is-vmtx-workflow="$ctrl.isVmtxWorkflow"\r\n      is-disk-groups-available="$ctrl.isDiskGroupsAvailable"\r\n      ng-if="$ctrl.storageSelectorState.mode === \'advancedMode\'">\r\n</storage-locator-advanced-mode>\r\n');
$templateCache.put('resources/ui/components/storageLocator/storageSelectorDialog.html','<div class="flex-column flex-auto storage-selector-dialog">\r\n   <storage-selector class="flex-auto flex-column"\r\n         mode-settings="modalOptions.dialogData.modeSettings"\r\n         pod-display-disabled="modalOptions.dialogData.podDisplayDisabled"\r\n         storage-selector-state="modalOptions.dialogData.storageSelectorState"\r\n         storage-selector-data="modalOptions.dialogData.storageSelectorData"\r\n         storage-selector-api="modalOptions.dialogData.storageSelectorApi"\r\n         disk-format-settings="modalOptions.dialogData.diskFormatSettings"\r\n         disable-default-preselection-in-basic-mode="modalOptions.dialogData.disableDefaultPreselection"\r\n         ensure-preselection-visibility-in-basic-mode="true"\r\n         show-replication-groups="modalOptions.dialogData.showReplicationGroups"\r\n         is-encryption-options-disabled="!!modalOptions.dialogData.isEncryptionOptionsDisabled"\r\n         is-pmem-option-disabled="modalOptions.dialogData.isPmemOptionDisabled"\r\n   >\r\n   </storage-selector>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/storageLocator/storageSelectorHeaderComponent.html','<div>\r\n   <div class="storage-selector-header flex-row">\r\n      <div class="flex-row flex-grow-auto">\r\n         <div ng-if="$ctrl.availableStorageBaselines && $ctrl.selectionMode === \'basicMode\'"\r\n               class="storage-baseline-selector flex-row flex-grow-auto">\r\n            <div ng-repeat="storageBaseline in $ctrl.availableStorageBaselines track by $index"\r\n                  class="radio-inline flex-none"\r\n                  ng-style="{\'padding-left\': $index == 0 ? 0 : \'inherit\'}">\r\n               <input type="radio" name="storageBaseline" id="{{storageBaseline.id}}"\r\n                      ng-value="storageBaseline.id"\r\n                      ng-model="$ctrl.selectedStorageBaselineId"\r\n                      ng-change="$ctrl.onSelectedStorageBaselineIdChange()"/>\r\n               <label for="{{storageBaseline.id}}">{{storageBaseline.label}}</label>\r\n            </div>\r\n            <vsc-sign-post ng-if="$ctrl.showStorageBaselineSignpostHints"\r\n                  class="storage-selector-header-pmem-info"\r\n                  [sign-post-header]=\'::$ctrl.signpostParams.title\'\r\n\t\t\t\t  [sign-post-content]=\'::$ctrl.signpostParams.message\'\r\n                  [sign-post-position]="\'right-bottom\'">\r\n            </vsc-sign-post>\r\n         </div>\r\n      </div>\r\n      <div ng-if="!$ctrl.availableStorageBaselines" class="flex-auto"/>\r\n      <div ng-if="$ctrl.showSelectionModeSelector" class="toggle-switch flex-none">\r\n         <input type="checkbox" id="toggleMode"\r\n                ng-checked="$ctrl.selectionMode === \'advancedMode\'"\r\n                ng-click="$ctrl.toggleSelectionMode()">\r\n         <label for="toggleMode" ng-if="!$ctrl.isDiskGroupsAvailable">\r\n            {{$ctrl.i18n(\'Common\', \'storageSelector.configurePerDisk\')}}\r\n         </label>\r\n         <label for="toggleMode" ng-if="$ctrl.isDiskGroupsAvailable">\r\n            {{$ctrl.i18n(\'Common\', \'storageSelector.configurePerDiskGroup\')}}\r\n         </label>\r\n      </div>\r\n   </div>\r\n\r\n   <!-- Baseline hint -->\r\n   <div class="alert alert-info alert-sm" ng-if="$ctrl.getHintFor($ctrl.selectedStorageBaselineId)">\r\n      <div class="alert-item static">\r\n         <div class="alert-icon-wrapper">\r\n            <clr-icon class="alert-icon" shape="info-circle"></clr-icon>\r\n         </div>\r\n         <div class="alert-text">\r\n            <div ng-repeat="hint in $ctrl.getHintFor($ctrl.selectedStorageBaselineId)"\r\n                  ng-style="hint.bold && {\'font-weight\': \'bold\'}">\r\n               {{hint.message}}\r\n            </div>\r\n         </div>\r\n         <button type="button" class="close" aria-label="Close" ng-click="$ctrl.onBaselineHintClose()">\r\n            <clr-icon aria-hidden="true" shape="close"></clr-icon>\r\n         </button>\r\n      </div>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/components/storageProfile/storageProfile.html','<div class="horizontal-flex-container">\r\n   <div class="select"\r\n        ng-class="{\'has-error\': errorConfig && errorConfig.isVisible}">\r\n      <select class="storage-profile"\r\n              ng-disabled="readOnly"\r\n              ng-model="selectedStorageProfile"\r\n              ng-options="storageProfile as storageProfile.label for storageProfile in storageProfiles track by storageProfile.label+storageProfile.id"\r\n              ng-change="onChangeCallback()(selectedStorageProfile)"\r\n              vx-error="errorConfig"\r\n              aria-label="{{::selectAriaLabel}}">\r\n      </select>\r\n   </div>\r\n   <a ng-if="warning"\r\n      role="tooltip"\r\n      aria-haspopup="true"\r\n      href="javascript://"\r\n      class="tooltip validation-tooltip tooltip-md tooltip-top-left">\r\n      <clr-icon shape="warning-standard" class="is-warning" size="16"></clr-icon>\r\n      <span class="tooltip-content" ng-bind="warning"></span>\r\n   </a>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/alarms/alarmPopupTemplate.html','<div ng-controller="AlarmPopupController as ctrl">\r\n   <div class="triggering-object-name">\r\n      <span class="{{alarm.iconStatusClass}}"></span>\r\n      <a ng-click="triggeringObjectClicked()">\r\n         {{alarm.triggeringObjectName}}\r\n      </a>\r\n      <div><strong>{{alarm.title}}</strong></div>\r\n   </div>\r\n   <table>\r\n      <tr>\r\n         <td class="alarm-detail-label">{{i18n(\'AlarmsUi\', \'AlarmDetailsView.severity\')}}</td>\r\n         <td class="alarm-detail-value">{{alarm.severity}}</td>\r\n      </tr>\r\n      <tr>\r\n         <td class="alarm-detail-label">{{i18n(\'AlarmsUi\', \'AlarmDetailsView.lifeCycleStatus\')}}</td>\r\n         <td class="alarm-detail-value">{{alarm.status}}</td>\r\n      </tr>\r\n      <tr ng-if="alarm.acknowledgedOn">\r\n         <td class="alarm-detail-label">{{i18n(\'AlarmsUi\', \'AlarmDetailsView.acknowledgedTime\')}}</td>\r\n         <td class="alarm-detail-value">{{alarm.acknowledgedOn | date:\'medium\'}}</td>\r\n      </tr>\r\n      <tr>\r\n         <td class="alarm-detail-label">{{i18n(\'AlarmsUi\', \'AlarmDetailsView.triggeredOnLabel\')}}</td>\r\n         <td class="alarm-detail-value">{{alarm.triggeredOn | date:\'medium\'}}</td>\r\n      </tr>\r\n      <tr>\r\n         <td class="alarm-detail-label">{{i18n(\'AlarmsUi\', \'AlarmDetailsView.editDefinition\')}}</td>\r\n         <td class="alarm-detail-value defined-in-object-name">\r\n            <a ng-click="definedInObjectClicked()">\r\n               {{alarm.definedInObjectName}}\r\n            </a>\r\n         </td>\r\n      </tr>\r\n      <tr>\r\n         <td class="alarm-detail-label">{{i18n(\'AlarmsUi\', \'AlarmDetailsView.description\')}}</td>\r\n         <td class="alarm-detail-value">{{alarm.description}}</td>\r\n      </tr>\r\n   </table>\r\n   <div class="actions">\r\n      <button ng-repeat="alarmAction in actions"\r\n              ng-if="alarmAction.enabled"\r\n              ng-click="alarmActionClicked(alarmAction)">\r\n         <span class="k-sprite" ng-class="alarmAction.iconClass"></span>\r\n         {{alarmAction.label}}\r\n      </button>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/alarms/AlarmsView.html','<div vui-datagrid=\'$ctrl.datagridOptions\' vx-stretch-grid class="fill-parent"\r\n     vx-datagrid-row-right-click="$ctrl.showActionsMenu($event)"></div>');
$templateCache.put('resources/ui/views/controlbar/ControlBarView.html','<!-- Copyright 2013 VMware, Inc. All rights reserved. -- VMware Confidential -->\r\n<!--Control bar View -->\r\n<div class="main-nav" ng-controller="ControlBarViewController">\r\n\r\n   <header class="header">\r\n      <div class="branding">\r\n\r\n         <!-- VMware icon -->\r\n         <a href="" ng-click="_navigateToView(rootExtId)" tabindex="0"\r\n            aria-label="{{::i18n(\'Common\', \'ariaLabel.productShortcuts.header\')}}"\r\n            accesskey="1" role="button">\r\n            <span data-test-id="{{rootExtId}}" class="clr-icon clr-vmw-logo tid-control-bar-vmw-logo"></span>\r\n            <span class="title"\r\n                  ng-class="{pointer: productHomePresent()}"\r\n                  ng-bind="::productName"></span>\r\n         </a>\r\n      </div>\r\n\r\n      <div class="header-nav">\r\n      <vsc-navigation-view-menu\r\n              [node-id]="::homeMenuNavigatorNodeId"\r\n              menu-alignment="bottom-left"\r\n              id="action-homeMenu"\r\n              [aria-menu-label]="productNavigationMenuLabel">\r\n         <vsc-navigation-view-menu-toggle>\r\n            <span class="home-menu-link">\r\n               <span class="nav-icon">\r\n                  {{::i18n(\'Common\', \'homeMenu\')}}\r\n                  <i class="fa fa-angle-down"></i>\r\n               </span>\r\n            </span>\r\n         </vsc-navigation-view-menu-toggle>\r\n      </vsc-navigation-view-menu>\r\n      </div>\r\n\r\n      <form class="search-box tid-quick-search">\r\n         <vsc-search-header></vsc-search-header>\r\n      </form>\r\n\r\n      <div class="settings header-actions">\r\n         <!-- refresh -->\r\n         <a class="nav-link tid-global-refresh-button"\r\n            ng-click="onRefresh()" href="" accesskey="r"\r\n            aria-label="{{::i18n(\'Common\', \'ariaLabel.refresh.link\')}}"\r\n            tabindex="0"\r\n            role="button">\r\n            <span class="nav-icon">\r\n               <clr-icon class="tid-global-refresh-button global-refresh-button"\r\n                         shape="refresh"\r\n                         size="24"\r\n                         role="button"\r\n                         data-test-id="global-refresh-button"\r\n                         ng-if="showSpinner === false">\r\n               </clr-icon>\r\n               <span class="spinner spinner-inline spinner-inverse global-refresh-active"\r\n                     ng-class="showSpinner ? \'\' : \'spinner-paused\'"\r\n                     data-test-id="global-refresh-activity-indicator">\r\n               </span>\r\n            </span>\r\n         </a>\r\n\r\n         <!-- Perf -->\r\n         <div ng-if="showPerf">\r\n            <div ng-include="\'resources/ui/views/performance/PerformanceView.html\'"></div>\r\n         </div>\r\n\r\n         <div class="divider"></div>\r\n\r\n         <!-- help -->\r\n         <vc-action-menu data-test-id="action-helpMenu"\r\n                         [aria-menu-label]="helpMenuLabel"\r\n                         [menu-type]="helpMenuType"\r\n                         [menu-alignment]="\'bottom-right\'"\r\n                         (menu-item-click)="onDropdownMenuItemClickEvent($event)"\r\n                         class="tid-control-bar-help-menu">\r\n            <vc-action-menu-toggle>\r\n               <span class="nav-link">\r\n                  <span class="nav-icon help-menu">\r\n                     <clr-icon shape="help"\r\n                               ng-attr-title="{{::i18n(\'Common\', \'ariaLabel.helpButton\')}}"\r\n                               size="24"></clr-icon>\r\n                     <clr-icon shape="caret down"\r\n                               aria-hidden="true"\r\n                               size="16"></clr-icon>\r\n                  </span>\r\n               </span>\r\n            </vc-action-menu-toggle>\r\n         </vc-action-menu>\r\n\r\n         <div class="divider"></div>\r\n\r\n         <!-- Code Capture - start/stop recording of the user actions. -->\r\n         <code-capture-actions\r\n               (on-visibility-change)="onCodeCaptureVisibilityChanged($event)">\r\n         </code-capture-actions>\r\n\r\n         <div class="divider" ng-if="isCodeCaptureVisible"></div>\r\n\r\n         <!-- user menu -->\r\n         <vc-action-menu data-test-id="action-userMenu"\r\n                          [aria-menu-label]="userName"\r\n                          [menu-type]="userMenuType"\r\n                          [menu-alignment]="\'bottom-right\'"\r\n                          (menu-item-click)="onDropdownMenuItemClickEvent($event)"\r\n                          class="tid-control-bar-user-menu">\r\n            <vc-action-menu-toggle>\r\n               <span class="nav-link">\r\n                  <span class="nav-icon user-menu-large">\r\n                     <clr-icon shape="caret down" size="16"></clr-icon>\r\n                     <clr-icon shape="caret down" size="16"></clr-icon>\r\n                     <span>\r\n                        {{::userName}}\r\n                     </span>\r\n                  </span>\r\n               </span>\r\n            </vc-action-menu-toggle>\r\n         </vc-action-menu>\r\n\r\n         <div class="divider" ng-if="isFeedbackToolEnabled"></div>\r\n\r\n         <button id="feedbackIcon"\r\n            class="nav-link nav-icon tid-control-bar-feedback-button"\r\n            ng-class="{showFeedback: !isFeedbackModalOpen()}"\r\n            ng-click="showEnhancedFeedbackModal()"\r\n            ng-if="isFeedbackToolEnabled"\r\n            ng-attr-title="{{::i18n(\'Common\', \'feedback.title\')}}">\r\n            <clr-icon shape="happy-face" size="24"></clr-icon>\r\n         </button>\r\n      </div>\r\n\r\n   </header>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/controlcenter/ControlCenterView.html','<!--Control center home view -->\r\n\r\n<div ng-controller="ControlCenterViewController as controlCenter">\r\n   <div class="controlcenter" ng-repeat="cat in controlCenter.categories">\r\n      <div class="controlcenter-category">{{cat.title}}</div>\r\n\r\n      <div class="controlcenter-shortcut" ng-repeat="shortcut in cat.exts"\r\n            ng-click="controlCenter.onSelect(shortcut)" aria-label="{{::shortcut.name}}" role="link">\r\n          <span class="{{shortcut.icon}} controlcenter-shortcut-icon-display" ng-if="controlCenter.hasClass(shortcut)"></span>\r\n          <img class="controlcenter-shortcut-icon" ng-src="{{shortcut.icon}}" ng-if="!controlCenter.hasClass(shortcut)"/>\r\n          <div data-test-id="{{shortcut.targetViewUid}}" class="controlcenter-shortcut-label">{{::shortcut.name}}</div>\r\n      </div>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/dialogs/confirmationModal.html','<clr-modal\r\n      [clr-modal-static-backdrop]="true"\r\n      [(clr-modal-open)]="modalOptions.modalOpen"\r\n      [(clr-modal-size)]="modalOptions.size"\r\n      [(clr-modal-closable)]="modalOptions.showXIcon"\r\n      class="clr-confirm-modal"\r\n      ng-class="modalOptions.modalClass" alert-dialog-role primary-title="modalOptions.title">\r\n   <h3 class="modal-title" modal-title\r\n       primary-title="modalOptions.title"\r\n       secondary-title="modalOptions.subTitle"></h3>\r\n   <div class="modal-body">\r\n      <div ng-if="!!modalOptions.icon" class="clr-confirm-modal-icon">\r\n         <span ng-if="!!modalOptions.icon" ng-class="modalOptions.icon"></span>\r\n      </div>\r\n      <div ng-if="!!modalOptions.clarityIcon" class="clr-confirm-modal-icon-top">\r\n         <span ng-if="!!modalOptions.icon" ng-class="modalOptions.icon"></span>\r\n\r\n         <span ng-if="!!modalOptions.clarityIcon">\r\n            <clr-icon\r\n                    ng-attr-shape="{{::modalOptions.clarityIcon.shape}}"\r\n                    ng-attr-size="{{::modalOptions.clarityIcon.size}}"\r\n                    ng-class="::modalOptions.clarityIcon.class"></clr-icon>\r\n         </span>\r\n      </div>\r\n      <p ng-class="{\'preserve-newlines\': modalOptions.preserveNewlines}">{{modalOptions.message}}</p>\r\n      <div ng-include="modalOptions.contentTemplate"></div>\r\n   </div>\r\n   <div class="modal-footer" focus-primary-button >\r\n      <button type="button" id="closeBtn"\r\n            class="btn {{::modalOptions.defaultButton === \'close\' ? \'btn-primary\' : \'btn-outline\'}}"\r\n            ng-click="closeModal()"\r\n            aria-label="{{getCancelBtnLabel()}}"\r\n            ng-if="!modalOptions.hideCancelButton">\r\n         {{getCancelBtnLabel()}}\r\n      </button>\r\n      <button type="button" id="submitBtn"\r\n            ng-disabled="modalOptions.submitDisabled"\r\n            class="btn {{::modalOptions.defaultButton === \'submit\' ? \'btn-primary\' : \'btn-outline\'}}"\r\n            aria-label="{{getOkBtnLabel()}}"\r\n            ng-click="submitModal()">\r\n         {{getOkBtnLabel()}}\r\n      </button>\r\n   </div>\r\n</clr-modal>\r\n');
$templateCache.put('resources/ui/views/dialogs/InformationalDialog.html','<div>\r\n   <span class="informational-dialog-image-container">\r\n      <img class="informational-dialog-image" ng-src="{{imageUrl}}" ng-if="imageUrl"/>\r\n   </span>\r\n   <span class="informational-dialog-text">{{informationalMessage}}</span><br />\r\n</div>');
$templateCache.put('resources/ui/views/dialogs/okCancelModal.html','<clr-modal\r\n        [clr-modal-static-backdrop]="true"\r\n        [(clr-modal-open)]="modalOptions.modalOpen"\r\n        [(clr-modal-size)]="modalOptions.size"\r\n        ng-class="modalOptions.modalClass">\r\n    <h3 class="modal-title"\r\n        modal-title\r\n        primary-title="modalOptions.title"\r\n        secondary-title="modalOptions.subTitle"></h3>\r\n    <div class="modal-body show-tooltip-modal">\r\n        <clr-alert role="alert" ng-repeat="alert in modalOptions.alerts" [clr-alert-type]="alert.className" [clr-closable]="true">\r\n            <clr-alert-item><span class="alert-text" ng-bind="alert.text"></span></clr-alert-item>\r\n        </clr-alert>\r\n\r\n        <div ng-include="modalOptions.contentTemplate"></div>\r\n    </div>\r\n    <div class="modal-footer">\r\n        <button type="button" class="btn" id="closeBtn"\r\n                ng-class="modalOptions.defaultButton == \'close\' ? \'btn-primary\' : \'btn-outline\'"\r\n                ng-click="closeModal()">\r\n            {{modalOptions.closeButtonTitle ? modalOptions.closeButtonTitle : i18n("Common", "cancelButtonLabel")}}\r\n        </button>\r\n        <button type="button" class="btn" id="submitBtn"\r\n                ng-disabled="modalOptions.submitDisabled"\r\n                ng-class="modalOptions.defaultButton == \'submit\' ? \'btn-primary\' : \'btn-outline\'"\r\n                ng-click="onSubmitModal()" ng-show="!modalOptions.hideSubmitButton">\r\n            {{modalOptions.submitButtonTitle ? modalOptions.submitButtonTitle : i18n("Common", "saveButtonLabel")}}\r\n        </button>\r\n    </div>\r\n</clr-modal>\r\n');
$templateCache.put('resources/ui/views/dialogs/popUpDialog.html','<clr-modal\r\n      [clr-modal-static-backdrop]="true"\r\n      [(clr-modal-open)]="modalOptions.modalOpen"\r\n      [(clr-modal-size)]="modalOptions.size">\r\n   <h3 class="modal-title" modal-title primary-title="modalOptions.title" secondary-title="modalOptions.subTitle"></h3>\r\n   <div class="modal-body">\r\n\r\n        <div ng-repeat="alert in modalOptions.alerts">\r\n            <div class="alert" ng-class="alert.className">\r\n                <div class="alert-items">\r\n\r\n                    <div class="alert-item alert-item">\r\n                        <div class="alert-icon-wrapper">\r\n                            <clr-icon class="alert-icon" ng-attr-shape="{{::alert.iconShape}}"></clr-icon>\r\n                        </div>\r\n                        <span class="alert-text" ng-bind="::alert.text"></span>\r\n                    </div>\r\n                </div>\r\n\r\n                <button ng-click="removeAlert($index)" type="button" class="close" aria-label="Close">\r\n                    <clr-icon aria-hidden="true" shape="close"></clr-icon>\r\n                </button>\r\n            </div>\r\n        </div>\r\n\r\n\r\n      <div ng-include="modalOptions.contentUrl"></div>\r\n   </div>\r\n</clr-modal>\r\n');
$templateCache.put('resources/ui/views/events/EventsView.html','<div ng-controller="EventsViewController as eventsView" class="fill-parent split-view">\r\n   <div vx-refreshable refresh="eventsView.refresh()"></div>\r\n   <div vui-splitter="eventsView.splitterOptions"\r\n        vx-vui-splitter-resize-notifier="eventsView.eventsListOptions"\r\n        class="fill-parent">\r\n      <div class="vui-panel">\r\n         <vx-activity-indicator is-visible="eventsView.pendingRequest" size="large"\r\n            loading-aria-label="{{::i18n(\'EventUi\', \'eventsList.loadingAriaLabel\')}}">\r\n         </vx-activity-indicator>\r\n         <div class="fill-parent">\r\n            <div ng-if="eventsView.eventsListOptions" vui-datagrid="eventsView.eventsListOptions"\r\n                 vx-datagrid-preselect-item class="fill-parent">\r\n            </div>\r\n         </div>\r\n      </div>\r\n      <div class="vui-panel details">\r\n         <div ng-show="!eventsView.selectedEvent" class="fill-parent centered-content-container">\r\n            <span class="no-items-selected">\r\n               {{::i18n(\'EventUi\', \'eventSelectOne\')}}\r\n            </span>\r\n         </div>\r\n         <div ng-if="eventsView.selectedEvent" class="content">\r\n            <div class="custom-split-view">\r\n               <div class="half-size">\r\n\r\n                  <!-- Date Time -->\r\n                  <div class="property-value horizontal-flex-container">\r\n                     <span class="property">\r\n                        {{::i18n(\'EventUi\', \'eventCreationTimeLabel.text\')}}\r\n                     </span>\r\n                     <span>{{eventsView.selectedEvent.formattedCreatedTime}}</span>\r\n                  </div>\r\n                  <!-- User -->\r\n                  <div ng-show="eventsView.selectedEvent.userName"\r\n                        class="property-value horizontal-flex-container">\r\n                     <span class="property">\r\n                        {{::i18n(\'EventUi\', \'eventUserLabel.text\')}}\r\n                     </span>\r\n                     <span class="text-overflow-ellipsis" title="{{eventsView.selectedEvent.userName}}">{{eventsView.selectedEvent.userName}}</span>\r\n                  </div>\r\n               </div>\r\n               <div class="half-size">\r\n\r\n                  <!-- Type -->\r\n                  <div class="property-value horizontal-flex-container">\r\n                     <span class="property">\r\n                        {{::i18n(\'EventUi\', \'eventTypeLabel.text\')}}\r\n                     </span>\r\n                     <span>{{eventsView.selectedEvent.categoryName}}</span>\r\n                  </div>\r\n\r\n                  <!-- Target -->\r\n                  <div ng-show="eventsView.selectedEvent.targetEntityName"\r\n                        class="property-value horizontal-flex-container">\r\n                     <span class="property">\r\n                        {{::i18n(\'EventUi\', \'eventRelatedTargetLabel.text\')}}\r\n                     </span>\r\n                     <span>\r\n                        <span class="{{eventsView.selectedEvent.targetIcon}}"\r\n                              ng-attr-aria-label="{{eventsView.getSelectedEventTargetType()}}"></span>\r\n                        <a ng-click="$root._navigateToObject(eventsView.selectedEvent.targetEntityId)"\r\n                              title="{{eventsView.selectedEvent.targetEntityName}}">\r\n                           {{eventsView.selectedEvent.targetEntityName || \'&nbsp;\'}}\r\n                        </a>\r\n                     </span>\r\n                  </div>\r\n               </div>\r\n            </div>\r\n\r\n            <!-- Task -->\r\n            <div ng-show="eventsView.selectedEvent.isTaskEvent"\r\n                  class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'EventUi\', \'eventRelatedTaskLabel.text\')}}\r\n               </span>\r\n               <span>{{eventsView.selectedEvent.taskInfoName}}</span>\r\n            </div>\r\n\r\n            <!-- Description -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'EventUi\', \'descriptionLabel.text\')}}\r\n               </span>\r\n               <span ng-show="eventsView.showAskVmware" class="ask-vmware">\r\n                  <a ng-click="eventsView.openHelp(eventsView.selectedEvent)">\r\n                     {{::i18n(\'EventUi\', \'EventDetailsView.askVMware\')}}\r\n                  </a>\r\n               </span>\r\n            </div>\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property date-time">\r\n                  <span class="icon-vSphere-events"></span>\r\n                  {{eventsView.selectedEvent.formattedCreatedTime}}\r\n               </span>\r\n               <span>\r\n                  <linked-text\r\n                     text="eventsView.selectedEvent.linkableFormattedMessage"\r\n                     targets="eventsView.selectedEvent.linkableEntities"\r\n                     fallback-text="eventsView.selectedEvent.fullFormattedMessage"\r\n                  ></linked-text>\r\n               </span>\r\n            </div>\r\n\r\n            <!-- Type description -->\r\n            <div ng-if="eventsView.selectedEvent.longDescription">\r\n               <div class="property-value">\r\n                  <span class="property">\r\n                     {{::i18n(\'EventUi\', \'typeDescriptionLabel.text\')}}\r\n                  </span>\r\n               </div>\r\n               <div class="property-value">\r\n                  <span>{{eventsView.selectedEvent.longDescription}}</span>\r\n               </div>\r\n            </div>\r\n\r\n            <!-- Possible causes -->\r\n            <div ng-if="eventsView.selectedEvent.causes && eventsView.selectedEvent.causes.length > 0">\r\n               <div class="property-value">\r\n                  <span class="property">\r\n                     {{::i18n(\'EventUi\', \'typeCauseLabel.text\')}}\r\n                  </span>\r\n               </div>\r\n               <ul class="causes-list">\r\n                  <li ng-repeat="cause in eventsView.selectedEvent.causes">\r\n                     {{cause.description}}\r\n                     {{cause.action ? i18n(\'EventUi\', \'actionLabel.text\', cause.action) : \'\'}}\r\n                  </li>\r\n               </ul>\r\n            </div>\r\n\r\n            <!-- Related events -->\r\n            <div class="property-value">\r\n               <span class="property">\r\n                  {{::i18n(\'EventUi\', \'relatedEventsTitleLabel.text\')}}\r\n               </span>\r\n            </div>\r\n\r\n            <div ng-show="!eventsView.hasRelatedEvents"\r\n                 class="property-value">\r\n               <span>{{::i18n(\'EventUi\', \'noRelatedEventsFound.text\')}}</span>\r\n            </div>\r\n\r\n            <div ng-if="eventsView.hasRelatedEvents">\r\n               <div>\r\n                  <div vui-datagrid="eventsView.relatedEventsListOptions" class="related-events">\r\n                  </div>\r\n               </div>\r\n            </div>\r\n         </div>\r\n      </div>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/issues/CommonIssuesView.html','<div ng-controller="CommonIssuesViewController as ctrl" class="fill-parent">\r\n    <vx-activity-indicator is-visible="ctrl.pendingRequest" title="{{i18n(\'Common\', \'loadingTitle\')}}"></vx-activity-indicator>\r\n    <div class="fill-parent">\r\n        <div vui-datagrid="ctrl.datagridOptions" vx-stretch-grid\r\n             class="fill-parent" vx-datagrid-row-right-click="ctrl.showActionsMenu($event)">\r\n        </div>\r\n    </div>\r\n</div>');
$templateCache.put('resources/ui/views/listview/ListView.html','<list-view list-view-id="{{!!_view.listViewId ? _view.listViewId : _view.$id}}"\r\n      list-view-type="_view.type"\r\n      object-id="_route.objectId"\r\n      relation-id="_view.relationId"\r\n      inverse-relation="_view.inverseRelation"\r\n      filter-id="{{_view.filterId}}"\r\n      filter-params="_view.filterParams"\r\n      data-models="_view.dataModels"\r\n      show-relations-for="_view.$parent.contentSpec.metadata.showRelationsFor"\r\n      right-clickable="true"\r\n      show-filter="true"\r\n      show-export="true"\r\n      selection-mode="{{_view.listSpec.contentSpec.metadata.selectionMode}}"\r\n      is-draggable="{{_view.listSpec.contentSpec.metadata.isDraggable}}"\r\n      show-checkboxes-on-multi-selection="_view.listSpec.contentSpec.metadata.showCheckboxesOnMultiSelection === \'true\'"\r\n      live-refresh-enabled="_view.liveRefreshEnabled"\r\n      use-persistent-selection-context="{{_view.usePersistentSelectionContext || true}}"\r\n      override-metadata-from-server="{{!_view.listSpec}}"\r\n      class="fill-parent">\r\n</list-view>\r\n');
$templateCache.put('resources/ui/views/listview/ListViewTemplate.html','<vx-activity-indicator\r\n        is-visible="showLoadingIndicatorWhileFetchingColumns && !datagridOptions"\r\n        title="{{i18n(\'Common\', \'loadingTitle\')}}"\r\n        ng-attr-size="{{loadingIndicatorSize}}">\r\n</vx-activity-indicator>\r\n\r\n<div ng-if="datagridOptions"\r\n     vui-datagrid="datagridOptions"\r\n     vx-datagrid-row-right-click="showActionsMenu($event)"\r\n     vx-stretch-grid\r\n     vx-multi-datagrid-member\r\n     vx-datagrid-preselect-item="{{!!preselectComparator}}"\r\n     preselect-comparator="comparatorWrapper"\r\n     list-view-draggable="isDraggable"\r\n     kendo-resizablewidget\r\n     k-on-resize="resizeGrid();"\r\n     class="fill-parent">\r\n</div>\r\n');
$templateCache.put('resources/ui/views/mainlayout/AppBottomPanelView.html','<!-- Application Bottom Panel - Recent Tasks -->\r\n<div id="bottom-panel">\r\n   <vsc-recent-tasks-and-alarms-view></vsc-recent-tasks-and-alarms-view>\r\n   <toggle-splitter id="toggle-bottom-panel">\r\n\r\n      <span>\r\n         <svg id="Layer_2"\r\n               data-name="Layer 2"\r\n               xmlns="http://www.w3.org/2000/svg"\r\n               viewBox="0 0 42.84 47">\r\n         <defs><style>.cls-1 {\r\n            fill: #007bcc;\r\n         }</style></defs>\r\n         <title>ic_doublearrow</title>\r\n         <path class="cls-1"\r\n               d="M66.74,49.29L50,65.78,33.26,49.29a2.75,2.75,0,1,0-3.86,3.92L50,73.5,70.6,53.21A2.75,2.75,0,1,0,66.74,49.29Z"\r\n               transform="translate(-28.58 -26.5)"/>\r\n         <path class="cls-1"\r\n               d="M50,51.5L70.6,31.21a2.75,2.75,0,1,0-3.86-3.92L50,43.78,33.26,27.29a2.75,2.75,0,1,0-3.86,3.92Z"\r\n               transform="translate(-28.58 -26.5)"/>\r\n      </svg>\r\n      </span>\r\n   </toggle-splitter>\r\n   <span class="vui-icon-warning warning-icon"\r\n         ng-if="showWarningIcon"\r\n         ng-click="showLastError()"></span>\r\n</div>');
$templateCache.put('resources/ui/views/mainlayout/ChangePasswordDialog.html','<clr-modal\r\n   [clr-modal-static-backdrop]="true"\r\n   [(clr-modal-open)]="modalOptions.modalOpen"\r\n   [(clr-modal-size)]="\'md\'"\r\n   [clr-modal-closable]="true"\r\n   ng-controller="ChangePasswordDialogController as passwordController">\r\n   <h3 class="modal-title"\r\n       modal-title primary-title="modalOptions.title"\r\n       secondary-title="modalOptions.secondaryTitle"></h3>\r\n\r\n\r\n   <div class="modal-body show-tooltip-modal">\r\n      <form class="compact">\r\n         <section class="form-block">\r\n            <div class="form-group">\r\n               <label for="currentPassword">{{i18n(\'Common\', \'changepassword.currentPassword\')}}</label>\r\n               <input type="password"\r\n                      id="currentPassword"\r\n                      name="currentPassword"\r\n                      ng-model="passwordController.currentPassword"\r\n                      autofocus>\r\n\r\n            </div>\r\n            <div class="form-group">\r\n               <label for="newPassword">{{i18n(\'Common\', \'changepassword.newPassword\')}}</label>\r\n               <vsc-validate [required]="true"\r\n                            [validator]="passwordController.validator"\r\n                            [custom-validation-function]="passwordController.isValidPassword"\r\n                            class="vsc-validate-tooltip">\r\n                  <input ng-model="passwordController.newPassword"\r\n                         type="password"\r\n                         id="newPassword"/>\r\n               </vsc-validate>\r\n            </div>\r\n            <div class="form-group">\r\n               <label for="confirmPassword">{{i18n(\'Common\', \'changepassword.newPasswordConfirm\')}}</label>\r\n               <vsc-validate [required]="true"\r\n                            [validator]="passwordController.validator"\r\n                            [custom-validation-function]="passwordController.isValidPassword"\r\n                            class="vsc-validate-tooltip">\r\n                  <input ng-model="passwordController.confirmPassword"\r\n                         type="password"\r\n                         id="confirmPassword"/>\r\n               </vsc-validate>\r\n            </div>\r\n         </section>\r\n      </form>\r\n   </div>\r\n   <div class="modal-footer">\r\n      <button type="button" class="btn btn-outline" ng-click="passwordController.onCancel()">\r\n         {{::i18n(\'Common\',\'cancelButtonLabel\')}}\r\n      </button>\r\n      <button type="button" class="btn btn-primary" ng-click="passwordController.onSave()"\r\n              ng-disabled="passwordController.okButtonDisabled()">\r\n         {{::i18n(\'Common\', \'saveButtonLabel\')}}\r\n      </button>\r\n   </div>\r\n</clr-modal>\r\n');
$templateCache.put('resources/ui/views/mainlayout/MainTemplate.html','<div id="MainTemplateController" ng-controller="MainTemplateController">\r\n   <div class="skip-links-container">\r\n      <a class="skip-link" ng-click="skipToMainContent()" href>{{::i18n(\'Common\', \'skipToMainContentLink\')}}</a>\r\n   </div>\r\n   <vsc-global-notification-bar></vsc-global-notification-bar>\r\n   <div class="app-header" onload="onHeaderLoaded()"\r\n         ng-include="\'resources/ui/views/controlbar/ControlBarView.html\'">\r\n   </div>\r\n\r\n   <div class="app-frame-outer">\r\n      <div class="app-frame-inner">\r\n         <div id="vertical-panel" class="vui-vertical-panel">\r\n            <!-- App top -->\r\n            <div id="horizontal-panel" class="vui-horizontal-panel">\r\n               <left-panel></left-panel>\r\n               <center-panel></center-panel>\r\n            </div>\r\n\r\n            <bottom-panel id="bottom-panel-pane" ng-hide="!splitterReady"></bottom-panel>\r\n         </div>\r\n      </div>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/objectnavigator/CategoryNodeListView.html','<div class="fill-parent category-node-object-navigator" ng-controller="CategoryNodeController">\r\n   <div class="containsScrollable" role="tree" tabindex="0">\r\n      <ul role="group" class="object-navigator-list scrollable" ng-if="node.children.length" aria-expanded="true">\r\n         <li role="group" ng-repeat="node in node.children" ng-class="{objNavSeparator: !$first}">\r\n            <ul class="object-navigator-list" ng-if="node.children.length" role="group" >\r\n               <li  ng-repeat="node in node.children"\r\n                    ng-click="selectItem(node)"\r\n                    tabindex="-1"\r\n                    role="treeitem"\r\n                    aria-expanded="true"\r\n                    aria-selected="{{isItemSelected(node) ? \'true\' : \'false\'}}">\r\n                  <a class="object"\r\n                     ng-class="{\'selected\': isItemSelected(node)}">\r\n                     <span ng-class="node.icon"></span>\r\n                     <span class="object-navigator-label"\r\n                           ng-attr-title="{{node.title}}"\r\n                           ng-bind="node.title"></span>\r\n                  </a>\r\n               </li>\r\n            </ul>\r\n         </li>\r\n      </ul>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/objectnavigator/CategoryNodeTreeSeparatorView.html','<div class="containsScrollable" ng-controller="CategoryNodeController"\r\n     tabindex="0" role="tree"\r\n     aria-label="{{node.title}}">\r\n\r\n   <div class="scrollable title-offset pull-top" ng-if="node.children.length"\r\n         ng-include="\'tree_item_renderer.html\'">\r\n   </div>\r\n\r\n   <script type="text/ng-template" id="tree_item_renderer.html">\r\n      <ul class="object-navigator-list seperated-view" role="group">\r\n         <li ng-repeat="node in node.children">\r\n            <div ng-if="node.children.length"\r\n                 class="object"\r\n                 role="treeitem"\r\n                 aria-label="{{node.title}}"\r\n                 tabindex="-1" >\r\n               <div  class="inline"></div>\r\n                  <span class="object-navigator-label short-label bold"\r\n                        ng-attr-title="{{node.title}}">\r\n                     {{node.title}}-title\r\n                  </span>\r\n            </div>\r\n            <a class="object" ng-if="!node.children.length"\r\n                  ng-class="{selected: node.uid==selectedUid || (selectedUid == null && topNode.children[0] == node) }"\r\n                  ng-click="selectItem(node)"\r\n                  role="treeitem" tabindex="-1">\r\n               <span ng-class="node.icon"></span>\r\n               <span class="object-navigator-label short-label"\r\n                     ng-attr-title="{{node.title}}">\r\n                        {{node.title}}-title1\r\n               </span>\r\n               <span class="object-navigator-counter"\r\n                     ng-if="!(node.count == null)">\r\n                  {{node.count}}\r\n               </span>\r\n               <span class="vui-icon-object-nav-pan" ng-if="node.viewOpenedUponFocus"></span>\r\n            </a>\r\n            <div ng-if="node.children.length" ng-include="\'tree_item_renderer.html\'">\r\n            </div>\r\n            <hr class="navigator-item-seperator" ng-if="node.level===1">\r\n         </li>\r\n      </ul>\r\n   </script>\r\n</div>');
$templateCache.put('resources/ui/views/objectnavigator/CategoryNodeTreeView.html','<div class="containsScrollable" ng-controller="CategoryNodeController"\r\n     tabindex="0" role="tree"\r\n     aria-label="{{node.title}}">\r\n\r\n   <div class="object-navigator-heading bold initial-height">{{node.title}}</div>\r\n\r\n   <div class="scrollable title-offset" ng-if="node.children.length"\r\n        ng-include="\'tree_item_renderer.html\'">\r\n   </div>\r\n\r\n   <script type="text/ng-template" id="tree_item_renderer.html">\r\n      <ul class="object-navigator-list" collapse="node.collapse" role="group" ng-class="{closed: node.collapse}">\r\n         <li ng-repeat="node in node.children">\r\n            <div class="object" ng-if="node.children.length" role="treeitem" aria-selected="false" aria-expanded="{{node.collapse ? \'false\' : \'true\'}}">\r\n               <span vx-collapse-icon="node.collapse" >\r\n               </span>\r\n               <span class="object-navigator-label short-label bold"\r\n                     ng-attr-title="{{node.title}}">\r\n                  {{node.title}}\r\n               </span>\r\n            </div>\r\n\r\n            <a class="object" ng-if="!node.children.length"\r\n               ng-class="{selected: node.uid==selectedUid ||\r\n                  (selectedUid == null && topNode.children[0] == node) }"\r\n               ng-click="selectItem(node)"\r\n               role="treeitem" aria-label="{{::node.title}}"\r\n               aria-selected="{{node.uid==selectedUid}}">\r\n               <span ng-class="node.icon"></span>\r\n               <span class="object-navigator-label"\r\n                     ng-attr-title="{{node.title}}">\r\n                  {{node.title}}\r\n               </span>\r\n               <span class="vui-icon-object-nav-pan" ng-if="node.viewOpenedUponFocus" >\r\n               </span>\r\n            </a>\r\n\r\n            <div ng-if="node.children.length" ng-include="\'tree_item_renderer.html\'">\r\n            </div>\r\n         </li>\r\n      </ul>\r\n   </script>\r\n\r\n</div>');
$templateCache.put('resources/ui/views/objectnavigator/InventoryTreeView.html','<script type="text/ng-template" id="hosts_clusters_inv_tree.html">\r\n<div ng-if="ctrl.isTreeLoadingAllowed(\'vsphere.core.physicalInventorySpec\')">\r\n   <vx-activity-indicator is-visible="ctrl.hidingVms"\r\n                          is-interactive="false"\r\n                          size="large">\r\n\r\n   </vx-activity-indicator>\r\n   <div  class="scrollableInventoryTree tid-physical-inventory-tree"\r\n      vx-tree-view\r\n      vx-tree-right-click="ctrl.showActionsMenu($event)"\r\n      tree-id="vsphere.core.physicalInventorySpec"\r\n      options="persistselection"\r\n      select-node="ctrl.selectedObjectByTreeId[\'vsphere.core.physicalInventorySpec\']"\r\n      on-change="ctrl.onChange(objRef, \'vsphere.core.physicalInventorySpec\')"\r\n      config="ctrl.treeConfig">\r\n   </div>\r\n</div>\r\n</script>\r\n\r\n<script type="text/ng-template" id="vms_templates_inv_tree.html">\r\n<div ng-if="ctrl.isTreeLoadingAllowed(\'vsphere.core.virtualInventorySpec\')">\r\n   <div class="scrollableInventoryTree tid-virtual-inventory-tree"\r\n      vx-tree-view\r\n      vx-tree-right-click="ctrl.showActionsMenu($event)"\r\n      tree-id="vsphere.core.virtualInventorySpec"\r\n      options="persistselection"\r\n      select-node="ctrl.selectedObjectByTreeId[\'vsphere.core.virtualInventorySpec\']"\r\n      on-change="ctrl.onChange(objRef, \'vsphere.core.virtualInventorySpec\')"\r\n      config="ctrl.treeConfig">\r\n   </div>\r\n</div>\r\n</script>\r\n\r\n<script type="text/ng-template" id="inv_data_storage_tree.html">\r\n<div ng-if="ctrl.isTreeLoadingAllowed(\'vsphere.core.storageInventorySpec\')">\r\n   <div class="scrollableInventoryTree tid-storage-inventory-tree"\r\n      vx-tree-view\r\n      vx-tree-right-click="ctrl.showActionsMenu($event)"\r\n      tree-id="vsphere.core.storageInventorySpec"\r\n      options="persistselection"\r\n      select-node="ctrl.selectedObjectByTreeId[\'vsphere.core.storageInventorySpec\']"\r\n      on-change="ctrl.onChange(objRef, \'vsphere.core.storageInventorySpec\')"\r\n      config="ctrl.treeConfig">\r\n   </div>\r\n</div>\r\n</script>\r\n\r\n<script type="text/ng-template" id="inv_networking_tree.html">\r\n<div ng-if="ctrl.isTreeLoadingAllowed(\'vsphere.core.networkingInventorySpec\')">\r\n   <div class="scrollableInventoryTree tid-networking-inventory-tree"\r\n      vx-tree-view\r\n      vx-tree-right-click="ctrl.showActionsMenu($event)"\r\n      tree-id="vsphere.core.networkingInventorySpec"\r\n      options="persistselection"\r\n      select-node="ctrl.selectedObjectByTreeId[\'vsphere.core.networkingInventorySpec\']"\r\n      on-change="ctrl.onChange(objRef, \'vsphere.core.networkingInventorySpec\')"\r\n      config="ctrl.treeConfig">\r\n   </div>\r\n</div>\r\n</script>\r\n\r\n<div class="fill-parent" ng-controller="InventoryTreeViewController as ctrl">\r\n   <div vui-tabs="tabOptions" class="nav-without-scroll"></div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/objectnavigator/ObjectListView.html','<div ng-controller="ObjectListViewController as objListControl" class="fill-parent non-scrollable">\r\n    <!-- selected item -->\r\n    <div id="object_list_view_top"\r\n            ng-click="openDomainView()"\r\n            ng-attr-title="{{::relation.label}}"\r\n            class="nav-top-block obj-nav-counter">\r\n        <span class="obj-nav-counter-label">{{::relation.label}}</span>\r\n        <span class="object-navigator-counter">{{virtualListCount}}</span>\r\n    </div>\r\n    <div class="nav-bottom-block panel-content objNavSeparator fill-parent-flex-column">\r\n        <!-- Progress bar / loading -->\r\n        <div class="progress progress-striped active" ng-show="!gridOpts">\r\n            <div class="progress-bar" role="alert"\r\n                 aria-live="assertive" aria-label="{{::i18n(\'Common\', \'saveLoading\')}}">\r\n            </div>\r\n        </div>\r\n        <!-- virtual list -->\r\n        <div ng-if="gridOpts"\r\n             vui-datagrid="gridOpts"\r\n             vx-datagrid-row-right-click="showActionsMenu($event)"\r\n             class="fill-parent flex-grid"\r\n             vx-stretch-grid\r\n             list-view-drop-target="true"\r\n             id="navigator-virtual-list"\r\n             ng-keydown="console.log($event)"></div>\r\n    </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/objectnavigator/ObjectNavigator.html','<div class="panel-inner">\r\n   <div class="panel-content">\r\n      <div class="object-navigator panel-content" vx-view="history[history.currentIndex].naviView">\r\n      </div>\r\n   </div>\r\n</div>');
$templateCache.put('resources/ui/views/objectnavigator/RelatedItemsView.html','<div ng-controller="RelatedItemsController as relatedItemsController" class="fill-parent non-scrollable">\r\n\r\n   <div vui-splitter="relatedItemsController.splitterOptions" class="related-items-pane-splitter">\r\n\r\n      <!-- splitter-top -->\r\n      <div id="related-items-top-pane" class="nav-top-pane-relations-mode rel-items-splitter-top" role="group" tabindex="-1">\r\n\r\n         <!-- splitter-top : primary-list-item -->\r\n         <span ng-if="relatedItemsController.focusObject" class="primary-list-item">\r\n            <div class="obj-nav-counter" title="{{relatedItemsController.focusObject.name + relatedItemsController.focusObject.taggingLabel}}"\r\n               ng-click="relatedItemsController.navigateToFocusObject()"\r\n               vx-right-click="relatedItemsController.showActionsMenu($event, relatedItemsController.focusObject)" role="treeitem">\r\n               <span class="obj-nav-counter-icon">\r\n\r\n                  <span ng-if="!iconNs" ng-class="relatedItemsController.focusObject.primaryIconId"></span>\r\n                  <span ng-if="iconNs === \'clr\'">\r\n                     <clr-icon shape="{{relatedItemsController.focusObject.primaryIconId}}"></clr-icon>\r\n                  </span>\r\n               </span>\r\n               <span class="obj-nav-counter-label object-navigator-label"\r\n                     ng-attr-title="{{relatedItemsController.focusObject.name + relatedItemsController.focusObject.taggingLabel}}">\r\n                  {{relatedItemsController.focusObject.name + relatedItemsController.focusObject.taggingLabel}}\r\n               </span>\r\n            </div>\r\n         </span>\r\n\r\n         <!-- splitter-top : nav-top block -->\r\n         <div class="nav-top-block" role="tree" tabindex="0">\r\n            <ul id="related_items_view_top_navigator_list" class="object-navigator-list" role="group">\r\n               <li ng-repeat="node in relatedItemsController.nodes">\r\n                  <a class="object"\r\n                     ng-class="{\'selected\': node==relatedItemsController.selectedRelation}"\r\n                     aria-selected="{{node==relatedItemsController.selectedRelation ? \'true\' : \'false\'}}"\r\n                     ng-click="relatedItemsController.selectRelation(node)" tabindex="-1"\r\n                     role="treeitem">\r\n                     <span ng-class="node.icon"></span>\r\n                     <span class="object-navigator-label" ng-attr-title="{{node.label}}">{{node.label}}</span>\r\n                     <span class="object-navigator-counter">{{node.count}}</span>\r\n                  </a>\r\n               </li>\r\n            </ul>\r\n         </div>\r\n\r\n      </div>\r\n\r\n\r\n\r\n      <!-- splitter-bottom -->\r\n      <div class="rel-items-splitter-bottom">\r\n\r\n         <!-- selected item -->\r\n         <div class="object-navigator-title"  ng-hide="relatedItemsController.selectedRelation==null">\r\n            {{relatedItemsController.selectedRelation.label}}\r\n         </div>\r\n\r\n         <div class="nav-bottom-block panel-content objNavSeparator">\r\n            <!-- splitter-bottom : Progress bar / loading -->\r\n            <div class="progress progress-striped active"\r\n                 ng-show="relatedItemsController.isBottomPanelLoading"\r\n                 style="width: 99%">\r\n               <div class="progress-bar" role="alert"\r\n                    aria-live="assertive" aria-label="{{::i18n(\'Common\', \'saveLoading\')}}">\r\n               </div>\r\n            </div>\r\n            <!-- virtual list -->\r\n            <div ng-if="gridOpts"\r\n                 vui-datagrid="gridOpts"\r\n                 vx-datagrid-row-right-click="showActionsMenu($event)"\r\n                 vx-datagrid-preselect-item="true"\r\n                 preselect-comparator="preselectComparator"\r\n                 class="fill-parent flex-grid"\r\n                 vx-stretch-grid\r\n                 list-view-drop-target="true"\r\n                 id="related-items-virtual-list"\r\n            ng-keydown="console.log($event)">\r\n            </div>\r\n         </div>\r\n      </div>\r\n\r\n   </div>\r\n\r\n</div>');
$templateCache.put('resources/ui/views/objectnavigator/SavedSearchView.html','Saved Search View- Not implemented');
$templateCache.put('resources/ui/views/objectnavigator/SearchLeftPane.html','<div class="fill-parent simple-search-left-pane">\r\n   <vsc-search-left-pane></vsc-search-left-pane>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/performance/PerformanceView.html','<span ng-controller="PerformanceViewController" class="perf">\r\n   <div class="results-quicksearch-container perf-container pull-right"\r\n        ng-click="showPerfEntries($event)"\r\n        ng-if="showList" tabindex="-1">\r\n      <div class="results-padding-LR">\r\n         <table>\r\n            <tr ng-show="perfData.perfEntries">\r\n               <td class="results-cell-white">\r\n                  <ul class="results-menu-list-right">\r\n                     <li>Total Time:\r\n                        <span class="time-badge">{{perfData.timeInSeconds}}s</span>\r\n                     <li>\r\n                     <li>UI Rendering Time:\r\n                        <span class="time-badge">{{perfData.uiTimeInSeconds}}s</span>\r\n                     <li>\r\n                     <li>AJAX Time:\r\n                        <span class="time-badge">{{perfData.ajaxTimeInSeconds}}s</span>\r\n                     <li>\r\n                     <li>Total AJAX Calls:\r\n                        <span class="time-badge">{{perfData.ajaxCallsCount}}</span>\r\n                     <li>\r\n                     <li>Total Watchers:\r\n                        <span class="time-badge">{{perfData.watchersCount}}</span>\r\n                     </li>\r\n                     <li style="font-weight: bold; padding-top: 10px;">AJAX Details</li>\r\n                     <li ng-repeat="perfEntry in perfData.perfEntries">\r\n                        {{perfEntry.name}}\r\n                        <span class="time-badge">{{perfEntry.duration}}</span>\r\n                     </li>\r\n                  </ul>\r\n               </td>\r\n            </tr>\r\n         </table>\r\n      </div>\r\n   </div>\r\n\r\n   <a class="nav-link">\r\n      <span class="perf-badge"\r\n            ng-class="{\'perf-badge-threshold-exceeded\' : isTimeAboveThreshold()}"\r\n            ng-click="showPerfEntries($event)" tabindex="-1">\r\n         Total time(s): {{perfData.timeInSeconds}}</span>\r\n   </a>\r\n   <a class="nav-link">\r\n      <span class="perf-badge"\r\n            ng-class="{\'perf-badge-threshold-exceeded\' : areWatchersAboveThreshold()}"\r\n            ng-click="showPerfEntries($event)" tabindex="-1">\r\n         Watchers: {{perfData.watchersCount}}</span>\r\n   </a>\r\n</span>');
$templateCache.put('resources/ui/views/plugins/htmlBridgePluginModalTemplate.html','<div class="modal sandbox-modal">\r\n   <div class="modal-dialog" role="dialog">\r\n      <div class="modal-content">\r\n         <div class="modal-header"\r\n               ng-style="{\r\n                  width: modalOptions.dialogData.pluginSize.width\r\n               }">\r\n            <button aria-label="{{i18n(\'Common\', \'close.label\')}}"\r\n                  class="close" type="button"\r\n                  ng-click="closeModal()">\r\n               <clr-icon shape="close"></clr-icon>\r\n            </button>\r\n            <h3 class="modal-title">\r\n               <span class="modal-title-icon {{modalOptions.dialogData.iconClass}}"></span>\r\n               <span class="modal-title-text"\r\n                     title="{{modalOptions.dialogData.title}}">\r\n                  {{modalOptions.dialogData.title}}\r\n               </span>\r\n            </h3>\r\n         </div>\r\n         <div class="modal-body"\r\n               ng-style="{\r\n                  width: modalOptions.dialogData.pluginSize.width,\r\n                  height: modalOptions.dialogData.pluginSize.height\r\n               }">\r\n            <html-bridge-plugin-modal-iframe\r\n                  url="modalOptions.dialogData.url"\r\n                  close-modal="closeModal()">\r\n            </html-bridge-plugin-modal-iframe>\r\n         </div>\r\n      </div>\r\n   </div>\r\n   <div class="modal-backdrop" aria-hidden="true"></div>\r\n</div>');
$templateCache.put('resources/ui/views/plugins/pluginModalTemplate.html','<div class="modal sandbox-modal">\r\n   <div class="modal-dialog" role="dialog">\r\n      <div class="modal-content">\r\n         <div class="modal-header"\r\n               ng-if="modalOptions.dialogData.closable || modalOptions.dialogData.title"\r\n               ng-style="{\r\n                  width: modalOptions.dialogData.pluginSize.width\r\n               }">\r\n            <button aria-label="{{i18n(\'Common\', \'close.label\')}}"\r\n                  class="close" type="button"\r\n                  ng-if="modalOptions.dialogData.closable"\r\n                  ng-click="closeModal()">\r\n               <clr-icon shape="close"></clr-icon>\r\n            </button>\r\n            <h3 class="modal-title"\r\n                  ng-if="modalOptions.dialogData.title">\r\n               <span class="modal-title-text"\r\n                     title="{{modalOptions.dialogData.title}}">\r\n                  {{modalOptions.dialogData.title}}\r\n               </span>\r\n            </h3>\r\n         </div>\r\n         <div class="modal-body"\r\n               ng-style="{\r\n                  width: modalOptions.dialogData.pluginSize.width,\r\n                  height: modalOptions.dialogData.pluginSize.height\r\n               }">\r\n            <plugin-iframe view-url="modalOptions.dialogData.url"\r\n                  class="sandbox-iframe"\r\n                  context="modalOptions.dialogData.iframeContext"\r\n                  remote-plugin-extension-context="modalOptions.dialogData.remotePluginExtensionContext"\r\n                  is-modal="true">\r\n            </plugin-iframe>\r\n         </div>\r\n      </div>\r\n   </div>\r\n   <div class="modal-backdrop" aria-hidden="true"></div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/plugins/remotePluginExtensionContextSelector.html','<div ng-controller="RemotePluginExtensionContextSelectorController as ctrl"\r\n      class="fill-parent remote-plugin-extension-context-selector">\r\n   <div vx-refreshable refresh="ctrl.onRefresh()"\r\n         class="remote-plugin-extension-context-selector-header">\r\n      <h6>{{_view.remotePluginExtensionContext.label}}</h6>\r\n      <div class="instance-dropdown-container" ng-show="ctrl.showDropdown">\r\n         <vsc-plugin-instance-dropdown\r\n               [items]="ctrl.dropdownItems"\r\n               [(selected-item-id)]="ctrl.selectedRpxcId">\r\n         </vsc-plugin-instance-dropdown>\r\n      </div>\r\n   </div>\r\n   <div ng-repeat="(rpxcId, navigationNode) in ctrl.childRpxcIdToNavigationNode track by rpxcId"\r\n         ng-if="rpxcId === ctrl.selectedRpxcId"\r\n         vx-view="navigationNode"></div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/plugins/sandboxTemplate.html','<div ng-controller="sandboxTemplateController as ctrl" class="fill-parent">\r\n   <plugin-iframe view-url="ctrl.url" view-url-params="ctrl.urlParams"\r\n         view-id="ctrl.viewId"\r\n         remote-plugin-extension-context="ctrl.remotePluginExtensionContext"\r\n         class="fill-parent">\r\n   </plugin-iframe>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/relateditems/RelatedItemsTabContent.html','<div class="fill-parent vertical-flex-container">\r\n\r\n   <div ng-show="_view.$children.length > 1">\r\n      <div vx-navi-tab-headers="_view" level="second" name-field="\'label\'"></div>\r\n   </div>\r\n\r\n   <div class="sub-tab-content">\r\n      <div vx-view class="content fill-parent"></div>\r\n   </div>\r\n</div>');
$templateCache.put('resources/ui/views/resourceinfo/RIStackEditorView.html','<div ng-controller="RIStackEditorController">\r\n\r\n    <div vx-stackview>\r\n        <div ng-repeat="prop in data.info.properties" vx-stackview-item\r\n            level="0">\r\n            <div vx-stackview-item-label>{{prop.title}}</div>\r\n            <div vx-stackview-item-value>\r\n                <div ng-switch="prop.immutable">\r\n                    <div ng-switch-when="true">\r\n                        <!--  TODO: maybe factor the real only field display into a directive -->\r\n                        {{data.values[prop.name] | dataFormat:prop.valueTypeName }}\r\n                    </div>\r\n                    <div ng-switch-default>\r\n                        <div ng-switch="prop.valueTypeName">\r\n                            <div ng-switch-when="String">\r\n                                <input ng-model="data.values[prop.name]" type="text">\r\n                            </div>\r\n                            <div ng-switch-when="password">\r\n                                <input ng-model="data.values[prop.name]"  type="password">\r\n                            </div>\r\n                            <div ng-switch-when="IPv4">\r\n                                <input ng-model="data.values[prop.name]" type="text">\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n    </div>');
$templateCache.put('resources/ui/views/search/QuickSearchPopupTemplate.html','<div class="results-quicksearch-container results-quicksearch-position" ng-style="{display: isOpen()&&\'block\' || \'none\'}">\r\n   <div class="results-padding-LR">\r\n      <div class="results-notification results-footer-searching-text-black" ng-style="{display: noResults && !isSearching() || \'none\'}">\r\n         <p>{{i18n(\'Common\',\'noResultsFound\')}}</p>\r\n      </div>\r\n      <table>\r\n         <tr ng-repeat="resultType in results">\r\n            <td class="results-cell-blue">\r\n               <span ng-class="\'{{resultType.icon}}\'"></span>\r\n               {{resultType.label}}\r\n            </td>\r\n            <td class="results-cell-white">\r\n               <ul class="results-menu-list-right-focus">\r\n                  <li   ng-class="{\'first-item\':$first,\'last-item\':$last , \'selected\': isActive({{resultItem.index}})}"\r\n                        ng-click="selectMatch(resultItem.index)"\r\n                        ng-repeat="resultItem in resultType.results">\r\n                           <a>{{resultItem.name}}</a>\r\n                  </li>\r\n               </ul>\r\n            </td>\r\n         </tr>\r\n      </table>\r\n\r\n      <div class="results-footer-searching-text-black" ng-show="isSearching()">\r\n         <p>{{i18n(\'Common\',\'searching\')}}</p>\r\n      </div>\r\n\r\n      <div class="results-footer-searching-text-blue" ng-show="!noResults && !isSearching()">\r\n         <a class="all-results-link"\r\n            ng-click="selectMatch(resultCount)" href="">{{i18n(\'Common\',\'showAllResults\')}}</a>\r\n      </div>\r\n   </div>\r\n</div>');
$templateCache.put('resources/ui/views/search/QuickSearchView.html','<div ng-controller="QuickSearchViewController" class="quickSearchContainer" >\r\n      <clr-icon shape="search" size="24" ng-click="typeAheadConfig.doSearch()" class="search-icon"></clr-icon>\r\n      <input type="text"\r\n             ng-attr-placeholder="{{i18n(\'Common\',\'search\')}}" ng-model="searchTerm"\r\n             ng-trim="true" vx-typeahead="typeAheadConfig"\r\n             accesskey="s"\r\n             aria-label="{{::i18n(\'Common\', \'ariaLabel.search.input\')}}">\r\n      <div vx-quicksearch-popup="typeAheadConfig"></div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/search/SavedSearchView.html','Not implemented');
$templateCache.put('resources/ui/views/search/search-center-pane.html','<vx-activity-indicator is-visible="$ctrl.searchResponse == null">\r\n</vx-activity-indicator>\r\n\r\n\r\n<div ng-if="$ctrl.searchResponse != null" class="search-center-pane">\r\n   <div class="search-header" aria-live="polite">\r\n      <clr-alert ng-if="$ctrl.searchOperationResponse"\r\n            [clr-alert-type]="\'{{ $ctrl.searchOperationResponse.isSuccessful === true ? \'success\' : \'danger\' }}\'"\r\n            [clr-alert-closable]="true">\r\n         <clr-alert-item>\r\n            <span class="alert-text">\r\n               {{ $ctrl.i18nService.getString(\'Common\', $ctrl.searchOperationResponse.messageKey) }}\r\n            </span>\r\n         </clr-alert-item>\r\n      </clr-alert>\r\n\r\n      <clr-alert ng-if="$ctrl.searchResponse.selection.totalCount >= 1000"\r\n            [clr-alert-type]="\'alert-warning\'"\r\n            [clr-alert-closable]="false">\r\n         <clr-alert-item>\r\n            <span class="alert-text">\r\n               {{ $ctrl.i18nService.getString(\'Common\', \'search.maxResults.warning\') }}\r\n            </span>\r\n         </clr-alert-item>\r\n      </clr-alert>\r\n\r\n      <div class="saved-search-bar" ng-if="$ctrl.searchResponse.savedSearch">\r\n         {{ $ctrl.i18nService.getString(\'Common\', \'search.saveSearch\', $ctrl.searchResponse.savedSearch) }}\r\n      </div>\r\n\r\n      <div class="search-title-bar">\r\n         <span class="search-title">\r\n            {{ $ctrl.i18nService.getString(\'Common\', \'resultsFoundWithData\', $ctrl.searchResponse.query) }}\r\n         </span>\r\n         <vsc-search-operations></vsc-search-operations>\r\n      </div>\r\n   </div>\r\n\r\n   <vsc-search-center-pane class="panel search-results-panel"\r\n                           ng-if="!$ctrl.viewNode"\r\n                           [search-left-pane]="{{ $ctrl.searchResponse | json }}">\r\n   </vsc-search-center-pane>\r\n\r\n   <div class="panel search-results-panel" ng-if="$ctrl.viewNode">\r\n      <div class="datagrid-container fill-parent" style="width: calc(100% - 36px * 2)">\r\n         <div vx-view="$ctrl.viewNode" class="fill-parent"></div>\r\n      </div>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/search/SearchView.html','<!-- View for Simple and Advanced Search UI -->\r\n<div class="fill-parent simple-search">\r\n   <search-center-pane class="simple-search"></search-center-pane>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/serverobject/ServerObjectView.html','<div ng-controller="ServerObjectViewController">\r\n    <div class="titlebar" ng-if="_view.getSelectedChild()">\r\n        <div class="object horizontal-flex-container" vx-refreshable\r\n             watch-objects=\'{{watchForObjects}}\' refresh=\'getViewData()\' has-object-state-property="true">\r\n\r\n            <div class="titlebar-icon" ng-if="!!currentObject.primaryIconId &amp;&amp; !currentObject.iconNs" ng-class="currentObject.primaryIconId"></div>\r\n            <div class="titlebar-icon" ng-if="!!currentObject.primaryIconId &amp;&amp; currentObject.iconNs === \'clr\'">\r\n                <clr-icon shape="{{currentObject.primaryIconId}}"></clr-icon>\r\n            </div>\r\n            <h1 class="summary-name-label titlebar-title"><span class="sr-only">{{translatedObjectType}}</span>{{currentObject.name}}</h1>\r\n            <div class="divider titlebar-divider" ng-if="isVmObject"></div>\r\n            <vm-quick-power-operations ng-if="isVmObject"></vm-quick-power-operations>\r\n            <div class="divider titlebar-divider"></div>\r\n\r\n           <div class="titlebar-actionable">\r\n                <a class="summary-action-link" data-test-id="summaryActionLink"\r\n                   href="" ng-click="showActionsMenu($event)">\r\n                <span class="actionable-title" ng-bind="i18n(\'Common\',\'actionsButton.label\')"\r\n                ></span><span class="icon-dropdownToggle actionable-toggle"></span>\r\n            </a>\r\n               </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div vx-view></div>\r\n\r\n    <div ng-if="!_view.getSelectedChild()" class="centered-text-block object-not-found fill-parent absolute-container">\r\n        {{i18n(\'CommonUi\', \'objectNotFound.descr\')}}\r\n    </div>\r\n\r\n</div>\r\n');
$templateCache.put('resources/ui/views/settings/vxGridviewSettings.html','<div class="flex-to-absolute-positioning-container">\r\n   <div class="flex-to-absolute-positioning-container-inner">\r\n      <div vx-refreshable watch-objects="{{gridviewSettings.watchForObjects}}"\r\n            refresh="gridviewSettings.getData()"\r\n            live-refresh-properties="gridviewSettings.liveRefreshProperties"\r\n            delay-refresh-on-object-updates-by="{{gridviewSettings.delayRefreshTimeInMsecs}}"></div>\r\n      <!--Wrapper divs needed since replace=true for this directive and vui-datagrid and vx-refreshable have isolate scope.-->\r\n      <div vui-datagrid="gridviewSettings.riDatagridOptions" class="fill-parent"></div>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/settings/vxStackviewSettings.html','<div\r\n    ng-if="stackviewSettings.datasetSupported"\r\n    vx-refreshable\r\n    watch-objects="{{stackviewSettings.watchForObjects}}"\r\n    refresh="stackviewSettings.getData()"\r\n    delay-refresh-on-object-updates-by="{{stackviewSettings.delayRefreshTimeInMsecs}}"\r\n    live-refresh-properties="stackviewSettings.liveRefreshProperties"\r\n    live-refresh-enabled="{{stackviewSettings.liveRefreshEnabled}}"\r\n></div>\r\n\r\n<div ng-if="!stackviewSettings.datasetSupported">{{stackviewSettings.unsupportedMessage}}</div>\r\n\r\n<clr-stack-view ng-if="stackviewSettings.datasetSupported" class="clr-component">\r\n   <clr-stack-block ng-repeat="item in stackviewSettings.stackViewData.blocks">\r\n      <clr-stack-label>{{item.label}}</clr-stack-label>\r\n      <clr-stack-content>{{item.content}}</clr-stack-content>\r\n   </clr-stack-block>\r\n</clr-stack-view>\r\n');
$templateCache.put('resources/ui/views/summary/SummaryView.html','<div ng-controller="SummaryViewController as ctrl" class="fill-parent">\r\n    <div ng-if="ctrl.newSummaryEnabled" class="summary-toggle">\r\n        <section class="form-block">\r\n            <div class="form-group">\r\n                <div class="toggle-switch">\r\n                    <input type="checkbox" id="new-summary"\r\n                           ng-checked="ctrl.showSummary"\r\n                           ng-click="ctrl.toggleNewSummary()">\r\n                    <label for="new-summary"></label>\r\n                </div>\r\n                <label class="summary-toggle-label">{{ctrl.newSummarySignpost.title}}</label>\r\n                <vsc-sign-post\r\n                        aria-label="ctrl.newSummarySignpost.title"\r\n                        [sign-post-header]="ctrl.newSummarySignpost.title"\r\n                        [sign-post-content]=ctrl.showSignPostMessage()\r\n                        [sign-post-position]="\'bottom-left\'">\r\n                </vsc-sign-post>\r\n            </div>\r\n        </section>\r\n    </div>\r\n\r\n    <vm-summary-view\r\n          ng-if="ctrl.showSummary"\r\n          [view-content-spec]="_view.contentSpec"\r\n          [plugins]="portletOptions.portlets"\r\n          class="fill-parent"></vm-summary-view>\r\n\r\n    <div ng-if="!ctrl.showSummary">\r\n        <div vx-summary="{{_view.contentSpec.metadata.summaryModel}}"\r\n             vx-summary-image="{{_view.contentSpec.metadata.summaryImage}}"\r\n             vx-resource-bundle="{{_view.contentSpec.metadata.resourceBundle}}"\r\n             vx-summary-image-template="{{_view.contentSpec.metadata.summaryImageTemplate}}"\r\n             vx-summary-action-ids="{{_view.contentSpec.metadata.actionIds}}"\r\n             live-refresh-properties="{{_view.contentSpec.metadata.liveRefreshProperties}}">\r\n        </div>\r\n\r\n        <div vx-issues-list vx-object-id="{{_route.objectId}}" vx-issues-extension-id="{{_view.contentSpec.metadata.issuesViewExtensionId}}">\r\n        </div>\r\n\r\n        <div ng-if="ctrl.loading" class="portlets-activity-indicator">\r\n            <vx-activity-indicator size="medium" is-visible="ctrl.loading"></vx-activity-indicator>\r\n        </div>\r\n\r\n        <div vx-portlets="portletOptions" class="vx-portlet-two-columns">\r\n        </div>\r\n    </div>\r\n\r\n</div>\r\n');
$templateCache.put('resources/ui/views/summary/vxIssuesListTemplate.html','<div vx-refreshable watch-objects=\'{{issuesListCtrl.objectId}}\' refresh=\'issuesListCtrl.getIssues()\'>\r\n    <div ng-repeat="issueGroup in issuesListCtrl.summaryIssuesGroups" class="alert" ng-class="issueGroup.icon.className"\r\n         role="region" ng-attr-aria-label="{{issueGroup.ariaLabel}}">\r\n\r\n        <div class="alert-items">\r\n            <div ng-repeat="issue in issueGroup.issues" class="alert-item static">\r\n\r\n                <div class="alert-icon-wrapper">\r\n                    <clr-icon class="alert-icon"\r\n                        ng-attr-shape="{{ issueGroup.icon.shape }}"\r\n                        vx-localized-aria-label="issueGroup.icon.ariaLabel"\r\n                        size="20"></clr-icon>\r\n                </div>\r\n\r\n                <span class="alert-text">\r\n                   <span ng-if="issue.entityName">\r\n                    <a href=""\r\n                       ng-click="issuesListCtrl.navigateToServerObjectViewsExtension(issue.entityId)"\r\n                       ng-bind="issue.entityName"></a>\r\n                   </span>\r\n                   <span ng-bind="issue.description"></span>\r\n                   <span ng-if="issue.kbNumber">\r\n                      <a ng-href="{{issuesListCtrl.VMWARE_KB_SITE}}{{issue.kbNumber}}" target="_blank">KB {{issue.kbNumber}}</a>\r\n                    </span>\r\n                </span>\r\n                <span class="alert-actions">\r\n                 <a ng-repeat="actionEvaluation in issue.actionEvaluations track by actionEvaluation.action.uid"\r\n                    ng-disabled="!actionEvaluation.available"\r\n                    ng-click="issuesListCtrl.invokeAction(actionEvaluation, issue)"\r\n                    ng-attr-aria-label="{{actionEvaluation.ariaLabel}}"\r\n                    ng-attr-title="{{actionEvaluation.ariaLabel ? null : actionEvaluation.action.description}}"\r\n                    ng-bind="actionEvaluation.action.label"\r\n                    href="" class="alert-action"></a>\r\n                 </span>\r\n            </div>\r\n        </div>\r\n\r\n    </div>\r\n    <div class="view-all-issues" ng-if="issuesListCtrl.totalCount > issuesListCtrl.ISSUE_COUNT_TO_SHOW">\r\n        <a href="" ng-click="issuesListCtrl.navigate(issuesListCtrl.issuesExtensionId, issuesListCtrl.objectId)">\r\n            {{issuesListCtrl.i18n(\'Common\',\'issueSummary.showAllLabelFormat\', issuesListCtrl.totalCount)}}\r\n        </a>\r\n    </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/summary/vxSummaryItemTemplate.html','<span tabindex="0" aria-label="{{getSummaryItemLabel(item)}}"\r\n      class="summary-label"\r\n      ng-bind="getSummaryItemLabel(item)"></span>\r\n\r\n<span tabindex="0" aria-label="{{getSummaryItemValue(item)}}" class="summary-value">\r\n   <span data-test-id="{{getSummaryItemLabel(item)}}" ng-if="!showingMoRef" ng-bind="getSummaryItemValue(item)"></span>\r\n   <span ng-if="showingMoRef">\r\n      <a ng-bind="getSummaryItemValue(item)" ng-click="onMoRefLinkClicked(item)" href=""></a>\r\n   </span>\r\n\r\n   <br/><a vui-sign-post=\'signPostParams\' ng-if="showSignPost" href=""\r\n            aria-label="{{signPostLinkAriaLabel}}">\r\n   {{signPostLinkText}}</a>\r\n</span>\r\n');
$templateCache.put('resources/ui/views/summary/vxSummaryTemplate.html','<!-- Copyright 2013 VMware, Inc. All rights reserved. - VMware Confidential -->\r\n<!-- A summary component that can build the resource meters and summary data dynamically.\r\n     Expected data structure:\r\n\r\n{\r\n    "name": "...",\r\n    "resourceMeters": [\r\n        {\r\n            "title": "CpuResourceDataItem.CpuLabel",\r\n            "free": "5GHz",\r\n            "used": "0GHz",\r\n            "capacity": "5GHz",\r\n            "progress": "0%"\r\n        },\r\n        {\r\n            "title": "MemoryResourceDataItem.MemoryLabel",\r\n            "free": "3GB",\r\n            "used": "2GB",\r\n            "capacity": "5GB",\r\n            "progress": "40%"\r\n        },\r\n        {\r\n            "title": "StorageResourceDataItem.StorageLabel",\r\n            "free": "4GB",\r\n            "used": "1GB",\r\n            "capacity": "5GB",\r\n            "progress": "20%"\r\n        },\r\n        ...\r\n    ],\r\n    "summaryItems": [\r\n        {\r\n            "label": "summaryView.vmCountLabel",\r\n            "value": "12"\r\n        },\r\n        {\r\n            "label": "summaryView.nicCountLabel",\r\n            "value": "1"\r\n        },\r\n    ],\r\n    "badges": [\r\n        {\r\n            "icon": "icon-vSphere-vendorDell",\r\n            "toolTip": "Dell Inc.",\r\n            "isToolTipLocalized": true\r\n        },\r\n        {\r\n            "icon": "icon-vSphere-vMotionEnabled",\r\n            "toolTip": ""summaryView.badge.vmotion",\r\n            "isToolTipLocalized": false\r\n        },\r\n    ]\r\n}\r\n\r\n<!-- A summary component that can show a thumbnail image or label\r\n     Expected data structures:\r\n{\r\n    "summaryData": {\r\n        "stateLabel": "Powered Off"\r\n    }\r\n}\r\n\r\n{\r\n    "summaryData": {\r\n        "imageUrl": "/resources/someImage.png"\r\n    }\r\n}\r\n\r\n{\r\n    "summaryData": {\r\n        "imageBytes": "AAABBBCCCDDD",\r\n        "imageCaption": "Powered On"\r\n    }\r\n}\r\n-->\r\n<div class="summary" vx-refreshable watch-objects="{{entityReference}}" refresh="getObjSummaryData()"\r\n      live-refresh-properties="liveRefreshProps" ng-if="liveRefreshProps" tabindex="0">\r\n   <div class="summary-image-block" ng-if="!summaryImageTemplate">\r\n      <img ng-src="{{imageUrl}}" alt="">\r\n   </div>\r\n   <div ng-if="summaryImageTemplate" ng-include="summaryImageTemplate"></div>\r\n\r\n   <div class="summary-info-block">\r\n\r\n      <ul class="summary-items-list">\r\n         <li ng-repeat="summaryItem in summaryData.summaryItems">\r\n             <vx-summary-item ng-if="summaryItem.available" item="summaryItem" resource-bundle="resourceBundle" sign-post-title="summaryData.name"></vx-summary-item>\r\n         </li>\r\n      </ul>\r\n\r\n      <div class="summary-badges">\r\n         <span ng-if="badge.icon || badge.base64EncodedImage"\r\n               ng-class="{\'{{badge.icon}}\': badge.icon}"\r\n               class="badge-item"\r\n               ng-repeat="badge in summaryData.badges"\r\n               title="{{getBadgeTooltip(badge)}}"\r\n               aria-label="{{getBadgeTooltip(badge)}}"\r\n               tabindex="0">\r\n            <img ng-if="badge.base64EncodedImage && !badge.icon"\r\n                  ng-attr-src="{{\'data:image/png;base64,\'+badge.base64EncodedImage}}" alt="">\r\n         </span>\r\n      </div>\r\n   </div>\r\n\r\n   <div class="summary-meters-block" ng-if="summaryData.resourceMeters">\r\n      <ul class="summary-items-list">\r\n         <li class="resource-meter"\r\n             ng-repeat="resourceMeter in summaryData.resourceMeters">\r\n            <span class="title">{{i18n(\'Common\', resourceMeter.title)}}</span>\r\n            <span class="resource-meter-top-right-info">\r\n               {{getFreeCapacity(resourceMeter)}}\r\n            </span>\r\n            <div class="progress" ng-class="resourceMeter.progress > 100 ? \'danger\' : \'\'">\r\n               <progress max="100" ng-value="{{resourceMeter.progress}}"\r\n                         data-displayval="{{resourceMeter.progress}}%">\r\n               </progress>\r\n            </div>\r\n            <span class="resource-meter-bottom-left-info">\r\n               {{i18n(\'Common\', \'ResourceAllocationComponent.usedCapFormat\', resourceMeter.used)}}\r\n            </span>\r\n            <span class="resource-meter-bottom-right-info">\r\n               {{i18n(\'Common\', \'ResourceAllocationComponent.totalCapFormat\', resourceMeter.capacity)}}\r\n            </span>\r\n         </li>\r\n      </ul>\r\n      <div ng-if="actionItems" class="horizontal-flex-container summary-action-container">\r\n         <a ng-repeat="actionItem in actionItems" href=""\r\n            ng-attr-aria-label="{{actionItem.ariaLabel}}"\r\n            ng-click="actionItem.onClick()"\r\n            ng-class="{disabled: !actionItem.isEnabled}"\r\n            ng-disabled="!actionItem.isEnabled">\r\n            {{actionItem.label}}\r\n         </a>\r\n      </div>\r\n   </div>\r\n\r\n   <div class="summary-icons-block" ng-if="summaryData.resourceIcons">\r\n      <table>\r\n         <tbody>\r\n         <tr ng-repeat="resource in summaryData.resourceIcons">\r\n            <td><div ng-class="resource.icon"></div></td>\r\n            <td>\r\n               <div class="resource-label">{{i18n(\'Common\', resource.title)}}</div>\r\n               <div class="resource-value">{{resource.used}}</div>\r\n            </td>\r\n         </tr>\r\n         </tbody>\r\n      </table>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/tabs/MultiExtensionView.html','<div class="vx-multi-extension-view">\r\n   <div ng-repeat="node in _view.$children" vx-view="node">\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/tabs/SubTabbedView.html','<div class="fill-parent vertical-flex-container">\r\n\r\n   <div ng-show="_view.$children.length > 1">\r\n      <div vx-navi-tab-headers="_view" level="second"></div>\r\n   </div>\r\n\r\n   <div class="sub-tab-content">\r\n      <div vx-view class="content fill-parent"></div>\r\n   </div>\r\n</div>');
$templateCache.put('resources/ui/views/tabs/TabbedObjectView.html','<div class="tabbed-object-view">\r\n   <div ng-if="_view.$children.length > 1">\r\n      <div vx-navi-tab-headers="_view" level="first"></div>\r\n   </div>\r\n    <div vx-view new-paint-region="true" class="outer-tab-content" ng-class="{\'outer-tab-content-no-title\':addTitleBar}">\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/tabs/TabContent.html','<div vx-view class="fill-parent"></div>');
$templateCache.put('resources/ui/views/tabs/TocView.html','\r\n<div class="vui-tertiary-tabs multi-level">\r\n   <div class="vui-toc-tabs" tabindex="-1">\r\n      <div vx-navi-toc-headers="_view"\r\n            categories-id="_view.contentSpec.metadata.categoriesExtensionPointId">\r\n      </div>\r\n   </div>\r\n\r\n   <div vx-view class="vui-tab-content"></div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/tabs/vxNaviDetailsTabHeadersTemplate.html','<ul class="nav nav-tabs" role="tablist">\r\n  <li ng-repeat="entityIterator in _view.categories"\r\n      data-test-id="category-{{::entityIterator.id}}"\r\n      ng-class="{ active: entityIterator.id === $parent.$parent.selectedCategoryId }"\r\n      ng-click="$parent.$parent.selectCategory(entityIterator.id)"\r\n      role="tab" tabindex="0" aria-selected="{{entityIterator.id === $parent.$parent.selectedCategoryId}}">\r\n     <a ng-bind="::entityIterator.title"></a>\r\n  </li>\r\n</ul>');
$templateCache.put('resources/ui/views/tabs/vxNaviSubTabHeadersTemplate.html','<div class="btn-group nav-secondary" role="tablist">\r\n   <button class="btn btn-sm"\r\n         ng-repeat="ext in _view.getNonEmptyChildren()"\r\n         ng-click="_navigate(ext.$id, _route.objectId, { \'navigator\' : _route.navigator,\r\n               \'relatedItemParentId\': relatedItemParentId(ext.$parent)})"\r\n         ng-class="{active: _view.getSelectedChild().$id == ext.$id}"\r\n         ng-model="radioModel"\r\n         role="tab" aria-selected="{{_view.getSelectedChild().$id == ext.$id}}"\r\n         btn-radio="\'{ext[nameField]}\'">{{ext[nameField]}}</button>\r\n</div>');
$templateCache.put('resources/ui/views/tabs/vxNaviTabHeadersTemplate.html','<ul class="nav nav-tabs" role="tablist">\r\n  <li ng-repeat="ext in _view.$children track by $index" ng-class="{active: _view.getSelectedChild().$id == ext.$id, \'{{_generateTid(ext.$id)}}\': true}"\r\n      ng-click="_navigate(ext.$id, _route.objectId, { \'navigator\' : _route.navigator })"\r\n      role="tab" tabindex="0" aria-selected="{{_view.getSelectedChild().$id == ext.$id}}">\r\n     <a>{{::ext[nameField]}}</a>\r\n  </li>\r\n</ul>\r\n');
$templateCache.put('resources/ui/views/tabs/vxNaviTocHeadersTemplate.html','<!-- Iterate over each category-->\r\n<div vx-refreshable watch-objects="{{_route.objectId}}" refresh="refreshToc()"\r\n   refresh-event-types="dataRefreshInvocationEvent modelChanged"\r\n   class="toc-headers-view" tabindex="0"\r\n   ng-keydown="handleKeydown($event)"\r\n   ng-focus="handleFocus($event)"\r\n   ng-blur="handleBlur($event)"\r\n   role="tree">\r\n   <div class="toc-headers-category"\r\n         ng-repeat="category in categories track by category.categoryId"\r\n         tabindex="-1">\r\n      <div class="toc-tabs-title" ng-if="::category.title"\r\n            ng-click="toggleCollapseExpand($index)"\r\n            ng-attr-title="{{::category.title}}"\r\n            aria-expanded="{{expanded[$index]}}"\r\n            role="treeitem"\r\n            tabindex="-1">\r\n         <!-- Caret Icon for expanded/collapsed-->\r\n         <span class="{{expanded[$index] ? \'vui-icon-caret-black-down\' : \'vui-icon-caret-black-right\'}}">\r\n         </span>\r\n         {{::category.title}}\r\n      </div>\r\n\r\n      <ul ng-show="expanded[$index]" ng-class="::{\'no-category-title\' : !category.title}"\r\n         role="group"\r\n         aria-label="{{::category.title}}"\r\n         aria-expanded="{{expanded[$index]}}">\r\n         <!-- iterate over each extension for a category-->\r\n         <li ng-repeat="ext in category.exts track by ext.$id"\r\n               role="treeitem"\r\n               tabindex="-1"\r\n               aria-selected="{{_view.getSelectedChild().$id == ext.$id}}"\r\n               ng-class="{active: _view.getSelectedChild().$id == ext.$id, \'{{_generateTid(ext.$id)}}\': true}"\r\n               ng-click="_navigate(ext.$id, _route.objectId, { \'navigator\' : _route.navigator })" title="{{::ext.name}}">\r\n            <a>{{::ext.name}}</a>\r\n         </li>\r\n      </ul>\r\n   </div>\r\n</div>');
$templateCache.put('resources/ui/views/tabs/vxTabbedViewTemplate.html','<div class="flex-column fill-parent vx-tab-wrapper" ng-if="tabs.length > 0" level="details">\r\n   <ul class="nav nav-tabs" role="tablist">\r\n      <li ng-repeat="currentTab in tabs"\r\n          ng-class="{active: currentTab.name === selectedTab.name, \'{{_generateTid(ext.$id)}}\': true}"\r\n          ng-click="selectTab(currentTab)"\r\n          role="tab" tabindex="0" aria-selected="{{currentTab.name === selectedTab.name}}">\r\n         <a>{{::currentTab.name}}</a>\r\n      </li>\r\n   </ul>\r\n   <div class="flex-grow-auto relative-container">\r\n      <div class="absolute-container fill-parent" id="vxTabContent"></div>\r\n   </div>\r\n</div>\r\n');
$templateCache.put('resources/ui/views/tasks/RecentTasksView.html','<div vx-stretch-grid class="vui-datagrid fill-parent"></div>\r\n\r\n<select ng-model=\'$ctrl.selectedTaskStatus\' ng-change=\'$ctrl.refreshTaskGrid()\' class="task-status-select">\r\n    <option ng-repeat=\'taskStatus in $ctrl.taskStatuses\'\r\n            ng-selected="taskStatus.id === $ctrl.selectedTaskStatus"\r\n            value=\'{{taskStatus.id}}\'>{{taskStatus.title}}\r\n    </option>\r\n</select>\r\n\r\n<a class="more-tasks" ng-click="$ctrl.navigateToTasks()" href="">{{$ctrl.moreTasksLabel}}</a>\r\n');
$templateCache.put('resources/ui/views/tasks/scheduledTasksView.html','<div ng-controller="scheduledTasksViewController as ctrl"\r\n     class="fill-parent split-view">\r\n    <div vui-splitter="ctrl.splitterOptions"\r\n         vx-vui-splitter-resize-notifier="ctrl.dataGridOptions"\r\n         class="fill-parent">\r\n        <div class="vui-panel">\r\n        <vx-activity-indicator is-visible="ctrl.pendingRequest" title="{{i18n(\'Common\', \'loadingTitle\')}}"></vx-activity-indicator>\r\n          <div class="fill-parent">\r\n             <div ng-if="ctrl.dataGridOptions" vui-datagrid="ctrl.dataGridOptions"\r\n                  class="fill-parent">\r\n             </div>\r\n          </div>\r\n    </div>\r\n        <div class="vui-panel details">\r\n        <div ng-show="!ctrl.selectedScheduledTask" class="fill-parent centered-content-container">\r\n            <span class="no-items-selected">\r\n               {{::i18n(\'Common\', \'ListPreviewSplitView.noItemsSelected\')}}\r\n            </span>\r\n        </div>\r\n        <div ng-if="ctrl.selectedScheduledTask" class="content">\r\n            <!-- Description -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{tasksView.selectedTask.description}}\r\n               </span>\r\n            </div>\r\n\r\n            <!-- Status -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'ScheduledOpsUi\', \'labelTask\')}}\r\n               </span>\r\n                <span>{{ctrl.scheduledTaskInfo.name}}</span>\r\n            </div>\r\n\r\n            <!-- Initiator -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'ScheduledOpsUi\', \'labelSchedule\')}}\r\n               </span>\r\n                <span>{{ctrl.getScheduleForDisplay(ctrl.scheduledTaskInfo.recurrence)}}</span>\r\n            </div>\r\n\r\n            <!-- Initiator -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'ScheduledOpsUi\', \'labelNextRun\')}}\r\n               </span>\r\n                <span>{{ctrl.scheduledTaskInfo.nextRunTime}}</span>\r\n            </div>\r\n\r\n\r\n            <!-- Target -->\r\n            <div class="property-value vertical-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'ScheduledOpsUi\', \'labelHistory\')}}\r\n               </span>\r\n                <div ng-if="ctrl.lastRunDatagridOptions" vui-datagrid="ctrl.lastRunDatagridOptions"\r\n                     class="fill-parent">\r\n                </div>\r\n            </div>\r\n\r\n            <!-- Result -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'ScheduledOpsUi\', \'labelLastModified\')}}\r\n               </span>\r\n                <span>{{ctrl.scheduledTaskInfo.lastModifiedTime}}</span>\r\n            </div>\r\n\r\n            <!-- Server -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'ScheduledOpsUi\', \'labelModifiedBy\')}}\r\n               </span>\r\n                <span>{{ctrl.scheduledTaskInfo.lastModifiedUser}}</span>\r\n            </div>\r\n\r\n            <!-- Server -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'ScheduledOpsUi\', \'labelNotes\')}}\r\n               </span>\r\n                <span>{{ctrl.scheduledTaskInfo.description}}</span>\r\n            </div>\r\n\r\n        </div>\r\n    </div>\r\n    </div>\r\n</div>\r\n\r\n');
$templateCache.put('resources/ui/views/tasks/TaskConsoleView.html','<div ng-controller="TaskConsoleViewController as tasksView"\r\n     class="fill-parent split-view">\r\n   <div vui-splitter="tasksView.splitterOptions"\r\n        vx-vui-splitter-resize-notifier="tasksView.tasksListOptions"\r\n        class="fill-parent">\r\n      <div class="vui-panel">\r\n         <vx-activity-indicator is-visible="tasksView.pendingRequest" size="large"\r\n            loading-aria-label="{{::i18n(\'Common\', \'tasksList.loadingAriaLabel\')}}"\r\n         ></vx-activity-indicator>\r\n         <div class="fill-parent">\r\n            <div ng-if="tasksView.tasksListOptions" vui-datagrid="tasksView.tasksListOptions"\r\n                  class="fill-parent tasksGrid">\r\n            </div>\r\n         </div>\r\n      </div>\r\n      <div class="vui-panel details">\r\n         <div ng-show="!tasksView.selectedTask" class="fill-parent centered-content-container">\r\n            <span class="no-items-selected">\r\n               {{::i18n(\'Common\', \'ListPreviewSplitView.noItemsSelected\')}}\r\n            </span>\r\n         </div>\r\n         <div ng-if="tasksView.selectedTask" class="content">\r\n\r\n            <!-- Description -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{tasksView.selectedTask.description}}\r\n               </span>\r\n            </div>\r\n\r\n            <!-- Status -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'Common\', \'taskDetailsStatus\')}}\r\n               </span>\r\n               <span vx-template="{{tasksView.selectedTask.statusTemplate}}"></span>\r\n            </div>\r\n\r\n            <!-- Initiator -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'Common\', \'taskDetailsInitiator\')}}\r\n               </span>\r\n               <span>{{tasksView.selectedTask.initiator}}</span>\r\n            </div>\r\n\r\n            <!-- Target -->\r\n            <div class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'Common\', \'taskEntityHeader\')}}\r\n               </span>\r\n               <span vx-template="{{tasksView.selectedTask.targetTemplate}}"></span>\r\n            </div>\r\n\r\n            <!-- Result -->\r\n            <div ng-if="(tasksView.selectedTask.resultEntityUid !== null &&\r\n                        tasksView.selectedTask.resultName !== null) ||\r\n                        tasksView.selectedTask.result !== null"\r\n                 class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'Common\', \'taskResultEntity\')}}\r\n               </span>\r\n               <span vx-template="{{tasksView.selectedTask.resultTemplate}}"></span>\r\n            </div>\r\n\r\n            <!-- Server -->\r\n            <div ng-if="tasksView.selectedTask.service !== null"\r\n                 class="property-value horizontal-flex-container">\r\n               <span class="property">\r\n                  {{::i18n(\'Common\', \'taskDetailsServer\')}}\r\n               </span>\r\n               <span>{{tasksView.selectedTask.service}}</span>\r\n            </div>\r\n\r\n            <div ng-if="tasksView.selectedTask.errorStack"\r\n                  vx-error-stack="tasksView.selectedTask.errorStack"\r\n                  error-report-args="tasksView.selectedTask.errorReportArgs">\r\n            </div>\r\n\r\n            <div ng-show="!tasksView.hasRelatedEvents" class="property-value">\r\n               <span>{{::i18n(\'EventUi\', \'noRelatedEventsFound.text\')}}</span>\r\n            </div>\r\n\r\n            <div ng-show="tasksView.hasRelatedEvents"\r\n                 class="property-value">\r\n               <span class="property">\r\n                  {{::i18n(\'EventUi\', \'relatedEventsTitleLabel.text\')}}\r\n               </span>\r\n            </div>\r\n\r\n            <div ng-if="tasksView.hasRelatedEvents">\r\n               <div>\r\n                  <div vui-datagrid="tasksView.relatedEventsListOptions"\r\n                       class="related-events">\r\n                  </div>\r\n               </div>\r\n            </div>\r\n         </div>\r\n      </div>\r\n   </div>\r\n</div>');
$templateCache.put('resources/ui/views/vfeed/vFeedDialog.html','<div ng-controller="VfeedDialogController" class="vfeed-content">\r\n   <form name="feedbackForm" class="feedback-form">\r\n      <div class="form-group form-group-horizontal">\r\n         {{i18n(\'Common\', \'feedback.header\')}}\r\n         <a vui-sign-post=\'signPostParams\'>{{i18n(\'Common\', \'feedback.moreInfo\')}}</a>\r\n      </div>\r\n      <div class="form-group form-group-horizontal">\r\n         {{i18n(\'Common\', \'feedback.experience\')}}\r\n         <div class="smiley-container">\r\n            <img class="smiley" src="./resources/img/smiley-happy.png"\r\n                 ng-click="selectSmiley(0)" ng-style="smileyStyles[0]"/>\r\n            <img class="smiley" src="./resources/img/smiley-neutral.png"\r\n                 ng-click="selectSmiley(1)" ng-style="smileyStyles[1]"/>\r\n            <img class="smiley" src="./resources/img/smiley-sad.png"\r\n                 ng-click="selectSmiley(2)" ng-style="smileyStyles[2]"/>\r\n         </div>\r\n      </div>\r\n      <div class="form-group form-group-horizontal">\r\n         {{i18n(\'Common\', \'feedback.tellusMore\')}}\r\n      </div>\r\n      <div class="form-group form-group-horizontal">\r\n         <textarea rows="4" cols="80" ng-model="message" ng-keydown="handleKeypress($event)"></textarea>\r\n      </div>\r\n      <div class="form-group form-group-horizontal">\r\n         <input type="email" ng-model="email" placeholder="{{emailPlaceholder}}">\r\n         <span style="color:red" ng-show="feedbackForm.$error.email">{{i18n(\'Common\', \'feedback.invalidEmail\')}}</span>\r\n      </div>\r\n      <div class="form-group form-group-horizontal" style="display: inline-block">\r\n         <div class="add-screenshot input-col col-xs-12" style="width:100%">\r\n            <button ng-click="addScreenshot()" style="vertical-align:top">{{i18n(\'Common\', \'feedback.takeScreenshot\')}}</button>\r\n         </div>\r\n         <div class="remove-screenshot input-col col-xs-12" style="padding:1px">\r\n            <button ng-click="removeScreenshot()" style="vertical-align: top">{{i18n(\'Common\', \'feedback.removeScreenshot\')}}</button>\r\n            <span style="margin-top:0">\r\n               {{i18n(\'Common\', \'feedback.clickAndDrag\')}}\r\n               <a ng-click="useMarkerPen()" class="content-padding">[{{i18n(\'Common\', \'feedback.redMarker\')}}]</a>\r\n               <a ng-click="useEraserPen()" class="content-padding">[{{i18n(\'Common\', \'feedback.grayEraser\')}}]</a>\r\n               <a ng-click="undo()" class="content-padding">[{{i18n(\'Common\', \'feedback.undo\')}}]</a>\r\n               <a ng-click="clearAllLines()" class="content-padding">[{{i18n(\'Common\', \'feedback.clearAll\')}}]</a>\r\n               <br/> <p ng-if="!showiFrameWarning">{{i18n(\'Common\', \'feedback.screenshotQuality\')}}</p>\r\n                     <p ng-if="showiFrameWarning" style="color:orangered">{{i18n(\'Common\', \'feedback.screenshotWarning\')}}</p>\r\n            </span>\r\n         </div>\r\n      </div>\r\n      <div class="canvas-div form-group form-group-horizontal canvas" width="100%" height="100%">\r\n      </div>\r\n   </form>\r\n</div>');
$templateCache.put('resources/ui/views/vfeed/vFeedError.html','<div ng-controller="VfeedDialogController" class="vfeed-content">\r\n   <form name="feedbackForm" style="padding:0px">\r\n      <div class="form-group form-group-horizontal">\r\n         {{i18n(\'Common\', \'feedback.errorHeader\')}}\r\n         <br/><a vui-sign-post=\'signPostParams\'>{{i18n(\'Common\', \'feedback.moreInfo\')}}</a>\r\n      </div>\r\n\r\n      <div class="form-group form-group-horizontal">\r\n         <textarea rows="7" cols="80" ng-model="message" ng-keydown="handleKeypress($event)"></textarea>\r\n      </div>\r\n      <div class="form-group form-group-horizontal">\r\n         <input type="email" ng-model="email" placeholder="{{emailPlaceholder}}">\r\n         <span style="color:red" ng-show="feedbackForm.$error.email">{{i18n(\'Common\', \'feedback.invalidEmail\')}}</span>\r\n      </div>\r\n      <div class="form-group form-group-horizontal"  style="display: inline-block">\r\n         <div class="add-screenshot input-col col-xs-12" style="width:100%">\r\n            <button ng-click="addScreenshot()" style="vertical-align:top">{{i18n(\'Common\', \'feedback.takeScreenshot\')}}</button>\r\n         </div>\r\n         <div class="remove-screenshot input-col col-xs-12" style="padding:1px">\r\n            <button ng-click="removeScreenshot()" style="vertical-align: top">{{i18n(\'Common\', \'feedback.removeScreenshot\')}}</button>\r\n            <span style="margin-top:0">\r\n               {{i18n(\'Common\', \'feedback.clickAndDrag\')}}\r\n               <a ng-click="useMarkerPen()" class="content-padding">[{{i18n(\'Common\', \'feedback.redMarker\')}}]</a>\r\n               <a ng-click="useEraserPen()" class="content-padding">[{{i18n(\'Common\', \'feedback.grayEraser\')}}]</a>\r\n               <a ng-click="undo()" class="content-padding">[{{i18n(\'Common\', \'feedback.undo\')}}]</a>\r\n               <a ng-click="clearAllLines()" class="content-padding">[{{i18n(\'Common\', \'feedback.clearAll\')}}]</a>\r\n               <br/>{{i18n(\'Common\', \'feedback.screenshotQuality\')}}\r\n            </span>\r\n         </div>\r\n      </div>\r\n      <div class="canvas-div form-group form-group-horizontal canvas" width="100%" height="100%">\r\n      </div>\r\n   </form>\r\n</div>');
$templateCache.put('resources/ui/views/listview/export/export-list.component.html','<div class="content">\r\n   <div ng-if="$ctrl.generatingFile" class="spinner-body">\r\n      <span class="spinner spinner-md"></span>\r\n      <span class="spinner-text">\r\n         {{ ::$ctrl.i18n(\'Common\', \'ExportDialog.exportingMessage\') }}\r\n      </span>\r\n   </div>\r\n\r\n   <div data-test-id="body" ng-class="{\'div-disabled\': $ctrl.generatingFile}">\r\n      <div>\r\n         <label>\r\n         <span>\r\n            {{ ::$ctrl.i18n(\'Common\', \'ExportDialog.tip\') }}\r\n         </span>\r\n         </label>\r\n      </div>\r\n\r\n      <label class="section">\r\n      <span>\r\n         {{ ::$ctrl.i18n(\'Common\', \'ExportDialog.rows\') }}\r\n      </span>\r\n      </label>\r\n      <div class="radio">\r\n         <input type="radio" id="rb-all"\r\n                ng-model="$ctrl.selectedExportType"\r\n                ng-value="$ctrl.exportType.ALL"/>\r\n         <label for="rb-all">\r\n            <span>\r\n               {{::$ctrl.i18n(\'Common\', \'ExportDialog.allRows\')}}\r\n            </span>\r\n         </label>\r\n      </div>\r\n\r\n      <div class="radio" ng-class="{\'div-disabled\': !$ctrl.selectedRowsOnlyEnabled}">\r\n         <input type="radio" id="rb-selected-only"\r\n                ng-model="$ctrl.selectedExportType"\r\n                ng-value="$ctrl.exportType.SELECTED_ONLY"/>\r\n         <label for="rb-selected-only">\r\n            <span>\r\n               {{::$ctrl.i18n(\'Common\', \'ExportDialog.selectedRows\')}}\r\n            </span>\r\n         </label>\r\n      </div>\r\n\r\n      <label class="section">\r\n      <span>\r\n         {{::$ctrl.i18n(\'Common\', \'ExportDialog.columns\')}}\r\n      </span>\r\n      </label>\r\n      <div class="checkbox">\r\n         <input type="checkbox"\r\n                id="selectAll"\r\n                ng-model="$ctrl.selectAll"\r\n                ng-change="$ctrl.onSelectAllChange()"/>\r\n         <label for="selectAll">\r\n            {{::$ctrl.i18n("Common", "ExportDialog.selectAll")}}\r\n         </label>\r\n      </div>\r\n      <div class="checkbox" ng-repeat="column in $ctrl.columns">\r\n         <input type="checkbox"\r\n                id="{{column.uid}}"\r\n                ng-model="$ctrl.columnsById[column.uid].selected"\r\n                ng-change="$ctrl.onSelectionChange()"/>\r\n         <label for="{{column.uid}}">\r\n            {{ column.title }}\r\n         </label>\r\n      </div>\r\n   </div>\r\n</div>');
$templateCache.put('resources/ui/views/listview/export/export-list.view.html','<export-list\r\n   selected-export-type="modalOptions.dialogData.exportType"\r\n   selected-items-count="modalOptions.dialogData.selectedItemsCount"\r\n   columns-by-id="modalOptions.dialogData.columnsById"\r\n   generating-file="modalOptions.dialogData.generatingFile"\r\n   is-selection-invalid="modalOptions.submitDisabled">\r\n</export-list>');
$templateCache.put('resources/ui/views/objectnavigator/error/ObjectNotFound.html','<div class="centered-text-block object-not-found">\r\n    {{i18n(\'CommonUi\', \'objectNotFound.descr\')}}\r\n</div>');}]);