/* Copyright (c) 2018 VMware, Inc. All rights reserved. -- VMware Confidential */

module platform {

   /**
    * This service class provides common APIs used by the other SDK services,
    * components and other parties.
    */
   export class H5SdkCommonService {
      /**
       * Determines whether an IFrame element content is cross-domain.
       * The cross-domain state should be checked after each "load" event of
       * the IFrame element.
       */
      public isCrossDomainIFrame(iframe: HTMLIFrameElement): boolean {
         try {
            /*
            Safari does not have addEventListener function,
            all other browsers throw an exception when addEventListener
            method is accessed. So we just need to check whether
            addEventListener is present.
            */
            return !iframe.contentWindow.addEventListener;
         } catch (error) {
            return true;
         }
      }
   }

   angular
         .module("com.vmware.platform.ui")
         .service("h5SdkCommonService", H5SdkCommonService);
}