/* Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential */

module sandbox {

   const GLOBAL_REFRESH_EVENT = 'dataRefreshInvocationEvent';

   /**
    * This service implements the business logic of plugin messaging API such as:
    * - handling requests from the plugins
    * - listening for platform events and eventually notifying the plugins
    *
    * The service may be initialized only once.
    *
    * Internally it uses {@link SandboxMessagingService} to do the actual communication
    * with the plugins.
    */
   export class SandboxBridgeService {

      static $inject = [
         '$rootScope',
         'sandboxMessagingService'
      ];


      private initialized: boolean = false;

      constructor(private $rootScope: ng.IRootScopeService,
                  private sandboxMessagingService: SandboxMessagingService) {
      }

      public init(): void {
         if (this.initialized) {
            return;
         }
         this.initialized = true;
         this.$rootScope.$on(GLOBAL_REFRESH_EVENT,
            () => this.sendGlobalRefreshMessage());
         this.sandboxMessagingService.subscribeForMessages(
            (message, source) => this.onMessage(message, source));
      }

      private sendGlobalRefreshMessage(): void {
         let message: SandboxMessage = {message : "globalRefresh"};
         this.sandboxMessagingService.broadcastMessage(message);
      }

      private onMessage(pluginMessage: SandboxMessage, source: Window): void {

      }

   }

   angular
      .module('com.vmware.platform.ui')
      .service('sandboxBridgeService', SandboxBridgeService);

}
