/* Copyright (c) 2018 VMware, Inc. All rights reserved. */

module platform {
   import IController = angular.IController;
   import ILocationService = angular.ILocationService;

   declare var _: any;

   class RemotePluginExtensionContextSelectorController implements IController {

      public static $inject = [
         '$scope',
         '$rootScope',
         '$location'
      ];

      public selectedRpxcId: string | null = null;
      public showDropdown: boolean = false;
      public dropdownItems: any[] = [];

      public childRpxcIdToNavigationNode: { [id: string]: any } = {};

      public get selectedChildContextNavigationNode(): any | null {
         if (this.selectedRpxcId === null || !this.childRpxcIdToNavigationNode.hasOwnProperty(this.selectedRpxcId)) {
            return null;
         }

         return this.childRpxcIdToNavigationNode[this.selectedRpxcId];
      }

      constructor(private $scope: any,
            private $rootScope: any,
            private $location: ILocationService) {

         $scope.$on("viewDidLoad", () => {
            this.update();
         });

         $scope.$on("viewDidUpdate", () => {
            this.update();
         });

         this.update(true);
      }

      public onRefresh(): void {
         let route: any = _.extend(
               {},
               this.$location.search(),
               {
                  sdkUpdateRpxcSelector: Math.random()
               }
         );
         this.$location.search(route);
      }

      private update(isFirstUpdate?: boolean): void {
         let remotePluginExtensionContext: RemotePluginMultiInstanceExtensionContext =
               this.$scope._view.remotePluginExtensionContext;

         this.childRpxcIdToNavigationNode = _.object(_.map(
               remotePluginExtensionContext.descriptors,
               (descriptor: RemotePluginSingleInstanceExtensionDescriptor) => {
                  let node: any = {};

                  node.extensionObject = {
                     uid: descriptor.extensionId,
                     remotePluginExtensionContext: descriptor.extensionContext,
                     contentSpec: {
                        sandbox: true,
                        url: descriptor.url
                     }
                  };

                  node.$id = node.extensionObject.uid;
                  node.$templateUrl = node.extensionObject.contentSpec.url;
                  node.contentSpec = node.extensionObject.contentSpec;
                  node.remotePluginExtensionContext = node.extensionObject.remotePluginExtensionContext;

                  return [descriptor.extensionContext.contextId, node];
               }
         ));

         this.showDropdown = (remotePluginExtensionContext.descriptors.length > 0);

         this.dropdownItems = _.map(
               remotePluginExtensionContext.descriptors,
               (descriptor: RemotePluginSingleInstanceExtensionDescriptor) => {
                  return {
                     id: descriptor.extensionContext.contextId,
                     instanceLabel: descriptor.instanceLabel,
                     instanceUrl: descriptor.instanceUrl,
                     versionLabel: descriptor.versionLabel,
                     vCenterNames: descriptor.vCenterNames.concat()
                  };
               }
         );

         let preSelectedRpxcId: string | null = null;
         if (isFirstUpdate) {
            let route: any = this.$location.search();
            if (route && typeof route.rpxcId === "string") {
               preSelectedRpxcId = route.rpxcId;
            }
         } else {
            preSelectedRpxcId = this.selectedRpxcId;
         }

         if (typeof preSelectedRpxcId === "string" &&
               this.childRpxcIdToNavigationNode.hasOwnProperty(preSelectedRpxcId)) {
            this.selectedRpxcId = preSelectedRpxcId;
         } else {
            if (remotePluginExtensionContext.descriptors.length > 0) {
               this.selectedRpxcId =
                     remotePluginExtensionContext.descriptors[0].extensionContext.contextId;
            } else {
               this.selectedRpxcId = null;
            }
         }
      }
   }

   angular.module("com.vmware.platform.ui").controller(
         "RemotePluginExtensionContextSelectorController",
         RemotePluginExtensionContextSelectorController
   );
}
