/* Copyright (c) 2018 VMware, Inc. All rights reserved. */

module platform {
    import IController = angular.IController;

    class SandboxTemplateController implements IController {

        public static $inject = ['$scope', 'pluginUrlService'];

        private url: string;
        private urlParams: any;
        private viewId: string;
        private remotePluginExtensionContext: RemotePluginSingleInstanceExtensionContext | undefined;

        constructor(private $scope, private pluginUrlService) {

            // Add objectId param for HTML bridge plugin views
            let objectId = $scope._route ? $scope._route.objectId : null;
            this.url = $scope._view.$templateUrl;
            this.urlParams = {objectId: objectId};
            this.viewId = $scope._view.$id;
            this.remotePluginExtensionContext = $scope._view.remotePluginExtensionContext;

            // Listen for user selection in the dropdown declared in CenterPanel.
            // vcService comes from the prototypical inheritance of the scopes.
            if ($scope._view.contentSpec.showVCenterSelector) {
                $scope.$watch('vcService', (newValue, oldValue) => {
                    if (oldValue === newValue) {
                        return;
                    }

                    this.urlParams.vcSelectorSelection = $scope.vcService;
                });
            }
        }
    }

    angular.module("com.vmware.platform.ui")
        .controller("sandboxTemplateController", SandboxTemplateController);
}
