/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.devkit;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.project.config.devkit.AbstractCommandRunner;
import com.vmware.vide.project.config.vib.UserInput;
import com.vmware.vide.project.config.vib.VIBData;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.vib.VIBFileManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class VIBBuildCommandRunner
extends AbstractCommandRunner {
    public static final String COMMAND_ID = "vibbuild";
    public static final String PROPERTY_PATH = "path";
    public static final String PROPERTY_TEMPLATE = "template-";
    public static final String PROPERTY_DEBUG = "debug";
    public static final String PROPERTY_RELEASE = "release";
    private static final String MSG_TAG = "VIB Package Build";
    private static final String ERROR_INVALID_PATH = "Unable to access directory to create XML files for VIB package";
    private static final String ERROR_GEN_VIBFILE = "Fail to generate VIB related XML files";
    private static final String ERROR_NO_METADATAFILE = "Unable to access VIB related XML files";

    public VIBBuildCommandRunner() {
        super(COMMAND_ID);
    }

    @Override
    public IStatus execute(Shell shell, IProject project, String command, int sequence, Map<String, String> commandproperties, Map<String, String> envs, IProgressMonitor monitor) throws Exception {
        IFile metadata;
        Path vibpath = this.getVIBPath(project, commandproperties);
        if (vibpath == null || !vibpath.toFile().exists() || !vibpath.toFile().isDirectory()) {
            Utils.openDialog(MSG_TAG, ERROR_INVALID_PATH, 1, null);
            return Status.CANCEL_STATUS;
        }
        VIBFileManager vibmanager = new VIBFileManager();
        if (!vibmanager.allVIBFilesExists(project, (IPath)vibpath)) {
            String devkitid = ProjectManager.getDevkitId(project);
            ArrayList<VIBData> data = ProjectPlugin.getConfig().getVIBData(devkitid);
            if (data != null && !data.isEmpty() && data.get(0).canCreateVIBFileFromUserInputs()) {
                VIBData vibdata = data.get(0).clone();
                LinkedHashMap<String, UserInput> inputs = vibdata.getUserInputs();
                Map<String, String> properties = ProjectManager.getAllProjectProperties(project);
                if (inputs != null) {
                    for (UserInput ui : inputs.values()) {
                        ui.getDefaultValue(properties, true);
                    }
                }
                vibdata.createVIBFiles(project);
            } else if (!vibmanager.generateVIBFiles(project, vibpath, this.getTemplateProperties(project, commandproperties))) {
                Utils.openDialog(MSG_TAG, ERROR_GEN_VIBFILE, 1, null);
                return Status.CANCEL_STATUS;
            }
        }
        if ((metadata = vibmanager.getPrimaryVIBFile(project, (IPath)vibpath)) == null) {
            Utils.openDialog(MSG_TAG, ERROR_NO_METADATAFILE, 1, null);
            return Status.CANCEL_STATUS;
        }
        ProjectManager.putProjectProperty(project, "VIBBUILD_COMMAND", command, false);
        if (commandproperties.containsKey(PROPERTY_DEBUG)) {
            ProjectManager.putProjectProperty(project, "VIBBUILD_DEBUG_COMMAND", commandproperties.get(PROPERTY_DEBUG), false);
        }
        if (commandproperties.containsKey(PROPERTY_RELEASE)) {
            ProjectManager.putProjectProperty(project, "VIBBUILD_RELEASE_COMMAND", commandproperties.get(PROPERTY_RELEASE), false);
        }
        if (commandproperties.containsKey("ExecutePath")) {
            ProjectManager.putProjectProperty(project, "VIBBUILD_DIRECTORY", commandproperties.get("ExecutePath"), false);
        }
        VIBBuildCommandRunner.openFileInEditor(shell, metadata, project, (IProgressMonitor)new NullProgressMonitor());
        return Status.OK_STATUS;
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    private Path getVIBPath(IProject project, Map<String, String> properties) {
        String vibpathstr = this.getPropertyValue(PROPERTY_PATH, project, properties);
        return vibpathstr != null && !vibpathstr.isEmpty() ? new Path(vibpathstr) : null;
    }

    private Map<String, String> getTemplateProperties(IProject project, Map<String, String> properties) {
        HashMap<String, String> templateproperties = new HashMap<String, String>();
        for (String property : properties.keySet()) {
            String key;
            if (!property.startsWith(PROPERTY_TEMPLATE) || (key = property.substring(PROPERTY_TEMPLATE.length())) == null || key.isEmpty()) continue;
            templateproperties.put(key, properties.get(property));
        }
        return templateproperties;
    }

    private String getPropertyValue(String key, IProject project, Map<String, String> properties) {
        if (!properties.containsKey(key)) {
            return null;
        }
        String value = properties.get(key);
        if (value.contains("{{")) {
            value = Utils.replaceContent(value, VIBBuildCommandRunner.getProjectProperties(project));
        }
        return value;
    }

    private static void openFileInEditor(Shell shell, final IFile file, IProject project, IProgressMonitor monitor) {
        monitor.worked(1);
        monitor.setTaskName("Opening VIB files...");
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        monitor.done();
    }

    private static Map<String, String> getProjectProperties(IProject project) {
        Map<String, String> properties = ProjectManager.getAllProjectProperties(project);
        properties.put("PROJECT_LOC", project.getLocation().toOSString());
        return properties;
    }
}

