/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.vib;

import com.vmware.vide.init.ConfigUtil;
import com.vmware.vide.init.InitPlugin;
import com.vmware.vide.project.config.devkit.MenuResource;
import com.vmware.vide.project.config.resource.AbstractProjectResource;
import com.vmware.vide.project.config.vib.UserInput;
import com.vmware.vide.project.config.vib.VIBFilesInfo;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import com.vmware.vide.project.wizard.vibwizard.GenerateVIBFileWizard;
import com.vmware.vide.utils.xml.XMLUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VIBData
extends AbstractProjectResource
implements Cloneable {
    private static final String TAG_VIBFILE = "vibfile";
    private static final String TAG_FILENAME = "filename";
    private static final String TAG_VIBBASEFILE = "vibbasefile";
    private static final String TAG_DEVKITBASEFILE = "devkitbasefile";
    private static final String TAG_DESTPATH = "destpath";
    private static final String TAG_SORTRULE = "sortrule";
    public static final String QUALIFIER = "com.vmware.vide.project.VIBDATA";
    private boolean isvalid;
    private LinkedHashMap<String, UserInput> orderedUserInputs;
    private HashMap<String, VIBFile> vibfiles = new HashMap();
    private List<VIBFilesInfo> vibfilesinfos = new ArrayList<VIBFilesInfo>();
    private String sortrule;

    public VIBData(Object config) {
        this.refreshConfig(config);
    }

    public VIBData clone() {
        VIBData data = null;
        try {
            data = (VIBData)super.clone();
            if (this.orderedUserInputs != null) {
                LinkedHashMap<String, UserInput> inputs = new LinkedHashMap<String, UserInput>();
                for (Map.Entry<String, UserInput> ent : this.orderedUserInputs.entrySet()) {
                    inputs.put(ent.getKey(), ent.getValue().clone());
                }
                data.orderedUserInputs = inputs;
            }
        }
        catch (CloneNotSupportedException e) {
            System.err.println("Failed to clone the VIBData.");
            e.printStackTrace();
        }
        return data;
    }

    public boolean isValid() {
        return this.isvalid;
    }

    @Override
    public String getResourceId() {
        return "vib";
    }

    @Override
    public MenuResource.STATUS createDefault(IProject project, int when, boolean ask) throws VIDEProjectException {
        MessageBox messageBox;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (when == 0) {
            if (this.hasAllVIBFiles(project)) {
                return MenuResource.STATUS.OK;
            }
            if (ask) {
                messageBox = new MessageBox(shell, 196);
                messageBox.setMessage("The required VIB file(s) do not exist, do you want to create them?");
                messageBox.setText("VIB Information");
                if (messageBox.open() != 64) {
                    return MenuResource.STATUS.USERCANCEL;
                }
            }
        } else if (this.hasAllVIBFiles(project) && ask) {
            messageBox = new MessageBox(shell, 196);
            messageBox.setMessage("The required VIB file(s) exist, do you want to overwirte them?");
            messageBox.setText("VIB Information");
            if (messageBox.open() != 64) {
                return MenuResource.STATUS.OK;
            }
        }
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        GenerateVIBFileWizard wizard = new GenerateVIBFileWizard(this, project);
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.create();
        int ret = dialog.open();
        return ret == 0 ? MenuResource.STATUS.OK : (ret == 1 ? MenuResource.STATUS.USERCANCEL : MenuResource.STATUS.ERROR);
    }

    @Override
    public boolean isAvailable(IProject project) {
        if (!this.isValid()) {
            return false;
        }
        return this.hasAllVIBFiles(project);
    }

    public boolean hasAllVIBFiles(IProject project) {
        boolean found = true;
        for (VIBFile file : this.vibfiles.values()) {
            if (file.hasVIBFile(project)) continue;
            found = false;
            break;
        }
        return found;
    }

    private void refreshConfig(Object config) {
        this.isvalid = false;
        if (config == null) {
            return;
        }
        this.vibfiles.clear();
        this.vibfilesinfos.clear();
        ArrayList vfiles = ConfigUtil.lookupList((Object)config, (String)TAG_VIBFILE);
        if (vfiles != null) {
            int i = 0;
            while (i < vfiles.size()) {
                String name = ConfigUtil.lookupString(vfiles.get(i), (String)TAG_FILENAME);
                String destpath = ConfigUtil.lookupString(vfiles.get(i), (String)TAG_DESTPATH);
                String vibbase = ConfigUtil.lookupString(vfiles.get(i), (String)TAG_VIBBASEFILE);
                String devkitbase = ConfigUtil.lookupString(vfiles.get(i), (String)TAG_DEVKITBASEFILE);
                if (!(name == null || name.isEmpty() || vibbase == null && devkitbase == null)) {
                    VIBFilesInfo info = new VIBFilesInfo(name, destpath, vibbase, devkitbase);
                    this.vibfiles.put(name, new VIBFile(info));
                    this.vibfilesinfos.add(info);
                }
                ++i;
            }
        }
        this.orderedUserInputs = UserInput.getOrderedUserInputs(config);
        this.sortrule = ConfigUtil.lookupString((Object)config, (String)TAG_SORTRULE);
        if (this.vibfiles.size() > 0) {
            this.isvalid = true;
        }
    }

    public List<VIBFilesInfo> getVIBFilesInfos() {
        return this.vibfilesinfos;
    }

    public void createVIBFiles(IProject project) throws VIDEProjectException {
        this.createVIBFiles(project, this.getPropertyValuesForProject(project));
    }

    public void createVIBFiles(IProject project, Map<String, String> properties) throws VIDEProjectException {
        if (project == null) {
            throw Utils.createFileAccessException("Insufficient project information ", null);
        }
        int maxSegments = 0;
        for (VIBFile file : this.vibfiles.values()) {
            if (file.createVIBFile(project, this.appendVIBUserInputs(properties)) == null) {
                throw Utils.createFileAccessException("Unable to create VIB related XML files ", null);
            }
            Path p = new Path(file.xmlfile.getAbsolutePath());
            IPath ip = p.makeRelativeTo(project.getLocation());
            if (ip.segmentCount() <= maxSegments) continue;
            maxSegments = ip.segmentCount();
        }
        try {
            project.refreshLocal(maxSegments, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw Utils.createProjectUpdateException("Failed to update project files", (Exception)((Object)e));
        }
    }

    public Map<String, String> appendVIBUserInputs(Map<String, String> properties) {
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        for (String name : this.orderedUserInputs.keySet()) {
            String value = this.orderedUserInputs.get(name).getValue();
            if (value == null || value.isEmpty()) continue;
            properties.put(name, value);
        }
        return properties;
    }

    public Map<String, String> getPropertyValuesForProject(IProject project) {
        Map systemprops;
        HashMap<String, String> properties = project == null ? new HashMap() : ProjectManager.getAllProjectProperties(project);
        String devkitid = ProjectManager.getDevkitId(project);
        if (devkitid != null && (systemprops = InitPlugin.getDefault().getSystemOptions(devkitid)) != null) {
            for (String name : systemprops.keySet()) {
                String value = (String)systemprops.get(name);
                if (value == null || value.isEmpty()) continue;
                properties.put(name, value);
            }
        }
        return properties;
    }

    public static File generateVIBXML(String filename, File[] xmls, Map<String, String> properties) throws VIDEProjectException {
        if (filename == null || filename.isEmpty() || xmls.length == 0) {
            return null;
        }
        File destfile = null;
        try {
            String filecontent;
            Document dom = VIBData.mergeXml(xmls, true, true);
            if (dom != null && (filecontent = VIBData.convertToString(dom)) != null && !filecontent.isEmpty()) {
                filecontent = Utils.replaceContent(filecontent, properties);
                destfile = new File(filename);
                BufferedWriter fwriter = new BufferedWriter(new FileWriter(destfile));
                fwriter.write(filecontent);
                ((Writer)fwriter).close();
            }
        }
        catch (Exception e) {
            throw Utils.createFileAccessException("Unable to create the file " + filename, e);
        }
        return destfile;
    }

    public static Document mergeXml(File[] xmls, boolean overwrite, boolean create) throws Exception {
        if (xmls == null || xmls.length == 0) {
            return null;
        }
        Document dom = VIBData.parseXml(xmls[0]);
        if (xmls.length > 1) {
            int i = 1;
            while (i < xmls.length) {
                Document updateddom = VIBData.parseXml(xmls[i]);
                if (updateddom != null) {
                    dom = VIBData.mergeDocument(dom, updateddom, overwrite, create);
                }
                ++i;
            }
        }
        return dom;
    }

    private static Document mergeDocument(Document basedom, Document updateddom, boolean overwrite, boolean create) {
        return VIBData.updateDocument(basedom, basedom, updateddom, overwrite, create);
    }

    private static boolean isValidNodeName(Node node) {
        String nodename = node.getNodeName();
        return nodename != null && !nodename.isEmpty() && node.getNodeType() != 3;
    }

    private static Hashtable<String, ArrayList<Node>> collectNodeListByName(NodeList nodes) {
        Hashtable<String, ArrayList<Node>> nodetable = new Hashtable<String, ArrayList<Node>>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (VIBData.isValidNodeName(node)) {
                String nodename = node.getNodeName();
                if (nodetable.containsKey(nodename)) {
                    nodetable.get(nodename).add(node);
                } else {
                    ArrayList<Node> multinodes = new ArrayList<Node>();
                    multinodes.add(node);
                    nodetable.put(nodename, multinodes);
                }
            }
            ++i;
        }
        return nodetable;
    }

    private static boolean isTextAttachedComments(NodeList nodes, int i) {
        if (i > 0 && nodes.item(i - 1).getNodeType() == 8) {
            return nodes.item(i).getNodeType() == 3;
        }
        return false;
    }

    private static Hashtable<String, ArrayList<Node>> collectNodeListWithCommentsByName(NodeList nodes) {
        Hashtable<String, ArrayList<Node>> nodetable = new Hashtable<String, ArrayList<Node>>();
        ArrayList<Node> comments = new ArrayList<Node>();
        String lastNodeName = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node.getNodeType() == 8 || VIBData.isTextAttachedComments(nodes, i)) {
                comments.add(node);
            } else if (VIBData.isValidNodeName(node)) {
                String nodename = node.getNodeName();
                if (nodetable.containsKey(nodename)) {
                    nodetable.get(nodename).addAll(comments);
                    comments.clear();
                    nodetable.get(nodename).add(node);
                    lastNodeName = nodename;
                } else {
                    ArrayList<Node> multinodes = new ArrayList<Node>();
                    multinodes.addAll(comments);
                    comments.clear();
                    multinodes.add(node);
                    nodetable.put(nodename, multinodes);
                    lastNodeName = nodename;
                }
            }
            ++i;
        }
        if (lastNodeName != null && !comments.isEmpty()) {
            nodetable.get(lastNodeName).addAll(comments);
        }
        return nodetable;
    }

    private static Document updateDocument(Document basedom, Node basedoc, Node doc, boolean overwrite, boolean create) {
        if (basedoc == null || doc == null) {
            return null;
        }
        Hashtable<String, ArrayList<Node>> basenodetable = VIBData.collectNodeListByName(basedoc.getChildNodes());
        Hashtable<String, ArrayList<Node>> nodetable = VIBData.collectNodeListWithCommentsByName(doc.getChildNodes());
        Enumeration<String> e = nodetable.keys();
        while (e.hasMoreElements()) {
            String nodename = e.nextElement();
            ArrayList<Node> nodes = nodetable.get(nodename);
            ArrayList<Object> basenodes = new ArrayList();
            if (basenodetable.containsKey(nodename)) {
                basenodes = basenodetable.get(nodename);
            }
            int num = 0;
            ArrayList<Node> comments = new ArrayList<Node>();
            int i = 0;
            while (i < nodes.size()) {
                Node node2;
                Node newnode;
                if (nodes.get(i).getNodeType() == 8 || nodes.get(i).getNodeType() == 3) {
                    newnode = nodes.get(i).cloneNode(true);
                    node2 = basedom.importNode(newnode, true);
                    comments.add(node2);
                } else if (basenodes.size() > num) {
                    VIBData.mergeNodeValue(basedom, nodename, (Node)basenodes.get(num), nodes.get(i), overwrite, create);
                    basedom = VIBData.updateDocument(basedom, (Node)basenodes.get(num), nodes.get(i), overwrite, create);
                    VIBData.insertComments(basedoc, comments, (Node)basenodes.get(num));
                    ++num;
                } else if (create) {
                    newnode = nodes.get(i).cloneNode(true);
                    node2 = basedom.importNode(newnode, true);
                    basedoc.appendChild(node2);
                    VIBData.insertComments(basedoc, comments, node2);
                }
                ++i;
            }
            VIBData.appendComments(basedoc, comments);
        }
        return basedom;
    }

    private static void insertComments(Node node, List<Node> comments, Node refNode) {
        XMLUtil.insertNodes((Node)node, comments, (Node)refNode);
    }

    private static void appendComments(Node node, List<Node> comments) {
        XMLUtil.appendNodes((Node)node, comments);
    }

    public static Document parseXml(Object input) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        dbf.setIgnoringComments(true);
        if (input instanceof File) {
            return db.parse((File)input);
        }
        if (input instanceof String) {
            return db.parse((String)input);
        }
        if (input instanceof InputStream) {
            return db.parse((InputStream)input);
        }
        return null;
    }

    public static void mergeNodeValue(Document orgdom, String nodename, Node orgnode, Node newnode, boolean overwrite, boolean create) {
        NamedNodeMap attributes;
        if (orgnode == null || newnode == null || nodename == null || !orgnode.getNodeName().equals(nodename) || !newnode.getNodeName().equals(nodename)) {
            return;
        }
        String nodevalue = VIBData.getTextNodeValue(newnode);
        if (nodevalue != null && !nodevalue.isEmpty()) {
            if (orgnode.getFirstChild() == null && create) {
                orgnode.appendChild(orgdom.createTextNode(nodevalue));
            } else if (overwrite || VIBData.getTextNodeValue(orgnode) == null || VIBData.getTextNodeValue(orgnode).isEmpty()) {
                orgnode.getFirstChild().setNodeValue(nodevalue);
            }
        }
        if ((attributes = newnode.getAttributes()) != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                String name = attributes.item(i).getNodeName();
                String value = attributes.item(i).getNodeValue();
                Node attrnode = orgnode.getAttributes().getNamedItem(name);
                if (attrnode != null) {
                    String attrvalue = attrnode.getNodeValue();
                    if (overwrite || attrvalue == null || attrvalue.isEmpty()) {
                        attrnode.setNodeValue(value);
                    }
                } else if (create) {
                    attrnode = orgdom.createAttribute(name);
                    attrnode.setNodeValue(value);
                    orgnode.appendChild(attrnode);
                }
                ++i;
            }
        }
    }

    public static String convertToString(Document doc) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = null;
        StringWriter writer = new StringWriter();
        trans = tf.newTransformer();
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        trans.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.toString();
    }

    public static boolean isTextNode(Node node) {
        if (node.getFirstChild() == null) {
            return false;
        }
        return node.getFirstChild().getNodeType() == 3;
    }

    public static String getTextNodeValue(Node node) {
        if (!VIBData.isTextNode(node)) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    public static String getFirstTextNodeValueFromTag(Document dom, String tagname) {
        NodeList nl = dom.getElementsByTagName(tagname);
        if (nl != null && nl.getLength() > 0) {
            return VIBData.getTextNodeValue(nl.item(0));
        }
        return null;
    }

    public LinkedHashMap<String, UserInput> getUserInputs() {
        return this.orderedUserInputs;
    }

    public String getSortRule() {
        if (this.sortrule == null) {
            return "";
        }
        return this.sortrule;
    }

    public boolean canCreateVIBFileFromUserInputs() {
        return this.orderedUserInputs != null && !this.orderedUserInputs.isEmpty();
    }

    public void saveVIBData(IProject project) throws VIDEProjectException {
        LinkedHashMap<String, UserInput> userinputs = this.getUserInputs();
        for (UserInput userinput : userinputs.values()) {
            try {
                project.setPersistentProperty(userinput.getQualifiedName(QUALIFIER), userinput.getValue());
                if (!userinput.isCheckBoxNeeded()) continue;
                String value = userinput.isCheckBoxSelected() ? "true" : "false";
                project.setPersistentProperty(userinput.getQualifiedCheckboxName(QUALIFIER), value);
            }
            catch (CoreException e) {
                throw Utils.createFileAccessException("Insufficient project information ", (Exception)((Object)e));
            }
        }
    }

    private class VIBFile {
        private File xmlfile;
        private final VIBFilesInfo vibfilesinfo;

        public VIBFile(VIBFilesInfo vibfilesinfo) {
            this.vibfilesinfo = vibfilesinfo;
        }

        public boolean hasVIBFile(IProject project) {
            String name;
            try {
                name = this.getAbsoluteVIBFilename(project, false);
            }
            catch (VIDEProjectException vIDEProjectException) {
                return false;
            }
            if (name != null) {
                return new File(name).exists();
            }
            return false;
        }

        public File createVIBFile(IProject project, Map<String, String> properties) throws VIDEProjectException {
            if (project != null) {
                File[] bases = this.getBaseXMLs(properties);
                String name = this.getAbsoluteVIBFilename(project, true);
                if (name != null) {
                    this.xmlfile = VIBData.generateVIBXML(name, bases, properties);
                    return this.xmlfile;
                }
            }
            throw Utils.createFileAccessException("Insufficient project information ", null);
        }

        public File[] getBaseXMLs(Map<String, String> properties) {
            String[] filenames = new String[]{this.vibfilesinfo.getVibbase(), this.vibfilesinfo.getDevkitbase()};
            ArrayList<File> files = new ArrayList<File>();
            String[] stringArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename;
                File file;
                String name = stringArray[n2];
                if (name != null && (file = new File(filename = Utils.replaceContent(name, properties))).exists() && file.isFile()) {
                    files.add(file);
                }
                ++n2;
            }
            return files.toArray(new File[files.size()]);
        }

        private String getAbsoluteVIBFilename(IProject project, boolean createdir) throws VIDEProjectException {
            IPath path = null;
            if (this.vibfilesinfo.getDestpath() != null && !this.vibfilesinfo.getDestpath().isEmpty()) {
                String loc = this.vibfilesinfo.getDestpath();
                Map<String, String> properties = ProjectManager.getAllProjectProperties(project);
                if ((loc = Utils.replaceContent(loc, properties)).charAt(0) != '/') {
                    String procDir = project.getLocation().toOSString();
                    if (procDir.charAt(procDir.length() - 1) != '/') {
                        procDir = String.valueOf(procDir) + '/';
                    }
                    loc = String.valueOf(procDir) + loc;
                }
                path = new Path(loc);
            } else if (project != null) {
                path = project.getLocation();
            }
            if (path != null) {
                if (!path.toFile().exists() && createdir && !path.toFile().mkdirs()) {
                    throw Utils.createFileAccessException("Unable to create the file " + path.toOSString(), null);
                }
                return path.addTrailingSeparator().append(this.vibfilesinfo.getFilename()).toOSString();
            }
            return null;
        }
    }
}

