/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.config.wizard.project;

import com.vmware.vide.project.ProjectPlugin;
import com.vmware.vide.utils.symbol.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class ProjectOperation {
    static final ILog logger = ProjectPlugin.getDefault().getLog();
    static final String WORKBENCH_PROJECT_OPERATION_PREFIX = "WB:";
    String operation;
    IProject project;

    ProjectOperation(IProject project, String op) {
        if (ProjectOperation.isWorkbenchProjectOperation(op)) {
            op = op.substring(op.indexOf(58) + 1);
        }
        this.operation = op;
        this.project = project;
    }

    Map<String, String> run() {
        String[] opArgs = this.parse();
        if (opArgs[0].equals("link")) {
            this.opLink(opArgs);
        } else {
            if (opArgs[0].equals("property")) {
                return this.opProperty(opArgs);
            }
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", String.format("Unsupported operation [%s].", opArgs[0])));
        }
        return null;
    }

    String[] parse() {
        ArrayList args = StringUtil.convertCommandLineToCommandAndArgs((String)this.operation);
        return args.toArray(new String[args.size()]);
    }

    void opLink(String[] opArgs) {
        Object res;
        if (this.project == null) {
            logger.log((IStatus)new Status(2, "com.vmware.vide.project", "Ignore link operation because no project."));
            return;
        }
        if (opArgs.length != 3) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Link operation requires two parameters."));
            return;
        }
        String src = opArgs[1];
        String dst = opArgs[2];
        IPath locationPath = Path.fromOSString((String)src);
        File f = locationPath.toFile();
        if (!f.isAbsolute()) {
            f = new File(this.project.getLocation().toFile().getAbsoluteFile(), src);
        }
        if (!f.exists()) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", String.format("Specified file [%s] does not exist.", f)));
            return;
        }
        IPath dstPath = Path.fromOSString((String)dst);
        if (dstPath.isAbsolute()) {
            IPath projectPath = this.project.getLocation();
            if (dstPath.matchingFirstSegments(projectPath) != projectPath.segmentCount()) {
                String msg = String.format("Specified path [%s] is absolute.", dstPath);
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                return;
            }
            dstPath = dstPath.removeFirstSegments(projectPath.segmentCount());
        }
        if ((res = f.isDirectory() ? this.project.getFolder(dstPath) : this.project.getFile(dstPath)).exists()) {
            if (!res.isLinked()) {
                String msg = String.format("Specified resource [%s] already exists in the project [%s].", dstPath, this.project);
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
                return;
            }
            if (res.getRawLocation().equals((Object)dstPath)) {
                String msg = String.format("Specified link [%s] already exists in the project [%s].", dstPath, this.project);
                logger.log((IStatus)new Status(2, "com.vmware.vide.project", msg));
            } else {
                String msg = String.format("Specified link name [%s] exists with a different reference in the project [%s].", dstPath, this.project);
                logger.log((IStatus)new Status(4, "com.vmware.vide.project", msg));
            }
            return;
        }
        try {
            if (res instanceof IFolder) {
                res.createLink(locationPath, 0, null);
            } else {
                ((IFile)res).createLink(locationPath, 0, null);
            }
        }
        catch (CoreException e) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", null, (Throwable)e));
        }
    }

    Map<String, String> opProperty(String[] opArgs) {
        if (opArgs.length < 3) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.project", "Too few arguments."));
            return null;
        }
        if (opArgs.length % 2 == 0) {
            logger.log((IStatus)new Status(2, "com.vmware.vide.project", "Odd number of arguments. Ignoring the last one."));
        }
        HashMap<String, String> props = new HashMap<String, String>();
        int i = 1;
        while (i + 1 < opArgs.length) {
            props.put(opArgs[i], opArgs[i + 1]);
            i += 2;
        }
        return props;
    }

    static boolean isWorkbenchProjectOperation(String op) {
        return op.startsWith(WORKBENCH_PROJECT_OPERATION_PREFIX);
    }
}

