/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.utils;

import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.utils.resource.ResourceUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableOperator {
    private static final Logger logger = LoggerFactory.getLogger(VariableOperator.class);
    private static final String TO_LOWER = "toLower";
    private static final String TO_UPPER = "toUpper";
    private static final String TO_XML_ESCAPE = "toXmlEscape";
    private static final String TO_ENVIRONMENT = "toEnvironment";
    private static final String TO_ANT_PATH_PROPERTY = "toAntPathProperty";
    private static final String TO_JAVA_PACKAGE_FOLDER = "toJavaPackageFolder";
    private static final String TO_PLUGIN_DIRECTORY = "toPluginDirectory";
    private static final String TO_UNDERSCORE = "toUnderscore";
    private final String name;

    public VariableOperator(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String convert(String[] args) {
        return args[0];
    }

    static VariableOperator getNop() {
        return new VariableOperator("");
    }

    static List<VariableOperator> getVariableOperators() {
        VariableOperator op;
        ArrayList<VariableOperator> operators = new ArrayList<VariableOperator>();
        VariableOperator variableOperator = op = new VariableOperator("");
        variableOperator.getClass();
        operators.add(variableOperator.new ToXmlEscape(TO_XML_ESCAPE));
        VariableOperator variableOperator2 = op;
        variableOperator2.getClass();
        operators.add(variableOperator2.new ToLower(TO_LOWER));
        VariableOperator variableOperator3 = op;
        variableOperator3.getClass();
        operators.add(variableOperator3.new ToUpper(TO_UPPER));
        VariableOperator variableOperator4 = op;
        variableOperator4.getClass();
        operators.add(variableOperator4.new ToEnvironment(TO_ENVIRONMENT));
        VariableOperator variableOperator5 = op;
        variableOperator5.getClass();
        operators.add(variableOperator5.new ToAntPathProperty(TO_ANT_PATH_PROPERTY));
        VariableOperator variableOperator6 = op;
        variableOperator6.getClass();
        operators.add(variableOperator6.new ToJavaPackageFolder(TO_JAVA_PACKAGE_FOLDER));
        VariableOperator variableOperator7 = op;
        variableOperator7.getClass();
        operators.add(variableOperator7.new ToPluginDirectory(TO_PLUGIN_DIRECTORY));
        VariableOperator variableOperator8 = op;
        variableOperator8.getClass();
        operators.add(variableOperator8.new ToUnderscore(TO_UNDERSCORE));
        return operators;
    }

    class ToAntPathProperty
    extends VariableOperator {
        public ToAntPathProperty(String name) {
            super(name);
        }

        @Override
        public String convert(String[] args) {
            Path path = new Path(args[0]);
            StringBuilder sb = new StringBuilder();
            if (path.getDevice() != null) {
                String dev = path.getDevice();
                sb.append(dev.subSequence(0, dev.length() - 1));
                sb.append("\\:");
            }
            if (path.isAbsolute()) {
                sb.append('/');
            }
            if (path.segmentCount() > 0) {
                sb.append(path.segment(0));
                int i = 1;
                while (i < path.segmentCount()) {
                    sb.append('/');
                    sb.append(path.segment(i));
                    ++i;
                }
            }
            return sb.toString();
        }
    }

    class ToEnvironment
    extends VariableOperator {
        public ToEnvironment(String name) {
            super(name);
        }

        @Override
        public String convert(String[] args) {
            String val;
            String var = args[0];
            if (var.isEmpty()) {
                var = args[1];
            }
            if ((val = System.getenv(var)) == null) {
                val = args.length > 2 ? args[2] : "";
            }
            return val;
        }
    }

    class ToJavaPackageFolder
    extends VariableOperator {
        public ToJavaPackageFolder(String name) {
            super(name);
        }

        @Override
        public String convert(String[] args) {
            String packageName = args[0];
            return packageName.replace(".", "/");
        }
    }

    class ToLower
    extends VariableOperator {
        public ToLower(String name) {
            super(name);
        }

        @Override
        public String convert(String[] args) {
            return args[0].toLowerCase();
        }
    }

    class ToPluginDirectory
    extends VariableOperator {
        public ToPluginDirectory(String name) {
            super(name);
        }

        @Override
        public String convert(String[] args) {
            String bundleId = args[0];
            String projectDir = "";
            try {
                File bundleFile = ResourceUtils.getBundleFile((String)bundleId);
                projectDir = bundleFile.getAbsolutePath();
            }
            catch (IOException e) {
                logger.error("Unable to resolve project directory of bundle: {}", (Object)bundleId, (Object)e);
            }
            return projectDir;
        }
    }

    class ToUnderscore
    extends VariableOperator {
        public ToUnderscore(String name) {
            super(name);
        }

        @Override
        public String convert(String[] args) {
            String id = args[0];
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < id.length()) {
                if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                    sb.append('_');
                } else {
                    sb.append(id.charAt(i));
                }
                ++i;
            }
            return sb.toString();
        }
    }

    class ToUpper
    extends VariableOperator {
        public ToUpper(String name) {
            super(name);
        }

        @Override
        public String convert(String[] args) {
            return args[0].toUpperCase();
        }
    }

    class ToXmlEscape
    extends VariableOperator {
        public ToXmlEscape(String name) {
            super(name);
        }

        @Override
        public String convert(String[] args) {
            return Utils.replaceEscapeCharsForXML(args[0]);
        }
    }
}

