/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.vib;

import com.vmware.vide.project.vib.VIBFileInfo;
import com.vmware.vide.project.vib.VIBProperty;
import com.vmware.vide.project.vib.VIBPropertyChangedEvent;
import com.vmware.vide.project.vib.VIBPropertyListener;
import java.util.ArrayList;
import org.eclipse.core.commands.common.EventManager;

public class PropertyManager
extends EventManager {
    private VIBProperty[] allproperties = VIBProperty.createAllProperties(this);

    public VIBProperty[] getAllProperties() {
        return this.allproperties;
    }

    public void setInput(VIBFileInfo vibinfo) {
        if (vibinfo == null) {
            return;
        }
        VIBProperty[] vIBPropertyArray = this.allproperties;
        int n = this.allproperties.length;
        int n2 = 0;
        while (n2 < n) {
            VIBProperty vibproperty = vIBPropertyArray[n2];
            if (vibproperty.getRootNodeName().equals(vibinfo.getRootNodeName())) {
                vibproperty.setVIBInfo(vibinfo);
            }
            ++n2;
        }
    }

    public VIBProperty getProperty(String propertynodename) {
        VIBProperty[] vibproperties;
        VIBProperty[] vIBPropertyArray = vibproperties = this.allproperties;
        int n = vibproperties.length;
        int n2 = 0;
        while (n2 < n) {
            VIBProperty property = vIBPropertyArray[n2];
            if (property.getNodeNames().equals(propertynodename)) {
                return property;
            }
            ++n2;
        }
        return null;
    }

    public VIBProperty[] getHyperlinkProperties() {
        ArrayList<VIBProperty> vibproperties = new ArrayList<VIBProperty>();
        VIBProperty[] vIBPropertyArray = this.allproperties;
        int n = this.allproperties.length;
        int n2 = 0;
        while (n2 < n) {
            VIBProperty property = vIBPropertyArray[n2];
            if (property.isHyperlinkProperty()) {
                vibproperties.add(property);
            }
            ++n2;
        }
        return vibproperties.toArray(new VIBProperty[vibproperties.size()]);
    }

    public boolean hasTheRoot(String root) {
        VIBProperty[] vIBPropertyArray = this.allproperties;
        int n = this.allproperties.length;
        int n2 = 0;
        while (n2 < n) {
            VIBProperty property = vIBPropertyArray[n2];
            if (property.getRootNodeName().equals(root)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void addVIBPropertyListener(VIBPropertyListener listener) {
        this.addListenerObject(listener);
    }

    public void removeVIBPropertyListener(VIBPropertyListener listener) {
        this.removeListenerObject(listener);
    }

    public void fireVIBPropertyChanged(VIBProperty property) {
        Object[] objects;
        Object[] objectArray = objects = this.getListeners();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            VIBPropertyListener l = (VIBPropertyListener)o;
            l.changed(new VIBPropertyChangedEvent(property));
            ++n2;
        }
    }
}

