/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.importwizard;

import com.vmware.vide.project.config.wizard.project.ProjectData;
import com.vmware.vide.project.manager.ProjectManager;
import com.vmware.vide.project.utils.Utils;
import com.vmware.vide.project.utils.VIDEProjectException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ProjectImportWizardPage
extends WizardPage {
    private static final String DEFAULT_WIZARDPAGE_TITLE = "VMware Import Wizard Page";
    private static final String TEXT_SELECT_ROOTPATH = "Select root path: ";
    private static final String TEXT_BROWSE = "   Browse   ";
    private static final String TEXT_PROJLIST = "Project list:";
    private static final String TEXT_SELECT_ALL = "Select All";
    private static final String TEXT_DESELECT_ALL = "Deselect All";
    private static final String TEXT_REFRESH = "Refresh";
    private static final String DIALOG_OPEN_TITLE = "Select root directory of the projects to import";
    private static final String MSG_DESCRIPTION = "Select a directory to search for existing VMware projects";
    private static final String MSG_PROJECT_IN_WORKSPACE = "Some projects cannot be imported because they already exist in the workspace";
    private static final String MSG_NO_PROJECT = "No project is found to import";
    private static final String MSG_SEARCH = "Searching for projects";
    private static final String MSG_PROCESSING = "Processing results";
    private static final String MSG_CREATE_PROJECT = "Creating projects";
    protected ArrayList<IProject> createdProjects;
    protected Text directoryPathField;
    protected Button browseDirectoriesButton;
    protected CheckboxTreeViewer projectsList;
    protected String previouslyBrowsedDirectory;
    private String lastPath;
    private long lastModified;
    private ProjectData projectdata;
    protected ProjectRecord[] selectedProjects;

    protected ProjectImportWizardPage(String name, String title, String description) {
        super(name);
        this.setTitle(title);
        this.setDescription(description);
        this.projectdata = null;
        this.selectedProjects = new ProjectRecord[0];
    }

    protected ProjectImportWizardPage() {
        this(DEFAULT_WIZARDPAGE_TITLE, DEFAULT_WIZARDPAGE_TITLE, MSG_DESCRIPTION);
    }

    protected ProjectImportWizardPage(String name) {
        this(name, DEFAULT_WIZARDPAGE_TITLE, MSG_DESCRIPTION);
    }

    private boolean getProjectFile(Hashtable<File, File> files, File directory, Map<String, String> props) {
        if (directory == null || !directory.isDirectory() || this.projectdata == null) {
            return false;
        }
        File file = this.projectdata.getProjectFile(directory, props);
        if (file != null) {
            files.put(directory, file);
            return true;
        }
        return false;
    }

    public boolean performCancel() {
        return true;
    }

    public void setProjectData(ProjectData data) {
        this.projectdata = data;
        if (this.projectdata != null && this.projectdata.isValid()) {
            this.setTitle(this.projectdata.getTitle());
            this.setDescription(this.projectdata.getDescription());
            String dir = data.getInitPath();
            if (dir != null) {
                dir = Utils.replaceContent(dir, data.getPropertyValues(null));
            }
            this.setInitBrowseDirectory(dir);
            this.updateProjectsList(dir);
            this.directoryPathField.redraw();
            this.projectsList.refresh();
        }
    }

    public void setInitBrowseDirectory(String path) {
        this.previouslyBrowsedDirectory = path;
        if (this.directoryPathField != null) {
            this.directoryPathField.setText(this.previouslyBrowsedDirectory);
        }
    }

    public void createControl(Composite parent) {
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectFromDirectoryRadio = new Label(projectGroup, 0);
        projectFromDirectoryRadio.setText(TEXT_SELECT_ROOTPATH);
        this.directoryPathField = new Text(projectGroup, 2048);
        if (this.previouslyBrowsedDirectory != null) {
            this.directoryPathField.setText(this.previouslyBrowsedDirectory);
        }
        this.directoryPathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(TEXT_BROWSE);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPage.this.handleLocationDirectoryButtonPressed();
            }
        });
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(TEXT_PROJLIST);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        this.projectsList.getControl().setLayoutData((Object)new GridData(1808));
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return ProjectImportWizardPage.this.getProjectRecords();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectRecord element = (ProjectRecord)event.getElement();
                if (element.hasConflicts) {
                    ProjectImportWizardPage.this.projectsList.setChecked((Object)element, false);
                }
                ProjectImportWizardPage.this.setPageComplete(ProjectImportWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 128, false, true));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(TEXT_SELECT_ALL);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < ProjectImportWizardPage.this.selectedProjects.length) {
                    if (ProjectImportWizardPage.this.selectedProjects[i].hasConflicts) {
                        ProjectImportWizardPage.this.projectsList.setChecked((Object)ProjectImportWizardPage.this.selectedProjects[i], false);
                    } else {
                        ProjectImportWizardPage.this.projectsList.setChecked((Object)ProjectImportWizardPage.this.selectedProjects[i], true);
                    }
                    ++i;
                }
                ProjectImportWizardPage.this.setPageComplete(ProjectImportWizardPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(TEXT_DESELECT_ALL);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPage.this.projectsList.setCheckedElements(new Object[0]);
                ProjectImportWizardPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(TEXT_REFRESH);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectImportWizardPage.this.updateProjectsList(ProjectImportWizardPage.this.directoryPathField.getText().trim());
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell());
        dialog.setMessage(DIALOG_OPEN_TITLE);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0 && this.previouslyBrowsedDirectory != null) {
            dirName = this.previouslyBrowsedDirectory;
        }
        if (dirName == null || dirName.length() == 0) {
            dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(this.previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    public void updateProjectsList(String path) {
        if (path == null || path.length() == 0) {
            this.setMessage("project description");
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        final File directory = new File(path);
        long modified = directory.lastModified();
        if (path.equals(this.lastPath) && this.lastModified == modified) {
            return;
        }
        this.lastPath = path;
        this.lastModified = modified;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(ProjectImportWizardPage.MSG_SEARCH, 100);
                    ProjectImportWizardPage.this.selectedProjects = new ProjectRecord[0];
                    Hashtable projectfiles = new Hashtable();
                    monitor.worked(10);
                    if (directory.isDirectory()) {
                        try {
                            Map<Object, Object> props = new HashMap();
                            if (ProjectImportWizardPage.this.projectdata != null && ProjectImportWizardPage.this.projectdata.hasValidators()) {
                                props = ProjectImportWizardPage.this.projectdata.getPropertyValues(null);
                            }
                            if (!ProjectImportWizardPage.this.collectProjectFilesFromDirectory(projectfiles, directory, null, props, monitor)) {
                                return;
                            }
                            monitor.worked(50);
                            monitor.subTask(ProjectImportWizardPage.MSG_PROCESSING);
                            ProjectImportWizardPage.this.selectedProjects = new ProjectRecord[projectfiles.size()];
                            int index = 0;
                            Enumeration e = projectfiles.keys();
                            while (e.hasMoreElements()) {
                                File projectdir = (File)e.nextElement();
                                ProjectImportWizardPage.this.selectedProjects[index] = new ProjectRecord(projectdir, (File)projectfiles.get(projectdir));
                                ++index;
                            }
                        }
                        catch (Exception e) {
                            Utils.openDialog(Utils.createImportWizardException("Failed to search projects " + directory.toString(), e));
                        }
                    } else {
                        monitor.worked(60);
                    }
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            Utils.openDialog(Utils.createImportWizardException("Failed to search projects " + directory.toString(), e));
        }
        this.projectsList.refresh(true);
        ProjectRecord[] projects = this.getProjectRecords();
        boolean displayWarning = false;
        int i = 0;
        while (i < projects.length) {
            if (projects[i].hasConflicts) {
                displayWarning = true;
                this.projectsList.setGrayed((Object)projects[i], true);
            } else {
                this.projectsList.setChecked((Object)projects[i], true);
            }
            ++i;
        }
        if (displayWarning) {
            this.setMessage(MSG_PROJECT_IN_WORKSPACE, 2);
        } else {
            this.setMessage(MSG_DESCRIPTION);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(MSG_NO_PROJECT, 2);
        }
    }

    private boolean collectProjectFilesFromDirectory(Hashtable<File, File> files, File directory, Set<String> directoriesVisited, Map<String, String> props, IProgressMonitor monitor) throws VIDEProjectException {
        if (monitor.isCanceled()) {
            return false;
        }
        File[] contents = directory.listFiles();
        if (contents == null || contents.length == 0) {
            return false;
        }
        if (!this.projectdata.isValidProjectPath(directory.getAbsolutePath())) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException e) {
                throw Utils.createImportWizardException("Failed to search projects ", e);
            }
        }
        if (this.isImportable(directory) && this.getProjectFile(files, directory, props)) {
            return true;
        }
        int i = 0;
        while (i < contents.length) {
            block12: {
                if (contents[i].isDirectory()) {
                    block11: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block11;
                            break block12;
                        }
                        catch (IOException e) {
                            throw Utils.createImportWizardException("Failed to search projects ", e);
                        }
                    }
                    this.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited, props, monitor);
                }
            }
            ++i;
        }
        return true;
    }

    public ProjectRecord[] getProjectRecords() {
        ArrayList<ProjectRecord> projectRecords = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            if (ProjectData.isProjectInWorkspace(this.selectedProjects[i].getProjectName())) {
                this.selectedProjects[i].hasConflicts = true;
            }
            projectRecords.add(this.selectedProjects[i]);
            ++i;
        }
        return projectRecords.toArray(new ProjectRecord[projectRecords.size()]);
    }

    private boolean isImportable(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().equals(".project") && f.isFile();
            }
        });
        return files.length == 0;
    }

    public boolean createProjects() {
        final Object[] selected = this.projectsList.getCheckedElements();
        this.createdProjects = new ArrayList();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask("", selected.length);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        int i = 0;
                        while (i < selected.length) {
                            ProjectImportWizardPage.this.createExistingProject((ProjectRecord)selected[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof VIDEProjectException) {
                            Utils.openDialog((VIDEProjectException)e);
                        } else {
                            Utils.openDialog(Utils.createImportWizardException("Failed to create the project ", e));
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Utils.openDialog(Utils.createImportWizardException("Failed to create the project ", e));
            return false;
        }
        return true;
    }

    private boolean createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, VIDEProjectException {
        try {
            try {
                monitor.beginTask(MSG_CREATE_PROJECT, 100);
                IProject project = this.projectdata.createIProject(record.projectname, record.getProjectDirectory().getAbsolutePath(), (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                if (project != null) {
                    this.projectdata.configureProject(project, record.getProjectFile(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    this.projectdata.addAdditionalProjectNatures(project);
                    this.createdProjects.add(project);
                    ProjectManager.putProjectProperty(project, "PROJECT_CREATION_TYPE", "import", false);
                    project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                }
            }
            catch (Exception e) {
                throw Utils.createImportWizardException(MSG_CREATE_PROJECT, e);
            }
        }
        finally {
            this.projectdata.cleanConfiguratorProperties();
            monitor.done();
        }
        return true;
    }

    private final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ProjectRecord) {
                return ((ProjectRecord)element).getProjectLabel();
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof ProjectRecord) {
                ProjectRecord projectRecord = (ProjectRecord)element;
                if (projectRecord.hasConflicts) {
                    return ProjectImportWizardPage.this.getShell().getDisplay().getSystemColor(15);
                }
            }
            return null;
        }
    }

    public class ProjectRecord {
        File projectdir;
        File projectfile;
        String projectname;
        Object parent;
        int level;
        boolean hasConflicts;
        IProjectDescription description;
        IProject project;

        ProjectRecord(File directory, File file) {
            this.projectdir = directory;
            this.projectfile = file;
            this.setProjectName();
            this.project = null;
        }

        private void setProjectName() {
            this.projectname = "unknown";
            if (this.projectdir != null) {
                this.projectname = this.projectdir.getName();
            } else if (this.projectfile != null) {
                int index = this.projectfile.getName().indexOf(".");
                this.projectname = index != -1 ? this.projectfile.getName().substring(0, index) : this.projectfile.getName();
            }
        }

        public File getProjectFile() {
            return this.projectfile;
        }

        public String getProjectName() {
            return this.projectname;
        }

        public String getProjectLabel() {
            return this.projectdir.getAbsolutePath();
        }

        public boolean hasConflicts() {
            return this.hasConflicts;
        }

        public File getProjectDirectory() {
            return this.projectdir;
        }
    }
}

