/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.project.wizard.vibwizard;

import com.vmware.vide.project.config.vib.VIBData;
import com.vmware.vide.project.utils.VIDEProjectException;
import com.vmware.vide.project.wizard.vibwizard.VIBInfoWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class GenerateVIBFileWizard
extends Wizard
implements INewWizard {
    private static final String WIZARD_TITLE = "VIB File Generation";
    private VIBData curvibdata;
    private IProject curproject;

    public GenerateVIBFileWizard(VIBData vibdata, IProject project) {
        this.setWindowTitle(WIZARD_TITLE);
        this.curvibdata = vibdata;
        this.curproject = project;
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new VIBInfoWizardPage(this.curvibdata, this.curproject));
    }

    public boolean performFinish() {
        if (this.curvibdata != null && this.curproject != null) {
            try {
                this.curvibdata.createVIBFiles(this.curproject);
                this.curvibdata.saveVIBData(this.curproject);
                return true;
            }
            catch (VIDEProjectException e) {
                System.out.println(e.getMessage());
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(WIZARD_TITLE);
    }
}

