/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.FileDeployExportData;
import com.vmware.vide.deploy.FileDeployOperationData;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;

public class AutoDeployOperationData
extends FileDeployOperationData {
    private String preCommands;
    private String postCommands;

    public AutoDeployOperationData(String name, ArrayList<IResource> resources, String targetDestination, String targetType, boolean createEntireDirs, String preCommands, String postCommands) {
        super(name, resources, targetDestination, targetType, createEntireDirs);
        this.preCommands = preCommands;
        this.postCommands = postCommands;
    }

    public AutoDeployOperationData(String name, ArrayList<IResource> resources, String targetDestination, String targetType, boolean createEntireDirs) {
        this(name, resources, targetDestination, targetType, createEntireDirs, "", "");
    }

    public AutoDeployOperationData(AutoDeployOperationData data) {
        this(data.getName(), data.getResources(), data.getTargetDestination(), data.getTargetType(), data.getCreateEntireDirs(), data.getPreCommands(), data.getPostCommands());
    }

    public AutoDeployOperationData(FileDeployOperationData data) {
        this(data.getName(), data.getResources(), data.getTargetDestination(), data.getTargetType(), data.getCreateEntireDirs());
    }

    public AutoDeployOperationData(FileDeployExportData data) {
        this(data.getName(), (ArrayList)data.getResources(), data.getTargetDestination(), data.getTargetType(), data.getCreateEntireDirsOption());
    }

    public void setAllData(AutoDeployOperationData data) {
        this.setName(data.getName());
        this.setResources(data.getResources());
        this.setTargetDestination(data.getTargetDestination());
        this.setTargetType(data.getTargetType());
        this.setCreateEntireDirs(data.getCreateEntireDirs());
        this.setPreCommands(data.getPreCommands());
        this.setPostCommands(data.getPostCommands());
    }

    public String getPreCommands() {
        return this.preCommands;
    }

    public String getPostCommands() {
        return this.postCommands;
    }

    public void setPreCommands(String commands) {
        this.preCommands = commands;
    }

    public void setPostCommands(String commands) {
        this.postCommands = commands;
    }

    @Override
    public String getInformationText() {
        StringBuffer info = new StringBuffer(super.getInformationText());
        if (this.getPreCommands() != null && !this.getPreCommands().trim().isEmpty()) {
            info.append("Pre-deploy commands: \n    " + this.formCommands(this.getPreCommands()));
        }
        if (this.getPostCommands() != null && !this.getPostCommands().trim().isEmpty()) {
            if (info.charAt(info.length() - 1) != '\n') {
                info.append("\n");
            }
            info.append("Post-deploy commands: \n    " + this.formCommands(this.getPostCommands()));
        }
        return info.toString();
    }

    private String formCommands(String commandsText) {
        return commandsText.replaceAll("\n", "\n    ").trim();
    }
}

