/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;

public class FileDeployOperationData {
    public static final String DEFAULT_TARGET_TYPE = "esx";
    private ArrayList<IResource> resources;
    private String targetDestination;
    private String targetType;
    private boolean createEntireDirs;
    private String name;

    public FileDeployOperationData(String name, ArrayList<IResource> resources, String targetDestination, String targetType, boolean createEntireDirs) {
        this.name = name;
        this.resources = resources;
        this.targetDestination = targetDestination;
        this.targetType = targetType == null ? DEFAULT_TARGET_TYPE : targetType;
        this.createEntireDirs = createEntireDirs;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<IResource> getResources() {
        return this.resources;
    }

    public String getTargetDestination() {
        return this.targetDestination;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public boolean getCreateEntireDirs() {
        return this.createEntireDirs;
    }

    public String getInformationText() {
        StringBuffer buf = new StringBuffer();
        buf.append("Deploy operation: " + this.getName() + "\n");
        buf.append("Target destination: " + this.getTargetDestination() + "\n");
        buf.append("Resources: \n");
        ArrayList<IResource> resources = this.getResources();
        for (IResource r : resources) {
            buf.append("    " + r.getFullPath().toString() + "\n");
        }
        return buf.toString();
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setTargetDestination(String dest) {
        this.targetDestination = dest;
    }

    protected void setTargetType(String type) {
        this.targetType = type;
    }

    protected void setResources(ArrayList<IResource> resources) {
        this.resources = resources;
    }

    protected void setCreateEntireDirs(boolean option) {
        this.createEntireDirs = option;
    }
}

