/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.deploy;

import com.vmware.vide.deploy.FileDeployExportData;
import com.vmware.vide.deploy.FileDeployExportOperation;
import com.vmware.vide.deploy.FileDeployOperationsDatabase;
import com.vmware.vide.deploy.FileDeployUtilities;
import com.vmware.vide.deploy.WizardExportResourcesPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.actions.SystemSelectRemoteFolderAction;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class WizardDeployFileExportPage1
extends WizardExportResourcesPage
implements Listener {
    private static final String STORE_DESTINATION_NAMES_ID = "WizardDeployFileExportPage1.STORE_DESTINATION_NAMES_ID";
    private static final String STORE_CREATE_STRUCTURE_ID = "WizardDeployFileExportPage1.STORE_CREATE_STRUCTURE_ID";
    private static final String FILE_DEPLOY_EXPORT_WIZARD_PAGE1_TITLE = "File Deploy";
    private static final String FILE_DEPLOY_EXPORT_WIZARD_PAGE1_DESCRIPTION = "Exports local files to deploy a remote target.";
    private static final String THIS_PAGE_NAME = "fileDeployExportPage1";
    public static final String NAME_TARGET_LOCCATION = "combo_targetLocation";
    public static final String NAME_OPERATIONS = "combo_operations";
    public static final String SAVE_BUTTON_LABEL = " Save:";
    public static final String RESTORE_BUTTON_LABEL = "Restore";
    private IStructuredSelection initialResourceSelection;
    private Combo destinationNameField;
    private Button destinationBrowseButton;
    protected Button createDirectoryStructureButton;
    protected Button createSelectionOnlyButton;
    private Button saveToButton;
    private Button restoreButton;
    private Combo operationsCombo;
    private List<String> operationItems = new ArrayList<String>();

    public WizardDeployFileExportPage1(IStructuredSelection selection) {
        super(THIS_PAGE_NAME, selection);
        this.initialResourceSelection = selection;
        this.setTitle(FILE_DEPLOY_EXPORT_WIZARD_PAGE1_TITLE);
        this.setDescription(FILE_DEPLOY_EXPORT_WIZARD_PAGE1_DESCRIPTION);
    }

    @Override
    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createResourcesGroup(composite);
        this.createButtonsGroup(composite);
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.createOperationsGroup(composite);
        this.restoreResourceSpecificationWidgetValues();
        this.restoreWidgetValues();
        if (this.initialResourceSelection != null) {
            this.setupBasedOnInitialSelections();
        }
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
        this.giveFocusToDestination();
    }

    @Override
    protected void setupBasedOnInitialSelections() {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        for (IResource res : this.initialResourceSelection) {
            if (res.getType() != 1 && res.getType() != 2) continue;
            resources.add(res);
        }
        this.setInitialResources(resources);
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
        Font font = optionsGroup.getFont();
        this.createDirectoryStructureButton = new Button((Composite)optionsGroup, 16400);
        this.createDirectoryStructureButton.setText(DataTransferMessages.FileExport_createDirectoryStructure);
        this.createDirectoryStructureButton.setSelection(false);
        this.createDirectoryStructureButton.setFont(font);
        this.createSelectionOnlyButton = new Button((Composite)optionsGroup, 16400);
        this.createSelectionOnlyButton.setText(DataTransferMessages.FileExport_createSelectedDirectories);
        this.createSelectionOnlyButton.setSelection(true);
        this.createSelectionOnlyButton.setFont(font);
    }

    private void createOperationsGroup(Composite parent) {
        Group operationsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        operationsGroup.setLayout((Layout)layout);
        operationsGroup.setLayoutData((Object)new GridData(768));
        operationsGroup.setText("Save/restore deploy operation");
        operationsGroup.setFont(parent.getFont());
        Composite operationsComposite = new Composite((Composite)operationsGroup, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 3;
        operationsComposite.setLayout((Layout)groupLayout);
        operationsComposite.setLayoutData((Object)new GridData(1808));
        this.saveToButton = new Button(operationsComposite, 8);
        this.saveToButton.setText(SAVE_BUTTON_LABEL);
        this.saveToButton.addListener(13, (Listener)this);
        this.saveToButton.setEnabled(false);
        this.restoreButton = new Button(operationsComposite, 8);
        this.restoreButton.setText(RESTORE_BUTTON_LABEL);
        this.restoreButton.addListener(13, (Listener)this);
        this.restoreButton.setEnabled(false);
        this.operationsCombo = new Combo(operationsComposite, 4);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.operationsCombo.setLayoutData((Object)data);
        this.operationsCombo.setItems(this.operationItems.toArray(new String[this.operationItems.size()]));
        this.operationsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (WizardDeployFileExportPage1.this.operationsCombo.getText().trim().isEmpty()) {
                    WizardDeployFileExportPage1.this.saveToButton.setEnabled(false);
                    WizardDeployFileExportPage1.this.restoreButton.setEnabled(false);
                } else {
                    WizardDeployFileExportPage1.this.saveToButton.setEnabled(true);
                    WizardDeployFileExportPage1.this.restoreButton.setEnabled(true);
                }
            }
        });
        this.operationsCombo.setData("name", (Object)NAME_OPERATIONS);
        this.setOperationItems();
    }

    private void setOperationItems() {
        String[] operationNames = FileDeployOperationsDatabase.getOperationNames();
        this.operationsCombo.setItems(operationNames);
    }

    private boolean ensureDirectoryExists(File directory, String folderName) {
        File result;
        if (!(directory.exists() || (result = FileDeployUtilities.getFolderOrCreateFullPath(folderName)) != null && result.exists())) {
            String msg = "Failed to create target directory: " + folderName;
            this.setErrorMessage(msg);
            this.giveFocusToDestination();
            return false;
        }
        return true;
    }

    protected boolean ensureTargetIsValid(File targetDirectory, String folderName) {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            String msg = "Invalid target directory :" + folderName;
            this.setErrorMessage(msg);
            this.giveFocusToDestination();
            return false;
        }
        return this.ensureDirectoryExists(targetDirectory, folderName);
    }

    protected boolean executeExportOperation(FileDeployExportOperation op) {
        op.setCreateLeadupStructure(this.createDirectoryStructureButton.getSelection());
        op.setOverwriteFiles(true);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.DataTransfer_exportProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    @Override
    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(STORE_DESTINATION_NAMES_ID, directoryNames);
            settings.put(STORE_CREATE_STRUCTURE_ID, this.createDirectoryStructureButton.getSelection());
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(STORE_DESTINATION_NAMES_ID);
            if (directoryNames == null) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
            boolean createDirectories = settings.getBoolean(STORE_CREATE_STRUCTURE_ID);
            this.createDirectoryStructureButton.setSelection(createDirectories);
            this.createSelectionOnlyButton.setSelection(!createDirectories);
        }
    }

    @Override
    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(272));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText("Target Location: ");
        destinationLabel.setFont(font);
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.setFont(font);
        this.destinationNameField.setData("name", (Object)NAME_TARGET_LOCCATION);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.destinationBrowseButton);
        new Label(parent, 0);
    }

    private void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    private String getDestinationValue() {
        return this.destinationNameField.getText().trim();
    }

    private void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    private void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        } else if (source == this.saveToButton) {
            this.saveConfiguration();
        } else if (source == this.restoreButton) {
            this.loadConfiguration();
        }
        this.updatePageCompletion();
    }

    private void loadConfiguration() {
        FileDeployExportData exportConfigData = new FileDeployExportData();
        try {
            exportConfigData.restore(this.operationsCombo.getText().trim());
            this.createDirectoryStructureButton.setSelection(exportConfigData.getCreateEntireDirsOption());
            this.createSelectionOnlyButton.setSelection(!exportConfigData.getCreateEntireDirsOption());
            this.destinationNameField.setText(exportConfigData.getTargetDestination());
            List<FileDeployExportData.RestoredResource> resources = exportConfigData.getRestoredResources();
            ArrayList<IResource> newResources = new ArrayList<IResource>();
            for (FileDeployExportData.RestoredResource r : resources) {
                IWorkspace w;
                Path path;
                if (r.getType() == "file") {
                    path = new Path(r.getResource());
                    w = ResourcesPlugin.getWorkspace();
                    IFile iFile = w.getRoot().getFile((IPath)path);
                    if (iFile == null) continue;
                    newResources.add((IResource)iFile);
                    continue;
                }
                if (r.getType() == "folder") {
                    path = new Path(r.getResource());
                    w = ResourcesPlugin.getWorkspace();
                    IFolder iFolder = w.getRoot().getFolder((IPath)path);
                    if (iFolder == null) continue;
                    newResources.add((IResource)iFolder);
                    continue;
                }
                if (r.getType() != "project") continue;
                path = new Path(r.getResource());
                w = ResourcesPlugin.getWorkspace();
                IProject iProject = w.getRoot().getProject(path.lastSegment());
                if (iProject == null) continue;
                newResources.add((IResource)iProject);
            }
            this.setAllSelections(false);
            this.setInitialResources(newResources);
        }
        catch (Exception exception) {
            System.err.println("Failed to load the configuration");
        }
    }

    private void saveConfiguration() {
        List<IResource> resourcesToExport = this.getWhiteCheckedResources();
        FileDeployExportData exportConfigData = new FileDeployExportData(resourcesToExport, this.getDestinationValue(), this.getDestinationTargetType(), this.createDirectoryStructureButton.getSelection());
        try {
            String operation = this.operationsCombo.getText().trim();
            exportConfigData.save(operation);
            if (this.operationsCombo.indexOf(operation) == -1) {
                this.operationsCombo.add(operation);
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to save the configuration");
        }
    }

    protected void handleDestinationBrowseButtonPressed() {
        SystemSelectRemoteFolderAction action = new SystemSelectRemoteFolderAction(this.getShell());
        action.setShowNewConnectionPrompt(true);
        action.setFoldersOnly(true);
        action.setShowPropertySheet(true, false);
        String destValue = this.getDestinationValue();
        if (destValue != null) {
            IHost host = Utilities.parseForSystemConnection((String)destValue);
            IRemoteFile path = Utilities.parseForIRemoteFile((String)destValue);
            action.setDefaultConnection(host);
            action.setPreSelection(path);
        }
        action.run();
        IRemoteFile folder = action.getSelectedFolder();
        if (folder != null) {
            UniFilePlus destinationFolder = new UniFilePlus(folder);
            destValue = FileDeployUtilities.getTargetFolderName(destinationFolder);
            this.setDestinationValue(destValue);
        }
    }

    public boolean finish() {
        boolean ret = false;
        String dstName = this.getDestinationValue();
        if (dstName.isEmpty()) {
            return ret;
        }
        this.setDestinationValue(dstName);
        if (!FileDeployUtilities.isValidTarget(dstName) && !FileDeployUtilities.createTarget(dstName, this.getDestinationTargetType())) {
            String msg = "Cannot create the new target: " + dstName;
            this.setErrorMessage(msg);
            return ret;
        }
        File dstFolder = FileDeployUtilities.getFolder(this.getDestinationValue());
        if (dstFolder == null || !this.ensureTargetIsValid(dstFolder, dstName)) {
            String msg = "Cannot access the target folder: " + dstName;
            this.setErrorMessage(msg);
            return false;
        }
        List<IResource> resourcesToExport = this.getWhiteCheckedResources();
        this.saveWidgetValues();
        if (resourcesToExport.size() > 0) {
            FileDeployExportOperation op = new FileDeployExportOperation(null, resourcesToExport, this.getDestinationValue(), (IOverwriteQuery)this);
            ret = this.executeExportOperation(op);
            return ret;
        }
        String msg = "Error during file deploy...";
        this.setErrorMessage(msg);
        return false;
    }

    protected boolean validateDestinationGroup() {
        String destination = this.getDestinationValue();
        return !destination.isEmpty();
    }

    protected boolean validateSourceGroup() {
        return !this.getWhiteCheckedResources().isEmpty();
    }

    private String getDestinationTargetType() {
        return FileDeployUtilities.getDestinationTargetType(this.getShell(), this.getDestinationValue(), new FileDeployOperationsDatabase().getAllFileDeployExportDataReaders());
    }
}

